
##############################################################################
#
# Copyright (c) 2003-2017 by The University of Queensland
# http://www.uq.edu.au
#
# Primary Business: Queensland, Australia
# Licensed under the Apache License, version 2.0
# http://www.apache.org/licenses/LICENSE-2.0
#
# Development until 2012 by Earth Systems Science Computational Center (ESSCC)
# Development 2012-2013 by School of Earth Sciences
# Development from 2014 by Centre for Geoscience Computing (GeoComp)
#
##############################################################################

from __future__ import print_function, division

__copyright__="""Copyright (c) 2003-2017 by The University of Queensland
http://www.uq.edu.au
Primary Business: Queensland, Australia"""
__license__="""Licensed under the Apache License, version 2.0
http://www.apache.org/licenses/LICENSE-2.0"""
__url__="https://launchpad.net/escript-finley"

"""
test for util operations for slicing operations with tagged data

:remark: use see `test_util`
:var __author__: name of author
:var __copyright__: copyrights
:var __license__: licence agreement
:var __url__: url entry point on documentation
:var __version__: version
:var __date__: date of the version
"""

__author__="Lutz Gross, l.gross@uq.edu.au"

import esys.escriptcore.utestselect as unittest
import numpy
from esys.escript import *
from test_util_base import Test_util_base

class Test_util_slicing_with_tagged_data(Test_util_base):
   """
   test for slicing operations for tagged data are tested.
   """
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank1_U(self):
      arg=Data(numpy.array([0.0, 1.0, 2.0]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([-0.0, -1.0, -2.0]))
      res=arg[:2]
      ref=Data(numpy.array([0.0, 1.0]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-0.0, -1.0]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank1_L(self):
      arg=Data(numpy.array([0.0, 1.0, 2.0]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([-0.0, -1.0, -2.0]))
      res=arg[2:]
      ref=Data(numpy.array([2.0]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-2.0]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank1_R(self):
      arg=Data(numpy.array([0.0, 1.0, 2.0]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([-0.0, -1.0, -2.0]))
      res=arg[1:2]
      ref=Data(numpy.array([1.0]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-1.0]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank1_P(self):
      arg=Data(numpy.array([0.0, 1.0, 2.0]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([-0.0, -1.0, -2.0]))
      res=arg[1]
      ref=Data(1.0,self.functionspace)
      ref.setTaggedValue(1,-1.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank1_C(self):
      arg=Data(numpy.array([0.0, 1.0, 2.0]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([-0.0, -1.0, -2.0]))
      res=arg[:]
      ref=Data(numpy.array([0.0, 1.0, 2.0]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-0.0, -1.0, -2.0]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank2_CP(self):
      arg=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      res=arg[:,2]
      ref=Data(numpy.array([2.0, 6.0, 10.0]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-2.0, -6.0, -10.0]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank2_CU(self):
      arg=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      res=arg[:,:3]
      ref=Data(numpy.array([[0.0, 1.0, 2.0], [4.0, 5.0, 6.0], [8.0, 9.0, 10.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0], [-4.0, -5.0, -6.0], [-8.0, -9.0, -10.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank2_UR(self):
      arg=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      res=arg[:2,1:3]
      ref=Data(numpy.array([[1.0, 2.0], [5.0, 6.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-1.0, -2.0], [-5.0, -6.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank2_RR(self):
      arg=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      res=arg[1:2,1:3]
      ref=Data(numpy.array([[5.0, 6.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-5.0, -6.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank2_PU(self):
      arg=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      res=arg[1,:3]
      ref=Data(numpy.array([4.0, 5.0, 6.0]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-4.0, -5.0, -6.0]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank2_UL(self):
      arg=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      res=arg[:2,2:]
      ref=Data(numpy.array([[2.0, 3.0], [6.0, 7.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-2.0, -3.0], [-6.0, -7.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank2_CL(self):
      arg=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      res=arg[:,2:]
      ref=Data(numpy.array([[2.0, 3.0], [6.0, 7.0], [10.0, 11.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-2.0, -3.0], [-6.0, -7.0], [-10.0, -11.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank2_LP(self):
      arg=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      res=arg[2:,2]
      ref=Data(numpy.array([10.0]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-10.0]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank2_LR(self):
      arg=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      res=arg[2:,1:3]
      ref=Data(numpy.array([[9.0, 10.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-9.0, -10.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank2_UN(self):
      arg=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      res=arg[:2]
      ref=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank2_UU(self):
      arg=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      res=arg[:2,:3]
      ref=Data(numpy.array([[0.0, 1.0, 2.0], [4.0, 5.0, 6.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0], [-4.0, -5.0, -6.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank2_RP(self):
      arg=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      res=arg[1:2,2]
      ref=Data(numpy.array([6.0]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-6.0]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank2_CC(self):
      arg=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      res=arg[:,:]
      ref=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank2_RC(self):
      arg=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      res=arg[1:2,:]
      ref=Data(numpy.array([[4.0, 5.0, 6.0, 7.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-4.0, -5.0, -6.0, -7.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank2_LL(self):
      arg=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      res=arg[2:,2:]
      ref=Data(numpy.array([[10.0, 11.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-10.0, -11.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank2_RN(self):
      arg=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      res=arg[1:2]
      ref=Data(numpy.array([[4.0, 5.0, 6.0, 7.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-4.0, -5.0, -6.0, -7.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank2_CN(self):
      arg=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      res=arg[:]
      ref=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank2_PN(self):
      arg=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      res=arg[1]
      ref=Data(numpy.array([4.0, 5.0, 6.0, 7.0]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-4.0, -5.0, -6.0, -7.0]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank2_PP(self):
      arg=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      res=arg[1,2]
      ref=Data(6.0,self.functionspace)
      ref.setTaggedValue(1,-6.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank2_LN(self):
      arg=Data(numpy.array([[0.0, 1.0, 2.0, 3.0], [4.0, 5.0, 6.0, 7.0], [8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[-0.0, -1.0, -2.0, -3.0], [-4.0, -5.0, -6.0, -7.0], [-8.0, -9.0, -10.0, -11.0]]))
      res=arg[2:]
      ref=Data(numpy.array([[8.0, 9.0, 10.0, 11.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-8.0, -9.0, -10.0, -11.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_URP(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:2,1:3,1]
      ref=Data(numpy.array([[4.0, 7.0], [16.0, 19.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-4.0, -7.0], [-16.0, -19.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_LCN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[2:,:]
      ref=Data(numpy.array([[[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-24.0, -25.0, -26.0], [-27.0, -28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, 
-35.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_LCR(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[2:,:,1:2]
      ref=Data(numpy.array([[[25.0], [28.0], [31.0], [34.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-25.0], [-28.0], [-31.0], [-34.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 4, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_URU(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:2,1:3,:2]
      ref=Data(numpy.array([[[3.0, 4.0], [6.0, 7.0]], [[15.0, 16.0], [18.0, 19.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-3.0, -4.0], [-6.0, -7.0]], [[-15.0, -16.0], [-18.0, -19.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_RCR(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1:2,:,1:2]
      ref=Data(numpy.array([[[13.0], [16.0], [19.0], [22.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-13.0], [-16.0], [-19.0], [-22.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 4, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_UCP(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:2,:,1]
      ref=Data(numpy.array([[1.0, 4.0, 7.0, 10.0], [13.0, 16.0, 19.0, 22.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-1.0, -4.0, -7.0, -10.0], [-13.0, -16.0, -19.0, -22.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_LLN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[2:,2:]
      ref=Data(numpy.array([[[30.0, 31.0, 32.0], [33.0, 34.0, 35.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_RPP(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1:2,2,1]
      ref=Data(numpy.array([19.0]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-19.0]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_LPL(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[2:,2,2:]
      ref=Data(numpy.array([[32.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-32.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_CCR(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:,:,1:2]
      ref=Data(numpy.array([[[1.0], [4.0], [7.0], [10.0]], [[13.0], [16.0], [19.0], [22.0]], [[25.0], [28.0], [31.0], 
[34.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-1.0], [-4.0], [-7.0], [-10.0]], [[-13.0], [-16.0], [-19.0], [-22.0]], [[-25.0], 
[-28.0], [-31.0], [-34.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 4, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_LUL(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[2:,:3,2:]
      ref=Data(numpy.array([[[26.0], [29.0], [32.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-26.0], [-29.0], [-32.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 3, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_PPU(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1,2,:2]
      ref=Data(numpy.array([18.0, 19.0]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-18.0, -19.0]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_LCP(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[2:,:,1]
      ref=Data(numpy.array([[25.0, 28.0, 31.0, 34.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-25.0, -28.0, -31.0, -34.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_RUR(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1:2,:3,1:2]
      ref=Data(numpy.array([[[13.0], [16.0], [19.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-13.0], [-16.0], [-19.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 3, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_CUC(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:,:3,:]
      ref=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0]], [[12.0, 13.0, 14.0], [15.0, 16.0, 17.0], 
[18.0, 19.0, 20.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0]], [[-12.0, -13.0, -14.0], 
[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0]], [[-24.0, -25.0, -26.0], [-27.0, -28.0, -29.0], [-30.0, -31.0, -32.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_LRU(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[2:,1:3,:2]
      ref=Data(numpy.array([[[27.0, 28.0], [30.0, 31.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-27.0, -28.0], [-30.0, -31.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_LRR(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[2:,1:3,1:2]
      ref=Data(numpy.array([[[28.0], [31.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-28.0], [-31.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 2, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_UUN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:2,:3]
      ref=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0]], [[12.0, 13.0, 14.0], [15.0, 16.0, 17.0], 
[18.0, 19.0, 20.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0]], [[-12.0, -13.0, -14.0], 
[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_CUL(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:,:3,2:]
      ref=Data(numpy.array([[[2.0], [5.0], [8.0]], [[14.0], [17.0], [20.0]], [[26.0], [29.0], [32.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-2.0], [-5.0], [-8.0]], [[-14.0], [-17.0], [-20.0]], [[-26.0], [-29.0], [-32.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_LUP(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[2:,:3,1]
      ref=Data(numpy.array([[25.0, 28.0, 31.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-25.0, -28.0, -31.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_CCL(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:,:,2:]
      ref=Data(numpy.array([[[2.0], [5.0], [8.0], [11.0]], [[14.0], [17.0], [20.0], [23.0]], [[26.0], [29.0], [32.0], 
[35.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-2.0], [-5.0], [-8.0], [-11.0]], [[-14.0], [-17.0], [-20.0], [-23.0]], [[-26.0], 
[-29.0], [-32.0], [-35.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 4, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_UCR(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:2,:,1:2]
      ref=Data(numpy.array([[[1.0], [4.0], [7.0], [10.0]], [[13.0], [16.0], [19.0], [22.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-1.0], [-4.0], [-7.0], [-10.0]], [[-13.0], [-16.0], [-19.0], [-22.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_LCU(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[2:,:,:2]
      ref=Data(numpy.array([[[24.0, 25.0], [27.0, 28.0], [30.0, 31.0], [33.0, 34.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-24.0, -25.0], [-27.0, -28.0], [-30.0, -31.0], [-33.0, -34.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 4, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_CCP(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:,:,1]
      ref=Data(numpy.array([[1.0, 4.0, 7.0, 10.0], [13.0, 16.0, 19.0, 22.0], [25.0, 28.0, 31.0, 34.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-1.0, -4.0, -7.0, -10.0], [-13.0, -16.0, -19.0, -22.0], [-25.0, -28.0, -31.0, -34.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_LPP(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[2:,2,1]
      ref=Data(numpy.array([31.0]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-31.0]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_ULN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:2,2:]
      ref=Data(numpy.array([[[6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[18.0, 19.0, 20.0], [21.0, 22.0, 23.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], [[-18.0, -19.0, -20.0], [-21.0, -22.0, 
-23.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_PPN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1,2]
      ref=Data(numpy.array([18.0, 19.0, 20.0]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-18.0, -19.0, -20.0]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_CCN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:,:]
      ref=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_RLP(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1:2,2:,1]
      ref=Data(numpy.array([[19.0, 22.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-19.0, -22.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_PLU(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1,2:,:2]
      ref=Data(numpy.array([[18.0, 19.0], [21.0, 22.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-18.0, -19.0], [-21.0, -22.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_RUC(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1:2,:3,:]
      ref=Data(numpy.array([[[12.0, 13.0, 14.0], [15.0, 16.0, 17.0], [18.0, 19.0, 20.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_PPP(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1,2,1]
      ref=Data(19.0,self.functionspace)
      ref.setTaggedValue(1,-19.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_CUU(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:,:3,:2]
      ref=Data(numpy.array([[[0.0, 1.0], [3.0, 4.0], [6.0, 7.0]], [[12.0, 13.0], [15.0, 16.0], [18.0, 19.0]], [[24.0, 25.0], 
[27.0, 28.0], [30.0, 31.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-0.0, -1.0], [-3.0, -4.0], [-6.0, -7.0]], [[-12.0, -13.0], [-15.0, -16.0], [-18.0, 
-19.0]], [[-24.0, -25.0], [-27.0, -28.0], [-30.0, -31.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_LUN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[2:,:3]
      ref=Data(numpy.array([[[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-24.0, -25.0, -26.0], [-27.0, -28.0, -29.0], [-30.0, -31.0, -32.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_LLC(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[2:,2:,:]
      ref=Data(numpy.array([[[30.0, 31.0, 32.0], [33.0, 34.0, 35.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_UUL(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:2,:3,2:]
      ref=Data(numpy.array([[[2.0], [5.0], [8.0]], [[14.0], [17.0], [20.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-2.0], [-5.0], [-8.0]], [[-14.0], [-17.0], [-20.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_LPN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[2:,2]
      ref=Data(numpy.array([[30.0, 31.0, 32.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-30.0, -31.0, -32.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_RPN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1:2,2]
      ref=Data(numpy.array([[18.0, 19.0, 20.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-18.0, -19.0, -20.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_RCP(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1:2,:,1]
      ref=Data(numpy.array([[13.0, 16.0, 19.0, 22.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-13.0, -16.0, -19.0, -22.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_UCN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:2,:]
      ref=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_LRL(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[2:,1:3,2:]
      ref=Data(numpy.array([[[29.0], [32.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-29.0], [-32.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 2, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_PUR(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1,:3,1:2]
      ref=Data(numpy.array([[13.0], [16.0], [19.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-13.0], [-16.0], [-19.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_RLC(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1:2,2:,:]
      ref=Data(numpy.array([[[18.0, 19.0, 20.0], [21.0, 22.0, 23.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_PRC(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1,1:3,:]
      ref=Data(numpy.array([[15.0, 16.0, 17.0], [18.0, 19.0, 20.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_CPN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:,2]
      ref=Data(numpy.array([[6.0, 7.0, 8.0], [18.0, 19.0, 20.0], [30.0, 31.0, 32.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-6.0, -7.0, -8.0], [-18.0, -19.0, -20.0], [-30.0, -31.0, -32.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_CLN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:,2:]
      ref=Data(numpy.array([[[6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[30.0, 31.0, 
32.0], [33.0, 34.0, 35.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], [[-18.0, -19.0, -20.0], [-21.0, -22.0, 
-23.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_RRN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1:2,1:3]
      ref=Data(numpy.array([[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_CUN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:,:3]
      ref=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0]], [[12.0, 13.0, 14.0], [15.0, 16.0, 17.0], 
[18.0, 19.0, 20.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0]], [[-12.0, -13.0, -14.0], 
[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0]], [[-24.0, -25.0, -26.0], [-27.0, -28.0, -29.0], [-30.0, -31.0, -32.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_UUP(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:2,:3,1]
      ref=Data(numpy.array([[1.0, 4.0, 7.0], [13.0, 16.0, 19.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-1.0, -4.0, -7.0], [-13.0, -16.0, -19.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_URN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:2,1:3]
      ref=Data(numpy.array([[[3.0, 4.0, 5.0], [6.0, 7.0, 8.0]], [[15.0, 16.0, 17.0], [18.0, 19.0, 20.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, 
-20.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_RRP(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1:2,1:3,1]
      ref=Data(numpy.array([[16.0, 19.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-16.0, -19.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_PRN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1,1:3]
      ref=Data(numpy.array([[15.0, 16.0, 17.0], [18.0, 19.0, 20.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_RLN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1:2,2:]
      ref=Data(numpy.array([[[18.0, 19.0, 20.0], [21.0, 22.0, 23.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_PRL(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1,1:3,2:]
      ref=Data(numpy.array([[17.0], [20.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-17.0], [-20.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_PLC(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1,2:,:]
      ref=Data(numpy.array([[18.0, 19.0, 20.0], [21.0, 22.0, 23.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_UPN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:2,2]
      ref=Data(numpy.array([[6.0, 7.0, 8.0], [18.0, 19.0, 20.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-6.0, -7.0, -8.0], [-18.0, -19.0, -20.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_ULR(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:2,2:,1:2]
      ref=Data(numpy.array([[[7.0], [10.0]], [[19.0], [22.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-7.0], [-10.0]], [[-19.0], [-22.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_PUC(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1,:3,:]
      ref=Data(numpy.array([[12.0, 13.0, 14.0], [15.0, 16.0, 17.0], [18.0, 19.0, 20.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_CPP(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:,2,1]
      ref=Data(numpy.array([7.0, 19.0, 31.0]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-7.0, -19.0, -31.0]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_LRN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[2:,1:3]
      ref=Data(numpy.array([[[27.0, 28.0, 29.0], [30.0, 31.0, 32.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-27.0, -28.0, -29.0], [-30.0, -31.0, -32.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_PCN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1,:]
      ref=Data(numpy.array([[12.0, 13.0, 14.0], [15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, 
-23.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_RCN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1:2,:]
      ref=Data(numpy.array([[[12.0, 13.0, 14.0], [15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 
23.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, 
-23.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_RUN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1:2,:3]
      ref=Data(numpy.array([[[12.0, 13.0, 14.0], [15.0, 16.0, 17.0], [18.0, 19.0, 20.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_CRN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[:,1:3]
      ref=Data(numpy.array([[[3.0, 4.0, 5.0], [6.0, 7.0, 8.0]], [[15.0, 16.0, 17.0], [18.0, 19.0, 20.0]], [[27.0, 28.0, 29.0], 
[30.0, 31.0, 32.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, 
-20.0]], [[-27.0, -28.0, -29.0], [-30.0, -31.0, -32.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_PLN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1,2:]
      ref=Data(numpy.array([[18.0, 19.0, 20.0], [21.0, 22.0, 23.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank3_PUN(self):
      arg=Data(numpy.array([[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[12.0, 13.0, 14.0], [15.0, 
16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0]], [[24.0, 25.0, 26.0], [27.0, 28.0, 29.0], [30.0, 31.0, 32.0], [33.0, 34.0, 
35.0]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0]], [[-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0], [-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0]]]))
      res=arg[1,:3]
      ref=Data(numpy.array([[12.0, 13.0, 14.0], [15.0, 16.0, 17.0], [18.0, 19.0, 20.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-12.0, -13.0, -14.0], [-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UCCL(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,:,:,2:]
      ref=Data(numpy.array([[[[2.0], [5.0], [8.0], [11.0], [14.0]], [[17.0], [20.0], [23.0], [26.0], [29.0]], [[32.0], [35.0], 
[38.0], [41.0], [44.0]]], [[[47.0], [50.0], [53.0], [56.0], [59.0]], [[62.0], [65.0], [68.0], [71.0], [74.0]], [[77.0], [80.0], 
[83.0], [86.0], [89.0]]], [[[92.0], [95.0], [98.0], [101.0], [104.0]], [[107.0], [110.0], [113.0], [116.0], [119.0]], [[122.0], 
[125.0], [128.0], [131.0], [134.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-2.0], [-5.0], [-8.0], [-11.0], [-14.0]], [[-17.0], [-20.0], [-23.0], [-26.0], 
[-29.0]], [[-32.0], [-35.0], [-38.0], [-41.0], [-44.0]]], [[[-47.0], [-50.0], [-53.0], [-56.0], [-59.0]], [[-62.0], [-65.0], 
[-68.0], [-71.0], [-74.0]], [[-77.0], [-80.0], [-83.0], [-86.0], [-89.0]]], [[[-92.0], [-95.0], [-98.0], [-101.0], [-104.0]], 
[[-107.0], [-110.0], [-113.0], [-116.0], [-119.0]], [[-122.0], [-125.0], [-128.0], [-131.0], [-134.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3, 5, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LPCU(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,1,:,:2]
      ref=Data(numpy.array([[[105.0, 106.0], [108.0, 109.0], [111.0, 112.0], [114.0, 115.0], [117.0, 118.0]], [[150.0, 151.0], 
[153.0, 154.0], [156.0, 157.0], [159.0, 160.0], [162.0, 163.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-105.0, -106.0], [-108.0, -109.0], [-111.0, -112.0], [-114.0, -115.0], [-117.0, 
-118.0]], [[-150.0, -151.0], [-153.0, -154.0], [-156.0, -157.0], [-159.0, -160.0], [-162.0, -163.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_URCR(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,1:2,:,1:2]
      ref=Data(numpy.array([[[[16.0], [19.0], [22.0], [25.0], [28.0]]], [[[61.0], [64.0], [67.0], [70.0], [73.0]]], [[[106.0], 
[109.0], [112.0], [115.0], [118.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-16.0], [-19.0], [-22.0], [-25.0], [-28.0]]], [[[-61.0], [-64.0], [-67.0], [-70.0], 
[-73.0]]], [[[-106.0], [-109.0], [-112.0], [-115.0], [-118.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 1, 5, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LRUU(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,1:2,:4,:2]
      ref=Data(numpy.array([[[[105.0, 106.0], [108.0, 109.0], [111.0, 112.0], [114.0, 115.0]]], [[[150.0, 151.0], [153.0, 
154.0], [156.0, 157.0], [159.0, 160.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-105.0, -106.0], [-108.0, -109.0], [-111.0, -112.0], [-114.0, -115.0]]], [[[-150.0, 
-151.0], [-153.0, -154.0], [-156.0, -157.0], [-159.0, -160.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 4, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CUUL(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,:2,:4,2:]
      ref=Data(numpy.array([[[[2.0], [5.0], [8.0], [11.0]], [[17.0], [20.0], [23.0], [26.0]]], [[[47.0], [50.0], [53.0], 
[56.0]], [[62.0], [65.0], [68.0], [71.0]]], [[[92.0], [95.0], [98.0], [101.0]], [[107.0], [110.0], [113.0], [116.0]]], 
[[[137.0], [140.0], [143.0], [146.0]], [[152.0], [155.0], [158.0], [161.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-2.0], [-5.0], [-8.0], [-11.0]], [[-17.0], [-20.0], [-23.0], [-26.0]]], [[[-47.0], 
[-50.0], [-53.0], [-56.0]], [[-62.0], [-65.0], [-68.0], [-71.0]]], [[[-92.0], [-95.0], [-98.0], [-101.0]], [[-107.0], [-110.0], 
[-113.0], [-116.0]]], [[[-137.0], [-140.0], [-143.0], [-146.0]], [[-152.0], [-155.0], [-158.0], [-161.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 2, 4, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CCPC(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,:,2,:]
      ref=Data(numpy.array([[[6.0, 7.0, 8.0], [21.0, 22.0, 23.0], [36.0, 37.0, 38.0]], [[51.0, 52.0, 53.0], [66.0, 67.0, 68.0], 
[81.0, 82.0, 83.0]], [[96.0, 97.0, 98.0], [111.0, 112.0, 113.0], [126.0, 127.0, 128.0]], [[141.0, 142.0, 143.0], [156.0, 157.0, 
158.0], [171.0, 172.0, 173.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-6.0, -7.0, -8.0], [-21.0, -22.0, -23.0], [-36.0, -37.0, -38.0]], [[-51.0, -52.0, 
-53.0], [-66.0, -67.0, -68.0], [-81.0, -82.0, -83.0]], [[-96.0, -97.0, -98.0], [-111.0, -112.0, -113.0], [-126.0, -127.0, 
-128.0]], [[-141.0, -142.0, -143.0], [-156.0, -157.0, -158.0], [-171.0, -172.0, -173.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RLCP(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,2:,:,1]
      ref=Data(numpy.array([[[76.0, 79.0, 82.0, 85.0, 88.0]], [[121.0, 124.0, 127.0, 130.0, 133.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-76.0, -79.0, -82.0, -85.0, -88.0]], [[-121.0, -124.0, -127.0, -130.0, -133.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LRRC(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,1:2,1:4,:]
      ref=Data(numpy.array([[[[108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]]], [[[153.0, 154.0, 155.0], 
[156.0, 157.0, 158.0], [159.0, 160.0, 161.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]], 
[[[-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LLCP(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,2:,:,1]
      ref=Data(numpy.array([[[121.0, 124.0, 127.0, 130.0, 133.0]], [[166.0, 169.0, 172.0, 175.0, 178.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-121.0, -124.0, -127.0, -130.0, -133.0]], [[-166.0, -169.0, -172.0, -175.0, 
-178.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PRCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,1:2,:]
      ref=Data(numpy.array([[[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], 
[117.0, 118.0, 119.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, 
-115.0, -116.0], [-117.0, -118.0, -119.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RPRC(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,1,1:4,:]
      ref=Data(numpy.array([[[63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0]], [[108.0, 109.0, 110.0], [111.0, 
112.0, 113.0], [114.0, 115.0, 116.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]], [[-108.0, 
-109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_ULCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,2:,:]
      ref=Data(numpy.array([[[[30.0, 31.0, 32.0], [33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 
44.0]]], [[[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], [87.0, 88.0, 89.0]]], [[[120.0, 
121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 
134.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, 
-41.0], [-42.0, -43.0, -44.0]]], [[[-75.0, -76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], 
[-87.0, -88.0, -89.0]]], [[[-120.0, -121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, 
-131.0], [-132.0, -133.0, -134.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 1, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CLRN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,2:,1:4]
      ref=Data(numpy.array([[[[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0]]], [[[78.0, 79.0, 80.0], [81.0, 82.0, 
83.0], [84.0, 85.0, 86.0]]], [[[123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0]]], [[[168.0, 169.0, 170.0], 
[171.0, 172.0, 173.0], [174.0, 175.0, 176.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0]]], [[[-78.0, 
-79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0]]], [[[-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, 
-130.0, -131.0]]], [[[-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RRRL(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,1:2,1:4,2:]
      ref=Data(numpy.array([[[[65.0], [68.0], [71.0]]], [[[110.0], [113.0], [116.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-65.0], [-68.0], [-71.0]]], [[[-110.0], [-113.0], [-116.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PLPL(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,2:,2,2:]
      ref=Data(numpy.array([[128.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-128.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LLPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,2:,2]
      ref=Data(numpy.array([[[126.0, 127.0, 128.0]], [[171.0, 172.0, 173.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-126.0, -127.0, -128.0]], [[-171.0, -172.0, -173.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PCRC(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,:,1:4,:]
      ref=Data(numpy.array([[[93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[108.0, 109.0, 110.0], [111.0, 
112.0, 113.0], [114.0, 115.0, 116.0]], [[123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 
131.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0]], [[-108.0, 
-109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]], [[-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], 
[-129.0, -130.0, -131.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CPRP(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,1,1:4,1]
      ref=Data(numpy.array([[19.0, 22.0, 25.0], [64.0, 67.0, 70.0], [109.0, 112.0, 115.0], [154.0, 157.0, 
160.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-19.0, -22.0, -25.0], [-64.0, -67.0, -70.0], [-109.0, -112.0, -115.0], [-154.0, 
-157.0, -160.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CUPU(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,:2,2,:2]
      ref=Data(numpy.array([[[6.0, 7.0], [21.0, 22.0]], [[51.0, 52.0], [66.0, 67.0]], [[96.0, 97.0], [111.0, 112.0]], [[141.0, 
142.0], [156.0, 157.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-6.0, -7.0], [-21.0, -22.0]], [[-51.0, -52.0], [-66.0, -67.0]], [[-96.0, -97.0], 
[-111.0, -112.0]], [[-141.0, -142.0], [-156.0, -157.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 2, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UUUL(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,:2,:4,2:]
      ref=Data(numpy.array([[[[2.0], [5.0], [8.0], [11.0]], [[17.0], [20.0], [23.0], [26.0]]], [[[47.0], [50.0], [53.0], 
[56.0]], [[62.0], [65.0], [68.0], [71.0]]], [[[92.0], [95.0], [98.0], [101.0]], [[107.0], [110.0], [113.0], 
[116.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-2.0], [-5.0], [-8.0], [-11.0]], [[-17.0], [-20.0], [-23.0], [-26.0]]], [[[-47.0], 
[-50.0], [-53.0], [-56.0]], [[-62.0], [-65.0], [-68.0], [-71.0]]], [[[-92.0], [-95.0], [-98.0], [-101.0]], [[-107.0], [-110.0], 
[-113.0], [-116.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 4, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RUUC(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,:2,:4,:]
      ref=Data(numpy.array([[[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], [51.0, 52.0, 53.0], [54.0, 55.0, 56.0]], [[60.0, 61.0, 
62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 
98.0], [99.0, 100.0, 101.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 
116.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, 
-56.0]], [[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, 
-110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CCLL(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,:,2:,2:]
      ref=Data(numpy.array([[[[8.0], [11.0], [14.0]], [[23.0], [26.0], [29.0]], [[38.0], [41.0], [44.0]]], [[[53.0], [56.0], 
[59.0]], [[68.0], [71.0], [74.0]], [[83.0], [86.0], [89.0]]], [[[98.0], [101.0], [104.0]], [[113.0], [116.0], [119.0]], 
[[128.0], [131.0], [134.0]]], [[[143.0], [146.0], [149.0]], [[158.0], [161.0], [164.0]], [[173.0], [176.0], 
[179.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-8.0], [-11.0], [-14.0]], [[-23.0], [-26.0], [-29.0]], [[-38.0], [-41.0], [-44.0]]], 
[[[-53.0], [-56.0], [-59.0]], [[-68.0], [-71.0], [-74.0]], [[-83.0], [-86.0], [-89.0]]], [[[-98.0], [-101.0], [-104.0]], 
[[-113.0], [-116.0], [-119.0]], [[-128.0], [-131.0], [-134.0]]], [[[-143.0], [-146.0], [-149.0]], [[-158.0], [-161.0], 
[-164.0]], [[-173.0], [-176.0], [-179.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 3, 3, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LRLC(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,1:2,2:,:]
      ref=Data(numpy.array([[[[111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]]], [[[156.0, 157.0, 158.0], 
[159.0, 160.0, 161.0], [162.0, 163.0, 164.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]]], 
[[[-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, -163.0, -164.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RRLN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,1:2,2:]
      ref=Data(numpy.array([[[[66.0, 67.0, 68.0], [69.0, 70.0, 71.0], [72.0, 73.0, 74.0]]], [[[111.0, 112.0, 113.0], [114.0, 
115.0, 116.0], [117.0, 118.0, 119.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]]], [[[-111.0, 
-112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PLUU(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,2:,:4,:2]
      ref=Data(numpy.array([[[120.0, 121.0], [123.0, 124.0], [126.0, 127.0], [129.0, 130.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-120.0, -121.0], [-123.0, -124.0], [-126.0, -127.0], [-129.0, -130.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 4, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PPUR(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,1,:4,1:2]
      ref=Data(numpy.array([[106.0], [109.0], [112.0], [115.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-106.0], [-109.0], [-112.0], [-115.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CRCU(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,1:2,:,:2]
      ref=Data(numpy.array([[[[15.0, 16.0], [18.0, 19.0], [21.0, 22.0], [24.0, 25.0], [27.0, 28.0]]], [[[60.0, 61.0], [63.0, 
64.0], [66.0, 67.0], [69.0, 70.0], [72.0, 73.0]]], [[[105.0, 106.0], [108.0, 109.0], [111.0, 112.0], [114.0, 115.0], [117.0, 
118.0]]], [[[150.0, 151.0], [153.0, 154.0], [156.0, 157.0], [159.0, 160.0], [162.0, 163.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-15.0, -16.0], [-18.0, -19.0], [-21.0, -22.0], [-24.0, -25.0], [-27.0, -28.0]]], 
[[[-60.0, -61.0], [-63.0, -64.0], [-66.0, -67.0], [-69.0, -70.0], [-72.0, -73.0]]], [[[-105.0, -106.0], [-108.0, -109.0], 
[-111.0, -112.0], [-114.0, -115.0], [-117.0, -118.0]]], [[[-150.0, -151.0], [-153.0, -154.0], [-156.0, -157.0], [-159.0, 
-160.0], [-162.0, -163.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 1, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RUPL(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,:2,2,2:]
      ref=Data(numpy.array([[[53.0], [68.0]], [[98.0], [113.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-53.0], [-68.0]], [[-98.0], [-113.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PLPU(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,2:,2,:2]
      ref=Data(numpy.array([[126.0, 127.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-126.0, -127.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PLRL(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,2:,1:4,2:]
      ref=Data(numpy.array([[[125.0], [128.0], [131.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-125.0], [-128.0], [-131.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 3, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RPPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,1,2]
      ref=Data(numpy.array([[66.0, 67.0, 68.0], [111.0, 112.0, 113.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-66.0, -67.0, -68.0], [-111.0, -112.0, -113.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UPCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,1,:]
      ref=Data(numpy.array([[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 
29.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[105.0, 106.0, 
107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, 
-26.0], [-27.0, -28.0, -29.0]], [[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], 
[-72.0, -73.0, -74.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, 
-116.0], [-117.0, -118.0, -119.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LLUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,2:,:4]
      ref=Data(numpy.array([[[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0]]], 
[[[165.0, 166.0, 167.0], [168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-120.0, -121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], 
[-129.0, -130.0, -131.0]]], [[[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, 
-176.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PPLC(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,1,2:,:]
      ref=Data(numpy.array([[111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PRRP(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,1:2,1:4,1]
      ref=Data(numpy.array([[109.0, 112.0, 115.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-109.0, -112.0, -115.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PPPC(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,1,2,:]
      ref=Data(numpy.array([111.0, 112.0, 113.0]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-111.0, -112.0, -113.0]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RURL(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,:2,1:4,2:]
      ref=Data(numpy.array([[[[50.0], [53.0], [56.0]], [[65.0], [68.0], [71.0]]], [[[95.0], [98.0], [101.0]], [[110.0], 
[113.0], [116.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-50.0], [-53.0], [-56.0]], [[-65.0], [-68.0], [-71.0]]], [[[-95.0], [-98.0], 
[-101.0]], [[-110.0], [-113.0], [-116.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2, 3, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PUUR(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,:2,:4,1:2]
      ref=Data(numpy.array([[[91.0], [94.0], [97.0], [100.0]], [[106.0], [109.0], [112.0], [115.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-91.0], [-94.0], [-97.0], [-100.0]], [[-106.0], [-109.0], [-112.0], [-115.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RUCL(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,:2,:,2:]
      ref=Data(numpy.array([[[[47.0], [50.0], [53.0], [56.0], [59.0]], [[62.0], [65.0], [68.0], [71.0], [74.0]]], [[[92.0], 
[95.0], [98.0], [101.0], [104.0]], [[107.0], [110.0], [113.0], [116.0], [119.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-47.0], [-50.0], [-53.0], [-56.0], [-59.0]], [[-62.0], [-65.0], [-68.0], [-71.0], 
[-74.0]]], [[[-92.0], [-95.0], [-98.0], [-101.0], [-104.0]], [[-107.0], [-110.0], [-113.0], [-116.0], [-119.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2, 5, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CCPP(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,:,2,1]
      ref=Data(numpy.array([[7.0, 22.0, 37.0], [52.0, 67.0, 82.0], [97.0, 112.0, 127.0], [142.0, 157.0, 
172.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-7.0, -22.0, -37.0], [-52.0, -67.0, -82.0], [-97.0, -112.0, -127.0], [-142.0, -157.0, 
-172.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RRPL(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,1:2,2,2:]
      ref=Data(numpy.array([[[68.0]], [[113.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-68.0]], [[-113.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LULP(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,:2,2:,1]
      ref=Data(numpy.array([[[97.0, 100.0, 103.0], [112.0, 115.0, 118.0]], [[142.0, 145.0, 148.0], [157.0, 160.0, 
163.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-97.0, -100.0, -103.0], [-112.0, -115.0, -118.0]], [[-142.0, -145.0, -148.0], 
[-157.0, -160.0, -163.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PLLL(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,2:,2:,2:]
      ref=Data(numpy.array([[[128.0], [131.0], [134.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-128.0], [-131.0], [-134.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 3, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PPPR(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,1,2,1:2]
      ref=Data(numpy.array([112.0]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-112.0]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LRCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,1:2,:]
      ref=Data(numpy.array([[[[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], 
[117.0, 118.0, 119.0]]], [[[150.0, 151.0, 152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 
163.0, 164.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], 
[-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]]], [[[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, 
-158.0], [-159.0, -160.0, -161.0], [-162.0, -163.0, -164.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CCUC(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,:,:4,:]
      ref=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[15.0, 16.0, 17.0], 
[18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0]], [[30.0, 31.0, 32.0], [33.0, 34.0, 35.0], [36.0, 37.0, 38.0], 
[39.0, 40.0, 41.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], [51.0, 52.0, 53.0], [54.0, 55.0, 56.0]], [[60.0, 61.0, 62.0], 
[63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], 
[84.0, 85.0, 86.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[105.0, 106.0, 
107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]], [[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], 
[126.0, 127.0, 128.0], [129.0, 130.0, 131.0]]], [[[135.0, 136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 
145.0, 146.0]], [[150.0, 151.0, 152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0]], [[165.0, 166.0, 
167.0], [168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0]], [[-30.0, -31.0, -32.0], [-33.0, 
-34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, 
-53.0], [-54.0, -55.0, -56.0]], [[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]], 
[[-75.0, -76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0]]], [[[-90.0, -91.0, -92.0], [-93.0, 
-94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, 
-112.0, -113.0], [-114.0, -115.0, -116.0]], [[-120.0, -121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], 
[-129.0, -130.0, -131.0]]], [[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, 
-146.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0]], [[-165.0, 
-166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 3, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LRLL(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,1:2,2:,2:]
      ref=Data(numpy.array([[[[113.0], [116.0], [119.0]]], [[[158.0], [161.0], [164.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-113.0], [-116.0], [-119.0]]], [[[-158.0], [-161.0], [-164.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CRRR(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,1:2,1:4,1:2]
      ref=Data(numpy.array([[[[19.0], [22.0], [25.0]]], [[[64.0], [67.0], [70.0]]], [[[109.0], [112.0], [115.0]]], [[[154.0], 
[157.0], [160.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-19.0], [-22.0], [-25.0]]], [[[-64.0], [-67.0], [-70.0]]], [[[-109.0], [-112.0], 
[-115.0]]], [[[-154.0], [-157.0], [-160.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 1, 3, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CRCR(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,1:2,:,1:2]
      ref=Data(numpy.array([[[[16.0], [19.0], [22.0], [25.0], [28.0]]], [[[61.0], [64.0], [67.0], [70.0], [73.0]]], [[[106.0], 
[109.0], [112.0], [115.0], [118.0]]], [[[151.0], [154.0], [157.0], [160.0], [163.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-16.0], [-19.0], [-22.0], [-25.0], [-28.0]]], [[[-61.0], [-64.0], [-67.0], [-70.0], 
[-73.0]]], [[[-106.0], [-109.0], [-112.0], [-115.0], [-118.0]]], [[[-151.0], [-154.0], [-157.0], [-160.0], [-163.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 1, 5, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RCRN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,:,1:4]
      ref=Data(numpy.array([[[[48.0, 49.0, 50.0], [51.0, 52.0, 53.0], [54.0, 55.0, 56.0]], [[63.0, 64.0, 65.0], [66.0, 67.0, 
68.0], [69.0, 70.0, 71.0]], [[78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0]]], [[[93.0, 94.0, 95.0], [96.0, 97.0, 
98.0], [99.0, 100.0, 101.0]], [[108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]], [[123.0, 124.0, 125.0], 
[126.0, 127.0, 128.0], [129.0, 130.0, 131.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0]], [[-63.0, -64.0, 
-65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]], [[-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0]]], 
[[[-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0]], [[-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], 
[-114.0, -115.0, -116.0]], [[-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PUCP(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,:2,:,1]
      ref=Data(numpy.array([[91.0, 94.0, 97.0, 100.0, 103.0], [106.0, 109.0, 112.0, 115.0, 118.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-91.0, -94.0, -97.0, -100.0, -103.0], [-106.0, -109.0, -112.0, -115.0, -118.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 5),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CUUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,:2,:4]
      ref=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[15.0, 16.0, 17.0], 
[18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], [51.0, 52.0, 53.0], 
[54.0, 55.0, 56.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0]]], [[[90.0, 91.0, 92.0], 
[93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 
113.0], [114.0, 115.0, 116.0]]], [[[135.0, 136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0]], 
[[150.0, 151.0, 152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0]]], [[[-45.0, -46.0, -47.0], [-48.0, 
-49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0]], [[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, 
-68.0], [-69.0, -70.0, -71.0]]], [[[-90.0, -91.0, -92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, 
-101.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]], [[[-135.0, 
-136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0]], [[-150.0, -151.0, -152.0], 
[-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 2, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RPCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,1,:]
      ref=Data(numpy.array([[[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0], [72.0, 73.0, 
74.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 
119.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, 
-71.0], [-72.0, -73.0, -74.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, 
-116.0], [-117.0, -118.0, -119.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LPRP(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,1,1:4,1]
      ref=Data(numpy.array([[109.0, 112.0, 115.0], [154.0, 157.0, 160.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-109.0, -112.0, -115.0], [-154.0, -157.0, -160.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PLUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,2:,:4]
      ref=Data(numpy.array([[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 
131.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-120.0, -121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, 
-130.0, -131.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UCPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,:,2]
      ref=Data(numpy.array([[[6.0, 7.0, 8.0], [21.0, 22.0, 23.0], [36.0, 37.0, 38.0]], [[51.0, 52.0, 53.0], [66.0, 67.0, 68.0], 
[81.0, 82.0, 83.0]], [[96.0, 97.0, 98.0], [111.0, 112.0, 113.0], [126.0, 127.0, 128.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-6.0, -7.0, -8.0], [-21.0, -22.0, -23.0], [-36.0, -37.0, -38.0]], [[-51.0, -52.0, 
-53.0], [-66.0, -67.0, -68.0], [-81.0, -82.0, -83.0]], [[-96.0, -97.0, -98.0], [-111.0, -112.0, -113.0], [-126.0, -127.0, 
-128.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_URCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,1:2,:]
      ref=Data(numpy.array([[[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 
29.0]]], [[[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0], [72.0, 73.0, 74.0]]], [[[105.0, 
106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 
119.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, 
-26.0], [-27.0, -28.0, -29.0]]], [[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], 
[-72.0, -73.0, -74.0]]], [[[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, 
-116.0], [-117.0, -118.0, -119.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 1, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PCCL(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,:,:,2:]
      ref=Data(numpy.array([[[92.0], [95.0], [98.0], [101.0], [104.0]], [[107.0], [110.0], [113.0], [116.0], [119.0]], 
[[122.0], [125.0], [128.0], [131.0], [134.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-92.0], [-95.0], [-98.0], [-101.0], [-104.0]], [[-107.0], [-110.0], [-113.0], 
[-116.0], [-119.0]], [[-122.0], [-125.0], [-128.0], [-131.0], [-134.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 5, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RUUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,:2,:4]
      ref=Data(numpy.array([[[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], [51.0, 52.0, 53.0], [54.0, 55.0, 56.0]], [[60.0, 61.0, 
62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 
98.0], [99.0, 100.0, 101.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 
116.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, 
-56.0]], [[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, 
-110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LLRU(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,2:,1:4,:2]
      ref=Data(numpy.array([[[[123.0, 124.0], [126.0, 127.0], [129.0, 130.0]]], [[[168.0, 169.0], [171.0, 172.0], [174.0, 
175.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-123.0, -124.0], [-126.0, -127.0], [-129.0, -130.0]]], [[[-168.0, -169.0], [-171.0, 
-172.0], [-174.0, -175.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_URUU(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,1:2,:4,:2]
      ref=Data(numpy.array([[[[15.0, 16.0], [18.0, 19.0], [21.0, 22.0], [24.0, 25.0]]], [[[60.0, 61.0], [63.0, 64.0], [66.0, 
67.0], [69.0, 70.0]]], [[[105.0, 106.0], [108.0, 109.0], [111.0, 112.0], [114.0, 115.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-15.0, -16.0], [-18.0, -19.0], [-21.0, -22.0], [-24.0, -25.0]]], [[[-60.0, -61.0], 
[-63.0, -64.0], [-66.0, -67.0], [-69.0, -70.0]]], [[[-105.0, -106.0], [-108.0, -109.0], [-111.0, -112.0], [-114.0, -115.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 1, 4, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PPUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,1,:4]
      ref=Data(numpy.array([[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 
116.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, 
-115.0, -116.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UUUP(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,:2,:4,1]
      ref=Data(numpy.array([[[1.0, 4.0, 7.0, 10.0], [16.0, 19.0, 22.0, 25.0]], [[46.0, 49.0, 52.0, 55.0], [61.0, 64.0, 67.0, 
70.0]], [[91.0, 94.0, 97.0, 100.0], [106.0, 109.0, 112.0, 115.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-1.0, -4.0, -7.0, -10.0], [-16.0, -19.0, -22.0, -25.0]], [[-46.0, -49.0, -52.0, 
-55.0], [-61.0, -64.0, -67.0, -70.0]], [[-91.0, -94.0, -97.0, -100.0], [-106.0, -109.0, -112.0, -115.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 4),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LPUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,1,:4]
      ref=Data(numpy.array([[[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]], 
[[150.0, 151.0, 152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, 
-115.0, -116.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RUPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,:2,2]
      ref=Data(numpy.array([[[51.0, 52.0, 53.0], [66.0, 67.0, 68.0]], [[96.0, 97.0, 98.0], [111.0, 112.0, 
113.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-51.0, -52.0, -53.0], [-66.0, -67.0, -68.0]], [[-96.0, -97.0, -98.0], [-111.0, 
-112.0, -113.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RCPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,:,2]
      ref=Data(numpy.array([[[51.0, 52.0, 53.0], [66.0, 67.0, 68.0], [81.0, 82.0, 83.0]], [[96.0, 97.0, 98.0], [111.0, 112.0, 
113.0], [126.0, 127.0, 128.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-51.0, -52.0, -53.0], [-66.0, -67.0, -68.0], [-81.0, -82.0, -83.0]], [[-96.0, -97.0, 
-98.0], [-111.0, -112.0, -113.0], [-126.0, -127.0, -128.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RRRR(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,1:2,1:4,1:2]
      ref=Data(numpy.array([[[[64.0], [67.0], [70.0]]], [[[109.0], [112.0], [115.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-64.0], [-67.0], [-70.0]]], [[[-109.0], [-112.0], [-115.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_ULUL(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,2:,:4,2:]
      ref=Data(numpy.array([[[[32.0], [35.0], [38.0], [41.0]]], [[[77.0], [80.0], [83.0], [86.0]]], [[[122.0], [125.0], 
[128.0], [131.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-32.0], [-35.0], [-38.0], [-41.0]]], [[[-77.0], [-80.0], [-83.0], [-86.0]]], 
[[[-122.0], [-125.0], [-128.0], [-131.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 1, 4, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_ULCL(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,2:,:,2:]
      ref=Data(numpy.array([[[[32.0], [35.0], [38.0], [41.0], [44.0]]], [[[77.0], [80.0], [83.0], [86.0], [89.0]]], [[[122.0], 
[125.0], [128.0], [131.0], [134.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-32.0], [-35.0], [-38.0], [-41.0], [-44.0]]], [[[-77.0], [-80.0], [-83.0], [-86.0], 
[-89.0]]], [[[-122.0], [-125.0], [-128.0], [-131.0], [-134.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 1, 5, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RRCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,1:2,:]
      ref=Data(numpy.array([[[[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0], [72.0, 73.0, 
74.0]]], [[[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 
119.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, 
-71.0], [-72.0, -73.0, -74.0]]], [[[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, 
-115.0, -116.0], [-117.0, -118.0, -119.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CCLC(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,:,2:,:]
      ref=Data(numpy.array([[[[6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], [[21.0, 22.0, 23.0], [24.0, 25.0, 26.0], 
[27.0, 28.0, 29.0]], [[36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], 
[57.0, 58.0, 59.0]], [[66.0, 67.0, 68.0], [69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 104.0]], [[111.0, 112.0, 113.0], [114.0, 
115.0, 116.0], [117.0, 118.0, 119.0]], [[126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[141.0, 142.0, 
143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], 
[[171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], [-12.0, -13.0, -14.0]], [[-21.0, -22.0, 
-23.0], [-24.0, -25.0, -26.0], [-27.0, -28.0, -29.0]], [[-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, -44.0]]], 
[[[-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], [[-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, 
-73.0, -74.0]], [[-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-96.0, -97.0, -98.0], [-99.0, 
-100.0, -101.0], [-102.0, -103.0, -104.0]], [[-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], 
[[-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], [[[-141.0, -142.0, -143.0], [-144.0, -145.0, 
-146.0], [-147.0, -148.0, -149.0]], [[-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, -163.0, -164.0]], [[-171.0, 
-172.0, -173.0], [-174.0, -175.0, -176.0], [-177.0, -178.0, -179.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 3, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CUPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,:2,2]
      ref=Data(numpy.array([[[6.0, 7.0, 8.0], [21.0, 22.0, 23.0]], [[51.0, 52.0, 53.0], [66.0, 67.0, 68.0]], [[96.0, 97.0, 
98.0], [111.0, 112.0, 113.0]], [[141.0, 142.0, 143.0], [156.0, 157.0, 158.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-6.0, -7.0, -8.0], [-21.0, -22.0, -23.0]], [[-51.0, -52.0, -53.0], [-66.0, -67.0, 
-68.0]], [[-96.0, -97.0, -98.0], [-111.0, -112.0, -113.0]], [[-141.0, -142.0, -143.0], [-156.0, -157.0, -158.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_ULLN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,2:,2:]
      ref=Data(numpy.array([[[[36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[81.0, 82.0, 83.0], [84.0, 85.0, 
86.0], [87.0, 88.0, 89.0]]], [[[126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, -44.0]]], [[[-81.0, 
-82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, 
-133.0, -134.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UUCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,:2,:]
      ref=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]]], [[[45.0, 46.0, 47.0], 
[48.0, 49.0, 50.0], [51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], 
[66.0, 67.0, 68.0], [69.0, 70.0, 71.0], [72.0, 73.0, 74.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], 
[99.0, 100.0, 101.0], [102.0, 103.0, 104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 
115.0, 116.0], [117.0, 118.0, 119.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, 
-59.0]], [[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]]], 
[[[-90.0, -91.0, -92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], 
[[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, 
-119.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LLLC(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,2:,2:,:]
      ref=Data(numpy.array([[[[126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[171.0, 172.0, 173.0], 
[174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], [-177.0, -178.0, -179.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RPLN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,1,2:]
      ref=Data(numpy.array([[[66.0, 67.0, 68.0], [69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[111.0, 112.0, 113.0], [114.0, 
115.0, 116.0], [117.0, 118.0, 119.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-111.0, 
-112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PUCC(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,:2,:,:]
      ref=Data(numpy.array([[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 
119.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-90.0, -91.0, -92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, 
-101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, 
-115.0, -116.0], [-117.0, -118.0, -119.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UCRN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,:,1:4]
      ref=Data(numpy.array([[[[3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[18.0, 19.0, 20.0], [21.0, 22.0, 23.0], 
[24.0, 25.0, 26.0]], [[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0]]], [[[48.0, 49.0, 50.0], [51.0, 52.0, 53.0], 
[54.0, 55.0, 56.0]], [[63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0]], [[78.0, 79.0, 80.0], [81.0, 82.0, 83.0], 
[84.0, 85.0, 86.0]]], [[[93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[108.0, 109.0, 110.0], [111.0, 112.0, 
113.0], [114.0, 115.0, 116.0]], [[123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], [[-18.0, -19.0, 
-20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0]], [[-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0]]], 
[[[-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0]], [[-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, 
-70.0, -71.0]], [[-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0]]], [[[-93.0, -94.0, -95.0], [-96.0, -97.0, 
-98.0], [-99.0, -100.0, -101.0]], [[-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]], [[-123.0, 
-124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CLRC(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,2:,1:4,:]
      ref=Data(numpy.array([[[[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0]]], [[[78.0, 79.0, 80.0], [81.0, 82.0, 
83.0], [84.0, 85.0, 86.0]]], [[[123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0]]], [[[168.0, 169.0, 170.0], 
[171.0, 172.0, 173.0], [174.0, 175.0, 176.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0]]], [[[-78.0, 
-79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0]]], [[[-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, 
-130.0, -131.0]]], [[[-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LUPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,:2,2]
      ref=Data(numpy.array([[[96.0, 97.0, 98.0], [111.0, 112.0, 113.0]], [[141.0, 142.0, 143.0], [156.0, 157.0, 
158.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-96.0, -97.0, -98.0], [-111.0, -112.0, -113.0]], [[-141.0, -142.0, -143.0], [-156.0, 
-157.0, -158.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PPPU(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,1,2,:2]
      ref=Data(numpy.array([111.0, 112.0]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-111.0, -112.0]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PRRU(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,1:2,1:4,:2]
      ref=Data(numpy.array([[[108.0, 109.0], [111.0, 112.0], [114.0, 115.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-108.0, -109.0], [-111.0, -112.0], [-114.0, -115.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 3, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_ULUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,2:,:4]
      ref=Data(numpy.array([[[[30.0, 31.0, 32.0], [33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0]]], [[[75.0, 76.0, 
77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0]]], [[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 
127.0, 128.0], [129.0, 130.0, 131.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, 
-41.0]]], [[[-75.0, -76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0]]], [[[-120.0, -121.0, 
-122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 1, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LLRN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,2:,1:4]
      ref=Data(numpy.array([[[[123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0]]], [[[168.0, 169.0, 170.0], 
[171.0, 172.0, 173.0], [174.0, 175.0, 176.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0]]], 
[[[-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RPCU(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,1,:,:2]
      ref=Data(numpy.array([[[60.0, 61.0], [63.0, 64.0], [66.0, 67.0], [69.0, 70.0], [72.0, 73.0]], [[105.0, 106.0], [108.0, 
109.0], [111.0, 112.0], [114.0, 115.0], [117.0, 118.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-60.0, -61.0], [-63.0, -64.0], [-66.0, -67.0], [-69.0, -70.0], [-72.0, -73.0]], 
[[-105.0, -106.0], [-108.0, -109.0], [-111.0, -112.0], [-114.0, -115.0], [-117.0, -118.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 5, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PUPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,:2,2]
      ref=Data(numpy.array([[96.0, 97.0, 98.0], [111.0, 112.0, 113.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-96.0, -97.0, -98.0], [-111.0, -112.0, -113.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LRLN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,1:2,2:]
      ref=Data(numpy.array([[[[111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]]], [[[156.0, 157.0, 158.0], 
[159.0, 160.0, 161.0], [162.0, 163.0, 164.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]]], 
[[[-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, -163.0, -164.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LUCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,:2,:]
      ref=Data(numpy.array([[[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]]], 
[[[135.0, 136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 
151.0, 152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 
164.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-90.0, -91.0, -92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, 
-101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, 
-115.0, -116.0], [-117.0, -118.0, -119.0]]], [[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], 
[-144.0, -145.0, -146.0], [-147.0, -148.0, -149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, 
-158.0], [-159.0, -160.0, -161.0], [-162.0, -163.0, -164.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UCUC(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,:,:4,:]
      ref=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[15.0, 16.0, 17.0], 
[18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0]], [[30.0, 31.0, 32.0], [33.0, 34.0, 35.0], [36.0, 37.0, 38.0], 
[39.0, 40.0, 41.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], [51.0, 52.0, 53.0], [54.0, 55.0, 56.0]], [[60.0, 61.0, 62.0], 
[63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], 
[84.0, 85.0, 86.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[105.0, 106.0, 
107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]], [[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], 
[126.0, 127.0, 128.0], [129.0, 130.0, 131.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0]], [[-30.0, -31.0, -32.0], [-33.0, 
-34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, 
-53.0], [-54.0, -55.0, -56.0]], [[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]], 
[[-75.0, -76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0]]], [[[-90.0, -91.0, -92.0], [-93.0, 
-94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, 
-112.0, -113.0], [-114.0, -115.0, -116.0]], [[-120.0, -121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], 
[-129.0, -130.0, -131.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CUCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,:2,:]
      ref=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]]], [[[45.0, 46.0, 47.0], 
[48.0, 49.0, 50.0], [51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], 
[66.0, 67.0, 68.0], [69.0, 70.0, 71.0], [72.0, 73.0, 74.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], 
[99.0, 100.0, 101.0], [102.0, 103.0, 104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 
115.0, 116.0], [117.0, 118.0, 119.0]]], [[[135.0, 136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 
146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], 
[162.0, 163.0, 164.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, 
-59.0]], [[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]]], 
[[[-90.0, -91.0, -92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], 
[[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, 
-119.0]]], [[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, 
-148.0, -149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], 
[-162.0, -163.0, -164.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 2, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CCLN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,:,2:]
      ref=Data(numpy.array([[[[6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], [[21.0, 22.0, 23.0], [24.0, 25.0, 26.0], 
[27.0, 28.0, 29.0]], [[36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], 
[57.0, 58.0, 59.0]], [[66.0, 67.0, 68.0], [69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 104.0]], [[111.0, 112.0, 113.0], [114.0, 
115.0, 116.0], [117.0, 118.0, 119.0]], [[126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[141.0, 142.0, 
143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], 
[[171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], [-12.0, -13.0, -14.0]], [[-21.0, -22.0, 
-23.0], [-24.0, -25.0, -26.0], [-27.0, -28.0, -29.0]], [[-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, -44.0]]], 
[[[-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], [[-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, 
-73.0, -74.0]], [[-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-96.0, -97.0, -98.0], [-99.0, 
-100.0, -101.0], [-102.0, -103.0, -104.0]], [[-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], 
[[-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], [[[-141.0, -142.0, -143.0], [-144.0, -145.0, 
-146.0], [-147.0, -148.0, -149.0]], [[-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, -163.0, -164.0]], [[-171.0, 
-172.0, -173.0], [-174.0, -175.0, -176.0], [-177.0, -178.0, -179.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 3, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PLLN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,2:,2:]
      ref=Data(numpy.array([[[126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RRLL(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,1:2,2:,2:]
      ref=Data(numpy.array([[[[68.0], [71.0], [74.0]]], [[[113.0], [116.0], [119.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-68.0], [-71.0], [-74.0]]], [[[-113.0], [-116.0], [-119.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UUUU(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,:2,:4,:2]
      ref=Data(numpy.array([[[[0.0, 1.0], [3.0, 4.0], [6.0, 7.0], [9.0, 10.0]], [[15.0, 16.0], [18.0, 19.0], [21.0, 22.0], 
[24.0, 25.0]]], [[[45.0, 46.0], [48.0, 49.0], [51.0, 52.0], [54.0, 55.0]], [[60.0, 61.0], [63.0, 64.0], [66.0, 67.0], [69.0, 
70.0]]], [[[90.0, 91.0], [93.0, 94.0], [96.0, 97.0], [99.0, 100.0]], [[105.0, 106.0], [108.0, 109.0], [111.0, 112.0], [114.0, 
115.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-0.0, -1.0], [-3.0, -4.0], [-6.0, -7.0], [-9.0, -10.0]], [[-15.0, -16.0], [-18.0, 
-19.0], [-21.0, -22.0], [-24.0, -25.0]]], [[[-45.0, -46.0], [-48.0, -49.0], [-51.0, -52.0], [-54.0, -55.0]], [[-60.0, -61.0], 
[-63.0, -64.0], [-66.0, -67.0], [-69.0, -70.0]]], [[[-90.0, -91.0], [-93.0, -94.0], [-96.0, -97.0], [-99.0, -100.0]], [[-105.0, 
-106.0], [-108.0, -109.0], [-111.0, -112.0], [-114.0, -115.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 4, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UPUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,1,:4]
      ref=Data(numpy.array([[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0]], [[60.0, 61.0, 
62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 
112.0, 113.0], [114.0, 115.0, 116.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, 
-26.0]], [[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LCUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,:,:4]
      ref=Data(numpy.array([[[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[105.0, 
106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]], [[120.0, 121.0, 122.0], [123.0, 124.0, 
125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0]]], [[[135.0, 136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], 
[144.0, 145.0, 146.0]], [[150.0, 151.0, 152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0]], [[165.0, 
166.0, 167.0], [168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-90.0, -91.0, -92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, 
-101.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0]]], [[[-135.0, -136.0, -137.0], 
[-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, 
-155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, 
-172.0, -173.0], [-174.0, -175.0, -176.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UPPU(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,1,2,:2]
      ref=Data(numpy.array([[21.0, 22.0], [66.0, 67.0], [111.0, 112.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-21.0, -22.0], [-66.0, -67.0], [-111.0, -112.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LLUL(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,2:,:4,2:]
      ref=Data(numpy.array([[[[122.0], [125.0], [128.0], [131.0]]], [[[167.0], [170.0], [173.0], [176.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-122.0], [-125.0], [-128.0], [-131.0]]], [[[-167.0], [-170.0], [-173.0], 
[-176.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 4, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RLLN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,2:,2:]
      ref=Data(numpy.array([[[[81.0, 82.0, 83.0], [84.0, 85.0, 86.0], [87.0, 88.0, 89.0]]], [[[126.0, 127.0, 128.0], [129.0, 
130.0, 131.0], [132.0, 133.0, 134.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-126.0, 
-127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CLUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,2:,:4]
      ref=Data(numpy.array([[[[30.0, 31.0, 32.0], [33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0]]], [[[75.0, 76.0, 
77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0]]], [[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 
127.0, 128.0], [129.0, 130.0, 131.0]]], [[[165.0, 166.0, 167.0], [168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 
176.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, 
-41.0]]], [[[-75.0, -76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0]]], [[[-120.0, -121.0, 
-122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0]]], [[[-165.0, -166.0, -167.0], [-168.0, 
-169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 1, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PCPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,:,2]
      ref=Data(numpy.array([[96.0, 97.0, 98.0], [111.0, 112.0, 113.0], [126.0, 127.0, 128.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-96.0, -97.0, -98.0], [-111.0, -112.0, -113.0], [-126.0, -127.0, -128.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LLCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,2:,:]
      ref=Data(numpy.array([[[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], 
[132.0, 133.0, 134.0]]], [[[165.0, 166.0, 167.0], [168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 
178.0, 179.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-120.0, -121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], 
[-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], [[[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, 
-173.0], [-174.0, -175.0, -176.0], [-177.0, -178.0, -179.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UUUC(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,:2,:4,:]
      ref=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[15.0, 16.0, 17.0], 
[18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], [51.0, 52.0, 53.0], 
[54.0, 55.0, 56.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0]]], [[[90.0, 91.0, 92.0], 
[93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 
113.0], [114.0, 115.0, 116.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0]]], [[[-45.0, -46.0, -47.0], [-48.0, 
-49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0]], [[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, 
-68.0], [-69.0, -70.0, -71.0]]], [[[-90.0, -91.0, -92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, 
-101.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RRRP(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,1:2,1:4,1]
      ref=Data(numpy.array([[[64.0, 67.0, 70.0]], [[109.0, 112.0, 115.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-64.0, -67.0, -70.0]], [[-109.0, -112.0, -115.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LURN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,:2,1:4]
      ref=Data(numpy.array([[[[93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[108.0, 109.0, 110.0], [111.0, 
112.0, 113.0], [114.0, 115.0, 116.0]]], [[[138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0]], [[153.0, 154.0, 
155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0]], [[-108.0, 
-109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]], [[[-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], 
[-144.0, -145.0, -146.0]], [[-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UUUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,:2,:4]
      ref=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[15.0, 16.0, 17.0], 
[18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], [51.0, 52.0, 53.0], 
[54.0, 55.0, 56.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0]]], [[[90.0, 91.0, 92.0], 
[93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 
113.0], [114.0, 115.0, 116.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0]]], [[[-45.0, -46.0, -47.0], [-48.0, 
-49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0]], [[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, 
-68.0], [-69.0, -70.0, -71.0]]], [[[-90.0, -91.0, -92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, 
-101.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PLCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,2:,:]
      ref=Data(numpy.array([[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], 
[132.0, 133.0, 134.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-120.0, -121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, 
-130.0, -131.0], [-132.0, -133.0, -134.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RCCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,:,:]
      ref=Data(numpy.array([[[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], [51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 
59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 
77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], [87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 
95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 
112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], [[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 
128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, 
-56.0], [-57.0, -58.0, -59.0]], [[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], 
[-72.0, -73.0, -74.0]], [[-75.0, -76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, 
-88.0, -89.0]]], [[[-90.0, -91.0, -92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, 
-103.0, -104.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], 
[-117.0, -118.0, -119.0]], [[-120.0, -121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, 
-131.0], [-132.0, -133.0, -134.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LUUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,:2,:4]
      ref=Data(numpy.array([[[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[105.0, 
106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]]], [[[135.0, 136.0, 137.0], [138.0, 139.0, 
140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0]], [[150.0, 151.0, 152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], 
[159.0, 160.0, 161.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-90.0, -91.0, -92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, 
-101.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]], [[[-135.0, 
-136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0]], [[-150.0, -151.0, -152.0], 
[-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RLRN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,2:,1:4]
      ref=Data(numpy.array([[[[78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0]]], [[[123.0, 124.0, 125.0], [126.0, 
127.0, 128.0], [129.0, 130.0, 131.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0]]], [[[-123.0, 
-124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RPUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,1,:4]
      ref=Data(numpy.array([[[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0]], [[105.0, 106.0, 
107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, 
-71.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UURR(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,:2,1:4,1:2]
      ref=Data(numpy.array([[[[4.0], [7.0], [10.0]], [[19.0], [22.0], [25.0]]], [[[49.0], [52.0], [55.0]], [[64.0], [67.0], 
[70.0]]], [[[94.0], [97.0], [100.0]], [[109.0], [112.0], [115.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-4.0], [-7.0], [-10.0]], [[-19.0], [-22.0], [-25.0]]], [[[-49.0], [-52.0], [-55.0]], 
[[-64.0], [-67.0], [-70.0]]], [[[-94.0], [-97.0], [-100.0]], [[-109.0], [-112.0], [-115.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CCCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,:,:]
      ref=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 3, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PPRN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,1,1:4]
      ref=Data(numpy.array([[108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PRUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,1:2,:4]
      ref=Data(numpy.array([[[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 
116.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, 
-115.0, -116.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_ULRN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,2:,1:4]
      ref=Data(numpy.array([[[[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0]]], [[[78.0, 79.0, 80.0], [81.0, 82.0, 
83.0], [84.0, 85.0, 86.0]]], [[[123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0]]], [[[-78.0, 
-79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0]]], [[[-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, 
-130.0, -131.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PCLN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,:,2:]
      ref=Data(numpy.array([[[96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 104.0]], [[111.0, 112.0, 113.0], [114.0, 
115.0, 116.0], [117.0, 118.0, 119.0]], [[126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 
134.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-111.0, 
-112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], 
[-132.0, -133.0, -134.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RRUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,1:2,:4]
      ref=Data(numpy.array([[[[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0]]], [[[105.0, 
106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, 
-71.0]]], [[[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LPPP(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,1,2,1]
      ref=Data(numpy.array([112.0, 157.0]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-112.0, -157.0]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LRUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,1:2,:4]
      ref=Data(numpy.array([[[[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]]], 
[[[150.0, 151.0, 152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], 
[-114.0, -115.0, -116.0]]], [[[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, 
-161.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RRUR(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,1:2,:4,1:2]
      ref=Data(numpy.array([[[[61.0], [64.0], [67.0], [70.0]]], [[[106.0], [109.0], [112.0], [115.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-61.0], [-64.0], [-67.0], [-70.0]]], [[[-106.0], [-109.0], [-112.0], [-115.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 4, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CPRN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,1,1:4]
      ref=Data(numpy.array([[[18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0]], [[63.0, 64.0, 65.0], [66.0, 67.0, 
68.0], [69.0, 70.0, 71.0]], [[108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]], [[153.0, 154.0, 155.0], 
[156.0, 157.0, 158.0], [159.0, 160.0, 161.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0]], [[-63.0, -64.0, 
-65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]], [[-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, 
-116.0]], [[-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RLUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,2:,:4]
      ref=Data(numpy.array([[[[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0]]], [[[120.0, 
121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-75.0, -76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, 
-86.0]]], [[[-120.0, -121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UCCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,:,:]
      ref=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 
134.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CLCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,2:,:]
      ref=Data(numpy.array([[[[30.0, 31.0, 32.0], [33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 
44.0]]], [[[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], [87.0, 88.0, 89.0]]], [[[120.0, 
121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[165.0, 166.0, 
167.0], [168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, 
-41.0], [-42.0, -43.0, -44.0]]], [[[-75.0, -76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], 
[-87.0, -88.0, -89.0]]], [[[-120.0, -121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, 
-131.0], [-132.0, -133.0, -134.0]]], [[[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, 
-175.0, -176.0], [-177.0, -178.0, -179.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 1, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CPLN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,1,2:]
      ref=Data(numpy.array([[[21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[66.0, 67.0, 68.0], [69.0, 70.0, 
71.0], [72.0, 73.0, 74.0]], [[111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], [[156.0, 157.0, 158.0], 
[159.0, 160.0, 161.0], [162.0, 163.0, 164.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, -28.0, -29.0]], [[-66.0, -67.0, 
-68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, 
-119.0]], [[-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, -163.0, -164.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UULN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,:2,2:]
      ref=Data(numpy.array([[[[6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], [[21.0, 22.0, 23.0], [24.0, 25.0, 26.0], 
[27.0, 28.0, 29.0]]], [[[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[66.0, 67.0, 68.0], [69.0, 70.0, 71.0], 
[72.0, 73.0, 74.0]]], [[[96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 104.0]], [[111.0, 112.0, 113.0], [114.0, 
115.0, 116.0], [117.0, 118.0, 119.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], [-12.0, -13.0, -14.0]], [[-21.0, -22.0, 
-23.0], [-24.0, -25.0, -26.0], [-27.0, -28.0, -29.0]]], [[[-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]]], [[[-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], 
[-102.0, -103.0, -104.0]], [[-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PLRN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,2:,1:4]
      ref=Data(numpy.array([[[123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LCPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,:,2]
      ref=Data(numpy.array([[[96.0, 97.0, 98.0], [111.0, 112.0, 113.0], [126.0, 127.0, 128.0]], [[141.0, 142.0, 143.0], [156.0, 
157.0, 158.0], [171.0, 172.0, 173.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-96.0, -97.0, -98.0], [-111.0, -112.0, -113.0], [-126.0, -127.0, -128.0]], [[-141.0, 
-142.0, -143.0], [-156.0, -157.0, -158.0], [-171.0, -172.0, -173.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CULN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,:2,2:]
      ref=Data(numpy.array([[[[6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], [[21.0, 22.0, 23.0], [24.0, 25.0, 26.0], 
[27.0, 28.0, 29.0]]], [[[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[66.0, 67.0, 68.0], [69.0, 70.0, 71.0], 
[72.0, 73.0, 74.0]]], [[[96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 104.0]], [[111.0, 112.0, 113.0], [114.0, 
115.0, 116.0], [117.0, 118.0, 119.0]]], [[[141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[156.0, 157.0, 
158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], [-12.0, -13.0, -14.0]], [[-21.0, -22.0, 
-23.0], [-24.0, -25.0, -26.0], [-27.0, -28.0, -29.0]]], [[[-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]]], [[[-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], 
[-102.0, -103.0, -104.0]], [[-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]]], [[[-141.0, -142.0, 
-143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, -149.0]], [[-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 2, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PRLN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,1:2,2:]
      ref=Data(numpy.array([[[111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CPPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,1,2]
      ref=Data(numpy.array([[21.0, 22.0, 23.0], [66.0, 67.0, 68.0], [111.0, 112.0, 113.0], [156.0, 157.0, 
158.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-21.0, -22.0, -23.0], [-66.0, -67.0, -68.0], [-111.0, -112.0, -113.0], [-156.0, 
-157.0, -158.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RCUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,:,:4]
      ref=Data(numpy.array([[[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], [51.0, 52.0, 53.0], [54.0, 55.0, 56.0]], [[60.0, 61.0, 
62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 
83.0], [84.0, 85.0, 86.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[105.0, 
106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]], [[120.0, 121.0, 122.0], [123.0, 124.0, 
125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, 
-56.0]], [[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]], [[-75.0, -76.0, -77.0], 
[-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0]]], [[[-90.0, -91.0, -92.0], [-93.0, -94.0, -95.0], [-96.0, 
-97.0, -98.0], [-99.0, -100.0, -101.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], 
[-114.0, -115.0, -116.0]], [[-120.0, -121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, 
-131.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PLPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,2:,2]
      ref=Data(numpy.array([[126.0, 127.0, 128.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-126.0, -127.0, -128.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UCLN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,:,2:]
      ref=Data(numpy.array([[[[6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], [[21.0, 22.0, 23.0], [24.0, 25.0, 26.0], 
[27.0, 28.0, 29.0]], [[36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], 
[57.0, 58.0, 59.0]], [[66.0, 67.0, 68.0], [69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 104.0]], [[111.0, 112.0, 113.0], [114.0, 
115.0, 116.0], [117.0, 118.0, 119.0]], [[126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 
134.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], [-12.0, -13.0, -14.0]], [[-21.0, -22.0, 
-23.0], [-24.0, -25.0, -26.0], [-27.0, -28.0, -29.0]], [[-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, -44.0]]], 
[[[-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], [[-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, 
-73.0, -74.0]], [[-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-96.0, -97.0, -98.0], [-99.0, 
-100.0, -101.0], [-102.0, -103.0, -104.0]], [[-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], 
[[-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PCRN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,:,1:4]
      ref=Data(numpy.array([[[93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[108.0, 109.0, 110.0], [111.0, 
112.0, 113.0], [114.0, 115.0, 116.0]], [[123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 
131.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0]], [[-108.0, 
-109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]], [[-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], 
[-129.0, -130.0, -131.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CCPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,:,2]
      ref=Data(numpy.array([[[6.0, 7.0, 8.0], [21.0, 22.0, 23.0], [36.0, 37.0, 38.0]], [[51.0, 52.0, 53.0], [66.0, 67.0, 68.0], 
[81.0, 82.0, 83.0]], [[96.0, 97.0, 98.0], [111.0, 112.0, 113.0], [126.0, 127.0, 128.0]], [[141.0, 142.0, 143.0], [156.0, 157.0, 
158.0], [171.0, 172.0, 173.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-6.0, -7.0, -8.0], [-21.0, -22.0, -23.0], [-36.0, -37.0, -38.0]], [[-51.0, -52.0, 
-53.0], [-66.0, -67.0, -68.0], [-81.0, -82.0, -83.0]], [[-96.0, -97.0, -98.0], [-111.0, -112.0, -113.0], [-126.0, -127.0, 
-128.0]], [[-141.0, -142.0, -143.0], [-156.0, -157.0, -158.0], [-171.0, -172.0, -173.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_URLN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,1:2,2:]
      ref=Data(numpy.array([[[[21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]]], [[[66.0, 67.0, 68.0], [69.0, 70.0, 
71.0], [72.0, 73.0, 74.0]]], [[[111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, -28.0, -29.0]]], [[[-66.0, 
-67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]]], [[[-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, 
-118.0, -119.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RURN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,:2,1:4]
      ref=Data(numpy.array([[[[48.0, 49.0, 50.0], [51.0, 52.0, 53.0], [54.0, 55.0, 56.0]], [[63.0, 64.0, 65.0], [66.0, 67.0, 
68.0], [69.0, 70.0, 71.0]]], [[[93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[108.0, 109.0, 110.0], [111.0, 
112.0, 113.0], [114.0, 115.0, 116.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0]], [[-63.0, -64.0, 
-65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]]], [[[-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, 
-101.0]], [[-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RLCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,2:,:]
      ref=Data(numpy.array([[[[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], [87.0, 88.0, 
89.0]]], [[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 
134.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-75.0, -76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, 
-86.0], [-87.0, -88.0, -89.0]]], [[[-120.0, -121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, 
-130.0, -131.0], [-132.0, -133.0, -134.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CCUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,:,:4]
      ref=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[15.0, 16.0, 17.0], 
[18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0]], [[30.0, 31.0, 32.0], [33.0, 34.0, 35.0], [36.0, 37.0, 38.0], 
[39.0, 40.0, 41.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], [51.0, 52.0, 53.0], [54.0, 55.0, 56.0]], [[60.0, 61.0, 62.0], 
[63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], 
[84.0, 85.0, 86.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[105.0, 106.0, 
107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]], [[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], 
[126.0, 127.0, 128.0], [129.0, 130.0, 131.0]]], [[[135.0, 136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 
145.0, 146.0]], [[150.0, 151.0, 152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0]], [[165.0, 166.0, 
167.0], [168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0]], [[-30.0, -31.0, -32.0], [-33.0, 
-34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, 
-53.0], [-54.0, -55.0, -56.0]], [[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]], 
[[-75.0, -76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0]]], [[[-90.0, -91.0, -92.0], [-93.0, 
-94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, 
-112.0, -113.0], [-114.0, -115.0, -116.0]], [[-120.0, -121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], 
[-129.0, -130.0, -131.0]]], [[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, 
-146.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0]], [[-165.0, 
-166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 3, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CLLN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,2:,2:]
      ref=Data(numpy.array([[[[36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[81.0, 82.0, 83.0], [84.0, 85.0, 
86.0], [87.0, 88.0, 89.0]]], [[[126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[171.0, 172.0, 173.0], 
[174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, -44.0]]], [[[-81.0, 
-82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, 
-133.0, -134.0]]], [[[-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], [-177.0, -178.0, -179.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CURN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,:2,1:4]
      ref=Data(numpy.array([[[[3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[18.0, 19.0, 20.0], [21.0, 22.0, 23.0], 
[24.0, 25.0, 26.0]]], [[[48.0, 49.0, 50.0], [51.0, 52.0, 53.0], [54.0, 55.0, 56.0]], [[63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0]]], [[[93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[108.0, 109.0, 110.0], [111.0, 112.0, 
113.0], [114.0, 115.0, 116.0]]], [[[138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0]], [[153.0, 154.0, 
155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], [[-18.0, -19.0, 
-20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0]]], [[[-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0]], 
[[-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]]], [[[-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, 
-100.0, -101.0]], [[-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]], [[[-138.0, -139.0, -140.0], 
[-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0]], [[-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, 
-161.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 2, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PRPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,1:2,2]
      ref=Data(numpy.array([[111.0, 112.0, 113.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-111.0, -112.0, -113.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_URRN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,1:2,1:4]
      ref=Data(numpy.array([[[[18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0]]], [[[63.0, 64.0, 65.0], [66.0, 67.0, 
68.0], [69.0, 70.0, 71.0]]], [[[108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0]]], [[[-63.0, 
-64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]]], [[[-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, 
-115.0, -116.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LRRN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,1:2,1:4]
      ref=Data(numpy.array([[[[108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]]], [[[153.0, 154.0, 155.0], 
[156.0, 157.0, 158.0], [159.0, 160.0, 161.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]], 
[[[-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_URUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,1:2,:4]
      ref=Data(numpy.array([[[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0]]], [[[60.0, 61.0, 
62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0]]], [[[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 
112.0, 113.0], [114.0, 115.0, 116.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, 
-26.0]]], [[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]]], [[[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 1, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LLLN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,2:,2:]
      ref=Data(numpy.array([[[[126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[171.0, 172.0, 173.0], 
[174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], [-177.0, -178.0, -179.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LPRN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,1,1:4]
      ref=Data(numpy.array([[[108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]], [[153.0, 154.0, 155.0], 
[156.0, 157.0, 158.0], [159.0, 160.0, 161.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]], 
[[-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CPCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,1,:]
      ref=Data(numpy.array([[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 
29.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[105.0, 106.0, 
107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], [[150.0, 151.0, 152.0], 
[153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, 
-26.0], [-27.0, -28.0, -29.0]], [[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], 
[-72.0, -73.0, -74.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, 
-116.0], [-117.0, -118.0, -119.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, 
-160.0, -161.0], [-162.0, -163.0, -164.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CRCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,1:2,:]
      ref=Data(numpy.array([[[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 
29.0]]], [[[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0], [72.0, 73.0, 74.0]]], [[[105.0, 
106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]]], [[[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, 
-26.0], [-27.0, -28.0, -29.0]]], [[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], 
[-72.0, -73.0, -74.0]]], [[[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, 
-116.0], [-117.0, -118.0, -119.0]]], [[[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, 
-160.0, -161.0], [-162.0, -163.0, -164.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 1, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LPLN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,1,2:]
      ref=Data(numpy.array([[[111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], [[156.0, 157.0, 158.0], 
[159.0, 160.0, 161.0], [162.0, 163.0, 164.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], 
[[-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, -163.0, -164.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RCLN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,:,2:]
      ref=Data(numpy.array([[[[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[66.0, 67.0, 68.0], [69.0, 70.0, 
71.0], [72.0, 73.0, 74.0]], [[81.0, 82.0, 83.0], [84.0, 85.0, 86.0], [87.0, 88.0, 89.0]]], [[[96.0, 97.0, 98.0], [99.0, 100.0, 
101.0], [102.0, 103.0, 104.0]], [[111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], [[126.0, 127.0, 128.0], 
[129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], [[-66.0, -67.0, 
-68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], 
[[[-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-111.0, -112.0, -113.0], [-114.0, -115.0, 
-116.0], [-117.0, -118.0, -119.0]], [[-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CCCC(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,:,:,:]
      ref=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 3, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LULN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,:2,2:]
      ref=Data(numpy.array([[[[96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 104.0]], [[111.0, 112.0, 113.0], [114.0, 
115.0, 116.0], [117.0, 118.0, 119.0]]], [[[141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[156.0, 157.0, 
158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-111.0, 
-112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]]], [[[-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], 
[-147.0, -148.0, -149.0]], [[-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, -163.0, -164.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PCUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,:,:4]
      ref=Data(numpy.array([[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[105.0, 106.0, 
107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]], [[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], 
[126.0, 127.0, 128.0], [129.0, 130.0, 131.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-90.0, -91.0, -92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, 
-101.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LRPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,1:2,2]
      ref=Data(numpy.array([[[111.0, 112.0, 113.0]], [[156.0, 157.0, 158.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-111.0, -112.0, -113.0]], [[-156.0, -157.0, -158.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RUCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,:2,:]
      ref=Data(numpy.array([[[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], [51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 
59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0], [72.0, 73.0, 74.0]]], [[[90.0, 91.0, 
92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 104.0]], [[105.0, 106.0, 107.0], [108.0, 
109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, 
-56.0], [-57.0, -58.0, -59.0]], [[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], 
[-72.0, -73.0, -74.0]]], [[[-90.0, -91.0, -92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], 
[-102.0, -103.0, -104.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, 
-116.0], [-117.0, -118.0, -119.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CRUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,1:2,:4]
      ref=Data(numpy.array([[[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0]]], [[[60.0, 61.0, 
62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0]]], [[[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 
112.0, 113.0], [114.0, 115.0, 116.0]]], [[[150.0, 151.0, 152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 
161.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, 
-26.0]]], [[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]]], [[[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]], [[[-150.0, -151.0, -152.0], [-153.0, 
-154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 1, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LPCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,1,:]
      ref=Data(numpy.array([[[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], 
[117.0, 118.0, 119.0]], [[150.0, 151.0, 152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 
163.0, 164.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, 
-115.0, -116.0], [-117.0, -118.0, -119.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], 
[-159.0, -160.0, -161.0], [-162.0, -163.0, -164.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UPPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,1,2]
      ref=Data(numpy.array([[21.0, 22.0, 23.0], [66.0, 67.0, 68.0], [111.0, 112.0, 113.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-21.0, -22.0, -23.0], [-66.0, -67.0, -68.0], [-111.0, -112.0, -113.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CCRN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,:,1:4]
      ref=Data(numpy.array([[[[3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[18.0, 19.0, 20.0], [21.0, 22.0, 23.0], 
[24.0, 25.0, 26.0]], [[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0]]], [[[48.0, 49.0, 50.0], [51.0, 52.0, 53.0], 
[54.0, 55.0, 56.0]], [[63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0]], [[78.0, 79.0, 80.0], [81.0, 82.0, 83.0], 
[84.0, 85.0, 86.0]]], [[[93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[108.0, 109.0, 110.0], [111.0, 112.0, 
113.0], [114.0, 115.0, 116.0]], [[123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0]]], [[[138.0, 139.0, 
140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0]], [[153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0]], 
[[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], [[-18.0, -19.0, 
-20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0]], [[-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0]]], 
[[[-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0]], [[-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, 
-70.0, -71.0]], [[-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0]]], [[[-93.0, -94.0, -95.0], [-96.0, -97.0, 
-98.0], [-99.0, -100.0, -101.0]], [[-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]], [[-123.0, 
-124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0]]], [[[-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], 
[-144.0, -145.0, -146.0]], [[-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0]], [[-168.0, -169.0, 
-170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 3, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PCCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,:,:]
      ref=Data(numpy.array([[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 
134.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-90.0, -91.0, -92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, 
-101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, 
-115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, -121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], 
[-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UUPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,:2,2]
      ref=Data(numpy.array([[[6.0, 7.0, 8.0], [21.0, 22.0, 23.0]], [[51.0, 52.0, 53.0], [66.0, 67.0, 68.0]], [[96.0, 97.0, 
98.0], [111.0, 112.0, 113.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-6.0, -7.0, -8.0], [-21.0, -22.0, -23.0]], [[-51.0, -52.0, -53.0], [-66.0, -67.0, 
-68.0]], [[-96.0, -97.0, -98.0], [-111.0, -112.0, -113.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CCCR(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,:,:,1:2]
      ref=Data(numpy.array([[[[1.0], [4.0], [7.0], [10.0], [13.0]], [[16.0], [19.0], [22.0], [25.0], [28.0]], [[31.0], [34.0], 
[37.0], [40.0], [43.0]]], [[[46.0], [49.0], [52.0], [55.0], [58.0]], [[61.0], [64.0], [67.0], [70.0], [73.0]], [[76.0], [79.0], 
[82.0], [85.0], [88.0]]], [[[91.0], [94.0], [97.0], [100.0], [103.0]], [[106.0], [109.0], [112.0], [115.0], [118.0]], [[121.0], 
[124.0], [127.0], [130.0], [133.0]]], [[[136.0], [139.0], [142.0], [145.0], [148.0]], [[151.0], [154.0], [157.0], [160.0], 
[163.0]], [[166.0], [169.0], [172.0], [175.0], [178.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-1.0], [-4.0], [-7.0], [-10.0], [-13.0]], [[-16.0], [-19.0], [-22.0], [-25.0], 
[-28.0]], [[-31.0], [-34.0], [-37.0], [-40.0], [-43.0]]], [[[-46.0], [-49.0], [-52.0], [-55.0], [-58.0]], [[-61.0], [-64.0], 
[-67.0], [-70.0], [-73.0]], [[-76.0], [-79.0], [-82.0], [-85.0], [-88.0]]], [[[-91.0], [-94.0], [-97.0], [-100.0], [-103.0]], 
[[-106.0], [-109.0], [-112.0], [-115.0], [-118.0]], [[-121.0], [-124.0], [-127.0], [-130.0], [-133.0]]], [[[-136.0], [-139.0], 
[-142.0], [-145.0], [-148.0]], [[-151.0], [-154.0], [-157.0], [-160.0], [-163.0]], [[-166.0], [-169.0], [-172.0], [-175.0], 
[-178.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 3, 5, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UPLN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,1,2:]
      ref=Data(numpy.array([[[21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[66.0, 67.0, 68.0], [69.0, 70.0, 
71.0], [72.0, 73.0, 74.0]], [[111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, -28.0, -29.0]], [[-66.0, -67.0, 
-68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, 
-119.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PPPP(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,1,2,1]
      ref=Data(112.0,self.functionspace)
      ref.setTaggedValue(1,-112.0)
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UPRN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,1,1:4]
      ref=Data(numpy.array([[[18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0]], [[63.0, 64.0, 65.0], [66.0, 67.0, 
68.0], [69.0, 70.0, 71.0]], [[108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0]], [[-63.0, -64.0, 
-65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]], [[-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, 
-116.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PUCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,:2,:]
      ref=Data(numpy.array([[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 
119.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-90.0, -91.0, -92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, 
-101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, 
-115.0, -116.0], [-117.0, -118.0, -119.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_ULPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,2:,2]
      ref=Data(numpy.array([[[36.0, 37.0, 38.0]], [[81.0, 82.0, 83.0]], [[126.0, 127.0, 128.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-36.0, -37.0, -38.0]], [[-81.0, -82.0, -83.0]], [[-126.0, -127.0, -128.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 1, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PPLN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,1,2:]
      ref=Data(numpy.array([[111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CLPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,2:,2]
      ref=Data(numpy.array([[[36.0, 37.0, 38.0]], [[81.0, 82.0, 83.0]], [[126.0, 127.0, 128.0]], [[171.0, 172.0, 
173.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-36.0, -37.0, -38.0]], [[-81.0, -82.0, -83.0]], [[-126.0, -127.0, -128.0]], [[-171.0, 
-172.0, -173.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 1, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PURN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,:2,1:4]
      ref=Data(numpy.array([[[93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[108.0, 109.0, 110.0], [111.0, 
112.0, 113.0], [114.0, 115.0, 116.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0]], [[-108.0, 
-109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LLLL(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,2:,2:,2:]
      ref=Data(numpy.array([[[[128.0], [131.0], [134.0]]], [[[173.0], [176.0], [179.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-128.0], [-131.0], [-134.0]]], [[[-173.0], [-176.0], [-179.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3, 1),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PPCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,1,:]
      ref=Data(numpy.array([[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 
118.0, 119.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, 
-115.0, -116.0], [-117.0, -118.0, -119.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RLPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,2:,2]
      ref=Data(numpy.array([[[81.0, 82.0, 83.0]], [[126.0, 127.0, 128.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-81.0, -82.0, -83.0]], [[-126.0, -127.0, -128.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CRPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,1:2,2]
      ref=Data(numpy.array([[[21.0, 22.0, 23.0]], [[66.0, 67.0, 68.0]], [[111.0, 112.0, 113.0]], [[156.0, 157.0, 
158.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-21.0, -22.0, -23.0]], [[-66.0, -67.0, -68.0]], [[-111.0, -112.0, -113.0]], [[-156.0, 
-157.0, -158.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 1, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CRLN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,1:2,2:]
      ref=Data(numpy.array([[[[21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]]], [[[66.0, 67.0, 68.0], [69.0, 70.0, 
71.0], [72.0, 73.0, 74.0]]], [[[111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]]], [[[156.0, 157.0, 158.0], 
[159.0, 160.0, 161.0], [162.0, 163.0, 164.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, -28.0, -29.0]]], [[[-66.0, 
-67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]]], [[[-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, 
-118.0, -119.0]]], [[[-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, -163.0, -164.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RPRN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,1,1:4]
      ref=Data(numpy.array([[[63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0]], [[108.0, 109.0, 110.0], [111.0, 
112.0, 113.0], [114.0, 115.0, 116.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]], [[-108.0, 
-109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LPPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,1,2]
      ref=Data(numpy.array([[111.0, 112.0, 113.0], [156.0, 157.0, 158.0]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[-111.0, -112.0, -113.0], [-156.0, -157.0, -158.0]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CRRN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,1:2,1:4]
      ref=Data(numpy.array([[[[18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0]]], [[[63.0, 64.0, 65.0], [66.0, 67.0, 
68.0], [69.0, 70.0, 71.0]]], [[[108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]]], [[[153.0, 154.0, 155.0], 
[156.0, 157.0, 158.0], [159.0, 160.0, 161.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0]]], [[[-63.0, 
-64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]]], [[[-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, 
-115.0, -116.0]]], [[[-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PRRN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,1:2,1:4]
      ref=Data(numpy.array([[[108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UCUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,:,:4]
      ref=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[15.0, 16.0, 17.0], 
[18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0]], [[30.0, 31.0, 32.0], [33.0, 34.0, 35.0], [36.0, 37.0, 38.0], 
[39.0, 40.0, 41.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], [51.0, 52.0, 53.0], [54.0, 55.0, 56.0]], [[60.0, 61.0, 62.0], 
[63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], 
[84.0, 85.0, 86.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[105.0, 106.0, 
107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]], [[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], 
[126.0, 127.0, 128.0], [129.0, 130.0, 131.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], 
[[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0]], [[-30.0, -31.0, -32.0], [-33.0, 
-34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, 
-53.0], [-54.0, -55.0, -56.0]], [[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]], 
[[-75.0, -76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0]]], [[[-90.0, -91.0, -92.0], [-93.0, 
-94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, 
-112.0, -113.0], [-114.0, -115.0, -116.0]], [[-120.0, -121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], 
[-129.0, -130.0, -131.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 3, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RRRN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,1:2,1:4]
      ref=Data(numpy.array([[[[63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0]]], [[[108.0, 109.0, 110.0], [111.0, 
112.0, 113.0], [114.0, 115.0, 116.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]]], [[[-108.0, 
-109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LCLN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,:,2:]
      ref=Data(numpy.array([[[[96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 104.0]], [[111.0, 112.0, 113.0], [114.0, 
115.0, 116.0], [117.0, 118.0, 119.0]], [[126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[141.0, 142.0, 
143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], 
[[171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-111.0, 
-112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], 
[-132.0, -133.0, -134.0]]], [[[-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, -149.0]], [[-156.0, -157.0, 
-158.0], [-159.0, -160.0, -161.0], [-162.0, -163.0, -164.0]], [[-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], [-177.0, 
-178.0, -179.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PPPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,1,2]
      ref=Data(numpy.array([111.0, 112.0, 113.0]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([-111.0, -112.0, -113.0]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3,),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_URPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,1:2,2]
      ref=Data(numpy.array([[[21.0, 22.0, 23.0]], [[66.0, 67.0, 68.0]], [[111.0, 112.0, 113.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-21.0, -22.0, -23.0]], [[-66.0, -67.0, -68.0]], [[-111.0, -112.0, -113.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 1, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_CPUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:,1,:4]
      ref=Data(numpy.array([[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0]], [[60.0, 61.0, 
62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], [69.0, 70.0, 71.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 
112.0, 113.0], [114.0, 115.0, 116.0]], [[150.0, 151.0, 152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 
161.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, 
-26.0]], [[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]], [[-150.0, -151.0, -152.0], [-153.0, 
-154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(4, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RRPN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,1:2,2]
      ref=Data(numpy.array([[[66.0, 67.0, 68.0]], [[111.0, 112.0, 113.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-66.0, -67.0, -68.0]], [[-111.0, -112.0, -113.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 1, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LCCN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,:,:]
      ref=Data(numpy.array([[[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-90.0, -91.0, -92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, 
-101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, 
-115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, -121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], 
[-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], [[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, 
-143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, -149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, 
-157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, -163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], 
[-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], [-177.0, -178.0, -179.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3, 5, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PULN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,:2,2:]
      ref=Data(numpy.array([[[96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 104.0]], [[111.0, 112.0, 113.0], [114.0, 
115.0, 116.0], [117.0, 118.0, 119.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-111.0, 
-112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_PUUN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2,:2,:4]
      ref=Data(numpy.array([[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[105.0, 106.0, 
107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[-90.0, -91.0, -92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, 
-101.0]], [[-105.0, -106.0, -107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 4, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_RULN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[1:3,:2,2:]
      ref=Data(numpy.array([[[[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[66.0, 67.0, 68.0], [69.0, 70.0, 
71.0], [72.0, 73.0, 74.0]]], [[[96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 104.0]], [[111.0, 112.0, 113.0], 
[114.0, 115.0, 116.0], [117.0, 118.0, 119.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], [[-66.0, -67.0, 
-68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]]], [[[-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, 
-104.0]], [[-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 2, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_LCRN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[2:,:,1:4]
      ref=Data(numpy.array([[[[93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[108.0, 109.0, 110.0], [111.0, 
112.0, 113.0], [114.0, 115.0, 116.0]], [[123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0]]], [[[138.0, 139.0, 
140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0]], [[153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0]], 
[[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0]], [[-108.0, 
-109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]], [[-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], 
[-129.0, -130.0, -131.0]]], [[[-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0]], [[-153.0, -154.0, 
-155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0]], [[-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, 
-175.0, -176.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(2, 3, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_getslice_taggedData_rank4_UURN(self):
      arg=Data(numpy.array([[[[0.0, 1.0, 2.0], [3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0], [12.0, 13.0, 14.0]], 
[[15.0, 16.0, 17.0], [18.0, 19.0, 20.0], [21.0, 22.0, 23.0], [24.0, 25.0, 26.0], [27.0, 28.0, 29.0]], [[30.0, 31.0, 32.0], 
[33.0, 34.0, 35.0], [36.0, 37.0, 38.0], [39.0, 40.0, 41.0], [42.0, 43.0, 44.0]]], [[[45.0, 46.0, 47.0], [48.0, 49.0, 50.0], 
[51.0, 52.0, 53.0], [54.0, 55.0, 56.0], [57.0, 58.0, 59.0]], [[60.0, 61.0, 62.0], [63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0], [72.0, 73.0, 74.0]], [[75.0, 76.0, 77.0], [78.0, 79.0, 80.0], [81.0, 82.0, 83.0], [84.0, 85.0, 86.0], 
[87.0, 88.0, 89.0]]], [[[90.0, 91.0, 92.0], [93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0], [102.0, 103.0, 
104.0]], [[105.0, 106.0, 107.0], [108.0, 109.0, 110.0], [111.0, 112.0, 113.0], [114.0, 115.0, 116.0], [117.0, 118.0, 119.0]], 
[[120.0, 121.0, 122.0], [123.0, 124.0, 125.0], [126.0, 127.0, 128.0], [129.0, 130.0, 131.0], [132.0, 133.0, 134.0]]], [[[135.0, 
136.0, 137.0], [138.0, 139.0, 140.0], [141.0, 142.0, 143.0], [144.0, 145.0, 146.0], [147.0, 148.0, 149.0]], [[150.0, 151.0, 
152.0], [153.0, 154.0, 155.0], [156.0, 157.0, 158.0], [159.0, 160.0, 161.0], [162.0, 163.0, 164.0]], [[165.0, 166.0, 167.0], 
[168.0, 169.0, 170.0], [171.0, 172.0, 173.0], [174.0, 175.0, 176.0], [177.0, 178.0, 179.0]]]]),self.functionspace)
      arg.setTaggedValue(1,numpy.array([[[[-0.0, -1.0, -2.0], [-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0], 
[-12.0, -13.0, -14.0]], [[-15.0, -16.0, -17.0], [-18.0, -19.0, -20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0], [-27.0, 
-28.0, -29.0]], [[-30.0, -31.0, -32.0], [-33.0, -34.0, -35.0], [-36.0, -37.0, -38.0], [-39.0, -40.0, -41.0], [-42.0, -43.0, 
-44.0]]], [[[-45.0, -46.0, -47.0], [-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0], [-57.0, -58.0, -59.0]], 
[[-60.0, -61.0, -62.0], [-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0], [-72.0, -73.0, -74.0]], [[-75.0, 
-76.0, -77.0], [-78.0, -79.0, -80.0], [-81.0, -82.0, -83.0], [-84.0, -85.0, -86.0], [-87.0, -88.0, -89.0]]], [[[-90.0, -91.0, 
-92.0], [-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, -100.0, -101.0], [-102.0, -103.0, -104.0]], [[-105.0, -106.0, 
-107.0], [-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0], [-117.0, -118.0, -119.0]], [[-120.0, 
-121.0, -122.0], [-123.0, -124.0, -125.0], [-126.0, -127.0, -128.0], [-129.0, -130.0, -131.0], [-132.0, -133.0, -134.0]]], 
[[[-135.0, -136.0, -137.0], [-138.0, -139.0, -140.0], [-141.0, -142.0, -143.0], [-144.0, -145.0, -146.0], [-147.0, -148.0, 
-149.0]], [[-150.0, -151.0, -152.0], [-153.0, -154.0, -155.0], [-156.0, -157.0, -158.0], [-159.0, -160.0, -161.0], [-162.0, 
-163.0, -164.0]], [[-165.0, -166.0, -167.0], [-168.0, -169.0, -170.0], [-171.0, -172.0, -173.0], [-174.0, -175.0, -176.0], 
[-177.0, -178.0, -179.0]]]]))
      res=arg[:3,:2,1:4]
      ref=Data(numpy.array([[[[3.0, 4.0, 5.0], [6.0, 7.0, 8.0], [9.0, 10.0, 11.0]], [[18.0, 19.0, 20.0], [21.0, 22.0, 23.0], 
[24.0, 25.0, 26.0]]], [[[48.0, 49.0, 50.0], [51.0, 52.0, 53.0], [54.0, 55.0, 56.0]], [[63.0, 64.0, 65.0], [66.0, 67.0, 68.0], 
[69.0, 70.0, 71.0]]], [[[93.0, 94.0, 95.0], [96.0, 97.0, 98.0], [99.0, 100.0, 101.0]], [[108.0, 109.0, 110.0], [111.0, 112.0, 
113.0], [114.0, 115.0, 116.0]]]]),self.functionspace)
      ref.setTaggedValue(1,numpy.array([[[[-3.0, -4.0, -5.0], [-6.0, -7.0, -8.0], [-9.0, -10.0, -11.0]], [[-18.0, -19.0, 
-20.0], [-21.0, -22.0, -23.0], [-24.0, -25.0, -26.0]]], [[[-48.0, -49.0, -50.0], [-51.0, -52.0, -53.0], [-54.0, -55.0, -56.0]], 
[[-63.0, -64.0, -65.0], [-66.0, -67.0, -68.0], [-69.0, -70.0, -71.0]]], [[[-93.0, -94.0, -95.0], [-96.0, -97.0, -98.0], [-99.0, 
-100.0, -101.0]], [[-108.0, -109.0, -110.0], [-111.0, -112.0, -113.0], [-114.0, -115.0, -116.0]]]]))
      self.assertTrue(isinstance(res,Data),"wrong type of result.")
      self.assertEqual(res.getShape(),(3, 2, 3, 3),"wrong shape of result.")
      self.assertTrue(Lsup(res-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank1_taggedData_L(self):
      arg=Data(numpy.array([8.0, 7.0, 4.0]),self.functionspace)
      val=Data(numpy.array([8.0]),self.functionspace)
      val.setTaggedValue(1,numpy.array([2.0]))
      arg[2:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([8.0, 7.0, 8.0])+(1.-msk_ref)*numpy.array([8.0, 7.0, 2.0])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank1_taggedData_C(self):
      arg=Data(numpy.array([1.0, 5.0, 5.0]),self.functionspace)
      val=Data(numpy.array([8.0, 7.0, 3.0]),self.functionspace)
      val.setTaggedValue(1,numpy.array([3.0, 3.0, 4.0]))
      arg[:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([8.0, 7.0, 3.0])+(1.-msk_ref)*numpy.array([3.0, 3.0, 4.0])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank1_taggedData_U(self):
      arg=Data(numpy.array([2.0, 3.0, 4.0]),self.functionspace)
      val=Data(numpy.array([6.0, 3.0]),self.functionspace)
      val.setTaggedValue(1,numpy.array([3.0, 7.0]))
      arg[:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([6.0, 3.0, 4.0])+(1.-msk_ref)*numpy.array([3.0, 7.0, 4.0])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank1_taggedData_P(self):
      arg=Data(numpy.array([3.0, 6.0, 6.0]),self.functionspace)
      val=Data(1.0,self.functionspace)
      val.setTaggedValue(1,1.0)
      arg[1]=val
      ref=Data(numpy.array([3.0, 1.0, 6.0]),self.functionspace)
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank1_taggedData_R(self):
      arg=Data(numpy.array([5.0, 7.0, 2.0]),self.functionspace)
      val=Data(numpy.array([7.0]),self.functionspace)
      val.setTaggedValue(1,numpy.array([6.0]))
      arg[1:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([5.0, 7.0, 2.0])+(1.-msk_ref)*numpy.array([5.0, 6.0, 2.0])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank2_taggedData_UU(self):
      arg=Data(numpy.array([[1.0, 6.0, 1.0, 8.0], [4.0, 4.0, 5.0, 6.0], [4.0, 7.0, 5.0, 7.0]]),self.functionspace)
      val=Data(numpy.array([[7.0, 7.0, 5.0], [6.0, 3.0, 4.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[4.0, 4.0, 1.0], [5.0, 2.0, 6.0]]))
      arg[:2,:3]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[7.0, 7.0, 5.0, 8.0], [6.0, 3.0, 4.0, 6.0], [4.0, 7.0, 5.0, 
7.0]])+(1.-msk_ref)*numpy.array([[4.0, 4.0, 1.0, 8.0], [5.0, 2.0, 6.0, 6.0], [4.0, 7.0, 5.0, 7.0]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank2_taggedData_LC(self):
      arg=Data(numpy.array([[3.0, 8.0, 1.0, 4.0], [6.0, 1.0, 1.0, 2.0], [4.0, 2.0, 1.0, 7.0]]),self.functionspace)
      val=Data(numpy.array([[8.0, 2.0, 5.0, 4.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[4.0, 4.0, 7.0, 6.0]]))
      arg[2:,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[3.0, 8.0, 1.0, 4.0], [6.0, 1.0, 1.0, 2.0], [8.0, 2.0, 5.0, 
4.0]])+(1.-msk_ref)*numpy.array([[3.0, 8.0, 1.0, 4.0], [6.0, 1.0, 1.0, 2.0], [4.0, 4.0, 7.0, 6.0]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank2_taggedData_LP(self):
      arg=Data(numpy.array([[2.0, 2.0, 3.0, 4.0], [1.0, 6.0, 8.0, 8.0], [4.0, 3.0, 1.0, 1.0]]),self.functionspace)
      val=Data(numpy.array([5.0]),self.functionspace)
      val.setTaggedValue(1,numpy.array([7.0]))
      arg[2:,2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[2.0, 2.0, 3.0, 4.0], [1.0, 6.0, 8.0, 8.0], [4.0, 3.0, 5.0, 
1.0]])+(1.-msk_ref)*numpy.array([[2.0, 2.0, 3.0, 4.0], [1.0, 6.0, 8.0, 8.0], [4.0, 3.0, 7.0, 1.0]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank2_taggedData_RU(self):
      arg=Data(numpy.array([[3.0, 5.0, 3.0, 3.0], [8.0, 1.0, 8.0, 5.0], [1.0, 4.0, 3.0, 1.0]]),self.functionspace)
      val=Data(numpy.array([[6.0, 8.0, 6.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[7.0, 7.0, 4.0]]))
      arg[1:2,:3]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[3.0, 5.0, 3.0, 3.0], [6.0, 8.0, 6.0, 5.0], [1.0, 4.0, 3.0, 
1.0]])+(1.-msk_ref)*numpy.array([[3.0, 5.0, 3.0, 3.0], [7.0, 7.0, 4.0, 5.0], [1.0, 4.0, 3.0, 1.0]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank2_taggedData_PN(self):
      arg=Data(numpy.array([[3.0, 7.0, 3.0, 8.0], [5.0, 2.0, 2.0, 6.0], [5.0, 8.0, 1.0, 6.0]]),self.functionspace)
      val=Data(numpy.array([5.0, 1.0, 7.0, 4.0]),self.functionspace)
      val.setTaggedValue(1,numpy.array([3.0, 5.0, 1.0, 8.0]))
      arg[1]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[3.0, 7.0, 3.0, 8.0], [5.0, 1.0, 7.0, 4.0], [5.0, 8.0, 1.0, 
6.0]])+(1.-msk_ref)*numpy.array([[3.0, 7.0, 3.0, 8.0], [3.0, 5.0, 1.0, 8.0], [5.0, 8.0, 1.0, 6.0]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank2_taggedData_UC(self):
      arg=Data(numpy.array([[4.0, 2.0, 6.0, 2.0], [8.0, 3.0, 1.0, 4.0], [3.0, 3.0, 5.0, 1.0]]),self.functionspace)
      val=Data(numpy.array([[3.0, 3.0, 6.0, 2.0], [7.0, 8.0, 4.0, 5.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[6.0, 7.0, 4.0, 4.0], [3.0, 1.0, 6.0, 3.0]]))
      arg[:2,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[3.0, 3.0, 6.0, 2.0], [7.0, 8.0, 4.0, 5.0], [3.0, 3.0, 5.0, 
1.0]])+(1.-msk_ref)*numpy.array([[6.0, 7.0, 4.0, 4.0], [3.0, 1.0, 6.0, 3.0], [3.0, 3.0, 5.0, 1.0]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank2_taggedData_CN(self):
      arg=Data(numpy.array([[3.0, 8.0, 8.0, 6.0], [4.0, 4.0, 5.0, 2.0], [3.0, 3.0, 7.0, 1.0]]),self.functionspace)
      val=Data(numpy.array([[4.0, 6.0, 4.0, 4.0], [6.0, 4.0, 7.0, 5.0], [1.0, 5.0, 7.0, 3.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[7.0, 5.0, 2.0, 3.0], [6.0, 7.0, 6.0, 3.0], [1.0, 4.0, 8.0, 4.0]]))
      arg[:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[4.0, 6.0, 4.0, 4.0], [6.0, 4.0, 7.0, 5.0], [1.0, 5.0, 7.0, 
3.0]])+(1.-msk_ref)*numpy.array([[7.0, 5.0, 2.0, 3.0], [6.0, 7.0, 6.0, 3.0], [1.0, 4.0, 8.0, 4.0]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank2_taggedData_RR(self):
      arg=Data(numpy.array([[1.0, 8.0, 2.0, 1.0], [4.0, 4.0, 8.0, 4.0], [7.0, 7.0, 8.0, 4.0]]),self.functionspace)
      val=Data(numpy.array([[4.0, 2.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[7.0, 8.0]]))
      arg[1:2,1:3]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[1.0, 8.0, 2.0, 1.0], [4.0, 4.0, 2.0, 4.0], [7.0, 7.0, 8.0, 
4.0]])+(1.-msk_ref)*numpy.array([[1.0, 8.0, 2.0, 1.0], [4.0, 7.0, 8.0, 4.0], [7.0, 7.0, 8.0, 4.0]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank2_taggedData_LR(self):
      arg=Data(numpy.array([[5.0, 4.0, 8.0, 2.0], [5.0, 1.0, 2.0, 4.0], [4.0, 7.0, 6.0, 8.0]]),self.functionspace)
      val=Data(numpy.array([[1.0, 4.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[3.0, 4.0]]))
      arg[2:,1:3]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[5.0, 4.0, 8.0, 2.0], [5.0, 1.0, 2.0, 4.0], [4.0, 1.0, 4.0, 
8.0]])+(1.-msk_ref)*numpy.array([[5.0, 4.0, 8.0, 2.0], [5.0, 1.0, 2.0, 4.0], [4.0, 3.0, 4.0, 8.0]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank2_taggedData_PP(self):
      arg=Data(numpy.array([[4.0, 1.0, 4.0, 6.0], [3.0, 2.0, 2.0, 3.0], [4.0, 1.0, 6.0, 7.0]]),self.functionspace)
      val=Data(1.0,self.functionspace)
      val.setTaggedValue(1,1.0)
      arg[1,2]=val
      ref=Data(numpy.array([[4.0, 1.0, 4.0, 6.0], [3.0, 2.0, 1.0, 3.0], [4.0, 1.0, 6.0, 7.0]]),self.functionspace)
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank2_taggedData_LL(self):
      arg=Data(numpy.array([[6.0, 6.0, 1.0, 7.0], [4.0, 6.0, 3.0, 2.0], [4.0, 7.0, 4.0, 5.0]]),self.functionspace)
      val=Data(numpy.array([[1.0, 3.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[2.0, 5.0]]))
      arg[2:,2:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[6.0, 6.0, 1.0, 7.0], [4.0, 6.0, 3.0, 2.0], [4.0, 7.0, 1.0, 
3.0]])+(1.-msk_ref)*numpy.array([[6.0, 6.0, 1.0, 7.0], [4.0, 6.0, 3.0, 2.0], [4.0, 7.0, 2.0, 5.0]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank2_taggedData_PU(self):
      arg=Data(numpy.array([[2.0, 3.0, 1.0, 7.0], [1.0, 3.0, 3.0, 6.0], [7.0, 2.0, 2.0, 1.0]]),self.functionspace)
      val=Data(numpy.array([8.0, 8.0, 4.0]),self.functionspace)
      val.setTaggedValue(1,numpy.array([8.0, 8.0, 1.0]))
      arg[1,:3]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[2.0, 3.0, 1.0, 7.0], [8.0, 8.0, 4.0, 6.0], [7.0, 2.0, 2.0, 
1.0]])+(1.-msk_ref)*numpy.array([[2.0, 3.0, 1.0, 7.0], [8.0, 8.0, 1.0, 6.0], [7.0, 2.0, 2.0, 1.0]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank2_taggedData_RC(self):
      arg=Data(numpy.array([[8.0, 5.0, 8.0, 4.0], [5.0, 1.0, 6.0, 5.0], [7.0, 7.0, 1.0, 3.0]]),self.functionspace)
      val=Data(numpy.array([[8.0, 8.0, 7.0, 8.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[6.0, 3.0, 7.0, 7.0]]))
      arg[1:2,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[8.0, 5.0, 8.0, 4.0], [8.0, 8.0, 7.0, 8.0], [7.0, 7.0, 1.0, 
3.0]])+(1.-msk_ref)*numpy.array([[8.0, 5.0, 8.0, 4.0], [6.0, 3.0, 7.0, 7.0], [7.0, 7.0, 1.0, 3.0]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank2_taggedData_CP(self):
      arg=Data(numpy.array([[7.0, 2.0, 7.0, 4.0], [6.0, 3.0, 5.0, 8.0], [8.0, 8.0, 3.0, 2.0]]),self.functionspace)
      val=Data(numpy.array([4.0, 8.0, 5.0]),self.functionspace)
      val.setTaggedValue(1,numpy.array([3.0, 4.0, 6.0]))
      arg[:,2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[7.0, 2.0, 4.0, 4.0], [6.0, 3.0, 8.0, 8.0], [8.0, 8.0, 5.0, 
2.0]])+(1.-msk_ref)*numpy.array([[7.0, 2.0, 3.0, 4.0], [6.0, 3.0, 4.0, 8.0], [8.0, 8.0, 6.0, 2.0]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank2_taggedData_LN(self):
      arg=Data(numpy.array([[8.0, 7.0, 8.0, 3.0], [2.0, 6.0, 1.0, 8.0], [2.0, 1.0, 7.0, 8.0]]),self.functionspace)
      val=Data(numpy.array([[8.0, 8.0, 5.0, 7.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[8.0, 2.0, 4.0, 3.0]]))
      arg[2:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[8.0, 7.0, 8.0, 3.0], [2.0, 6.0, 1.0, 8.0], [8.0, 8.0, 5.0, 
7.0]])+(1.-msk_ref)*numpy.array([[8.0, 7.0, 8.0, 3.0], [2.0, 6.0, 1.0, 8.0], [8.0, 2.0, 4.0, 3.0]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank2_taggedData_PR(self):
      arg=Data(numpy.array([[6.0, 3.0, 3.0, 2.0], [5.0, 3.0, 6.0, 5.0], [1.0, 1.0, 4.0, 5.0]]),self.functionspace)
      val=Data(numpy.array([7.0, 2.0]),self.functionspace)
      val.setTaggedValue(1,numpy.array([4.0, 7.0]))
      arg[1,1:3]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[6.0, 3.0, 3.0, 2.0], [5.0, 7.0, 2.0, 5.0], [1.0, 1.0, 4.0, 
5.0]])+(1.-msk_ref)*numpy.array([[6.0, 3.0, 3.0, 2.0], [5.0, 4.0, 7.0, 5.0], [1.0, 1.0, 4.0, 5.0]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank2_taggedData_UL(self):
      arg=Data(numpy.array([[2.0, 3.0, 4.0, 8.0], [6.0, 6.0, 5.0, 4.0], [8.0, 4.0, 2.0, 8.0]]),self.functionspace)
      val=Data(numpy.array([[8.0, 8.0], [6.0, 8.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[8.0, 1.0], [7.0, 1.0]]))
      arg[:2,2:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[2.0, 3.0, 8.0, 8.0], [6.0, 6.0, 6.0, 8.0], [8.0, 4.0, 2.0, 
8.0]])+(1.-msk_ref)*numpy.array([[2.0, 3.0, 8.0, 1.0], [6.0, 6.0, 7.0, 1.0], [8.0, 4.0, 2.0, 8.0]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank2_taggedData_CC(self):
      arg=Data(numpy.array([[2.0, 4.0, 8.0, 3.0], [8.0, 8.0, 6.0, 6.0], [1.0, 3.0, 5.0, 3.0]]),self.functionspace)
      val=Data(numpy.array([[5.0, 8.0, 5.0, 3.0], [7.0, 8.0, 5.0, 2.0], [1.0, 3.0, 3.0, 7.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[4.0, 3.0, 6.0, 1.0], [8.0, 5.0, 2.0, 3.0], [4.0, 4.0, 3.0, 2.0]]))
      arg[:,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[5.0, 8.0, 5.0, 3.0], [7.0, 8.0, 5.0, 2.0], [1.0, 3.0, 3.0, 
7.0]])+(1.-msk_ref)*numpy.array([[4.0, 3.0, 6.0, 1.0], [8.0, 5.0, 2.0, 3.0], [4.0, 4.0, 3.0, 2.0]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank2_taggedData_RN(self):
      arg=Data(numpy.array([[7.0, 1.0, 1.0, 4.0], [6.0, 3.0, 7.0, 4.0], [4.0, 5.0, 7.0, 1.0]]),self.functionspace)
      val=Data(numpy.array([[6.0, 5.0, 3.0, 2.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[8.0, 1.0, 2.0, 5.0]]))
      arg[1:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[7.0, 1.0, 1.0, 4.0], [6.0, 5.0, 3.0, 2.0], [4.0, 5.0, 7.0, 
1.0]])+(1.-msk_ref)*numpy.array([[7.0, 1.0, 1.0, 4.0], [8.0, 1.0, 2.0, 5.0], [4.0, 5.0, 7.0, 1.0]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank2_taggedData_UN(self):
      arg=Data(numpy.array([[6.0, 8.0, 7.0, 5.0], [2.0, 3.0, 8.0, 7.0], [1.0, 7.0, 6.0, 8.0]]),self.functionspace)
      val=Data(numpy.array([[3.0, 8.0, 7.0, 7.0], [8.0, 6.0, 6.0, 5.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[4.0, 3.0, 3.0, 4.0], [4.0, 7.0, 2.0, 2.0]]))
      arg[:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[3.0, 8.0, 7.0, 7.0], [8.0, 6.0, 6.0, 5.0], [1.0, 7.0, 6.0, 
8.0]])+(1.-msk_ref)*numpy.array([[4.0, 3.0, 3.0, 4.0], [4.0, 7.0, 2.0, 2.0], [1.0, 7.0, 6.0, 8.0]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_LLL(self):
      arg=Data(numpy.array([[[8.0, 8.0, 2.0], [5.0, 7.0, 2.0], [6.0, 6.0, 3.0], [8.0, 6.0, 1.0]], [[2.0, 1.0, 3.0], [8.0, 7.0, 
2.0], [3.0, 8.0, 3.0], [6.0, 5.0, 6.0]], [[1.0, 2.0, 6.0], [2.0, 8.0, 1.0], [3.0, 4.0, 4.0], [5.0, 5.0, 
4.0]]]),self.functionspace)
      val=Data(numpy.array([[[5.0], [8.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[7.0], [3.0]]]))
      arg[2:,2:,2:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[8.0, 8.0, 2.0], [5.0, 7.0, 2.0], [6.0, 6.0, 3.0], [8.0, 6.0, 1.0]], [[2.0, 1.0, 3.0], [8.0, 
7.0, 2.0], [3.0, 8.0, 3.0], [6.0, 5.0, 6.0]], [[1.0, 2.0, 6.0], [2.0, 8.0, 1.0], [3.0, 4.0, 5.0], [5.0, 5.0, 
8.0]]])+(1.-msk_ref)*numpy.array([[[8.0, 8.0, 2.0], [5.0, 7.0, 2.0], [6.0, 6.0, 3.0], [8.0, 6.0, 1.0]], [[2.0, 1.0, 3.0], [8.0, 
7.0, 2.0], [3.0, 8.0, 3.0], [6.0, 5.0, 6.0]], [[1.0, 2.0, 6.0], [2.0, 8.0, 1.0], [3.0, 4.0, 7.0], [5.0, 5.0, 3.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_RCC(self):
      arg=Data(numpy.array([[[3.0, 6.0, 2.0], [2.0, 5.0, 3.0], [5.0, 3.0, 3.0], [2.0, 2.0, 6.0]], [[1.0, 1.0, 7.0], [6.0, 2.0, 
5.0], [3.0, 6.0, 2.0], [3.0, 1.0, 6.0]], [[7.0, 4.0, 3.0], [3.0, 5.0, 7.0], [2.0, 4.0, 6.0], [6.0, 5.0, 
7.0]]]),self.functionspace)
      val=Data(numpy.array([[[8.0, 7.0, 4.0], [6.0, 6.0, 4.0], [6.0, 2.0, 5.0], [1.0, 2.0, 2.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[2.0, 2.0, 3.0], [4.0, 1.0, 8.0], [3.0, 8.0, 5.0], [3.0, 8.0, 2.0]]]))
      arg[1:2,:,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[3.0, 6.0, 2.0], [2.0, 5.0, 3.0], [5.0, 3.0, 3.0], [2.0, 2.0, 6.0]], [[8.0, 7.0, 4.0], [6.0, 
6.0, 4.0], [6.0, 2.0, 5.0], [1.0, 2.0, 2.0]], [[7.0, 4.0, 3.0], [3.0, 5.0, 7.0], [2.0, 4.0, 6.0], [6.0, 5.0, 
7.0]]])+(1.-msk_ref)*numpy.array([[[3.0, 6.0, 2.0], [2.0, 5.0, 3.0], [5.0, 3.0, 3.0], [2.0, 2.0, 6.0]], [[2.0, 2.0, 3.0], [4.0, 
1.0, 8.0], [3.0, 8.0, 5.0], [3.0, 8.0, 2.0]], [[7.0, 4.0, 3.0], [3.0, 5.0, 7.0], [2.0, 4.0, 6.0], [6.0, 5.0, 7.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_PPU(self):
      arg=Data(numpy.array([[[1.0, 2.0, 6.0], [2.0, 5.0, 8.0], [2.0, 2.0, 6.0], [4.0, 7.0, 6.0]], [[1.0, 2.0, 3.0], [6.0, 8.0, 
5.0], [2.0, 4.0, 8.0], [8.0, 5.0, 1.0]], [[2.0, 1.0, 1.0], [6.0, 6.0, 8.0], [1.0, 2.0, 6.0], [1.0, 1.0, 
3.0]]]),self.functionspace)
      val=Data(numpy.array([6.0, 6.0]),self.functionspace)
      val.setTaggedValue(1,numpy.array([2.0, 6.0]))
      arg[1,2,:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[1.0, 2.0, 6.0], [2.0, 5.0, 8.0], [2.0, 2.0, 6.0], [4.0, 7.0, 6.0]], [[1.0, 2.0, 3.0], [6.0, 
8.0, 5.0], [6.0, 6.0, 8.0], [8.0, 5.0, 1.0]], [[2.0, 1.0, 1.0], [6.0, 6.0, 8.0], [1.0, 2.0, 6.0], [1.0, 1.0, 
3.0]]])+(1.-msk_ref)*numpy.array([[[1.0, 2.0, 6.0], [2.0, 5.0, 8.0], [2.0, 2.0, 6.0], [4.0, 7.0, 6.0]], [[1.0, 2.0, 3.0], [6.0, 
8.0, 5.0], [2.0, 6.0, 8.0], [8.0, 5.0, 1.0]], [[2.0, 1.0, 1.0], [6.0, 6.0, 8.0], [1.0, 2.0, 6.0], [1.0, 1.0, 3.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_PLU(self):
      arg=Data(numpy.array([[[6.0, 7.0, 3.0], [7.0, 7.0, 8.0], [6.0, 7.0, 6.0], [5.0, 1.0, 1.0]], [[1.0, 3.0, 1.0], [1.0, 6.0, 
7.0], [4.0, 3.0, 1.0], [4.0, 3.0, 5.0]], [[8.0, 3.0, 5.0], [3.0, 8.0, 7.0], [5.0, 8.0, 5.0], [1.0, 8.0, 
3.0]]]),self.functionspace)
      val=Data(numpy.array([[7.0, 4.0], [8.0, 1.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[4.0, 8.0], [5.0, 3.0]]))
      arg[1,2:,:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[6.0, 7.0, 3.0], [7.0, 7.0, 8.0], [6.0, 7.0, 6.0], [5.0, 1.0, 1.0]], [[1.0, 3.0, 1.0], [1.0, 
6.0, 7.0], [7.0, 4.0, 1.0], [8.0, 1.0, 5.0]], [[8.0, 3.0, 5.0], [3.0, 8.0, 7.0], [5.0, 8.0, 5.0], [1.0, 8.0, 
3.0]]])+(1.-msk_ref)*numpy.array([[[6.0, 7.0, 3.0], [7.0, 7.0, 8.0], [6.0, 7.0, 6.0], [5.0, 1.0, 1.0]], [[1.0, 3.0, 1.0], [1.0, 
6.0, 7.0], [4.0, 8.0, 1.0], [5.0, 3.0, 5.0]], [[8.0, 3.0, 5.0], [3.0, 8.0, 7.0], [5.0, 8.0, 5.0], [1.0, 8.0, 3.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_URN(self):
      arg=Data(numpy.array([[[2.0, 2.0, 5.0], [7.0, 3.0, 8.0], [8.0, 6.0, 2.0], [2.0, 2.0, 6.0]], [[6.0, 2.0, 6.0], [6.0, 5.0, 
3.0], [8.0, 1.0, 7.0], [5.0, 1.0, 5.0]], [[3.0, 7.0, 6.0], [4.0, 2.0, 6.0], [3.0, 1.0, 4.0], [3.0, 5.0, 
1.0]]]),self.functionspace)
      val=Data(numpy.array([[[4.0, 7.0, 6.0], [4.0, 4.0, 2.0]], [[7.0, 5.0, 7.0], [7.0, 1.0, 3.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[1.0, 5.0, 5.0], [5.0, 5.0, 6.0]], [[4.0, 8.0, 6.0], [7.0, 3.0, 5.0]]]))
      arg[:2,1:3]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[2.0, 2.0, 5.0], [4.0, 7.0, 6.0], [4.0, 4.0, 2.0], [2.0, 2.0, 6.0]], [[6.0, 2.0, 6.0], [7.0, 
5.0, 7.0], [7.0, 1.0, 3.0], [5.0, 1.0, 5.0]], [[3.0, 7.0, 6.0], [4.0, 2.0, 6.0], [3.0, 1.0, 4.0], [3.0, 5.0, 
1.0]]])+(1.-msk_ref)*numpy.array([[[2.0, 2.0, 5.0], [1.0, 5.0, 5.0], [5.0, 5.0, 6.0], [2.0, 2.0, 6.0]], [[6.0, 2.0, 6.0], [4.0, 
8.0, 6.0], [7.0, 3.0, 5.0], [5.0, 1.0, 5.0]], [[3.0, 7.0, 6.0], [4.0, 2.0, 6.0], [3.0, 1.0, 4.0], [3.0, 5.0, 1.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_PLR(self):
      arg=Data(numpy.array([[[2.0, 7.0, 5.0], [4.0, 6.0, 8.0], [4.0, 8.0, 3.0], [7.0, 5.0, 5.0]], [[8.0, 1.0, 4.0], [3.0, 6.0, 
3.0], [4.0, 3.0, 2.0], [3.0, 4.0, 6.0]], [[8.0, 6.0, 8.0], [5.0, 7.0, 4.0], [1.0, 1.0, 4.0], [3.0, 5.0, 
4.0]]]),self.functionspace)
      val=Data(numpy.array([[3.0], [3.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[7.0], [6.0]]))
      arg[1,2:,1:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[2.0, 7.0, 5.0], [4.0, 6.0, 8.0], [4.0, 8.0, 3.0], [7.0, 5.0, 5.0]], [[8.0, 1.0, 4.0], [3.0, 
6.0, 3.0], [4.0, 3.0, 2.0], [3.0, 3.0, 6.0]], [[8.0, 6.0, 8.0], [5.0, 7.0, 4.0], [1.0, 1.0, 4.0], [3.0, 5.0, 
4.0]]])+(1.-msk_ref)*numpy.array([[[2.0, 7.0, 5.0], [4.0, 6.0, 8.0], [4.0, 8.0, 3.0], [7.0, 5.0, 5.0]], [[8.0, 1.0, 4.0], [3.0, 
6.0, 3.0], [4.0, 7.0, 2.0], [3.0, 6.0, 6.0]], [[8.0, 6.0, 8.0], [5.0, 7.0, 4.0], [1.0, 1.0, 4.0], [3.0, 5.0, 4.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_UCL(self):
      arg=Data(numpy.array([[[4.0, 4.0, 8.0], [7.0, 6.0, 8.0], [8.0, 1.0, 8.0], [6.0, 1.0, 5.0]], [[4.0, 4.0, 5.0], [2.0, 6.0, 
5.0], [3.0, 3.0, 1.0], [4.0, 3.0, 5.0]], [[1.0, 1.0, 4.0], [7.0, 1.0, 6.0], [2.0, 6.0, 6.0], [3.0, 7.0, 
1.0]]]),self.functionspace)
      val=Data(numpy.array([[[8.0], [7.0], [8.0], [1.0]], [[7.0], [8.0], [8.0], [1.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[3.0], [2.0], [1.0], [4.0]], [[1.0], [8.0], [6.0], [5.0]]]))
      arg[:2,:,2:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[4.0, 4.0, 8.0], [7.0, 6.0, 7.0], [8.0, 1.0, 8.0], [6.0, 1.0, 1.0]], [[4.0, 4.0, 7.0], [2.0, 
6.0, 8.0], [3.0, 3.0, 8.0], [4.0, 3.0, 1.0]], [[1.0, 1.0, 4.0], [7.0, 1.0, 6.0], [2.0, 6.0, 6.0], [3.0, 7.0, 
1.0]]])+(1.-msk_ref)*numpy.array([[[4.0, 4.0, 3.0], [7.0, 6.0, 2.0], [8.0, 1.0, 1.0], [6.0, 1.0, 4.0]], [[4.0, 4.0, 1.0], [2.0, 
6.0, 8.0], [3.0, 3.0, 6.0], [4.0, 3.0, 5.0]], [[1.0, 1.0, 4.0], [7.0, 1.0, 6.0], [2.0, 6.0, 6.0], [3.0, 7.0, 1.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_PUU(self):
      arg=Data(numpy.array([[[4.0, 2.0, 5.0], [2.0, 4.0, 1.0], [6.0, 5.0, 4.0], [3.0, 8.0, 3.0]], [[2.0, 1.0, 3.0], [8.0, 5.0, 
8.0], [8.0, 4.0, 6.0], [6.0, 7.0, 2.0]], [[3.0, 1.0, 7.0], [8.0, 6.0, 4.0], [6.0, 8.0, 3.0], [1.0, 3.0, 
4.0]]]),self.functionspace)
      val=Data(numpy.array([[5.0, 2.0], [1.0, 7.0], [7.0, 3.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[5.0, 7.0], [6.0, 2.0], [8.0, 1.0]]))
      arg[1,:3,:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[4.0, 2.0, 5.0], [2.0, 4.0, 1.0], [6.0, 5.0, 4.0], [3.0, 8.0, 3.0]], [[5.0, 2.0, 3.0], [1.0, 
7.0, 8.0], [7.0, 3.0, 6.0], [6.0, 7.0, 2.0]], [[3.0, 1.0, 7.0], [8.0, 6.0, 4.0], [6.0, 8.0, 3.0], [1.0, 3.0, 
4.0]]])+(1.-msk_ref)*numpy.array([[[4.0, 2.0, 5.0], [2.0, 4.0, 1.0], [6.0, 5.0, 4.0], [3.0, 8.0, 3.0]], [[5.0, 7.0, 3.0], [6.0, 
2.0, 8.0], [8.0, 1.0, 6.0], [6.0, 7.0, 2.0]], [[3.0, 1.0, 7.0], [8.0, 6.0, 4.0], [6.0, 8.0, 3.0], [1.0, 3.0, 4.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_ULR(self):
      arg=Data(numpy.array([[[8.0, 4.0, 1.0], [1.0, 5.0, 6.0], [7.0, 6.0, 4.0], [6.0, 6.0, 2.0]], [[3.0, 4.0, 2.0], [4.0, 4.0, 
2.0], [3.0, 4.0, 6.0], [4.0, 1.0, 4.0]], [[2.0, 8.0, 3.0], [1.0, 7.0, 5.0], [7.0, 1.0, 3.0], [2.0, 3.0, 
8.0]]]),self.functionspace)
      val=Data(numpy.array([[[2.0], [7.0]], [[4.0], [8.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[6.0], [5.0]], [[4.0], [7.0]]]))
      arg[:2,2:,1:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[8.0, 4.0, 1.0], [1.0, 5.0, 6.0], [7.0, 2.0, 4.0], [6.0, 7.0, 2.0]], [[3.0, 4.0, 2.0], [4.0, 
4.0, 2.0], [3.0, 4.0, 6.0], [4.0, 8.0, 4.0]], [[2.0, 8.0, 3.0], [1.0, 7.0, 5.0], [7.0, 1.0, 3.0], [2.0, 3.0, 
8.0]]])+(1.-msk_ref)*numpy.array([[[8.0, 4.0, 1.0], [1.0, 5.0, 6.0], [7.0, 6.0, 4.0], [6.0, 5.0, 2.0]], [[3.0, 4.0, 2.0], [4.0, 
4.0, 2.0], [3.0, 4.0, 6.0], [4.0, 7.0, 4.0]], [[2.0, 8.0, 3.0], [1.0, 7.0, 5.0], [7.0, 1.0, 3.0], [2.0, 3.0, 8.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_RUU(self):
      arg=Data(numpy.array([[[7.0, 8.0, 2.0], [8.0, 6.0, 1.0], [1.0, 7.0, 8.0], [1.0, 4.0, 2.0]], [[8.0, 5.0, 8.0], [4.0, 8.0, 
5.0], [6.0, 1.0, 4.0], [7.0, 8.0, 6.0]], [[7.0, 8.0, 1.0], [6.0, 2.0, 8.0], [4.0, 8.0, 1.0], [1.0, 3.0, 
6.0]]]),self.functionspace)
      val=Data(numpy.array([[[2.0, 2.0], [7.0, 3.0], [5.0, 4.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[4.0, 4.0], [6.0, 8.0], [5.0, 7.0]]]))
      arg[1:2,:3,:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[7.0, 8.0, 2.0], [8.0, 6.0, 1.0], [1.0, 7.0, 8.0], [1.0, 4.0, 2.0]], [[2.0, 2.0, 8.0], [7.0, 
3.0, 5.0], [5.0, 4.0, 4.0], [7.0, 8.0, 6.0]], [[7.0, 8.0, 1.0], [6.0, 2.0, 8.0], [4.0, 8.0, 1.0], [1.0, 3.0, 
6.0]]])+(1.-msk_ref)*numpy.array([[[7.0, 8.0, 2.0], [8.0, 6.0, 1.0], [1.0, 7.0, 8.0], [1.0, 4.0, 2.0]], [[4.0, 4.0, 8.0], [6.0, 
8.0, 5.0], [5.0, 7.0, 4.0], [7.0, 8.0, 6.0]], [[7.0, 8.0, 1.0], [6.0, 2.0, 8.0], [4.0, 8.0, 1.0], [1.0, 3.0, 6.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_CRR(self):
      arg=Data(numpy.array([[[6.0, 4.0, 3.0], [4.0, 5.0, 4.0], [3.0, 3.0, 7.0], [1.0, 1.0, 5.0]], [[5.0, 6.0, 5.0], [4.0, 4.0, 
2.0], [8.0, 7.0, 1.0], [8.0, 6.0, 3.0]], [[2.0, 1.0, 7.0], [4.0, 4.0, 2.0], [1.0, 8.0, 5.0], [7.0, 6.0, 
1.0]]]),self.functionspace)
      val=Data(numpy.array([[[1.0], [1.0]], [[8.0], [7.0]], [[4.0], [2.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[3.0], [3.0]], [[1.0], [6.0]], [[6.0], [2.0]]]))
      arg[:,1:3,1:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[6.0, 4.0, 3.0], [4.0, 1.0, 4.0], [3.0, 1.0, 7.0], [1.0, 1.0, 5.0]], [[5.0, 6.0, 5.0], [4.0, 
8.0, 2.0], [8.0, 7.0, 1.0], [8.0, 6.0, 3.0]], [[2.0, 1.0, 7.0], [4.0, 4.0, 2.0], [1.0, 2.0, 5.0], [7.0, 6.0, 
1.0]]])+(1.-msk_ref)*numpy.array([[[6.0, 4.0, 3.0], [4.0, 3.0, 4.0], [3.0, 3.0, 7.0], [1.0, 1.0, 5.0]], [[5.0, 6.0, 5.0], [4.0, 
1.0, 2.0], [8.0, 6.0, 1.0], [8.0, 6.0, 3.0]], [[2.0, 1.0, 7.0], [4.0, 6.0, 2.0], [1.0, 2.0, 5.0], [7.0, 6.0, 1.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_LRN(self):
      arg=Data(numpy.array([[[2.0, 1.0, 6.0], [7.0, 2.0, 7.0], [5.0, 2.0, 4.0], [2.0, 6.0, 5.0]], [[1.0, 5.0, 8.0], [6.0, 1.0, 
4.0], [5.0, 6.0, 3.0], [1.0, 3.0, 7.0]], [[5.0, 7.0, 5.0], [4.0, 3.0, 2.0], [5.0, 6.0, 6.0], [6.0, 1.0, 
2.0]]]),self.functionspace)
      val=Data(numpy.array([[[4.0, 8.0, 4.0], [1.0, 2.0, 5.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[6.0, 6.0, 4.0], [3.0, 6.0, 3.0]]]))
      arg[2:,1:3]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[2.0, 1.0, 6.0], [7.0, 2.0, 7.0], [5.0, 2.0, 4.0], [2.0, 6.0, 5.0]], [[1.0, 5.0, 8.0], [6.0, 
1.0, 4.0], [5.0, 6.0, 3.0], [1.0, 3.0, 7.0]], [[5.0, 7.0, 5.0], [4.0, 8.0, 4.0], [1.0, 2.0, 5.0], [6.0, 1.0, 
2.0]]])+(1.-msk_ref)*numpy.array([[[2.0, 1.0, 6.0], [7.0, 2.0, 7.0], [5.0, 2.0, 4.0], [2.0, 6.0, 5.0]], [[1.0, 5.0, 8.0], [6.0, 
1.0, 4.0], [5.0, 6.0, 3.0], [1.0, 3.0, 7.0]], [[5.0, 7.0, 5.0], [6.0, 6.0, 4.0], [3.0, 6.0, 3.0], [6.0, 1.0, 2.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_CRU(self):
      arg=Data(numpy.array([[[4.0, 2.0, 1.0], [5.0, 8.0, 6.0], [3.0, 8.0, 7.0], [8.0, 6.0, 5.0]], [[3.0, 2.0, 1.0], [4.0, 1.0, 
8.0], [6.0, 8.0, 6.0], [8.0, 3.0, 7.0]], [[8.0, 4.0, 6.0], [4.0, 5.0, 7.0], [8.0, 8.0, 1.0], [8.0, 6.0, 
1.0]]]),self.functionspace)
      val=Data(numpy.array([[[5.0, 2.0], [2.0, 8.0]], [[1.0, 8.0], [7.0, 1.0]], [[8.0, 2.0], [4.0, 1.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[2.0, 4.0], [8.0, 2.0]], [[2.0, 6.0], [3.0, 7.0]], [[2.0, 6.0], [7.0, 6.0]]]))
      arg[:,1:3,:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[4.0, 2.0, 1.0], [5.0, 2.0, 6.0], [2.0, 8.0, 7.0], [8.0, 6.0, 5.0]], [[3.0, 2.0, 1.0], [1.0, 
8.0, 8.0], [7.0, 1.0, 6.0], [8.0, 3.0, 7.0]], [[8.0, 4.0, 6.0], [8.0, 2.0, 7.0], [4.0, 1.0, 1.0], [8.0, 6.0, 
1.0]]])+(1.-msk_ref)*numpy.array([[[4.0, 2.0, 1.0], [2.0, 4.0, 6.0], [8.0, 2.0, 7.0], [8.0, 6.0, 5.0]], [[3.0, 2.0, 1.0], [2.0, 
6.0, 8.0], [3.0, 7.0, 6.0], [8.0, 3.0, 7.0]], [[8.0, 4.0, 6.0], [2.0, 6.0, 7.0], [7.0, 6.0, 1.0], [8.0, 6.0, 1.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_UCC(self):
      arg=Data(numpy.array([[[8.0, 5.0, 8.0], [8.0, 4.0, 3.0], [6.0, 8.0, 3.0], [3.0, 3.0, 1.0]], [[2.0, 4.0, 2.0], [7.0, 5.0, 
3.0], [5.0, 5.0, 4.0], [5.0, 8.0, 2.0]], [[4.0, 6.0, 4.0], [3.0, 1.0, 7.0], [5.0, 6.0, 7.0], [3.0, 3.0, 
4.0]]]),self.functionspace)
      val=Data(numpy.array([[[6.0, 4.0, 8.0], [6.0, 3.0, 5.0], [4.0, 2.0, 1.0], [8.0, 4.0, 2.0]], [[6.0, 3.0, 5.0], [7.0, 1.0, 
5.0], [4.0, 8.0, 6.0], [1.0, 3.0, 2.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[8.0, 3.0, 7.0], [4.0, 6.0, 5.0], [1.0, 5.0, 6.0], [8.0, 3.0, 3.0]], [[1.0, 5.0, 3.0], 
[7.0, 7.0, 7.0], [4.0, 5.0, 1.0], [4.0, 3.0, 6.0]]]))
      arg[:2,:,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[6.0, 4.0, 8.0], [6.0, 3.0, 5.0], [4.0, 2.0, 1.0], [8.0, 4.0, 2.0]], [[6.0, 3.0, 5.0], [7.0, 
1.0, 5.0], [4.0, 8.0, 6.0], [1.0, 3.0, 2.0]], [[4.0, 6.0, 4.0], [3.0, 1.0, 7.0], [5.0, 6.0, 7.0], [3.0, 3.0, 
4.0]]])+(1.-msk_ref)*numpy.array([[[8.0, 3.0, 7.0], [4.0, 6.0, 5.0], [1.0, 5.0, 6.0], [8.0, 3.0, 3.0]], [[1.0, 5.0, 3.0], [7.0, 
7.0, 7.0], [4.0, 5.0, 1.0], [4.0, 3.0, 6.0]], [[4.0, 6.0, 4.0], [3.0, 1.0, 7.0], [5.0, 6.0, 7.0], [3.0, 3.0, 4.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_CPN(self):
      arg=Data(numpy.array([[[4.0, 6.0, 4.0], [1.0, 7.0, 1.0], [7.0, 1.0, 8.0], [5.0, 2.0, 8.0]], [[2.0, 4.0, 2.0], [4.0, 4.0, 
1.0], [1.0, 4.0, 7.0], [4.0, 7.0, 2.0]], [[2.0, 4.0, 1.0], [4.0, 1.0, 1.0], [4.0, 8.0, 5.0], [7.0, 7.0, 
4.0]]]),self.functionspace)
      val=Data(numpy.array([[4.0, 6.0, 7.0], [3.0, 2.0, 8.0], [1.0, 2.0, 3.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[6.0, 2.0, 2.0], [8.0, 4.0, 2.0], [4.0, 6.0, 8.0]]))
      arg[:,2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[4.0, 6.0, 4.0], [1.0, 7.0, 1.0], [4.0, 6.0, 7.0], [5.0, 2.0, 8.0]], [[2.0, 4.0, 2.0], [4.0, 
4.0, 1.0], [3.0, 2.0, 8.0], [4.0, 7.0, 2.0]], [[2.0, 4.0, 1.0], [4.0, 1.0, 1.0], [1.0, 2.0, 3.0], [7.0, 7.0, 
4.0]]])+(1.-msk_ref)*numpy.array([[[4.0, 6.0, 4.0], [1.0, 7.0, 1.0], [6.0, 2.0, 2.0], [5.0, 2.0, 8.0]], [[2.0, 4.0, 2.0], [4.0, 
4.0, 1.0], [8.0, 4.0, 2.0], [4.0, 7.0, 2.0]], [[2.0, 4.0, 1.0], [4.0, 1.0, 1.0], [4.0, 6.0, 8.0], [7.0, 7.0, 4.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_PCL(self):
      arg=Data(numpy.array([[[7.0, 1.0, 6.0], [7.0, 6.0, 4.0], [1.0, 7.0, 8.0], [4.0, 7.0, 1.0]], [[7.0, 4.0, 6.0], [7.0, 5.0, 
2.0], [4.0, 5.0, 1.0], [2.0, 4.0, 2.0]], [[8.0, 1.0, 6.0], [2.0, 3.0, 4.0], [5.0, 2.0, 2.0], [1.0, 4.0, 
4.0]]]),self.functionspace)
      val=Data(numpy.array([[6.0], [5.0], [6.0], [4.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[4.0], [7.0], [8.0], [4.0]]))
      arg[1,:,2:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[7.0, 1.0, 6.0], [7.0, 6.0, 4.0], [1.0, 7.0, 8.0], [4.0, 7.0, 1.0]], [[7.0, 4.0, 6.0], [7.0, 
5.0, 5.0], [4.0, 5.0, 6.0], [2.0, 4.0, 4.0]], [[8.0, 1.0, 6.0], [2.0, 3.0, 4.0], [5.0, 2.0, 2.0], [1.0, 4.0, 
4.0]]])+(1.-msk_ref)*numpy.array([[[7.0, 1.0, 6.0], [7.0, 6.0, 4.0], [1.0, 7.0, 8.0], [4.0, 7.0, 1.0]], [[7.0, 4.0, 4.0], [7.0, 
5.0, 7.0], [4.0, 5.0, 8.0], [2.0, 4.0, 4.0]], [[8.0, 1.0, 6.0], [2.0, 3.0, 4.0], [5.0, 2.0, 2.0], [1.0, 4.0, 4.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_RCL(self):
      arg=Data(numpy.array([[[7.0, 7.0, 4.0], [2.0, 4.0, 3.0], [2.0, 4.0, 7.0], [7.0, 3.0, 5.0]], [[6.0, 3.0, 3.0], [2.0, 4.0, 
4.0], [2.0, 4.0, 3.0], [2.0, 4.0, 5.0]], [[4.0, 6.0, 1.0], [6.0, 7.0, 2.0], [3.0, 2.0, 6.0], [5.0, 1.0, 
2.0]]]),self.functionspace)
      val=Data(numpy.array([[[3.0], [6.0], [8.0], [7.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[1.0], [7.0], [4.0], [8.0]]]))
      arg[1:2,:,2:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[7.0, 7.0, 4.0], [2.0, 4.0, 3.0], [2.0, 4.0, 7.0], [7.0, 3.0, 5.0]], [[6.0, 3.0, 3.0], [2.0, 
4.0, 6.0], [2.0, 4.0, 8.0], [2.0, 4.0, 7.0]], [[4.0, 6.0, 1.0], [6.0, 7.0, 2.0], [3.0, 2.0, 6.0], [5.0, 1.0, 
2.0]]])+(1.-msk_ref)*numpy.array([[[7.0, 7.0, 4.0], [2.0, 4.0, 3.0], [2.0, 4.0, 7.0], [7.0, 3.0, 5.0]], [[6.0, 3.0, 1.0], [2.0, 
4.0, 7.0], [2.0, 4.0, 4.0], [2.0, 4.0, 8.0]], [[4.0, 6.0, 1.0], [6.0, 7.0, 2.0], [3.0, 2.0, 6.0], [5.0, 1.0, 2.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_PPN(self):
      arg=Data(numpy.array([[[6.0, 6.0, 1.0], [1.0, 1.0, 6.0], [2.0, 1.0, 5.0], [1.0, 7.0, 5.0]], [[8.0, 5.0, 3.0], [5.0, 1.0, 
8.0], [4.0, 6.0, 4.0], [4.0, 4.0, 1.0]], [[8.0, 3.0, 6.0], [8.0, 4.0, 2.0], [8.0, 6.0, 7.0], [5.0, 5.0, 
2.0]]]),self.functionspace)
      val=Data(numpy.array([2.0, 4.0, 2.0]),self.functionspace)
      val.setTaggedValue(1,numpy.array([8.0, 8.0, 1.0]))
      arg[1,2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[6.0, 6.0, 1.0], [1.0, 1.0, 6.0], [2.0, 1.0, 5.0], [1.0, 7.0, 5.0]], [[8.0, 5.0, 3.0], [5.0, 
1.0, 8.0], [2.0, 4.0, 2.0], [4.0, 4.0, 1.0]], [[8.0, 3.0, 6.0], [8.0, 4.0, 2.0], [8.0, 6.0, 7.0], [5.0, 5.0, 
2.0]]])+(1.-msk_ref)*numpy.array([[[6.0, 6.0, 1.0], [1.0, 1.0, 6.0], [2.0, 1.0, 5.0], [1.0, 7.0, 5.0]], [[8.0, 5.0, 3.0], [5.0, 
1.0, 8.0], [8.0, 8.0, 1.0], [4.0, 4.0, 1.0]], [[8.0, 3.0, 6.0], [8.0, 4.0, 2.0], [8.0, 6.0, 7.0], [5.0, 5.0, 2.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_ULL(self):
      arg=Data(numpy.array([[[2.0, 7.0, 3.0], [4.0, 8.0, 2.0], [8.0, 2.0, 5.0], [3.0, 6.0, 8.0]], [[1.0, 2.0, 2.0], [3.0, 7.0, 
6.0], [1.0, 8.0, 3.0], [5.0, 5.0, 2.0]], [[7.0, 3.0, 6.0], [8.0, 7.0, 4.0], [2.0, 3.0, 2.0], [5.0, 5.0, 
1.0]]]),self.functionspace)
      val=Data(numpy.array([[[4.0], [1.0]], [[5.0], [8.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[3.0], [8.0]], [[7.0], [7.0]]]))
      arg[:2,2:,2:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[2.0, 7.0, 3.0], [4.0, 8.0, 2.0], [8.0, 2.0, 4.0], [3.0, 6.0, 1.0]], [[1.0, 2.0, 2.0], [3.0, 
7.0, 6.0], [1.0, 8.0, 5.0], [5.0, 5.0, 8.0]], [[7.0, 3.0, 6.0], [8.0, 7.0, 4.0], [2.0, 3.0, 2.0], [5.0, 5.0, 
1.0]]])+(1.-msk_ref)*numpy.array([[[2.0, 7.0, 3.0], [4.0, 8.0, 2.0], [8.0, 2.0, 3.0], [3.0, 6.0, 8.0]], [[1.0, 2.0, 2.0], [3.0, 
7.0, 6.0], [1.0, 8.0, 7.0], [5.0, 5.0, 7.0]], [[7.0, 3.0, 6.0], [8.0, 7.0, 4.0], [2.0, 3.0, 2.0], [5.0, 5.0, 1.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_UUC(self):
      arg=Data(numpy.array([[[1.0, 7.0, 7.0], [4.0, 2.0, 4.0], [4.0, 1.0, 5.0], [3.0, 8.0, 2.0]], [[1.0, 1.0, 6.0], [4.0, 8.0, 
1.0], [5.0, 1.0, 2.0], [3.0, 7.0, 5.0]], [[4.0, 5.0, 8.0], [8.0, 2.0, 8.0], [6.0, 5.0, 3.0], [2.0, 3.0, 
2.0]]]),self.functionspace)
      val=Data(numpy.array([[[4.0, 6.0, 6.0], [8.0, 2.0, 2.0], [7.0, 3.0, 3.0]], [[5.0, 2.0, 1.0], [5.0, 1.0, 3.0], [8.0, 7.0, 
8.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[2.0, 8.0, 1.0], [7.0, 6.0, 5.0], [4.0, 3.0, 4.0]], [[7.0, 7.0, 8.0], [2.0, 3.0, 1.0], 
[1.0, 1.0, 2.0]]]))
      arg[:2,:3,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[4.0, 6.0, 6.0], [8.0, 2.0, 2.0], [7.0, 3.0, 3.0], [3.0, 8.0, 2.0]], [[5.0, 2.0, 1.0], [5.0, 
1.0, 3.0], [8.0, 7.0, 8.0], [3.0, 7.0, 5.0]], [[4.0, 5.0, 8.0], [8.0, 2.0, 8.0], [6.0, 5.0, 3.0], [2.0, 3.0, 
2.0]]])+(1.-msk_ref)*numpy.array([[[2.0, 8.0, 1.0], [7.0, 6.0, 5.0], [4.0, 3.0, 4.0], [3.0, 8.0, 2.0]], [[7.0, 7.0, 8.0], [2.0, 
3.0, 1.0], [1.0, 1.0, 2.0], [3.0, 7.0, 5.0]], [[4.0, 5.0, 8.0], [8.0, 2.0, 8.0], [6.0, 5.0, 3.0], [2.0, 3.0, 2.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_PRC(self):
      arg=Data(numpy.array([[[1.0, 2.0, 2.0], [3.0, 7.0, 6.0], [8.0, 6.0, 1.0], [2.0, 6.0, 5.0]], [[3.0, 6.0, 1.0], [6.0, 7.0, 
5.0], [1.0, 8.0, 1.0], [3.0, 4.0, 1.0]], [[3.0, 4.0, 8.0], [7.0, 7.0, 1.0], [4.0, 3.0, 8.0], [7.0, 8.0, 
3.0]]]),self.functionspace)
      val=Data(numpy.array([[7.0, 3.0, 1.0], [8.0, 5.0, 1.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[1.0, 6.0, 1.0], [4.0, 2.0, 7.0]]))
      arg[1,1:3,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[1.0, 2.0, 2.0], [3.0, 7.0, 6.0], [8.0, 6.0, 1.0], [2.0, 6.0, 5.0]], [[3.0, 6.0, 1.0], [7.0, 
3.0, 1.0], [8.0, 5.0, 1.0], [3.0, 4.0, 1.0]], [[3.0, 4.0, 8.0], [7.0, 7.0, 1.0], [4.0, 3.0, 8.0], [7.0, 8.0, 
3.0]]])+(1.-msk_ref)*numpy.array([[[1.0, 2.0, 2.0], [3.0, 7.0, 6.0], [8.0, 6.0, 1.0], [2.0, 6.0, 5.0]], [[3.0, 6.0, 1.0], [1.0, 
6.0, 1.0], [4.0, 2.0, 7.0], [3.0, 4.0, 1.0]], [[3.0, 4.0, 8.0], [7.0, 7.0, 1.0], [4.0, 3.0, 8.0], [7.0, 8.0, 3.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_PPL(self):
      arg=Data(numpy.array([[[6.0, 5.0, 6.0], [8.0, 2.0, 8.0], [1.0, 2.0, 5.0], [3.0, 5.0, 3.0]], [[4.0, 8.0, 5.0], [4.0, 5.0, 
1.0], [6.0, 6.0, 7.0], [3.0, 8.0, 8.0]], [[5.0, 1.0, 3.0], [7.0, 2.0, 7.0], [6.0, 8.0, 1.0], [6.0, 3.0, 
3.0]]]),self.functionspace)
      val=Data(numpy.array([3.0]),self.functionspace)
      val.setTaggedValue(1,numpy.array([7.0]))
      arg[1,2,2:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[6.0, 5.0, 6.0], [8.0, 2.0, 8.0], [1.0, 2.0, 5.0], [3.0, 5.0, 3.0]], [[4.0, 8.0, 5.0], [4.0, 
5.0, 1.0], [6.0, 6.0, 3.0], [3.0, 8.0, 8.0]], [[5.0, 1.0, 3.0], [7.0, 2.0, 7.0], [6.0, 8.0, 1.0], [6.0, 3.0, 
3.0]]])+(1.-msk_ref)*numpy.array([[[6.0, 5.0, 6.0], [8.0, 2.0, 8.0], [1.0, 2.0, 5.0], [3.0, 5.0, 3.0]], [[4.0, 8.0, 5.0], [4.0, 
5.0, 1.0], [6.0, 6.0, 7.0], [3.0, 8.0, 8.0]], [[5.0, 1.0, 3.0], [7.0, 2.0, 7.0], [6.0, 8.0, 1.0], [6.0, 3.0, 3.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_RLR(self):
      arg=Data(numpy.array([[[3.0, 3.0, 1.0], [4.0, 5.0, 8.0], [1.0, 7.0, 2.0], [7.0, 4.0, 8.0]], [[4.0, 5.0, 4.0], [1.0, 8.0, 
8.0], [8.0, 2.0, 2.0], [5.0, 4.0, 1.0]], [[2.0, 6.0, 7.0], [6.0, 6.0, 4.0], [8.0, 2.0, 8.0], [3.0, 4.0, 
5.0]]]),self.functionspace)
      val=Data(numpy.array([[[4.0], [2.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[5.0], [6.0]]]))
      arg[1:2,2:,1:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[3.0, 3.0, 1.0], [4.0, 5.0, 8.0], [1.0, 7.0, 2.0], [7.0, 4.0, 8.0]], [[4.0, 5.0, 4.0], [1.0, 
8.0, 8.0], [8.0, 4.0, 2.0], [5.0, 2.0, 1.0]], [[2.0, 6.0, 7.0], [6.0, 6.0, 4.0], [8.0, 2.0, 8.0], [3.0, 4.0, 
5.0]]])+(1.-msk_ref)*numpy.array([[[3.0, 3.0, 1.0], [4.0, 5.0, 8.0], [1.0, 7.0, 2.0], [7.0, 4.0, 8.0]], [[4.0, 5.0, 4.0], [1.0, 
8.0, 8.0], [8.0, 5.0, 2.0], [5.0, 6.0, 1.0]], [[2.0, 6.0, 7.0], [6.0, 6.0, 4.0], [8.0, 2.0, 8.0], [3.0, 4.0, 5.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_URR(self):
      arg=Data(numpy.array([[[1.0, 2.0, 8.0], [2.0, 8.0, 4.0], [1.0, 5.0, 8.0], [3.0, 2.0, 5.0]], [[7.0, 2.0, 6.0], [6.0, 6.0, 
1.0], [6.0, 7.0, 1.0], [4.0, 2.0, 5.0]], [[1.0, 7.0, 6.0], [8.0, 6.0, 6.0], [8.0, 1.0, 4.0], [3.0, 4.0, 
2.0]]]),self.functionspace)
      val=Data(numpy.array([[[6.0], [3.0]], [[7.0], [8.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[3.0], [6.0]], [[3.0], [8.0]]]))
      arg[:2,1:3,1:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[1.0, 2.0, 8.0], [2.0, 6.0, 4.0], [1.0, 3.0, 8.0], [3.0, 2.0, 5.0]], [[7.0, 2.0, 6.0], [6.0, 
7.0, 1.0], [6.0, 8.0, 1.0], [4.0, 2.0, 5.0]], [[1.0, 7.0, 6.0], [8.0, 6.0, 6.0], [8.0, 1.0, 4.0], [3.0, 4.0, 
2.0]]])+(1.-msk_ref)*numpy.array([[[1.0, 2.0, 8.0], [2.0, 3.0, 4.0], [1.0, 6.0, 8.0], [3.0, 2.0, 5.0]], [[7.0, 2.0, 6.0], [6.0, 
3.0, 1.0], [6.0, 8.0, 1.0], [4.0, 2.0, 5.0]], [[1.0, 7.0, 6.0], [8.0, 6.0, 6.0], [8.0, 1.0, 4.0], [3.0, 4.0, 2.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_PRP(self):
      arg=Data(numpy.array([[[6.0, 8.0, 8.0], [7.0, 2.0, 7.0], [1.0, 7.0, 5.0], [4.0, 4.0, 4.0]], [[7.0, 8.0, 4.0], [1.0, 8.0, 
2.0], [8.0, 2.0, 7.0], [3.0, 4.0, 2.0]], [[1.0, 3.0, 2.0], [1.0, 6.0, 5.0], [6.0, 7.0, 8.0], [2.0, 8.0, 
1.0]]]),self.functionspace)
      val=Data(numpy.array([8.0, 5.0]),self.functionspace)
      val.setTaggedValue(1,numpy.array([4.0, 2.0]))
      arg[1,1:3,1]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[6.0, 8.0, 8.0], [7.0, 2.0, 7.0], [1.0, 7.0, 5.0], [4.0, 4.0, 4.0]], [[7.0, 8.0, 4.0], [1.0, 
8.0, 2.0], [8.0, 5.0, 7.0], [3.0, 4.0, 2.0]], [[1.0, 3.0, 2.0], [1.0, 6.0, 5.0], [6.0, 7.0, 8.0], [2.0, 8.0, 
1.0]]])+(1.-msk_ref)*numpy.array([[[6.0, 8.0, 8.0], [7.0, 2.0, 7.0], [1.0, 7.0, 5.0], [4.0, 4.0, 4.0]], [[7.0, 8.0, 4.0], [1.0, 
4.0, 2.0], [8.0, 2.0, 7.0], [3.0, 4.0, 2.0]], [[1.0, 3.0, 2.0], [1.0, 6.0, 5.0], [6.0, 7.0, 8.0], [2.0, 8.0, 1.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_UUU(self):
      arg=Data(numpy.array([[[4.0, 4.0, 3.0], [2.0, 3.0, 4.0], [1.0, 7.0, 7.0], [2.0, 8.0, 4.0]], [[7.0, 2.0, 2.0], [1.0, 6.0, 
3.0], [8.0, 5.0, 4.0], [5.0, 6.0, 5.0]], [[2.0, 6.0, 2.0], [6.0, 5.0, 3.0], [8.0, 8.0, 8.0], [4.0, 7.0, 
6.0]]]),self.functionspace)
      val=Data(numpy.array([[[3.0, 8.0], [7.0, 3.0], [5.0, 6.0]], [[3.0, 2.0], [1.0, 2.0], [7.0, 3.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[1.0, 4.0], [6.0, 8.0], [2.0, 7.0]], [[8.0, 5.0], [5.0, 1.0], [2.0, 4.0]]]))
      arg[:2,:3,:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[3.0, 8.0, 3.0], [7.0, 3.0, 4.0], [5.0, 6.0, 7.0], [2.0, 8.0, 4.0]], [[3.0, 2.0, 2.0], [1.0, 
2.0, 3.0], [7.0, 3.0, 4.0], [5.0, 6.0, 5.0]], [[2.0, 6.0, 2.0], [6.0, 5.0, 3.0], [8.0, 8.0, 8.0], [4.0, 7.0, 
6.0]]])+(1.-msk_ref)*numpy.array([[[1.0, 4.0, 3.0], [6.0, 8.0, 4.0], [2.0, 7.0, 7.0], [2.0, 8.0, 4.0]], [[8.0, 5.0, 2.0], [5.0, 
1.0, 3.0], [2.0, 4.0, 4.0], [5.0, 6.0, 5.0]], [[2.0, 6.0, 2.0], [6.0, 5.0, 3.0], [8.0, 8.0, 8.0], [4.0, 7.0, 6.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_PRU(self):
      arg=Data(numpy.array([[[3.0, 1.0, 5.0], [3.0, 2.0, 2.0], [2.0, 5.0, 3.0], [7.0, 4.0, 6.0]], [[7.0, 2.0, 3.0], [8.0, 4.0, 
3.0], [8.0, 6.0, 7.0], [2.0, 6.0, 8.0]], [[6.0, 3.0, 7.0], [4.0, 4.0, 7.0], [3.0, 8.0, 6.0], [2.0, 8.0, 
7.0]]]),self.functionspace)
      val=Data(numpy.array([[8.0, 6.0], [2.0, 7.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[2.0, 5.0], [1.0, 6.0]]))
      arg[1,1:3,:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[3.0, 1.0, 5.0], [3.0, 2.0, 2.0], [2.0, 5.0, 3.0], [7.0, 4.0, 6.0]], [[7.0, 2.0, 3.0], [8.0, 
6.0, 3.0], [2.0, 7.0, 7.0], [2.0, 6.0, 8.0]], [[6.0, 3.0, 7.0], [4.0, 4.0, 7.0], [3.0, 8.0, 6.0], [2.0, 8.0, 
7.0]]])+(1.-msk_ref)*numpy.array([[[3.0, 1.0, 5.0], [3.0, 2.0, 2.0], [2.0, 5.0, 3.0], [7.0, 4.0, 6.0]], [[7.0, 2.0, 3.0], [2.0, 
5.0, 3.0], [1.0, 6.0, 7.0], [2.0, 6.0, 8.0]], [[6.0, 3.0, 7.0], [4.0, 4.0, 7.0], [3.0, 8.0, 6.0], [2.0, 8.0, 7.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_LPC(self):
      arg=Data(numpy.array([[[5.0, 8.0, 7.0], [4.0, 2.0, 2.0], [8.0, 8.0, 4.0], [2.0, 7.0, 8.0]], [[1.0, 8.0, 2.0], [2.0, 3.0, 
3.0], [2.0, 5.0, 7.0], [7.0, 2.0, 3.0]], [[4.0, 4.0, 3.0], [5.0, 5.0, 6.0], [4.0, 3.0, 7.0], [6.0, 6.0, 
3.0]]]),self.functionspace)
      val=Data(numpy.array([[7.0, 4.0, 2.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[8.0, 3.0, 7.0]]))
      arg[2:,2,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[5.0, 8.0, 7.0], [4.0, 2.0, 2.0], [8.0, 8.0, 4.0], [2.0, 7.0, 8.0]], [[1.0, 8.0, 2.0], [2.0, 
3.0, 3.0], [2.0, 5.0, 7.0], [7.0, 2.0, 3.0]], [[4.0, 4.0, 3.0], [5.0, 5.0, 6.0], [7.0, 4.0, 2.0], [6.0, 6.0, 
3.0]]])+(1.-msk_ref)*numpy.array([[[5.0, 8.0, 7.0], [4.0, 2.0, 2.0], [8.0, 8.0, 4.0], [2.0, 7.0, 8.0]], [[1.0, 8.0, 2.0], [2.0, 
3.0, 3.0], [2.0, 5.0, 7.0], [7.0, 2.0, 3.0]], [[4.0, 4.0, 3.0], [5.0, 5.0, 6.0], [8.0, 3.0, 7.0], [6.0, 6.0, 3.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_UCN(self):
      arg=Data(numpy.array([[[4.0, 3.0, 4.0], [4.0, 5.0, 7.0], [1.0, 2.0, 6.0], [5.0, 6.0, 6.0]], [[2.0, 1.0, 2.0], [1.0, 1.0, 
3.0], [6.0, 4.0, 1.0], [2.0, 1.0, 3.0]], [[4.0, 7.0, 1.0], [6.0, 2.0, 4.0], [1.0, 8.0, 4.0], [7.0, 5.0, 
8.0]]]),self.functionspace)
      val=Data(numpy.array([[[6.0, 5.0, 1.0], [5.0, 5.0, 3.0], [3.0, 7.0, 3.0], [8.0, 2.0, 4.0]], [[4.0, 3.0, 2.0], [6.0, 2.0, 
6.0], [7.0, 4.0, 1.0], [4.0, 5.0, 4.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[3.0, 5.0, 3.0], [5.0, 6.0, 7.0], [7.0, 7.0, 8.0], [8.0, 1.0, 2.0]], [[1.0, 5.0, 6.0], 
[8.0, 7.0, 7.0], [8.0, 5.0, 6.0], [2.0, 7.0, 7.0]]]))
      arg[:2,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[6.0, 5.0, 1.0], [5.0, 5.0, 3.0], [3.0, 7.0, 3.0], [8.0, 2.0, 4.0]], [[4.0, 3.0, 2.0], [6.0, 
2.0, 6.0], [7.0, 4.0, 1.0], [4.0, 5.0, 4.0]], [[4.0, 7.0, 1.0], [6.0, 2.0, 4.0], [1.0, 8.0, 4.0], [7.0, 5.0, 
8.0]]])+(1.-msk_ref)*numpy.array([[[3.0, 5.0, 3.0], [5.0, 6.0, 7.0], [7.0, 7.0, 8.0], [8.0, 1.0, 2.0]], [[1.0, 5.0, 6.0], [8.0, 
7.0, 7.0], [8.0, 5.0, 6.0], [2.0, 7.0, 7.0]], [[4.0, 7.0, 1.0], [6.0, 2.0, 4.0], [1.0, 8.0, 4.0], [7.0, 5.0, 8.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_RUL(self):
      arg=Data(numpy.array([[[6.0, 1.0, 2.0], [3.0, 3.0, 2.0], [5.0, 3.0, 8.0], [5.0, 8.0, 7.0]], [[7.0, 3.0, 2.0], [3.0, 5.0, 
1.0], [7.0, 7.0, 4.0], [5.0, 1.0, 1.0]], [[8.0, 8.0, 6.0], [1.0, 7.0, 7.0], [8.0, 5.0, 1.0], [3.0, 7.0, 
3.0]]]),self.functionspace)
      val=Data(numpy.array([[[3.0], [4.0], [5.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[4.0], [1.0], [3.0]]]))
      arg[1:2,:3,2:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[6.0, 1.0, 2.0], [3.0, 3.0, 2.0], [5.0, 3.0, 8.0], [5.0, 8.0, 7.0]], [[7.0, 3.0, 3.0], [3.0, 
5.0, 4.0], [7.0, 7.0, 5.0], [5.0, 1.0, 1.0]], [[8.0, 8.0, 6.0], [1.0, 7.0, 7.0], [8.0, 5.0, 1.0], [3.0, 7.0, 
3.0]]])+(1.-msk_ref)*numpy.array([[[6.0, 1.0, 2.0], [3.0, 3.0, 2.0], [5.0, 3.0, 8.0], [5.0, 8.0, 7.0]], [[7.0, 3.0, 4.0], [3.0, 
5.0, 1.0], [7.0, 7.0, 3.0], [5.0, 1.0, 1.0]], [[8.0, 8.0, 6.0], [1.0, 7.0, 7.0], [8.0, 5.0, 1.0], [3.0, 7.0, 3.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_ULU(self):
      arg=Data(numpy.array([[[7.0, 1.0, 3.0], [5.0, 3.0, 3.0], [7.0, 6.0, 2.0], [3.0, 4.0, 8.0]], [[2.0, 3.0, 6.0], [3.0, 6.0, 
7.0], [1.0, 5.0, 6.0], [6.0, 5.0, 6.0]], [[4.0, 5.0, 4.0], [5.0, 1.0, 7.0], [8.0, 5.0, 3.0], [7.0, 4.0, 
4.0]]]),self.functionspace)
      val=Data(numpy.array([[[2.0, 4.0], [2.0, 1.0]], [[7.0, 5.0], [7.0, 8.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[6.0, 2.0], [1.0, 5.0]], [[3.0, 5.0], [7.0, 3.0]]]))
      arg[:2,2:,:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[7.0, 1.0, 3.0], [5.0, 3.0, 3.0], [2.0, 4.0, 2.0], [2.0, 1.0, 8.0]], [[2.0, 3.0, 6.0], [3.0, 
6.0, 7.0], [7.0, 5.0, 6.0], [7.0, 8.0, 6.0]], [[4.0, 5.0, 4.0], [5.0, 1.0, 7.0], [8.0, 5.0, 3.0], [7.0, 4.0, 
4.0]]])+(1.-msk_ref)*numpy.array([[[7.0, 1.0, 3.0], [5.0, 3.0, 3.0], [6.0, 2.0, 2.0], [1.0, 5.0, 8.0]], [[2.0, 3.0, 6.0], [3.0, 
6.0, 7.0], [3.0, 5.0, 6.0], [7.0, 3.0, 6.0]], [[4.0, 5.0, 4.0], [5.0, 1.0, 7.0], [8.0, 5.0, 3.0], [7.0, 4.0, 4.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_RRP(self):
      arg=Data(numpy.array([[[7.0, 3.0, 6.0], [7.0, 6.0, 6.0], [6.0, 6.0, 5.0], [5.0, 3.0, 8.0]], [[3.0, 4.0, 6.0], [1.0, 2.0, 
2.0], [1.0, 8.0, 5.0], [7.0, 3.0, 8.0]], [[1.0, 6.0, 1.0], [4.0, 6.0, 1.0], [3.0, 1.0, 7.0], [4.0, 4.0, 
7.0]]]),self.functionspace)
      val=Data(numpy.array([[4.0, 2.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[8.0, 3.0]]))
      arg[1:2,1:3,1]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[7.0, 3.0, 6.0], [7.0, 6.0, 6.0], [6.0, 6.0, 5.0], [5.0, 3.0, 8.0]], [[3.0, 4.0, 6.0], [1.0, 
4.0, 2.0], [1.0, 2.0, 5.0], [7.0, 3.0, 8.0]], [[1.0, 6.0, 1.0], [4.0, 6.0, 1.0], [3.0, 1.0, 7.0], [4.0, 4.0, 
7.0]]])+(1.-msk_ref)*numpy.array([[[7.0, 3.0, 6.0], [7.0, 6.0, 6.0], [6.0, 6.0, 5.0], [5.0, 3.0, 8.0]], [[3.0, 4.0, 6.0], [1.0, 
8.0, 2.0], [1.0, 3.0, 5.0], [7.0, 3.0, 8.0]], [[1.0, 6.0, 1.0], [4.0, 6.0, 1.0], [3.0, 1.0, 7.0], [4.0, 4.0, 7.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_RPN(self):
      arg=Data(numpy.array([[[8.0, 5.0, 4.0], [1.0, 7.0, 5.0], [2.0, 1.0, 6.0], [4.0, 3.0, 1.0]], [[8.0, 5.0, 6.0], [6.0, 1.0, 
2.0], [6.0, 2.0, 8.0], [4.0, 2.0, 1.0]], [[5.0, 7.0, 5.0], [6.0, 5.0, 8.0], [4.0, 2.0, 1.0], [2.0, 8.0, 
4.0]]]),self.functionspace)
      val=Data(numpy.array([[1.0, 6.0, 2.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[8.0, 5.0, 6.0]]))
      arg[1:2,2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[8.0, 5.0, 4.0], [1.0, 7.0, 5.0], [2.0, 1.0, 6.0], [4.0, 3.0, 1.0]], [[8.0, 5.0, 6.0], [6.0, 
1.0, 2.0], [1.0, 6.0, 2.0], [4.0, 2.0, 1.0]], [[5.0, 7.0, 5.0], [6.0, 5.0, 8.0], [4.0, 2.0, 1.0], [2.0, 8.0, 
4.0]]])+(1.-msk_ref)*numpy.array([[[8.0, 5.0, 4.0], [1.0, 7.0, 5.0], [2.0, 1.0, 6.0], [4.0, 3.0, 1.0]], [[8.0, 5.0, 6.0], [6.0, 
1.0, 2.0], [8.0, 5.0, 6.0], [4.0, 2.0, 1.0]], [[5.0, 7.0, 5.0], [6.0, 5.0, 8.0], [4.0, 2.0, 1.0], [2.0, 8.0, 4.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_PRN(self):
      arg=Data(numpy.array([[[1.0, 6.0, 7.0], [8.0, 2.0, 5.0], [3.0, 1.0, 3.0], [1.0, 7.0, 2.0]], [[1.0, 8.0, 5.0], [4.0, 4.0, 
5.0], [4.0, 6.0, 7.0], [5.0, 6.0, 4.0]], [[4.0, 1.0, 8.0], [7.0, 4.0, 6.0], [7.0, 4.0, 5.0], [8.0, 1.0, 
3.0]]]),self.functionspace)
      val=Data(numpy.array([[1.0, 8.0, 4.0], [1.0, 2.0, 4.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[6.0, 5.0, 7.0], [1.0, 4.0, 2.0]]))
      arg[1,1:3]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[1.0, 6.0, 7.0], [8.0, 2.0, 5.0], [3.0, 1.0, 3.0], [1.0, 7.0, 2.0]], [[1.0, 8.0, 5.0], [1.0, 
8.0, 4.0], [1.0, 2.0, 4.0], [5.0, 6.0, 4.0]], [[4.0, 1.0, 8.0], [7.0, 4.0, 6.0], [7.0, 4.0, 5.0], [8.0, 1.0, 
3.0]]])+(1.-msk_ref)*numpy.array([[[1.0, 6.0, 7.0], [8.0, 2.0, 5.0], [3.0, 1.0, 3.0], [1.0, 7.0, 2.0]], [[1.0, 8.0, 5.0], [6.0, 
5.0, 7.0], [1.0, 4.0, 2.0], [5.0, 6.0, 4.0]], [[4.0, 1.0, 8.0], [7.0, 4.0, 6.0], [7.0, 4.0, 5.0], [8.0, 1.0, 3.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_LLR(self):
      arg=Data(numpy.array([[[3.0, 6.0, 1.0], [7.0, 8.0, 2.0], [5.0, 1.0, 8.0], [2.0, 7.0, 1.0]], [[6.0, 7.0, 2.0], [2.0, 8.0, 
2.0], [3.0, 1.0, 4.0], [8.0, 5.0, 2.0]], [[7.0, 4.0, 3.0], [4.0, 7.0, 7.0], [2.0, 4.0, 2.0], [7.0, 3.0, 
5.0]]]),self.functionspace)
      val=Data(numpy.array([[[2.0], [3.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[4.0], [7.0]]]))
      arg[2:,2:,1:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[3.0, 6.0, 1.0], [7.0, 8.0, 2.0], [5.0, 1.0, 8.0], [2.0, 7.0, 1.0]], [[6.0, 7.0, 2.0], [2.0, 
8.0, 2.0], [3.0, 1.0, 4.0], [8.0, 5.0, 2.0]], [[7.0, 4.0, 3.0], [4.0, 7.0, 7.0], [2.0, 2.0, 2.0], [7.0, 3.0, 
5.0]]])+(1.-msk_ref)*numpy.array([[[3.0, 6.0, 1.0], [7.0, 8.0, 2.0], [5.0, 1.0, 8.0], [2.0, 7.0, 1.0]], [[6.0, 7.0, 2.0], [2.0, 
8.0, 2.0], [3.0, 1.0, 4.0], [8.0, 5.0, 2.0]], [[7.0, 4.0, 3.0], [4.0, 7.0, 7.0], [2.0, 4.0, 2.0], [7.0, 7.0, 5.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_CCP(self):
      arg=Data(numpy.array([[[2.0, 1.0, 2.0], [2.0, 7.0, 6.0], [1.0, 4.0, 3.0], [4.0, 1.0, 4.0]], [[2.0, 1.0, 3.0], [8.0, 3.0, 
8.0], [5.0, 1.0, 5.0], [6.0, 8.0, 4.0]], [[1.0, 2.0, 4.0], [5.0, 5.0, 3.0], [6.0, 7.0, 6.0], [8.0, 4.0, 
5.0]]]),self.functionspace)
      val=Data(numpy.array([[5.0, 5.0, 2.0, 3.0], [2.0, 6.0, 6.0, 1.0], [3.0, 2.0, 6.0, 4.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[2.0, 4.0, 4.0, 3.0], [7.0, 4.0, 5.0, 4.0], [5.0, 2.0, 4.0, 7.0]]))
      arg[:,:,1]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[2.0, 5.0, 2.0], [2.0, 5.0, 6.0], [1.0, 2.0, 3.0], [4.0, 3.0, 4.0]], [[2.0, 2.0, 3.0], [8.0, 
6.0, 8.0], [5.0, 6.0, 5.0], [6.0, 1.0, 4.0]], [[1.0, 3.0, 4.0], [5.0, 2.0, 3.0], [6.0, 6.0, 6.0], [8.0, 4.0, 
5.0]]])+(1.-msk_ref)*numpy.array([[[2.0, 2.0, 2.0], [2.0, 4.0, 6.0], [1.0, 4.0, 3.0], [4.0, 3.0, 4.0]], [[2.0, 7.0, 3.0], [8.0, 
4.0, 8.0], [5.0, 5.0, 5.0], [6.0, 4.0, 4.0]], [[1.0, 5.0, 4.0], [5.0, 2.0, 3.0], [6.0, 4.0, 6.0], [8.0, 7.0, 5.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_UPR(self):
      arg=Data(numpy.array([[[6.0, 8.0, 7.0], [4.0, 3.0, 5.0], [1.0, 5.0, 5.0], [4.0, 6.0, 4.0]], [[5.0, 7.0, 3.0], [5.0, 3.0, 
3.0], [7.0, 2.0, 6.0], [3.0, 1.0, 8.0]], [[1.0, 1.0, 4.0], [3.0, 4.0, 4.0], [1.0, 7.0, 7.0], [6.0, 3.0, 
5.0]]]),self.functionspace)
      val=Data(numpy.array([[4.0], [1.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[2.0], [3.0]]))
      arg[:2,2,1:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[6.0, 8.0, 7.0], [4.0, 3.0, 5.0], [1.0, 4.0, 5.0], [4.0, 6.0, 4.0]], [[5.0, 7.0, 3.0], [5.0, 
3.0, 3.0], [7.0, 1.0, 6.0], [3.0, 1.0, 8.0]], [[1.0, 1.0, 4.0], [3.0, 4.0, 4.0], [1.0, 7.0, 7.0], [6.0, 3.0, 
5.0]]])+(1.-msk_ref)*numpy.array([[[6.0, 8.0, 7.0], [4.0, 3.0, 5.0], [1.0, 2.0, 5.0], [4.0, 6.0, 4.0]], [[5.0, 7.0, 3.0], [5.0, 
3.0, 3.0], [7.0, 3.0, 6.0], [3.0, 1.0, 8.0]], [[1.0, 1.0, 4.0], [3.0, 4.0, 4.0], [1.0, 7.0, 7.0], [6.0, 3.0, 5.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_PCN(self):
      arg=Data(numpy.array([[[1.0, 7.0, 7.0], [7.0, 8.0, 6.0], [3.0, 8.0, 5.0], [5.0, 1.0, 5.0]], [[3.0, 8.0, 6.0], [5.0, 6.0, 
1.0], [3.0, 7.0, 1.0], [4.0, 2.0, 1.0]], [[2.0, 1.0, 7.0], [8.0, 5.0, 5.0], [1.0, 7.0, 4.0], [5.0, 2.0, 
3.0]]]),self.functionspace)
      val=Data(numpy.array([[7.0, 5.0, 4.0], [4.0, 6.0, 5.0], [2.0, 5.0, 4.0], [4.0, 5.0, 5.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[6.0, 7.0, 6.0], [8.0, 3.0, 5.0], [7.0, 8.0, 2.0], [6.0, 2.0, 3.0]]))
      arg[1,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[1.0, 7.0, 7.0], [7.0, 8.0, 6.0], [3.0, 8.0, 5.0], [5.0, 1.0, 5.0]], [[7.0, 5.0, 4.0], [4.0, 
6.0, 5.0], [2.0, 5.0, 4.0], [4.0, 5.0, 5.0]], [[2.0, 1.0, 7.0], [8.0, 5.0, 5.0], [1.0, 7.0, 4.0], [5.0, 2.0, 
3.0]]])+(1.-msk_ref)*numpy.array([[[1.0, 7.0, 7.0], [7.0, 8.0, 6.0], [3.0, 8.0, 5.0], [5.0, 1.0, 5.0]], [[6.0, 7.0, 6.0], [8.0, 
3.0, 5.0], [7.0, 8.0, 2.0], [6.0, 2.0, 3.0]], [[2.0, 1.0, 7.0], [8.0, 5.0, 5.0], [1.0, 7.0, 4.0], [5.0, 2.0, 3.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_PPC(self):
      arg=Data(numpy.array([[[3.0, 7.0, 2.0], [8.0, 5.0, 1.0], [3.0, 5.0, 3.0], [8.0, 4.0, 4.0]], [[5.0, 6.0, 7.0], [2.0, 2.0, 
7.0], [3.0, 5.0, 5.0], [1.0, 4.0, 3.0]], [[1.0, 7.0, 2.0], [2.0, 7.0, 6.0], [8.0, 1.0, 3.0], [5.0, 3.0, 
5.0]]]),self.functionspace)
      val=Data(numpy.array([5.0, 2.0, 4.0]),self.functionspace)
      val.setTaggedValue(1,numpy.array([5.0, 2.0, 2.0]))
      arg[1,2,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[3.0, 7.0, 2.0], [8.0, 5.0, 1.0], [3.0, 5.0, 3.0], [8.0, 4.0, 4.0]], [[5.0, 6.0, 7.0], [2.0, 
2.0, 7.0], [5.0, 2.0, 4.0], [1.0, 4.0, 3.0]], [[1.0, 7.0, 2.0], [2.0, 7.0, 6.0], [8.0, 1.0, 3.0], [5.0, 3.0, 
5.0]]])+(1.-msk_ref)*numpy.array([[[3.0, 7.0, 2.0], [8.0, 5.0, 1.0], [3.0, 5.0, 3.0], [8.0, 4.0, 4.0]], [[5.0, 6.0, 7.0], [2.0, 
2.0, 7.0], [5.0, 2.0, 2.0], [1.0, 4.0, 3.0]], [[1.0, 7.0, 2.0], [2.0, 7.0, 6.0], [8.0, 1.0, 3.0], [5.0, 3.0, 5.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_CPU(self):
      arg=Data(numpy.array([[[5.0, 3.0, 2.0], [6.0, 2.0, 7.0], [8.0, 6.0, 1.0], [6.0, 8.0, 7.0]], [[3.0, 8.0, 4.0], [2.0, 4.0, 
3.0], [8.0, 1.0, 7.0], [2.0, 8.0, 4.0]], [[2.0, 8.0, 8.0], [8.0, 8.0, 4.0], [7.0, 2.0, 1.0], [2.0, 8.0, 
3.0]]]),self.functionspace)
      val=Data(numpy.array([[4.0, 6.0], [5.0, 5.0], [3.0, 1.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[8.0, 1.0], [6.0, 4.0], [2.0, 2.0]]))
      arg[:,2,:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[5.0, 3.0, 2.0], [6.0, 2.0, 7.0], [4.0, 6.0, 1.0], [6.0, 8.0, 7.0]], [[3.0, 8.0, 4.0], [2.0, 
4.0, 3.0], [5.0, 5.0, 7.0], [2.0, 8.0, 4.0]], [[2.0, 8.0, 8.0], [8.0, 8.0, 4.0], [3.0, 1.0, 1.0], [2.0, 8.0, 
3.0]]])+(1.-msk_ref)*numpy.array([[[5.0, 3.0, 2.0], [6.0, 2.0, 7.0], [8.0, 1.0, 1.0], [6.0, 8.0, 7.0]], [[3.0, 8.0, 4.0], [2.0, 
4.0, 3.0], [6.0, 4.0, 7.0], [2.0, 8.0, 4.0]], [[2.0, 8.0, 8.0], [8.0, 8.0, 4.0], [2.0, 2.0, 1.0], [2.0, 8.0, 3.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_CCL(self):
      arg=Data(numpy.array([[[5.0, 3.0, 7.0], [6.0, 5.0, 6.0], [1.0, 5.0, 2.0], [8.0, 5.0, 1.0]], [[6.0, 3.0, 1.0], [7.0, 4.0, 
4.0], [3.0, 3.0, 5.0], [4.0, 4.0, 8.0]], [[1.0, 1.0, 2.0], [4.0, 5.0, 6.0], [4.0, 7.0, 2.0], [5.0, 3.0, 
4.0]]]),self.functionspace)
      val=Data(numpy.array([[[3.0], [7.0], [1.0], [1.0]], [[5.0], [5.0], [2.0], [7.0]], [[5.0], [8.0], [5.0], 
[8.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[6.0], [7.0], [2.0], [3.0]], [[6.0], [7.0], [7.0], [8.0]], [[8.0], [2.0], [1.0], 
[8.0]]]))
      arg[:,:,2:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[5.0, 3.0, 3.0], [6.0, 5.0, 7.0], [1.0, 5.0, 1.0], [8.0, 5.0, 1.0]], [[6.0, 3.0, 5.0], [7.0, 
4.0, 5.0], [3.0, 3.0, 2.0], [4.0, 4.0, 7.0]], [[1.0, 1.0, 5.0], [4.0, 5.0, 8.0], [4.0, 7.0, 5.0], [5.0, 3.0, 
8.0]]])+(1.-msk_ref)*numpy.array([[[5.0, 3.0, 6.0], [6.0, 5.0, 7.0], [1.0, 5.0, 2.0], [8.0, 5.0, 3.0]], [[6.0, 3.0, 6.0], [7.0, 
4.0, 7.0], [3.0, 3.0, 7.0], [4.0, 4.0, 8.0]], [[1.0, 1.0, 8.0], [4.0, 5.0, 2.0], [4.0, 7.0, 1.0], [5.0, 3.0, 8.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_LCN(self):
      arg=Data(numpy.array([[[6.0, 6.0, 6.0], [4.0, 4.0, 8.0], [6.0, 5.0, 7.0], [6.0, 7.0, 7.0]], [[6.0, 6.0, 6.0], [8.0, 7.0, 
1.0], [5.0, 8.0, 8.0], [4.0, 5.0, 2.0]], [[7.0, 4.0, 2.0], [8.0, 4.0, 1.0], [3.0, 1.0, 7.0], [6.0, 3.0, 
2.0]]]),self.functionspace)
      val=Data(numpy.array([[[8.0, 3.0, 5.0], [1.0, 4.0, 5.0], [2.0, 6.0, 6.0], [3.0, 2.0, 2.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[8.0, 4.0, 2.0], [4.0, 8.0, 7.0], [8.0, 1.0, 3.0], [3.0, 7.0, 2.0]]]))
      arg[2:,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[6.0, 6.0, 6.0], [4.0, 4.0, 8.0], [6.0, 5.0, 7.0], [6.0, 7.0, 7.0]], [[6.0, 6.0, 6.0], [8.0, 
7.0, 1.0], [5.0, 8.0, 8.0], [4.0, 5.0, 2.0]], [[8.0, 3.0, 5.0], [1.0, 4.0, 5.0], [2.0, 6.0, 6.0], [3.0, 2.0, 
2.0]]])+(1.-msk_ref)*numpy.array([[[6.0, 6.0, 6.0], [4.0, 4.0, 8.0], [6.0, 5.0, 7.0], [6.0, 7.0, 7.0]], [[6.0, 6.0, 6.0], [8.0, 
7.0, 1.0], [5.0, 8.0, 8.0], [4.0, 5.0, 2.0]], [[8.0, 4.0, 2.0], [4.0, 8.0, 7.0], [8.0, 1.0, 3.0], [3.0, 7.0, 2.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_CPR(self):
      arg=Data(numpy.array([[[7.0, 6.0, 3.0], [6.0, 2.0, 2.0], [7.0, 7.0, 6.0], [4.0, 4.0, 5.0]], [[8.0, 2.0, 4.0], [5.0, 3.0, 
1.0], [5.0, 3.0, 2.0], [4.0, 6.0, 2.0]], [[4.0, 1.0, 6.0], [4.0, 2.0, 6.0], [5.0, 1.0, 3.0], [1.0, 2.0, 
8.0]]]),self.functionspace)
      val=Data(numpy.array([[3.0], [4.0], [6.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[5.0], [2.0], [6.0]]))
      arg[:,2,1:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[7.0, 6.0, 3.0], [6.0, 2.0, 2.0], [7.0, 3.0, 6.0], [4.0, 4.0, 5.0]], [[8.0, 2.0, 4.0], [5.0, 
3.0, 1.0], [5.0, 4.0, 2.0], [4.0, 6.0, 2.0]], [[4.0, 1.0, 6.0], [4.0, 2.0, 6.0], [5.0, 6.0, 3.0], [1.0, 2.0, 
8.0]]])+(1.-msk_ref)*numpy.array([[[7.0, 6.0, 3.0], [6.0, 2.0, 2.0], [7.0, 5.0, 6.0], [4.0, 4.0, 5.0]], [[8.0, 2.0, 4.0], [5.0, 
3.0, 1.0], [5.0, 2.0, 2.0], [4.0, 6.0, 2.0]], [[4.0, 1.0, 6.0], [4.0, 2.0, 6.0], [5.0, 6.0, 3.0], [1.0, 2.0, 8.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_UPN(self):
      arg=Data(numpy.array([[[6.0, 8.0, 2.0], [1.0, 8.0, 6.0], [4.0, 4.0, 2.0], [8.0, 8.0, 8.0]], [[4.0, 8.0, 8.0], [7.0, 5.0, 
1.0], [3.0, 1.0, 8.0], [2.0, 2.0, 1.0]], [[4.0, 3.0, 1.0], [6.0, 8.0, 8.0], [7.0, 4.0, 1.0], [7.0, 3.0, 
3.0]]]),self.functionspace)
      val=Data(numpy.array([[8.0, 1.0, 3.0], [7.0, 5.0, 6.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[3.0, 2.0, 4.0], [8.0, 2.0, 2.0]]))
      arg[:2,2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[6.0, 8.0, 2.0], [1.0, 8.0, 6.0], [8.0, 1.0, 3.0], [8.0, 8.0, 8.0]], [[4.0, 8.0, 8.0], [7.0, 
5.0, 1.0], [7.0, 5.0, 6.0], [2.0, 2.0, 1.0]], [[4.0, 3.0, 1.0], [6.0, 8.0, 8.0], [7.0, 4.0, 1.0], [7.0, 3.0, 
3.0]]])+(1.-msk_ref)*numpy.array([[[6.0, 8.0, 2.0], [1.0, 8.0, 6.0], [3.0, 2.0, 4.0], [8.0, 8.0, 8.0]], [[4.0, 8.0, 8.0], [7.0, 
5.0, 1.0], [8.0, 2.0, 2.0], [2.0, 2.0, 1.0]], [[4.0, 3.0, 1.0], [6.0, 8.0, 8.0], [7.0, 4.0, 1.0], [7.0, 3.0, 3.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_LUC(self):
      arg=Data(numpy.array([[[8.0, 1.0, 7.0], [7.0, 7.0, 8.0], [5.0, 2.0, 7.0], [2.0, 1.0, 7.0]], [[6.0, 1.0, 3.0], [8.0, 6.0, 
8.0], [1.0, 8.0, 4.0], [3.0, 2.0, 6.0]], [[7.0, 1.0, 5.0], [6.0, 1.0, 6.0], [4.0, 4.0, 2.0], [7.0, 2.0, 
7.0]]]),self.functionspace)
      val=Data(numpy.array([[[4.0, 1.0, 7.0], [1.0, 6.0, 5.0], [8.0, 3.0, 1.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[1.0, 7.0, 7.0], [5.0, 4.0, 5.0], [3.0, 3.0, 1.0]]]))
      arg[2:,:3,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[8.0, 1.0, 7.0], [7.0, 7.0, 8.0], [5.0, 2.0, 7.0], [2.0, 1.0, 7.0]], [[6.0, 1.0, 3.0], [8.0, 
6.0, 8.0], [1.0, 8.0, 4.0], [3.0, 2.0, 6.0]], [[4.0, 1.0, 7.0], [1.0, 6.0, 5.0], [8.0, 3.0, 1.0], [7.0, 2.0, 
7.0]]])+(1.-msk_ref)*numpy.array([[[8.0, 1.0, 7.0], [7.0, 7.0, 8.0], [5.0, 2.0, 7.0], [2.0, 1.0, 7.0]], [[6.0, 1.0, 3.0], [8.0, 
6.0, 8.0], [1.0, 8.0, 4.0], [3.0, 2.0, 6.0]], [[1.0, 7.0, 7.0], [5.0, 4.0, 5.0], [3.0, 3.0, 1.0], [7.0, 2.0, 7.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_LLN(self):
      arg=Data(numpy.array([[[8.0, 8.0, 4.0], [3.0, 6.0, 4.0], [8.0, 2.0, 2.0], [7.0, 3.0, 1.0]], [[6.0, 8.0, 2.0], [8.0, 1.0, 
5.0], [6.0, 6.0, 7.0], [3.0, 8.0, 1.0]], [[6.0, 2.0, 8.0], [1.0, 4.0, 5.0], [4.0, 6.0, 6.0], [6.0, 2.0, 
8.0]]]),self.functionspace)
      val=Data(numpy.array([[[4.0, 5.0, 8.0], [2.0, 2.0, 4.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[8.0, 2.0, 6.0], [6.0, 2.0, 1.0]]]))
      arg[2:,2:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[8.0, 8.0, 4.0], [3.0, 6.0, 4.0], [8.0, 2.0, 2.0], [7.0, 3.0, 1.0]], [[6.0, 8.0, 2.0], [8.0, 
1.0, 5.0], [6.0, 6.0, 7.0], [3.0, 8.0, 1.0]], [[6.0, 2.0, 8.0], [1.0, 4.0, 5.0], [4.0, 5.0, 8.0], [2.0, 2.0, 
4.0]]])+(1.-msk_ref)*numpy.array([[[8.0, 8.0, 4.0], [3.0, 6.0, 4.0], [8.0, 2.0, 2.0], [7.0, 3.0, 1.0]], [[6.0, 8.0, 2.0], [8.0, 
1.0, 5.0], [6.0, 6.0, 7.0], [3.0, 8.0, 1.0]], [[6.0, 2.0, 8.0], [1.0, 4.0, 5.0], [8.0, 2.0, 6.0], [6.0, 2.0, 1.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_RPL(self):
      arg=Data(numpy.array([[[4.0, 2.0, 6.0], [1.0, 8.0, 7.0], [5.0, 3.0, 5.0], [1.0, 2.0, 6.0]], [[4.0, 4.0, 3.0], [6.0, 5.0, 
5.0], [6.0, 1.0, 7.0], [4.0, 7.0, 3.0]], [[1.0, 4.0, 6.0], [8.0, 3.0, 7.0], [8.0, 8.0, 6.0], [5.0, 5.0, 
3.0]]]),self.functionspace)
      val=Data(numpy.array([[3.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[5.0]]))
      arg[1:2,2,2:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[4.0, 2.0, 6.0], [1.0, 8.0, 7.0], [5.0, 3.0, 5.0], [1.0, 2.0, 6.0]], [[4.0, 4.0, 3.0], [6.0, 
5.0, 5.0], [6.0, 1.0, 3.0], [4.0, 7.0, 3.0]], [[1.0, 4.0, 6.0], [8.0, 3.0, 7.0], [8.0, 8.0, 6.0], [5.0, 5.0, 
3.0]]])+(1.-msk_ref)*numpy.array([[[4.0, 2.0, 6.0], [1.0, 8.0, 7.0], [5.0, 3.0, 5.0], [1.0, 2.0, 6.0]], [[4.0, 4.0, 3.0], [6.0, 
5.0, 5.0], [6.0, 1.0, 5.0], [4.0, 7.0, 3.0]], [[1.0, 4.0, 6.0], [8.0, 3.0, 7.0], [8.0, 8.0, 6.0], [5.0, 5.0, 3.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_CLN(self):
      arg=Data(numpy.array([[[3.0, 2.0, 7.0], [8.0, 3.0, 1.0], [2.0, 4.0, 8.0], [5.0, 8.0, 7.0]], [[4.0, 8.0, 4.0], [1.0, 4.0, 
7.0], [8.0, 8.0, 6.0], [7.0, 6.0, 2.0]], [[7.0, 8.0, 6.0], [8.0, 4.0, 3.0], [3.0, 4.0, 4.0], [1.0, 4.0, 
8.0]]]),self.functionspace)
      val=Data(numpy.array([[[3.0, 8.0, 6.0], [2.0, 1.0, 3.0]], [[7.0, 8.0, 1.0], [3.0, 8.0, 2.0]], [[5.0, 7.0, 5.0], [4.0, 
3.0, 6.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[7.0, 8.0, 4.0], [3.0, 2.0, 5.0]], [[4.0, 7.0, 5.0], [2.0, 5.0, 5.0]], [[7.0, 4.0, 
8.0], [5.0, 3.0, 4.0]]]))
      arg[:,2:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[3.0, 2.0, 7.0], [8.0, 3.0, 1.0], [3.0, 8.0, 6.0], [2.0, 1.0, 3.0]], [[4.0, 8.0, 4.0], [1.0, 
4.0, 7.0], [7.0, 8.0, 1.0], [3.0, 8.0, 2.0]], [[7.0, 8.0, 6.0], [8.0, 4.0, 3.0], [5.0, 7.0, 5.0], [4.0, 3.0, 
6.0]]])+(1.-msk_ref)*numpy.array([[[3.0, 2.0, 7.0], [8.0, 3.0, 1.0], [7.0, 8.0, 4.0], [3.0, 2.0, 5.0]], [[4.0, 8.0, 4.0], [1.0, 
4.0, 7.0], [4.0, 7.0, 5.0], [2.0, 5.0, 5.0]], [[7.0, 8.0, 6.0], [8.0, 4.0, 3.0], [7.0, 4.0, 8.0], [5.0, 3.0, 4.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_UCR(self):
      arg=Data(numpy.array([[[2.0, 5.0, 1.0], [2.0, 1.0, 5.0], [8.0, 2.0, 5.0], [5.0, 7.0, 7.0]], [[2.0, 1.0, 6.0], [6.0, 5.0, 
1.0], [1.0, 7.0, 6.0], [3.0, 8.0, 6.0]], [[5.0, 5.0, 7.0], [2.0, 3.0, 5.0], [5.0, 6.0, 3.0], [2.0, 5.0, 
3.0]]]),self.functionspace)
      val=Data(numpy.array([[[4.0], [5.0], [1.0], [6.0]], [[8.0], [8.0], [2.0], [2.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[2.0], [8.0], [8.0], [1.0]], [[3.0], [8.0], [7.0], [6.0]]]))
      arg[:2,:,1:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[2.0, 4.0, 1.0], [2.0, 5.0, 5.0], [8.0, 1.0, 5.0], [5.0, 6.0, 7.0]], [[2.0, 8.0, 6.0], [6.0, 
8.0, 1.0], [1.0, 2.0, 6.0], [3.0, 2.0, 6.0]], [[5.0, 5.0, 7.0], [2.0, 3.0, 5.0], [5.0, 6.0, 3.0], [2.0, 5.0, 
3.0]]])+(1.-msk_ref)*numpy.array([[[2.0, 2.0, 1.0], [2.0, 8.0, 5.0], [8.0, 8.0, 5.0], [5.0, 1.0, 7.0]], [[2.0, 3.0, 6.0], [6.0, 
8.0, 1.0], [1.0, 7.0, 6.0], [3.0, 6.0, 6.0]], [[5.0, 5.0, 7.0], [2.0, 3.0, 5.0], [5.0, 6.0, 3.0], [2.0, 5.0, 3.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_ULN(self):
      arg=Data(numpy.array([[[3.0, 8.0, 4.0], [7.0, 7.0, 6.0], [6.0, 4.0, 6.0], [1.0, 5.0, 8.0]], [[5.0, 4.0, 7.0], [8.0, 4.0, 
3.0], [7.0, 2.0, 4.0], [5.0, 3.0, 4.0]], [[6.0, 7.0, 5.0], [8.0, 2.0, 6.0], [8.0, 1.0, 1.0], [7.0, 1.0, 
7.0]]]),self.functionspace)
      val=Data(numpy.array([[[6.0, 4.0, 4.0], [1.0, 4.0, 3.0]], [[3.0, 7.0, 3.0], [8.0, 6.0, 4.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[5.0, 7.0, 8.0], [5.0, 3.0, 2.0]], [[2.0, 8.0, 2.0], [5.0, 4.0, 8.0]]]))
      arg[:2,2:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[3.0, 8.0, 4.0], [7.0, 7.0, 6.0], [6.0, 4.0, 4.0], [1.0, 4.0, 3.0]], [[5.0, 4.0, 7.0], [8.0, 
4.0, 3.0], [3.0, 7.0, 3.0], [8.0, 6.0, 4.0]], [[6.0, 7.0, 5.0], [8.0, 2.0, 6.0], [8.0, 1.0, 1.0], [7.0, 1.0, 
7.0]]])+(1.-msk_ref)*numpy.array([[[3.0, 8.0, 4.0], [7.0, 7.0, 6.0], [5.0, 7.0, 8.0], [5.0, 3.0, 2.0]], [[5.0, 4.0, 7.0], [8.0, 
4.0, 3.0], [2.0, 8.0, 2.0], [5.0, 4.0, 8.0]], [[6.0, 7.0, 5.0], [8.0, 2.0, 6.0], [8.0, 1.0, 1.0], [7.0, 1.0, 7.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_PUN(self):
      arg=Data(numpy.array([[[2.0, 5.0, 4.0], [6.0, 7.0, 3.0], [1.0, 8.0, 4.0], [3.0, 7.0, 7.0]], [[3.0, 3.0, 5.0], [3.0, 2.0, 
8.0], [3.0, 2.0, 8.0], [5.0, 8.0, 3.0]], [[5.0, 5.0, 6.0], [4.0, 8.0, 7.0], [2.0, 2.0, 8.0], [6.0, 5.0, 
7.0]]]),self.functionspace)
      val=Data(numpy.array([[3.0, 3.0, 3.0], [7.0, 6.0, 4.0], [2.0, 5.0, 1.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[5.0, 7.0, 2.0], [1.0, 3.0, 5.0], [6.0, 8.0, 3.0]]))
      arg[1,:3]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[2.0, 5.0, 4.0], [6.0, 7.0, 3.0], [1.0, 8.0, 4.0], [3.0, 7.0, 7.0]], [[3.0, 3.0, 3.0], [7.0, 
6.0, 4.0], [2.0, 5.0, 1.0], [5.0, 8.0, 3.0]], [[5.0, 5.0, 6.0], [4.0, 8.0, 7.0], [2.0, 2.0, 8.0], [6.0, 5.0, 
7.0]]])+(1.-msk_ref)*numpy.array([[[2.0, 5.0, 4.0], [6.0, 7.0, 3.0], [1.0, 8.0, 4.0], [3.0, 7.0, 7.0]], [[5.0, 7.0, 2.0], [1.0, 
3.0, 5.0], [6.0, 8.0, 3.0], [5.0, 8.0, 3.0]], [[5.0, 5.0, 6.0], [4.0, 8.0, 7.0], [2.0, 2.0, 8.0], [6.0, 5.0, 7.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_RCN(self):
      arg=Data(numpy.array([[[7.0, 3.0, 7.0], [5.0, 3.0, 3.0], [3.0, 7.0, 8.0], [7.0, 2.0, 3.0]], [[6.0, 7.0, 6.0], [2.0, 6.0, 
1.0], [4.0, 8.0, 3.0], [6.0, 8.0, 8.0]], [[3.0, 6.0, 3.0], [5.0, 6.0, 6.0], [4.0, 2.0, 6.0], [4.0, 1.0, 
4.0]]]),self.functionspace)
      val=Data(numpy.array([[[7.0, 8.0, 2.0], [6.0, 6.0, 4.0], [3.0, 1.0, 2.0], [1.0, 6.0, 2.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[7.0, 5.0, 5.0], [4.0, 3.0, 2.0], [8.0, 7.0, 5.0], [4.0, 3.0, 6.0]]]))
      arg[1:2,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[7.0, 3.0, 7.0], [5.0, 3.0, 3.0], [3.0, 7.0, 8.0], [7.0, 2.0, 3.0]], [[7.0, 8.0, 2.0], [6.0, 
6.0, 4.0], [3.0, 1.0, 2.0], [1.0, 6.0, 2.0]], [[3.0, 6.0, 3.0], [5.0, 6.0, 6.0], [4.0, 2.0, 6.0], [4.0, 1.0, 
4.0]]])+(1.-msk_ref)*numpy.array([[[7.0, 3.0, 7.0], [5.0, 3.0, 3.0], [3.0, 7.0, 8.0], [7.0, 2.0, 3.0]], [[7.0, 5.0, 5.0], [4.0, 
3.0, 2.0], [8.0, 7.0, 5.0], [4.0, 3.0, 6.0]], [[3.0, 6.0, 3.0], [5.0, 6.0, 6.0], [4.0, 2.0, 6.0], [4.0, 1.0, 4.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_CRN(self):
      arg=Data(numpy.array([[[5.0, 3.0, 6.0], [2.0, 3.0, 8.0], [2.0, 6.0, 8.0], [8.0, 8.0, 4.0]], [[7.0, 2.0, 4.0], [7.0, 6.0, 
3.0], [2.0, 8.0, 3.0], [4.0, 1.0, 1.0]], [[5.0, 3.0, 4.0], [4.0, 3.0, 1.0], [1.0, 1.0, 1.0], [7.0, 5.0, 
2.0]]]),self.functionspace)
      val=Data(numpy.array([[[6.0, 1.0, 8.0], [5.0, 3.0, 5.0]], [[5.0, 6.0, 1.0], [5.0, 8.0, 3.0]], [[5.0, 8.0, 5.0], [5.0, 
3.0, 7.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[6.0, 2.0, 8.0], [5.0, 7.0, 3.0]], [[4.0, 1.0, 1.0], [7.0, 1.0, 3.0]], [[5.0, 8.0, 
3.0], [7.0, 4.0, 7.0]]]))
      arg[:,1:3]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[5.0, 3.0, 6.0], [6.0, 1.0, 8.0], [5.0, 3.0, 5.0], [8.0, 8.0, 4.0]], [[7.0, 2.0, 4.0], [5.0, 
6.0, 1.0], [5.0, 8.0, 3.0], [4.0, 1.0, 1.0]], [[5.0, 3.0, 4.0], [5.0, 8.0, 5.0], [5.0, 3.0, 7.0], [7.0, 5.0, 
2.0]]])+(1.-msk_ref)*numpy.array([[[5.0, 3.0, 6.0], [6.0, 2.0, 8.0], [5.0, 7.0, 3.0], [8.0, 8.0, 4.0]], [[7.0, 2.0, 4.0], [4.0, 
1.0, 1.0], [7.0, 1.0, 3.0], [4.0, 1.0, 1.0]], [[5.0, 3.0, 4.0], [5.0, 8.0, 3.0], [7.0, 4.0, 7.0], [7.0, 5.0, 2.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_UUN(self):
      arg=Data(numpy.array([[[8.0, 4.0, 8.0], [2.0, 3.0, 3.0], [2.0, 1.0, 4.0], [3.0, 1.0, 1.0]], [[2.0, 3.0, 6.0], [3.0, 7.0, 
3.0], [4.0, 7.0, 2.0], [6.0, 2.0, 3.0]], [[1.0, 3.0, 6.0], [2.0, 4.0, 4.0], [8.0, 2.0, 7.0], [2.0, 8.0, 
3.0]]]),self.functionspace)
      val=Data(numpy.array([[[1.0, 8.0, 4.0], [4.0, 4.0, 5.0], [1.0, 2.0, 3.0]], [[7.0, 5.0, 3.0], [8.0, 2.0, 6.0], [4.0, 6.0, 
5.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[4.0, 3.0, 3.0], [3.0, 3.0, 1.0], [1.0, 4.0, 1.0]], [[7.0, 5.0, 6.0], [6.0, 5.0, 2.0], 
[6.0, 7.0, 2.0]]]))
      arg[:2,:3]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[1.0, 8.0, 4.0], [4.0, 4.0, 5.0], [1.0, 2.0, 3.0], [3.0, 1.0, 1.0]], [[7.0, 5.0, 3.0], [8.0, 
2.0, 6.0], [4.0, 6.0, 5.0], [6.0, 2.0, 3.0]], [[1.0, 3.0, 6.0], [2.0, 4.0, 4.0], [8.0, 2.0, 7.0], [2.0, 8.0, 
3.0]]])+(1.-msk_ref)*numpy.array([[[4.0, 3.0, 3.0], [3.0, 3.0, 1.0], [1.0, 4.0, 1.0], [3.0, 1.0, 1.0]], [[7.0, 5.0, 6.0], [6.0, 
5.0, 2.0], [6.0, 7.0, 2.0], [6.0, 2.0, 3.0]], [[1.0, 3.0, 6.0], [2.0, 4.0, 4.0], [8.0, 2.0, 7.0], [2.0, 8.0, 3.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_UCP(self):
      arg=Data(numpy.array([[[5.0, 6.0, 4.0], [6.0, 4.0, 3.0], [7.0, 1.0, 2.0], [8.0, 2.0, 6.0]], [[6.0, 4.0, 1.0], [8.0, 1.0, 
4.0], [7.0, 4.0, 2.0], [3.0, 6.0, 8.0]], [[1.0, 1.0, 4.0], [8.0, 6.0, 3.0], [6.0, 3.0, 4.0], [6.0, 2.0, 
1.0]]]),self.functionspace)
      val=Data(numpy.array([[2.0, 4.0, 2.0, 7.0], [1.0, 3.0, 1.0, 6.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[3.0, 7.0, 1.0, 5.0], [7.0, 3.0, 7.0, 7.0]]))
      arg[:2,:,1]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[5.0, 2.0, 4.0], [6.0, 4.0, 3.0], [7.0, 2.0, 2.0], [8.0, 7.0, 6.0]], [[6.0, 1.0, 1.0], [8.0, 
3.0, 4.0], [7.0, 1.0, 2.0], [3.0, 6.0, 8.0]], [[1.0, 1.0, 4.0], [8.0, 6.0, 3.0], [6.0, 3.0, 4.0], [6.0, 2.0, 
1.0]]])+(1.-msk_ref)*numpy.array([[[5.0, 3.0, 4.0], [6.0, 7.0, 3.0], [7.0, 1.0, 2.0], [8.0, 5.0, 6.0]], [[6.0, 7.0, 1.0], [8.0, 
3.0, 4.0], [7.0, 7.0, 2.0], [3.0, 7.0, 8.0]], [[1.0, 1.0, 4.0], [8.0, 6.0, 3.0], [6.0, 3.0, 4.0], [6.0, 2.0, 1.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_RUN(self):
      arg=Data(numpy.array([[[1.0, 5.0, 2.0], [6.0, 7.0, 5.0], [2.0, 8.0, 7.0], [2.0, 4.0, 2.0]], [[3.0, 6.0, 8.0], [2.0, 8.0, 
7.0], [8.0, 4.0, 5.0], [2.0, 1.0, 7.0]], [[4.0, 4.0, 4.0], [4.0, 1.0, 3.0], [8.0, 8.0, 8.0], [7.0, 2.0, 
6.0]]]),self.functionspace)
      val=Data(numpy.array([[[3.0, 3.0, 8.0], [3.0, 3.0, 1.0], [4.0, 2.0, 4.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[5.0, 6.0, 3.0], [8.0, 1.0, 7.0], [1.0, 4.0, 3.0]]]))
      arg[1:2,:3]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[1.0, 5.0, 2.0], [6.0, 7.0, 5.0], [2.0, 8.0, 7.0], [2.0, 4.0, 2.0]], [[3.0, 3.0, 8.0], [3.0, 
3.0, 1.0], [4.0, 2.0, 4.0], [2.0, 1.0, 7.0]], [[4.0, 4.0, 4.0], [4.0, 1.0, 3.0], [8.0, 8.0, 8.0], [7.0, 2.0, 
6.0]]])+(1.-msk_ref)*numpy.array([[[1.0, 5.0, 2.0], [6.0, 7.0, 5.0], [2.0, 8.0, 7.0], [2.0, 4.0, 2.0]], [[5.0, 6.0, 3.0], [8.0, 
1.0, 7.0], [1.0, 4.0, 3.0], [2.0, 1.0, 7.0]], [[4.0, 4.0, 4.0], [4.0, 1.0, 3.0], [8.0, 8.0, 8.0], [7.0, 2.0, 6.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_CUN(self):
      arg=Data(numpy.array([[[5.0, 4.0, 2.0], [8.0, 8.0, 6.0], [3.0, 2.0, 3.0], [8.0, 2.0, 4.0]], [[7.0, 1.0, 6.0], [3.0, 1.0, 
4.0], [6.0, 6.0, 4.0], [8.0, 8.0, 4.0]], [[4.0, 2.0, 6.0], [5.0, 5.0, 5.0], [3.0, 4.0, 1.0], [2.0, 6.0, 
4.0]]]),self.functionspace)
      val=Data(numpy.array([[[7.0, 4.0, 1.0], [2.0, 6.0, 8.0], [7.0, 7.0, 4.0]], [[2.0, 1.0, 5.0], [7.0, 7.0, 1.0], [6.0, 6.0, 
6.0]], [[4.0, 7.0, 4.0], [3.0, 4.0, 5.0], [2.0, 4.0, 1.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[4.0, 5.0, 1.0], [4.0, 1.0, 3.0], [3.0, 2.0, 5.0]], [[2.0, 8.0, 7.0], [6.0, 4.0, 1.0], 
[8.0, 4.0, 6.0]], [[6.0, 1.0, 3.0], [2.0, 4.0, 1.0], [6.0, 3.0, 2.0]]]))
      arg[:,:3]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[7.0, 4.0, 1.0], [2.0, 6.0, 8.0], [7.0, 7.0, 4.0], [8.0, 2.0, 4.0]], [[2.0, 1.0, 5.0], [7.0, 
7.0, 1.0], [6.0, 6.0, 6.0], [8.0, 8.0, 4.0]], [[4.0, 7.0, 4.0], [3.0, 4.0, 5.0], [2.0, 4.0, 1.0], [2.0, 6.0, 
4.0]]])+(1.-msk_ref)*numpy.array([[[4.0, 5.0, 1.0], [4.0, 1.0, 3.0], [3.0, 2.0, 5.0], [8.0, 2.0, 4.0]], [[2.0, 8.0, 7.0], [6.0, 
4.0, 1.0], [8.0, 4.0, 6.0], [8.0, 8.0, 4.0]], [[6.0, 1.0, 3.0], [2.0, 4.0, 1.0], [6.0, 3.0, 2.0], [2.0, 6.0, 4.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_LLC(self):
      arg=Data(numpy.array([[[2.0, 6.0, 6.0], [2.0, 6.0, 5.0], [1.0, 6.0, 8.0], [4.0, 7.0, 1.0]], [[6.0, 8.0, 8.0], [5.0, 2.0, 
5.0], [2.0, 5.0, 4.0], [5.0, 1.0, 1.0]], [[3.0, 5.0, 8.0], [3.0, 3.0, 4.0], [7.0, 7.0, 3.0], [8.0, 5.0, 
5.0]]]),self.functionspace)
      val=Data(numpy.array([[[5.0, 4.0, 6.0], [8.0, 5.0, 7.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[2.0, 4.0, 5.0], [3.0, 6.0, 7.0]]]))
      arg[2:,2:,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[2.0, 6.0, 6.0], [2.0, 6.0, 5.0], [1.0, 6.0, 8.0], [4.0, 7.0, 1.0]], [[6.0, 8.0, 8.0], [5.0, 
2.0, 5.0], [2.0, 5.0, 4.0], [5.0, 1.0, 1.0]], [[3.0, 5.0, 8.0], [3.0, 3.0, 4.0], [5.0, 4.0, 6.0], [8.0, 5.0, 
7.0]]])+(1.-msk_ref)*numpy.array([[[2.0, 6.0, 6.0], [2.0, 6.0, 5.0], [1.0, 6.0, 8.0], [4.0, 7.0, 1.0]], [[6.0, 8.0, 8.0], [5.0, 
2.0, 5.0], [2.0, 5.0, 4.0], [5.0, 1.0, 1.0]], [[3.0, 5.0, 8.0], [3.0, 3.0, 4.0], [2.0, 4.0, 5.0], [3.0, 6.0, 7.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_RRN(self):
      arg=Data(numpy.array([[[4.0, 3.0, 1.0], [2.0, 2.0, 6.0], [7.0, 8.0, 7.0], [5.0, 4.0, 3.0]], [[5.0, 6.0, 8.0], [3.0, 3.0, 
8.0], [1.0, 4.0, 1.0], [3.0, 8.0, 1.0]], [[4.0, 8.0, 4.0], [2.0, 5.0, 7.0], [7.0, 5.0, 1.0], [5.0, 3.0, 
3.0]]]),self.functionspace)
      val=Data(numpy.array([[[5.0, 7.0, 3.0], [7.0, 7.0, 4.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[1.0, 4.0, 5.0], [7.0, 8.0, 2.0]]]))
      arg[1:2,1:3]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[4.0, 3.0, 1.0], [2.0, 2.0, 6.0], [7.0, 8.0, 7.0], [5.0, 4.0, 3.0]], [[5.0, 6.0, 8.0], [5.0, 
7.0, 3.0], [7.0, 7.0, 4.0], [3.0, 8.0, 1.0]], [[4.0, 8.0, 4.0], [2.0, 5.0, 7.0], [7.0, 5.0, 1.0], [5.0, 3.0, 
3.0]]])+(1.-msk_ref)*numpy.array([[[4.0, 3.0, 1.0], [2.0, 2.0, 6.0], [7.0, 8.0, 7.0], [5.0, 4.0, 3.0]], [[5.0, 6.0, 8.0], [1.0, 
4.0, 5.0], [7.0, 8.0, 2.0], [3.0, 8.0, 1.0]], [[4.0, 8.0, 4.0], [2.0, 5.0, 7.0], [7.0, 5.0, 1.0], [5.0, 3.0, 3.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_LUN(self):
      arg=Data(numpy.array([[[7.0, 3.0, 4.0], [3.0, 4.0, 3.0], [8.0, 7.0, 6.0], [8.0, 4.0, 7.0]], [[3.0, 8.0, 8.0], [5.0, 2.0, 
4.0], [3.0, 7.0, 6.0], [4.0, 1.0, 1.0]], [[3.0, 2.0, 7.0], [7.0, 5.0, 1.0], [6.0, 1.0, 1.0], [3.0, 3.0, 
5.0]]]),self.functionspace)
      val=Data(numpy.array([[[3.0, 3.0, 8.0], [6.0, 6.0, 3.0], [6.0, 6.0, 7.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[5.0, 2.0, 3.0], [1.0, 4.0, 8.0], [2.0, 3.0, 7.0]]]))
      arg[2:,:3]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[7.0, 3.0, 4.0], [3.0, 4.0, 3.0], [8.0, 7.0, 6.0], [8.0, 4.0, 7.0]], [[3.0, 8.0, 8.0], [5.0, 
2.0, 4.0], [3.0, 7.0, 6.0], [4.0, 1.0, 1.0]], [[3.0, 3.0, 8.0], [6.0, 6.0, 3.0], [6.0, 6.0, 7.0], [3.0, 3.0, 
5.0]]])+(1.-msk_ref)*numpy.array([[[7.0, 3.0, 4.0], [3.0, 4.0, 3.0], [8.0, 7.0, 6.0], [8.0, 4.0, 7.0]], [[3.0, 8.0, 8.0], [5.0, 
2.0, 4.0], [3.0, 7.0, 6.0], [4.0, 1.0, 1.0]], [[5.0, 2.0, 3.0], [1.0, 4.0, 8.0], [2.0, 3.0, 7.0], [3.0, 3.0, 5.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_RLN(self):
      arg=Data(numpy.array([[[5.0, 8.0, 4.0], [6.0, 2.0, 6.0], [1.0, 6.0, 6.0], [1.0, 7.0, 2.0]], [[6.0, 3.0, 3.0], [3.0, 1.0, 
5.0], [1.0, 7.0, 4.0], [8.0, 2.0, 8.0]], [[1.0, 1.0, 4.0], [3.0, 2.0, 6.0], [8.0, 7.0, 8.0], [2.0, 1.0, 
3.0]]]),self.functionspace)
      val=Data(numpy.array([[[6.0, 8.0, 8.0], [7.0, 4.0, 4.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[3.0, 4.0, 3.0], [8.0, 4.0, 4.0]]]))
      arg[1:2,2:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[5.0, 8.0, 4.0], [6.0, 2.0, 6.0], [1.0, 6.0, 6.0], [1.0, 7.0, 2.0]], [[6.0, 3.0, 3.0], [3.0, 
1.0, 5.0], [6.0, 8.0, 8.0], [7.0, 4.0, 4.0]], [[1.0, 1.0, 4.0], [3.0, 2.0, 6.0], [8.0, 7.0, 8.0], [2.0, 1.0, 
3.0]]])+(1.-msk_ref)*numpy.array([[[5.0, 8.0, 4.0], [6.0, 2.0, 6.0], [1.0, 6.0, 6.0], [1.0, 7.0, 2.0]], [[6.0, 3.0, 3.0], [3.0, 
1.0, 5.0], [3.0, 4.0, 3.0], [8.0, 4.0, 4.0]], [[1.0, 1.0, 4.0], [3.0, 2.0, 6.0], [8.0, 7.0, 8.0], [2.0, 1.0, 3.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_PLL(self):
      arg=Data(numpy.array([[[6.0, 1.0, 2.0], [6.0, 3.0, 5.0], [6.0, 7.0, 1.0], [3.0, 3.0, 5.0]], [[6.0, 2.0, 5.0], [5.0, 8.0, 
6.0], [6.0, 4.0, 1.0], [3.0, 2.0, 5.0]], [[8.0, 8.0, 7.0], [7.0, 1.0, 1.0], [7.0, 5.0, 1.0], [1.0, 1.0, 
7.0]]]),self.functionspace)
      val=Data(numpy.array([[7.0], [8.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[3.0], [2.0]]))
      arg[1,2:,2:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[6.0, 1.0, 2.0], [6.0, 3.0, 5.0], [6.0, 7.0, 1.0], [3.0, 3.0, 5.0]], [[6.0, 2.0, 5.0], [5.0, 
8.0, 6.0], [6.0, 4.0, 7.0], [3.0, 2.0, 8.0]], [[8.0, 8.0, 7.0], [7.0, 1.0, 1.0], [7.0, 5.0, 1.0], [1.0, 1.0, 
7.0]]])+(1.-msk_ref)*numpy.array([[[6.0, 1.0, 2.0], [6.0, 3.0, 5.0], [6.0, 7.0, 1.0], [3.0, 3.0, 5.0]], [[6.0, 2.0, 5.0], [5.0, 
8.0, 6.0], [6.0, 4.0, 3.0], [3.0, 2.0, 2.0]], [[8.0, 8.0, 7.0], [7.0, 1.0, 1.0], [7.0, 5.0, 1.0], [1.0, 1.0, 7.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_PLN(self):
      arg=Data(numpy.array([[[3.0, 2.0, 6.0], [4.0, 8.0, 3.0], [4.0, 2.0, 1.0], [8.0, 3.0, 1.0]], [[4.0, 2.0, 3.0], [7.0, 7.0, 
6.0], [5.0, 5.0, 4.0], [8.0, 7.0, 8.0]], [[7.0, 1.0, 1.0], [4.0, 7.0, 2.0], [3.0, 7.0, 2.0], [8.0, 8.0, 
1.0]]]),self.functionspace)
      val=Data(numpy.array([[1.0, 5.0, 4.0], [7.0, 3.0, 3.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[3.0, 2.0, 6.0], [7.0, 4.0, 2.0]]))
      arg[1,2:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[3.0, 2.0, 6.0], [4.0, 8.0, 3.0], [4.0, 2.0, 1.0], [8.0, 3.0, 1.0]], [[4.0, 2.0, 3.0], [7.0, 
7.0, 6.0], [1.0, 5.0, 4.0], [7.0, 3.0, 3.0]], [[7.0, 1.0, 1.0], [4.0, 7.0, 2.0], [3.0, 7.0, 2.0], [8.0, 8.0, 
1.0]]])+(1.-msk_ref)*numpy.array([[[3.0, 2.0, 6.0], [4.0, 8.0, 3.0], [4.0, 2.0, 1.0], [8.0, 3.0, 1.0]], [[4.0, 2.0, 3.0], [7.0, 
7.0, 6.0], [3.0, 2.0, 6.0], [7.0, 4.0, 2.0]], [[7.0, 1.0, 1.0], [4.0, 7.0, 2.0], [3.0, 7.0, 2.0], [8.0, 8.0, 1.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_LPN(self):
      arg=Data(numpy.array([[[7.0, 5.0, 8.0], [5.0, 8.0, 2.0], [5.0, 7.0, 8.0], [2.0, 6.0, 4.0]], [[8.0, 1.0, 2.0], [7.0, 5.0, 
3.0], [6.0, 5.0, 3.0], [1.0, 8.0, 3.0]], [[8.0, 5.0, 1.0], [2.0, 1.0, 2.0], [8.0, 3.0, 6.0], [8.0, 4.0, 
7.0]]]),self.functionspace)
      val=Data(numpy.array([[7.0, 1.0, 3.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[8.0, 4.0, 7.0]]))
      arg[2:,2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[7.0, 5.0, 8.0], [5.0, 8.0, 2.0], [5.0, 7.0, 8.0], [2.0, 6.0, 4.0]], [[8.0, 1.0, 2.0], [7.0, 
5.0, 3.0], [6.0, 5.0, 3.0], [1.0, 8.0, 3.0]], [[8.0, 5.0, 1.0], [2.0, 1.0, 2.0], [7.0, 1.0, 3.0], [8.0, 4.0, 
7.0]]])+(1.-msk_ref)*numpy.array([[[7.0, 5.0, 8.0], [5.0, 8.0, 2.0], [5.0, 7.0, 8.0], [2.0, 6.0, 4.0]], [[8.0, 1.0, 2.0], [7.0, 
5.0, 3.0], [6.0, 5.0, 3.0], [1.0, 8.0, 3.0]], [[8.0, 5.0, 1.0], [2.0, 1.0, 2.0], [8.0, 4.0, 7.0], [8.0, 4.0, 7.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_CCC(self):
      arg=Data(numpy.array([[[6.0, 3.0, 8.0], [1.0, 6.0, 1.0], [5.0, 7.0, 7.0], [2.0, 8.0, 2.0]], [[8.0, 8.0, 5.0], [8.0, 7.0, 
2.0], [1.0, 6.0, 4.0], [8.0, 2.0, 8.0]], [[2.0, 6.0, 8.0], [2.0, 4.0, 4.0], [6.0, 5.0, 1.0], [7.0, 5.0, 
8.0]]]),self.functionspace)
      val=Data(numpy.array([[[6.0, 2.0, 2.0], [8.0, 1.0, 5.0], [2.0, 4.0, 1.0], [7.0, 6.0, 6.0]], [[1.0, 7.0, 5.0], [3.0, 4.0, 
2.0], [6.0, 7.0, 5.0], [1.0, 8.0, 6.0]], [[2.0, 4.0, 5.0], [3.0, 1.0, 5.0], [5.0, 1.0, 6.0], [2.0, 6.0, 
4.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[6.0, 3.0, 4.0], [8.0, 2.0, 1.0], [5.0, 1.0, 3.0], [4.0, 6.0, 3.0]], [[3.0, 3.0, 1.0], 
[1.0, 6.0, 5.0], [8.0, 3.0, 6.0], [5.0, 3.0, 6.0]], [[6.0, 3.0, 3.0], [1.0, 5.0, 5.0], [5.0, 5.0, 1.0], [6.0, 4.0, 8.0]]]))
      arg[:,:,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[6.0, 2.0, 2.0], [8.0, 1.0, 5.0], [2.0, 4.0, 1.0], [7.0, 6.0, 6.0]], [[1.0, 7.0, 5.0], [3.0, 
4.0, 2.0], [6.0, 7.0, 5.0], [1.0, 8.0, 6.0]], [[2.0, 4.0, 5.0], [3.0, 1.0, 5.0], [5.0, 1.0, 6.0], [2.0, 6.0, 
4.0]]])+(1.-msk_ref)*numpy.array([[[6.0, 3.0, 4.0], [8.0, 2.0, 1.0], [5.0, 1.0, 3.0], [4.0, 6.0, 3.0]], [[3.0, 3.0, 1.0], [1.0, 
6.0, 5.0], [8.0, 3.0, 6.0], [5.0, 3.0, 6.0]], [[6.0, 3.0, 3.0], [1.0, 5.0, 5.0], [5.0, 5.0, 1.0], [6.0, 4.0, 8.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_LRC(self):
      arg=Data(numpy.array([[[8.0, 3.0, 4.0], [5.0, 8.0, 4.0], [5.0, 2.0, 7.0], [7.0, 6.0, 7.0]], [[2.0, 2.0, 1.0], [1.0, 3.0, 
2.0], [2.0, 3.0, 3.0], [4.0, 4.0, 8.0]], [[4.0, 4.0, 1.0], [2.0, 6.0, 1.0], [5.0, 5.0, 2.0], [5.0, 6.0, 
5.0]]]),self.functionspace)
      val=Data(numpy.array([[[4.0, 2.0, 8.0], [3.0, 2.0, 6.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[2.0, 1.0, 8.0], [5.0, 3.0, 7.0]]]))
      arg[2:,1:3,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[8.0, 3.0, 4.0], [5.0, 8.0, 4.0], [5.0, 2.0, 7.0], [7.0, 6.0, 7.0]], [[2.0, 2.0, 1.0], [1.0, 
3.0, 2.0], [2.0, 3.0, 3.0], [4.0, 4.0, 8.0]], [[4.0, 4.0, 1.0], [4.0, 2.0, 8.0], [3.0, 2.0, 6.0], [5.0, 6.0, 
5.0]]])+(1.-msk_ref)*numpy.array([[[8.0, 3.0, 4.0], [5.0, 8.0, 4.0], [5.0, 2.0, 7.0], [7.0, 6.0, 7.0]], [[2.0, 2.0, 1.0], [1.0, 
3.0, 2.0], [2.0, 3.0, 3.0], [4.0, 4.0, 8.0]], [[4.0, 4.0, 1.0], [2.0, 1.0, 8.0], [5.0, 3.0, 7.0], [5.0, 6.0, 5.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_CCN(self):
      arg=Data(numpy.array([[[2.0, 2.0, 4.0], [4.0, 3.0, 3.0], [2.0, 8.0, 5.0], [4.0, 5.0, 2.0]], [[2.0, 5.0, 8.0], [7.0, 1.0, 
1.0], [4.0, 6.0, 7.0], [6.0, 6.0, 2.0]], [[7.0, 4.0, 4.0], [1.0, 8.0, 8.0], [8.0, 1.0, 7.0], [5.0, 7.0, 
4.0]]]),self.functionspace)
      val=Data(numpy.array([[[6.0, 7.0, 8.0], [6.0, 8.0, 6.0], [8.0, 3.0, 6.0], [7.0, 2.0, 4.0]], [[4.0, 6.0, 1.0], [8.0, 7.0, 
8.0], [4.0, 1.0, 2.0], [1.0, 8.0, 7.0]], [[2.0, 4.0, 8.0], [1.0, 7.0, 7.0], [7.0, 4.0, 4.0], [8.0, 5.0, 
1.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[3.0, 7.0, 7.0], [3.0, 4.0, 5.0], [4.0, 6.0, 6.0], [4.0, 1.0, 3.0]], [[7.0, 5.0, 8.0], 
[6.0, 8.0, 5.0], [5.0, 2.0, 2.0], [7.0, 6.0, 5.0]], [[2.0, 8.0, 8.0], [6.0, 2.0, 4.0], [7.0, 6.0, 1.0], [4.0, 5.0, 6.0]]]))
      arg[:,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[6.0, 7.0, 8.0], [6.0, 8.0, 6.0], [8.0, 3.0, 6.0], [7.0, 2.0, 4.0]], [[4.0, 6.0, 1.0], [8.0, 
7.0, 8.0], [4.0, 1.0, 2.0], [1.0, 8.0, 7.0]], [[2.0, 4.0, 8.0], [1.0, 7.0, 7.0], [7.0, 4.0, 4.0], [8.0, 5.0, 
1.0]]])+(1.-msk_ref)*numpy.array([[[3.0, 7.0, 7.0], [3.0, 4.0, 5.0], [4.0, 6.0, 6.0], [4.0, 1.0, 3.0]], [[7.0, 5.0, 8.0], [6.0, 
8.0, 5.0], [5.0, 2.0, 2.0], [7.0, 6.0, 5.0]], [[2.0, 8.0, 8.0], [6.0, 2.0, 4.0], [7.0, 6.0, 1.0], [4.0, 5.0, 6.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank3_taggedData_UPL(self):
      arg=Data(numpy.array([[[7.0, 2.0, 5.0], [2.0, 7.0, 3.0], [2.0, 7.0, 4.0], [1.0, 3.0, 1.0]], [[5.0, 8.0, 8.0], [2.0, 2.0, 
1.0], [4.0, 5.0, 5.0], [6.0, 2.0, 3.0]], [[4.0, 3.0, 4.0], [2.0, 4.0, 4.0], [2.0, 1.0, 7.0], [7.0, 8.0, 
8.0]]]),self.functionspace)
      val=Data(numpy.array([[3.0], [6.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[5.0], [6.0]]))
      arg[:2,2,2:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[7.0, 2.0, 5.0], [2.0, 7.0, 3.0], [2.0, 7.0, 3.0], [1.0, 3.0, 1.0]], [[5.0, 8.0, 8.0], [2.0, 
2.0, 1.0], [4.0, 5.0, 6.0], [6.0, 2.0, 3.0]], [[4.0, 3.0, 4.0], [2.0, 4.0, 4.0], [2.0, 1.0, 7.0], [7.0, 8.0, 
8.0]]])+(1.-msk_ref)*numpy.array([[[7.0, 2.0, 5.0], [2.0, 7.0, 3.0], [2.0, 7.0, 5.0], [1.0, 3.0, 1.0]], [[5.0, 8.0, 8.0], [2.0, 
2.0, 1.0], [4.0, 5.0, 6.0], [6.0, 2.0, 3.0]], [[4.0, 3.0, 4.0], [2.0, 4.0, 4.0], [2.0, 1.0, 7.0], [7.0, 8.0, 8.0]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank4_taggedData_CLCP(self):
      arg=Data(numpy.array([[[[8.0, 8.0, 6.0], [6.0, 4.0, 2.0], [5.0, 7.0, 8.0]], [[5.0, 7.0, 3.0], [1.0, 8.0, 6.0], [1.0, 3.0, 
5.0]], [[8.0, 3.0, 3.0], [2.0, 6.0, 5.0], [3.0, 2.0, 6.0]]], [[[5.0, 3.0, 3.0], [2.0, 6.0, 1.0], [3.0, 6.0, 7.0]], [[8.0, 8.0, 
2.0], [5.0, 4.0, 4.0], [3.0, 3.0, 4.0]], [[3.0, 3.0, 8.0], [5.0, 2.0, 8.0], [8.0, 1.0, 5.0]]], [[[3.0, 6.0, 7.0], [6.0, 7.0, 
1.0], [2.0, 1.0, 2.0]], [[1.0, 6.0, 3.0], [2.0, 5.0, 8.0], [6.0, 1.0, 6.0]], [[6.0, 3.0, 5.0], [4.0, 6.0, 4.0], [1.0, 2.0, 
4.0]]], [[[5.0, 8.0, 6.0], [8.0, 2.0, 6.0], [1.0, 2.0, 3.0]], [[6.0, 8.0, 5.0], [1.0, 3.0, 8.0], [6.0, 8.0, 3.0]], [[5.0, 4.0, 
6.0], [1.0, 5.0, 4.0], [6.0, 6.0, 1.0]]]]),self.functionspace)
      val=Data(numpy.array([[[3.0, 3.0, 8.0]], [[6.0, 2.0, 1.0]], [[7.0, 4.0, 8.0]], [[2.0, 2.0, 3.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[6.0, 3.0, 8.0]], [[8.0, 8.0, 4.0]], [[7.0, 4.0, 3.0]], [[6.0, 1.0, 2.0]]]))
      arg[:,2:,:,1]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[8.0, 8.0, 6.0], [6.0, 4.0, 2.0], [5.0, 7.0, 8.0]], [[5.0, 7.0, 3.0], [1.0, 8.0, 6.0], [1.0, 
3.0, 5.0]], [[8.0, 3.0, 3.0], [2.0, 3.0, 5.0], [3.0, 8.0, 6.0]]], [[[5.0, 3.0, 3.0], [2.0, 6.0, 1.0], [3.0, 6.0, 7.0]], [[8.0, 
8.0, 2.0], [5.0, 4.0, 4.0], [3.0, 3.0, 4.0]], [[3.0, 6.0, 8.0], [5.0, 2.0, 8.0], [8.0, 1.0, 5.0]]], [[[3.0, 6.0, 7.0], [6.0, 
7.0, 1.0], [2.0, 1.0, 2.0]], [[1.0, 6.0, 3.0], [2.0, 5.0, 8.0], [6.0, 1.0, 6.0]], [[6.0, 7.0, 5.0], [4.0, 4.0, 4.0], [1.0, 8.0, 
4.0]]], [[[5.0, 8.0, 6.0], [8.0, 2.0, 6.0], [1.0, 2.0, 3.0]], [[6.0, 8.0, 5.0], [1.0, 3.0, 8.0], [6.0, 8.0, 3.0]], [[5.0, 2.0, 
6.0], [1.0, 2.0, 4.0], [6.0, 3.0, 1.0]]]])+(1.-msk_ref)*numpy.array([[[[8.0, 8.0, 6.0], [6.0, 4.0, 2.0], [5.0, 7.0, 8.0]], 
[[5.0, 7.0, 3.0], [1.0, 8.0, 6.0], [1.0, 3.0, 5.0]], [[8.0, 6.0, 3.0], [2.0, 3.0, 5.0], [3.0, 8.0, 6.0]]], [[[5.0, 3.0, 3.0], 
[2.0, 6.0, 1.0], [3.0, 6.0, 7.0]], [[8.0, 8.0, 2.0], [5.0, 4.0, 4.0], [3.0, 3.0, 4.0]], [[3.0, 8.0, 8.0], [5.0, 8.0, 8.0], 
[8.0, 4.0, 5.0]]], [[[3.0, 6.0, 7.0], [6.0, 7.0, 1.0], [2.0, 1.0, 2.0]], [[1.0, 6.0, 3.0], [2.0, 5.0, 8.0], [6.0, 1.0, 6.0]], 
[[6.0, 7.0, 5.0], [4.0, 4.0, 4.0], [1.0, 3.0, 4.0]]], [[[5.0, 8.0, 6.0], [8.0, 2.0, 6.0], [1.0, 2.0, 3.0]], [[6.0, 8.0, 5.0], 
[1.0, 3.0, 8.0], [6.0, 8.0, 3.0]], [[5.0, 6.0, 6.0], [1.0, 1.0, 4.0], [6.0, 2.0, 1.0]]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank4_taggedData_RUCP(self):
      arg=Data(numpy.array([[[[2.0, 3.0, 5.0], [1.0, 3.0, 5.0], [8.0, 6.0, 5.0]], [[5.0, 4.0, 3.0], [4.0, 3.0, 5.0], [4.0, 5.0, 
4.0]], [[3.0, 2.0, 5.0], [4.0, 8.0, 2.0], [8.0, 2.0, 1.0]]], [[[1.0, 4.0, 5.0], [7.0, 8.0, 1.0], [7.0, 2.0, 2.0]], [[6.0, 1.0, 
6.0], [8.0, 3.0, 4.0], [3.0, 5.0, 5.0]], [[5.0, 2.0, 7.0], [3.0, 7.0, 5.0], [7.0, 7.0, 8.0]]], [[[2.0, 7.0, 6.0], [2.0, 8.0, 
8.0], [8.0, 4.0, 5.0]], [[5.0, 6.0, 7.0], [3.0, 2.0, 3.0], [1.0, 5.0, 3.0]], [[8.0, 7.0, 3.0], [7.0, 7.0, 2.0], [8.0, 5.0, 
1.0]]], [[[6.0, 7.0, 8.0], [1.0, 2.0, 2.0], [5.0, 2.0, 7.0]], [[3.0, 2.0, 8.0], [6.0, 7.0, 2.0], [6.0, 5.0, 1.0]], [[4.0, 4.0, 
7.0], [6.0, 8.0, 3.0], [7.0, 1.0, 5.0]]]]),self.functionspace)
      val=Data(numpy.array([[[7.0, 8.0, 8.0], [1.0, 8.0, 4.0]], [[6.0, 6.0, 6.0], [5.0, 6.0, 6.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[8.0, 1.0, 3.0], [3.0, 3.0, 4.0]], [[6.0, 6.0, 7.0], [4.0, 6.0, 3.0]]]))
      arg[1:3,:2,:,1]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[2.0, 3.0, 5.0], [1.0, 3.0, 5.0], [8.0, 6.0, 5.0]], [[5.0, 4.0, 3.0], [4.0, 3.0, 5.0], [4.0, 
5.0, 4.0]], [[3.0, 2.0, 5.0], [4.0, 8.0, 2.0], [8.0, 2.0, 1.0]]], [[[1.0, 7.0, 5.0], [7.0, 8.0, 1.0], [7.0, 8.0, 2.0]], [[6.0, 
1.0, 6.0], [8.0, 8.0, 4.0], [3.0, 4.0, 5.0]], [[5.0, 2.0, 7.0], [3.0, 7.0, 5.0], [7.0, 7.0, 8.0]]], [[[2.0, 6.0, 6.0], [2.0, 
6.0, 8.0], [8.0, 6.0, 5.0]], [[5.0, 5.0, 7.0], [3.0, 6.0, 3.0], [1.0, 6.0, 3.0]], [[8.0, 7.0, 3.0], [7.0, 7.0, 2.0], [8.0, 5.0, 
1.0]]], [[[6.0, 7.0, 8.0], [1.0, 2.0, 2.0], [5.0, 2.0, 7.0]], [[3.0, 2.0, 8.0], [6.0, 7.0, 2.0], [6.0, 5.0, 1.0]], [[4.0, 4.0, 
7.0], [6.0, 8.0, 3.0], [7.0, 1.0, 5.0]]]])+(1.-msk_ref)*numpy.array([[[[2.0, 3.0, 5.0], [1.0, 3.0, 5.0], [8.0, 6.0, 5.0]], 
[[5.0, 4.0, 3.0], [4.0, 3.0, 5.0], [4.0, 5.0, 4.0]], [[3.0, 2.0, 5.0], [4.0, 8.0, 2.0], [8.0, 2.0, 1.0]]], [[[1.0, 8.0, 5.0], 
[7.0, 1.0, 1.0], [7.0, 3.0, 2.0]], [[6.0, 3.0, 6.0], [8.0, 3.0, 4.0], [3.0, 4.0, 5.0]], [[5.0, 2.0, 7.0], [3.0, 7.0, 5.0], 
[7.0, 7.0, 8.0]]], [[[2.0, 6.0, 6.0], [2.0, 6.0, 8.0], [8.0, 7.0, 5.0]], [[5.0, 4.0, 7.0], [3.0, 6.0, 3.0], [1.0, 3.0, 3.0]], 
[[8.0, 7.0, 3.0], [7.0, 7.0, 2.0], [8.0, 5.0, 1.0]]], [[[6.0, 7.0, 8.0], [1.0, 2.0, 2.0], [5.0, 2.0, 7.0]], [[3.0, 2.0, 8.0], 
[6.0, 7.0, 2.0], [6.0, 5.0, 1.0]], [[4.0, 4.0, 7.0], [6.0, 8.0, 3.0], [7.0, 1.0, 5.0]]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank4_taggedData_CRRR(self):
      arg=Data(numpy.array([[[[8.0, 4.0, 1.0], [8.0, 3.0, 7.0], [3.0, 2.0, 3.0]], [[7.0, 5.0, 7.0], [2.0, 2.0, 7.0], [2.0, 5.0, 
6.0]], [[8.0, 7.0, 4.0], [3.0, 6.0, 6.0], [3.0, 2.0, 7.0]]], [[[3.0, 5.0, 3.0], [2.0, 2.0, 1.0], [7.0, 8.0, 6.0]], [[1.0, 8.0, 
5.0], [2.0, 5.0, 6.0], [7.0, 6.0, 3.0]], [[7.0, 3.0, 5.0], [5.0, 3.0, 5.0], [6.0, 2.0, 8.0]]], [[[1.0, 7.0, 6.0], [8.0, 6.0, 
2.0], [3.0, 4.0, 1.0]], [[3.0, 1.0, 6.0], [7.0, 7.0, 6.0], [4.0, 1.0, 2.0]], [[5.0, 4.0, 5.0], [4.0, 4.0, 6.0], [8.0, 5.0, 
4.0]]], [[[2.0, 5.0, 5.0], [5.0, 3.0, 4.0], [6.0, 6.0, 5.0]], [[2.0, 3.0, 3.0], [3.0, 8.0, 2.0], [7.0, 4.0, 7.0]], [[8.0, 6.0, 
4.0], [5.0, 8.0, 5.0], [7.0, 5.0, 4.0]]]]),self.functionspace)
      val=Data(numpy.array([[[[3.0]]], [[[1.0]]], [[[8.0]]], [[[7.0]]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[[8.0]]], [[[8.0]]], [[[1.0]]], [[[5.0]]]]))
      arg[:,1:2,1:2,1:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[8.0, 4.0, 1.0], [8.0, 3.0, 7.0], [3.0, 2.0, 3.0]], [[7.0, 5.0, 7.0], [2.0, 3.0, 7.0], [2.0, 
5.0, 6.0]], [[8.0, 7.0, 4.0], [3.0, 6.0, 6.0], [3.0, 2.0, 7.0]]], [[[3.0, 5.0, 3.0], [2.0, 2.0, 1.0], [7.0, 8.0, 6.0]], [[1.0, 
8.0, 5.0], [2.0, 1.0, 6.0], [7.0, 6.0, 3.0]], [[7.0, 3.0, 5.0], [5.0, 3.0, 5.0], [6.0, 2.0, 8.0]]], [[[1.0, 7.0, 6.0], [8.0, 
6.0, 2.0], [3.0, 4.0, 1.0]], [[3.0, 1.0, 6.0], [7.0, 8.0, 6.0], [4.0, 1.0, 2.0]], [[5.0, 4.0, 5.0], [4.0, 4.0, 6.0], [8.0, 5.0, 
4.0]]], [[[2.0, 5.0, 5.0], [5.0, 3.0, 4.0], [6.0, 6.0, 5.0]], [[2.0, 3.0, 3.0], [3.0, 7.0, 2.0], [7.0, 4.0, 7.0]], [[8.0, 6.0, 
4.0], [5.0, 8.0, 5.0], [7.0, 5.0, 4.0]]]])+(1.-msk_ref)*numpy.array([[[[8.0, 4.0, 1.0], [8.0, 3.0, 7.0], [3.0, 2.0, 3.0]], 
[[7.0, 5.0, 7.0], [2.0, 8.0, 7.0], [2.0, 5.0, 6.0]], [[8.0, 7.0, 4.0], [3.0, 6.0, 6.0], [3.0, 2.0, 7.0]]], [[[3.0, 5.0, 3.0], 
[2.0, 2.0, 1.0], [7.0, 8.0, 6.0]], [[1.0, 8.0, 5.0], [2.0, 8.0, 6.0], [7.0, 6.0, 3.0]], [[7.0, 3.0, 5.0], [5.0, 3.0, 5.0], 
[6.0, 2.0, 8.0]]], [[[1.0, 7.0, 6.0], [8.0, 6.0, 2.0], [3.0, 4.0, 1.0]], [[3.0, 1.0, 6.0], [7.0, 1.0, 6.0], [4.0, 1.0, 2.0]], 
[[5.0, 4.0, 5.0], [4.0, 4.0, 6.0], [8.0, 5.0, 4.0]]], [[[2.0, 5.0, 5.0], [5.0, 3.0, 4.0], [6.0, 6.0, 5.0]], [[2.0, 3.0, 3.0], 
[3.0, 5.0, 2.0], [7.0, 4.0, 7.0]], [[8.0, 6.0, 4.0], [5.0, 8.0, 5.0], [7.0, 5.0, 4.0]]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank4_taggedData_PCRR(self):
      arg=Data(numpy.array([[[[5.0, 8.0, 1.0], [2.0, 2.0, 5.0], [5.0, 8.0, 8.0]], [[7.0, 7.0, 8.0], [3.0, 8.0, 3.0], [3.0, 5.0, 
2.0]], [[7.0, 2.0, 6.0], [3.0, 4.0, 2.0], [6.0, 3.0, 2.0]]], [[[7.0, 3.0, 7.0], [5.0, 6.0, 6.0], [6.0, 6.0, 8.0]], [[5.0, 4.0, 
3.0], [4.0, 3.0, 4.0], [4.0, 5.0, 3.0]], [[4.0, 7.0, 2.0], [7.0, 2.0, 5.0], [4.0, 3.0, 6.0]]], [[[7.0, 4.0, 4.0], [8.0, 7.0, 
4.0], [7.0, 7.0, 8.0]], [[8.0, 2.0, 8.0], [3.0, 5.0, 8.0], [4.0, 2.0, 5.0]], [[1.0, 4.0, 2.0], [5.0, 4.0, 3.0], [3.0, 5.0, 
5.0]]], [[[6.0, 1.0, 7.0], [7.0, 5.0, 5.0], [3.0, 2.0, 8.0]], [[2.0, 3.0, 2.0], [3.0, 6.0, 5.0], [6.0, 7.0, 6.0]], [[1.0, 3.0, 
1.0], [8.0, 7.0, 7.0], [1.0, 1.0, 7.0]]]]),self.functionspace)
      val=Data(numpy.array([[[5.0]], [[4.0]], [[6.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[7.0]], [[7.0]], [[7.0]]]))
      arg[2,:,1:2,1:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[5.0, 8.0, 1.0], [2.0, 2.0, 5.0], [5.0, 8.0, 8.0]], [[7.0, 7.0, 8.0], [3.0, 8.0, 3.0], [3.0, 
5.0, 2.0]], [[7.0, 2.0, 6.0], [3.0, 4.0, 2.0], [6.0, 3.0, 2.0]]], [[[7.0, 3.0, 7.0], [5.0, 6.0, 6.0], [6.0, 6.0, 8.0]], [[5.0, 
4.0, 3.0], [4.0, 3.0, 4.0], [4.0, 5.0, 3.0]], [[4.0, 7.0, 2.0], [7.0, 2.0, 5.0], [4.0, 3.0, 6.0]]], [[[7.0, 4.0, 4.0], [8.0, 
5.0, 4.0], [7.0, 7.0, 8.0]], [[8.0, 2.0, 8.0], [3.0, 4.0, 8.0], [4.0, 2.0, 5.0]], [[1.0, 4.0, 2.0], [5.0, 6.0, 3.0], [3.0, 5.0, 
5.0]]], [[[6.0, 1.0, 7.0], [7.0, 5.0, 5.0], [3.0, 2.0, 8.0]], [[2.0, 3.0, 2.0], [3.0, 6.0, 5.0], [6.0, 7.0, 6.0]], [[1.0, 3.0, 
1.0], [8.0, 7.0, 7.0], [1.0, 1.0, 7.0]]]])+(1.-msk_ref)*numpy.array([[[[5.0, 8.0, 1.0], [2.0, 2.0, 5.0], [5.0, 8.0, 8.0]], 
[[7.0, 7.0, 8.0], [3.0, 8.0, 3.0], [3.0, 5.0, 2.0]], [[7.0, 2.0, 6.0], [3.0, 4.0, 2.0], [6.0, 3.0, 2.0]]], [[[7.0, 3.0, 7.0], 
[5.0, 6.0, 6.0], [6.0, 6.0, 8.0]], [[5.0, 4.0, 3.0], [4.0, 3.0, 4.0], [4.0, 5.0, 3.0]], [[4.0, 7.0, 2.0], [7.0, 2.0, 5.0], 
[4.0, 3.0, 6.0]]], [[[7.0, 4.0, 4.0], [8.0, 7.0, 4.0], [7.0, 7.0, 8.0]], [[8.0, 2.0, 8.0], [3.0, 7.0, 8.0], [4.0, 2.0, 5.0]], 
[[1.0, 4.0, 2.0], [5.0, 7.0, 3.0], [3.0, 5.0, 5.0]]], [[[6.0, 1.0, 7.0], [7.0, 5.0, 5.0], [3.0, 2.0, 8.0]], [[2.0, 3.0, 2.0], 
[3.0, 6.0, 5.0], [6.0, 7.0, 6.0]], [[1.0, 3.0, 1.0], [8.0, 7.0, 7.0], [1.0, 1.0, 7.0]]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank4_taggedData_PURN(self):
      arg=Data(numpy.array([[[[3.0, 1.0, 6.0], [6.0, 3.0, 7.0], [7.0, 4.0, 3.0]], [[5.0, 7.0, 6.0], [6.0, 4.0, 4.0], [5.0, 1.0, 
5.0]], [[1.0, 7.0, 7.0], [6.0, 7.0, 5.0], [3.0, 7.0, 4.0]]], [[[1.0, 3.0, 7.0], [3.0, 5.0, 3.0], [2.0, 8.0, 8.0]], [[1.0, 7.0, 
7.0], [7.0, 4.0, 4.0], [3.0, 5.0, 5.0]], [[6.0, 4.0, 1.0], [8.0, 5.0, 2.0], [8.0, 3.0, 7.0]]], [[[2.0, 1.0, 5.0], [6.0, 6.0, 
3.0], [7.0, 5.0, 6.0]], [[3.0, 1.0, 8.0], [1.0, 5.0, 4.0], [4.0, 6.0, 3.0]], [[1.0, 7.0, 6.0], [6.0, 6.0, 7.0], [6.0, 8.0, 
1.0]]], [[[1.0, 4.0, 6.0], [7.0, 2.0, 6.0], [5.0, 5.0, 7.0]], [[4.0, 1.0, 2.0], [8.0, 6.0, 5.0], [8.0, 8.0, 7.0]], [[1.0, 3.0, 
1.0], [7.0, 4.0, 1.0], [8.0, 7.0, 8.0]]]]),self.functionspace)
      val=Data(numpy.array([[[6.0, 1.0, 4.0]], [[5.0, 4.0, 6.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[2.0, 1.0, 3.0]], [[8.0, 1.0, 5.0]]]))
      arg[2,:2,1:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[3.0, 1.0, 6.0], [6.0, 3.0, 7.0], [7.0, 4.0, 3.0]], [[5.0, 7.0, 6.0], [6.0, 4.0, 4.0], [5.0, 
1.0, 5.0]], [[1.0, 7.0, 7.0], [6.0, 7.0, 5.0], [3.0, 7.0, 4.0]]], [[[1.0, 3.0, 7.0], [3.0, 5.0, 3.0], [2.0, 8.0, 8.0]], [[1.0, 
7.0, 7.0], [7.0, 4.0, 4.0], [3.0, 5.0, 5.0]], [[6.0, 4.0, 1.0], [8.0, 5.0, 2.0], [8.0, 3.0, 7.0]]], [[[2.0, 1.0, 5.0], [6.0, 
1.0, 4.0], [7.0, 5.0, 6.0]], [[3.0, 1.0, 8.0], [5.0, 4.0, 6.0], [4.0, 6.0, 3.0]], [[1.0, 7.0, 6.0], [6.0, 6.0, 7.0], [6.0, 8.0, 
1.0]]], [[[1.0, 4.0, 6.0], [7.0, 2.0, 6.0], [5.0, 5.0, 7.0]], [[4.0, 1.0, 2.0], [8.0, 6.0, 5.0], [8.0, 8.0, 7.0]], [[1.0, 3.0, 
1.0], [7.0, 4.0, 1.0], [8.0, 7.0, 8.0]]]])+(1.-msk_ref)*numpy.array([[[[3.0, 1.0, 6.0], [6.0, 3.0, 7.0], [7.0, 4.0, 3.0]], 
[[5.0, 7.0, 6.0], [6.0, 4.0, 4.0], [5.0, 1.0, 5.0]], [[1.0, 7.0, 7.0], [6.0, 7.0, 5.0], [3.0, 7.0, 4.0]]], [[[1.0, 3.0, 7.0], 
[3.0, 5.0, 3.0], [2.0, 8.0, 8.0]], [[1.0, 7.0, 7.0], [7.0, 4.0, 4.0], [3.0, 5.0, 5.0]], [[6.0, 4.0, 1.0], [8.0, 5.0, 2.0], 
[8.0, 3.0, 7.0]]], [[[2.0, 1.0, 5.0], [2.0, 1.0, 3.0], [7.0, 5.0, 6.0]], [[3.0, 1.0, 8.0], [8.0, 1.0, 5.0], [4.0, 6.0, 3.0]], 
[[1.0, 7.0, 6.0], [6.0, 6.0, 7.0], [6.0, 8.0, 1.0]]], [[[1.0, 4.0, 6.0], [7.0, 2.0, 6.0], [5.0, 5.0, 7.0]], [[4.0, 1.0, 2.0], 
[8.0, 6.0, 5.0], [8.0, 8.0, 7.0]], [[1.0, 3.0, 1.0], [7.0, 4.0, 1.0], [8.0, 7.0, 8.0]]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank4_taggedData_LURL(self):
      arg=Data(numpy.array([[[[7.0, 1.0, 6.0], [1.0, 2.0, 5.0], [4.0, 6.0, 1.0]], [[7.0, 5.0, 2.0], [4.0, 3.0, 4.0], [4.0, 8.0, 
7.0]], [[5.0, 7.0, 4.0], [3.0, 3.0, 3.0], [7.0, 4.0, 6.0]]], [[[6.0, 4.0, 1.0], [8.0, 2.0, 2.0], [2.0, 2.0, 7.0]], [[6.0, 2.0, 
4.0], [6.0, 3.0, 4.0], [2.0, 6.0, 5.0]], [[8.0, 5.0, 8.0], [8.0, 8.0, 6.0], [8.0, 7.0, 4.0]]], [[[3.0, 7.0, 7.0], [2.0, 2.0, 
2.0], [6.0, 5.0, 2.0]], [[1.0, 1.0, 3.0], [7.0, 6.0, 1.0], [3.0, 8.0, 3.0]], [[4.0, 8.0, 3.0], [1.0, 3.0, 3.0], [8.0, 2.0, 
5.0]]], [[[6.0, 3.0, 7.0], [7.0, 5.0, 6.0], [3.0, 7.0, 5.0]], [[7.0, 5.0, 6.0], [3.0, 3.0, 5.0], [3.0, 4.0, 5.0]], [[7.0, 4.0, 
4.0], [3.0, 6.0, 7.0], [8.0, 3.0, 2.0]]]]),self.functionspace)
      val=Data(numpy.array([[[[8.0]], [[5.0]]], [[[1.0]], [[4.0]]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[[4.0]], [[4.0]]], [[[1.0]], [[1.0]]]]))
      arg[2:,:2,1:2,2:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[7.0, 1.0, 6.0], [1.0, 2.0, 5.0], [4.0, 6.0, 1.0]], [[7.0, 5.0, 2.0], [4.0, 3.0, 4.0], [4.0, 
8.0, 7.0]], [[5.0, 7.0, 4.0], [3.0, 3.0, 3.0], [7.0, 4.0, 6.0]]], [[[6.0, 4.0, 1.0], [8.0, 2.0, 2.0], [2.0, 2.0, 7.0]], [[6.0, 
2.0, 4.0], [6.0, 3.0, 4.0], [2.0, 6.0, 5.0]], [[8.0, 5.0, 8.0], [8.0, 8.0, 6.0], [8.0, 7.0, 4.0]]], [[[3.0, 7.0, 7.0], [2.0, 
2.0, 8.0], [6.0, 5.0, 2.0]], [[1.0, 1.0, 3.0], [7.0, 6.0, 5.0], [3.0, 8.0, 3.0]], [[4.0, 8.0, 3.0], [1.0, 3.0, 3.0], [8.0, 2.0, 
5.0]]], [[[6.0, 3.0, 7.0], [7.0, 5.0, 1.0], [3.0, 7.0, 5.0]], [[7.0, 5.0, 6.0], [3.0, 3.0, 4.0], [3.0, 4.0, 5.0]], [[7.0, 4.0, 
4.0], [3.0, 6.0, 7.0], [8.0, 3.0, 2.0]]]])+(1.-msk_ref)*numpy.array([[[[7.0, 1.0, 6.0], [1.0, 2.0, 5.0], [4.0, 6.0, 1.0]], 
[[7.0, 5.0, 2.0], [4.0, 3.0, 4.0], [4.0, 8.0, 7.0]], [[5.0, 7.0, 4.0], [3.0, 3.0, 3.0], [7.0, 4.0, 6.0]]], [[[6.0, 4.0, 1.0], 
[8.0, 2.0, 2.0], [2.0, 2.0, 7.0]], [[6.0, 2.0, 4.0], [6.0, 3.0, 4.0], [2.0, 6.0, 5.0]], [[8.0, 5.0, 8.0], [8.0, 8.0, 6.0], 
[8.0, 7.0, 4.0]]], [[[3.0, 7.0, 7.0], [2.0, 2.0, 4.0], [6.0, 5.0, 2.0]], [[1.0, 1.0, 3.0], [7.0, 6.0, 4.0], [3.0, 8.0, 3.0]], 
[[4.0, 8.0, 3.0], [1.0, 3.0, 3.0], [8.0, 2.0, 5.0]]], [[[6.0, 3.0, 7.0], [7.0, 5.0, 1.0], [3.0, 7.0, 5.0]], [[7.0, 5.0, 6.0], 
[3.0, 3.0, 1.0], [3.0, 4.0, 5.0]], [[7.0, 4.0, 4.0], [3.0, 6.0, 7.0], [8.0, 3.0, 2.0]]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank4_taggedData_CPPC(self):
      arg=Data(numpy.array([[[[6.0, 6.0, 1.0], [2.0, 1.0, 4.0], [3.0, 7.0, 8.0]], [[4.0, 8.0, 3.0], [1.0, 1.0, 6.0], [6.0, 7.0, 
5.0]], [[3.0, 7.0, 5.0], [4.0, 6.0, 7.0], [3.0, 5.0, 8.0]]], [[[4.0, 4.0, 6.0], [6.0, 1.0, 2.0], [7.0, 3.0, 2.0]], [[1.0, 8.0, 
1.0], [3.0, 4.0, 5.0], [1.0, 4.0, 3.0]], [[1.0, 8.0, 4.0], [3.0, 5.0, 5.0], [2.0, 2.0, 6.0]]], [[[7.0, 1.0, 6.0], [6.0, 3.0, 
8.0], [4.0, 6.0, 2.0]], [[5.0, 8.0, 2.0], [6.0, 3.0, 5.0], [4.0, 4.0, 2.0]], [[6.0, 3.0, 3.0], [3.0, 2.0, 7.0], [4.0, 7.0, 
1.0]]], [[[5.0, 5.0, 8.0], [4.0, 6.0, 5.0], [2.0, 1.0, 7.0]], [[3.0, 8.0, 8.0], [3.0, 5.0, 1.0], [8.0, 1.0, 6.0]], [[8.0, 2.0, 
6.0], [3.0, 6.0, 2.0], [4.0, 3.0, 1.0]]]]),self.functionspace)
      val=Data(numpy.array([[7.0, 1.0, 7.0], [8.0, 8.0, 4.0], [1.0, 2.0, 8.0], [3.0, 5.0, 3.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[5.0, 7.0, 4.0], [7.0, 3.0, 1.0], [3.0, 1.0, 8.0], [5.0, 5.0, 8.0]]))
      arg[:,1,1,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[6.0, 6.0, 1.0], [2.0, 1.0, 4.0], [3.0, 7.0, 8.0]], [[4.0, 8.0, 3.0], [7.0, 1.0, 7.0], [6.0, 
7.0, 5.0]], [[3.0, 7.0, 5.0], [4.0, 6.0, 7.0], [3.0, 5.0, 8.0]]], [[[4.0, 4.0, 6.0], [6.0, 1.0, 2.0], [7.0, 3.0, 2.0]], [[1.0, 
8.0, 1.0], [8.0, 8.0, 4.0], [1.0, 4.0, 3.0]], [[1.0, 8.0, 4.0], [3.0, 5.0, 5.0], [2.0, 2.0, 6.0]]], [[[7.0, 1.0, 6.0], [6.0, 
3.0, 8.0], [4.0, 6.0, 2.0]], [[5.0, 8.0, 2.0], [1.0, 2.0, 8.0], [4.0, 4.0, 2.0]], [[6.0, 3.0, 3.0], [3.0, 2.0, 7.0], [4.0, 7.0, 
1.0]]], [[[5.0, 5.0, 8.0], [4.0, 6.0, 5.0], [2.0, 1.0, 7.0]], [[3.0, 8.0, 8.0], [3.0, 5.0, 3.0], [8.0, 1.0, 6.0]], [[8.0, 2.0, 
6.0], [3.0, 6.0, 2.0], [4.0, 3.0, 1.0]]]])+(1.-msk_ref)*numpy.array([[[[6.0, 6.0, 1.0], [2.0, 1.0, 4.0], [3.0, 7.0, 8.0]], 
[[4.0, 8.0, 3.0], [5.0, 7.0, 4.0], [6.0, 7.0, 5.0]], [[3.0, 7.0, 5.0], [4.0, 6.0, 7.0], [3.0, 5.0, 8.0]]], [[[4.0, 4.0, 6.0], 
[6.0, 1.0, 2.0], [7.0, 3.0, 2.0]], [[1.0, 8.0, 1.0], [7.0, 3.0, 1.0], [1.0, 4.0, 3.0]], [[1.0, 8.0, 4.0], [3.0, 5.0, 5.0], 
[2.0, 2.0, 6.0]]], [[[7.0, 1.0, 6.0], [6.0, 3.0, 8.0], [4.0, 6.0, 2.0]], [[5.0, 8.0, 2.0], [3.0, 1.0, 8.0], [4.0, 4.0, 2.0]], 
[[6.0, 3.0, 3.0], [3.0, 2.0, 7.0], [4.0, 7.0, 1.0]]], [[[5.0, 5.0, 8.0], [4.0, 6.0, 5.0], [2.0, 1.0, 7.0]], [[3.0, 8.0, 8.0], 
[5.0, 5.0, 8.0], [8.0, 1.0, 6.0]], [[8.0, 2.0, 6.0], [3.0, 6.0, 2.0], [4.0, 3.0, 1.0]]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank4_taggedData_PLRR(self):
      arg=Data(numpy.array([[[[7.0, 5.0, 4.0], [5.0, 4.0, 3.0], [5.0, 6.0, 4.0]], [[2.0, 8.0, 3.0], [6.0, 3.0, 7.0], [1.0, 6.0, 
1.0]], [[5.0, 6.0, 2.0], [6.0, 5.0, 8.0], [7.0, 3.0, 1.0]]], [[[3.0, 2.0, 7.0], [3.0, 4.0, 8.0], [8.0, 1.0, 1.0]], [[3.0, 3.0, 
6.0], [2.0, 4.0, 3.0], [7.0, 4.0, 2.0]], [[2.0, 4.0, 4.0], [1.0, 4.0, 6.0], [3.0, 1.0, 8.0]]], [[[8.0, 5.0, 7.0], [1.0, 6.0, 
8.0], [4.0, 7.0, 7.0]], [[7.0, 7.0, 2.0], [3.0, 2.0, 1.0], [1.0, 5.0, 6.0]], [[4.0, 8.0, 6.0], [8.0, 6.0, 6.0], [7.0, 5.0, 
5.0]]], [[[7.0, 5.0, 5.0], [7.0, 3.0, 6.0], [3.0, 1.0, 3.0]], [[3.0, 7.0, 7.0], [1.0, 3.0, 7.0], [6.0, 4.0, 6.0]], [[8.0, 2.0, 
3.0], [2.0, 3.0, 6.0], [6.0, 5.0, 6.0]]]]),self.functionspace)
      val=Data(numpy.array([[[8.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[7.0]]]))
      arg[2,2:,1:2,1:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[7.0, 5.0, 4.0], [5.0, 4.0, 3.0], [5.0, 6.0, 4.0]], [[2.0, 8.0, 3.0], [6.0, 3.0, 7.0], [1.0, 
6.0, 1.0]], [[5.0, 6.0, 2.0], [6.0, 5.0, 8.0], [7.0, 3.0, 1.0]]], [[[3.0, 2.0, 7.0], [3.0, 4.0, 8.0], [8.0, 1.0, 1.0]], [[3.0, 
3.0, 6.0], [2.0, 4.0, 3.0], [7.0, 4.0, 2.0]], [[2.0, 4.0, 4.0], [1.0, 4.0, 6.0], [3.0, 1.0, 8.0]]], [[[8.0, 5.0, 7.0], [1.0, 
6.0, 8.0], [4.0, 7.0, 7.0]], [[7.0, 7.0, 2.0], [3.0, 2.0, 1.0], [1.0, 5.0, 6.0]], [[4.0, 8.0, 6.0], [8.0, 8.0, 6.0], [7.0, 5.0, 
5.0]]], [[[7.0, 5.0, 5.0], [7.0, 3.0, 6.0], [3.0, 1.0, 3.0]], [[3.0, 7.0, 7.0], [1.0, 3.0, 7.0], [6.0, 4.0, 6.0]], [[8.0, 2.0, 
3.0], [2.0, 3.0, 6.0], [6.0, 5.0, 6.0]]]])+(1.-msk_ref)*numpy.array([[[[7.0, 5.0, 4.0], [5.0, 4.0, 3.0], [5.0, 6.0, 4.0]], 
[[2.0, 8.0, 3.0], [6.0, 3.0, 7.0], [1.0, 6.0, 1.0]], [[5.0, 6.0, 2.0], [6.0, 5.0, 8.0], [7.0, 3.0, 1.0]]], [[[3.0, 2.0, 7.0], 
[3.0, 4.0, 8.0], [8.0, 1.0, 1.0]], [[3.0, 3.0, 6.0], [2.0, 4.0, 3.0], [7.0, 4.0, 2.0]], [[2.0, 4.0, 4.0], [1.0, 4.0, 6.0], 
[3.0, 1.0, 8.0]]], [[[8.0, 5.0, 7.0], [1.0, 6.0, 8.0], [4.0, 7.0, 7.0]], [[7.0, 7.0, 2.0], [3.0, 2.0, 1.0], [1.0, 5.0, 6.0]], 
[[4.0, 8.0, 6.0], [8.0, 7.0, 6.0], [7.0, 5.0, 5.0]]], [[[7.0, 5.0, 5.0], [7.0, 3.0, 6.0], [3.0, 1.0, 3.0]], [[3.0, 7.0, 7.0], 
[1.0, 3.0, 7.0], [6.0, 4.0, 6.0]], [[8.0, 2.0, 3.0], [2.0, 3.0, 6.0], [6.0, 5.0, 6.0]]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank4_taggedData_LCPP(self):
      arg=Data(numpy.array([[[[2.0, 8.0, 7.0], [2.0, 7.0, 2.0], [8.0, 5.0, 4.0]], [[1.0, 3.0, 8.0], [2.0, 2.0, 2.0], [5.0, 8.0, 
3.0]], [[7.0, 1.0, 4.0], [4.0, 2.0, 4.0], [5.0, 7.0, 6.0]]], [[[3.0, 3.0, 7.0], [8.0, 1.0, 5.0], [7.0, 3.0, 4.0]], [[7.0, 2.0, 
8.0], [6.0, 1.0, 2.0], [2.0, 6.0, 4.0]], [[1.0, 1.0, 8.0], [6.0, 1.0, 2.0], [1.0, 8.0, 5.0]]], [[[3.0, 8.0, 4.0], [5.0, 8.0, 
5.0], [3.0, 5.0, 7.0]], [[6.0, 3.0, 7.0], [1.0, 4.0, 1.0], [3.0, 1.0, 2.0]], [[3.0, 7.0, 7.0], [2.0, 8.0, 8.0], [7.0, 8.0, 
8.0]]], [[[7.0, 3.0, 8.0], [5.0, 6.0, 5.0], [2.0, 6.0, 2.0]], [[2.0, 5.0, 7.0], [6.0, 5.0, 6.0], [2.0, 5.0, 5.0]], [[3.0, 7.0, 
3.0], [5.0, 6.0, 6.0], [7.0, 5.0, 4.0]]]]),self.functionspace)
      val=Data(numpy.array([[2.0, 4.0, 7.0], [6.0, 6.0, 1.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[3.0, 2.0, 3.0], [4.0, 5.0, 7.0]]))
      arg[2:,:,1,1]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[2.0, 8.0, 7.0], [2.0, 7.0, 2.0], [8.0, 5.0, 4.0]], [[1.0, 3.0, 8.0], [2.0, 2.0, 2.0], [5.0, 
8.0, 3.0]], [[7.0, 1.0, 4.0], [4.0, 2.0, 4.0], [5.0, 7.0, 6.0]]], [[[3.0, 3.0, 7.0], [8.0, 1.0, 5.0], [7.0, 3.0, 4.0]], [[7.0, 
2.0, 8.0], [6.0, 1.0, 2.0], [2.0, 6.0, 4.0]], [[1.0, 1.0, 8.0], [6.0, 1.0, 2.0], [1.0, 8.0, 5.0]]], [[[3.0, 8.0, 4.0], [5.0, 
2.0, 5.0], [3.0, 5.0, 7.0]], [[6.0, 3.0, 7.0], [1.0, 4.0, 1.0], [3.0, 1.0, 2.0]], [[3.0, 7.0, 7.0], [2.0, 7.0, 8.0], [7.0, 8.0, 
8.0]]], [[[7.0, 3.0, 8.0], [5.0, 6.0, 5.0], [2.0, 6.0, 2.0]], [[2.0, 5.0, 7.0], [6.0, 6.0, 6.0], [2.0, 5.0, 5.0]], [[3.0, 7.0, 
3.0], [5.0, 1.0, 6.0], [7.0, 5.0, 4.0]]]])+(1.-msk_ref)*numpy.array([[[[2.0, 8.0, 7.0], [2.0, 7.0, 2.0], [8.0, 5.0, 4.0]], 
[[1.0, 3.0, 8.0], [2.0, 2.0, 2.0], [5.0, 8.0, 3.0]], [[7.0, 1.0, 4.0], [4.0, 2.0, 4.0], [5.0, 7.0, 6.0]]], [[[3.0, 3.0, 7.0], 
[8.0, 1.0, 5.0], [7.0, 3.0, 4.0]], [[7.0, 2.0, 8.0], [6.0, 1.0, 2.0], [2.0, 6.0, 4.0]], [[1.0, 1.0, 8.0], [6.0, 1.0, 2.0], 
[1.0, 8.0, 5.0]]], [[[3.0, 8.0, 4.0], [5.0, 3.0, 5.0], [3.0, 5.0, 7.0]], [[6.0, 3.0, 7.0], [1.0, 2.0, 1.0], [3.0, 1.0, 2.0]], 
[[3.0, 7.0, 7.0], [2.0, 3.0, 8.0], [7.0, 8.0, 8.0]]], [[[7.0, 3.0, 8.0], [5.0, 4.0, 5.0], [2.0, 6.0, 2.0]], [[2.0, 5.0, 7.0], 
[6.0, 5.0, 6.0], [2.0, 5.0, 5.0]], [[3.0, 7.0, 3.0], [5.0, 7.0, 6.0], [7.0, 5.0, 4.0]]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank4_taggedData_UURP(self):
      arg=Data(numpy.array([[[[3.0, 2.0, 8.0], [6.0, 6.0, 8.0], [4.0, 7.0, 8.0]], [[8.0, 4.0, 3.0], [5.0, 3.0, 1.0], [4.0, 1.0, 
2.0]], [[3.0, 4.0, 7.0], [4.0, 5.0, 8.0], [2.0, 6.0, 2.0]]], [[[5.0, 1.0, 6.0], [6.0, 1.0, 3.0], [1.0, 3.0, 7.0]], [[2.0, 8.0, 
4.0], [5.0, 7.0, 5.0], [5.0, 6.0, 1.0]], [[7.0, 4.0, 4.0], [3.0, 2.0, 1.0], [6.0, 6.0, 1.0]]], [[[7.0, 8.0, 6.0], [1.0, 6.0, 
6.0], [4.0, 8.0, 2.0]], [[3.0, 1.0, 7.0], [2.0, 8.0, 7.0], [8.0, 5.0, 3.0]], [[6.0, 2.0, 3.0], [4.0, 6.0, 3.0], [2.0, 5.0, 
7.0]]], [[[1.0, 3.0, 8.0], [6.0, 8.0, 1.0], [3.0, 1.0, 4.0]], [[1.0, 4.0, 5.0], [3.0, 7.0, 1.0], [3.0, 3.0, 3.0]], [[6.0, 7.0, 
3.0], [8.0, 7.0, 7.0], [6.0, 1.0, 3.0]]]]),self.functionspace)
      val=Data(numpy.array([[[4.0], [7.0]], [[5.0], [4.0]], [[7.0], [4.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[3.0], [5.0]], [[4.0], [8.0]], [[7.0], [7.0]]]))
      arg[:3,:2,1:2,1]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[3.0, 2.0, 8.0], [6.0, 4.0, 8.0], [4.0, 7.0, 8.0]], [[8.0, 4.0, 3.0], [5.0, 7.0, 1.0], [4.0, 
1.0, 2.0]], [[3.0, 4.0, 7.0], [4.0, 5.0, 8.0], [2.0, 6.0, 2.0]]], [[[5.0, 1.0, 6.0], [6.0, 5.0, 3.0], [1.0, 3.0, 7.0]], [[2.0, 
8.0, 4.0], [5.0, 4.0, 5.0], [5.0, 6.0, 1.0]], [[7.0, 4.0, 4.0], [3.0, 2.0, 1.0], [6.0, 6.0, 1.0]]], [[[7.0, 8.0, 6.0], [1.0, 
7.0, 6.0], [4.0, 8.0, 2.0]], [[3.0, 1.0, 7.0], [2.0, 4.0, 7.0], [8.0, 5.0, 3.0]], [[6.0, 2.0, 3.0], [4.0, 6.0, 3.0], [2.0, 5.0, 
7.0]]], [[[1.0, 3.0, 8.0], [6.0, 8.0, 1.0], [3.0, 1.0, 4.0]], [[1.0, 4.0, 5.0], [3.0, 7.0, 1.0], [3.0, 3.0, 3.0]], [[6.0, 7.0, 
3.0], [8.0, 7.0, 7.0], [6.0, 1.0, 3.0]]]])+(1.-msk_ref)*numpy.array([[[[3.0, 2.0, 8.0], [6.0, 3.0, 8.0], [4.0, 7.0, 8.0]], 
[[8.0, 4.0, 3.0], [5.0, 5.0, 1.0], [4.0, 1.0, 2.0]], [[3.0, 4.0, 7.0], [4.0, 5.0, 8.0], [2.0, 6.0, 2.0]]], [[[5.0, 1.0, 6.0], 
[6.0, 4.0, 3.0], [1.0, 3.0, 7.0]], [[2.0, 8.0, 4.0], [5.0, 8.0, 5.0], [5.0, 6.0, 1.0]], [[7.0, 4.0, 4.0], [3.0, 2.0, 1.0], 
[6.0, 6.0, 1.0]]], [[[7.0, 8.0, 6.0], [1.0, 7.0, 6.0], [4.0, 8.0, 2.0]], [[3.0, 1.0, 7.0], [2.0, 7.0, 7.0], [8.0, 5.0, 3.0]], 
[[6.0, 2.0, 3.0], [4.0, 6.0, 3.0], [2.0, 5.0, 7.0]]], [[[1.0, 3.0, 8.0], [6.0, 8.0, 1.0], [3.0, 1.0, 4.0]], [[1.0, 4.0, 5.0], 
[3.0, 7.0, 1.0], [3.0, 3.0, 3.0]], [[6.0, 7.0, 3.0], [8.0, 7.0, 7.0], [6.0, 1.0, 3.0]]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank4_taggedData_RLRC(self):
      arg=Data(numpy.array([[[[6.0, 2.0, 6.0], [7.0, 8.0, 2.0], [2.0, 1.0, 8.0]], [[3.0, 3.0, 3.0], [3.0, 4.0, 3.0], [6.0, 8.0, 
4.0]], [[3.0, 5.0, 2.0], [4.0, 5.0, 8.0], [8.0, 8.0, 3.0]]], [[[2.0, 8.0, 2.0], [4.0, 2.0, 3.0], [8.0, 3.0, 6.0]], [[5.0, 4.0, 
6.0], [5.0, 5.0, 3.0], [5.0, 5.0, 2.0]], [[8.0, 7.0, 7.0], [5.0, 1.0, 6.0], [1.0, 1.0, 6.0]]], [[[2.0, 3.0, 2.0], [2.0, 7.0, 
7.0], [4.0, 8.0, 2.0]], [[6.0, 3.0, 4.0], [4.0, 2.0, 1.0], [3.0, 7.0, 8.0]], [[3.0, 3.0, 3.0], [6.0, 8.0, 8.0], [4.0, 5.0, 
4.0]]], [[[2.0, 8.0, 8.0], [4.0, 1.0, 6.0], [4.0, 7.0, 5.0]], [[2.0, 1.0, 2.0], [8.0, 5.0, 6.0], [7.0, 8.0, 6.0]], [[4.0, 2.0, 
8.0], [4.0, 8.0, 1.0], [3.0, 7.0, 7.0]]]]),self.functionspace)
      val=Data(numpy.array([[[[7.0, 6.0, 4.0]]], [[[6.0, 2.0, 1.0]]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[[5.0, 2.0, 7.0]]], [[[3.0, 1.0, 3.0]]]]))
      arg[1:3,2:,1:2,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[6.0, 2.0, 6.0], [7.0, 8.0, 2.0], [2.0, 1.0, 8.0]], [[3.0, 3.0, 3.0], [3.0, 4.0, 3.0], [6.0, 
8.0, 4.0]], [[3.0, 5.0, 2.0], [4.0, 5.0, 8.0], [8.0, 8.0, 3.0]]], [[[2.0, 8.0, 2.0], [4.0, 2.0, 3.0], [8.0, 3.0, 6.0]], [[5.0, 
4.0, 6.0], [5.0, 5.0, 3.0], [5.0, 5.0, 2.0]], [[8.0, 7.0, 7.0], [7.0, 6.0, 4.0], [1.0, 1.0, 6.0]]], [[[2.0, 3.0, 2.0], [2.0, 
7.0, 7.0], [4.0, 8.0, 2.0]], [[6.0, 3.0, 4.0], [4.0, 2.0, 1.0], [3.0, 7.0, 8.0]], [[3.0, 3.0, 3.0], [6.0, 2.0, 1.0], [4.0, 5.0, 
4.0]]], [[[2.0, 8.0, 8.0], [4.0, 1.0, 6.0], [4.0, 7.0, 5.0]], [[2.0, 1.0, 2.0], [8.0, 5.0, 6.0], [7.0, 8.0, 6.0]], [[4.0, 2.0, 
8.0], [4.0, 8.0, 1.0], [3.0, 7.0, 7.0]]]])+(1.-msk_ref)*numpy.array([[[[6.0, 2.0, 6.0], [7.0, 8.0, 2.0], [2.0, 1.0, 8.0]], 
[[3.0, 3.0, 3.0], [3.0, 4.0, 3.0], [6.0, 8.0, 4.0]], [[3.0, 5.0, 2.0], [4.0, 5.0, 8.0], [8.0, 8.0, 3.0]]], [[[2.0, 8.0, 2.0], 
[4.0, 2.0, 3.0], [8.0, 3.0, 6.0]], [[5.0, 4.0, 6.0], [5.0, 5.0, 3.0], [5.0, 5.0, 2.0]], [[8.0, 7.0, 7.0], [5.0, 2.0, 7.0], 
[1.0, 1.0, 6.0]]], [[[2.0, 3.0, 2.0], [2.0, 7.0, 7.0], [4.0, 8.0, 2.0]], [[6.0, 3.0, 4.0], [4.0, 2.0, 1.0], [3.0, 7.0, 8.0]], 
[[3.0, 3.0, 3.0], [3.0, 1.0, 3.0], [4.0, 5.0, 4.0]]], [[[2.0, 8.0, 8.0], [4.0, 1.0, 6.0], [4.0, 7.0, 5.0]], [[2.0, 1.0, 2.0], 
[8.0, 5.0, 6.0], [7.0, 8.0, 6.0]], [[4.0, 2.0, 8.0], [4.0, 8.0, 1.0], [3.0, 7.0, 7.0]]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank4_taggedData_CRPP(self):
      arg=Data(numpy.array([[[[2.0, 1.0, 4.0], [2.0, 6.0, 3.0], [5.0, 1.0, 3.0]], [[1.0, 5.0, 4.0], [7.0, 6.0, 5.0], [1.0, 5.0, 
8.0]], [[3.0, 2.0, 7.0], [7.0, 7.0, 1.0], [3.0, 3.0, 4.0]]], [[[2.0, 4.0, 2.0], [1.0, 5.0, 1.0], [8.0, 1.0, 1.0]], [[4.0, 3.0, 
6.0], [6.0, 2.0, 2.0], [4.0, 5.0, 5.0]], [[1.0, 3.0, 5.0], [3.0, 8.0, 8.0], [1.0, 7.0, 5.0]]], [[[5.0, 5.0, 4.0], [1.0, 1.0, 
1.0], [5.0, 7.0, 3.0]], [[5.0, 7.0, 5.0], [3.0, 1.0, 5.0], [3.0, 7.0, 7.0]], [[8.0, 6.0, 3.0], [2.0, 3.0, 6.0], [6.0, 7.0, 
2.0]]], [[[6.0, 6.0, 2.0], [8.0, 7.0, 5.0], [5.0, 3.0, 2.0]], [[1.0, 4.0, 8.0], [8.0, 1.0, 3.0], [1.0, 4.0, 1.0]], [[3.0, 3.0, 
7.0], [5.0, 5.0, 8.0], [5.0, 6.0, 6.0]]]]),self.functionspace)
      val=Data(numpy.array([[2.0], [3.0], [8.0], [8.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[7.0], [2.0], [3.0], [4.0]]))
      arg[:,1:2,1,1]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[2.0, 1.0, 4.0], [2.0, 6.0, 3.0], [5.0, 1.0, 3.0]], [[1.0, 5.0, 4.0], [7.0, 2.0, 5.0], [1.0, 
5.0, 8.0]], [[3.0, 2.0, 7.0], [7.0, 7.0, 1.0], [3.0, 3.0, 4.0]]], [[[2.0, 4.0, 2.0], [1.0, 5.0, 1.0], [8.0, 1.0, 1.0]], [[4.0, 
3.0, 6.0], [6.0, 3.0, 2.0], [4.0, 5.0, 5.0]], [[1.0, 3.0, 5.0], [3.0, 8.0, 8.0], [1.0, 7.0, 5.0]]], [[[5.0, 5.0, 4.0], [1.0, 
1.0, 1.0], [5.0, 7.0, 3.0]], [[5.0, 7.0, 5.0], [3.0, 8.0, 5.0], [3.0, 7.0, 7.0]], [[8.0, 6.0, 3.0], [2.0, 3.0, 6.0], [6.0, 7.0, 
2.0]]], [[[6.0, 6.0, 2.0], [8.0, 7.0, 5.0], [5.0, 3.0, 2.0]], [[1.0, 4.0, 8.0], [8.0, 8.0, 3.0], [1.0, 4.0, 1.0]], [[3.0, 3.0, 
7.0], [5.0, 5.0, 8.0], [5.0, 6.0, 6.0]]]])+(1.-msk_ref)*numpy.array([[[[2.0, 1.0, 4.0], [2.0, 6.0, 3.0], [5.0, 1.0, 3.0]], 
[[1.0, 5.0, 4.0], [7.0, 7.0, 5.0], [1.0, 5.0, 8.0]], [[3.0, 2.0, 7.0], [7.0, 7.0, 1.0], [3.0, 3.0, 4.0]]], [[[2.0, 4.0, 2.0], 
[1.0, 5.0, 1.0], [8.0, 1.0, 1.0]], [[4.0, 3.0, 6.0], [6.0, 2.0, 2.0], [4.0, 5.0, 5.0]], [[1.0, 3.0, 5.0], [3.0, 8.0, 8.0], 
[1.0, 7.0, 5.0]]], [[[5.0, 5.0, 4.0], [1.0, 1.0, 1.0], [5.0, 7.0, 3.0]], [[5.0, 7.0, 5.0], [3.0, 3.0, 5.0], [3.0, 7.0, 7.0]], 
[[8.0, 6.0, 3.0], [2.0, 3.0, 6.0], [6.0, 7.0, 2.0]]], [[[6.0, 6.0, 2.0], [8.0, 7.0, 5.0], [5.0, 3.0, 2.0]], [[1.0, 4.0, 8.0], 
[8.0, 4.0, 3.0], [1.0, 4.0, 1.0]], [[3.0, 3.0, 7.0], [5.0, 5.0, 8.0], [5.0, 6.0, 6.0]]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank4_taggedData_LPUU(self):
      arg=Data(numpy.array([[[[3.0, 1.0, 4.0], [8.0, 7.0, 5.0], [2.0, 6.0, 6.0]], [[7.0, 3.0, 7.0], [8.0, 2.0, 8.0], [6.0, 5.0, 
2.0]], [[2.0, 5.0, 5.0], [6.0, 4.0, 4.0], [1.0, 8.0, 8.0]]], [[[6.0, 4.0, 7.0], [6.0, 5.0, 3.0], [7.0, 5.0, 2.0]], [[1.0, 5.0, 
8.0], [1.0, 8.0, 3.0], [2.0, 5.0, 6.0]], [[6.0, 4.0, 5.0], [6.0, 1.0, 2.0], [4.0, 7.0, 4.0]]], [[[4.0, 2.0, 5.0], [7.0, 6.0, 
6.0], [5.0, 6.0, 5.0]], [[7.0, 3.0, 7.0], [5.0, 6.0, 3.0], [5.0, 1.0, 7.0]], [[7.0, 8.0, 3.0], [5.0, 5.0, 8.0], [7.0, 6.0, 
1.0]]], [[[2.0, 6.0, 8.0], [4.0, 4.0, 8.0], [1.0, 3.0, 4.0]], [[7.0, 4.0, 5.0], [8.0, 5.0, 7.0], [6.0, 8.0, 1.0]], [[6.0, 4.0, 
3.0], [1.0, 4.0, 8.0], [1.0, 6.0, 1.0]]]]),self.functionspace)
      val=Data(numpy.array([[[8.0, 7.0], [5.0, 3.0]], [[5.0, 6.0], [4.0, 2.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[3.0, 4.0], [8.0, 1.0]], [[7.0, 6.0], [5.0, 4.0]]]))
      arg[2:,1,:2,:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[3.0, 1.0, 4.0], [8.0, 7.0, 5.0], [2.0, 6.0, 6.0]], [[7.0, 3.0, 7.0], [8.0, 2.0, 8.0], [6.0, 
5.0, 2.0]], [[2.0, 5.0, 5.0], [6.0, 4.0, 4.0], [1.0, 8.0, 8.0]]], [[[6.0, 4.0, 7.0], [6.0, 5.0, 3.0], [7.0, 5.0, 2.0]], [[1.0, 
5.0, 8.0], [1.0, 8.0, 3.0], [2.0, 5.0, 6.0]], [[6.0, 4.0, 5.0], [6.0, 1.0, 2.0], [4.0, 7.0, 4.0]]], [[[4.0, 2.0, 5.0], [7.0, 
6.0, 6.0], [5.0, 6.0, 5.0]], [[8.0, 7.0, 7.0], [5.0, 3.0, 3.0], [5.0, 1.0, 7.0]], [[7.0, 8.0, 3.0], [5.0, 5.0, 8.0], [7.0, 6.0, 
1.0]]], [[[2.0, 6.0, 8.0], [4.0, 4.0, 8.0], [1.0, 3.0, 4.0]], [[5.0, 6.0, 5.0], [4.0, 2.0, 7.0], [6.0, 8.0, 1.0]], [[6.0, 4.0, 
3.0], [1.0, 4.0, 8.0], [1.0, 6.0, 1.0]]]])+(1.-msk_ref)*numpy.array([[[[3.0, 1.0, 4.0], [8.0, 7.0, 5.0], [2.0, 6.0, 6.0]], 
[[7.0, 3.0, 7.0], [8.0, 2.0, 8.0], [6.0, 5.0, 2.0]], [[2.0, 5.0, 5.0], [6.0, 4.0, 4.0], [1.0, 8.0, 8.0]]], [[[6.0, 4.0, 7.0], 
[6.0, 5.0, 3.0], [7.0, 5.0, 2.0]], [[1.0, 5.0, 8.0], [1.0, 8.0, 3.0], [2.0, 5.0, 6.0]], [[6.0, 4.0, 5.0], [6.0, 1.0, 2.0], 
[4.0, 7.0, 4.0]]], [[[4.0, 2.0, 5.0], [7.0, 6.0, 6.0], [5.0, 6.0, 5.0]], [[3.0, 4.0, 7.0], [8.0, 1.0, 3.0], [5.0, 1.0, 7.0]], 
[[7.0, 8.0, 3.0], [5.0, 5.0, 8.0], [7.0, 6.0, 1.0]]], [[[2.0, 6.0, 8.0], [4.0, 4.0, 8.0], [1.0, 3.0, 4.0]], [[7.0, 6.0, 5.0], 
[5.0, 4.0, 7.0], [6.0, 8.0, 1.0]], [[6.0, 4.0, 3.0], [1.0, 4.0, 8.0], [1.0, 6.0, 1.0]]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank4_taggedData_LPUN(self):
      arg=Data(numpy.array([[[[8.0, 5.0, 6.0], [5.0, 1.0, 2.0], [3.0, 3.0, 1.0]], [[6.0, 4.0, 1.0], [3.0, 4.0, 7.0], [8.0, 6.0, 
7.0]], [[1.0, 4.0, 2.0], [1.0, 7.0, 1.0], [3.0, 4.0, 4.0]]], [[[3.0, 6.0, 1.0], [3.0, 8.0, 2.0], [2.0, 8.0, 2.0]], [[1.0, 3.0, 
8.0], [1.0, 6.0, 3.0], [3.0, 2.0, 8.0]], [[4.0, 1.0, 5.0], [7.0, 1.0, 8.0], [8.0, 3.0, 2.0]]], [[[2.0, 1.0, 4.0], [6.0, 3.0, 
7.0], [6.0, 5.0, 5.0]], [[7.0, 7.0, 5.0], [5.0, 3.0, 5.0], [3.0, 4.0, 4.0]], [[1.0, 5.0, 2.0], [2.0, 7.0, 8.0], [8.0, 2.0, 
3.0]]], [[[1.0, 4.0, 3.0], [6.0, 4.0, 3.0], [4.0, 1.0, 2.0]], [[4.0, 6.0, 6.0], [3.0, 6.0, 1.0], [6.0, 1.0, 7.0]], [[2.0, 7.0, 
6.0], [2.0, 2.0, 4.0], [7.0, 1.0, 2.0]]]]),self.functionspace)
      val=Data(numpy.array([[[6.0, 3.0, 6.0], [4.0, 1.0, 8.0]], [[7.0, 3.0, 4.0], [8.0, 1.0, 2.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[6.0, 6.0, 5.0], [3.0, 4.0, 2.0]], [[4.0, 4.0, 6.0], [4.0, 4.0, 6.0]]]))
      arg[2:,1,:2]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[8.0, 5.0, 6.0], [5.0, 1.0, 2.0], [3.0, 3.0, 1.0]], [[6.0, 4.0, 1.0], [3.0, 4.0, 7.0], [8.0, 
6.0, 7.0]], [[1.0, 4.0, 2.0], [1.0, 7.0, 1.0], [3.0, 4.0, 4.0]]], [[[3.0, 6.0, 1.0], [3.0, 8.0, 2.0], [2.0, 8.0, 2.0]], [[1.0, 
3.0, 8.0], [1.0, 6.0, 3.0], [3.0, 2.0, 8.0]], [[4.0, 1.0, 5.0], [7.0, 1.0, 8.0], [8.0, 3.0, 2.0]]], [[[2.0, 1.0, 4.0], [6.0, 
3.0, 7.0], [6.0, 5.0, 5.0]], [[6.0, 3.0, 6.0], [4.0, 1.0, 8.0], [3.0, 4.0, 4.0]], [[1.0, 5.0, 2.0], [2.0, 7.0, 8.0], [8.0, 2.0, 
3.0]]], [[[1.0, 4.0, 3.0], [6.0, 4.0, 3.0], [4.0, 1.0, 2.0]], [[7.0, 3.0, 4.0], [8.0, 1.0, 2.0], [6.0, 1.0, 7.0]], [[2.0, 7.0, 
6.0], [2.0, 2.0, 4.0], [7.0, 1.0, 2.0]]]])+(1.-msk_ref)*numpy.array([[[[8.0, 5.0, 6.0], [5.0, 1.0, 2.0], [3.0, 3.0, 1.0]], 
[[6.0, 4.0, 1.0], [3.0, 4.0, 7.0], [8.0, 6.0, 7.0]], [[1.0, 4.0, 2.0], [1.0, 7.0, 1.0], [3.0, 4.0, 4.0]]], [[[3.0, 6.0, 1.0], 
[3.0, 8.0, 2.0], [2.0, 8.0, 2.0]], [[1.0, 3.0, 8.0], [1.0, 6.0, 3.0], [3.0, 2.0, 8.0]], [[4.0, 1.0, 5.0], [7.0, 1.0, 8.0], 
[8.0, 3.0, 2.0]]], [[[2.0, 1.0, 4.0], [6.0, 3.0, 7.0], [6.0, 5.0, 5.0]], [[6.0, 6.0, 5.0], [3.0, 4.0, 2.0], [3.0, 4.0, 4.0]], 
[[1.0, 5.0, 2.0], [2.0, 7.0, 8.0], [8.0, 2.0, 3.0]]], [[[1.0, 4.0, 3.0], [6.0, 4.0, 3.0], [4.0, 1.0, 2.0]], [[4.0, 4.0, 6.0], 
[4.0, 4.0, 6.0], [6.0, 1.0, 7.0]], [[2.0, 7.0, 6.0], [2.0, 2.0, 4.0], [7.0, 1.0, 2.0]]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank4_taggedData_CUPN(self):
      arg=Data(numpy.array([[[[6.0, 7.0, 6.0], [4.0, 3.0, 3.0], [1.0, 3.0, 4.0]], [[4.0, 8.0, 3.0], [6.0, 1.0, 7.0], [3.0, 4.0, 
1.0]], [[8.0, 4.0, 3.0], [4.0, 4.0, 5.0], [6.0, 7.0, 2.0]]], [[[2.0, 6.0, 8.0], [5.0, 8.0, 6.0], [8.0, 5.0, 4.0]], [[4.0, 5.0, 
2.0], [3.0, 7.0, 8.0], [2.0, 2.0, 6.0]], [[5.0, 7.0, 2.0], [5.0, 5.0, 5.0], [5.0, 7.0, 6.0]]], [[[6.0, 2.0, 5.0], [6.0, 4.0, 
8.0], [7.0, 8.0, 6.0]], [[4.0, 3.0, 5.0], [7.0, 7.0, 8.0], [6.0, 4.0, 4.0]], [[8.0, 5.0, 7.0], [5.0, 7.0, 6.0], [7.0, 6.0, 
3.0]]], [[[5.0, 5.0, 4.0], [3.0, 7.0, 6.0], [3.0, 1.0, 4.0]], [[4.0, 1.0, 7.0], [4.0, 3.0, 3.0], [4.0, 1.0, 3.0]], [[8.0, 2.0, 
8.0], [3.0, 2.0, 8.0], [7.0, 3.0, 6.0]]]]),self.functionspace)
      val=Data(numpy.array([[[5.0, 8.0, 7.0], [3.0, 5.0, 3.0]], [[5.0, 2.0, 5.0], [4.0, 6.0, 3.0]], [[2.0, 5.0, 2.0], [5.0, 
1.0, 8.0]], [[7.0, 7.0, 2.0], [4.0, 8.0, 8.0]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[8.0, 4.0, 4.0], [5.0, 2.0, 3.0]], [[2.0, 1.0, 4.0], [8.0, 5.0, 7.0]], [[8.0, 5.0, 
5.0], [1.0, 1.0, 2.0]], [[1.0, 3.0, 7.0], [6.0, 7.0, 3.0]]]))
      arg[:,:2,1]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[6.0, 7.0, 6.0], [5.0, 8.0, 7.0], [1.0, 3.0, 4.0]], [[4.0, 8.0, 3.0], [3.0, 5.0, 3.0], [3.0, 
4.0, 1.0]], [[8.0, 4.0, 3.0], [4.0, 4.0, 5.0], [6.0, 7.0, 2.0]]], [[[2.0, 6.0, 8.0], [5.0, 2.0, 5.0], [8.0, 5.0, 4.0]], [[4.0, 
5.0, 2.0], [4.0, 6.0, 3.0], [2.0, 2.0, 6.0]], [[5.0, 7.0, 2.0], [5.0, 5.0, 5.0], [5.0, 7.0, 6.0]]], [[[6.0, 2.0, 5.0], [2.0, 
5.0, 2.0], [7.0, 8.0, 6.0]], [[4.0, 3.0, 5.0], [5.0, 1.0, 8.0], [6.0, 4.0, 4.0]], [[8.0, 5.0, 7.0], [5.0, 7.0, 6.0], [7.0, 6.0, 
3.0]]], [[[5.0, 5.0, 4.0], [7.0, 7.0, 2.0], [3.0, 1.0, 4.0]], [[4.0, 1.0, 7.0], [4.0, 8.0, 8.0], [4.0, 1.0, 3.0]], [[8.0, 2.0, 
8.0], [3.0, 2.0, 8.0], [7.0, 3.0, 6.0]]]])+(1.-msk_ref)*numpy.array([[[[6.0, 7.0, 6.0], [8.0, 4.0, 4.0], [1.0, 3.0, 4.0]], 
[[4.0, 8.0, 3.0], [5.0, 2.0, 3.0], [3.0, 4.0, 1.0]], [[8.0, 4.0, 3.0], [4.0, 4.0, 5.0], [6.0, 7.0, 2.0]]], [[[2.0, 6.0, 8.0], 
[2.0, 1.0, 4.0], [8.0, 5.0, 4.0]], [[4.0, 5.0, 2.0], [8.0, 5.0, 7.0], [2.0, 2.0, 6.0]], [[5.0, 7.0, 2.0], [5.0, 5.0, 5.0], 
[5.0, 7.0, 6.0]]], [[[6.0, 2.0, 5.0], [8.0, 5.0, 5.0], [7.0, 8.0, 6.0]], [[4.0, 3.0, 5.0], [1.0, 1.0, 2.0], [6.0, 4.0, 4.0]], 
[[8.0, 5.0, 7.0], [5.0, 7.0, 6.0], [7.0, 6.0, 3.0]]], [[[5.0, 5.0, 4.0], [1.0, 3.0, 7.0], [3.0, 1.0, 4.0]], [[4.0, 1.0, 7.0], 
[6.0, 7.0, 3.0], [4.0, 1.0, 3.0]], [[8.0, 2.0, 8.0], [3.0, 2.0, 8.0], [7.0, 3.0, 6.0]]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank4_taggedData_LPLP(self):
      arg=Data(numpy.array([[[[3.0, 1.0, 5.0], [1.0, 4.0, 4.0], [3.0, 7.0, 8.0]], [[5.0, 1.0, 2.0], [7.0, 1.0, 2.0], [4.0, 4.0, 
3.0]], [[1.0, 5.0, 4.0], [8.0, 6.0, 3.0], [4.0, 1.0, 4.0]]], [[[7.0, 2.0, 7.0], [6.0, 3.0, 3.0], [5.0, 8.0, 1.0]], [[7.0, 1.0, 
7.0], [1.0, 1.0, 5.0], [3.0, 8.0, 5.0]], [[1.0, 6.0, 4.0], [8.0, 1.0, 7.0], [6.0, 3.0, 8.0]]], [[[2.0, 2.0, 5.0], [5.0, 8.0, 
5.0], [5.0, 8.0, 2.0]], [[1.0, 4.0, 7.0], [8.0, 4.0, 2.0], [2.0, 4.0, 8.0]], [[5.0, 5.0, 6.0], [8.0, 5.0, 6.0], [1.0, 6.0, 
6.0]]], [[[8.0, 5.0, 1.0], [7.0, 3.0, 5.0], [3.0, 1.0, 3.0]], [[4.0, 1.0, 3.0], [5.0, 1.0, 6.0], [1.0, 2.0, 3.0]], [[4.0, 2.0, 
7.0], [4.0, 1.0, 3.0], [7.0, 7.0, 2.0]]]]),self.functionspace)
      val=Data(numpy.array([[5.0], [1.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[7.0], [1.0]]))
      arg[2:,1,2:,1]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[3.0, 1.0, 5.0], [1.0, 4.0, 4.0], [3.0, 7.0, 8.0]], [[5.0, 1.0, 2.0], [7.0, 1.0, 2.0], [4.0, 
4.0, 3.0]], [[1.0, 5.0, 4.0], [8.0, 6.0, 3.0], [4.0, 1.0, 4.0]]], [[[7.0, 2.0, 7.0], [6.0, 3.0, 3.0], [5.0, 8.0, 1.0]], [[7.0, 
1.0, 7.0], [1.0, 1.0, 5.0], [3.0, 8.0, 5.0]], [[1.0, 6.0, 4.0], [8.0, 1.0, 7.0], [6.0, 3.0, 8.0]]], [[[2.0, 2.0, 5.0], [5.0, 
8.0, 5.0], [5.0, 8.0, 2.0]], [[1.0, 4.0, 7.0], [8.0, 4.0, 2.0], [2.0, 5.0, 8.0]], [[5.0, 5.0, 6.0], [8.0, 5.0, 6.0], [1.0, 6.0, 
6.0]]], [[[8.0, 5.0, 1.0], [7.0, 3.0, 5.0], [3.0, 1.0, 3.0]], [[4.0, 1.0, 3.0], [5.0, 1.0, 6.0], [1.0, 1.0, 3.0]], [[4.0, 2.0, 
7.0], [4.0, 1.0, 3.0], [7.0, 7.0, 2.0]]]])+(1.-msk_ref)*numpy.array([[[[3.0, 1.0, 5.0], [1.0, 4.0, 4.0], [3.0, 7.0, 8.0]], 
[[5.0, 1.0, 2.0], [7.0, 1.0, 2.0], [4.0, 4.0, 3.0]], [[1.0, 5.0, 4.0], [8.0, 6.0, 3.0], [4.0, 1.0, 4.0]]], [[[7.0, 2.0, 7.0], 
[6.0, 3.0, 3.0], [5.0, 8.0, 1.0]], [[7.0, 1.0, 7.0], [1.0, 1.0, 5.0], [3.0, 8.0, 5.0]], [[1.0, 6.0, 4.0], [8.0, 1.0, 7.0], 
[6.0, 3.0, 8.0]]], [[[2.0, 2.0, 5.0], [5.0, 8.0, 5.0], [5.0, 8.0, 2.0]], [[1.0, 4.0, 7.0], [8.0, 4.0, 2.0], [2.0, 7.0, 8.0]], 
[[5.0, 5.0, 6.0], [8.0, 5.0, 6.0], [1.0, 6.0, 6.0]]], [[[8.0, 5.0, 1.0], [7.0, 3.0, 5.0], [3.0, 1.0, 3.0]], [[4.0, 1.0, 3.0], 
[5.0, 1.0, 6.0], [1.0, 1.0, 3.0]], [[4.0, 2.0, 7.0], [4.0, 1.0, 3.0], [7.0, 7.0, 2.0]]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank4_taggedData_PRUP(self):
      arg=Data(numpy.array([[[[5.0, 7.0, 6.0], [7.0, 5.0, 6.0], [4.0, 4.0, 6.0]], [[8.0, 2.0, 4.0], [4.0, 3.0, 8.0], [2.0, 4.0, 
6.0]], [[6.0, 6.0, 1.0], [5.0, 3.0, 6.0], [4.0, 8.0, 4.0]]], [[[8.0, 8.0, 8.0], [3.0, 5.0, 3.0], [8.0, 7.0, 5.0]], [[5.0, 8.0, 
7.0], [5.0, 8.0, 2.0], [6.0, 5.0, 1.0]], [[5.0, 3.0, 8.0], [7.0, 8.0, 8.0], [7.0, 4.0, 8.0]]], [[[6.0, 5.0, 4.0], [6.0, 1.0, 
8.0], [1.0, 8.0, 3.0]], [[6.0, 2.0, 4.0], [2.0, 7.0, 6.0], [4.0, 2.0, 1.0]], [[1.0, 6.0, 1.0], [5.0, 2.0, 4.0], [8.0, 4.0, 
2.0]]], [[[2.0, 1.0, 1.0], [1.0, 4.0, 3.0], [4.0, 3.0, 4.0]], [[6.0, 4.0, 2.0], [3.0, 6.0, 8.0], [3.0, 1.0, 2.0]], [[1.0, 4.0, 
5.0], [1.0, 2.0, 2.0], [6.0, 3.0, 5.0]]]]),self.functionspace)
      val=Data(numpy.array([[4.0, 5.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[1.0, 8.0]]))
      arg[2,1:2,:2,1]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[5.0, 7.0, 6.0], [7.0, 5.0, 6.0], [4.0, 4.0, 6.0]], [[8.0, 2.0, 4.0], [4.0, 3.0, 8.0], [2.0, 
4.0, 6.0]], [[6.0, 6.0, 1.0], [5.0, 3.0, 6.0], [4.0, 8.0, 4.0]]], [[[8.0, 8.0, 8.0], [3.0, 5.0, 3.0], [8.0, 7.0, 5.0]], [[5.0, 
8.0, 7.0], [5.0, 8.0, 2.0], [6.0, 5.0, 1.0]], [[5.0, 3.0, 8.0], [7.0, 8.0, 8.0], [7.0, 4.0, 8.0]]], [[[6.0, 5.0, 4.0], [6.0, 
1.0, 8.0], [1.0, 8.0, 3.0]], [[6.0, 4.0, 4.0], [2.0, 5.0, 6.0], [4.0, 2.0, 1.0]], [[1.0, 6.0, 1.0], [5.0, 2.0, 4.0], [8.0, 4.0, 
2.0]]], [[[2.0, 1.0, 1.0], [1.0, 4.0, 3.0], [4.0, 3.0, 4.0]], [[6.0, 4.0, 2.0], [3.0, 6.0, 8.0], [3.0, 1.0, 2.0]], [[1.0, 4.0, 
5.0], [1.0, 2.0, 2.0], [6.0, 3.0, 5.0]]]])+(1.-msk_ref)*numpy.array([[[[5.0, 7.0, 6.0], [7.0, 5.0, 6.0], [4.0, 4.0, 6.0]], 
[[8.0, 2.0, 4.0], [4.0, 3.0, 8.0], [2.0, 4.0, 6.0]], [[6.0, 6.0, 1.0], [5.0, 3.0, 6.0], [4.0, 8.0, 4.0]]], [[[8.0, 8.0, 8.0], 
[3.0, 5.0, 3.0], [8.0, 7.0, 5.0]], [[5.0, 8.0, 7.0], [5.0, 8.0, 2.0], [6.0, 5.0, 1.0]], [[5.0, 3.0, 8.0], [7.0, 8.0, 8.0], 
[7.0, 4.0, 8.0]]], [[[6.0, 5.0, 4.0], [6.0, 1.0, 8.0], [1.0, 8.0, 3.0]], [[6.0, 1.0, 4.0], [2.0, 8.0, 6.0], [4.0, 2.0, 1.0]], 
[[1.0, 6.0, 1.0], [5.0, 2.0, 4.0], [8.0, 4.0, 2.0]]], [[[2.0, 1.0, 1.0], [1.0, 4.0, 3.0], [4.0, 3.0, 4.0]], [[6.0, 4.0, 2.0], 
[3.0, 6.0, 8.0], [3.0, 1.0, 2.0]], [[1.0, 4.0, 5.0], [1.0, 2.0, 2.0], [6.0, 3.0, 5.0]]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank4_taggedData_CLUC(self):
      arg=Data(numpy.array([[[[1.0, 2.0, 6.0], [6.0, 6.0, 7.0], [3.0, 1.0, 4.0]], [[8.0, 5.0, 7.0], [4.0, 6.0, 6.0], [8.0, 2.0, 
1.0]], [[3.0, 1.0, 3.0], [3.0, 7.0, 8.0], [1.0, 1.0, 2.0]]], [[[2.0, 1.0, 1.0], [2.0, 7.0, 8.0], [5.0, 1.0, 5.0]], [[8.0, 5.0, 
3.0], [5.0, 3.0, 6.0], [5.0, 8.0, 6.0]], [[3.0, 5.0, 8.0], [1.0, 8.0, 6.0], [4.0, 2.0, 5.0]]], [[[1.0, 6.0, 4.0], [7.0, 6.0, 
1.0], [2.0, 7.0, 6.0]], [[4.0, 7.0, 5.0], [2.0, 6.0, 3.0], [5.0, 7.0, 4.0]], [[5.0, 6.0, 8.0], [3.0, 1.0, 1.0], [1.0, 5.0, 
8.0]]], [[[7.0, 2.0, 6.0], [4.0, 6.0, 4.0], [3.0, 7.0, 2.0]], [[7.0, 2.0, 8.0], [1.0, 2.0, 4.0], [5.0, 4.0, 1.0]], [[5.0, 2.0, 
2.0], [1.0, 7.0, 5.0], [5.0, 4.0, 5.0]]]]),self.functionspace)
      val=Data(numpy.array([[[[5.0, 5.0, 7.0], [3.0, 3.0, 2.0]]], [[[8.0, 5.0, 5.0], [6.0, 5.0, 1.0]]], [[[1.0, 8.0, 4.0], 
[7.0, 3.0, 6.0]]], [[[5.0, 8.0, 1.0], [3.0, 4.0, 1.0]]]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[[[8.0, 1.0, 7.0], [8.0, 5.0, 7.0]]], [[[4.0, 1.0, 1.0], [6.0, 2.0, 8.0]]], [[[4.0, 
3.0, 2.0], [1.0, 5.0, 7.0]]], [[[7.0, 5.0, 2.0], [4.0, 2.0, 6.0]]]]))
      arg[:,2:,:2,:]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[1.0, 2.0, 6.0], [6.0, 6.0, 7.0], [3.0, 1.0, 4.0]], [[8.0, 5.0, 7.0], [4.0, 6.0, 6.0], [8.0, 
2.0, 1.0]], [[5.0, 5.0, 7.0], [3.0, 3.0, 2.0], [1.0, 1.0, 2.0]]], [[[2.0, 1.0, 1.0], [2.0, 7.0, 8.0], [5.0, 1.0, 5.0]], [[8.0, 
5.0, 3.0], [5.0, 3.0, 6.0], [5.0, 8.0, 6.0]], [[8.0, 5.0, 5.0], [6.0, 5.0, 1.0], [4.0, 2.0, 5.0]]], [[[1.0, 6.0, 4.0], [7.0, 
6.0, 1.0], [2.0, 7.0, 6.0]], [[4.0, 7.0, 5.0], [2.0, 6.0, 3.0], [5.0, 7.0, 4.0]], [[1.0, 8.0, 4.0], [7.0, 3.0, 6.0], [1.0, 5.0, 
8.0]]], [[[7.0, 2.0, 6.0], [4.0, 6.0, 4.0], [3.0, 7.0, 2.0]], [[7.0, 2.0, 8.0], [1.0, 2.0, 4.0], [5.0, 4.0, 1.0]], [[5.0, 8.0, 
1.0], [3.0, 4.0, 1.0], [5.0, 4.0, 5.0]]]])+(1.-msk_ref)*numpy.array([[[[1.0, 2.0, 6.0], [6.0, 6.0, 7.0], [3.0, 1.0, 4.0]], 
[[8.0, 5.0, 7.0], [4.0, 6.0, 6.0], [8.0, 2.0, 1.0]], [[8.0, 1.0, 7.0], [8.0, 5.0, 7.0], [1.0, 1.0, 2.0]]], [[[2.0, 1.0, 1.0], 
[2.0, 7.0, 8.0], [5.0, 1.0, 5.0]], [[8.0, 5.0, 3.0], [5.0, 3.0, 6.0], [5.0, 8.0, 6.0]], [[4.0, 1.0, 1.0], [6.0, 2.0, 8.0], 
[4.0, 2.0, 5.0]]], [[[1.0, 6.0, 4.0], [7.0, 6.0, 1.0], [2.0, 7.0, 6.0]], [[4.0, 7.0, 5.0], [2.0, 6.0, 3.0], [5.0, 7.0, 4.0]], 
[[4.0, 3.0, 2.0], [1.0, 5.0, 7.0], [1.0, 5.0, 8.0]]], [[[7.0, 2.0, 6.0], [4.0, 6.0, 4.0], [3.0, 7.0, 2.0]], [[7.0, 2.0, 8.0], 
[1.0, 2.0, 4.0], [5.0, 4.0, 1.0]], [[7.0, 5.0, 2.0], [4.0, 2.0, 6.0], [5.0, 4.0, 5.0]]]])
      self.assertTrue(Lsup(arg-ref)<=self.RES_TOL*Lsup(ref),"wrong result")
   #+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
   def test_setslice_constData_rank4_taggedData_PLUP(self):
      arg=Data(numpy.array([[[[8.0, 8.0, 8.0], [1.0, 3.0, 2.0], [5.0, 1.0, 3.0]], [[6.0, 4.0, 8.0], [4.0, 5.0, 1.0], [4.0, 2.0, 
1.0]], [[7.0, 3.0, 6.0], [2.0, 7.0, 7.0], [1.0, 5.0, 3.0]]], [[[6.0, 5.0, 7.0], [3.0, 2.0, 1.0], [8.0, 8.0, 6.0]], [[4.0, 5.0, 
2.0], [8.0, 1.0, 4.0], [1.0, 3.0, 4.0]], [[4.0, 1.0, 2.0], [3.0, 8.0, 7.0], [1.0, 6.0, 7.0]]], [[[6.0, 7.0, 1.0], [5.0, 2.0, 
8.0], [5.0, 8.0, 3.0]], [[1.0, 2.0, 8.0], [1.0, 8.0, 1.0], [1.0, 4.0, 2.0]], [[1.0, 7.0, 6.0], [3.0, 5.0, 6.0], [4.0, 2.0, 
8.0]]], [[[7.0, 3.0, 2.0], [2.0, 8.0, 7.0], [4.0, 3.0, 7.0]], [[4.0, 5.0, 4.0], [6.0, 7.0, 1.0], [3.0, 2.0, 3.0]], [[5.0, 7.0, 
4.0], [3.0, 6.0, 6.0], [6.0, 5.0, 1.0]]]]),self.functionspace)
      val=Data(numpy.array([[1.0, 6.0]]),self.functionspace)
      val.setTaggedValue(1,numpy.array([[4.0, 4.0]]))
      arg[2,2:,:2,1]=val
      msk_ref=1.-whereZero(self.functionspace.getX()[0],1.e-8)
      ref=msk_ref*numpy.array([[[[8.0, 8.0, 8.0], [1.0, 3.0, 2.0], [5.0, 1.0, 3.0]], [[6.0, 4.0, 8.0], [4.0, 5.0, 1.0], [4.0, 
2.0, 1.0]], [[7.0, 3.0, 6.0], [2.0, 7.0, 7.0], [1.0, 5.0, 3.0]]], [[[6.0, 5.0, 7.0], [3.0, 2.0, 1.0], [8.0, 8.0, 6.0]], [[4.0, 
5.0, 2.0], [8.0, 1.0, 4.0], [1.0, 3.0, 4.0]], [[4.0, 1.0, 2.0], [3.0, 8.0, 7.0], [1.0, 6.0, 7.0]]], [[[6.0, 7.0, 1.0], [5.0, 
2.0, 8.0], [5.0, 8.0, 3.0]], [[1.0, 2.0, 8.0], [1.0, 8.0, 1.0], [1.0, 4.0, 2.0]], [[1.0, 1.0, 6.0], [3.0, 6.0, 6.0], [4.0, 2.0, 
8.0]]], [[[7.0, 3.0, 2.0], [2.0, 8.0, 7.0], [4.0, 3.0, 7.0]], [[4.0, 5.0, 4.0], [6.0, 