# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for
# license information.
#
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from .rule_action import RuleAction


class RuleWebhookAction(RuleAction):
    """Specifies the action to post to service when the rule condition is
    evaluated. The discriminator is always RuleWebhookAction in this case.

    :param odatatype: Polymorphic Discriminator
    :type odatatype: str
    :param service_uri: the service uri to Post the notitication when the
     alert activates or resolves.
    :type service_uri: str
    :param properties: the dictionary of custom properties to include with the
     post operation. These data are appended to the webhook payload.
    :type properties: dict
    """

    _validation = {
        'odatatype': {'required': True},
    }

    _attribute_map = {
        'odatatype': {'key': 'odata\\.type', 'type': 'str'},
        'service_uri': {'key': 'serviceUri', 'type': 'str'},
        'properties': {'key': 'properties', 'type': '{str}'},
    }

    def __init__(self, service_uri=None, properties=None):
        super(RuleWebhookAction, self).__init__()
        self.service_uri = service_uri
        self.properties = properties
        self.odatatype = 'Microsoft.Azure.Management.Insights.Models.RuleWebhookAction'
