package org.jboss.cache.api.nodevalidity;

import org.jboss.cache.Cache;
import org.jboss.cache.CacheFactory;
import org.jboss.cache.DefaultCacheFactory;
import org.jboss.cache.util.TestingUtil;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.Test;

/**
 * @author <a href="mailto:manik@jboss.org">Manik Surtani</a>
 * @since 2.1.0
 */
@Test(groups = {"functional"})
public class LocalPessNodeValidityTest extends NodeValidityTestBase
{
   private Cache<String, String> cache;

   public LocalPessNodeValidityTest()
   {
      clustered = false;
   }

   @AfterMethod
   public void tearDown()
   {
      super.tearDown();
      TestingUtil.killCaches(cache);
      cache = null;
   }

   protected Cache<String, String> createObserver()
   {
      return createModifier();
   }

   protected Cache<String, String> createModifier()
   {
      if (cache == null)
      {
         CacheFactory<String, String> f = new DefaultCacheFactory();
         cache = f.createCache(false);
         optimisticConfiguration(cache.getConfiguration());
         cache.start();
         return cache;
      }
      return cache;
   }
}
