/*
 *  @(#)DefaultAttributeInfo.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Part of the GroboUtils package at:
 *  http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */
package net.sourceforge.groboutils.pmti.v1.defimpl;

import net.sourceforge.groboutils.pmti.v1.IAttributeInfo;

/**
 * Describes a particular attribute.  Note that since attributes may be
 * shared among issue types, this cannot describe the particulars of the
 * real attribute's type.
 *
 * @author     Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version    $Date: 2003/02/10 22:51:58 $
 * @since      July 12, 2002
 */
public class DefaultAttributeInfo implements IAttributeInfo
{
    private String name;
    private String desc;
    private Class[] types;
    
    
    public DefaultAttributeInfo( String n, String d, Class[] t )
    {
        if (n == null)
        {
            throw new IllegalArgumentException("no null arguments");
        }
        this.types = copyClasses( t );
        
        this.name = n;
        this.desc = d;
    }
    
    
    
    /**
     * Returns the identifying name of this attribute.
     */
    public String getName()
    {
        return this.name;
    }
    
    
    /**
     * Returns a human-readable description of this attribute.
     */
    public String getDescription()
    {
        return this.desc;
    }
    
    
    /**
     * Returns a list of the acceptable types (baseclasses and
     * interfaces) for the values stored with this attribute.  Implementations
     * should return a minimal but most descriptive set of classes
     * (that is, only returning <tt>java.lang.Object</tt> is not descriptive;
     * likewise if there are many known implementations of an inferface,
     * only the interface need to be returned).  This is a convenience method,
     * and should not be relied upon to generate input values.
     */
    public Class[] getValueTypes()
    {
        return copyClasses( this.types );
    }
    
    
    private Class[] copyClasses( Class[] c )
    {
        if (c == null)
        {
            throw new IllegalArgumentException("no null arguments");
        }
        Class[] ret = new Class[ c.length ];
        System.arraycopy( c, 0, ret, 0, c.length );
        return ret;
    }
}

