#ifdef __cplusplus
extern "C" {
#endif
#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#ifdef __cplusplus
}
#endif

#include <sys/param.h>
#include <sys/mount.h>
#include <unistd.h>
#include <stdlib.h>


MODULE = PathUtils		PACKAGE = PathUtils		

#if defined(__bsdi__)

SV*
GetMountPoint(path)
	char *path
	PREINIT:
	struct statfs fs;
	CODE:
	ST(0) = sv_newmortal();
	
	if(!statfs(path, &fs))
	    sv_setpv(ST(0), fs.f_mntonname);


#else

SV*
GetMountPoint(path)
	char *path
	CODE:
	ST(0) = sv_newmortal();
	sv_setpv(ST(0), "/");

#endif

SV*
RealPath(path)
	char *path
	PREINIT:
	char buf[2*MAXPATHLEN];
	char *p;
	CODE:
	ST(0) = sv_newmortal();
	
	if((p=realpath(path, buf)) != NULL)
	    sv_setpv(ST(0), p);

SV*
cwd()
        PREINIT:
	char buf[2*MAXPATHLEN];
        char *p;
	CODE:
	ST(0) = sv_newmortal();

        if((p=getcwd(buf, sizeof(buf))) != NULL)
	    sv_setpv(ST(0), p);

