#!/usr/local/bin/perl5.00401 -w -T -I/home/hostmaster/dist-ip-req-robot/lib

# Copyright (c) 1993, 1994, 1995, 1996, 1997    The TERENA Association
# Copyright (c) 1998                            RIPE NCC
#
# All Rights Reserved
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of the author not be
# used in advertising or publicity pertaining to distribution of the
# software without specific, written prior permission.
#
# THE AUTHOR DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
# ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS; IN NO EVENT SHALL
# AUTHOR BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY
# DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN
# AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
# OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

#------------------------------------------------------------------------------
# Module Header
# Filename          :	auto-hm-text.pl
# Purpose           :	calls all the PERL routines which implement the 
# 			text and web page checking versions of the hm robot.
# Author            :	Lee Wilmot
# Date              :	971105 / 990108
# Description       :	
# Language Version  :	PERL5, version 5.004
# OSs Tested        :	BSDI 3.1
# Command Line      :	auto-hm.pl <args>
# Input Files       :	None: see package descriptions
# Output Files      :	None: see package descriptions
# External Programs :	None: see package descriptions
# Problems          :	
# To Do             :
# Comments          :   Accepts arguments defined in &Misc::parse_arguments
# Exit values       :   Success: 0
#                   :   Failure: -1
#------------------------------------------------------------------------------

package main;

use strict;

use subs qw(
	&perl_problem_handler &signal_handler
);

use RobotConfig qw(
    $NORMAL_COMPLETION_TXT
    $REPORT_TYPE_FLAG %REPORT_TYPE
);

use Check qw(
	&check
);

use HtmlReport qw(
	&html_report
);

use EmailReport qw(
	&email_report
);

use Misc qw(
	&clr_tmp_dir &chk_tmp_dir &fatal 
	&parse_arguments &check_debug_flags
        &exit_gracefully
);

use Extract qw(
	&extract
);

########################### SIGNAL HANDLERS ###########################

$SIG{__DIE__} = \&perl_problem_handler;
$SIG{__WARN__} = \&perl_problem_handler;

$SIG{'INT'} = \&signal_handler;
$SIG{'KILL'} = \&signal_handler;

sub perl_problem_handler {
 	my ($prob) = @_;
 	&fatal("Exiting due to program warning/error: $prob. Please notify maintainer.");
}

sub signal_handler {
 	my ($sig) = @_;
 	&fatal("Received signal $sig.");
}

################################ DO IT #################################

$ENV{'USER'} = 'autohm';  	# set user environment variable
				# added Lee 19981216 under pressure
				# from Mal :-)

$ENV{'PATH'} = '/bin';		# Restricted path for more safety 
                                # during shell calls. Ideally this
                                # would be clear, but rtt doesn't
                                # needs (at least) chmod and mkdir

umask 002;              	# make files created group writeable

&parse_arguments;		# what the name says

&check_debug_flags;		# check flags have OK settings etc
				# set defaults for the mode

&chk_tmp_dir;			# check if any files in the temporary
				# directory are so old they should be deleted



&extract;			# extract templates from STDIN into an array of hashes

&check;			        # attach problem codes to each hash

# Produce a report, type dependent on $REPORT_TYPE_FLAG

if ( $REPORT_TYPE_FLAG eq $REPORT_TYPE{HTML} )	{
    &html_report; 	        # html report
}
else {
    &email_report; 	        # email report (default)
}

&clr_tmp_dir;			# remove any temp files created during processing.
				# If we reached this point then there weren't any
				# fatal problems so it's safe to remove the 'evidence'.

&exit_gracefully( 0, $NORMAL_COMPLETION_TXT );

