/* A Bison parser, made by GNU Bison 1.875.  */

/* Skeleton parser for Yacc-like parsing with Bison,
   Copyright (C) 1984, 1989, 1990, 2000, 2001, 2002 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* Written by Richard Stallman by simplifying the original so called
   ``semantic'' parser.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output.  */
#define YYBISON 1

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Using locations.  */
#define YYLSP_NEEDED 1

/* If NAME_PREFIX is specified substitute the variables and functions
   names.  */
#define yyparse base_yyparse
#define yylex   base_yylex
#define yyerror base_yyerror
#define yylval  base_yylval
#define yychar  base_yychar
#define yydebug base_yydebug
#define yynerrs base_yynerrs
#define yylloc base_yylloc

/* Tokens.  */
#ifndef YYTOKENTYPE
# define YYTOKENTYPE
   /* Put the tokens into the symbol table, so that GDB and other debuggers
      know about them.  */
   enum yytokentype {
     SQL_ALLOCATE = 258,
     SQL_AUTOCOMMIT = 259,
     SQL_BOOL = 260,
     SQL_BREAK = 261,
     SQL_CALL = 262,
     SQL_CARDINALITY = 263,
     SQL_CONNECT = 264,
     SQL_COUNT = 265,
     SQL_DATETIME_INTERVAL_CODE = 266,
     SQL_DATETIME_INTERVAL_PRECISION = 267,
     SQL_DESCRIBE = 268,
     SQL_DESCRIPTOR = 269,
     SQL_DISCONNECT = 270,
     SQL_FOUND = 271,
     SQL_FREE = 272,
     SQL_GET = 273,
     SQL_GO = 274,
     SQL_GOTO = 275,
     SQL_IDENTIFIED = 276,
     SQL_INDICATOR = 277,
     SQL_KEY_MEMBER = 278,
     SQL_LENGTH = 279,
     SQL_LONG = 280,
     SQL_NULLABLE = 281,
     SQL_OCTET_LENGTH = 282,
     SQL_OPEN = 283,
     SQL_OUTPUT = 284,
     SQL_REFERENCE = 285,
     SQL_RETURNED_LENGTH = 286,
     SQL_RETURNED_OCTET_LENGTH = 287,
     SQL_SCALE = 288,
     SQL_SECTION = 289,
     SQL_SHORT = 290,
     SQL_SIGNED = 291,
     SQL_SQL = 292,
     SQL_SQLERROR = 293,
     SQL_SQLPRINT = 294,
     SQL_SQLWARNING = 295,
     SQL_START = 296,
     SQL_STOP = 297,
     SQL_STRUCT = 298,
     SQL_UNSIGNED = 299,
     SQL_VAR = 300,
     SQL_WHENEVER = 301,
     S_ADD = 302,
     S_AND = 303,
     S_ANYTHING = 304,
     S_AUTO = 305,
     S_CONST = 306,
     S_DEC = 307,
     S_DIV = 308,
     S_DOTPOINT = 309,
     S_EQUAL = 310,
     S_EXTERN = 311,
     S_INC = 312,
     S_LSHIFT = 313,
     S_MEMPOINT = 314,
     S_MEMBER = 315,
     S_MOD = 316,
     S_MUL = 317,
     S_NEQUAL = 318,
     S_OR = 319,
     S_REGISTER = 320,
     S_RSHIFT = 321,
     S_STATIC = 322,
     S_SUB = 323,
     S_VOLATILE = 324,
     S_TYPEDEF = 325,
     CSTRING = 326,
     CVARIABLE = 327,
     CPP_LINE = 328,
     IP = 329,
     DOLCONST = 330,
     ECONST = 331,
     NCONST = 332,
     UCONST = 333,
     UIDENT = 334,
     IDENT = 335,
     FCONST = 336,
     SCONST = 337,
     BCONST = 338,
     XCONST = 339,
     Op = 340,
     ICONST = 341,
     PARAM = 342,
     TYPECAST = 343,
     DOT_DOT = 344,
     COLON_EQUALS = 345,
     ABORT_P = 346,
     ABSOLUTE_P = 347,
     ACCESS = 348,
     ACTION = 349,
     ADD_P = 350,
     ADMIN = 351,
     AFTER = 352,
     AGGREGATE = 353,
     ALL = 354,
     ALSO = 355,
     ALTER = 356,
     ALWAYS = 357,
     ANALYSE = 358,
     ANALYZE = 359,
     AND = 360,
     ANY = 361,
     ARRAY = 362,
     AS = 363,
     ASC = 364,
     ASSERTION = 365,
     ASSIGNMENT = 366,
     ASYMMETRIC = 367,
     AT = 368,
     AUTHORIZATION = 369,
     BACKWARD = 370,
     BEFORE = 371,
     BEGIN_P = 372,
     BETWEEN = 373,
     BIGINT = 374,
     BINARY = 375,
     BIT = 376,
     BOOLEAN_P = 377,
     BOTH = 378,
     BY = 379,
     CACHE = 380,
     CALLED = 381,
     CASCADE = 382,
     CASCADED = 383,
     CASE = 384,
     CAST = 385,
     CATALOG_P = 386,
     CHAIN = 387,
     CHAR_P = 388,
     CHARACTER = 389,
     CHARACTERISTICS = 390,
     CHECK = 391,
     CHECKPOINT = 392,
     CLASS = 393,
     CLOSE = 394,
     CLUSTER = 395,
     COALESCE = 396,
     COLLATE = 397,
     COLUMN = 398,
     COMMENT = 399,
     COMMENTS = 400,
     COMMIT = 401,
     COMMITTED = 402,
     CONCURRENTLY = 403,
     CONFIGURATION = 404,
     CONNECTION = 405,
     CONSTRAINT = 406,
     CONSTRAINTS = 407,
     CONTENT_P = 408,
     CONTINUE_P = 409,
     CONVERSION_P = 410,
     COPY = 411,
     COST = 412,
     CREATE = 413,
     CREATEDB = 414,
     CREATEROLE = 415,
     CREATEUSER = 416,
     CROSS = 417,
     CSV = 418,
     CURRENT_P = 419,
     CURRENT_CATALOG = 420,
     CURRENT_DATE = 421,
     CURRENT_ROLE = 422,
     CURRENT_SCHEMA = 423,
     CURRENT_TIME = 424,
     CURRENT_TIMESTAMP = 425,
     CURRENT_USER = 426,
     CURSOR = 427,
     CYCLE = 428,
     DATA_P = 429,
     DATABASE = 430,
     DAY_P = 431,
     DEALLOCATE = 432,
     DEC = 433,
     DECIMAL_P = 434,
     DECLARE = 435,
     DEFAULT = 436,
     DEFAULTS = 437,
     DEFERRABLE = 438,
     DEFERRED = 439,
     DEFINER = 440,
     DELETE_P = 441,
     DELIMITER = 442,
     DELIMITERS = 443,
     DESC = 444,
     DICTIONARY = 445,
     DISABLE_P = 446,
     DISCARD = 447,
     DISTINCT = 448,
     DO = 449,
     DOCUMENT_P = 450,
     DOMAIN_P = 451,
     DOUBLE_P = 452,
     DROP = 453,
     EACH = 454,
     ELSE = 455,
     ENABLE_P = 456,
     ENCODING = 457,
     ENCRYPTED = 458,
     END_P = 459,
     ENUM_P = 460,
     ESCAPE = 461,
     EXCEPT = 462,
     EXCLUDE = 463,
     EXCLUDING = 464,
     EXCLUSIVE = 465,
     EXECUTE = 466,
     EXISTS = 467,
     EXPLAIN = 468,
     EXTERNAL = 469,
     EXTRACT = 470,
     FALSE_P = 471,
     FAMILY = 472,
     FETCH = 473,
     FIRST_P = 474,
     FLOAT_P = 475,
     FOLLOWING = 476,
     FOR = 477,
     FORCE = 478,
     FOREIGN = 479,
     FORWARD = 480,
     FREEZE = 481,
     FROM = 482,
     FULL = 483,
     FUNCTION = 484,
     FUNCTIONS = 485,
     GLOBAL = 486,
     GRANT = 487,
     GRANTED = 488,
     GREATEST = 489,
     GROUP_P = 490,
     HANDLER = 491,
     HAVING = 492,
     HEADER_P = 493,
     HOLD = 494,
     HOUR_P = 495,
     IDENTITY_P = 496,
     IF_P = 497,
     ILIKE = 498,
     IMMEDIATE = 499,
     IMMUTABLE = 500,
     IMPLICIT_P = 501,
     IN_P = 502,
     INCLUDING = 503,
     INCREMENT = 504,
     INDEX = 505,
     INDEXES = 506,
     INHERIT = 507,
     INHERITS = 508,
     INITIALLY = 509,
     INLINE_P = 510,
     INNER_P = 511,
     INOUT = 512,
     INPUT_P = 513,
     INSENSITIVE = 514,
     INSERT = 515,
     INSTEAD = 516,
     INT_P = 517,
     INTEGER = 518,
     INTERSECT = 519,
     INTERVAL = 520,
     INTO = 521,
     INVOKER = 522,
     IS = 523,
     ISNULL = 524,
     ISOLATION = 525,
     JOIN = 526,
     KEY = 527,
     LANGUAGE = 528,
     LARGE_P = 529,
     LAST_P = 530,
     LC_COLLATE_P = 531,
     LC_CTYPE_P = 532,
     LEADING = 533,
     LEAST = 534,
     LEFT = 535,
     LEVEL = 536,
     LIKE = 537,
     LIMIT = 538,
     LISTEN = 539,
     LOAD = 540,
     LOCAL = 541,
     LOCALTIME = 542,
     LOCALTIMESTAMP = 543,
     LOCATION = 544,
     LOCK_P = 545,
     LOGIN_P = 546,
     MAPPING = 547,
     MATCH = 548,
     MAXVALUE = 549,
     MINUTE_P = 550,
     MINVALUE = 551,
     MODE = 552,
     MONTH_P = 553,
     MOVE = 554,
     NAME_P = 555,
     NAMES = 556,
     NATIONAL = 557,
     NATURAL = 558,
     NCHAR = 559,
     NEXT = 560,
     NO = 561,
     NOCREATEDB = 562,
     NOCREATEROLE = 563,
     NOCREATEUSER = 564,
     NOINHERIT = 565,
     NOLOGIN_P = 566,
     NONE = 567,
     NOSUPERUSER = 568,
     NOT = 569,
     NOTHING = 570,
     NOTIFY = 571,
     NOTNULL = 572,
     NOWAIT = 573,
     NULL_P = 574,
     NULLIF = 575,
     NULLS_P = 576,
     NUMERIC = 577,
     OBJECT_P = 578,
     OF = 579,
     OFF = 580,
     OFFSET = 581,
     OIDS = 582,
     ON = 583,
     ONLY = 584,
     OPERATOR = 585,
     OPTION = 586,
     OPTIONS = 587,
     OR = 588,
     ORDER = 589,
     OUT_P = 590,
     OUTER_P = 591,
     OVER = 592,
     OVERLAPS = 593,
     OVERLAY = 594,
     OWNED = 595,
     OWNER = 596,
     PARSER = 597,
     PARTIAL = 598,
     PARTITION = 599,
     PASSWORD = 600,
     PLACING = 601,
     PLANS = 602,
     POSITION = 603,
     PRECEDING = 604,
     PRECISION = 605,
     PRESERVE = 606,
     PREPARE = 607,
     PREPARED = 608,
     PRIMARY = 609,
     PRIOR = 610,
     PRIVILEGES = 611,
     PROCEDURAL = 612,
     PROCEDURE = 613,
     QUOTE = 614,
     RANGE = 615,
     READ = 616,
     REAL = 617,
     REASSIGN = 618,
     RECHECK = 619,
     RECURSIVE = 620,
     REFERENCES = 621,
     REINDEX = 622,
     RELATIVE_P = 623,
     RELEASE = 624,
     RENAME = 625,
     REPEATABLE = 626,
     REPLACE = 627,
     REPLICA = 628,
     RESET = 629,
     RESTART = 630,
     RESTRICT = 631,
     RETURNING = 632,
     RETURNS = 633,
     REVOKE = 634,
     RIGHT = 635,
     ROLE = 636,
     ROLLBACK = 637,
     ROW = 638,
     ROWS = 639,
     RULE = 640,
     SAVEPOINT = 641,
     SCHEMA = 642,
     SCROLL = 643,
     SEARCH = 644,
     SECOND_P = 645,
     SECURITY = 646,
     SELECT = 647,
     SEQUENCE = 648,
     SEQUENCES = 649,
     SERIALIZABLE = 650,
     SERVER = 651,
     SESSION = 652,
     SESSION_USER = 653,
     SET = 654,
     SETOF = 655,
     SHARE = 656,
     SHOW = 657,
     SIMILAR = 658,
     SIMPLE = 659,
     SMALLINT = 660,
     SOME = 661,
     STABLE = 662,
     STANDALONE_P = 663,
     START = 664,
     STATEMENT = 665,
     STATISTICS = 666,
     STDIN = 667,
     STDOUT = 668,
     STORAGE = 669,
     STRICT_P = 670,
     STRIP_P = 671,
     SUBSTRING = 672,
     SUPERUSER_P = 673,
     SYMMETRIC = 674,
     SYSID = 675,
     SYSTEM_P = 676,
     TABLE = 677,
     TABLES = 678,
     TABLESPACE = 679,
     TEMP = 680,
     TEMPLATE = 681,
     TEMPORARY = 682,
     TEXT_P = 683,
     THEN = 684,
     TIME = 685,
     TIMESTAMP = 686,
     TO = 687,
     TRAILING = 688,
     TRANSACTION = 689,
     TREAT = 690,
     TRIGGER = 691,
     TRIM = 692,
     TRUE_P = 693,
     TRUNCATE = 694,
     TRUSTED = 695,
     TYPE_P = 696,
     UNBOUNDED = 697,
     UNCOMMITTED = 698,
     UNENCRYPTED = 699,
     UNION = 700,
     UNIQUE = 701,
     UNKNOWN = 702,
     UNLISTEN = 703,
     UNTIL = 704,
     UPDATE = 705,
     USER = 706,
     USING = 707,
     VACUUM = 708,
     VALID = 709,
     VALIDATOR = 710,
     VALUE_P = 711,
     VALUES = 712,
     VARCHAR = 713,
     VARIADIC = 714,
     VARYING = 715,
     VERBOSE = 716,
     VERSION_P = 717,
     VIEW = 718,
     VOLATILE = 719,
     WHEN = 720,
     WHERE = 721,
     WHITESPACE_P = 722,
     WINDOW = 723,
     WITH = 724,
     WITHOUT = 725,
     WORK = 726,
     WRAPPER = 727,
     WRITE = 728,
     XML_P = 729,
     XMLATTRIBUTES = 730,
     XMLCONCAT = 731,
     XMLELEMENT = 732,
     XMLFOREST = 733,
     XMLPARSE = 734,
     XMLPI = 735,
     XMLROOT = 736,
     XMLSERIALIZE = 737,
     YEAR_P = 738,
     YES_P = 739,
     ZONE = 740,
     NULLS_FIRST = 741,
     NULLS_LAST = 742,
     WITH_TIME = 743,
     POSTFIXOP = 744,
     UMINUS = 745
   };
#endif
#define SQL_ALLOCATE 258
#define SQL_AUTOCOMMIT 259
#define SQL_BOOL 260
#define SQL_BREAK 261
#define SQL_CALL 262
#define SQL_CARDINALITY 263
#define SQL_CONNECT 264
#define SQL_COUNT 265
#define SQL_DATETIME_INTERVAL_CODE 266
#define SQL_DATETIME_INTERVAL_PRECISION 267
#define SQL_DESCRIBE 268
#define SQL_DESCRIPTOR 269
#define SQL_DISCONNECT 270
#define SQL_FOUND 271
#define SQL_FREE 272
#define SQL_GET 273
#define SQL_GO 274
#define SQL_GOTO 275
#define SQL_IDENTIFIED 276
#define SQL_INDICATOR 277
#define SQL_KEY_MEMBER 278
#define SQL_LENGTH 279
#define SQL_LONG 280
#define SQL_NULLABLE 281
#define SQL_OCTET_LENGTH 282
#define SQL_OPEN 283
#define SQL_OUTPUT 284
#define SQL_REFERENCE 285
#define SQL_RETURNED_LENGTH 286
#define SQL_RETURNED_OCTET_LENGTH 287
#define SQL_SCALE 288
#define SQL_SECTION 289
#define SQL_SHORT 290
#define SQL_SIGNED 291
#define SQL_SQL 292
#define SQL_SQLERROR 293
#define SQL_SQLPRINT 294
#define SQL_SQLWARNING 295
#define SQL_START 296
#define SQL_STOP 297
#define SQL_STRUCT 298
#define SQL_UNSIGNED 299
#define SQL_VAR 300
#define SQL_WHENEVER 301
#define S_ADD 302
#define S_AND 303
#define S_ANYTHING 304
#define S_AUTO 305
#define S_CONST 306
#define S_DEC 307
#define S_DIV 308
#define S_DOTPOINT 309
#define S_EQUAL 310
#define S_EXTERN 311
#define S_INC 312
#define S_LSHIFT 313
#define S_MEMPOINT 314
#define S_MEMBER 315
#define S_MOD 316
#define S_MUL 317
#define S_NEQUAL 318
#define S_OR 319
#define S_REGISTER 320
#define S_RSHIFT 321
#define S_STATIC 322
#define S_SUB 323
#define S_VOLATILE 324
#define S_TYPEDEF 325
#define CSTRING 326
#define CVARIABLE 327
#define CPP_LINE 328
#define IP 329
#define DOLCONST 330
#define ECONST 331
#define NCONST 332
#define UCONST 333
#define UIDENT 334
#define IDENT 335
#define FCONST 336
#define SCONST 337
#define BCONST 338
#define XCONST 339
#define Op 340
#define ICONST 341
#define PARAM 342
#define TYPECAST 343
#define DOT_DOT 344
#define COLON_EQUALS 345
#define ABORT_P 346
#define ABSOLUTE_P 347
#define ACCESS 348
#define ACTION 349
#define ADD_P 350
#define ADMIN 351
#define AFTER 352
#define AGGREGATE 353
#define ALL 354
#define ALSO 355
#define ALTER 356
#define ALWAYS 357
#define ANALYSE 358
#define ANALYZE 359
#define AND 360
#define ANY 361
#define ARRAY 362
#define AS 363
#define ASC 364
#define ASSERTION 365
#define ASSIGNMENT 366
#define ASYMMETRIC 367
#define AT 368
#define AUTHORIZATION 369
#define BACKWARD 370
#define BEFORE 371
#define BEGIN_P 372
#define BETWEEN 373
#define BIGINT 374
#define BINARY 375
#define BIT 376
#define BOOLEAN_P 377
#define BOTH 378
#define BY 379
#define CACHE 380
#define CALLED 381
#define CASCADE 382
#define CASCADED 383
#define CASE 384
#define CAST 385
#define CATALOG_P 386
#define CHAIN 387
#define CHAR_P 388
#define CHARACTER 389
#define CHARACTERISTICS 390
#define CHECK 391
#define CHECKPOINT 392
#define CLASS 393
#define CLOSE 394
#define CLUSTER 395
#define COALESCE 396
#define COLLATE 397
#define COLUMN 398
#define COMMENT 399
#define COMMENTS 400
#define COMMIT 401
#define COMMITTED 402
#define CONCURRENTLY 403
#define CONFIGURATION 404
#define CONNECTION 405
#define CONSTRAINT 406
#define CONSTRAINTS 407
#define CONTENT_P 408
#define CONTINUE_P 409
#define CONVERSION_P 410
#define COPY 411
#define COST 412
#define CREATE 413
#define CREATEDB 414
#define CREATEROLE 415
#define CREATEUSER 416
#define CROSS 417
#define CSV 418
#define CURRENT_P 419
#define CURRENT_CATALOG 420
#define CURRENT_DATE 421
#define CURRENT_ROLE 422
#define CURRENT_SCHEMA 423
#define CURRENT_TIME 424
#define CURRENT_TIMESTAMP 425
#define CURRENT_USER 426
#define CURSOR 427
#define CYCLE 428
#define DATA_P 429
#define DATABASE 430
#define DAY_P 431
#define DEALLOCATE 432
#define DEC 433
#define DECIMAL_P 434
#define DECLARE 435
#define DEFAULT 436
#define DEFAULTS 437
#define DEFERRABLE 438
#define DEFERRED 439
#define DEFINER 440
#define DELETE_P 441
#define DELIMITER 442
#define DELIMITERS 443
#define DESC 444
#define DICTIONARY 445
#define DISABLE_P 446
#define DISCARD 447
#define DISTINCT 448
#define DO 449
#define DOCUMENT_P 450
#define DOMAIN_P 451
#define DOUBLE_P 452
#define DROP 453
#define EACH 454
#define ELSE 455
#define ENABLE_P 456
#define ENCODING 457
#define ENCRYPTED 458
#define END_P 459
#define ENUM_P 460
#define ESCAPE 461
#define EXCEPT 462
#define EXCLUDE 463
#define EXCLUDING 464
#define EXCLUSIVE 465
#define EXECUTE 466
#define EXISTS 467
#define EXPLAIN 468
#define EXTERNAL 469
#define EXTRACT 470
#define FALSE_P 471
#define FAMILY 472
#define FETCH 473
#define FIRST_P 474
#define FLOAT_P 475
#define FOLLOWING 476
#define FOR 477
#define FORCE 478
#define FOREIGN 479
#define FORWARD 480
#define FREEZE 481
#define FROM 482
#define FULL 483
#define FUNCTION 484
#define FUNCTIONS 485
#define GLOBAL 486
#define GRANT 487
#define GRANTED 488
#define GREATEST 489
#define GROUP_P 490
#define HANDLER 491
#define HAVING 492
#define HEADER_P 493
#define HOLD 494
#define HOUR_P 495
#define IDENTITY_P 496
#define IF_P 497
#define ILIKE 498
#define IMMEDIATE 499
#define IMMUTABLE 500
#define IMPLICIT_P 501
#define IN_P 502
#define INCLUDING 503
#define INCREMENT 504
#define INDEX 505
#define INDEXES 506
#define INHERIT 507
#define INHERITS 508
#define INITIALLY 509
#define INLINE_P 510
#define INNER_P 511
#define INOUT 512
#define INPUT_P 513
#define INSENSITIVE 514
#define INSERT 515
#define INSTEAD 516
#define INT_P 517
#define INTEGER 518
#define INTERSECT 519
#define INTERVAL 520
#define INTO 521
#define INVOKER 522
#define IS 523
#define ISNULL 524
#define ISOLATION 525
#define JOIN 526
#define KEY 527
#define LANGUAGE 528
#define LARGE_P 529
#define LAST_P 530
#define LC_COLLATE_P 531
#define LC_CTYPE_P 532
#define LEADING 533
#define LEAST 534
#define LEFT 535
#define LEVEL 536
#define LIKE 537
#define LIMIT 538
#define LISTEN 539
#define LOAD 540
#define LOCAL 541
#define LOCALTIME 542
#define LOCALTIMESTAMP 543
#define LOCATION 544
#define LOCK_P 545
#define LOGIN_P 546
#define MAPPING 547
#define MATCH 548
#define MAXVALUE 549
#define MINUTE_P 550
#define MINVALUE 551
#define MODE 552
#define MONTH_P 553
#define MOVE 554
#define NAME_P 555
#define NAMES 556
#define NATIONAL 557
#define NATURAL 558
#define NCHAR 559
#define NEXT 560
#define NO 561
#define NOCREATEDB 562
#define NOCREATEROLE 563
#define NOCREATEUSER 564
#define NOINHERIT 565
#define NOLOGIN_P 566
#define NONE 567
#define NOSUPERUSER 568
#define NOT 569
#define NOTHING 570
#define NOTIFY 571
#define NOTNULL 572
#define NOWAIT 573
#define NULL_P 574
#define NULLIF 575
#define NULLS_P 576
#define NUMERIC 577
#define OBJECT_P 578
#define OF 579
#define OFF 580
#define OFFSET 581
#define OIDS 582
#define ON 583
#define ONLY 584
#define OPERATOR 585
#define OPTION 586
#define OPTIONS 587
#define OR 588
#define ORDER 589
#define OUT_P 590
#define OUTER_P 591
#define OVER 592
#define OVERLAPS 593
#define OVERLAY 594
#define OWNED 595
#define OWNER 596
#define PARSER 597
#define PARTIAL 598
#define PARTITION 599
#define PASSWORD 600
#define PLACING 601
#define PLANS 602
#define POSITION 603
#define PRECEDING 604
#define PRECISION 605
#define PRESERVE 606
#define PREPARE 607
#define PREPARED 608
#define PRIMARY 609
#define PRIOR 610
#define PRIVILEGES 611
#define PROCEDURAL 612
#define PROCEDURE 613
#define QUOTE 614
#define RANGE 615
#define READ 616
#define REAL 617
#define REASSIGN 618
#define RECHECK 619
#define RECURSIVE 620
#define REFERENCES 621
#define REINDEX 622
#define RELATIVE_P 623
#define RELEASE 624
#define RENAME 625
#define REPEATABLE 626
#define REPLACE 627
#define REPLICA 628
#define RESET 629
#define RESTART 630
#define RESTRICT 631
#define RETURNING 632
#define RETURNS 633
#define REVOKE 634
#define RIGHT 635
#define ROLE 636
#define ROLLBACK 637
#define ROW 638
#define ROWS 639
#define RULE 640
#define SAVEPOINT 641
#define SCHEMA 642
#define SCROLL 643
#define SEARCH 644
#define SECOND_P 645
#define SECURITY 646
#define SELECT 647
#define SEQUENCE 648
#define SEQUENCES 649
#define SERIALIZABLE 650
#define SERVER 651
#define SESSION 652
#define SESSION_USER 653
#define SET 654
#define SETOF 655
#define SHARE 656
#define SHOW 657
#define SIMILAR 658
#define SIMPLE 659
#define SMALLINT 660
#define SOME 661
#define STABLE 662
#define STANDALONE_P 663
#define START 664
#define STATEMENT 665
#define STATISTICS 666
#define STDIN 667
#define STDOUT 668
#define STORAGE 669
#define STRICT_P 670
#define STRIP_P 671
#define SUBSTRING 672
#define SUPERUSER_P 673
#define SYMMETRIC 674
#define SYSID 675
#define SYSTEM_P 676
#define TABLE 677
#define TABLES 678
#define TABLESPACE 679
#define TEMP 680
#define TEMPLATE 681
#define TEMPORARY 682
#define TEXT_P 683
#define THEN 684
#define TIME 685
#define TIMESTAMP 686
#define TO 687
#define TRAILING 688
#define TRANSACTION 689
#define TREAT 690
#define TRIGGER 691
#define TRIM 692
#define TRUE_P 693
#define TRUNCATE 694
#define TRUSTED 695
#define TYPE_P 696
#define UNBOUNDED 697
#define UNCOMMITTED 698
#define UNENCRYPTED 699
#define UNION 700
#define UNIQUE 701
#define UNKNOWN 702
#define UNLISTEN 703
#define UNTIL 704
#define UPDATE 705
#define USER 706
#define USING 707
#define VACUUM 708
#define VALID 709
#define VALIDATOR 710
#define VALUE_P 711
#define VALUES 712
#define VARCHAR 713
#define VARIADIC 714
#define VARYING 715
#define VERBOSE 716
#define VERSION_P 717
#define VIEW 718
#define VOLATILE 719
#define WHEN 720
#define WHERE 721
#define WHITESPACE_P 722
#define WINDOW 723
#define WITH 724
#define WITHOUT 725
#define WORK 726
#define WRAPPER 727
#define WRITE 728
#define XML_P 729
#define XMLATTRIBUTES 730
#define XMLCONCAT 731
#define XMLELEMENT 732
#define XMLFOREST 733
#define XMLPARSE 734
#define XMLPI 735
#define XMLROOT 736
#define XMLSERIALIZE 737
#define YEAR_P 738
#define YES_P 739
#define ZONE 740
#define NULLS_FIRST 741
#define NULLS_LAST 742
#define WITH_TIME 743
#define POSTFIXOP 744
#define UMINUS 745




/* Copy the first part of user declarations.  */
#line 5 "preproc.y"

#include "postgres_fe.h"

#include "extern.h"
#include "ecpg_config.h"
#include <unistd.h>

/* Location tracking support --- simpler than bison's default */
#define YYLLOC_DEFAULT(Current, Rhs, N) \
	do { \
                if (N) \
			(Current) = (Rhs)[1]; \
		else \
		        (Current) = (Rhs)[0]; \
	} while (0)

/*
 * The %name-prefix option below will make bison call base_yylex, but we
 * really want it to call filtered_base_yylex (see parser.c).
 */
#define base_yylex filtered_base_yylex

/*
 * This is only here so the string gets into the POT.  Bison uses it
 * internally.
 */
#define bison_gettext_dummy gettext_noop("syntax error")

/*
 * Variables containing simple states.
 */
int struct_level = 0;
int braces_open; /* brace level counter */
char *current_function;
int ecpg_internal_var = 0;
char	*connection = NULL;
char	*input_filename = NULL;

static int	FoundInto = 0;
static int	initializer = 0;
static int	pacounter = 1;
static char     pacounter_buffer[sizeof(int) * CHAR_BIT * 10 / 3]; /* a rough guess at the size we need */
static struct this_type actual_type[STRUCT_DEPTH];
static char *actual_startline[STRUCT_DEPTH];
static int 	varchar_counter = 1;

/* temporarily store struct members while creating the data structure */
struct ECPGstruct_member *struct_member_list[STRUCT_DEPTH] = { NULL };

/* also store struct type so we can do a sizeof() later */
static char *ECPGstruct_sizeof = NULL;

/* for forward declarations we have to store some data as well */
static char *forward_name = NULL;

struct ECPGtype ecpg_no_indicator = {ECPGt_NO_INDICATOR, NULL, NULL, NULL, {NULL}, 0};
struct variable no_indicator = {"no_indicator", &ecpg_no_indicator, 0, NULL};

struct ECPGtype ecpg_query = {ECPGt_char_variable, NULL, NULL, NULL, {NULL}, 0};

/*
 * Handle parsing errors and warnings
 */
void
mmerror(int error_code, enum errortype type, const char *error, ...)
{
	va_list ap;

	/* internationalize the error message string */
	error = _(error);

	fprintf(stderr, "%s:%d: ", input_filename, yylineno);

	switch(type)
	{
		case ET_WARNING:
			fprintf(stderr, _("WARNING: "));
			break;
		case ET_ERROR:
		case ET_FATAL:
			fprintf(stderr, _("ERROR: "));
			break;
	}

	va_start(ap, error);
	vfprintf(stderr, error, ap);
	va_end(ap);

	fprintf(stderr, "\n");

	switch(type)
	{
		case ET_WARNING:
			break;
		case ET_ERROR:
			ret_value = error_code;
			break;
		case ET_FATAL:
			if (yyin)
				fclose(yyin);
			if (yyout)
				fclose(yyout);
			
			if (strcmp(output_filename, "-") != 0 && unlink(output_filename) != 0)
			        fprintf(stderr, _("could not remove output file \"%s\"\n"), output_filename);
			exit(error_code);
	}
}

/*
 * string concatenation
 */

static char *
cat2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 2);

	strcpy(res_str, str1);
	if (strlen(str1) != 0 && strlen(str2) != 0)
		strcat(res_str, " ");
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
cat_str(int count, ...)
{
	va_list		args;
	int			i;
	char		*res_str;

	va_start(args, count);

	res_str = va_arg(args, char *);

	/* now add all other strings */
	for (i = 1; i < count; i++)
		res_str = cat2_str(res_str, va_arg(args, char *));

	va_end(args);

	return(res_str);
}

char *
make_str(const char *str)
{
	char * res_str = (char *)mm_alloc(strlen(str) + 1);

	strcpy(res_str, str);
	return res_str;
}

static char *
make2_str(char *str1, char *str2)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	free(str1);
	free(str2);
	return(res_str);
}

static char *
make3_str(char *str1, char *str2, char *str3)
{
	char * res_str	= (char *)mm_alloc(strlen(str1) + strlen(str2) +strlen(str3) + 1);

	strcpy(res_str, str1);
	strcat(res_str, str2);
	strcat(res_str, str3);
	free(str1);
	free(str2);
	free(str3);
	return(res_str);
}

/* and the rest */
static char *
make_name(void)
{
	return mm_strdup(yytext);
}

static char *
create_questionmarks(char *name, bool array)
{
	struct variable *p = find_variable(name);
	int count;
	char *result = EMPTY;

	/* In case we have a struct, we have to print as many "?" as there are attributes in the struct
	 * An array is only allowed together with an element argument
	 * This is essantially only used for inserts, but using a struct as input parameter is an error anywhere else
	 * so we don't have to worry here. */

	if (p->type->type == ECPGt_struct || (array && p->type->type == ECPGt_array && p->type->u.element->type == ECPGt_struct))
	{
		struct ECPGstruct_member *m;

		if (p->type->type == ECPGt_struct)
			m = p->type->u.members;
		else
			m = p->type->u.element->u.members;

		for (count = 0; m != NULL; m=m->next, count++);
	}
	else
		count = 1;

	for (; count > 0; count --)
	{
		sprintf(pacounter_buffer, "$%d", pacounter++);
		result = cat_str(3, result, mm_strdup(pacounter_buffer), make_str(" , "));
	}

	/* removed the trailing " ," */

	result[strlen(result)-3] = '\0';
	return(result);
}

static char *
adjust_outofscope_cursor_vars(struct cursor *cur)
{
	/* Informix accepts DECLARE with variables that are out of scope when OPEN is called.
	 * For instance you can DECLARE a cursor in one function, and OPEN/FETCH/CLOSE
	 * it in other functions. This is very useful for e.g. event-driver programming,
	 * but may also lead to dangerous programming. The limitation when this is allowed
	 * and doesn's cause problems have to be documented, like the allocated variables
	 * must not be realloc()'ed.
	 *
	 * We have to change the variables to our own struct and just store the pointer
	 * instead of the variable. Do it only for local variables, not for globals.
	 */

	char *result = make_str("");
	int insert;

	for (insert = 1; insert >= 0; insert--)
	{
		struct arguments *list;
		struct arguments *ptr;
		struct arguments *newlist = NULL;
		struct variable *newvar, *newind;

		list = (insert ? cur->argsinsert : cur->argsresult);

		for (ptr = list; ptr != NULL; ptr = ptr->next)
		{
			char temp[20];
			char *original_var;
			bool skip_set_var = false;

			/* change variable name to "ECPGget_var(<counter>)" */
			original_var = ptr->variable->name;
			sprintf(temp, "%d))", ecpg_internal_var);

			/* Don't emit ECPGset_var() calls for global variables */
			if (ptr->variable->brace_level == 0)
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type == ECPGt_char_variable) && (!strncmp(ptr->variable->name, "ECPGprepared_statement", strlen("ECPGprepared_statement"))))
			{
				newvar = ptr->variable;
				skip_set_var = true;
			}
			else if ((ptr->variable->type->type != ECPGt_varchar && ptr->variable->type->type != ECPGt_char && ptr->variable->type->type != ECPGt_unsigned_char && ptr->variable->type->type != ECPGt_string) && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->u.element->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, make_str("1"), ptr->variable->type->u.element->counter), ptr->variable->type->size), 0);
				sprintf(temp, "%d, (", ecpg_internal_var++);
			}
			else if ((ptr->variable->type->type == ECPGt_varchar || ptr->variable->type->type == ECPGt_char || ptr->variable->type->type == ECPGt_unsigned_char || ptr->variable->type->type == ECPGt_string) && atoi(ptr->variable->type->size) > 1)
			{
				newvar = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->counter), 0);
				if (ptr->variable->type->type == ECPGt_varchar)
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				else
					sprintf(temp, "%d, (", ecpg_internal_var++);
			}
			else if (ptr->variable->type->type == ECPGt_struct || ptr->variable->type->type == ECPGt_union)
			{
				sprintf(temp, "%d)))", ecpg_internal_var);
				newvar = new_variable(cat_str(4, make_str("(*("), mm_strdup(ptr->variable->type->type_name), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->variable->type->u.members, ptr->variable->type->type, ptr->variable->type->type_name, ptr->variable->type->struct_sizeof), 0);
				sprintf(temp, "%d, &(", ecpg_internal_var++);
			}
			else if (ptr->variable->type->type == ECPGt_array)
			{
				if (ptr->variable->type->u.element->type == ECPGt_struct || ptr->variable->type->u.element->type == ECPGt_union)
				{
					sprintf(temp, "%d)))", ecpg_internal_var);
					newvar = new_variable(cat_str(4, make_str("(*("), mm_strdup(ptr->variable->type->u.element->type_name), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->variable->type->u.element->u.members, ptr->variable->type->u.element->type, ptr->variable->type->u.element->type_name, ptr->variable->type->u.element->struct_sizeof), 0);
					sprintf(temp, "%d, (", ecpg_internal_var++);
				}
				else
				{
					newvar = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->variable->type->u.element->type, ptr->variable->type->u.element->size, ptr->variable->type->u.element->counter), ptr->variable->type->size), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}
			}
			else
			{
				newvar = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->variable->type->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->variable->type->type, ptr->variable->type->size, ptr->variable->type->counter), 0);
				sprintf(temp, "%d, &(", ecpg_internal_var++);
			}

			/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
			if (!skip_set_var)
				result = cat_str(5, result, make_str("ECPGset_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));

			/* now the indicator if there is one and it's not a global variable */
			if ((ptr->indicator->type->type == ECPGt_NO_INDICATOR) || (ptr->indicator->brace_level == 0))
			{
				newind = ptr->indicator;
			}
			else
			{
				/* change variable name to "ECPGget_var(<counter>)" */
				original_var = ptr->indicator->name;
				sprintf(temp, "%d))", ecpg_internal_var);

				if (ptr->indicator->type->type == ECPGt_struct || ptr->indicator->type->type == ECPGt_union)
				{
					sprintf(temp, "%d)))", ecpg_internal_var);
					newind = new_variable(cat_str(4, make_str("(*("), mm_strdup(ptr->indicator->type->type_name), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->indicator->type->u.members, ptr->indicator->type->type, ptr->indicator->type->type_name, ptr->indicator->type->struct_sizeof), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}
				else if (ptr->indicator->type->type == ECPGt_array)
				{
					if (ptr->indicator->type->u.element->type == ECPGt_struct || ptr->indicator->type->u.element->type == ECPGt_union)
					{
						sprintf(temp, "%d)))", ecpg_internal_var);
						newind = new_variable(cat_str(4, make_str("(*("), mm_strdup(ptr->indicator->type->u.element->type_name), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_struct_type(ptr->indicator->type->u.element->u.members, ptr->indicator->type->u.element->type, ptr->indicator->type->u.element->type_name, ptr->indicator->type->u.element->struct_sizeof), 0);
						sprintf(temp, "%d, (", ecpg_internal_var++);
					}
					else
					{
						newind = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->indicator->type->u.element->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_array_type(ECPGmake_simple_type(ptr->indicator->type->u.element->type, ptr->indicator->type->u.element->size, ptr->indicator->type->u.element->counter), ptr->indicator->type->size), 0);
						sprintf(temp, "%d, &(", ecpg_internal_var++);
					}
				}
				else if (atoi(ptr->indicator->type->size) > 1)
				{
					newind = new_variable(cat_str(4, make_str("("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->counter), 0);
					sprintf(temp, "%d, (", ecpg_internal_var++);
				}
				else
				{
					newind = new_variable(cat_str(4, make_str("*("), mm_strdup(ecpg_type_name(ptr->indicator->type->type)), make_str(" *)(ECPGget_var("), mm_strdup(temp)), ECPGmake_simple_type(ptr->indicator->type->type, ptr->indicator->type->size, ptr->variable->type->counter), 0);
					sprintf(temp, "%d, &(", ecpg_internal_var++);
				}

				/* create call to "ECPGset_var(<counter>, <pointer>. <line number>)" */
				result = cat_str(5, result, make_str("ECPGset_var("), mm_strdup(temp), mm_strdup(original_var), make_str("), __LINE__);\n"));
			}

			add_variable_to_tail(&newlist, newvar, newind);
		}

		if (insert)
			cur->argsinsert_oos = newlist;
		else
			cur->argsresult_oos = newlist;
	}

	return result;
}

/* This tests whether the cursor was declared and opened in the same function. */
#define SAMEFUNC(cur)	\
	((cur->function == NULL) ||		\
	 (cur->function != NULL && !strcmp(cur->function, current_function)))

static struct cursor *
add_additional_variables(char *name, bool insert)
{
	struct cursor *ptr;
	struct arguments *p;

	for (ptr = cur; ptr != NULL; ptr=ptr->next)
	{
		if (strcmp(ptr->name, name) == 0)
			break;
	}

	if (ptr == NULL)
	{
		mmerror(PARSE_ERROR, ET_ERROR, "cursor \"%s\" does not exist", name);
		return NULL;
	}

	if (insert)
	{
		/* add all those input variables that were given earlier
		 * note that we have to append here but have to keep the existing order */
		for (p = (SAMEFUNC(ptr) ? ptr->argsinsert : ptr->argsinsert_oos); p; p = p->next)
			add_variable_to_tail(&argsinsert, p->variable, p->indicator);
	}

	/* add all those output variables that were given earlier */
	for (p = (SAMEFUNC(ptr) ? ptr->argsresult : ptr->argsresult_oos); p; p = p->next)
		add_variable_to_tail(&argsresult, p->variable, p->indicator);

	return ptr;
}

static void
add_typedef(char *name, char * dimension, char * length, enum ECPGttype type_enum, char *type_dimension, char *type_index, int initializer, int array)
{
	/* add entry to list */
	struct typedefs *ptr, *this;

	if ((type_enum == ECPGt_struct ||
	     type_enum == ECPGt_union) &&
	    initializer == 1)
		mmerror(PARSE_ERROR, ET_ERROR, "initializer not allowed in type definition");
	else if (INFORMIX_MODE && strcmp(name, "string") == 0)
		mmerror(PARSE_ERROR, ET_ERROR, "type name \"string\" is reserved in Informix mode");
	else
	{
		for (ptr = types; ptr != NULL; ptr = ptr->next)
		{
			if (strcmp(name, ptr->name) == 0)
				/* re-definition is a bug */
				mmerror(PARSE_ERROR, ET_ERROR, "type \"%s\" is already defined", name);
		}
		adjust_array(type_enum, &dimension, &length, type_dimension, type_index, array, true);

		this = (struct typedefs *) mm_alloc(sizeof(struct typedefs));

		/* initial definition */
		this->next = types;
		this->name = name;
		this->brace_level = braces_open;
		this->type = (struct this_type *) mm_alloc(sizeof(struct this_type));
		this->type->type_enum = type_enum;
		this->type->type_str = mm_strdup(name);
		this->type->type_dimension = dimension; /* dimension of array */
		this->type->type_index = length;	/* length of string */
		this->type->type_sizeof = ECPGstruct_sizeof;
		this->struct_member_list = (type_enum == ECPGt_struct || type_enum == ECPGt_union) ?
		ECPGstruct_member_dup(struct_member_list[struct_level]) : NULL;

		if (type_enum != ECPGt_varchar &&
			type_enum != ECPGt_char &&
			type_enum != ECPGt_unsigned_char &&
			type_enum != ECPGt_string &&
			atoi(this->type->type_index) >= 0)
			mmerror(PARSE_ERROR, ET_ERROR, "multidimensional arrays for simple data types are not supported");

		types = this;
	}
}


/* Enabling traces.  */
#ifndef YYDEBUG
# define YYDEBUG 0
#endif

/* Enabling verbose error messages.  */
#ifdef YYERROR_VERBOSE
# undef YYERROR_VERBOSE
# define YYERROR_VERBOSE 1
#else
# define YYERROR_VERBOSE 0
#endif

#if ! defined (YYSTYPE) && ! defined (YYSTYPE_IS_DECLARED)
#line 471 "preproc.y"
typedef union YYSTYPE {
	double	dval;
	char	*str;
	int     ival;
	struct	when		action;
	struct	index		index;
	int		tagname;
	struct	this_type	type;
	enum	ECPGttype	type_enum;
	enum	ECPGdtype	dtype_enum;
	struct	fetch_desc	descriptor;
	struct  su_symbol	struct_union;
	struct	prep		prep;
} YYSTYPE;
/* Line 186 of yacc.c.  */
#line 1541 "preproc.c"
# define yystype YYSTYPE /* obsolescent; will be withdrawn */
# define YYSTYPE_IS_DECLARED 1
# define YYSTYPE_IS_TRIVIAL 1
#endif

#if ! defined (YYLTYPE) && ! defined (YYLTYPE_IS_DECLARED)
typedef struct YYLTYPE
{
  int first_line;
  int first_column;
  int last_line;
  int last_column;
} YYLTYPE;
# define yyltype YYLTYPE /* obsolescent; will be withdrawn */
# define YYLTYPE_IS_DECLARED 1
# define YYLTYPE_IS_TRIVIAL 1
#endif


/* Copy the second part of user declarations.  */


/* Line 214 of yacc.c.  */
#line 1565 "preproc.c"

#if ! defined (yyoverflow) || YYERROR_VERBOSE

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# if YYSTACK_USE_ALLOCA
#  define YYSTACK_ALLOC alloca
# else
#  ifndef YYSTACK_USE_ALLOCA
#   if defined (alloca) || defined (_ALLOCA_H)
#    define YYSTACK_ALLOC alloca
#   else
#    ifdef __GNUC__
#     define YYSTACK_ALLOC __builtin_alloca
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's `empty if-body' warning. */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
# else
#  if defined (__STDC__) || defined (__cplusplus)
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   define YYSIZE_T size_t
#  endif
#  define YYSTACK_ALLOC malloc
#  define YYSTACK_FREE free
# endif
#endif /* ! defined (yyoverflow) || YYERROR_VERBOSE */


#if (! defined (yyoverflow) \
     && (! defined (__cplusplus) \
	 || (YYLTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  short yyss;
  YYSTYPE yyvs;
    YYLTYPE yyls;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (sizeof (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (sizeof (short) + sizeof (YYSTYPE) + sizeof (YYLTYPE))	\
      + 2 * YYSTACK_GAP_MAXIMUM)

/* Copy COUNT objects from FROM to TO.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if 1 < __GNUC__
#   define YYCOPY(To, From, Count) \
      __builtin_memcpy (To, From, (Count) * sizeof (*(From)))
#  else
#   define YYCOPY(To, From, Count)		\
      do					\
	{					\
	  register YYSIZE_T yyi;		\
	  for (yyi = 0; yyi < (Count); yyi++)	\
	    (To)[yyi] = (From)[yyi];		\
	}					\
      while (0)
#  endif
# endif

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack)					\
    do									\
      {									\
	YYSIZE_T yynewbytes;						\
	YYCOPY (&yyptr->Stack, Stack, yysize);				\
	Stack = &yyptr->Stack;						\
	yynewbytes = yystacksize * sizeof (*Stack) + YYSTACK_GAP_MAXIMUM; \
	yyptr += yynewbytes / sizeof (*yyptr);				\
      }									\
    while (0)

#endif

#if defined (__STDC__) || defined (__cplusplus)
   typedef signed char yysigned_char;
#else
   typedef short yysigned_char;
#endif

/* YYFINAL -- State number of the termination state. */
#define YYFINAL  3
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   94130

/* YYNTOKENS -- Number of terminals. */
#define YYNTOKENS  510
/* YYNNTS -- Number of nonterminals. */
#define YYNNTS  657
/* YYNRULES -- Number of rules. */
#define YYNRULES  2565
/* YYNRULES -- Number of states. */
#define YYNSTATES  4493

/* YYTRANSLATE(YYLEX) -- Bison symbol number corresponding to YYLEX.  */
#define YYUNDEFTOK  2
#define YYMAXUTOK   745

#define YYTRANSLATE(YYX) 						\
  ((unsigned int) (YYX) <= YYMAXUTOK ? yytranslate[YYX] : YYUNDEFTOK)

/* YYTRANSLATE[YYLEX] -- Bison symbol number corresponding to YYLEX.  */
static const unsigned short yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,   497,     2,     2,
     502,   503,   495,   493,   505,   494,   504,   496,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,   507,   506,
     490,   489,   491,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,   500,     2,   501,   498,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,   508,     2,   509,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    48,    49,    50,    51,    52,    53,    54,
      55,    56,    57,    58,    59,    60,    61,    62,    63,    64,
      65,    66,    67,    68,    69,    70,    71,    72,    73,    74,
      75,    76,    77,    78,    79,    80,    81,    82,    83,    84,
      85,    86,    87,    88,    89,    90,    91,    92,    93,    94,
      95,    96,    97,    98,    99,   100,   101,   102,   103,   104,
     105,   106,   107,   108,   109,   110,   111,   112,   113,   114,
     115,   116,   117,   118,   119,   120,   121,   122,   123,   124,
     125,   126,   127,   128,   129,   130,   131,   132,   133,   134,
     135,   136,   137,   138,   139,   140,   141,   142,   143,   144,
     145,   146,   147,   148,   149,   150,   151,   152,   153,   154,
     155,   156,   157,   158,   159,   160,   161,   162,   163,   164,
     165,   166,   167,   168,   169,   170,   171,   172,   173,   174,
     175,   176,   177,   178,   179,   180,   181,   182,   183,   184,
     185,   186,   187,   188,   189,   190,   191,   192,   193,   194,
     195,   196,   197,   198,   199,   200,   201,   202,   203,   204,
     205,   206,   207,   208,   209,   210,   211,   212,   213,   214,
     215,   216,   217,   218,   219,   220,   221,   222,   223,   224,
     225,   226,   227,   228,   229,   230,   231,   232,   233,   234,
     235,   236,   237,   238,   239,   240,   241,   242,   243,   244,
     245,   246,   247,   248,   249,   250,   251,   252,   253,   254,
     255,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   492,   499
};

#if YYDEBUG
/* YYPRHS[YYN] -- Index of the first RHS symbol of rule number YYN in
   YYRHS.  */
static const unsigned short yyprhs[] =
{
       0,     0,     3,     5,     7,     9,    11,    13,    15,    17,
      19,    21,    23,    25,    27,    29,    31,    33,    35,    37,
      39,    41,    43,    45,    47,    49,    51,    53,    55,    57,
      59,    61,    63,    65,    67,    69,    71,    73,    75,    77,
      79,    81,    83,    85,    87,    89,    91,    93,    95,    97,
      99,   101,   103,   105,   107,   109,   111,   113,   115,   117,
     119,   121,   123,   125,   127,   129,   131,   133,   135,   137,
     139,   141,   143,   145,   147,   149,   151,   153,   155,   157,
     159,   161,   163,   165,   167,   169,   171,   173,   175,   177,
     179,   181,   183,   185,   187,   189,   191,   193,   195,   197,
     199,   201,   203,   205,   207,   209,   211,   213,   215,   217,
     219,   221,   223,   225,   227,   229,   231,   233,   235,   237,
     239,   241,   243,   245,   247,   248,   254,   256,   257,   260,
     261,   264,   265,   268,   271,   275,   279,   281,   283,   285,
     287,   289,   291,   293,   295,   297,   299,   301,   303,   307,
     311,   314,   316,   319,   322,   325,   329,   333,   339,   345,
     346,   350,   356,   362,   367,   371,   377,   381,   387,   393,
     400,   402,   404,   408,   414,   421,   426,   428,   429,   432,
     433,   435,   437,   439,   441,   443,   445,   448,   452,   456,
     460,   464,   468,   472,   476,   480,   483,   489,   492,   495,
     498,   501,   505,   509,   513,   515,   519,   521,   525,   527,
     529,   531,   534,   537,   540,   542,   544,   546,   548,   550,
     552,   554,   558,   565,   567,   569,   571,   573,   575,   576,
     578,   580,   583,   587,   592,   596,   599,   602,   604,   608,
     613,   619,   624,   627,   632,   634,   636,   638,   640,   642,
     645,   648,   651,   654,   659,   664,   669,   674,   676,   680,
     683,   687,   692,   699,   706,   713,   719,   725,   732,   739,
     744,   752,   755,   762,   767,   771,   775,   779,   783,   787,
     792,   797,   801,   805,   809,   813,   817,   821,   826,   831,
     835,   838,   842,   846,   850,   853,   856,   860,   863,   865,
     867,   868,   871,   872,   876,   879,   880,   882,   886,   890,
     892,   898,   902,   905,   908,   919,   926,   928,   930,   932,
     934,   936,   938,   942,   945,   946,   948,   950,   954,   958,
     960,   962,   966,   970,   974,   978,   983,   985,   986,   989,
     990,   994,   995,   997,   998,  1000,  1004,  1007,  1009,  1011,
    1013,  1015,  1019,  1020,  1022,  1026,  1028,  1030,  1042,  1053,
    1055,  1057,  1060,  1063,  1066,  1069,  1070,  1072,  1073,  1077,
    1078,  1080,  1084,  1086,  1090,  1092,  1094,  1096,  1098,  1100,
    1104,  1109,  1112,  1113,  1117,  1119,  1121,  1124,  1126,  1130,
    1135,  1140,  1143,  1149,  1151,  1154,  1157,  1160,  1164,  1168,
    1172,  1173,  1175,  1177,  1179,  1181,  1183,  1185,  1189,  1191,
    1197,  1205,  1214,  1224,  1236,  1240,  1241,  1243,  1247,  1249,
    1252,  1255,  1258,  1259,  1261,  1265,  1269,  1276,  1281,  1282,
    1284,  1286,  1289,  1292,  1293,  1297,  1301,  1304,  1306,  1308,
    1311,  1314,  1319,  1320,  1323,  1326,  1329,  1330,  1334,  1339,
    1344,  1345,  1348,  1349,  1354,  1355,  1361,  1365,  1366,  1368,
    1372,  1374,  1377,  1381,  1382,  1388,  1393,  1395,  1396,  1398,
    1401,  1404,  1406,  1409,  1413,  1416,  1419,  1422,  1425,  1429,
    1433,  1435,  1439,  1441,  1442,  1444,  1447,  1449,  1451,  1455,
    1462,  1473,  1475,  1476,  1478,  1481,  1484,  1485,  1488,  1491,
    1493,  1494,  1500,  1508,  1510,  1511,  1518,  1521,  1522,  1526,
    1532,  1540,  1547,  1556,  1564,  1571,  1578,  1583,  1584,  1586,
    1590,  1595,  1597,  1601,  1603,  1606,  1609,  1612,  1615,  1617,
    1619,  1630,  1633,  1634,  1637,  1640,  1642,  1643,  1648,  1655,
    1661,  1666,  1671,  1680,  1682,  1684,  1686,  1694,  1704,  1713,
    1729,  1750,  1752,  1754,  1756,  1760,  1762,  1764,  1766,  1770,
    1772,  1776,  1777,  1779,  1780,  1782,  1784,  1789,  1790,  1792,
    1796,  1797,  1799,  1801,  1803,  1805,  1807,  1809,  1812,  1813,
    1815,  1818,  1820,  1823,  1824,  1827,  1829,  1832,  1835,  1842,
    1851,  1860,  1865,  1871,  1876,  1881,  1886,  1890,  1898,  1907,
    1914,  1921,  1928,  1935,  1939,  1941,  1945,  1949,  1951,  1953,
    1955,  1957,  1959,  1961,  1965,  1969,  1973,  1975,  1979,  1983,
    1985,  1986,  1988,  1992,  2006,  2008,  2012,  2017,  2023,  2028,
    2036,  2039,  2041,  2042,  2045,  2046,  2048,  2049,  2056,  2065,
    2074,  2076,  2080,  2086,  2092,  2100,  2110,  2118,  2128,  2134,
    2141,  2148,  2153,  2155,  2157,  2159,  2161,  2163,  2165,  2167,
    2169,  2173,  2177,  2181,  2185,  2187,  2191,  2193,  2196,  2199,
    2203,  2209,  2212,  2215,  2216,  2223,  2231,  2239,  2247,  2256,
    2265,  2272,  2281,  2291,  2301,  2309,  2320,  2328,  2337,  2346,
    2355,  2364,  2366,  2368,  2370,  2372,  2374,  2376,  2378,  2380,
    2382,  2384,  2386,  2388,  2390,  2392,  2395,  2398,  2402,  2407,
    2413,  2418,  2424,  2428,  2433,  2437,  2442,  2444,  2447,  2451,
    2455,  2459,  2463,  2468,  2473,  2477,  2481,  2486,  2491,  2496,
    2501,  2503,  2505,  2507,  2508,  2516,  2524,  2535,  2537,  2539,
    2542,  2547,  2553,  2555,  2559,  2562,  2565,  2568,  2571,  2573,
    2576,  2579,  2584,  2588,  2591,  2594,  2597,  2601,  2604,  2607,
    2613,  2619,  2625,  2627,  2631,  2633,  2636,  2640,  2641,  2643,
    2647,  2650,  2657,  2664,  2674,  2678,  2679,  2683,  2684,  2690,
    2693,  2694,  2698,  2702,  2706,  2714,  2722,  2733,  2735,  2737,
    2739,  2754,  2756,  2757,  2759,  2760,  2762,  2763,  2766,  2767,
    2769,  2773,  2778,  2783,  2790,  2792,  2795,  2796,  2798,  2800,
    2801,  2803,  2805,  2806,  2816,  2829,  2837,  2840,  2841,  2845,
    2848,  2850,  2854,  2858,  2861,  2863,  2867,  2871,  2875,  2878,
    2881,  2883,  2885,  2887,  2889,  2892,  2894,  2896,  2898,  2900,
    2905,  2911,  2913,  2917,  2921,  2923,  2926,  2931,  2937,  2939,
    2941,  2943,  2945,  2949,  2953,  2956,  2959,  2962,  2965,  2967,
    2970,  2973,  2975,  2977,  2979,  2983,  2986,  2987,  2990,  2992,
    2996,  3002,  3004,  3007,  3009,  3010,  3016,  3024,  3030,  3038,
    3044,  3052,  3056,  3062,  3068,  3074,  3076,  3080,  3083,  3085,
    3088,  3090,  3093,  3105,  3116,  3127,  3130,  3133,  3134,  3144,
    3147,  3148,  3153,  3158,  3163,  3165,  3167,  3169,  3170,  3178,
    3185,  3192,  3199,  3206,  3214,  3224,  3234,  3241,  3248,  3255,
    3262,  3269,  3278,  3287,  3294,  3301,  3308,  3314,  3320,  3329,
    3338,  3347,  3356,  3363,  3365,  3366,  3369,  3370,  3378,  3385,
    3392,  3399,  3406,  3413,  3420,  3428,  3435,  3442,  3449,  3456,
    3464,  3472,  3480,  3490,  3500,  3507,  3514,  3521,  3530,  3539,
    3548,  3555,  3569,  3571,  3573,  3577,  3581,  3583,  3585,  3587,
    3589,  3591,  3593,  3595,  3596,  3598,  3600,  3602,  3604,  3606,
    3608,  3609,  3616,  3625,  3629,  3632,  3633,  3636,  3639,  3642,
    3645,  3649,  3653,  3656,  3659,  3662,  3665,  3669,  3672,  3678,
    3683,  3687,  3691,  3695,  3697,  3699,  3700,  3704,  3707,  3710,
    3712,  3716,  3719,  3721,  3722,  3731,  3742,  3746,  3751,  3756,
    3757,  3760,  3766,  3769,  3770,  3774,  3778,  3782,  3786,  3790,
    3794,  3798,  3802,  3806,  3810,  3814,  3818,  3822,  3827,  3831,
    3835,  3837,  3838,  3844,  3851,  3856,  3859,  3860,  3865,  3869,
    3875,  3882,  3887,  3894,  3901,  3907,  3915,  3917,  3918,  3925,
    3937,  3949,  3961,  3975,  3985,  3997,  4008,  4013,  4016,  4022,
    4025,  4026,  4031,  4037,  4043,  4048,  4055,  4057,  4061,  4063,
    4065,  4067,  4069,  4072,  4077,  4079,  4081,  4083,  4084,  4086,
    4087,  4089,  4090,  4094,  4095,  4098,  4103,  4107,  4113,  4115,
    4117,  4119,  4121,  4123,  4125,  4127,  4129,  4133,  4136,  4138,
    4140,  4142,  4144,  4146,  4148,  4149,  4155,  4160,  4164,  4165,
    4167,  4169,  4171,  4173,  4178,  4187,  4191,  4192,  4198,  4200,
    4205,  4208,  4210,  4214,  4217,  4221,  4222,  4229,  4232,  4233,
    4239,  4243,  4244,  4247,  4250,  4253,  4257,  4259,  4263,  4265,
    4268,  4270,  4271,  4279,  4281,  4285,  4287,  4289,  4293,  4299,
    4302,  4304,  4308,  4316,  4318,  4320,  4321,  4325,  4328,  4331,
    4334,  4335,  4338,  4341,  4343,  4345,  4349,  4353,  4355,  4358,
    4363,  4368,  4371,  4375,  4381,  4387,  4389,  4391,  4401,  4403,
    4406,  4411,  4416,  4421,  4424,  4428,  4430,  4434,  4439,  4442,
    4444,  4445,  4449,  4453,  4458,  4463,  4468,  4473,  4476,  4478,
    4480,  4481,  4483,  4485,  4486,  4488,  4494,  4496,  4497,  4499,
    4500,  4504,  4506,  4510,  4515,  4519,  4522,  4525,  4527,  4529,
    4531,  4532,  4535,  4540,  4546,  4549,  4553,  4555,  4557,  4559,
    4561,  4565,  4566,  4568,  4570,  4572,  4574,  4576,  4580,  4581,
    4584,  4585,  4587,  4591,  4593,  4594,  4596,  4599,  4604,  4609,
    4612,  4613,  4616,  4620,  4623,  4624,  4626,  4630,  4632,  4635,
    4637,  4640,  4646,  4653,  4659,  4661,  4664,  4666,  4671,  4675,
    4680,  4686,  4691,  4697,  4702,  4708,  4711,  4716,  4718,  4721,
    4724,  4727,  4729,  4731,  4732,  4737,  4740,  4742,  4745,  4748,
    4753,  4755,  4759,  4761,  4764,  4768,  4770,  4773,  4774,  4777,
    4782,  4783,  4785,  4789,  4792,  4795,  4799,  4805,  4812,  4815,
    4819,  4823,  4828,  4829,  4831,  4833,  4835,  4837,  4839,  4842,
    4848,  4850,  4852,  4854,  4856,  4859,  4863,  4867,  4868,  4870,
    4872,  4874,  4876,  4878,  4881,  4884,  4887,  4890,  4893,  4895,
    4899,  4900,  4902,  4904,  4906,  4908,  4914,  4917,  4919,  4921,
    4923,  4925,  4931,  4934,  4937,  4940,  4942,  4946,  4950,  4953,
    4955,  4956,  4960,  4961,  4967,  4970,  4976,  4979,  4981,  4984,
    4988,  4989,  4991,  4993,  4995,  4997,  4999,  5001,  5005,  5009,
    5013,  5017,  5021,  5025,  5029,  5030,  5032,  5037,  5039,  5043,
    5049,  5052,  5055,  5059,  5063,  5067,  5071,  5075,  5079,  5083,
    5087,  5091,  5095,  5098,  5101,  5105,  5109,  5112,  5116,  5122,
    5127,  5134,  5138,  5144,  5149,  5156,  5161,  5168,  5174,  5182,
    5186,  5189,  5194,  5197,  5201,  5205,  5210,  5214,  5219,  5223,
    5228,  5234,  5241,  5248,  5256,  5263,  5271,  5278,  5286,  5290,
    5295,  5300,  5307,  5310,  5314,  5319,  5321,  5325,  5328,  5331,
    5335,  5339,  5343,  5347,  5351,  5355,  5359,  5363,  5367,  5371,
    5374,  5377,  5383,  5390,  5397,  5405,  5409,  5414,  5416,  5418,
    5421,  5426,  5428,  5430,  5432,  5435,  5438,  5441,  5443,  5448,
    5454,  5461,  5470,  5477,  5485,  5493,  5499,  5501,  5503,  5508,
    5510,  5515,  5517,  5522,  5524,  5529,  5531,  5533,  5535,  5537,
    5539,  5541,  5548,  5553,  5558,  5563,  5568,  5575,  5581,  5587,
    5593,  5598,  5605,  5610,  5615,  5620,  5625,  5631,  5639,  5647,
    5657,  5662,  5669,  5675,  5683,  5691,  5699,  5702,  5706,  5710,
    5714,  5719,  5720,  5725,  5727,  5731,  5735,  5737,  5739,  5741,
    5744,  5747,  5748,  5751,  5752,  5754,  5758,  5762,  5765,  5768,
    5769,  5776,  5778,  5779,  5783,  5784,  5787,  5790,  5791,  5793,
    5798,  5801,  5804,  5807,  5810,  5813,  5818,  5822,  5828,  5830,
    5832,  5834,  5836,  5838,  5840,  5842,  5844,  5846,  5848,  5850,
    5852,  5854,  5856,  5858,  5863,  5865,  5870,  5872,  5877,  5879,
    5882,  5884,  5887,  5889,  5893,  5895,  5899,  5901,  5905,  5907,
    5911,  5915,  5919,  5922,  5924,  5928,  5932,  5933,  5935,  5937,
    5939,  5941,  5943,  5945,  5947,  5949,  5954,  5958,  5961,  5965,
    5966,  5970,  5974,  5977,  5980,  5982,  5983,  5986,  5989,  5993,
    5996,  5998,  6000,  6004,  6010,  6012,  6015,  6020,  6023,  6024,
    6026,  6027,  6029,  6032,  6035,  6038,  6042,  6048,  6050,  6053,
    6054,  6057,  6059,  6060,  6062,  6064,  6066,  6070,  6074,  6076,
    6080,  6084,  6087,  6089,  6091,  6093,  6097,  6099,  6102,  6104,
    6108,  6110,  6112,  6114,  6116,  6118,  6120,  6122,  6125,  6127,
    6129,  6131,  6133,  6135,  6138,  6144,  6147,  6151,  6158,  6160,
    6162,  6164,  6166,  6168,  6170,  6172,  6174,  6176,  6179,  6182,
    6184,  6186,  6188,  6190,  6192,  6194,  6196,  6198,  6200,  6202,
    6204,  6206,  6208,  6210,  6212,  6214,  6216,  6218,  6220,  6222,
    6224,  6226,  6228,  6230,  6232,  6234,  6236,  6238,  6240,  6242,
    6244,  6246,  6248,  6250,  6252,  6254,  6256,  6258,  6260,  6262,
    6264,  6266,  6268,  6270,  6272,  6274,  6276,  6278,  6280,  6282,
    6284,  6286,  6288,  6290,  6292,  6294,  6296,  6298,  6300,  6302,
    6304,  6306,  6308,  6310,  6312,  6314,  6316,  6318,  6320,  6322,
    6324,  6326,  6328,  6330,  6332,  6334,  6336,  6338,  6340,  6342,
    6344,  6346,  6348,  6350,  6352,  6354,  6356,  6358,  6360,  6362,
    6364,  6366,  6368,  6370,  6372,  6374,  6376,  6378,  6380,  6382,
    6384,  6386,  6388,  6390,  6392,  6394,  6396,  6398,  6400,  6402,
    6404,  6406,  6408,  6410,  6412,  6414,  6416,  6418,  6420,  6422,
    6424,  6426,  6428,  6430,  6432,  6434,  6436,  6438,  6440,  6442,
    6444,  6446,  6448,  6450,  6452,  6454,  6456,  6458,  6460,  6462,
    6464,  6466,  6468,  6470,  6472,  6474,  6476,  6478,  6480,  6482,
    6484,  6486,  6488,  6490,  6492,  6494,  6496,  6498,  6500,  6502,
    6504,  6506,  6508,  6510,  6512,  6514,  6516,  6518,  6520,  6522,
    6524,  6526,  6528,  6530,  6532,  6534,  6536,  6538,  6540,  6542,
    6544,  6546,  6548,  6550,  6552,  6554,  6556,  6558,  6560,  6562,
    6564,  6566,  6568,  6570,  6572,  6574,  6576,  6578,  6580,  6582,
    6584,  6586,  6588,  6590,  6592,  6594,  6596,  6598,  6600,  6602,
    6604,  6606,  6608,  6610,  6612,  6614,  6616,  6618,  6620,  6622,
    6624,  6626,  6628,  6630,  6632,  6634,  6636,  6638,  6640,  6642,
    6644,  6646,  6648,  6650,  6652,  6654,  6656,  6658,  6660,  6662,
    6664,  6666,  6668,  6670,  6672,  6674,  6676,  6678,  6680,  6682,
    6684,  6686,  6688,  6690,  6692,  6694,  6696,  6698,  6700,  6702,
    6704,  6706,  6708,  6710,  6712,  6714,  6716,  6718,  6720,  6722,
    6724,  6726,  6728,  6730,  6732,  6734,  6736,  6738,  6740,  6742,
    6744,  6746,  6748,  6750,  6752,  6754,  6756,  6758,  6760,  6762,
    6764,  6766,  6768,  6770,  6772,  6774,  6776,  6778,  6780,  6782,
    6784,  6786,  6788,  6790,  6792,  6794,  6796,  6798,  6800,  6802,
    6804,  6806,  6808,  6810,  6812,  6814,  6816,  6818,  6820,  6822,
    6824,  6826,  6828,  6830,  6832,  6834,  6836,  6838,  6840,  6842,
    6844,  6846,  6848,  6850,  6852,  6854,  6856,  6858,  6860,  6862,
    6864,  6866,  6868,  6870,  6872,  6874,  6876,  6878,  6880,  6882,
    6884,  6886,  6888,  6890,  6892,  6894,  6896,  6898,  6900,  6902,
    6904,  6906,  6908,  6910,  6912,  6914,  6916,  6918,  6920,  6922,
    6924,  6926,  6928,  6930,  6932,  6934,  6936,  6938,  6940,  6942,
    6944,  6945,  6948,  6953,  6957,  6960,  6962,  6964,  6966,  6968,
    6970,  6971,  6980,  6983,  6989,  6993,  6996,  6999,  7003,  7011,
    7013,  7015,  7017,  7018,  7021,  7024,  7026,  7027,  7029,  7033,
    7035,  7038,  7039,  7042,  7043,  7046,  7047,  7049,  7053,  7058,
    7062,  7064,  7066,  7068,  7070,  7073,  7074,  7077,  7082,  7083,
    7086,  7089,  7092,  7094,  7096,  7104,  7108,  7110,  7112,  7114,
    7116,  7119,  7120,  7122,  7126,  7130,  7134,  7138,  7139,  7144,
    7150,  7156,  7157,  7159,  7161,  7163,  7166,  7169,  7171,  7174,
    7175,  7183,  7184,  7190,  7191,  7196,  7199,  7202,  7203,  7206,
    7208,  7210,  7212,  7214,  7216,  7218,  7220,  7222,  7224,  7226,
    7228,  7234,  7237,  7239,  7243,  7246,  7249,  7253,  7254,  7260,
    7262,  7263,  7269,  7272,  7275,  7277,  7279,  7281,  7284,  7287,
    7291,  7293,  7296,  7299,  7303,  7307,  7312,  7315,  7317,  7320,
    7322,  7324,  7327,  7330,  7334,  7336,  7338,  7340,  7342,  7343,
    7345,  7349,  7355,  7356,  7359,  7360,  7362,  7365,  7369,  7372,
    7374,  7376,  7378,  7379,  7381,  7383,  7385,  7387,  7389,  7392,
    7395,  7399,  7400,  7402,  7405,  7407,  7412,  7416,  7421,  7425,
    7428,  7430,  7434,  7436,  7438,  7440,  7442,  7445,  7448,  7450,
    7453,  7456,  7458,  7460,  7462,  7467,  7472,  7477,  7482,  7487,
    7489,  7490,  7494,  7498,  7503,  7505,  7509,  7513,  7518,  7520,
    7524,  7528,  7530,  7532,  7534,  7541,  7543,  7547,  7551,  7558,
    7560,  7564,  7568,  7570,  7572,  7575,  7578,  7580,  7582,  7584,
    7586,  7588,  7590,  7592,  7594,  7596,  7598,  7600,  7602,  7604,
    7606,  7608,  7610,  7615,  7620,  7622,  7624,  7629,  7634,  7638,
    7639,  7647,  7649,  7650,  7651,  7659,  7663,  7668,  7672,  7674,
    7676,  7678,  7681,  7685,  7691,  7694,  7700,  7703,  7705,  7707,
    7709,  7711,  7713,  7715,  7717,  7719,  7721,  7723,  7725,  7727,
    7729,  7731,  7733,  7735,  7737,  7739,  7741,  7743,  7745,  7747,
    7749,  7751,  7753,  7755,  7757,  7759,  7761,  7763,  7765,  7767,
    7769,  7771,  7773,  7775,  7777,  7779,  7781,  7783,  7785,  7787,
    7789,  7791,  7793,  7795,  7797,  7799,  7801,  7803,  7805,  7807,
    7809,  7811,  7813,  7815,  7817,  7819,  7821,  7823,  7825,  7827,
    7829,  7831,  7833,  7835,  7837,  7839,  7841,  7843,  7845,  7847,
    7849,  7851,  7853,  7855,  7857,  7859,  7861,  7863,  7865,  7867,
    7869,  7871,  7873,  7875,  7877,  7879,  7881,  7883,  7885,  7887,
    7889,  7891,  7893,  7895,  7897,  7899,  7903,  7905,  7906,  7908,
    7911,  7913,  7916,  7918,  7920,  7922,  7925,  7928,  7930,  7932,
    7934,  7936,  7938,  7940,  7942,  7944,  7946,  7948,  7950,  7952,
    7954,  7956,  7958,  7960,  7963,  7967,  7969,  7972,  7974,  7978,
    7980,  7984,  7986,  7988,  7990,  7992,  7994,  7996,  7998,  8000,
    8002,  8004,  8006,  8008,  8010,  8012,  8014,  8016,  8018,  8020,
    8022,  8024,  8026,  8028,  8030,  8032,  8034,  8036,  8038,  8040,
    8042,  8044,  8046,  8048,  8050,  8052,  8054,  8056,  8058,  8060,
    8062,  8064,  8066,  8068,  8070,  8072,  8074,  8076,  8078,  8080,
    8082,  8084,  8086,  8088,  8090,  8092,  8094,  8096,  8098,  8100,
    8102,  8104,  8106,  8109,  8113,  8116,  8120,  8122,  8126,  8130,
    8134,  8138,  8142,  8146,  8148,  8150,  8151,  8154,  8157,  8159,
    8161,  8164,  8166,  8168,  8170,  8171
};

/* YYRHS -- A `-1'-separated list of the rules' RHS. */
static const short yyrhs[] =
{
     511,     0,    -1,  1018,    -1,   811,    -1,   812,    -1,   730,
      -1,   817,    -1,   640,    -1,   654,    -1,   764,    -1,   528,
      -1,   785,    -1,   786,    -1,   620,    -1,   553,    -1,   522,
      -1,   520,    -1,   820,    -1,   819,    -1,   658,    -1,   524,
      -1,   523,    -1,   827,    -1,   551,    -1,   563,    -1,   822,
      -1,   708,    -1,   548,    -1,   564,    -1,  1020,    -1,   674,
      -1,   775,    -1,   821,    -1,   816,    -1,   638,    -1,   649,
      -1,   745,    -1,   527,    -1,   687,    -1,   693,    -1,   694,
      -1,   627,    -1,   531,    -1,   619,    -1,   579,    -1,   635,
      -1,   659,    -1,   513,    -1,   519,    -1,   655,    -1,   807,
      -1,  1161,    -1,   862,    -1,   676,    -1,   849,    -1,   552,
      -1,   772,    -1,   675,    -1,   777,    -1,   639,    -1,   653,
      -1,   530,    -1,   697,    -1,   698,    -1,   699,    -1,   633,
      -1,   794,    -1,   701,    -1,   637,    -1,   673,    -1,   525,
      -1,   526,    -1,   657,    -1,   815,    -1,   842,    -1,   833,
      -1,   711,    -1,   715,    -1,   726,    -1,   735,    -1,   844,
      -1,   797,    -1,   806,    -1,   851,    -1,   795,    -1,   839,
      -1,   700,    -1,   779,    -1,   768,    -1,   767,    -1,   769,
      -1,   782,    -1,   716,    -1,   727,    -1,   787,    -1,   866,
      -1,   799,    -1,   706,    -1,   798,    -1,   855,    -1,   824,
      -1,   545,    -1,   535,    -1,   547,    -1,   804,    -1,  1097,
      -1,  1023,    -1,  1040,    -1,  1098,    -1,  1080,    -1,  1095,
      -1,  1081,    -1,  1041,    -1,  1085,    -1,  1107,    -1,  1099,
      -1,  1086,    -1,  1115,    -1,  1117,    -1,  1110,    -1,  1102,
      -1,  1118,    -1,  1121,    -1,  1123,    -1,    -1,   158,   381,
    1012,   514,   515,    -1,   469,    -1,    -1,   515,   518,    -1,
      -1,   516,   517,    -1,    -1,   345,  1151,    -1,   345,   319,
      -1,   203,   345,  1151,    -1,   444,   345,  1151,    -1,   418,
      -1,   313,    -1,   252,    -1,   310,    -1,   159,    -1,   307,
      -1,   160,    -1,   308,    -1,   161,    -1,   309,    -1,   291,
      -1,   311,    -1,   150,   283,  1013,    -1,   454,   449,  1151,
      -1,   451,  1002,    -1,   517,    -1,   420,  1011,    -1,    96,
    1002,    -1,   381,  1002,    -1,   247,   381,  1002,    -1,   247,
     235,  1002,    -1,   158,   451,  1012,   514,   515,    -1,   101,
     381,  1012,   514,   516,    -1,    -1,   247,   175,  1004,    -1,
     101,   381,  1012,   521,   546,    -1,   101,   451,  1012,   514,
     516,    -1,   101,   451,  1012,   546,    -1,   198,   381,  1002,
      -1,   198,   381,   242,   212,  1002,    -1,   198,   451,  1002,
      -1,   198,   451,   242,   212,  1002,    -1,   158,   235,  1012,
     514,   515,    -1,   101,   235,  1012,   529,   451,  1002,    -1,
      95,    -1,   198,    -1,   198,   235,  1002,    -1,   198,   235,
     242,   212,  1002,    -1,   158,   387,   532,   114,  1012,   533,
      -1,   158,   387,  1131,   533,    -1,  1131,    -1,    -1,   533,
     534,    -1,    -1,   579,    -1,   735,    -1,   619,    -1,   659,
      -1,   715,    -1,   804,    -1,   399,   536,    -1,   399,   286,
     536,    -1,   399,   397,   536,    -1,   537,   432,   538,    -1,
     537,   489,   538,    -1,   537,   432,   181,    -1,   537,   489,
     181,    -1,   537,   227,   164,    -1,   430,   485,   542,    -1,
     434,   802,    -1,   397,   135,   108,   434,   802,    -1,   131,
    1151,    -1,   387,  1151,    -1,   301,   543,    -1,   381,   544,
      -1,   397,   114,   544,    -1,   397,   114,   181,    -1,   474,
     331,   950,    -1,  1130,    -1,   537,   504,  1131,    -1,   539,
      -1,   538,   505,   539,    -1,   541,    -1,   544,    -1,   625,
      -1,   361,   443,    -1,   361,   147,    -1,   371,   361,    -1,
     395,    -1,   438,    -1,   216,    -1,   328,    -1,   325,    -1,
    1151,    -1,  1153,    -1,   937,  1151,   939,    -1,   937,   502,
    1011,   503,  1151,   939,    -1,   625,    -1,   181,    -1,   286,
      -1,  1151,    -1,   181,    -1,    -1,  1131,    -1,  1151,    -1,
     374,   537,    -1,   374,   430,   485,    -1,   374,   434,   270,
     281,    -1,   374,   397,   114,    -1,   374,    99,    -1,   399,
     536,    -1,   545,    -1,   402,   537,  1164,    -1,   402,   430,
     485,  1164,    -1,   402,   434,   270,   281,  1164,    -1,   402,
     397,   114,  1164,    -1,   402,    99,    -1,   399,   152,   549,
     550,    -1,    99,    -1,  1000,    -1,   184,    -1,   244,    -1,
     137,    -1,   192,    99,    -1,   192,   425,    -1,   192,   427,
      -1,   192,   347,    -1,   101,   422,   909,   554,    -1,   101,
     250,  1001,   554,    -1,   101,   393,  1001,   554,    -1,   101,
     463,  1001,   554,    -1,   555,    -1,   554,   505,   555,    -1,
      95,   587,    -1,    95,   143,   587,    -1,   101,   783,  1131,
     556,    -1,   101,   783,  1131,   198,   314,   319,    -1,   101,
     783,  1131,   399,   314,   319,    -1,   101,   783,  1131,   399,
     411,  1013,    -1,   101,   783,  1131,   399,   559,    -1,   101,
     783,  1131,   374,   559,    -1,   101,   783,  1131,   399,   414,
    1131,    -1,   198,   783,   242,   212,  1131,   557,    -1,   198,
     783,  1131,   557,    -1,   101,   783,  1131,   784,   441,   917,
     558,    -1,    95,   596,    -1,   198,   151,   242,   212,  1003,
     557,    -1,   198,   151,  1003,   557,    -1,   399,   469,   327,
      -1,   399,   470,   327,    -1,   140,   328,  1003,    -1,   399,
     470,   140,    -1,   201,   436,  1003,    -1,   201,   102,   436,
    1003,    -1,   201,   373,   436,  1003,    -1,   201,   436,    99,
      -1,   201,   436,   451,    -1,   191,   436,  1003,    -1,   191,
     436,    99,    -1,   191,   436,   451,    -1,   201,   385,  1003,
      -1,   201,   102,   385,  1003,    -1,   201,   373,   385,  1003,
      -1,   191,   385,  1003,    -1,   252,  1001,    -1,   306,   252,
    1001,    -1,   341,   432,  1012,    -1,   399,   424,  1003,    -1,
     399,   559,    -1,   374,   559,    -1,   399,   181,   941,    -1,
     198,   181,    -1,   127,    -1,   376,    -1,    -1,   452,   941,
      -1,    -1,   502,   561,   503,    -1,   469,   559,    -1,    -1,
     562,    -1,   561,   505,   562,    -1,  1133,   489,   680,    -1,
    1133,    -1,  1133,   504,  1133,   489,   680,    -1,  1133,   504,
    1133,    -1,   139,   863,    -1,   139,    99,    -1,   156,   570,
    1001,   598,   571,   565,   566,   572,   514,   567,    -1,   156,
     867,   432,   566,   514,   567,    -1,   227,    -1,   432,    -1,
    1151,    -1,   412,    -1,   413,    -1,   568,    -1,   502,   574,
     503,    -1,   568,   569,    -1,    -1,   120,    -1,   327,    -1,
     187,   818,  1151,    -1,   319,   818,  1151,    -1,   163,    -1,
     238,    -1,   359,   818,  1151,    -1,   206,   818,  1151,    -1,
     223,   359,   599,    -1,   223,   359,   495,    -1,   223,   314,
     319,   599,    -1,   120,    -1,    -1,   469,   327,    -1,    -1,
     573,   188,  1151,    -1,    -1,   452,    -1,    -1,   575,    -1,
     574,   505,   575,    -1,  1133,   576,    -1,   541,    -1,   544,
      -1,   625,    -1,   495,    -1,   502,   577,   503,    -1,    -1,
     578,    -1,   577,   505,   578,    -1,   541,    -1,   544,    -1,
     158,   580,   422,  1001,   502,   581,   503,   609,   610,   611,
     612,    -1,   158,   580,   422,  1001,   324,   704,   582,   610,
     611,   612,    -1,   427,    -1,   425,    -1,   286,   427,    -1,
     286,   425,    -1,   231,   427,    -1,   231,   425,    -1,    -1,
     583,    -1,    -1,   502,   584,   503,    -1,    -1,   585,    -1,
     583,   505,   585,    -1,   586,    -1,   584,   505,   586,    -1,
     587,    -1,   593,    -1,   596,    -1,   588,    -1,   596,    -1,
    1131,   917,   589,    -1,  1131,   469,   332,   589,    -1,   589,
     590,    -1,    -1,   151,  1003,   591,    -1,   591,    -1,   592,
      -1,   314,   319,    -1,   319,    -1,   446,   761,   613,    -1,
     354,   272,   761,   613,    -1,   136,   502,   941,   503,    -1,
     181,   942,    -1,   366,  1001,   598,   601,   605,    -1,   183,
      -1,   314,   183,    -1,   254,   184,    -1,   254,   244,    -1,
     282,  1001,   594,    -1,   594,   248,   595,    -1,   594,   209,
     595,    -1,    -1,   182,    -1,   152,    -1,   251,    -1,   414,
      -1,   145,    -1,    99,    -1,   151,  1003,   597,    -1,   597,
      -1,   136,   502,   941,   503,   670,    -1,   446,   502,   599,
     503,   761,   613,   670,    -1,   354,   272,   502,   599,   503,
     761,   613,   670,    -1,   208,   739,   502,   602,   503,   761,
     613,   604,   670,    -1,   224,   272,   502,   599,   503,   366,
    1001,   598,   601,   605,   670,    -1,   502,   599,   503,    -1,
      -1,   600,    -1,   599,   505,   600,    -1,  1131,    -1,   293,
     228,    -1,   293,   343,    -1,   293,   404,    -1,    -1,   603,
      -1,   602,   505,   603,    -1,   741,   469,   771,    -1,   741,
     469,   330,   502,   771,   503,    -1,   466,   502,   941,   503,
      -1,    -1,   606,    -1,   607,    -1,   606,   607,    -1,   607,
     606,    -1,    -1,   328,   450,   608,    -1,   328,   186,   608,
      -1,   306,    94,    -1,   376,    -1,   127,    -1,   399,   319,
      -1,   399,   181,    -1,   253,   502,  1000,   503,    -1,    -1,
     469,   559,    -1,   469,   327,    -1,   470,   327,    -1,    -1,
     328,   146,   198,    -1,   328,   146,   186,   384,    -1,   328,
     146,   351,   384,    -1,    -1,   424,  1003,    -1,    -1,   452,
     250,   424,  1003,    -1,    -1,  1001,   615,   610,   611,   612,
      -1,   502,   616,   503,    -1,    -1,   617,    -1,   616,   505,
     617,    -1,  1131,    -1,   469,   174,    -1,   469,   306,   174,
      -1,    -1,   158,   580,   393,  1001,   621,    -1,   101,   393,
    1001,   622,    -1,   622,    -1,    -1,   623,    -1,   622,   623,
      -1,   125,   625,    -1,   173,    -1,   306,   173,    -1,   249,
     624,   625,    -1,   294,   625,    -1,   296,   625,    -1,   306,
     294,    -1,   306,   296,    -1,   340,   124,   704,    -1,   409,
     514,   625,    -1,   375,    -1,   375,   514,   625,    -1,   124,
      -1,    -1,  1150,    -1,   494,  1150,    -1,  1013,    -1,   625,
      -1,   626,   505,   625,    -1,   158,   746,   628,   634,   273,
     544,    -1,   158,   746,   628,   634,   273,   544,   236,   629,
     630,   632,    -1,   440,    -1,    -1,  1003,    -1,  1003,   705,
      -1,   255,   629,    -1,    -1,   455,   629,    -1,   306,   455,
      -1,   631,    -1,    -1,   198,   634,   273,   544,   557,    -1,
     198,   634,   273,   242,   212,   544,   557,    -1,   357,    -1,
      -1,   158,   424,  1003,   636,   289,  1151,    -1,   341,  1003,
      -1,    -1,   198,   424,  1003,    -1,   198,   424,   242,   212,
    1003,    -1,   158,   224,   174,   472,  1003,   632,   641,    -1,
     198,   224,   174,   472,  1003,   557,    -1,   198,   224,   174,
     472,   242,   212,  1003,   557,    -1,   101,   224,   174,   472,
    1003,   631,   643,    -1,   101,   224,   174,   472,  1003,   631,
      -1,   101,   224,   174,   472,  1003,   643,    -1,   332,   502,
     642,   503,    -1,    -1,   646,    -1,   642,   505,   646,    -1,
     332,   502,   644,   503,    -1,   645,    -1,   644,   505,   645,
      -1,   646,    -1,   399,   646,    -1,    95,   646,    -1,   198,
     647,    -1,   647,   648,    -1,  1133,    -1,  1151,    -1,   158,
     396,  1003,   650,   652,   224,   174,   472,  1003,   641,    -1,
     441,  1151,    -1,    -1,   462,  1151,    -1,   462,   319,    -1,
     651,    -1,    -1,   198,   396,  1003,   557,    -1,   198,   396,
     242,   212,  1003,   557,    -1,   101,   396,  1003,   651,   643,
      -1,   101,   396,  1003,   651,    -1,   101,   396,  1003,   643,
      -1,   158,   451,   292,   222,   656,   396,  1003,   641,    -1,
     171,    -1,   451,    -1,  1012,    -1,   198,   451,   292,   222,
     656,   396,  1003,    -1,   198,   451,   292,   242,   212,   222,
     656,   396,  1003,    -1,   101,   451,   292,   222,   656,   396,
    1003,   643,    -1,   158,   436,  1003,   660,   661,   328,  1001,
     663,   666,   211,   358,  1009,   502,   667,   503,    -1,   158,
     151,   436,  1003,    97,   661,   328,  1001,   669,   670,   222,
     199,   383,   666,   211,   358,  1009,   502,   667,   503,    -1,
     116,    -1,    97,    -1,   662,    -1,   661,   333,   662,    -1,
     260,    -1,   186,    -1,   450,    -1,   450,   324,   599,    -1,
     439,    -1,   222,   664,   665,    -1,    -1,   199,    -1,    -1,
     383,    -1,   410,    -1,   465,   502,   941,   503,    -1,    -1,
     668,    -1,   667,   505,   668,    -1,    -1,  1011,    -1,  1150,
      -1,  1151,    -1,  1149,    -1,    84,    -1,  1131,    -1,   227,
    1001,    -1,    -1,   671,    -1,   671,   672,    -1,   672,    -1,
     672,   671,    -1,    -1,   314,   183,    -1,   183,    -1,   254,
     244,    -1,   254,   184,    -1,   198,   436,  1003,   328,  1001,
     557,    -1,   198,   436,   242,   212,  1003,   328,  1001,   557,
      -1,   158,   110,  1003,   136,   502,   941,   503,   670,    -1,
     198,   110,  1003,   557,    -1,   158,    98,  1009,   681,   677,
      -1,   158,    98,  1009,   682,    -1,   158,   330,   771,   677,
      -1,   158,   441,   704,   677,    -1,   158,   441,   704,    -1,
     158,   441,   704,   108,   502,   915,   503,    -1,   158,   441,
     704,   108,   205,   502,   685,   503,    -1,   158,   428,   389,
     342,   704,   677,    -1,   158,   428,   389,   190,   704,   677,
      -1,   158,   428,   389,   426,   704,   677,    -1,   158,   428,
     389,   149,   704,   677,    -1,   502,   678,   503,    -1,   679,
      -1,   678,   505,   679,    -1,  1133,   489,   680,    -1,  1133,
      -1,   755,    -1,  1017,    -1,   967,    -1,   625,    -1,  1151,
      -1,   502,   972,   503,    -1,   502,   495,   503,    -1,   502,
     683,   503,    -1,   684,    -1,   683,   505,   684,    -1,  1153,
     489,   680,    -1,   686,    -1,    -1,  1151,    -1,   686,   505,
    1151,    -1,   158,   330,   138,   704,   690,   222,   441,   917,
     452,  1005,   691,   108,   688,    -1,   689,    -1,   688,   505,
     689,    -1,   330,  1011,   771,   692,    -1,   330,  1011,   771,
     770,   692,    -1,   229,  1011,  1009,   747,    -1,   229,  1011,
     502,   972,   503,  1009,   747,    -1,   414,   917,    -1,   181,
      -1,    -1,   217,   704,    -1,    -1,   364,    -1,    -1,   158,
     330,   217,   704,   452,  1005,    -1,   101,   330,   217,   704,
     452,  1005,    95,   688,    -1,   101,   330,   217,   704,   452,
    1005,   198,   695,    -1,   696,    -1,   695,   505,   696,    -1,
     330,  1011,   502,   972,   503,    -1,   229,  1011,   502,   972,
     503,    -1,   198,   330,   138,   704,   452,  1005,   557,    -1,
     198,   330,   138,   242,   212,   704,   452,  1005,   557,    -1,
     198,   330,   217,   704,   452,  1005,   557,    -1,   198,   330,
     217,   242,   212,   704,   452,  1005,   557,    -1,   198,   340,
     124,  1002,   557,    -1,   363,   340,   124,  1002,   432,  1003,
      -1,   198,   702,   242,   212,   703,   557,    -1,   198,   702,
     703,   557,    -1,   422,    -1,   393,    -1,   463,    -1,   250,
      -1,   441,    -1,   196,    -1,   155,    -1,   387,    -1,   428,
     389,   342,    -1,   428,   389,   190,    -1,   428,   389,   426,
      -1,   428,   389,   149,    -1,   704,    -1,   703,   505,   704,
      -1,  1131,    -1,  1131,   705,    -1,   504,  1006,    -1,   705,
     504,  1006,    -1,   439,   876,   910,   707,   557,    -1,   154,
     241,    -1,   375,   241,    -1,    -1,   144,   328,   709,   704,
     268,   710,    -1,   144,   328,    98,  1009,   681,   268,   710,
      -1,   144,   328,   229,  1009,   747,   268,   710,    -1,   144,
     328,   330,   771,   770,   268,   710,    -1,   144,   328,   151,
    1003,   328,   704,   268,   710,    -1,   144,   328,   385,  1003,
     328,   704,   268,   710,    -1,   144,   328,   385,  1003,   268,
     710,    -1,   144,   328,   436,  1003,   328,   704,   268,   710,
      -1,   144,   328,   330,   138,   704,   452,  1005,   268,   710,
      -1,   144,   328,   330,   217,   704,   452,  1005,   268,   710,
      -1,   144,   328,   274,   323,   625,   268,   710,    -1,   144,
     328,   130,   502,   917,   108,   917,   503,   268,   710,    -1,
     144,   328,   634,   273,   704,   268,   710,    -1,   144,   328,
     428,   389,   342,   704,   268,   710,    -1,   144,   328,   428,
     389,   190,   704,   268,   710,    -1,   144,   328,   428,   389,
     426,   704,   268,   710,    -1,   144,   328,   428,   389,   149,
     704,   268,   710,    -1,   143,    -1,   175,    -1,   387,    -1,
     250,    -1,   393,    -1,   422,    -1,   196,    -1,   441,    -1,
     463,    -1,   155,    -1,   424,    -1,   381,    -1,  1151,    -1,
     319,    -1,   218,   712,    -1,   299,   712,    -1,   218,   712,
    1165,    -1,   218,   225,   863,  1166,    -1,   218,   225,   713,
     863,  1166,    -1,   218,   115,   863,  1166,    -1,   218,   115,
     713,   863,  1166,    -1,   299,   225,   863,    -1,   299,   225,
     713,   863,    -1,   299,   115,   863,    -1,   299,   115,   713,
     863,    -1,   863,    -1,   713,   863,    -1,   305,   714,   863,
      -1,   355,   714,   863,    -1,   219,   714,   863,    -1,   275,
     714,   863,    -1,    92,  1013,   714,   863,    -1,   368,  1013,
     714,   863,    -1,  1013,   714,   863,    -1,    99,   714,   863,
      -1,   225,  1013,   714,   863,    -1,   225,    99,   714,   863,
      -1,   115,  1013,   714,   863,    -1,   115,    99,   714,   863,
      -1,   227,    -1,   247,    -1,   713,    -1,    -1,   232,   717,
     328,   720,   432,   721,   723,    -1,   379,   717,   328,   720,
     227,   721,   557,    -1,   379,   232,   331,   222,   717,   328,
     720,   227,   721,   557,    -1,   718,    -1,    99,    -1,    99,
     356,    -1,    99,   502,   599,   503,    -1,    99,   356,   502,
     599,   503,    -1,   719,    -1,   718,   505,   719,    -1,   392,
     598,    -1,   366,   598,    -1,   158,   598,    -1,  1131,   598,
      -1,  1000,    -1,   422,  1000,    -1,   393,  1000,    -1,   224,
     174,   472,  1002,    -1,   224,   396,  1002,    -1,   229,   724,
      -1,   175,  1002,    -1,   273,  1002,    -1,   274,   323,   626,
      -1,   387,  1002,    -1,   424,  1002,    -1,    99,   423,   247,
     387,  1002,    -1,    99,   394,   247,   387,  1002,    -1,    99,
     230,   247,   387,  1002,    -1,   722,    -1,   721,   505,   722,
      -1,  1012,    -1,   235,  1012,    -1,   469,   232,   331,    -1,
      -1,   725,    -1,   724,   505,   725,    -1,  1009,   747,    -1,
     232,   718,   432,  1002,   728,   729,    -1,   379,   718,   227,
    1002,   729,   557,    -1,   379,    96,   331,   222,   718,   227,
    1002,   729,   557,    -1,   469,    96,   331,    -1,    -1,   233,
     124,  1012,    -1,    -1,   101,   181,   356,   731,   733,    -1,
     731,   732,    -1,    -1,   247,   387,  1002,    -1,   222,   381,
    1002,    -1,   222,   451,  1002,    -1,   232,   717,   328,   734,
     432,   721,   723,    -1,   379,   717,   328,   734,   227,   721,
     557,    -1,   379,   232,   331,   222,   717,   328,   734,   227,
     721,   557,    -1,   423,    -1,   230,    -1,   394,    -1,   158,
     736,   250,   737,   738,   328,  1001,   739,   502,   740,   503,
     560,   612,   913,    -1,   446,    -1,    -1,   148,    -1,    -1,
    1007,    -1,    -1,   452,  1005,    -1,    -1,   741,    -1,   740,
     505,   741,    -1,  1131,   742,   743,   744,    -1,   944,   742,
     743,   744,    -1,   502,   941,   503,   742,   743,   744,    -1,
     704,    -1,   452,   704,    -1,    -1,   109,    -1,   189,    -1,
      -1,   486,    -1,   487,    -1,    -1,   158,   746,   229,  1009,
     749,   378,   754,   757,   761,    -1,   158,   746,   229,  1009,
     749,   378,   422,   502,   763,   503,   757,   761,    -1,   158,
     746,   229,  1009,   749,   757,   761,    -1,   333,   372,    -1,
      -1,   502,   748,   503,    -1,   502,   503,    -1,   751,    -1,
     748,   505,   751,    -1,   502,   750,   503,    -1,   502,   503,
      -1,   756,    -1,   750,   505,   756,    -1,   752,   753,   755,
      -1,   753,   752,   755,    -1,   753,   755,    -1,   752,   755,
      -1,   755,    -1,   247,    -1,   335,    -1,   257,    -1,   247,
     335,    -1,   459,    -1,  1132,    -1,   755,    -1,   917,    -1,
    1132,   705,   497,   441,    -1,   400,  1132,   705,   497,   441,
      -1,   751,    -1,   751,   181,   941,    -1,   751,   489,   941,
      -1,   759,    -1,   757,   759,    -1,   126,   328,   319,   258,
      -1,   378,   319,   328,   319,   258,    -1,   415,    -1,   245,
      -1,   407,    -1,   464,    -1,   214,   391,   185,    -1,   214,
     391,   267,    -1,   391,   185,    -1,   391,   267,    -1,   157,
     625,    -1,   384,   625,    -1,   546,    -1,   108,   760,    -1,
     273,   544,    -1,   468,    -1,   758,    -1,  1151,    -1,  1151,
     505,  1151,    -1,   469,   677,    -1,    -1,   753,   755,    -1,
     762,    -1,   763,   505,   762,    -1,   101,   229,   725,   765,
     766,    -1,   758,    -1,   765,   758,    -1,   376,    -1,    -1,
     198,   229,  1009,   747,   557,    -1,   198,   229,   242,   212,
    1009,   747,   557,    -1,   198,    98,  1009,   681,   557,    -1,
     198,    98,   242,   212,  1009,   681,   557,    -1,   198,   330,
     771,   770,   557,    -1,   198,   330,   242,   212,   771,   770,
     557,    -1,   502,   917,   503,    -1,   502,   917,   505,   917,
     503,    -1,   502,   312,   505,   917,   503,    -1,   502,   917,
     505,   312,   503,    -1,   964,    -1,  1131,   504,   771,    -1,
     194,   773,    -1,   774,    -1,   773,   774,    -1,  1151,    -1,
     273,   544,    -1,   158,   130,   502,   917,   108,   917,   503,
     469,   229,   725,   776,    -1,   158,   130,   502,   917,   108,
     917,   503,   470,   229,   776,    -1,   158,   130,   502,   917,
     108,   917,   503,   469,   257,   776,    -1,   108,   246,    -1,
     108,   111,    -1,    -1,   198,   130,   778,   502,   917,   108,
     917,   503,   557,    -1,   242,   212,    -1,    -1,   367,   780,
    1001,   781,    -1,   367,   421,  1003,   781,    -1,   367,   175,
    1003,   781,    -1,   250,    -1,   422,    -1,   223,    -1,    -1,
     101,    98,  1009,   681,   370,   432,  1003,    -1,   101,   155,
     704,   370,   432,  1003,    -1,   101,   175,  1004,   370,   432,
    1004,    -1,   101,   229,   725,   370,   432,  1003,    -1,   101,
     235,  1012,   370,   432,  1012,    -1,   101,   634,   273,  1003,
     370,   432,  1003,    -1,   101,   330,   138,   704,   452,  1005,
     370,   432,  1003,    -1,   101,   330,   217,   704,   452,  1005,
     370,   432,  1003,    -1,   101,   387,  1003,   370,   432,  1003,
      -1,   101,   422,   909,   370,   432,  1003,    -1,   101,   393,
    1001,   370,   432,  1003,    -1,   101,   463,  1001,   370,   432,
    1003,    -1,   101,   250,  1001,   370,   432,  1003,    -1,   101,
     422,   909,   370,   783,  1003,   432,  1003,    -1,   101,   436,
    1003,   328,  1001,   370,   432,  1003,    -1,   101,   381,  1012,
     370,   432,  1012,    -1,   101,   451,  1012,   370,   432,  1012,
      -1,   101,   424,  1003,   370,   432,  1003,    -1,   101,   424,
    1003,   399,   559,    -1,   101,   424,  1003,   374,   559,    -1,
     101,   428,   389,   342,   704,   370,   432,  1003,    -1,   101,
     428,   389,   190,   704,   370,   432,  1003,    -1,   101,   428,
     389,   426,   704,   370,   432,  1003,    -1,   101,   428,   389,
     149,   704,   370,   432,  1003,    -1,   101,   441,   704,   370,
     432,  1003,    -1,   143,    -1,    -1,   399,   174,    -1,    -1,
     101,    98,  1009,   681,   399,   387,  1003,    -1,   101,   196,
     704,   399,   387,  1003,    -1,   101,   229,   725,   399,   387,
    1003,    -1,   101,   422,   909,   399,   387,  1003,    -1,   101,
     393,  1001,   399,   387,  1003,    -1,   101,   463,  1001,   399,
     387,  1003,    -1,   101,   441,   704,   399,   387,  1003,    -1,
     101,    98,  1009,   681,   341,   432,  1012,    -1,   101,   155,
     704,   341,   432,  1012,    -1,   101,   175,  1004,   341,   432,
    1012,    -1,   101,   196,   704,   341,   432,  1012,    -1,   101,
     229,   725,   341,   432,  1012,    -1,   101,   634,   273,  1003,
     341,   432,  1012,    -1,   101,   274,   323,   625,   341,   432,
    1012,    -1,   101,   330,   771,   770,   341,   432,  1012,    -1,
     101,   330,   138,   704,   452,  1005,   341,   432,  1012,    -1,
     101,   330,   217,   704,   452,  1005,   341,   432,  1012,    -1,
     101,   387,  1003,   341,   432,  1012,    -1,   101,   441,   704,
     341,   432,  1012,    -1,   101,   424,  1003,   341,   432,  1012,
      -1,   101,   428,   389,   190,   704,   341,   432,  1012,    -1,
     101,   428,   389,   149,   704,   341,   432,  1012,    -1,   101,
     224,   174,   472,  1003,   341,   432,  1012,    -1,   101,   396,
    1003,   341,   432,  1012,    -1,   158,   746,   385,  1003,   108,
     328,   792,   432,  1001,   913,   194,   793,   788,    -1,   315,
      -1,   790,    -1,   502,   789,   503,    -1,   789,   506,   791,
      -1,   791,    -1,   866,    -1,   844,    -1,   855,    -1,   849,
      -1,   795,    -1,   790,    -1,    -1,   392,    -1,   450,    -1,
     186,    -1,   260,    -1,   261,    -1,   100,    -1,    -1,   198,
     385,  1003,   328,  1001,   557,    -1,   198,   385,   242,   212,
    1003,   328,  1001,   557,    -1,   316,  1131,   796,    -1,   505,
    1151,    -1,    -1,   284,  1131,    -1,   448,  1131,    -1,   448,
     495,    -1,    91,   800,    -1,   117,   800,   803,    -1,   409,
     434,   803,    -1,   146,   800,    -1,   204,   800,    -1,   382,
     800,    -1,   386,  1131,    -1,   369,   386,  1131,    -1,   369,
    1131,    -1,   382,   800,   432,   386,  1131,    -1,   382,   800,
     432,  1131,    -1,   352,   434,  1151,    -1,   146,   353,  1151,
      -1,   382,   353,  1151,    -1,   471,    -1,   434,    -1,    -1,
     270,   281,   540,    -1,   361,   329,    -1,   361,   473,    -1,
     801,    -1,   802,   505,   801,    -1,   802,   801,    -1,   802,
      -1,    -1,   158,   580,   463,  1001,   598,   108,   866,   805,
      -1,   158,   333,   372,   580,   463,  1001,   598,   108,   866,
     805,    -1,   469,   136,   331,    -1,   469,   128,   136,   331,
      -1,   469,   286,   136,   331,    -1,    -1,   285,  1008,    -1,
     158,   175,  1004,   514,   808,    -1,   808,   809,    -1,    -1,
     424,   810,  1003,    -1,   424,   810,   181,    -1,   289,   810,
    1151,    -1,   289,   810,   181,    -1,   426,   810,  1003,    -1,
     426,   810,   181,    -1,   202,   810,  1151,    -1,   202,   810,
    1011,    -1,   202,   810,   181,    -1,   276,   810,  1151,    -1,
     276,   810,   181,    -1,   277,   810,  1151,    -1,   277,   810,
     181,    -1,   150,   283,   810,  1013,    -1,   341,   810,  1003,
      -1,   341,   810,   181,    -1,   489,    -1,    -1,   101,   175,
    1004,   514,   813,    -1,   101,   175,  1004,   399,   424,  1003,
      -1,   101,   175,  1004,   546,    -1,   813,   814,    -1,    -1,
     150,   283,   810,  1013,    -1,   198,   175,  1004,    -1,   198,
     175,   242,   212,  1004,    -1,   158,   196,   704,   818,   917,
     589,    -1,   101,   196,   704,   556,    -1,   101,   196,   704,
     198,   314,   319,    -1,   101,   196,   704,   399,   314,   319,
      -1,   101,   196,   704,    95,   596,    -1,   101,   196,   704,
     198,   151,  1003,   557,    -1,   108,    -1,    -1,   101,   428,
     389,   190,   704,   677,    -1,   101,   428,   389,   149,   704,
      95,   292,   222,  1002,   469,   703,    -1,   101,   428,   389,
     149,   704,   101,   292,   222,  1002,   469,   703,    -1,   101,
     428,   389,   149,   704,   101,   292,   372,   704,   469,   704,
      -1,   101,   428,   389,   149,   704,   101,   292,   222,  1002,
     372,   704,   469,   704,    -1,   101,   428,   389,   149,   704,
     198,   292,   222,  1002,    -1,   101,   428,   389,   149,   704,
     198,   292,   242,   212,   222,  1002,    -1,   158,   690,   155,
     704,   222,  1151,   432,  1151,   227,   704,    -1,   140,   829,
    1001,   823,    -1,   140,   829,    -1,   140,   829,  1007,   328,
    1001,    -1,   452,  1007,    -1,    -1,   453,   830,   831,   829,
      -1,   453,   830,   831,   829,  1001,    -1,   453,   830,   831,
     829,   827,    -1,   453,   502,   825,   503,    -1,   453,   502,
     825,   503,  1001,   832,    -1,   826,    -1,   825,   505,   826,
      -1,   828,    -1,   461,    -1,   226,    -1,   228,    -1,   828,
     829,    -1,   828,   829,  1001,   832,    -1,   104,    -1,   103,
      -1,   461,    -1,    -1,   228,    -1,    -1,   226,    -1,    -1,
     502,  1002,   503,    -1,    -1,   213,   834,    -1,   213,   828,
     829,   834,    -1,   213,   461,   834,    -1,   213,   502,   835,
     503,   834,    -1,   866,    -1,   844,    -1,   855,    -1,   849,
      -1,   862,    -1,  1020,    -1,   842,    -1,   836,    -1,   835,
     505,   836,    -1,   837,   838,    -1,  1131,    -1,   828,    -1,
     461,    -1,   541,    -1,   544,    -1,   625,    -1,    -1,   352,
    1039,   840,   108,   841,    -1,   352,  1039,   227,  1084,    -1,
     502,   972,   503,    -1,    -1,   866,    -1,   844,    -1,   855,
      -1,   849,    -1,   211,  1039,   843,  1163,    -1,   158,   580,
     422,   614,   108,   211,  1039,   843,    -1,   502,   969,   503,
      -1,    -1,   260,   266,  1001,   845,   848,    -1,   866,    -1,
     502,   846,   503,   866,    -1,   181,   457,    -1,   847,    -1,
     846,   505,   847,    -1,  1131,   993,    -1,   377,   998,  1164,
      -1,    -1,   186,   227,   911,   850,   914,   848,    -1,   452,
     902,    -1,    -1,   290,   876,   910,   852,   854,    -1,   247,
     853,   297,    -1,    -1,    93,   401,    -1,   383,   401,    -1,
     383,   210,    -1,   401,   450,   210,    -1,   401,    -1,   401,
     383,   210,    -1,   210,    -1,    93,   210,    -1,   318,    -1,
      -1,   450,   911,   399,   856,   901,   914,   848,    -1,   857,
      -1,   856,   505,   857,    -1,   858,    -1,   859,    -1,   860,
     489,   995,    -1,   502,   861,   503,   489,   997,    -1,  1131,
     993,    -1,   860,    -1,   861,   505,   860,    -1,   180,   863,
     864,   172,   865,   222,   866,    -1,  1003,    -1,  1144,    -1,
      -1,   864,   306,   388,    -1,   864,   388,    -1,   864,   120,
      -1,   864,   259,    -1,    -1,   469,   239,    -1,   470,   239,
      -1,   868,    -1,   867,    -1,   502,   868,   503,    -1,   502,
     867,   503,    -1,   870,    -1,   869,   880,    -1,   869,   879,
     895,   884,    -1,   869,   879,   883,   896,    -1,   871,   869,
      -1,   871,   869,   880,    -1,   871,   869,   879,   895,   884,
      -1,   871,   869,   879,   883,   896,    -1,   870,    -1,   867,
      -1,   392,   878,   998,   874,   901,   913,   893,   894,   952,
      -1,   900,    -1,   422,   909,    -1,   869,   445,   877,   869,
      -1,   869,   264,   877,   869,    -1,   869,   207,   877,   869,
      -1,   469,   872,    -1,   469,   365,   872,    -1,   873,    -1,
     872,   505,   873,    -1,  1003,   832,   108,   867,    -1,   266,
     875,    -1,  1164,    -1,    -1,   427,   876,  1001,    -1,   425,
     876,  1001,    -1,   286,   427,   876,  1001,    -1,   286,   425,
     876,  1001,    -1,   231,   427,   876,  1001,    -1,   231,   425,
     876,  1001,    -1,   422,  1001,    -1,  1001,    -1,   422,    -1,
      -1,    99,    -1,   193,    -1,    -1,   193,    -1,   193,   328,
     502,   969,   503,    -1,    99,    -1,    -1,   880,    -1,    -1,
     334,   124,   881,    -1,   882,    -1,   881,   505,   882,    -1,
     941,   452,   967,   744,    -1,   941,   743,   744,    -1,   885,
     886,    -1,   886,   885,    -1,   885,    -1,   886,    -1,   883,
      -1,    -1,   283,   887,    -1,   283,   887,   505,   888,    -1,
     218,   892,   889,   891,   329,    -1,   326,   888,    -1,   326,
     890,   891,    -1,   941,    -1,    99,    -1,   941,    -1,  1013,
      -1,   502,   941,   503,    -1,    -1,   943,    -1,   383,    -1,
     384,    -1,   219,    -1,   305,    -1,   235,   124,   969,    -1,
      -1,   237,   941,    -1,    -1,   897,    -1,   222,   361,   329,
      -1,   895,    -1,    -1,   898,    -1,   897,   898,    -1,   222,
     450,   899,   854,    -1,   222,   401,   899,   854,    -1,   324,
    1000,    -1,    -1,   457,   997,    -1,   900,   505,   997,    -1,
     227,   902,    -1,    -1,   903,    -1,   902,   505,   903,    -1,
     909,    -1,   909,   905,    -1,   912,    -1,   912,   905,    -1,
     912,   108,   502,   915,   503,    -1,   912,   108,  1131,   502,
     915,   503,    -1,   912,  1131,   502,   915,   503,    -1,   867,
      -1,   867,   905,    -1,   904,    -1,   502,   904,   503,   905,
      -1,   502,   904,   503,    -1,   903,   162,   271,   903,    -1,
     903,   906,   271,   903,   908,    -1,   903,   271,   903,   908,
      -1,   903,   303,   906,   271,   903,    -1,   903,   303,   271,
     903,    -1,   108,  1131,   502,  1002,   503,    -1,   108,  1131,
      -1,  1131,   502,  1002,   503,    -1,  1131,    -1,   228,   907,
      -1,   280,   907,    -1,   380,   907,    -1,   256,    -1,   336,
      -1,    -1,   452,   502,  1002,   503,    -1,   328,   941,    -1,
    1001,    -1,  1001,   495,    -1,   329,  1001,    -1,   329,   502,
    1001,   503,    -1,   909,    -1,   910,   505,   909,    -1,   909,
      -1,   909,  1131,    -1,   909,   108,  1131,    -1,   944,    -1,
     466,   941,    -1,    -1,   466,   941,    -1,   466,   164,   324,
    1003,    -1,    -1,   916,    -1,   915,   505,   916,    -1,  1131,
     917,    -1,   919,   918,    -1,   400,   919,   918,    -1,   919,
     107,   500,  1011,   501,    -1,   400,   919,   107,   500,  1011,
     501,    -1,   919,   107,    -1,   400,   919,   107,    -1,   918,
     500,   501,    -1,   918,   500,  1162,   501,    -1,    -1,   921,
      -1,   923,    -1,   925,    -1,   929,    -1,   936,    -1,   937,
     939,    -1,   937,   502,  1011,   503,   939,    -1,   923,    -1,
     926,    -1,   930,    -1,   936,    -1,  1132,   922,    -1,  1132,
     705,   922,    -1,   502,   969,   503,    -1,    -1,   262,    -1,
     263,    -1,   405,    -1,   119,    -1,   362,    -1,   220,   924,
      -1,   197,   350,    -1,   179,   922,    -1,   178,   922,    -1,
     322,   922,    -1,   122,    -1,   502,  1011,   503,    -1,    -1,
     927,    -1,   928,    -1,   927,    -1,   928,    -1,   121,   934,
     502,   969,   503,    -1,   121,   934,    -1,   931,    -1,   932,
      -1,   931,    -1,   932,    -1,   933,   502,  1011,   503,   935,
      -1,   933,   935,    -1,   134,   934,    -1,   133,   934,    -1,
     458,    -1,   302,   134,   934,    -1,   302,   133,   934,    -1,
     304,   934,    -1,   460,    -1,    -1,   134,   399,  1131,    -1,
      -1,   431,   502,  1011,   503,   938,    -1,   431,   938,    -1,
     430,   502,  1011,   503,   938,    -1,   430,   938,    -1,   265,
      -1,   488,   485,    -1,   470,   430,   485,    -1,    -1,   483,
      -1,   298,    -1,   176,    -1,   240,    -1,   295,    -1,   940,
      -1,   483,   432,   298,    -1,   176,   432,   240,    -1,   176,
     432,   295,    -1,   176,   432,   940,    -1,   240,   432,   295,
      -1,   240,   432,   940,    -1,   295,   432,   940,    -1,    -1,
     390,    -1,   390,   502,  1011,   503,    -1,   943,    -1,   941,
      88,   917,    -1,   941,   113,   430,   485,   941,    -1,   493,
     941,    -1,   494,   941,    -1,   941,   493,   941,    -1,   941,
     494,   941,    -1,   941,   495,   941,    -1,   941,   496,   941,
      -1,   941,   497,   941,    -1,   941,   498,   941,    -1,   941,
     490,   941,    -1,   941,   491,   941,    -1,   941,   489,   941,
      -1,   941,   966,   941,    -1,   966,   941,    -1,   941,   966,
      -1,   941,   105,   941,    -1,   941,   333,   941,    -1,   314,
     941,    -1,   941,   282,   941,    -1,   941,   282,   941,   206,
     941,    -1,   941,   314,   282,   941,    -1,   941,   314,   282,
     941,   206,   941,    -1,   941,   243,   941,    -1,   941,   243,
     941,   206,   941,    -1,   941,   314,   243,   941,    -1,   941,
     314,   243,   941,   206,   941,    -1,   941,   403,   432,   941,
      -1,   941,   403,   432,   941,   206,   941,    -1,   941,   314,
     403,   432,   941,    -1,   941,   314,   403,   432,   941,   206,
     941,    -1,   941,   268,   319,    -1,   941,   269,    -1,   941,
     268,   314,   319,    -1,   941,   317,    -1,   962,   338,   962,
      -1,   941,   268,   438,    -1,   941,   268,   314,   438,    -1,
     941,   268,   216,    -1,   941,   268,   314,   216,    -1,   941,
     268,   447,    -1,   941,   268,   314,   447,    -1,   941,   268,
     193,   227,   941,    -1,   941,   268,   314,   193,   227,   941,
      -1,   941,   268,   324,   502,   972,   503,    -1,   941,   268,
     314,   324,   502,   972,   503,    -1,   941,   118,   994,   942,
     105,   942,    -1,   941,   314,   118,   994,   942,   105,   942,
      -1,   941,   118,   419,   942,   105,   942,    -1,   941,   314,
     118,   419,   942,   105,   942,    -1,   941,   247,   984,    -1,
     941,   314,   247,   984,    -1,   941,   968,   963,   867,    -1,
     941,   968,   963,   502,   941,   503,    -1,   446,   867,    -1,
     941,   268,   195,    -1,   941,   268,   314,   195,    -1,   943,
      -1,   942,    88,   917,    -1,   493,   942,    -1,   494,   942,
      -1,   942,   493,   942,    -1,   942,   494,   942,    -1,   942,
     495,   942,    -1,   942,   496,   942,    -1,   942,   497,   942,
      -1,   942,   498,   942,    -1,   942,   490,   942,    -1,   942,
     491,   942,    -1,   942,   489,   942,    -1,   942,   966,   942,
      -1,   966,   942,    -1,   942,   966,    -1,   942,   268,   193,
     227,   942,    -1,   942,   268,   314,   193,   227,   942,    -1,
     942,   268,   324,   502,   972,   503,    -1,   942,   268,   314,
     324,   502,   972,   503,    -1,   942,   268,   195,    -1,   942,
     268,   314,   195,    -1,   990,    -1,  1010,    -1,  1148,   993,
      -1,   502,   941,   503,   993,    -1,   985,    -1,   944,    -1,
     867,    -1,   212,   867,    -1,   107,   867,    -1,   107,   973,
      -1,   962,    -1,  1009,   502,   503,   955,    -1,  1009,   502,
     970,   503,   955,    -1,  1009,   502,   459,   971,   503,   955,
      -1,  1009,   502,   970,   505,   459,   971,   503,   955,    -1,
    1009,   502,   970,   880,   503,   955,    -1,  1009,   502,    99,
     970,   879,   503,   955,    -1,  1009,   502,   193,   970,   879,
     503,   955,    -1,  1009,   502,   495,   503,   955,    -1,   166,
      -1,   169,    -1,   169,   502,  1011,   503,    -1,   170,    -1,
     170,   502,  1011,   503,    -1,   287,    -1,   287,   502,  1011,
     503,    -1,   288,    -1,   288,   502,  1011,   503,    -1,   167,
      -1,   171,    -1,   398,    -1,   451,    -1,   165,    -1,   168,
      -1,   130,   502,   941,   108,   917,   503,    -1,   215,   502,
     975,   503,    -1,   339,   502,   977,   503,    -1,   348,   502,
     979,   503,    -1,   417,   502,   980,   503,    -1,   435,   502,
     941,   108,   917,   503,    -1,   437,   502,   123,   983,   503,
      -1,   437,   502,   278,   983,   503,    -1,   437,   502,   433,
     983,   503,    -1,   437,   502,   983,   503,    -1,   320,   502,
     941,   505,   941,   503,    -1,   141,   502,   969,   503,    -1,
     234,   502,   969,   503,    -1,   279,   502,   969,   503,    -1,
     476,   502,   969,   503,    -1,   477,   502,   300,  1133,   503,
      -1,   477,   502,   300,  1133,   505,   947,   503,    -1,   477,
     502,   300,  1133,   505,   969,   503,    -1,   477,   502,   300,
    1133,   505,   947,   505,   969,   503,    -1,   478,   502,   948,
     503,    -1,   479,   502,   950,   941,   951,   503,    -1,   480,
     502,   300,  1133,   503,    -1,   480,   502,   300,  1133,   505,
     941,   503,    -1,   481,   502,   941,   505,   945,   946,   503,
      -1,   482,   502,   950,   941,   108,   919,   503,    -1,   462,
     941,    -1,   462,   306,   456,    -1,   505,   408,   484,    -1,
     505,   408,   306,    -1,   505,   408,   306,   456,    -1,    -1,
     475,   502,   948,   503,    -1,   949,    -1,   948,   505,   949,
      -1,   941,   108,  1133,    -1,   941,    -1,   195,    -1,   153,
      -1,   351,   467,    -1,   416,   467,    -1,    -1,   468,   953,
      -1,    -1,   954,    -1,   953,   505,   954,    -1,  1131,   108,
     956,    -1,   337,   956,    -1,   337,  1131,    -1,    -1,   502,
     957,   958,   879,   959,   503,    -1,  1131,    -1,    -1,   344,
     124,   969,    -1,    -1,   360,   960,    -1,   384,   960,    -1,
      -1,   961,    -1,   118,   961,   105,   961,    -1,   442,   349,
      -1,   442,   221,    -1,   164,   383,    -1,   941,   349,    -1,
     941,   221,    -1,   383,   502,   969,   503,    -1,   383,   502,
     503,    -1,   502,   969,   505,   941,   503,    -1,   106,    -1,
     406,    -1,    99,    -1,    85,    -1,   965,    -1,   493,    -1,
     494,    -1,   495,    -1,   496,    -1,   497,    -1,   498,    -1,
     490,    -1,   491,    -1,   489,    -1,    85,    -1,   330,   502,
     771,   503,    -1,   964,    -1,   330,   502,   771,   503,    -1,
     964,    -1,   330,   502,   771,   503,    -1,   282,    -1,   314,
     282,    -1,   243,    -1,   314,   243,    -1,   941,    -1,   969,
     505,   941,    -1,   971,    -1,   970,   505,   971,    -1,   941,
      -1,   753,    90,   941,    -1,   917,    -1,   972,   505,   917,
      -1,   500,   969,   501,    -1,   500,   974,   501,    -1,   500,
     501,    -1,   973,    -1,   974,   505,   973,    -1,   976,   227,
     941,    -1,    -1,  1153,    -1,   483,    -1,   298,    -1,   176,
      -1,   240,    -1,   295,    -1,   390,    -1,  1151,    -1,   941,
     978,   981,   982,    -1,   941,   978,   981,    -1,   346,   941,
      -1,   942,   247,   942,    -1,    -1,   941,   981,   982,    -1,
     941,   982,   981,    -1,   941,   981,    -1,   941,   982,    -1,
     969,    -1,    -1,   227,   941,    -1,   222,   941,    -1,   941,
     227,   969,    -1,   227,   969,    -1,   969,    -1,   867,    -1,
     502,   969,   503,    -1,   129,   989,   986,   988,   204,    -1,
     987,    -1,   986,   987,    -1,   465,   941,   429,   941,    -1,
     200,   941,    -1,    -1,   941,    -1,    -1,  1131,    -1,  1131,
     992,    -1,   504,  1006,    -1,   504,   495,    -1,   500,   941,
     501,    -1,   500,   941,   507,   941,   501,    -1,   991,    -1,
     992,   991,    -1,    -1,   993,   991,    -1,   112,    -1,    -1,
     941,    -1,   181,    -1,   995,    -1,   996,   505,   995,    -1,
     502,   996,   503,    -1,   999,    -1,   998,   505,   999,    -1,
     941,   108,  1133,    -1,   941,  1153,    -1,   941,    -1,   495,
      -1,  1001,    -1,  1000,   505,  1001,    -1,  1131,    -1,  1131,
     992,    -1,  1003,    -1,  1002,   505,  1003,    -1,  1131,    -1,
    1131,    -1,  1131,    -1,  1133,    -1,  1131,    -1,  1151,    -1,
    1132,    -1,  1131,   992,    -1,  1011,    -1,  1150,    -1,  1151,
      -1,  1149,    -1,    84,    -1,  1009,  1151,    -1,  1009,   502,
     970,   503,  1151,    -1,   920,  1151,    -1,   937,  1151,   939,
      -1,   937,   502,  1011,   503,  1151,   939,    -1,   438,    -1,
     216,    -1,   319,    -1,  1145,    -1,  1143,    -1,    86,    -1,
    1131,    -1,  1011,    -1,  1145,    -1,   493,  1011,    -1,   494,
    1011,    -1,    91,    -1,    92,    -1,    93,    -1,    94,    -1,
      95,    -1,    96,    -1,    97,    -1,    98,    -1,   100,    -1,
     101,    -1,   102,    -1,   110,    -1,   111,    -1,   113,    -1,
     115,    -1,   116,    -1,   117,    -1,   124,    -1,   125,    -1,
     126,    -1,   127,    -1,   128,    -1,   131,    -1,   132,    -1,
     135,    -1,   137,    -1,   138,    -1,   139,    -1,   140,    -1,
     144,    -1,   145,    -1,   146,    -1,   147,    -1,   149,    -1,
     152,    -1,   153,    -1,   154,    -1,   155,    -1,   156,    -1,
     157,    -1,   159,    -1,   160,    -1,   161,    -1,   163,    -1,
     172,    -1,   173,    -1,   174,    -1,   175,    -1,   177,    -1,
     180,    -1,   182,    -1,   184,    -1,   185,    -1,   186,    -1,
     187,    -1,   188,    -1,   190,    -1,   191,    -1,   192,    -1,
     195,    -1,   196,    -1,   197,    -1,   198,    -1,   199,    -1,
     201,    -1,   202,    -1,   203,    -1,   205,    -1,   206,    -1,
     208,    -1,   209,    -1,   210,    -1,   211,    -1,   213,    -1,
     214,    -1,   217,    -1,   219,    -1,   221,    -1,   223,    -1,
     225,    -1,   229,    -1,   230,    -1,   231,    -1,   233,    -1,
     236,    -1,   238,    -1,   239,    -1,   241,    -1,   242,    -1,
     244,    -1,   245,    -1,   246,    -1,   248,    -1,   249,    -1,
     250,    -1,   251,    -1,   252,    -1,   253,    -1,   255,    -1,
     259,    -1,   260,    -1,   261,    -1,   267,    -1,   270,    -1,
     272,    -1,   273,    -1,   274,    -1,   275,    -1,   276,    -1,
     277,    -1,   281,    -1,   284,    -1,   285,    -1,   286,    -1,
     289,    -1,   290,    -1,   291,    -1,   292,    -1,   293,    -1,
     294,    -1,   296,    -1,   297,    -1,   299,    -1,   300,    -1,
     301,    -1,   305,    -1,   306,    -1,   307,    -1,   308,    -1,
     309,    -1,   310,    -1,   311,    -1,   313,    -1,   315,    -1,
     316,    -1,   318,    -1,   321,    -1,   323,    -1,   324,    -1,
     327,    -1,   330,    -1,   331,    -1,   332,    -1,   340,    -1,
     341,    -1,   342,    -1,   343,    -1,   344,    -1,   345,    -1,
     347,    -1,   349,    -1,   352,    -1,   353,    -1,   351,    -1,
     355,    -1,   356,    -1,   357,    -1,   358,    -1,   359,    -1,
     360,    -1,   361,    -1,   363,    -1,   364,    -1,   365,    -1,
     367,    -1,   368,    -1,   369,    -1,   370,    -1,   371,    -1,
     372,    -1,   373,    -1,   374,    -1,   375,    -1,   376,    -1,
     378,    -1,   379,    -1,   381,    -1,   382,    -1,   384,    -1,
     385,    -1,   386,    -1,   387,    -1,   388,    -1,   389,    -1,
     391,    -1,   393,    -1,   394,    -1,   395,    -1,   396,    -1,
     397,    -1,   399,    -1,   401,    -1,   402,    -1,   404,    -1,
     407,    -1,   408,    -1,   409,    -1,   410,    -1,   411,    -1,
     412,    -1,   413,    -1,   414,    -1,   415,    -1,   416,    -1,
     418,    -1,   420,    -1,   421,    -1,   423,    -1,   424,    -1,
     425,    -1,   426,    -1,   427,    -1,   428,    -1,   434,    -1,
     436,    -1,   439,    -1,   440,    -1,   441,    -1,   442,    -1,
     443,    -1,   444,    -1,   447,    -1,   448,    -1,   449,    -1,
     450,    -1,   453,    -1,   454,    -1,   455,    -1,   456,    -1,
     460,    -1,   462,    -1,   463,    -1,   464,    -1,   467,    -1,
     470,    -1,   471,    -1,   472,    -1,   473,    -1,   474,    -1,
     484,    -1,   485,    -1,   118,    -1,   119,    -1,   121,    -1,
     122,    -1,   134,    -1,   141,    -1,   178,    -1,   179,    -1,
     212,    -1,   215,    -1,   220,    -1,   234,    -1,   257,    -1,
     263,    -1,   265,    -1,   279,    -1,   302,    -1,   304,    -1,
     312,    -1,   320,    -1,   322,    -1,   335,    -1,   339,    -1,
     348,    -1,   350,    -1,   362,    -1,   383,    -1,   400,    -1,
     405,    -1,   417,    -1,   430,    -1,   431,    -1,   435,    -1,
     437,    -1,   458,    -1,   475,    -1,   476,    -1,   477,    -1,
     478,    -1,   479,    -1,   480,    -1,   481,    -1,   482,    -1,
     114,    -1,   120,    -1,   148,    -1,   162,    -1,   168,    -1,
     226,    -1,   228,    -1,   243,    -1,   256,    -1,   268,    -1,
     269,    -1,   271,    -1,   280,    -1,   282,    -1,   303,    -1,
     317,    -1,   336,    -1,   337,    -1,   338,    -1,   380,    -1,
     403,    -1,   461,    -1,    99,    -1,   103,    -1,   104,    -1,
     105,    -1,   106,    -1,   107,    -1,   108,    -1,   109,    -1,
     112,    -1,   123,    -1,   129,    -1,   130,    -1,   136,    -1,
     142,    -1,   143,    -1,   151,    -1,   158,    -1,   165,    -1,
     166,    -1,   167,    -1,   169,    -1,   170,    -1,   171,    -1,
     181,    -1,   183,    -1,   189,    -1,   193,    -1,   194,    -1,
     200,    -1,   204,    -1,   207,    -1,   216,    -1,   218,    -1,
     222,    -1,   224,    -1,   227,    -1,   232,    -1,   235,    -1,
     237,    -1,   247,    -1,   254,    -1,   264,    -1,   266,    -1,
     278,    -1,   283,    -1,   287,    -1,   288,    -1,   314,    -1,
     319,    -1,   325,    -1,   326,    -1,   328,    -1,   329,    -1,
     333,    -1,   334,    -1,   346,    -1,   354,    -1,   366,    -1,
     377,    -1,   392,    -1,   398,    -1,   406,    -1,   419,    -1,
     422,    -1,   429,    -1,   433,    -1,   438,    -1,   446,    -1,
     451,    -1,   452,    -1,   459,    -1,   465,    -1,   466,    -1,
     468,    -1,   469,    -1,    -1,  1018,  1019,    -1,  1140,  1022,
     512,   506,    -1,  1140,   512,   506,    -1,  1140,  1042,    -1,
    1047,    -1,  1159,    -1,    73,    -1,   508,    -1,   509,    -1,
      -1,   158,   580,   422,   614,   108,  1021,   866,   618,    -1,
     113,  1083,    -1,     9,   432,  1024,  1031,  1032,    -1,     9,
     432,   181,    -1,     9,  1033,    -1,   175,  1024,    -1,  1025,
    1028,  1030,    -1,  1026,   507,  1027,  1030,   496,  1025,  1036,
      -1,  1035,    -1,  1151,    -1,  1004,    -1,    -1,  1153,  1147,
      -1,    85,  1029,    -1,  1027,    -1,    -1,  1131,    -1,  1131,
     504,  1029,    -1,    74,    -1,   507,  1011,    -1,    -1,   108,
    1083,    -1,    -1,   451,  1033,    -1,    -1,  1034,    -1,  1034,
     496,  1034,    -1,  1034,    21,   124,  1034,    -1,  1034,   452,
    1034,    -1,  1012,    -1,  1151,    -1,  1145,    -1,  1147,    -1,
      85,  1037,    -1,    -1,  1131,  1038,    -1,  1131,  1038,    85,
    1037,    -1,    -1,   489,  1011,    -1,   489,  1153,    -1,   489,
    1145,    -1,  1003,    -1,  1035,    -1,   180,   863,   864,   172,
     865,   222,  1039,    -1,   211,   244,  1084,    -1,  1043,    -1,
    1054,    -1,  1056,    -1,   625,    -1,   505,   625,    -1,    -1,
     939,    -1,   483,   432,   295,    -1,   483,   432,   390,    -1,
     176,   432,   176,    -1,   298,   432,   298,    -1,    -1,  1049,
    1048,  1051,  1050,    -1,  1140,   117,   180,    34,   506,    -1,
    1140,   204,   180,    34,   506,    -1,    -1,  1052,    -1,  1043,
      -1,    73,    -1,  1052,  1043,    -1,  1052,    73,    -1,  1056,
      -1,  1053,  1056,    -1,    -1,    70,  1055,  1063,  1079,  1135,
     918,   506,    -1,    -1,  1060,  1063,  1057,  1076,   506,    -1,
      -1,  1063,  1058,  1076,   506,    -1,  1066,   506,    -1,   507,
    1011,    -1,    -1,  1061,  1062,    -1,  1061,    -1,  1062,    -1,
      56,    -1,    67,    -1,    65,    -1,    50,    -1,    51,    -1,
      69,    -1,  1072,    -1,  1068,    -1,  1064,    -1,  1135,   502,
    1044,  1045,   503,    -1,  1135,  1046,    -1,  1070,    -1,   205,
    1129,  1065,    -1,   205,  1065,    -1,   205,  1129,    -1,   508,
    1157,   509,    -1,    -1,  1070,  1067,   508,  1053,   509,    -1,
    1066,    -1,    -1,  1071,  1069,   508,  1053,   509,    -1,    43,
    1129,    -1,   445,  1129,    -1,    43,    -1,   445,    -1,  1073,
      -1,  1075,  1074,    -1,    44,    35,    -1,    44,    35,   262,
      -1,    44,    -1,    44,   262,    -1,    44,    25,    -1,    44,
      25,   262,    -1,    44,    25,    25,    -1,    44,    25,    25,
     262,    -1,    44,   133,    -1,    35,    -1,    35,   262,    -1,
     262,    -1,    25,    -1,    25,   262,    -1,    25,    25,    -1,
      25,    25,   262,    -1,     5,    -1,   133,    -1,   197,    -1,
      36,    -1,    -1,  1077,    -1,  1076,   505,  1077,    -1,  1079,
    1134,   918,  1059,  1078,    -1,    -1,   489,  1158,    -1,    -1,
     495,    -1,   495,   495,    -1,   180,   410,  1153,    -1,    15,
    1082,    -1,  1083,    -1,   164,    -1,    99,    -1,    -1,  1004,
      -1,   181,    -1,  1035,    -1,  1035,    -1,    71,    -1,    17,
     863,    -1,    17,    99,    -1,    28,   863,  1087,    -1,    -1,
    1088,    -1,   452,  1092,    -1,  1089,    -1,   452,    37,    14,
    1154,    -1,   452,    14,  1003,    -1,   266,    37,    14,  1154,
      -1,   266,    14,  1003,    -1,   266,  1003,    -1,  1093,    -1,
    1093,   505,  1092,    -1,  1094,    -1,  1145,    -1,  1143,    -1,
    1011,    -1,   493,  1011,    -1,   494,  1011,    -1,  1150,    -1,
     493,  1150,    -1,   494,  1150,    -1,  1151,    -1,  1149,    -1,
    1152,    -1,    13,   258,  1039,  1089,    -1,    13,  1096,  1039,
    1089,    -1,    13,  1096,  1039,  1090,    -1,    13,   258,  1039,
    1091,    -1,    13,  1096,  1039,  1091,    -1,    29,    -1,    -1,
       3,    14,  1154,    -1,   177,    14,  1154,    -1,    18,    14,
    1154,  1100,    -1,  1101,    -1,  1100,   505,  1101,    -1,  1147,
     489,  1106,    -1,   399,    14,  1154,  1103,    -1,  1104,    -1,
    1103,   505,  1104,    -1,  1106,   489,  1105,    -1,  1011,    -1,
    1147,    -1,    10,    -1,    18,    14,  1154,   456,  1105,  1108,
      -1,  1109,    -1,  1108,   505,  1109,    -1,  1147,   489,  1114,
      -1,   399,    14,  1154,   456,  1105,  1111,    -1,  1112,    -1,
    1111,   505,  1112,    -1,  1114,   489,  1113,    -1,  1150,    -1,
    1105,    -1,   494,  1150,    -1,   494,  1011,    -1,  1151,    -1,
       8,    -1,   174,    -1,    11,    -1,    12,    -1,    22,    -1,
      23,    -1,    24,    -1,   300,    -1,    26,    -1,    27,    -1,
     350,    -1,    31,    -1,    32,    -1,    33,    -1,   441,    -1,
     399,     4,   489,  1116,    -1,   399,     4,   432,  1116,    -1,
     328,    -1,   325,    -1,   399,   150,   432,  1083,    -1,   399,
     150,   489,  1083,    -1,   399,   150,  1083,    -1,    -1,   441,
    1119,  1135,   268,  1063,   918,  1120,    -1,    30,    -1,    -1,
      -1,    45,  1122,  1133,   268,  1063,   918,  1120,    -1,    46,
      38,  1124,    -1,    46,   314,    16,  1124,    -1,    46,    40,
    1124,    -1,   154,    -1,    39,    -1,    42,    -1,    20,  1003,
      -1,    19,   432,  1003,    -1,   194,  1003,   502,  1141,   503,
      -1,   194,     6,    -1,     7,  1003,   502,  1141,   503,    -1,
       7,  1003,    -1,  1126,    -1,  1127,    -1,     6,    -1,     7,
      -1,     8,    -1,    10,    -1,    11,    -1,    12,    -1,    16,
      -1,    19,    -1,    20,    -1,    21,    -1,    22,    -1,    23,
      -1,    24,    -1,    26,    -1,    27,    -1,    31,    -1,    32,
      -1,    33,    -1,    34,    -1,    37,    -1,    38,    -1,    39,
      -1,    40,    -1,    42,    -1,     9,    -1,    13,    -1,    15,
      -1,    28,    -1,    45,    -1,    46,    -1,     5,    -1,    25,
      -1,    29,    -1,    35,    -1,    43,    -1,    36,    -1,    44,
      -1,  1133,    -1,  1153,    -1,  1014,    -1,  1015,    -1,  1138,
      -1,  1125,    -1,  1136,    -1,   133,    -1,   457,    -1,  1153,
      -1,  1137,    -1,  1015,    -1,  1125,    -1,  1136,    -1,   133,
      -1,   457,    -1,  1153,    -1,  1137,    -1,  1016,    -1,  1125,
      -1,  1136,    -1,  1128,    -1,  1134,    -1,  1128,    -1,   133,
      -1,   164,    -1,   258,    -1,   262,    -1,   432,    -1,   445,
      -1,   457,    -1,  1136,    -1,  1138,    -1,  1135,    -1,  1014,
      -1,  1017,    -1,  1127,    -1,   150,    -1,  1153,    -1,  1015,
      -1,  1016,    -1,  1126,    -1,    50,    -1,    51,    -1,    56,
      -1,    65,    -1,    67,    -1,    70,    -1,    69,    -1,  1014,
      -1,  1138,    -1,   150,    -1,   176,    -1,   240,    -1,   295,
      -1,   298,    -1,   390,    -1,   483,    -1,  1142,    -1,  1139,
     505,  1142,    -1,    41,    -1,    -1,  1157,    -1,  1147,  1146,
      -1,  1147,    -1,  1147,  1146,    -1,  1035,    -1,  1147,    -1,
    1147,    -1,    22,  1147,    -1,    22,  1003,    -1,    72,    -1,
      87,    -1,    83,    -1,    81,    -1,    82,    -1,    76,    -1,
      77,    -1,    78,    -1,    75,    -1,    84,    -1,    80,    -1,
      71,    -1,    79,    -1,  1003,    -1,  1035,    -1,  1160,    -1,
     502,   503,    -1,   502,  1156,   503,    -1,  1155,    -1,  1156,
    1155,    -1,  1158,    -1,  1157,   505,  1158,    -1,  1156,    -1,
     508,  1157,   509,    -1,  1160,    -1,   502,    -1,   503,    -1,
     505,    -1,   506,    -1,  1153,    -1,  1011,    -1,  1150,    -1,
    1151,    -1,   495,    -1,   493,    -1,   494,    -1,   496,    -1,
     497,    -1,   319,    -1,    47,    -1,    48,    -1,    49,    -1,
      50,    -1,    51,    -1,    52,    -1,    53,    -1,    54,    -1,
      55,    -1,    56,    -1,    57,    -1,    58,    -1,    60,    -1,
      59,    -1,    61,    -1,    62,    -1,    63,    -1,    64,    -1,
      65,    -1,    66,    -1,    67,    -1,    68,    -1,    70,    -1,
      69,    -1,     5,    -1,   205,    -1,   240,    -1,   262,    -1,
      25,    -1,   295,    -1,   298,    -1,   390,    -1,    35,    -1,
      36,    -1,    43,    -1,    44,    -1,   483,    -1,   133,    -1,
     220,    -1,   432,    -1,   445,    -1,   458,    -1,   500,    -1,
     501,    -1,   489,    -1,   507,    -1,   177,  1039,    -1,   177,
     352,  1039,    -1,   177,    99,    -1,   177,   352,    99,    -1,
    1011,    -1,   502,  1162,   503,    -1,  1162,   493,  1162,    -1,
    1162,   494,  1162,    -1,  1162,   495,  1162,    -1,  1162,   496,
    1162,    -1,  1162,   497,  1162,    -1,  1151,    -1,  1131,    -1,
      -1,  1088,  1164,    -1,  1164,  1088,    -1,  1088,    -1,  1164,
      -1,   266,  1139,    -1,  1090,    -1,  1164,    -1,  1089,    -1,
      -1,  1165,    -1
};

/* YYRLINE[YYN] -- source line where rule number YYN was defined.  */
static const unsigned short yyrline[] =
{
       0,  1340,  1340,  1343,  1345,  1347,  1349,  1351,  1353,  1355,
    1357,  1359,  1361,  1363,  1365,  1367,  1369,  1371,  1373,  1375,
    1377,  1379,  1381,  1383,  1385,  1403,  1405,  1407,  1409,  1411,
    1413,  1415,  1417,  1419,  1421,  1423,  1425,  1427,  1429,  1431,
    1433,  1435,  1437,  1439,  1441,  1443,  1445,  1447,  1449,  1451,
    1453,  1455,  1462,  1464,  1466,  1468,  1470,  1472,  1474,  1476,
    1478,  1480,  1482,  1484,  1486,  1488,  1490,  1492,  1494,  1496,
    1498,  1500,  1502,  1504,  1506,  1508,  1510,  1512,  1514,  1516,
    1518,  1520,  1522,  1524,  1526,  1528,  1535,  1537,  1539,  1541,
    1543,  1545,  1547,  1549,  1551,  1553,  1555,  1561,  1563,  1565,
    1567,  1569,  1571,  1573,  1575,  1577,  1583,  1593,  1597,  1605,
    1609,  1619,  1629,  1630,  1644,  1651,  1657,  1668,  1674,  1683,
    1690,  1696,  1705,  1712,  1720,  1725,  1733,  1738,  1744,  1749,
    1755,  1760,  1766,  1770,  1774,  1778,  1782,  1786,  1790,  1794,
    1798,  1802,  1806,  1810,  1814,  1818,  1822,  1826,  1830,  1834,
    1838,  1846,  1850,  1854,  1858,  1862,  1866,  1874,  1882,  1891,
    1893,  1901,  1909,  1917,  1925,  1929,  1937,  1941,  1949,  1957,
    1965,  1969,  1977,  1981,  1989,  1993,  2001,  2006,  2012,  2017,
    2023,  2027,  2031,  2035,  2039,  2043,  2051,  2055,  2059,  2067,
    2071,  2075,  2079,  2083,  2087,  2091,  2095,  2099,  2104,  2108,
    2112,  2116,  2120,  2124,  2132,  2136,  2144,  2148,  2156,  2160,
    2164,  2178,  2182,  2186,  2190,  2198,  2202,  2206,  2210,  2218,
    2222,  2226,  2230,  2234,  2238,  2242,  2250,  2254,  2259,  2265,
    2269,  2277,  2281,  2285,  2289,  2293,  2301,  2305,  2313,  2317,
    2321,  2325,  2329,  2338,  2346,  2350,  2358,  2362,  2370,  2378,
    2382,  2386,  2390,  2398,  2402,  2406,  2410,  2418,  2422,  2430,
    2434,  2438,  2442,  2446,  2450,  2454,  2458,  2462,  2466,  2470,
    2474,  2478,  2482,  2486,  2490,  2494,  2498,  2502,  2506,  2510,
    2514,  2518,  2522,  2526,  2530,  2534,  2538,  2542,  2546,  2550,
    2554,  2558,  2562,  2566,  2570,  2574,  2582,  2586,  2594,  2598,
    2603,  2609,  2614,  2620,  2628,  2633,  2639,  2643,  2651,  2655,
    2659,  2663,  2671,  2676,  2684,  2695,  2706,  2710,  2718,  2722,
    2726,  2734,  2738,  2746,  2751,  2757,  2761,  2765,  2769,  2773,
    2777,  2781,  2785,  2789,  2793,  2797,  2805,  2810,  2816,  2821,
    2827,  2832,  2838,  2843,  2849,  2853,  2861,  2869,  2873,  2877,
    2881,  2885,  2890,  2896,  2900,  2908,  2912,  2920,  2924,  2932,
    2936,  2940,  2944,  2948,  2952,  2957,  2963,  2968,  2974,  2979,
    2985,  2989,  2997,  3001,  3009,  3013,  3017,  3025,  3029,  3037,
    3045,  3053,  3058,  3064,  3068,  3072,  3080,  3084,  3088,  3092,
    3096,  3100,  3104,  3112,  3116,  3120,  3124,  3132,  3140,  3144,
    3149,  3155,  3159,  3163,  3167,  3171,  3175,  3183,  3187,  3195,
    3200,  3204,  3208,  3212,  3220,  3225,  3231,  3235,  3243,  3251,
    3255,  3260,  3265,  3271,  3275,  3283,  3287,  3295,  3300,  3306,
    3310,  3314,  3318,  3323,  3329,  3337,  3345,  3349,  3353,  3357,
    3361,  3369,  3374,  3380,  3384,  3388,  3393,  3399,  3403,  3407,
    3412,  3418,  3423,  3429,  3434,  3440,  3448,  3453,  3459,  3463,
    3471,  3479,  3483,  3488,  3494,  3502,  3510,  3515,  3521,  3525,
    3533,  3537,  3541,  3545,  3549,  3553,  3557,  3561,  3565,  3569,
    3573,  3577,  3585,  3590,  3596,  3600,  3604,  3612,  3616,  3624,
    3628,  3636,  3641,  3647,  3651,  3659,  3664,  3670,  3674,  3682,
    3687,  3693,  3697,  3705,  3710,  3716,  3724,  3729,  3735,  3739,
    3747,  3755,  3759,  3767,  3771,  3775,  3783,  3788,  3794,  3798,
    3806,  3814,  3818,  3826,  3830,  3834,  3838,  3846,  3854,  3862,
    3870,  3878,  3883,  3889,  3893,  3901,  3906,  3912,  3916,  3924,
    3928,  3932,  3940,  3948,  3952,  3956,  3964,  3968,  3976,  3984,
    3988,  3996,  4000,  4008,  4012,  4020,  4024,  4028,  4032,  4036,
    4044,  4049,  4055,  4060,  4066,  4070,  4078,  4083,  4089,  4093,
    4098,  4104,  4108,  4112,  4116,  4120,  4124,  4132,  4137,  4143,
    4147,  4154,  4158,  4166,  4172,  4176,  4184,  4188,  4196,  4200,
    4208,  4217,  4226,  4230,  4234,  4238,  4242,  4246,  4250,  4254,
    4258,  4262,  4266,  4274,  4282,  4286,  4294,  4298,  4306,  4310,
    4314,  4318,  4322,  4330,  4334,  4342,  4350,  4354,  4362,  4370,
    4375,  4381,  4385,  4393,  4401,  4405,  4413,  4417,  4421,  4425,
    4429,  4437,  4442,  4448,  4453,  4459,  4465,  4471,  4479,  4483,
    4491,  4495,  4503,  4507,  4515,  4519,  4527,  4531,  4539,  4547,
    4555,  4559,  4567,  4571,  4575,  4579,  4583,  4587,  4591,  4595,
    4599,  4603,  4607,  4611,  4619,  4623,  4631,  4635,  4643,  4647,
    4655,  4663,  4667,  4672,  4678,  4682,  4686,  4690,  4694,  4698,
    4702,  4706,  4710,  4714,  4718,  4722,  4726,  4730,  4734,  4738,
    4742,  4750,  4754,  4758,  4762,  4766,  4770,  4774,  4778,  4782,
    4786,  4790,  4794,  4802,  4806,  4814,  4818,  4822,  4826,  4832,
    4838,  4844,  4850,  4856,  4862,  4868,  4878,  4889,  4900,  4911,
    4922,  4933,  4944,  4960,  4976,  4992,  5003,  5019,  5030,  5046,
    5061,  5065,  5073,  5078,  5084,  5092,  5096,  5104,  5108,  5112,
    5116,  5120,  5128,  5132,  5140,  5144,  5148,  5152,  5160,  5164,
    5168,  5172,  5176,  5180,  5184,  5188,  5192,  5196,  5200,  5204,
    5208,  5212,  5220,  5224,  5232,  5236,  5244,  5249,  5255,  5259,
    5267,  5275,  5283,  5287,  5295,  5300,  5306,  5311,  5317,  5325,
    5330,  5336,  5340,  5344,  5352,  5356,  5360,  5368,  5372,  5376,
    5384,  5392,  5397,  5403,  5408,  5414,  5419,  5425,  5430,  5436,
    5440,  5448,  5452,  5456,  5464,  5468,  5473,  5479,  5483,  5488,
    5494,  5498,  5503,  5509,  5513,  5517,  5525,  5530,  5536,  5540,
    5548,  5552,  5560,  5564,  5572,  5576,  5584,  5588,  5592,  5596,
    5600,  5608,  5612,  5616,  5620,  5624,  5632,  5640,  5648,  5652,
    5656,  5664,  5668,  5672,  5680,  5684,  5692,  5696,  5700,  5704,
    5708,  5712,  5716,  5720,  5724,  5728,  5732,  5736,  5740,  5748,
    5752,  5756,  5760,  5768,  5772,  5780,  5785,  5791,  5799,  5803,
    5811,  5819,  5823,  5831,  5836,  5842,  5846,  5854,  5858,  5866,
    5870,  5878,  5882,  5886,  5890,  5898,  5902,  5910,  5918,  5922,
    5930,  5934,  5942,  5946,  5950,  5958,  5962,  5967,  5973,  5981,
    5986,  5992,  5996,  6000,  6008,  6012,  6020,  6025,  6031,  6035,
    6039,  6043,  6047,  6051,  6055,  6059,  6063,  6067,  6071,  6075,
    6079,  6083,  6087,  6091,  6095,  6099,  6103,  6107,  6111,  6115,
    6119,  6123,  6127,  6135,  6140,  6146,  6151,  6157,  6161,  6165,
    6169,  6173,  6177,  6181,  6189,  6193,  6197,  6201,  6205,  6209,
    6213,  6217,  6221,  6225,  6229,  6233,  6237,  6241,  6245,  6249,
    6253,  6261,  6269,  6273,  6277,  6285,  6289,  6297,  6301,  6305,
    6309,  6313,  6321,  6326,  6332,  6336,  6340,  6344,  6352,  6356,
    6361,  6367,  6371,  6379,  6387,  6392,  6398,  6406,  6410,  6418,
    6422,  6426,  6430,  6434,  6438,  6442,  6446,  6450,  6454,  6458,
    6462,  6466,  6470,  6478,  6482,  6487,  6493,  6497,  6501,  6509,
    6513,  6517,  6525,  6530,  6536,  6540,  6548,  6553,  6558,  6564,
    6570,  6578,  6586,  6591,  6597,  6601,  6605,  6609,  6613,  6617,
    6621,  6625,  6629,  6633,  6637,  6641,  6645,  6649,  6653,  6657,
    6665,  6670,  6676,  6680,  6688,  6696,  6701,  6707,  6715,  6719,
    6727,  6735,  6739,  6743,  6747,  6751,  6759,  6764,  6770,  6778,
    6782,  6786,  6790,  6794,  6798,  6806,  6814,  6818,  6822,  6830,
    6835,  6841,  6845,  6849,  6853,  6857,  6865,  6869,  6877,  6881,
    6885,  6889,  6897,  6901,  6909,  6913,  6921,  6926,  6932,  6937,
    6943,  6948,  6954,  6959,  6965,  6969,  6973,  6977,  6985,  6989,
    6993,  6997,  7001,  7005,  7009,  7017,  7021,  7029,  7037,  7041,
    7045,  7053,  7057,  7061,  7066,  7072,  7078,  7088,  7093,  7099,
    7103,  7107,  7111,  7119,  7121,  7129,  7134,  7140,  7148,  7152,
    7156,  7164,  7168,  7176,  7184,  7189,  7195,  7203,  7208,  7214,
    7222,  7227,  7233,  7237,  7241,  7245,  7249,  7253,  7257,  7261,
    7269,  7274,  7280,  7288,  7292,  7300,  7304,  7312,  7320,  7328,
    7336,  7340,  7348,  7400,  7404,  7417,  7419,  7423,  7427,  7431,
    7440,  7446,  7450,  7458,  7462,  7470,  7474,  7482,  7486,  7490,
    7494,  7498,  7502,  7506,  7510,  7518,  7522,  7530,  7534,  7538,
    7542,  7546,  7550,  7558,  7562,  7570,  7574,  7582,  7590,  7595,
    7597,  7603,  7607,  7611,  7615,  7619,  7623,  7627,  7631,  7639,
    7644,  7650,  7654,  7659,  7665,  7669,  7673,  7678,  7684,  7689,
    7695,  7703,  7707,  7715,  7719,  7727,  7731,  7735,  7739,  7747,
    7752,  7758,  7762,  7767,  7775,  7779,  7787,  7791,  7799,  7807,
    7811,  7816,  7822,  7830,  7834,  7842,  7846,  7854,  7859,  7865,
    7870,  7876,  7880,  7888,  7893,  7899,  7903,  7911,  7915,  7923,
    7928,  7934,  7938,  7946,  7951,  7957,  7961,  7969,  7973,  7977,
    7981,  7985,  7989,  7993,  7997,  8003,  8007,  8011,  8019,  8023,
    8027,  8031,  8035,  8039,  8047,  8051,  8055,  8059,  8067,  8071,
    8075,  8079,  8087,  8092,  8098,  8102,  8110,  8114,  8118,  8122,
    8130,  8134,  8142,  8146,  8150,  8158,  8166,  8171,  8177,  8181,
    8186,  8192,  8196,  8204,  8212,  8214,  8216,  8220,  8224,  8228,
    8236,  8246,  8257,  8266,  8270,  8274,  8278,  8282,  8286,  8290,
    8298,  8302,  8306,  8310,  8318,  8322,  8330,  8335,  8341,  8345,
    8349,  8353,  8357,  8361,  8365,  8369,  8373,  8377,  8381,  8389,
    8394,  8400,  8404,  8412,  8416,  8424,  8432,  8440,  8444,  8452,
    8456,  8464,  8472,  8480,  8484,  8488,  8492,  8496,  8500,  8508,
    8513,  8519,  8524,  8530,  8534,  8538,  8542,  8550,  8558,  8562,
    8567,  8573,  8577,  8581,  8585,  8589,  8593,  8597,  8601,  8605,
    8609,  8613,  8617,  8621,  8626,  8632,  8636,  8644,  8648,  8652,
    8656,  8660,  8664,  8668,  8672,  8676,  8680,  8684,  8688,  8692,
    8696,  8700,  8704,  8708,  8712,  8716,  8720,  8724,  8728,  8732,
    8736,  8740,  8744,  8748,  8752,  8756,  8760,  8764,  8768,  8772,
    8776,  8780,  8784,  8788,  8792,  8796,  8800,  8804,  8808,  8812,
    8816,  8820,  8824,  8828,  8832,  8836,  8840,  8844,  8848,  8852,
    8856,  8860,  8864,  8869,  8873,  8881,  8885,  8889,  8893,  8897,
    8901,  8905,  8909,  8913,  8917,  8921,  8925,  8929,  8933,  8937,
    8941,  8945,  8949,  8953,  8957,  8961,  8965,  8973,  8977,  8981,
    8985,  8989,  8993,  8997,  9001,  9005,  9009,  9013,  9021,  9025,
    9029,  9033,  9037,  9041,  9045,  9049,  9053,  9057,  9061,  9065,
    9069,  9073,  9077,  9081,  9085,  9089,  9093,  9097,  9101,  9105,
    9109,  9113,  9117,  9121,  9125,  9129,  9133,  9137,  9141,  9145,
    9149,  9153,  9157,  9161,  9165,  9169,  9173,  9177,  9181,  9185,
    9189,  9193,  9197,  9201,  9205,  9209,  9217,  9221,  9229,  9233,
    9237,  9242,  9248,  9256,  9260,  9268,  9272,  9280,  9284,  9292,
    9296,  9301,  9307,  9312,  9318,  9322,  9330,  9338,  9342,  9347,
    9353,  9361,  9365,  9372,  9377,  9383,  9388,  9393,  9399,  9403,
    9411,  9415,  9419,  9423,  9427,  9435,  9439,  9443,  9451,  9455,
    9459,  9467,  9471,  9479,  9483,  9487,  9491,  9495,  9499,  9503,
    9507,  9511,  9519,  9523,  9531,  9535,  9543,  9547,  9551,  9555,
    9559,  9563,  9571,  9575,  9583,  9587,  9595,  9599,  9607,  9611,
    9619,  9623,  9627,  9635,  9639,  9647,  9652,  9658,  9662,  9666,
    9670,  9674,  9678,  9682,  9686,  9694,  9698,  9706,  9714,  9719,
    9725,  9729,  9733,  9737,  9741,  9746,  9752,  9760,  9768,  9772,
    9776,  9784,  9788,  9796,  9804,  9808,  9816,  9824,  9829,  9835,
    9840,  9846,  9850,  9858,  9862,  9866,  9870,  9878,  9882,  9891,
    9893,  9901,  9906,  9912,  9916,  9924,  9928,  9936,  9944,  9948,
    9956,  9960,  9964,  9968,  9976,  9980,  9988,  9992, 10000, 10004,
   10012, 10020, 10028, 10036, 10044, 10052, 10060, 10064, 10072, 10076,
   10080, 10084, 10088, 10092, 10096, 10100, 10104, 10108, 10112, 10116,
   10120, 10124, 10125, 10130, 10136, 10144, 10148, 10149, 10153, 10161,
   10165, 10169, 10173, 10177, 10181, 10185, 10189, 10193, 10197, 10201,
   10205, 10209, 10213, 10217, 10221, 10225, 10229, 10233, 10237, 10241,
   10245, 10249, 10253, 10257, 10261, 10265, 10269, 10273, 10277, 10281,
   10285, 10289, 10293, 10297, 10301, 10305, 10309, 10313, 10317, 10321,
   10325, 10329, 10333, 10337, 10341, 10345, 10349, 10353, 10357, 10361,
   10365, 10369, 10373, 10377, 10381, 10385, 10389, 10393, 10397, 10401,
   10405, 10409, 10413, 10417, 10421, 10425, 10429, 10433, 10437, 10441,
   10445, 10449, 10453, 10457, 10461, 10465, 10469, 10473, 10477, 10481,
   10485, 10489, 10493, 10497, 10501, 10505, 10509, 10513, 10517, 10521,
   10525, 10529, 10533, 10537, 10541, 10545, 10549, 10553, 10557, 10561,
   10565, 10569, 10573, 10577, 10581, 10585, 10589, 10593, 10597, 10601,
   10605, 10609, 10613, 10617, 10621, 10625, 10629, 10633, 10637, 10641,
   10645, 10649, 10653, 10657, 10661, 10665, 10669, 10673, 10677, 10681,
   10685, 10689, 10693, 10697, 10701, 10705, 10709, 10713, 10717, 10721,
   10725, 10729, 10733, 10737, 10741, 10745, 10749, 10753, 10757, 10761,
   10765, 10769, 10773, 10777, 10781, 10785, 10789, 10793, 10797, 10801,
   10805, 10809, 10813, 10817, 10821, 10825, 10829, 10833, 10837, 10841,
   10845, 10849, 10853, 10857, 10861, 10865, 10869, 10873, 10877, 10881,
   10885, 10889, 10893, 10897, 10901, 10905, 10909, 10913, 10917, 10921,
   10925, 10929, 10933, 10937, 10941, 10945, 10949, 10953, 10957, 10961,
   10965, 10969, 10973, 10977, 10981, 10985, 10989, 10993, 10997, 11001,
   11005, 11009, 11013, 11017, 11021, 11025, 11029, 11033, 11037, 11041,
   11045, 11049, 11053, 11057, 11061, 11065, 11069, 11073, 11077, 11081,
   11085, 11089, 11093, 11097, 11101, 11105, 11109, 11113, 11117, 11121,
   11129, 11133, 11137, 11141, 11145, 11149, 11153, 11157, 11161, 11165,
   11169, 11173, 11177, 11181, 11185, 11189, 11193, 11197, 11201, 11205,
   11209, 11213, 11217, 11221, 11225, 11229, 11233, 11237, 11241, 11245,
   11249, 11253, 11257, 11261, 11265, 11269, 11273, 11277, 11281, 11285,
   11289, 11293, 11297, 11305, 11309, 11313, 11317, 11321, 11325, 11329,
   11333, 11337, 11341, 11345, 11349, 11353, 11357, 11361, 11365, 11369,
   11373, 11377, 11381, 11385, 11389, 11397, 11401, 11405, 11409, 11413,
   11417, 11421, 11425, 11429, 11433, 11437, 11441, 11445, 11449, 11453,
   11457, 11461, 11465, 11469, 11473, 11477, 11481, 11485, 11489, 11493,
   11497, 11501, 11505, 11509, 11513, 11517, 11521, 11525, 11529, 11533,
   11537, 11541, 11545, 11549, 11553, 11557, 11561, 11565, 11569, 11573,
   11577, 11581, 11585, 11589, 11593, 11597, 11601, 11605, 11609, 11613,
   11617, 11621, 11625, 11629, 11633, 11637, 11641, 11645, 11649, 11653,
   11657, 11661, 11665, 11669, 11673, 11677, 11681, 11685, 11689, 11693,
   11703, 11704, 11707, 11708, 11709, 11715, 11716, 11717, 11718, 11719,
   11732, 11732, 11741, 11757, 11759, 11762, 11764, 11768, 11780, 11796,
   11800, 11811, 11812, 11815, 11827, 11836, 11837, 11840, 11841, 11842,
   11845, 11846, 11849, 11850, 11853, 11854, 11857, 11859, 11861, 11863,
   11867, 11874, 11881, 11897, 11931, 11941, 11944, 11946, 11959, 11960,
   11962, 11964, 11968, 11981, 11988, 12048, 12057, 12059, 12060, 12063,
   12065, 12066, 12069, 12070, 12071, 12072, 12073, 12080, 12079, 12089,
   12091, 12093, 12094, 12097, 12098, 12099, 12100, 12103, 12104, 12108,
   12107, 12124, 12122, 12138, 12137, 12151, 12157, 12158, 12161, 12163,
   12164, 12167, 12168, 12169, 12170, 12173, 12174, 12177, 12185, 12202,
   12210, 12233, 12339, 12373, 12375, 12377, 12381, 12385, 12384, 12435,
   12437, 12436, 12451, 12457, 12464, 12469, 12472, 12473, 12476, 12477,
   12478, 12479, 12480, 12481, 12482, 12490, 12498, 12501, 12502, 12503,
   12504, 12505, 12506, 12514, 12522, 12523, 12524, 12527, 12528, 12531,
   12533, 12537, 12625, 12626, 12633, 12634, 12635, 12641, 12650, 12653,
   12654, 12655, 12656, 12659, 12660, 12661, 12664, 12666, 12674, 12675,
   12681, 12689, 12690, 12693, 12694, 12697, 12702, 12709, 12714, 12721,
   12728, 12728, 12730, 12737, 12738, 12741, 12742, 12743, 12744, 12745,
   12746, 12747, 12748, 12749, 12755, 12762, 12774, 12780, 12787, 12795,
   12796, 12808, 12819, 12830, 12834, 12835, 12838, 12843, 12847, 12848,
   12851, 12857, 12865, 12868, 12875, 12879, 12880, 12883, 12886, 12890,
   12891, 12894, 12900, 12908, 12909, 12918, 12927, 12939, 12940, 12941,
   12942, 12943, 12944, 12945, 12946, 12947, 12948, 12949, 12950, 12951,
   12952, 12953, 12960, 12961, 12964, 12965, 12972, 12973, 12974, 12981,
   12980, 12997, 12998, 13005, 13004, 13074, 13080, 13086, 13094, 13100,
   13106, 13112, 13118, 13124, 13130, 13136, 13142, 13153, 13154, 13157,
   13158, 13159, 13160, 13161, 13162, 13163, 13164, 13165, 13166, 13167,
   13168, 13169, 13170, 13171, 13172, 13173, 13174, 13175, 13176, 13177,
   13178, 13179, 13180, 13183, 13184, 13185, 13186, 13187, 13188, 13192,
   13193, 13194, 13195, 13196, 13197, 13198, 13201, 13204, 13205, 13206,
   13207, 13208, 13209, 13210, 13211, 13224, 13225, 13226, 13227, 13228,
   13229, 13230, 13235, 13236, 13237, 13238, 13239, 13240, 13246, 13247,
   13248, 13249, 13250, 13251, 13252, 13253, 13254, 13255, 13256, 13259,
   13260, 13261, 13262, 13263, 13266, 13267, 13268, 13269, 13272, 13273,
   13274, 13275, 13276, 13277, 13278, 13295, 13296, 13297, 13300, 13301,
   13302, 13303, 13304, 13305, 13309, 13309, 13312, 13318, 13319, 13322,
   13324, 13329, 13339, 13350, 13357, 13358, 13359, 13362, 13395, 13397,
   13399, 13402, 13412, 13422, 13432, 13433, 13436, 13438, 13439, 13440,
   13443, 13445, 13453, 13454, 13455, 13459, 13460, 13464, 13465, 13468,
   13469, 13472, 13473, 13474, 13475, 13476, 13479, 13480, 13481, 13482,
   13483, 13484, 13485, 13486, 13487, 13488, 13489, 13490, 13491, 13492,
   13493, 13494, 13495, 13496, 13497, 13498, 13499, 13500, 13501, 13502,
   13503, 13504, 13505, 13506, 13507, 13508, 13509, 13510, 13511, 13512,
   13513, 13514, 13515, 13516, 13517, 13518, 13519, 13520, 13521, 13522,
   13523, 13524, 13525, 13526, 13527, 13528, 13529, 13530, 13531, 13532,
   13533, 13534, 13537, 13538, 13539, 13540, 13543, 13544, 13545, 13546,
   13547, 13548, 13549, 13550, 13551, 13554, 13555, 13556, 13557, 13558,
   13561, 13562, 13565, 13566, 13577, 13578
};
#endif

#if YYDEBUG || YYERROR_VERBOSE
/* YYTNME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals. */
static const char *const yytname[] =
{
  "$end", "error", "$undefined", "SQL_ALLOCATE", "SQL_AUTOCOMMIT", 
  "SQL_BOOL", "SQL_BREAK", "SQL_CALL", "SQL_CARDINALITY", "SQL_CONNECT", 
  "SQL_COUNT", "SQL_DATETIME_INTERVAL_CODE", 
  "SQL_DATETIME_INTERVAL_PRECISION", "SQL_DESCRIBE", "SQL_DESCRIPTOR", 
  "SQL_DISCONNECT", "SQL_FOUND", "SQL_FREE", "SQL_GET", "SQL_GO", 
  "SQL_GOTO", "SQL_IDENTIFIED", "SQL_INDICATOR", "SQL_KEY_MEMBER", 
  "SQL_LENGTH", "SQL_LONG", "SQL_NULLABLE", "SQL_OCTET_LENGTH", 
  "SQL_OPEN", "SQL_OUTPUT", "SQL_REFERENCE", "SQL_RETURNED_LENGTH", 
  "SQL_RETURNED_OCTET_LENGTH", "SQL_SCALE", "SQL_SECTION", "SQL_SHORT", 
  "SQL_SIGNED", "SQL_SQL", "SQL_SQLERROR", "SQL_SQLPRINT", 
  "SQL_SQLWARNING", "SQL_START", "SQL_STOP", "SQL_STRUCT", "SQL_UNSIGNED", 
  "SQL_VAR", "SQL_WHENEVER", "S_ADD", "S_AND", "S_ANYTHING", "S_AUTO", 
  "S_CONST", "S_DEC", "S_DIV", "S_DOTPOINT", "S_EQUAL", "S_EXTERN", 
  "S_INC", "S_LSHIFT", "S_MEMPOINT", "S_MEMBER", "S_MOD", "S_MUL", 
  "S_NEQUAL", "S_OR", "S_REGISTER", "S_RSHIFT", "S_STATIC", "S_SUB", 
  "S_VOLATILE", "S_TYPEDEF", "CSTRING", "CVARIABLE", "CPP_LINE", "IP", 
  "DOLCONST", "ECONST", "NCONST", "UCONST", "UIDENT", "IDENT", "FCONST", 
  "SCONST", "BCONST", "XCONST", "Op", "ICONST", "PARAM", "TYPECAST", 
  "DOT_DOT", "COLON_EQUALS", "ABORT_P", "ABSOLUTE_P", "ACCESS", "ACTION", 
  "ADD_P", "ADMIN", "AFTER", "AGGREGATE", "ALL", "ALSO", "ALTER", 
  "ALWAYS", "ANALYSE", "ANALYZE", "AND", "ANY", "ARRAY", "AS", "ASC", 
  "ASSERTION", "ASSIGNMENT", "ASYMMETRIC", "AT", "AUTHORIZATION", 
  "BACKWARD", "BEFORE", "BEGIN_P", "BETWEEN", "BIGINT", "BINARY", "BIT", 
  "BOOLEAN_P", "BOTH", "BY", "CACHE", "CALLED", "CASCADE", "CASCADED", 
  "CASE", "CAST", "CATALOG_P", "CHAIN", "CHAR_P", "CHARACTER", 
  "CHARACTERISTICS", "CHECK", "CHECKPOINT", "CLASS", "CLOSE", "CLUSTER", 
  "COALESCE", "COLLATE", "COLUMN", "COMMENT", "COMMENTS", "COMMIT", 
  "COMMITTED", "CONCURRENTLY", "CONFIGURATION", "CONNECTION", 
  "CONSTRAINT", "CONSTRAINTS", "CONTENT_P", "CONTINUE_P", "CONVERSION_P", 
  "COPY", "COST", "CREATE", "CREATEDB", "CREATEROLE", "CREATEUSER", 
  "CROSS", "CSV", "CURRENT_P", "CURRENT_CATALOG", "CURRENT_DATE", 
  "CURRENT_ROLE", "CURRENT_SCHEMA", "CURRENT_TIME", "CURRENT_TIMESTAMP", 
  "CURRENT_USER", "CURSOR", "CYCLE", "DATA_P", "DATABASE", "DAY_P", 
  "DEALLOCATE", "DEC", "DECIMAL_P", "DECLARE", "DEFAULT", "DEFAULTS", 
  "DEFERRABLE", "DEFERRED", "DEFINER", "DELETE_P", "DELIMITER", 
  "DELIMITERS", "DESC", "DICTIONARY", "DISABLE_P", "DISCARD", "DISTINCT", 
  "DO", "DOCUMENT_P", "DOMAIN_P", "DOUBLE_P", "DROP", "EACH", "ELSE", 
  "ENABLE_P", "ENCODING", "ENCRYPTED", "END_P", "ENUM_P", "ESCAPE", 
  "EXCEPT", "EXCLUDE", "EXCLUDING", "EXCLUSIVE", "EXECUTE", "EXISTS", 
  "EXPLAIN", "EXTERNAL", "EXTRACT", "FALSE_P", "FAMILY", "FETCH", 
  "FIRST_P", "FLOAT_P", "FOLLOWING", "FOR", "FORCE", "FOREIGN", "FORWARD", 
  "FREEZE", "FROM", "FULL", "FUNCTION", "FUNCTIONS", "GLOBAL", "GRANT", 
  "GRANTED", "GREATEST", "GROUP_P", "HANDLER", "HAVING", "HEADER_P", 
  "HOLD", "HOUR_P", "IDENTITY_P", "IF_P", "ILIKE", "IMMEDIATE", 
  "IMMUTABLE", "IMPLICIT_P", "IN_P", "INCLUDING", "INCREMENT", "INDEX", 
  "INDEXES", "INHERIT", "INHERITS", "INITIALLY", "INLINE_P", "INNER_P", 
  "INOUT", "INPUT_P", "INSENSITIVE", "INSERT", "INSTEAD", "INT_P", 
  "INTEGER", "INTERSECT", "INTERVAL", "INTO", "INVOKER", "IS", "ISNULL", 
  "ISOLATION", "JOIN", "KEY", "LANGUAGE", "LARGE_P", "LAST_P", 
  "LC_COLLATE_P", "LC_CTYPE_P", "LEADING", "LEAST", "LEFT", "LEVEL", 
  "LIKE", "LIMIT", "LISTEN", "LOAD", "LOCAL", "LOCALTIME", 
  "LOCALTIMESTAMP", "LOCATION", "LOCK_P", "LOGIN_P", "MAPPING", "MATCH", 
  "MAXVALUE", "MINUTE_P", "MINVALUE", "MODE", "MONTH_P", "MOVE", "NAME_P", 
  "NAMES", "NATIONAL", "NATURAL", "NCHAR", "NEXT", "NO", "NOCREATEDB", 
  "NOCREATEROLE", "NOCREATEUSER", "NOINHERIT", "NOLOGIN_P", "NONE", 
  "NOSUPERUSER", "NOT", "NOTHING", "NOTIFY", "NOTNULL", "NOWAIT", 
  "NULL_P", "NULLIF", "NULLS_P", "NUMERIC", "OBJECT_P", "OF", "OFF", 
  "OFFSET", "OIDS", "ON", "ONLY", "OPERATOR", "OPTION", "OPTIONS", "OR", 
  "ORDER", "OUT_P", "OUTER_P", "OVER", "OVERLAPS", "OVERLAY", "OWNED", 
  "OWNER", "PARSER", "PARTIAL", "PARTITION", "PASSWORD", "PLACING", 
  "PLANS", "POSITION", "PRECEDING", "PRECISION", "PRESERVE", "PREPARE", 
  "PREPARED", "PRIMARY", "PRIOR", "PRIVILEGES", "PROCEDURAL", "PROCEDURE", 
  "QUOTE", "RANGE", "READ", "REAL", "REASSIGN", "RECHECK", "RECURSIVE", 
  "REFERENCES", "REINDEX", "RELATIVE_P", "RELEASE", "RENAME", 
  "REPEATABLE", "REPLACE", "REPLICA", "RESET", "RESTART", "RESTRICT", 
  "RETURNING", "RETURNS", "REVOKE", "RIGHT", "ROLE", "ROLLBACK", "ROW", 
  "ROWS", "RULE", "SAVEPOINT", "SCHEMA", "SCROLL", "SEARCH", "SECOND_P", 
  "SECURITY", "SELECT", "SEQUENCE", "SEQUENCES", "SERIALIZABLE", "SERVER", 
  "SESSION", "SESSION_USER", "SET", "SETOF", "SHARE", "SHOW", "SIMILAR", 
  "SIMPLE", "SMALLINT", "SOME", "STABLE", "STANDALONE_P", "START", 
  "STATEMENT", "STATISTICS", "STDIN", "STDOUT", "STORAGE", "STRICT_P", 
  "STRIP_P", "SUBSTRING", "SUPERUSER_P", "SYMMETRIC", "SYSID", "SYSTEM_P", 
  "TABLE", "TABLES", "TABLESPACE", "TEMP", "TEMPLATE", "TEMPORARY", 
  "TEXT_P", "THEN", "TIME", "TIMESTAMP", "TO", "TRAILING", "TRANSACTION", 
  "TREAT", "TRIGGER", "TRIM", "TRUE_P", "TRUNCATE", "TRUSTED", "TYPE_P", 
  "UNBOUNDED", "UNCOMMITTED", "UNENCRYPTED", "UNION", "UNIQUE", "UNKNOWN", 
  "UNLISTEN", "UNTIL", "UPDATE", "USER", "USING", "VACUUM", "VALID", 
  "VALIDATOR", "VALUE_P", "VALUES", "VARCHAR", "VARIADIC", "VARYING", 
  "VERBOSE", "VERSION_P", "VIEW", "VOLATILE", "WHEN", "WHERE", 
  "WHITESPACE_P", "WINDOW", "WITH", "WITHOUT", "WORK", "WRAPPER", "WRITE", 
  "XML_P", "XMLATTRIBUTES", "XMLCONCAT", "XMLELEMENT", "XMLFOREST", 
  "XMLPARSE", "XMLPI", "XMLROOT", "XMLSERIALIZE", "YEAR_P", "YES_P", 
  "ZONE", "NULLS_FIRST", "NULLS_LAST", "WITH_TIME", "'='", "'<'", "'>'", 
  "POSTFIXOP", "'+'", "'-'", "'*'", "'/'", "'%'", "'^'", "UMINUS", "'['", 
  "']'", "'('", "')'", "'.'", "','", "';'", "':'", "'{'", "'}'", 
  "$accept", "prog", "stmt", "CreateRoleStmt", "opt_with", "OptRoleList", 
  "AlterOptRoleList", "AlterOptRoleElem", "CreateOptRoleElem", 
  "CreateUserStmt", "AlterRoleStmt", "opt_in_database", 
  "AlterRoleSetStmt", "AlterUserStmt", "AlterUserSetStmt", "DropRoleStmt", 
  "DropUserStmt", "CreateGroupStmt", "AlterGroupStmt", "add_drop", 
  "DropGroupStmt", "CreateSchemaStmt", "OptSchemaName", 
  "OptSchemaEltList", "schema_stmt", "VariableSetStmt", "set_rest", 
  "var_name", "var_list", "var_value", "iso_level", "opt_boolean", 
  "zone_value", "opt_encoding", "ColId_or_Sconst", "VariableResetStmt", 
  "SetResetClause", "VariableShowStmt", "ConstraintsSetStmt", 
  "constraints_set_list", "constraints_set_mode", "CheckPointStmt", 
  "DiscardStmt", "AlterTableStmt", "alter_table_cmds", "alter_table_cmd", 
  "alter_column_default", "opt_drop_behavior", "alter_using", 
  "reloptions", "opt_reloptions", "reloption_list", "reloption_elem", 
  "ClosePortalStmt", "CopyStmt", "copy_from", "copy_file_name", 
  "copy_options", "copy_opt_list", "copy_opt_item", "opt_binary", 
  "opt_oids", "copy_delimiter", "opt_using", "copy_generic_opt_list", 
  "copy_generic_opt_elem", "copy_generic_opt_arg", 
  "copy_generic_opt_arg_list", "copy_generic_opt_arg_list_item", 
  "CreateStmt", "OptTemp", "OptTableElementList", 
  "OptTypedTableElementList", "TableElementList", "TypedTableElementList", 
  "TableElement", "TypedTableElement", "columnDef", "columnOptions", 
  "ColQualList", "ColConstraint", "ColConstraintElem", "ConstraintAttr", 
  "TableLikeClause", "TableLikeOptionList", "TableLikeOption", 
  "TableConstraint", "ConstraintElem", "opt_column_list", "columnList", 
  "columnElem", "key_match", "ExclusionConstraintList", 
  "ExclusionConstraintElem", "ExclusionWhereClause", "key_actions", 
  "key_update", "key_delete", "key_action", "OptInherit", "OptWith", 
  "OnCommitOption", "OptTableSpace", "OptConsTableSpace", 
  "create_as_target", "OptCreateAs", "CreateAsList", "CreateAsElement", 
  "opt_with_data", "CreateSeqStmt", "AlterSeqStmt", "OptSeqOptList", 
  "SeqOptList", "SeqOptElem", "opt_by", "NumericOnly", "NumericOnly_list", 
  "CreatePLangStmt", "opt_trusted", "handler_name", "opt_inline_handler", 
  "validator_clause", "opt_validator", "DropPLangStmt", "opt_procedural", 
  "CreateTableSpaceStmt", "OptTableSpaceOwner", "DropTableSpaceStmt", 
  "CreateFdwStmt", "DropFdwStmt", "AlterFdwStmt", 
  "create_generic_options", "generic_option_list", 
  "alter_generic_options", "alter_generic_option_list", 
  "alter_generic_option_elem", "generic_option_elem", 
  "generic_option_name", "generic_option_arg", "CreateForeignServerStmt", 
  "opt_type", "foreign_server_version", "opt_foreign_server_version", 
  "DropForeignServerStmt", "AlterForeignServerStmt", 
  "CreateUserMappingStmt", "auth_ident", "DropUserMappingStmt", 
  "AlterUserMappingStmt", "CreateTrigStmt", "TriggerActionTime", 
  "TriggerEvents", "TriggerOneEvent", "TriggerForSpec", "TriggerForOpt", 
  "TriggerForType", "TriggerWhen", "TriggerFuncArgs", "TriggerFuncArg", 
  "OptConstrFromTable", "ConstraintAttributeSpec", 
  "ConstraintDeferrabilitySpec", "ConstraintTimeSpec", "DropTrigStmt", 
  "CreateAssertStmt", "DropAssertStmt", "DefineStmt", "definition", 
  "def_list", "def_elem", "def_arg", "aggr_args", "old_aggr_definition", 
  "old_aggr_list", "old_aggr_elem", "opt_enum_val_list", "enum_val_list", 
  "CreateOpClassStmt", "opclass_item_list", "opclass_item", "opt_default", 
  "opt_opfamily", "opt_recheck", "CreateOpFamilyStmt", 
  "AlterOpFamilyStmt", "opclass_drop_list", "opclass_drop", 
  "DropOpClassStmt", "DropOpFamilyStmt", "DropOwnedStmt", 
  "ReassignOwnedStmt", "DropStmt", "drop_type", "any_name_list", 
  "any_name", "attrs", "TruncateStmt", "opt_restart_seqs", "CommentStmt", 
  "comment_type", "comment_text", "FetchStmt", "fetch_args", "from_in", 
  "opt_from_in", "GrantStmt", "RevokeStmt", "privileges", 
  "privilege_list", "privilege", "privilege_target", "grantee_list", 
  "grantee", "opt_grant_grant_option", "function_with_argtypes_list", 
  "function_with_argtypes", "GrantRoleStmt", "RevokeRoleStmt", 
  "opt_grant_admin_option", "opt_granted_by", 
  "AlterDefaultPrivilegesStmt", "DefACLOptionList", "DefACLOption", 
  "DefACLAction", "defacl_privilege_target", "IndexStmt", "opt_unique", 
  "opt_concurrently", "opt_index_name", "access_method_clause", 
  "index_params", "index_elem", "opt_class", "opt_asc_desc", 
  "opt_nulls_order", "CreateFunctionStmt", "opt_or_replace", "func_args", 
  "func_args_list", "func_args_with_defaults", 
  "func_args_with_defaults_list", "func_arg", "arg_class", "param_name", 
  "func_return", "func_type", "func_arg_with_default", 
  "createfunc_opt_list", "common_func_opt_item", "createfunc_opt_item", 
  "func_as", "opt_definition", "table_func_column", 
  "table_func_column_list", "AlterFunctionStmt", "alterfunc_opt_list", 
  "opt_restrict", "RemoveFuncStmt", "RemoveAggrStmt", "RemoveOperStmt", 
  "oper_argtypes", "any_operator", "DoStmt", "dostmt_opt_list", 
  "dostmt_opt_item", "CreateCastStmt", "cast_context", "DropCastStmt", 
  "opt_if_exists", "ReindexStmt", "reindex_type", "opt_force", 
  "RenameStmt", "opt_column", "opt_set_data", "AlterObjectSchemaStmt", 
  "AlterOwnerStmt", "RuleStmt", "RuleActionList", "RuleActionMulti", 
  "RuleActionStmt", "RuleActionStmtOrEmpty", "event", "opt_instead", 
  "DropRuleStmt", "NotifyStmt", "notify_payload", "ListenStmt", 
  "UnlistenStmt", "TransactionStmt", "opt_transaction", 
  "transaction_mode_item", "transaction_mode_list", 
  "transaction_mode_list_or_empty", "ViewStmt", "opt_check_option", 
  "LoadStmt", "CreatedbStmt", "createdb_opt_list", "createdb_opt_item", 
  "opt_equal", "AlterDatabaseStmt", "AlterDatabaseSetStmt", 
  "alterdb_opt_list", "alterdb_opt_item", "DropdbStmt", 
  "CreateDomainStmt", "AlterDomainStmt", "opt_as", 
  "AlterTSDictionaryStmt", "AlterTSConfigurationStmt", 
  "CreateConversionStmt", "ClusterStmt", "cluster_index_specification", 
  "VacuumStmt", "vacuum_option_list", "vacuum_option_elem", "AnalyzeStmt", 
  "analyze_keyword", "opt_verbose", "opt_full", "opt_freeze", 
  "opt_name_list", "ExplainStmt", "ExplainableStmt", 
  "explain_option_list", "explain_option_elem", "explain_option_name", 
  "explain_option_arg", "PrepareStmt", "prep_type_clause", 
  "PreparableStmt", "ExecuteStmt", "execute_param_clause", "InsertStmt", 
  "insert_rest", "insert_column_list", "insert_column_item", 
  "returning_clause", "DeleteStmt", "using_clause", "LockStmt", 
  "opt_lock", "lock_type", "opt_nowait", "UpdateStmt", "set_clause_list", 
  "set_clause", "single_set_clause", "multiple_set_clause", "set_target", 
  "set_target_list", "DeclareCursorStmt", "cursor_name", "cursor_options", 
  "opt_hold", "SelectStmt", "select_with_parens", "select_no_parens", 
  "select_clause", "simple_select", "with_clause", "cte_list", 
  "common_table_expr", "into_clause", "OptTempTableName", "opt_table", 
  "opt_all", "opt_distinct", "opt_sort_clause", "sort_clause", 
  "sortby_list", "sortby", "select_limit", "opt_select_limit", 
  "limit_clause", "offset_clause", "select_limit_value", 
  "select_offset_value", "opt_select_fetch_first_value", 
  "select_offset_value2", "row_or_rows", "first_or_next", "group_clause", 
  "having_clause", "for_locking_clause", "opt_for_locking_clause", 
  "for_locking_items", "for_locking_item", "locked_rels_list", 
  "values_clause", "from_clause", "from_list", "table_ref", 
  "joined_table", "alias_clause", "join_type", "join_outer", "join_qual", 
  "relation_expr", "relation_expr_list", "relation_expr_opt_alias", 
  "func_table", "where_clause", "where_or_current_clause", 
  "TableFuncElementList", "TableFuncElement", "Typename", 
  "opt_array_bounds", "SimpleTypename", "ConstTypename", "GenericType", 
  "opt_type_modifiers", "Numeric", "opt_float", "Bit", "ConstBit", 
  "BitWithLength", "BitWithoutLength", "Character", "ConstCharacter", 
  "CharacterWithLength", "CharacterWithoutLength", "character", 
  "opt_varying", "opt_charset", "ConstDatetime", "ConstInterval", 
  "opt_timezone", "opt_interval", "interval_second", "a_expr", "b_expr", 
  "c_expr", "func_expr", "xml_root_version", "opt_xml_root_standalone", 
  "xml_attributes", "xml_attribute_list", "xml_attribute_el", 
  "document_or_content", "xml_whitespace_option", "window_clause", 
  "window_definition_list", "window_definition", "over_clause", 
  "window_specification", "opt_existing_window_name", 
  "opt_partition_clause", "opt_frame_clause", "frame_extent", 
  "frame_bound", "row", "sub_type", "all_Op", "MathOp", "qual_Op", 
  "qual_all_Op", "subquery_Op", "expr_list", "func_arg_list", 
  "func_arg_expr", "type_list", "array_expr", "array_expr_list", 
  "extract_list", "extract_arg", "overlay_list", "overlay_placing", 
  "position_list", "substr_list", "substr_from", "substr_for", 
  "trim_list", "in_expr", "case_expr", "when_clause_list", "when_clause", 
  "case_default", "case_arg", "columnref", "indirection_el", 
  "indirection", "opt_indirection", "opt_asymmetric", "ctext_expr", 
  "ctext_expr_list", "ctext_row", "target_list", "target_el", 
  "qualified_name_list", "qualified_name", "name_list", "name", 
  "database_name", "access_method", "attr_name", "index_name", 
  "file_name", "func_name", "AexprConst", "Iconst", "RoleId", 
  "SignedIconst", "unreserved_keyword", "col_name_keyword", 
  "type_func_name_keyword", "reserved_keyword", "statements", "statement", 
  "CreateAsStmt", "@1", "at", "ECPGConnect", "connection_target", 
  "opt_database_name", "db_prefix", "server", "opt_server", "server_name", 
  "opt_port", "opt_connection_name", "opt_user", "ora_user", "user_name", 
  "char_variable", "opt_options", "connect_options", "opt_opt_value", 
  "prepared_name", "ECPGCursorStmt", "ECPGExecuteImmediateStmt", 
  "ECPGVarDeclaration", "single_vt_declaration", "precision", "opt_scale", 
  "ecpg_interval", "ECPGDeclaration", "@2", "sql_startdeclare", 
  "sql_enddeclare", "var_type_declarations", "vt_declarations", 
  "variable_declarations", "type_declaration", "@3", "var_declaration", 
  "@4", "@5", "opt_bit_field", "storage_declaration", "storage_clause", 
  "storage_modifier", "var_type", "enum_type", "enum_definition", 
  "struct_union_type_with_symbol", "@6", "struct_union_type", "@7", 
  "s_struct_union_symbol", "s_struct_union", "simple_type", 
  "unsigned_type", "signed_type", "opt_signed", "variable_list", 
  "variable", "opt_initializer", "opt_pointer", "ECPGDeclare", 
  "ECPGDisconnect", "dis_name", "connection_object", "execstring", 
  "ECPGFree", "ECPGOpen", "opt_ecpg_using", "ecpg_using", 
  "using_descriptor", "into_descriptor", "into_sqlda", "using_list", 
  "UsingValue", "UsingConst", "ECPGDescribe", "opt_output", 
  "ECPGAllocateDescr", "ECPGDeallocateDescr", "ECPGGetDescriptorHeader", 
  "ECPGGetDescHeaderItems", "ECPGGetDescHeaderItem", 
  "ECPGSetDescriptorHeader", "ECPGSetDescHeaderItems", 
  "ECPGSetDescHeaderItem", "IntConstVar", "desc_header_item", 
  "ECPGGetDescriptor", "ECPGGetDescItems", "ECPGGetDescItem", 
  "ECPGSetDescriptor", "ECPGSetDescItems", "ECPGSetDescItem", 
  "AllConstVar", "descriptor_item", "ECPGSetAutocommit", "on_off", 
  "ECPGSetConnection", "ECPGTypedef", "@8", "opt_reference", "ECPGVar", 
  "@9", "ECPGWhenever", "action", "ECPGKeywords", "ECPGKeywords_vanames", 
  "ECPGKeywords_rest", "ECPGTypeName", "symbol", "ECPGColId", "ColId", 
  "type_function_name", "ColLabel", "ECPGColLabel", "ECPGColLabelCommon", 
  "ECPGCKeywords", "all_unreserved_keyword", "ECPGunreserved_interval", 
  "into_list", "ecpgstart", "c_args", "coutputvariable", "civarind", 
  "char_civar", "civar", "indicator", "cvariable", "ecpg_param", 
  "ecpg_bconst", "ecpg_fconst", "ecpg_sconst", "ecpg_xconst", 
  "ecpg_ident", "quoted_ident_stringvar", "c_stuff_item", "c_stuff", 
  "c_list", "c_term", "c_thing", "c_anything", "DeallocateStmt", 
  "Iresult", "execute_rest", "ecpg_into", "ecpg_fetch_into", 
  "opt_ecpg_fetch_into", 0
};
#endif

# ifdef YYPRINT
/* YYTOKNUM[YYLEX-NUM] -- Internal token number corresponding to
   token YYLEX-NUM.  */
static const unsigned short yytoknum[] =
{
       0,   256,   257,   258,   259,   260,   261,   262,   263,   264,
     265,   266,   267,   268,   269,   270,   271,   272,   273,   274,
     275,   276,   277,   278,   279,   280,   281,   282,   283,   284,
     285,   286,   287,   288,   289,   290,   291,   292,   293,   294,
     295,   296,   297,   298,   299,   300,   301,   302,   303,   304,
     305,   306,   307,   308,   309,   310,   311,   312,   313,   314,
     315,   316,   317,   318,   319,   320,   321,   322,   323,   324,
     325,   326,   327,   328,   329,   330,   331,   332,   333,   334,
     335,   336,   337,   338,   339,   340,   341,   342,   343,   344,
     345,   346,   347,   348,   349,   350,   351,   352,   353,   354,
     355,   356,   357,   358,   359,   360,   361,   362,   363,   364,
     365,   366,   367,   368,   369,   370,   371,   372,   373,   374,
     375,   376,   377,   378,   379,   380,   381,   382,   383,   384,
     385,   386,   387,   388,   389,   390,   391,   392,   393,   394,
     395,   396,   397,   398,   399,   400,   401,   402,   403,   404,
     405,   406,   407,   408,   409,   410,   411,   412,   413,   414,
     415,   416,   417,   418,   419,   420,   421,   422,   423,   424,
     425,   426,   427,   428,   429,   430,   431,   432,   433,   434,
     435,   436,   437,   438,   439,   440,   441,   442,   443,   444,
     445,   446,   447,   448,   449,   450,   451,   452,   453,   454,
     455,   456,   457,   458,   459,   460,   461,   462,   463,   464,
     465,   466,   467,   468,   469,   470,   471,   472,   473,   474,
     475,   476,   477,   478,   479,   480,   481,   482,   483,   484,
     485,   486,   487,   488,   489,   490,   491,   492,   493,   494,
     495,   496,   497,   498,   499,   500,   501,   502,   503,   504,
     505,   506,   507,   508,   509,   510,   511,   512,   513,   514,
     515,   516,   517,   518,   519,   520,   521,   522,   523,   524,
     525,   526,   527,   528,   529,   530,   531,   532,   533,   534,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   548,   549,   550,   551,   552,   553,   554,
     555,   556,   557,   558,   559,   560,   561,   562,   563,   564,
     565,   566,   567,   568,   569,   570,   571,   572,   573,   574,
     575,   576,   577,   578,   579,   580,   581,   582,   583,   584,
     585,   586,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,   597,   598,   599,   600,   601,   602,   603,   604,
     605,   606,   607,   608,   609,   610,   611,   612,   613,   614,
     615,   616,   617,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   628,   629,   630,   631,   632,   633,   634,
     635,   636,   637,   638,   639,   640,   641,   642,   643,   644,
     645,   646,   647,   648,   649,   650,   651,   652,   653,   654,
     655,   656,   657,   658,   659,   660,   661,   662,   663,   664,
     665,   666,   667,   668,   669,   670,   671,   672,   673,   674,
     675,   676,   677,   678,   679,   680,   681,   682,   683,   684,
     685,   686,   687,   688,   689,   690,   691,   692,   693,   694,
     695,   696,   697,   698,   699,   700,   701,   702,   703,   704,
     705,   706,   707,   708,   709,   710,   711,   712,   713,   714,
     715,   716,   717,   718,   719,   720,   721,   722,   723,   724,
     725,   726,   727,   728,   729,   730,   731,   732,   733,   734,
     735,   736,   737,   738,   739,   740,   741,   742,   743,    61,
      60,    62,   744,    43,    45,    42,    47,    37,    94,   745,
      91,    93,    40,    41,    46,    44,    59,    58,   123,   125
};
# endif

/* YYR1[YYN] -- Symbol number of symbol that rule YYN derives.  */
static const unsigned short yyr1[] =
{
       0,   510,   511,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   512,   512,   512,   512,   512,
     512,   512,   512,   512,   512,   513,   514,   514,   515,   515,
     516,   516,   517,   517,   517,   517,   517,   517,   517,   517,
     517,   517,   517,   517,   517,   517,   517,   517,   517,   517,
     517,   518,   518,   518,   518,   518,   518,   519,   520,   521,
     521,   522,   523,   524,   525,   525,   526,   526,   527,   528,
     529,   529,   530,   530,   531,   531,   532,   532,   533,   533,
     534,   534,   534,   534,   534,   534,   535,   535,   535,   536,
     536,   536,   536,   536,   536,   536,   536,   536,   536,   536,
     536,   536,   536,   536,   537,   537,   538,   538,   539,   539,
     539,   540,   540,   540,   540,   541,   541,   541,   541,   542,
     542,   542,   542,   542,   542,   542,   543,   543,   543,   544,
     544,   545,   545,   545,   545,   545,   546,   546,   547,   547,
     547,   547,   547,   548,   549,   549,   550,   550,   551,   552,
     552,   552,   552,   553,   553,   553,   553,   554,   554,   555,
     555,   555,   555,   555,   555,   555,   555,   555,   555,   555,
     555,   555,   555,   555,   555,   555,   555,   555,   555,   555,
     555,   555,   555,   555,   555,   555,   555,   555,   555,   555,
     555,   555,   555,   555,   555,   555,   556,   556,   557,   557,
     557,   558,   558,   559,   560,   560,   561,   561,   562,   562,
     562,   562,   563,   563,   564,   564,   565,   565,   566,   566,
     566,   567,   567,   568,   568,   569,   569,   569,   569,   569,
     569,   569,   569,   569,   569,   569,   570,   570,   571,   571,
     572,   572,   573,   573,   574,   574,   575,   576,   576,   576,
     576,   576,   576,   577,   577,   578,   578,   579,   579,   580,
     580,   580,   580,   580,   580,   580,   581,   581,   582,   582,
     583,   583,   584,   584,   585,   585,   585,   586,   586,   587,
     588,   589,   589,   590,   590,   590,   591,   591,   591,   591,
     591,   591,   591,   592,   592,   592,   592,   593,   594,   594,
     594,   595,   595,   595,   595,   595,   595,   596,   596,   597,
     597,   597,   597,   597,   598,   598,   599,   599,   600,   601,
     601,   601,   601,   602,   602,   603,   603,   604,   604,   605,
     605,   605,   605,   605,   606,   607,   608,   608,   608,   608,
     608,   609,   609,   610,   610,   610,   610,   611,   611,   611,
     611,   612,   612,   613,   613,   614,   615,   615,   616,   616,
     617,   618,   618,   618,   619,   620,   621,   621,   622,   622,
     623,   623,   623,   623,   623,   623,   623,   623,   623,   623,
     623,   623,   624,   624,   625,   625,   625,   626,   626,   627,
     627,   628,   628,   629,   629,   630,   630,   631,   631,   632,
     632,   633,   633,   634,   634,   635,   636,   636,   637,   637,
     638,   639,   639,   640,   640,   640,   641,   641,   642,   642,
     643,   644,   644,   645,   645,   645,   645,   646,   647,   648,
     649,   650,   650,   651,   651,   652,   652,   653,   653,   654,
     654,   654,   655,   656,   656,   656,   657,   657,   658,   659,
     659,   660,   660,   661,   661,   662,   662,   662,   662,   662,
     663,   663,   664,   664,   665,   665,   666,   666,   667,   667,
     667,   668,   668,   668,   668,   668,   668,   669,   669,   670,
     670,   670,   670,   670,   671,   671,   672,   672,   673,   673,
     674,   675,   676,   676,   676,   676,   676,   676,   676,   676,
     676,   676,   676,   677,   678,   678,   679,   679,   680,   680,
     680,   680,   680,   681,   681,   682,   683,   683,   684,   685,
     685,   686,   686,   687,   688,   688,   689,   689,   689,   689,
     689,   690,   690,   691,   691,   692,   692,   693,   694,   694,
     695,   695,   696,   696,   697,   697,   698,   698,   699,   700,
     701,   701,   702,   702,   702,   702,   702,   702,   702,   702,
     702,   702,   702,   702,   703,   703,   704,   704,   705,   705,
     706,   707,   707,   707,   708,   708,   708,   708,   708,   708,
     708,   708,   708,   708,   708,   708,   708,   708,   708,   708,
     708,   709,   709,   709,   709,   709,   709,   709,   709,   709,
     709,   709,   709,   710,   710,   711,   711,   711,   711,   711,
     711,   711,   711,   711,   711,   711,   712,   712,   712,   712,
     712,   712,   712,   712,   712,   712,   712,   712,   712,   712,
     713,   713,   714,   714,   715,   716,   716,   717,   717,   717,
     717,   717,   718,   718,   719,   719,   719,   719,   720,   720,
     720,   720,   720,   720,   720,   720,   720,   720,   720,   720,
     720,   720,   721,   721,   722,   722,   723,   723,   724,   724,
     725,   726,   727,   727,   728,   728,   729,   729,   730,   731,
     731,   732,   732,   732,   733,   733,   733,   734,   734,   734,
     735,   736,   736,   737,   737,   738,   738,   739,   739,   740,
     740,   741,   741,   741,   742,   742,   742,   743,   743,   743,
     744,   744,   744,   745,   745,   745,   746,   746,   747,   747,
     748,   748,   749,   749,   750,   750,   751,   751,   751,   751,
     751,   752,   752,   752,   752,   752,   753,   754,   755,   755,
     755,   756,   756,   756,   757,   757,   758,   758,   758,   758,
     758,   758,   758,   758,   758,   758,   758,   758,   758,   759,
     759,   759,   759,   760,   760,   761,   761,   762,   763,   763,
     764,   765,   765,   766,   766,   767,   767,   768,   768,   769,
     769,   770,   770,   770,   770,   771,   771,   772,   773,   773,
     774,   774,   775,   775,   775,   776,   776,   776,   777,   778,
     778,   779,   779,   779,   780,   780,   781,   781,   782,   782,
     782,   782,   782,   782,   782,   782,   782,   782,   782,   782,
     782,   782,   782,   782,   782,   782,   782,   782,   782,   782,
     782,   782,   782,   783,   783,   784,   784,   785,   785,   785,
     785,   785,   785,   785,   786,   786,   786,   786,   786,   786,
     786,   786,   786,   786,   786,   786,   786,   786,   786,   786,
     786,   787,   788,   788,   788,   789,   789,   790,   790,   790,
     790,   790,   791,   791,   792,   792,   792,   792,   793,   793,
     793,   794,   794,   795,   796,   796,   797,   798,   798,   799,
     799,   799,   799,   799,   799,   799,   799,   799,   799,   799,
     799,   799,   799,   800,   800,   800,   801,   801,   801,   802,
     802,   802,   803,   803,   804,   804,   805,   805,   805,   805,
     806,   807,   808,   808,   809,   809,   809,   809,   809,   809,
     809,   809,   809,   809,   809,   809,   809,   809,   809,   809,
     810,   810,   811,   811,   812,   813,   813,   814,   815,   815,
     816,   817,   817,   817,   817,   817,   818,   818,   819,   820,
     820,   820,   820,   820,   820,   821,   822,   822,   822,   823,
     823,   824,   824,   824,   824,   824,   825,   825,   826,   826,
     826,   826,   827,   827,   828,   828,   829,   829,   830,   830,
     831,   831,   832,   832,   833,   833,   833,   833,   834,   834,
     834,   834,   834,   834,   834,   835,   835,   836,   837,   837,
     837,   838,   838,   838,   838,   839,   839,   840,   840,   841,
     841,   841,   841,   842,   842,   843,   843,   844,   845,   845,
     845,   846,   846,   847,   848,   848,   849,   850,   850,   851,
     852,   852,   853,   853,   853,   853,   853,   853,   853,   853,
     854,   854,   855,   856,   856,   857,   857,   858,   859,   860,
     861,   861,   862,   863,   863,   864,   864,   864,   864,   864,
     865,   865,   865,   866,   866,   867,   867,   868,   868,   868,
     868,   868,   868,   868,   868,   869,   869,   870,   870,   870,
     870,   870,   870,   871,   871,   872,   872,   873,   874,   874,
     874,   875,   875,   875,   875,   875,   875,   875,   875,   876,
     876,   877,   877,   877,   878,   878,   878,   878,   879,   879,
     880,   881,   881,   882,   882,   883,   883,   883,   883,   884,
     884,   885,   885,   885,   886,   886,   887,   887,   888,   889,
     889,   889,   890,   891,   891,   892,   892,   893,   893,   894,
     894,   895,   895,   896,   896,   897,   897,   898,   898,   899,
     899,   900,   900,   901,   901,   902,   902,   903,   903,   903,
     903,   903,   903,   903,   903,   903,   903,   903,   904,   904,
     904,   904,   904,   904,   905,   905,   905,   905,   906,   906,
     906,   906,   907,   907,   908,   908,   909,   909,   909,   909,
     910,   910,   911,   911,   911,   912,   913,   913,   914,   914,
     914,   915,   915,   916,   917,   917,   917,   917,   917,   917,
     918,   918,   918,   919,   919,   919,   919,   919,   919,   919,
     920,   920,   920,   920,   921,   921,   922,   922,   923,   923,
     923,   923,   923,   923,   923,   923,   923,   923,   923,   924,
     924,   925,   925,   926,   926,   927,   928,   929,   929,   930,
     930,   931,   932,   933,   933,   933,   933,   933,   933,   934,
     934,   935,   935,   936,   936,   936,   936,   937,   938,   938,
     938,   939,   939,   939,   939,   939,   939,   939,   939,   939,
     939,   939,   939,   939,   939,   940,   940,   941,   941,   941,
     941,   941,   941,   941,   941,   941,   941,   941,   941,   941,
     941,   941,   941,   941,   941,   941,   941,   941,   941,   941,
     941,   941,   941,   941,   941,   941,   941,   941,   941,   941,
     941,   941,   941,   941,   941,   941,   941,   941,   941,   941,
     941,   941,   941,   941,   941,   941,   941,   941,   941,   941,
     941,   941,   941,   941,   941,   942,   942,   942,   942,   942,
     942,   942,   942,   942,   942,   942,   942,   942,   942,   942,
     942,   942,   942,   942,   942,   942,   942,   943,   943,   943,
     943,   943,   943,   943,   943,   943,   943,   943,   944,   944,
     944,   944,   944,   944,   944,   944,   944,   944,   944,   944,
     944,   944,   944,   944,   944,   944,   944,   944,   944,   944,
     944,   944,   944,   944,   944,   944,   944,   944,   944,   944,
     944,   944,   944,   944,   944,   944,   944,   944,   944,   944,
     944,   944,   944,   944,   944,   944,   945,   945,   946,   946,
     946,   946,   947,   948,   948,   949,   949,   950,   950,   951,
     951,   951,   952,   952,   953,   953,   954,   955,   955,   955,
     956,   957,   957,   958,   958,   959,   959,   959,   960,   960,
     961,   961,   961,   961,   961,   962,   962,   962,   963,   963,
     963,   964,   964,   965,   965,   965,   965,   965,   965,   965,
     965,   965,   966,   966,   967,   967,   968,   968,   968,   968,
     968,   968,   969,   969,   970,   970,   971,   971,   972,   972,
     973,   973,   973,   974,   974,   975,   975,   976,   976,   976,
     976,   976,   976,   976,   976,   977,   977,   978,   979,   979,
     980,   980,   980,   980,   980,   980,   981,   982,   983,   983,
     983,   984,   984,   985,   986,   986,   987,   988,   988,   989,
     989,   990,   990,   991,   991,   991,   991,   992,   992,   993,
     993,   994,   994,   995,   995,   996,   996,   997,   998,   998,
     999,   999,   999,   999,  1000,  1000,  1001,  1001,  1002,  1002,
    1003,  1004,  1005,  1006,  1007,  1008,  1009,  1009,  1010,  1010,
    1010,  1010,  1010,  1010,  1010,  1010,  1010,  1010,  1010,  1010,
    1010,  1010,  1010,  1011,  1012,  1013,  1013,  1013,  1013,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,  1014,
    1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,
    1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,
    1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,
    1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,  1015,
    1015,  1015,  1015,  1016,  1016,  1016,  1016,  1016,  1016,  1016,
    1016,  1016,  1016,  1016,  1016,  1016,  1016,  1016,  1016,  1016,
    1016,  1016,  1016,  1016,  1016,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,  1017,
    1018,  1018,  1019,  1019,  1019,  1019,  1019,  1019,  1019,  1019,
    1021,  1020,  1022,  1023,  1023,  1023,  1023,  1024,  1024,  1024,
    1024,  1025,  1025,  1026,  1027,  1028,  1028,  1029,  1029,  1029,
    1030,  1030,  1031,  1031,  1032,  1032,  1033,  1033,  1033,  1033,
    1034,  1034,  1034,  1035,  1036,  1036,  1037,  1037,  1038,  1038,
    1038,  1038,  1039,  1039,  1040,  1041,  1042,  1043,  1043,  1044,
    1045,  1045,  1046,  1046,  1046,  1046,  1046,  1048,  1047,  1049,
    1050,  1051,  1051,  1052,  1052,  1052,  1052,  1053,  1053,  1055,
    1054,  1057,  1056,  1058,  1056,  1056,  1059,  1059,  1060,  1060,
    1060,  1061,  1061,  1061,  1061,  1062,  1062,  1063,  1063,  1063,
    1063,  1063,  1063,  1064,  1064,  1064,  1065,  1067,  1066,  1068,
    1069,  1068,  1070,  1070,  1071,  1071,  1072,  1072,  1073,  1073,
    1073,  1073,  1073,  1073,  1073,  1073,  1073,  1074,  1074,  1074,
    1074,  1074,  1074,  1074,  1074,  1074,  1074,  1075,  1075,  1076,
    1076,  1077,  1078,  1078,  1079,  1079,  1079,  1080,  1081,  1082,
    1082,  1082,  1082,  1083,  1083,  1083,  1084,  1084,  1085,  1085,
    1086,  1087,  1087,  1088,  1088,  1089,  1089,  1090,  1090,  1091,
    1092,  1092,  1093,  1093,  1093,  1094,  1094,  1094,  1094,  1094,
    1094,  1094,  1094,  1094,  1095,  1095,  1095,  1095,  1095,  1096,
    1096,  1097,  1098,  1099,  1100,  1100,  1101,  1102,  1103,  1103,
    1104,  1105,  1105,  1106,  1107,  1108,  1108,  1109,  1110,  1111,
    1111,  1112,  1113,  1113,  1113,  1113,  1113,  1114,  1114,  1114,
    1114,  1114,  1114,  1114,  1114,  1114,  1114,  1114,  1114,  1114,
    1114,  1114,  1115,  1115,  1116,  1116,  1117,  1117,  1117,  1119,
    1118,  1120,  1120,  1122,  1121,  1123,  1123,  1123,  1124,  1124,
    1124,  1124,  1124,  1124,  1124,  1124,  1124,  1125,  1125,  1126,
    1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,
    1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,  1126,
    1126,  1126,  1126,  1127,  1127,  1127,  1127,  1127,  1127,  1128,
    1128,  1128,  1128,  1128,  1128,  1128,  1129,  1130,  1130,  1130,
    1130,  1130,  1130,  1130,  1130,  1131,  1131,  1131,  1131,  1131,
    1131,  1131,  1132,  1132,  1132,  1132,  1132,  1132,  1133,  1133,
    1133,  1133,  1133,  1133,  1133,  1133,  1133,  1133,  1133,  1134,
    1134,  1134,  1134,  1134,  1135,  1135,  1135,  1135,  1136,  1136,
    1136,  1136,  1136,  1136,  1136,  1137,  1137,  1137,  1138,  1138,
    1138,  1138,  1138,  1138,  1139,  1139,  1140,  1141,  1141,  1142,
    1142,  1143,  1144,  1145,  1146,  1146,  1146,  1147,  1148,  1149,
    1150,  1151,  1151,  1151,  1151,  1151,  1152,  1153,  1153,  1153,
    1154,  1154,  1155,  1155,  1155,  1156,  1156,  1157,  1157,  1158,
    1158,  1159,  1159,  1159,  1159,  1159,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,  1160,
    1160,  1160,  1161,  1161,  1161,  1161,  1162,  1162,  1162,  1162,
    1162,  1162,  1162,  1162,  1162,  1163,  1163,  1163,  1163,  1163,
    1164,  1164,  1165,  1165,  1166,  1166
};

/* YYR2[YYN] -- Number of symbols composing right hand side of rule YYN.  */
static const unsigned char yyr2[] =
{
       0,     2,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     0,     5,     1,     0,     2,     0,
       2,     0,     2,     2,     3,     3,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     3,     3,
       2,     1,     2,     2,     2,     3,     3,     5,     5,     0,
       3,     5,     5,     4,     3,     5,     3,     5,     5,     6,
       1,     1,     3,     5,     6,     4,     1,     0,     2,     0,
       1,     1,     1,     1,     1,     1,     2,     3,     3,     3,
       3,     3,     3,     3,     3,     2,     5,     2,     2,     2,
       2,     3,     3,     3,     1,     3,     1,     3,     1,     1,
       1,     2,     2,     2,     1,     1,     1,     1,     1,     1,
       1,     3,     6,     1,     1,     1,     1,     1,     0,     1,
       1,     2,     3,     4,     3,     2,     2,     1,     3,     4,
       5,     4,     2,     4,     1,     1,     1,     1,     1,     2,
       2,     2,     2,     4,     4,     4,     4,     1,     3,     2,
       3,     4,     6,     6,     6,     5,     5,     6,     6,     4,
       7,     2,     6,     4,     3,     3,     3,     3,     3,     4,
       4,     3,     3,     3,     3,     3,     3,     4,     4,     3,
       2,     3,     3,     3,     2,     2,     3,     2,     1,     1,
       0,     2,     0,     3,     2,     0,     1,     3,     3,     1,
       5,     3,     2,     2,    10,     6,     1,     1,     1,     1,
       1,     1,     3,     2,     0,     1,     1,     3,     3,     1,
       1,     3,     3,     3,     3,     4,     1,     0,     2,     0,
       3,     0,     1,     0,     1,     3,     2,     1,     1,     1,
       1,     3,     0,     1,     3,     1,     1,    11,    10,     1,
       1,     2,     2,     2,     2,     0,     1,     0,     3,     0,
       1,     3,     1,     3,     1,     1,     1,     1,     1,     3,
       4,     2,     0,     3,     1,     1,     2,     1,     3,     4,
       4,     2,     5,     1,     2,     2,     2,     3,     3,     3,
       0,     1,     1,     1,     1,     1,     1,     3,     1,     5,
       7,     8,     9,    11,     3,     0,     1,     3,     1,     2,
       2,     2,     0,     1,     3,     3,     6,     4,     0,     1,
       1,     2,     2,     0,     3,     3,     2,     1,     1,     2,
       2,     4,     0,     2,     2,     2,     0,     3,     4,     4,
       0,     2,     0,     4,     0,     5,     3,     0,     1,     3,
       1,     2,     3,     0,     5,     4,     1,     0,     1,     2,
       2,     1,     2,     3,     2,     2,     2,     2,     3,     3,
       1,     3,     1,     0,     1,     2,     1,     1,     3,     6,
      10,     1,     0,     1,     2,     2,     0,     2,     2,     1,
       0,     5,     7,     1,     0,     6,     2,     0,     3,     5,
       7,     6,     8,     7,     6,     6,     4,     0,     1,     3,
       4,     1,     3,     1,     2,     2,     2,     2,     1,     1,
      10,     2,     0,     2,     2,     1,     0,     4,     6,     5,
       4,     4,     8,     1,     1,     1,     7,     9,     8,    15,
      20,     1,     1,     1,     3,     1,     1,     1,     3,     1,
       3,     0,     1,     0,     1,     1,     4,     0,     1,     3,
       0,     1,     1,     1,     1,     1,     1,     2,     0,     1,
       2,     1,     2,     0,     2,     1,     2,     2,     6,     8,
       8,     4,     5,     4,     4,     4,     3,     7,     8,     6,
       6,     6,     6,     3,     1,     3,     3,     1,     1,     1,
       1,     1,     1,     3,     3,     3,     1,     3,     3,     1,
       0,     1,     3,    13,     1,     3,     4,     5,     4,     7,
       2,     1,     0,     2,     0,     1,     0,     6,     8,     8,
       1,     3,     5,     5,     7,     9,     7,     9,     5,     6,
       6,     4,     1,     1,     1,     1,     1,     1,     1,     1,
       3,     3,     3,     3,     1,     3,     1,     2,     2,     3,
       5,     2,     2,     0,     6,     7,     7,     7,     8,     8,
       6,     8,     9,     9,     7,    10,     7,     8,     8,     8,
       8,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     2,     2,     3,     4,     5,
       4,     5,     3,     4,     3,     4,     1,     2,     3,     3,
       3,     3,     4,     4,     3,     3,     4,     4,     4,     4,
       1,     1,     1,     0,     7,     7,    10,     1,     1,     2,
       4,     5,     1,     3,     2,     2,     2,     2,     1,     2,
       2,     4,     3,     2,     2,     2,     3,     2,     2,     5,
       5,     5,     1,     3,     1,     2,     3,     0,     1,     3,
       2,     6,     6,     9,     3,     0,     3,     0,     5,     2,
       0,     3,     3,     3,     7,     7,    10,     1,     1,     1,
      14,     1,     0,     1,     0,     1,     0,     2,     0,     1,
       3,     4,     4,     6,     1,     2,     0,     1,     1,     0,
       1,     1,     0,     9,    12,     7,     2,     0,     3,     2,
       1,     3,     3,     2,     1,     3,     3,     3,     2,     2,
       1,     1,     1,     1,     2,     1,     1,     1,     1,     4,
       5,     1,     3,     3,     1,     2,     4,     5,     1,     1,
       1,     1,     3,     3,     2,     2,     2,     2,     1,     2,
       2,     1,     1,     1,     3,     2,     0,     2,     1,     3,
       5,     1,     2,     1,     0,     5,     7,     5,     7,     5,
       7,     3,     5,     5,     5,     1,     3,     2,     1,     2,
       1,     2,    11,    10,    10,     2,     2,     0,     9,     2,
       0,     4,     4,     4,     1,     1,     1,     0,     7,     6,
       6,     6,     6,     7,     9,     9,     6,     6,     6,     6,
       6,     8,     8,     6,     6,     6,     5,     5,     8,     8,
       8,     8,     6,     1,     0,     2,     0,     7,     6,     6,
       6,     6,     6,     6,     7,     6,     6,     6,     6,     7,
       7,     7,     9,     9,     6,     6,     6,     8,     8,     8,
       6,    13,     1,     1,     3,     3,     1,     1,     1,     1,
       1,     1,     1,     0,     1,     1,     1,     1,     1,     1,
       0,     6,     8,     3,     2,     0,     2,     2,     2,     2,
       3,     3,     2,     2,     2,     2,     3,     2,     5,     4,
       3,     3,     3,     1,     1,     0,     3,     2,     2,     1,
       3,     2,     1,     0,     8,    10,     3,     4,     4,     0,
       2,     5,     2,     0,     3,     3,     3,     3,     3,     3,
       3,     3,     3,     3,     3,     3,     3,     4,     3,     3,
       1,     0,     5,     6,     4,     2,     0,     4,     3,     5,
       6,     4,     6,     6,     5,     7,     1,     0,     6,    11,
      11,    11,    13,     9,    11,    10,     4,     2,     5,     2,
       0,     4,     5,     5,     4,     6,     1,     3,     1,     1,
       1,     1,     2,     4,     1,     1,     1,     0,     1,     0,
       1,     0,     3,     0,     2,     4,     3,     5,     1,     1,
       1,     1,     1,     1,     1,     1,     3,     2,     1,     1,
       1,     1,     1,     1,     0,     5,     4,     3,     0,     1,
       1,     1,     1,     4,     8,     3,     0,     5,     1,     4,
       2,     1,     3,     2,     3,     0,     6,     2,     0,     5,
       3,     0,     2,     2,     2,     3,     1,     3,     1,     2,
       1,     0,     7,     1,     3,     1,     1,     3,     5,     2,
       1,     3,     7,     1,     1,     0,     3,     2,     2,     2,
       0,     2,     2,     1,     1,     3,     3,     1,     2,     4,
       4,     2,     3,     5,     5,     1,     1,     9,     1,     2,
       4,     4,     4,     2,     3,     1,     3,     4,     2,     1,
       0,     3,     3,     4,     4,     4,     4,     2,     1,     1,
       0,     1,     1,     0,     1,     5,     1,     0,     1,     0,
       3,     1,     3,     4,     3,     2,     2,     1,     1,     1,
       0,     2,     4,     5,     2,     3,     1,     1,     1,     1,
       3,     0,     1,     1,     1,     1,     1,     3,     0,     2,
       0,     1,     3,     1,     0,     1,     2,     4,     4,     2,
       0,     2,     3,     2,     0,     1,     3,     1,     2,     1,
       2,     5,     6,     5,     1,     2,     1,     4,     3,     4,
       5,     4,     5,     4,     5,     2,     4,     1,     2,     2,
       2,     1,     1,     0,     4,     2,     1,     2,     2,     4,
       1,     3,     1,     2,     3,     1,     2,     0,     2,     4,
       0,     1,     3,     2,     2,     3,     5,     6,     2,     3,
       3,     4,     0,     1,     1,     1,     1,     1,     2,     5,
       1,     1,     1,     1,     2,     3,     3,     0,     1,     1,
       1,     1,     1,     2,     2,     2,     2,     2,     1,     3,
       0,     1,     1,     1,     1,     5,     2,     1,     1,     1,
       1,     5,     2,     2,     2,     1,     3,     3,     2,     1,
       0,     3,     0,     5,     2,     5,     2,     1,     2,     3,
       0,     1,     1,     1,     1,     1,     1,     3,     3,     3,
       3,     3,     3,     3,     0,     1,     4,     1,     3,     5,
       2,     2,     3,     3,     3,     3,     3,     3,     3,     3,
       3,     3,     2,     2,     3,     3,     2,     3,     5,     4,
       6,     3,     5,     4,     6,     4,     6,     5,     7,     3,
       2,     4,     2,     3,     3,     4,     3,     4,     3,     4,
       5,     6,     6,     7,     6,     7,     6,     7,     3,     4,
       4,     6,     2,     3,     4,     1,     3,     2,     2,     3,
       3,     3,     3,     3,     3,     3,     3,     3,     3,     2,
       2,     5,     6,     6,     7,     3,     4,     1,     1,     2,
       4,     1,     1,     1,     2,     2,     2,     1,     4,     5,
       6,     8,     6,     7,     7,     5,     1,     1,     4,     1,
       4,     1,     4,     1,     4,     1,     1,     1,     1,     1,
       1,     6,     4,     4,     4,     4,     6,     5,     5,     5,
       4,     6,     4,     4,     4,     4,     5,     7,     7,     9,
       4,     6,     5,     7,     7,     7,     2,     3,     3,     3,
       4,     0,     4,     1,     3,     3,     1,     1,     1,     2,
       2,     0,     2,     0,     1,     3,     3,     2,     2,     0,
       6,     1,     0,     3,     0,     2,     2,     0,     1,     4,
       2,     2,     2,     2,     2,     4,     3,     5,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     4,     1,     4,     1,     4,     1,     2,
       1,     2,     1,     3,     1,     3,     1,     3,     1,     3,
       3,     3,     2,     1,     3,     3,     0,     1,     1,     1,
       1,     1,     1,     1,     1,     4,     3,     2,     3,     0,
       3,     3,     2,     2,     1,     0,     2,     2,     3,     2,
       1,     1,     3,     5,     1,     2,     4,     2,     0,     1,
       0,     1,     2,     2,     2,     3,     5,     1,     2,     0,
       2,     1,     0,     1,     1,     1,     3,     3,     1,     3,
       3,     2,     1,     1,     1,     3,     1,     2,     1,     3,
       1,     1,     1,     1,     1,     1,     1,     2,     1,     1,
       1,     1,     1,     2,     5,     2,     3,     6,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       0,     2,     4,     3,     2,     1,     1,     1,     1,     1,
       0,     8,     2,     5,     3,     2,     2,     3,     7,     1,
       1,     1,     0,     2,     2,     1,     0,     1,     3,     1,
       2,     0,     2,     0,     2,     0,     1,     3,     4,     3,
       1,     1,     1,     1,     2,     0,     2,     4,     0,     2,
       2,     2,     1,     1,     7,     3,     1,     1,     1,     1,
       2,     0,     1,     3,     3,     3,     3,     0,     4,     5,
       5,     0,     1,     1,     1,     2,     2,     1,     2,     0,
       7,     0,     5,     0,     4,     2,     2,     0,     2,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       5,     2,     1,     3,     2,     2,     3,     0,     5,     1,
       0,     5,     2,     2,     1,     1,     1,     2,     2,     3,
       1,     2,     2,     3,     3,     4,     2,     1,     2,     1,
       1,     2,     2,     3,     1,     1,     1,     1,     0,     1,
       3,     5,     0,     2,     0,     1,     2,     3,     2,     1,
       1,     1,     0,     1,     1,     1,     1,     1,     2,     2,
       3,     0,     1,     2,     1,     4,     3,     4,     3,     2,
       1,     3,     1,     1,     1,     1,     2,     2,     1,     2,
       2,     1,     1,     1,     4,     4,     4,     4,     4,     1,
       0,     3,     3,     4,     1,     3,     3,     4,     1,     3,
       3,     1,     1,     1,     6,     1,     3,     3,     6,     1,
       3,     3,     1,     1,     2,     2,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     4,     4,     1,     1,     4,     4,     3,     0,
       7,     1,     0,     0,     7,     3,     4,     3,     1,     1,
       1,     2,     3,     5,     2,     5,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     3,     1,     0,     1,     2,
       1,     2,     1,     1,     1,     2,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     2,     3,     1,     2,     1,     3,     1,
       3,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     2,     3,     2,     3,     1,     3,     3,     3,
       3,     3,     3,     1,     1,     0,     2,     2,     1,     1,
       2,     1,     1,     1,     0,     1
};

/* YYDEFACT[STATE-NAME] -- Default rule to reduce with in state
   STATE-NUM when YYTABLE doesn't specify something else to do.  Zero
   means the default is an error.  */
static const unsigned short yydefact[] =
{
    2090,     0,     2,     1,  2520,  2524,  2528,  2529,  2446,  2530,
    2531,  2496,  2497,  2498,  2499,  2500,  2501,  2502,  2503,  2504,
    2505,  2506,  2507,  2509,  2508,  2510,  2511,  2512,  2513,  2514,
    2515,  2516,  2517,  2519,  2518,  2468,  2097,  2465,  2462,  2463,
    2464,  2469,  2467,  2460,  2461,  1703,  2533,  2521,  2534,  2522,
    2523,  2525,  2526,  2495,  2527,  2535,  2536,  2537,  2532,  2540,
    2491,  2492,  2490,  2493,  2494,  2538,  2539,  2482,  2483,  2484,
    2485,  2541,  2098,  2099,  2487,  2091,  2095,  2157,  2228,  2488,
    2489,  2486,  2096,  2481,  2228,     0,  2349,  2350,  2351,     0,
    2352,  2353,  2354,  2280,  2242,  2355,     0,     0,  2356,  2357,
    2358,  2359,  2360,  2361,  2362,  2363,     0,  2364,  2365,  2366,
    2367,  2227,  2368,  2369,  2370,  2371,  2372,  2204,  2210,  2333,
       0,  2184,  2185,  2181,  2183,  2182,  2186,  2169,  1005,   504,
    1085,  1084,     0,  1993,  1005,  1950,  1951,  1994,  1952,  1953,
    1954,   248,     0,  1087,  1955,     0,  1005,  1995,   337,   817,
    1996,  1997,  2112,     0,  1956,  1957,     0,     0,     0,     0,
     504,  1005,     0,     0,  1958,     0,  1959,     0,  1960,  1998,
    1999,     0,  1961,  2000,  2001,  1962,     0,  1963,  1964,  2002,
    2003,  2004,  1965,  2005,  2006,     0,     0,  1210,     0,  1966,
    2007,  1967,  1968,     0,  2008,  1969,  1970,  1971,  2009,  2010,
    2011,  1972,  1973,  1974,     0,  1975,     0,     0,     0,     0,
       0,  2012,  1005,  1976,     0,  1217,     0,  1977,     0,  2013,
    1978,     0,  1979,     0,  1980,  1981,  1982,  1983,  1210,  2329,
    2205,     0,     0,  1089,     0,  1984,  2014,     0,  1985,  1986,
    1987,  1988,  1989,  1990,  1991,  1992,     0,     0,    47,    48,
      16,    15,    21,    20,    70,    71,    37,    10,    61,    42,
     102,   101,   103,    27,    23,    55,    14,    24,    28,    44,
      43,    13,    41,    65,    45,    68,    34,    59,     7,    35,
      60,     8,    49,    72,    19,    46,    69,    30,    57,    53,
      38,    39,    40,    62,    63,    64,    86,    67,    97,    26,
      76,    77,    92,    78,    93,     5,    79,    36,     9,    89,
      88,    90,    56,    31,    58,    87,    91,    11,    12,    94,
      66,    84,    81,    98,    96,   104,    82,    50,     3,     4,
      73,    33,     6,    18,    17,    32,    25,   100,    22,  1087,
      75,    85,    74,    80,    54,    83,    99,    52,    95,  1186,
    1173,  1219,  1185,     0,  1188,  2425,  2426,    29,   124,   106,
     107,   112,  2094,  2146,  2147,  2148,  2228,  2179,  2180,  2173,
    2189,  2199,  2188,  2192,  2200,  2187,  2206,     0,   109,   111,
     113,   116,   110,   105,   108,   115,   120,   114,   119,   117,
     118,   121,   122,   123,  2427,  1394,  2424,    51,  2164,  2163,
       0,  2228,     0,  2373,  2374,  2375,  2376,  2377,  2378,  2428,
    2429,  2430,  2431,  2432,  2434,  2433,  2457,  1709,  1710,  1711,
    1712,  1713,  1714,  1715,  1716,  1717,  1718,  1719,  1720,  1721,
    1722,  1723,  1724,  1725,  1726,  1727,  1728,  1729,  1730,  1731,
    1732,  2400,  1733,  1734,  1735,  1736,  1737,  1738,  1739,  1740,
    1741,  1742,  2437,  1743,  1744,  1745,  1746,  1747,  1748,  1749,
    1750,  1751,  1752,  1753,  1754,  1755,  1756,  2438,  1757,  1758,
    1759,  1760,  1761,  1762,  1763,  1764,  1765,  1766,  1767,  1768,
    1769,  1770,  1771,  1772,  1773,  1774,  1775,  1776,  1777,  1778,
    1779,  1780,  1781,  1782,  1783,  1784,  1785,  1786,  1787,  1788,
    1789,  1790,  1791,  1792,  1793,  1794,  1795,  2439,  1796,  1797,
    1798,  1799,  1800,  1801,  1802,  1803,  1804,  1805,  1806,  1807,
    1808,  1809,  1810,  1811,  1812,  1813,  1814,  1815,  1816,  1817,
    1818,  1819,  1820,  1821,  1822,  1823,  1824,  1825,  1826,  1827,
    1828,  2440,  1829,  1830,  2441,  1831,  1832,  1833,  1834,  1835,
    1836,  1837,  1838,  1839,  1840,  1841,  1842,  1843,  1844,  1845,
    1846,  1847,  1848,  1849,  1850,  1851,  1852,  1853,  1854,  1855,
    1856,  1857,  1858,  1859,  1862,  1860,  1861,  1863,  1864,  1865,
    1866,  1867,  1868,  1869,  1870,  1871,  1872,  1873,  1874,  1875,
    1876,  1877,  1878,  1879,  1880,  1881,  1882,  1883,  1884,  1885,
    1886,  1887,  1888,  1889,  1890,  1891,  1892,  2442,  1893,  1894,
    1895,  1896,  1897,  1898,  1899,  1900,  1901,  1902,  1903,  1904,
    1905,  1906,  1907,  1908,  1909,  1910,  1911,  1912,  1913,  1914,
    1915,  1916,  1917,  1918,  1919,  1920,  1921,  2112,  1922,  1923,
    1924,  1925,  1926,  1927,  1928,  1929,  1930,  1931,  1932,  1933,
    1934,  1935,  1936,  1937,  2401,  1938,  1939,  1940,  1941,  1942,
    1943,  1944,  1945,  1946,  1947,  2443,  1948,  1949,  2130,  2435,
    2397,  2105,  2126,  2398,  2347,  2348,  1704,  2399,  2396,  2436,
    2132,  2453,  2131,  2395,  2279,     0,     0,  2241,  2240,  2244,
    2243,  2245,  2238,  2239,  1681,  2133,  2249,  2248,  1163,  2452,
    1680,  1164,     0,  2251,  2379,  2380,  2381,  2382,  2384,  2383,
    2385,  2015,  2016,  2017,  2018,  2019,  2020,  2021,  2022,  2023,
    2024,  2025,  2026,  2410,  2027,  2028,  2029,  2423,  2030,  2031,
    2411,  2032,  2033,  2034,  2035,  2036,  2037,  2038,  2039,  2040,
    2041,  2042,  2043,  2044,  2045,  2046,  2047,  2048,  2049,  2050,
    2051,  2052,  2053,  2054,  2055,  2412,  2413,  2056,  2057,  2058,
    2059,  2060,  2061,  2062,  2063,  2064,  2065,  2066,  2067,  2068,
    2069,  2070,  2071,  2072,  2073,  2074,  2075,  2076,  2077,  2078,
    2079,  2414,  2080,  2081,  2415,  2082,  2083,  2084,  2416,  2085,
    2086,  2087,  2088,  2089,  2420,  2421,  2422,  2409,  2202,  2386,
    2408,  2419,  2417,  2418,  2212,  2208,  2216,  2211,     0,     0,
       0,     0,  2228,  1004,  1003,   989,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   503,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2102,     0,  1013,   313,   312,  1086,  1067,   504,     0,   992,
     336,     0,     0,     0,     0,     0,     0,     0,   631,     0,
       0,     0,     0,     0,     0,     0,     0,   177,     0,     0,
     360,   359,     0,     0,     0,   791,     0,     0,     0,     0,
     492,  2111,  2106,  2116,     0,  2109,  2110,  2395,     0,  2544,
    1860,  2142,  2143,  2542,  1906,  1165,     0,   249,   252,   250,
     251,     0,   887,   888,   890,     0,     0,   900,   658,     0,
     657,     0,     0,     0,   655,     0,     0,     0,     0,   659,
     653,     0,   652,     0,     0,     0,   656,     0,   654,     0,
       0,   993,     0,  2194,  2195,  1798,  1126,   365,     0,     0,
       0,     0,  1087,  1094,  1104,  1099,  1101,  1100,  1102,  1098,
    1103,  1710,   733,  1723,   733,  1788,   730,   731,   733,   733,
     733,  1874,     0,     0,   705,     0,   716,  1705,   733,  1706,
    2453,   738,   415,   415,   415,     0,   737,   742,   415,     0,
     986,  1020,  1685,  1209,     0,  1723,  1788,   706,   985,  1922,
    1118,     0,     0,   904,     0,   905,     0,  1889,   997,   235,
    2393,  1898,  1980,  1922,  2394,   231,  2388,  2389,  2391,   204,
    2392,  2390,  2387,  1714,     0,     0,   737,     0,   994,   995,
    1216,  1214,     0,     0,     0,  1731,     0,  1743,  1822,   228,
    1885,  1890,  1898,  1980,  1922,  1947,   186,     0,   242,  1898,
    1980,  1922,     0,  1013,     0,  1189,  1296,  1676,     0,     0,
    2203,   988,   987,  1302,     0,  1088,     0,  1091,     0,  1261,
    1872,  1193,  1195,  1093,  1186,     0,  2093,  1082,  1213,  1213,
       0,  1213,     0,  1178,  1186,  1181,  1185,     0,  1005,     0,
    2171,  2199,  2178,  2234,  2175,     0,     0,  2224,  2220,  2217,
    2225,  2226,  2219,  2207,  1383,  1384,  1385,  1382,  1395,  1381,
       0,  2152,  1386,  2191,  2158,     0,  2166,  2165,  2470,  2471,
    2281,  2104,  2123,     0,     0,     0,     0,     0,     0,     0,
    2250,  2252,  2254,  2214,  2213,  2209,     0,     0,     0,     0,
    2339,  2340,  2338,     0,  2335,  2337,     0,  2234,     0,  2404,
    2398,  2407,     0,  1686,  2399,  2396,  2395,     0,   666,   127,
     780,     0,     0,     0,     0,     0,     0,     0,  1581,  1735,
    1784,  1591,  1589,  1590,  1583,  1584,  1585,  1586,  1587,  1588,
       0,   885,  1582,     0,   127,     0,     0,     0,     0,     0,
       0,     0,     0,  1826,   127,     0,     0,     0,     0,     0,
    1009,  1012,   990,  1070,     0,  1676,     0,     0,   691,     0,
     700,   692,   697,     0,   694,     0,     0,   702,     0,   693,
     695,   696,   701,     0,     0,   698,   699,     0,     0,  1001,
     415,     0,     0,     0,     0,     0,   127,  1057,     0,   364,
     363,   127,   362,   361,  1735,  1784,     0,   816,   127,     0,
     179,   532,   507,     0,     0,   596,  1826,   127,     0,     0,
       0,     0,   794,     0,     0,   491,   504,     0,  2115,  2121,
       0,  2113,  2282,  2545,  2543,  2237,     0,  1138,   891,   229,
     230,   889,  1797,     0,   300,     0,     0,  1797,  1048,     0,
    1797,     0,  1797,   172,  1678,  1735,  1784,  1797,     0,     0,
    1797,   164,  1797,     0,  1797,   300,  1797,   508,     0,  1797,
       0,  1797,  1826,   166,     0,  1797,   300,   664,     0,     0,
    2475,  2479,     0,  2477,  2472,  2193,  2247,  2246,  2145,     0,
    2555,     0,  1165,  1096,  2401,  1110,  1109,     0,  1105,  1114,
    1108,     0,   733,   732,     0,   733,     0,  2564,   733,     0,
     733,     0,  2564,   733,     0,     0,     0,   733,  1707,  1708,
       0,     0,  2563,  2561,  2562,   707,   717,     0,   739,     0,
       0,   746,   745,   744,     0,     0,     0,   747,     0,  1300,
    1141,     0,   714,     0,   712,     0,   983,  1000,     0,     0,
       0,     0,   907,   907,   907,   996,   234,   232,     0,     0,
       0,     0,     0,     0,  1002,     0,     0,  2459,  1692,  1592,
    2458,     0,  1951,  1952,  1953,  1650,     0,  2400,  1954,  1955,
    1509,  1496,  1505,  1510,  1497,  1499,  1506,  1956,  1957,  1770,
    1958,  1959,  1699,  1960,  1961,  1338,  1963,  1964,  1965,  1501,
    1503,  1966,  1967,     0,  1700,  1969,  1970,  1849,  1972,  1973,
    1975,  1976,  1507,  1978,  1979,  1980,  1981,  1982,  1983,  1698,
       0,  1508,  1984,  1986,  1987,  1988,  1989,  1990,  1991,  1992,
       0,     0,  1673,     0,  1483,     0,  1330,  1331,  1353,  1354,
    1332,  1359,  1360,  1372,  1333,     0,  1672,  1397,  1482,  1487,
       0,  1481,  1477,  1200,  1668,     0,  1478,  1688,  1651,  1702,
    1701,  2453,  1659,  1691,  1689,  1690,     0,     0,     0,   197,
       0,     0,  2328,   244,     0,   245,  1674,  1898,   187,   227,
     199,   226,   200,   198,     0,  1733,   188,     0,   195,     0,
       0,     0,     0,     0,     0,     0,   238,   991,     0,  1298,
    1297,     0,     0,  1657,  1677,   673,     0,     0,  1303,     0,
    1080,  1081,  1079,     0,  1076,  1078,  1090,  1087,  1664,  1663,
    1665,     0,  1194,     0,     0,     0,  1176,  1175,  1093,  1211,
    1212,     0,     0,     0,     0,     0,     0,     0,     0,  1254,
    1227,  1228,  1230,  1251,  1255,     0,  1182,  1262,  2092,  2234,
    2235,     0,  2229,     0,  2228,  2228,  2222,  2221,  2218,     0,
       0,     0,     0,     0,     0,     0,  2149,   486,  2151,   484,
       0,     0,  2125,     0,  2129,  2127,     0,  2274,  2277,     0,
    2275,  2276,  2278,     0,  2283,  2284,     0,     0,     0,  2466,
       0,     0,  2265,  2253,  2260,  2262,  2264,  2263,  2272,  2268,
    2271,  2273,  2215,  2228,  2346,     0,  2341,  2344,     0,  2336,
       0,     0,     0,  1687,     0,     0,     0,   667,     0,     0,
       0,   126,  1046,   237,  1044,     0,     0,     0,     0,     0,
    1051,     0,     0,     0,     0,   849,     0,     0,     0,     0,
       0,     0,   850,   848,   851,   858,   871,   874,     0,   770,
     170,   171,     0,     0,     0,   934,     0,     0,   934,     0,
       0,     0,     0,     0,     0,     0,   254,   257,     0,     0,
       0,     0,     0,     0,     0,     0,   131,     0,     0,     0,
       0,   471,   483,     0,     0,     0,     0,     0,   480,     0,
     127,   255,   465,   468,     0,     0,     0,   541,   540,   934,
       0,   253,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   131,   163,     0,
       0,   256,     0,  2159,     0,  1007,  1008,     0,  1011,     0,
    1066,     0,     0,     0,     0,     0,     0,  1735,  1784,     0,
       0,     0,     0,     0,     0,   339,   319,   320,   127,   318,
       0,     0,   593,     0,  1341,  1370,  1348,  1370,  1370,  1337,
    1337,  1350,  1339,  1377,     0,  1370,  1337,  1342,     0,  1340,
    1380,  1380,  1365,     0,  1322,  1323,  1324,  1325,  1351,  1352,
    1326,  1357,  1358,  1327,  1394,  2405,  1337,  2406,  2403,  2402,
       0,  1023,  1056,     0,     0,   129,   632,     0,     0,   594,
       0,   129,     0,   175,     0,   536,     0,     0,     0,     0,
       0,     0,   552,   551,     0,     0,   595,     0,   129,   467,
       0,   457,   415,     0,   793,   796,     0,     0,     0,  2119,
    2114,  2117,     0,  2107,  2121,  1168,  1170,  1169,     0,  1167,
       0,  1310,     0,   300,   298,   299,   591,   899,     0,     0,
       0,     0,   300,     0,     0,  1797,     0,  1797,     0,     0,
     300,   300,     0,     0,     0,     0,   537,     0,   663,   661,
     660,   662,     0,     0,     0,     0,     0,  1797,   300,     0,
       0,   651,  2473,     0,     0,  2476,     0,  2196,  1602,     0,
    2558,  1123,  2559,     0,     0,     0,     0,   216,   218,   217,
     215,  1111,  1112,  1113,  1107,  1095,     0,   725,     0,  2564,
    2565,   710,     0,   720,     0,  2564,   708,     0,   721,   718,
     719,     0,     0,     0,  2560,  2444,  2450,   724,     0,     0,
     416,   418,     0,     0,  1756,     0,  1789,  1814,  1815,  1890,
    1894,     0,  1917,     0,   748,   775,   743,     0,     0,  1135,
    1128,     0,     0,  1151,   715,   713,   984,  1116,  1608,     0,
       0,     0,   906,   903,   902,   901,   233,   205,     0,     0,
       0,   777,  1889,   999,     0,     0,  1485,  1486,  1369,  1356,
    1649,     0,     0,  1364,  1363,     0,     0,     0,     0,  1346,
    1345,  1344,  1484,  1616,     0,  1343,     0,     0,     0,     0,
    1370,  1370,  1368,  1416,     0,  1347,     0,     0,  1629,     0,
    1635,     0,     0,     0,  1376,     0,  1374,     0,     0,  1452,
       0,     0,     0,     0,     0,     0,     0,  1400,  1401,  1483,
    1602,     0,  1695,     0,     0,  1362,     0,  1394,  1592,     0,
       0,     0,     0,  1662,  1600,     0,     0,  1430,  1598,     0,
    1432,     0,     0,     0,  1591,  1589,  1590,  1583,  1584,  1585,
    1586,  1587,  1588,  1596,  1413,     0,  1671,     0,  1412,     0,
       0,  1264,  1199,     0,  1693,  1652,     0,  2451,  2454,  1479,
    2325,  2324,  2323,  2322,  2293,     0,  2287,  2288,     0,  2326,
    2327,   246,   247,   243,     0,     0,   202,   201,     0,   224,
     225,   194,   223,     0,   219,   220,  1548,  1547,   203,   193,
     191,   189,   206,   208,   209,   210,   192,   190,   241,   239,
       0,     0,     0,  1654,  1653,  1683,  1658,     0,     0,   300,
    2228,  1304,     0,  1264,  1153,  1155,  1156,     0,  1659,  1074,
       0,  1071,  1667,     0,  1196,     0,     0,  1083,  1192,  1191,
    1220,  1221,   809,  1190,  1245,  1246,  1241,     0,  1260,  1260,
    1237,  1231,  1236,  1234,     0,  1238,  1397,  1253,  1180,  1225,
    1226,  1229,  1179,     0,  1256,  1254,  1230,     0,  2236,  2234,
    2174,  1322,  2228,  2167,  2228,  2223,  2155,  1388,  1389,  1390,
    1391,  1392,  1393,  2156,     0,  2153,  1387,  2154,   485,     0,
       0,     0,  2122,     0,  2103,  2128,  2259,  2368,  2291,     0,
    2292,     0,     0,  2256,     0,  2266,  2269,  2267,  2270,     0,
    1322,  2447,  2342,  2447,  1322,     0,     0,     0,     0,     0,
       0,     0,   668,     0,     0,     0,  1917,   236,  1042,     0,
       0,     0,     0,   779,   778,     0,     0,   798,     0,     0,
       0,  1054,   408,     0,   297,     0,     0,     0,     0,     0,
       0,     0,   856,     0,     0,     0,     0,   857,   854,   855,
    1890,   873,   872,   870,   831,   833,   832,     0,   835,   819,
       0,   820,     0,     0,   830,   838,   836,     0,     0,     0,
    1778,   259,   271,     0,   933,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   290,     0,     0,     0,     0,
     295,     0,     0,     0,   294,     0,     0,     0,     0,     0,
       0,     0,   886,     0,     0,   158,   161,     0,     0,   470,
     482,     0,   474,   475,   472,   476,   477,     0,     0,     0,
       0,     0,     0,   469,     0,     0,   534,   533,   539,     0,
       0,     0,     0,     0,   927,   926,     0,     0,     0,     0,
       0,     0,     0,     0,   543,   544,     0,   545,     0,   162,
       0,     0,     0,     0,     0,     0,   214,  1006,  1010,  1069,
    1684,  1068,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   324,     0,   616,  2402,   592,     0,  1322,     0,  1318,
    1314,  1383,  1382,  1381,     0,  1328,  1337,  1334,     0,  1021,
     382,   500,   168,     0,     0,     0,   604,   607,     0,   125,
     179,   365,     0,   178,   180,   182,   183,   184,   181,   185,
     531,   535,     0,   506,     0,     0,     0,     0,     0,   556,
     555,   559,   557,     0,   553,     0,     0,     0,   157,   464,
     466,  2100,     0,   367,   446,     0,     0,     0,   795,     0,
       0,     0,     0,     0,  2120,     0,     0,     0,     0,  1166,
       0,  1274,  1137,  1265,  1276,  1267,  1269,  1305,     0,  1676,
       0,  1135,     0,   877,     0,  1049,  1797,   300,     0,   875,
     173,  1679,     0,     0,     0,     0,     0,   879,   648,   165,
       0,   300,   300,   509,     0,   300,   167,     0,     0,     0,
     501,   300,   665,  2474,  2480,  2478,  1125,     0,  2556,  2557,
     457,  1170,  1097,  1106,   722,   729,   711,   728,   727,   709,
     726,   723,  2258,     0,     0,  2449,     0,   740,     0,   414,
       0,     0,     0,   754,     0,     0,   753,   768,   755,     0,
     757,   750,   749,   758,     0,     0,   777,  1130,     0,  1131,
    1659,     0,  1127,     0,  1148,     0,  1146,     0,  1301,  1150,
    1139,  1117,     0,  1115,  1120,  1122,  1121,  1119,     0,     0,
       0,   737,     0,     0,   300,   998,     0,  1612,     0,  1613,
       0,     0,     0,  1648,  1644,     0,     0,     0,     0,     0,
    1620,  1621,  1622,  1619,  1623,  1618,     0,     0,  1624,  1617,
       0,     0,     0,     0,     0,  1367,  1366,     0,     0,     0,
       0,     0,     0,     0,  1455,  1487,     0,     0,  1576,     0,
    1602,  1634,     0,     0,  1378,     0,     0,     0,     0,     0,
       0,     0,  1602,  1640,     0,     0,     0,  1546,     0,  1543,
       0,     0,     0,     0,  1659,     0,     0,     0,     0,  1696,
    1398,  1414,  1670,     0,  1661,     0,     0,  1421,     0,  1641,
    1448,     0,  1453,  1436,     0,  1429,     0,  1434,  1438,  1417,
    1662,  1601,     0,  1599,     0,     0,  1415,     0,  1410,  1408,
    1409,  1402,  1403,  1404,  1405,  1406,  1407,  1411,  1580,  1578,
    1579,     0,     0,     0,  1433,  1791,  1822,     0,  1210,  1210,
    1198,  1208,  1669,     0,  1307,     0,     0,     0,     0,  1559,
       0,  1606,     0,  1604,  1686,  2456,  2455,  1660,     0,     0,
       0,  1675,     0,     0,  1394,     0,   240,  1299,  1655,     0,
     671,   672,   670,  1322,  1160,     0,     0,  1310,     0,  1159,
    1093,  1077,  1073,  1072,  1666,  1092,  1197,     0,   807,   808,
       0,   812,     0,     0,  1239,  1252,     0,  1151,  1151,     0,
    1243,  1244,  1235,  1184,  1183,  2172,  2230,  2177,  2198,  2168,
    2201,  1396,  2150,  2190,     0,  2124,  2294,  2295,     0,  2285,
    2286,  2255,  2261,  2332,     0,  2448,     0,     0,   614,   613,
       0,     0,     0,   945,   909,   669,   946,   910,  1043,     0,
    1045,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   300,  1052,   947,   296,  1053,   938,
       0,     0,     0,   514,   515,     0,   852,   853,   948,   911,
       0,   939,   834,  1337,   818,     0,     0,   829,     0,   828,
    1337,  1337,   912,   169,   260,   382,   936,   276,   289,   284,
     285,   283,  1797,   300,  1797,   300,     0,     0,     0,     0,
     286,   281,   282,   278,   291,   292,   920,     0,   306,   309,
     293,   274,   277,   275,   258,     0,     0,  1682,     0,     0,
     881,     0,     0,   160,   923,     0,   140,   142,   144,     0,
     138,   146,   141,   143,   145,   139,   147,   137,     0,   136,
       0,     0,     0,   130,   954,   916,   473,   478,   918,   481,
     941,   479,  1713,  1771,  1899,     0,   521,   523,     0,   528,
     960,   917,     0,   940,   956,   925,     0,     0,     0,     0,
       0,     0,     0,  1058,     0,     0,     0,   955,   932,   943,
       0,   924,   919,   942,     0,     0,   212,   211,   213,     0,
       0,     0,     0,     0,     0,     0,     0,   704,   680,   703,
       0,     0,     0,     0,     0,     0,     0,   674,   338,   316,
     317,     0,     0,   315,   321,   615,     0,     0,     0,  1319,
    1315,     0,     0,     0,     0,     0,     0,  1335,     0,     0,
    1041,  1041,  1041,  1041,  1041,  1041,  1041,  1022,  1050,   499,
     517,     0,     0,     0,     0,   151,   128,     0,   637,   603,
       0,     0,   415,   174,     0,     0,     0,   505,   602,   600,
     599,   601,     0,     0,     0,   620,     0,  1311,     0,     0,
       0,     0,   369,     0,     0,   366,   370,   374,   375,   376,
       0,   458,   460,     0,     0,   450,     0,     0,     0,   823,
       0,   841,   824,     0,     0,     0,   861,   866,   862,   844,
       0,   489,  2118,  2112,  1171,  1172,     0,  1186,     0,  1276,
       0,  1275,  1287,     0,     0,  1293,  1291,     0,  1293,     0,
    1293,     0,  1268,     0,  1270,  1287,     0,  1677,     0,  1308,
    1136,   300,     0,     0,   511,   300,     0,   300,     0,   300,
     300,     0,   981,   538,     0,   588,     0,     0,   300,   650,
    1603,     0,     0,  2257,  2445,   741,   417,     0,     0,     0,
       0,   752,     0,   487,   756,     0,   767,   762,   764,     0,
     771,     0,     0,  1133,     0,  1149,  1142,  1144,  1143,     0,
       0,  1140,  1609,   649,     0,     0,   300,     0,   772,  1215,
    1610,  1611,     0,     0,     0,     0,  1645,     0,     0,  1522,
    1498,  1500,  1336,  1512,     0,  1349,  1523,  1524,  1502,  1504,
       0,  1593,     0,     0,  1513,  1457,  1458,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1470,  1469,  1514,  1575,     0,     0,  1632,  1633,  1515,  1379,
    1380,  1380,     0,     0,  1639,     0,     0,     0,  1520,  1525,
       0,     0,  1530,     0,  1551,     0,     0,     0,  1480,  1603,
    1371,  1372,     0,     0,     0,     0,     0,     0,     0,     0,
    1454,  1437,  1431,     0,  1435,  1439,     0,     0,     0,     0,
    1423,  1449,  1419,     0,     0,  1425,     0,  1450,  1210,  1210,
    1210,  1210,  1207,     0,     0,  1263,     0,  1248,  1219,  1219,
       0,  1559,     0,  1488,     0,  1559,     0,     0,  2307,  2309,
    2310,  2311,  2312,  2313,  2315,  2316,  2318,  2319,  2320,  2308,
    2314,  2317,  2321,  2298,  2299,     0,  2289,  2290,   196,     0,
     221,   207,     0,  2332,     0,     0,  1154,  1135,  1157,  1075,
    1222,     0,  1594,   812,   810,   811,  1224,     0,     0,  1259,
    1258,  1257,  1232,     0,  2232,  2160,     0,     0,  2331,  2334,
    2345,  2343,  2170,   944,   908,   937,  1041,   782,   783,     0,
     781,     0,     0,     0,   407,   797,     0,     0,     0,     0,
    1055,   498,     0,   497,   493,   513,   846,     0,  1337,   821,
     826,   827,     0,   379,     0,     0,     0,   261,     0,     0,
     273,     0,   269,   287,   279,   288,   280,   303,     0,     0,
       0,   950,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   951,     0,     0,   133,   132,     0,   150,     0,   525,
     526,   524,   520,     0,   527,   529,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   949,   913,
     675,     0,     0,   676,   684,     0,     0,   677,     0,     0,
       0,     0,     0,     0,   686,   341,     0,   344,   352,   325,
     329,  1057,  1057,     0,   330,  1057,   326,  1057,   323,   617,
       0,  1849,  1583,  1584,   611,   618,   608,   610,   609,   612,
     583,     0,     0,     0,  1320,     0,  2546,  2554,  2553,     0,
    1394,     0,  1041,  1040,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   393,     0,     0,   387,     0,     0,
     866,   381,   384,   385,     0,   510,   153,     0,     0,   154,
     152,     0,   605,   606,     0,   365,     0,     0,   558,   561,
     554,     0,   619,   621,   597,     0,  1313,   517,  1126,   463,
       0,   446,   400,   442,     0,   456,     0,   444,   443,   445,
       0,   452,  1019,     0,   798,   822,     0,     0,     0,   859,
     863,   860,     0,     0,   837,     0,   845,   815,   976,   977,
     974,   975,     0,     0,  2135,  1162,  2144,  1278,  1285,     0,
    1266,     0,  1292,  1288,     0,  1289,     0,     0,  1290,     0,
       0,  1285,     0,     0,     0,   878,     0,   300,   876,     0,
     644,     0,   646,   880,   300,   300,   546,     0,   502,   460,
       0,     0,     0,     0,   751,   769,     0,   765,     0,     0,
     734,   774,  1129,  1132,  1134,  1147,  1145,   777,     0,   735,
     776,  1614,  1355,     0,  1647,  1643,     0,  1615,     0,  1627,
    1626,  1456,  1628,     0,  1475,     0,     0,  1467,  1465,  1466,
    1459,  1460,  1461,  1462,  1463,  1464,  1468,  1637,  1636,  1630,
    1631,  1375,  1373,     0,  1517,  1518,  1519,  1638,  1526,     0,
    1545,  1544,     0,     0,     0,  1532,     0,     0,  1541,     0,
    1577,  1361,  1394,  1399,     0,     0,  1422,  1642,  1440,     0,
       0,     0,  1418,     0,     0,     0,     0,  1427,  1593,     0,
       0,     0,     0,     0,     0,  1202,  1201,  1306,     0,  1250,
       0,     0,  1218,     0,  1559,  1495,  1562,  1557,  1558,  1607,
    1489,  1694,     0,  1605,  1559,     0,     0,     0,  1656,  2330,
       0,  1161,  1152,     0,  1223,  1240,  1233,  2176,     0,  2231,
    2296,  2297,     0,   788,   789,   787,     0,     0,     0,   583,
       0,     0,   423,     0,   806,   806,     0,     0,   866,   959,
     494,   847,     0,   839,     0,   266,   935,     0,     0,     0,
     265,     0,   300,   300,   307,   308,   311,     0,     0,     0,
       0,     0,   638,   624,     0,     0,   639,   640,     0,     0,
     883,   884,   882,   148,   134,   135,   149,   522,   921,     0,
       0,     0,     0,     0,   958,   931,   957,   929,   928,   930,
     922,   548,     0,   678,     0,     0,   679,   690,   688,   687,
     689,   681,   342,   127,     0,   322,     0,   350,     0,   347,
     348,   346,   349,     0,     0,     0,     0,     0,     0,   585,
       0,     0,   590,   579,   581,     0,     0,     0,  1316,     0,
       0,     0,     0,     0,     0,  1321,  1329,   578,     0,  1032,
    1031,  1030,  1034,  1033,  1036,  1035,  1027,  1026,  1039,  1038,
    1025,  1024,  1029,  1028,     0,     0,   391,   395,   396,   394,
     386,   866,   415,   454,     0,   156,   155,     0,     0,     0,
       0,   563,   567,   598,     0,  1312,   542,  1124,     0,  2101,
       0,   372,   377,   378,     0,   450,   397,     0,   446,   371,
     459,     0,     0,   455,     0,  1014,     0,     0,   825,   842,
     843,     0,     0,   866,   865,     0,   496,     0,  2108,  1277,
       0,     0,  1279,     0,     0,  1281,  1283,     0,     0,     0,
       0,     0,  1680,  1559,  1309,   300,   512,   300,   300,   982,
     589,     0,   761,   760,   759,   488,     0,   763,   300,     0,
    1646,  1511,  1521,  1625,     0,     0,  1476,     0,     0,  1516,
    1985,     0,     0,  1549,  1550,  1531,     0,  1835,  1536,     0,
       0,     0,  1697,  1446,  1444,  1441,     0,  1442,     0,     0,
    1424,  1420,     0,  1426,  1451,  1206,  1205,  1204,  1203,     0,
       0,  1553,  1559,  1559,  1490,  1564,  1561,     0,  1492,  2300,
       0,  2303,  2301,  2302,  2306,  1394,  1158,     0,  2233,  1047,
       0,     0,     0,   409,     0,   866,     0,     0,     0,   804,
     809,   809,     0,   866,   454,   840,   262,   263,   264,   267,
     302,   272,   268,     0,   952,   914,     0,     0,   630,     0,
       0,     0,     0,   953,   915,     0,     0,     0,  1063,     0,
       0,   682,   683,   324,     0,   345,   355,   356,     0,   353,
     327,   332,     0,   334,   333,   328,   331,   587,   586,   584,
     580,   582,  1317,     0,   897,   897,  2547,  2548,  2549,  2550,
    2551,  2552,     0,   583,  1037,     0,     0,   383,   454,   422,
       0,   388,     0,   518,     0,  1019,   367,   517,   562,     0,
       0,     0,   622,   461,     0,   368,     0,     0,   452,     0,
       0,     0,   450,     0,   447,     0,   451,     0,     0,     0,
       0,     0,   864,     0,   868,     0,   836,   813,  1307,     0,
     500,  2134,  2138,     0,  1286,  1295,     0,  1282,  1280,  1271,
       0,  1273,   898,   645,   647,   547,   766,   773,   300,  1471,
       0,     0,     0,     0,  1527,     0,  1528,  1533,  1537,     0,
    1534,  1535,  1443,  1447,  1445,  1428,  1247,  1249,     0,  1187,
    1493,  1494,     0,  1219,  1559,  2305,  2304,   222,  1595,   767,
       0,   300,   806,   454,   424,  1849,   425,   805,   812,   812,
       0,   454,   583,     0,   270,   310,     0,     0,   636,   625,
       0,     0,   641,     0,     0,     0,     0,     0,   685,   314,
     340,   351,     0,   335,   897,     0,   894,   893,   577,     0,
     390,   389,     0,   433,     0,   516,     0,   634,  1015,   530,
     564,   565,   560,     0,     0,   462,   373,   382,   358,   406,
     405,   402,   401,   403,   404,   399,   398,     0,   452,   448,
     449,     0,  1016,     0,  1065,     0,   799,   867,     0,     0,
       0,   495,   490,     0,  2136,  1284,     0,  1272,   736,  1472,
       0,  1473,     0,     0,  1539,  1538,  1552,  1554,     0,     0,
    1567,  1491,   784,     0,   785,   809,   428,     0,   802,   801,
     415,   583,   410,   301,     0,   628,   635,   626,   636,     0,
       0,  1059,     0,  1060,  1061,  1064,   354,   892,   896,   895,
       0,   419,   420,   421,     0,   392,   429,   430,     0,   519,
       0,     0,     0,     0,   380,   441,   357,  1017,  1018,   305,
       0,   866,   869,   980,  2139,  2141,  2140,     0,  1294,  1474,
    1542,  1529,  1540,     0,     0,  1563,     0,     0,     0,     0,
     812,     0,   583,     0,   422,   411,     0,   627,   643,   642,
       0,     0,     0,     0,     0,   431,     0,   432,   453,   633,
       0,   566,     0,     0,   452,   800,   814,   979,   978,     0,
    2137,  1555,  1556,  1950,     0,  1927,     0,  1565,  1568,  1566,
    1560,   300,   803,     0,   412,   426,   433,     0,  1062,   567,
     438,     0,   437,     0,   435,   434,   623,   570,   304,  1307,
     962,   973,   961,   963,   971,   968,   970,   969,   967,     0,
    1572,  1571,  1570,  1574,  1573,   786,     0,   583,   629,     0,
     436,   440,   439,   575,     0,   568,   571,   576,   574,   572,
     573,   790,     0,   972,   966,  1186,  1173,     0,   427,   413,
       0,   549,     0,   964,   973,  1569,     0,   569,   965,     0,
     570,     0,   550
};

/* YYDEFGOTO[NTERM-NUM]. */
static const short yydefgoto[] =
{
      -1,     1,   247,   248,  1652,  2452,  2355,  3055,  3056,   249,
     250,  1707,   251,   252,   253,   254,   255,   256,   257,  1683,
     258,   259,  1239,  1833,  2463,   260,  2267,  1037,  2141,  2142,
    2407,  2143,  2131,  1510,  2144,  1653,  1675,   262,   263,  1504,
    2123,   264,   265,   266,  1696,  1697,  1660,  1876,  4224,  2344,
    4404,  2917,  2918,   267,   268,  3021,  1778,  3023,  3024,  3488,
     851,  2430,  3843,  3844,  3476,  3477,  3851,  4088,  4089,   269,
    1830,  3084,  3561,  3085,  3920,  3086,  3921,  3087,  3922,  3048,
    3531,  3532,  3533,  3088,  3926,  4275,  3089,  2282,  1361,  1959,
    1960,  4253,  3771,  3772,  4382,  4345,  4346,  4347,  4434,  3928,
    3095,  3571,  3933,  4121,  1850,  2494,  3090,  3091,  3919,   270,
     271,  2489,  1722,  1723,  2361,  3494,  3174,   272,  1256,  3393,
    4160,  3049,  3050,   273,   839,   274,  1837,   275,   276,   277,
     278,  3535,  4122,  1727,  2965,  2966,  2967,  2968,  3444,   279,
    1835,  1728,  2472,   280,   281,   282,  2396,   283,   284,   285,
    1844,  2483,  2484,  3912,  4129,  4262,  4131,  4464,  4465,  4113,
    3862,  3863,  3864,   286,   287,   288,   289,  1829,  2455,  2456,
    3495,  1642,  1782,  2432,  2433,  3551,  3552,   290,  3802,  3803,
     878,  4351,  4327,   291,   292,  3806,  3807,   293,   294,   295,
     296,   297,   930,  1306,  1307,  2891,   298,  2159,   299,  1218,
    3008,   300,   964,  1333,  1334,   301,   302,   975,  2621,   977,
    1973,  3176,  3177,  3640,  2586,  1153,   303,   304,  2596,  2624,
     305,  1655,  2273,  2274,  3766,   306,   879,  1855,  2497,  2860,
    4285,  3773,  4050,  2801,  3356,   307,   880,  1679,  2310,  2500,
    3100,  3101,  2312,  2760,  3583,  2314,  3102,  3107,  3108,  3109,
    3579,  3587,  4154,  4155,   308,  1677,  2303,   309,   310,   311,
    1702,  1170,   312,   902,   903,   313,  4246,   314,  1276,   315,
     996,  1993,   316,  2325,  3408,   317,   318,   319,  4442,  4472,
    4473,  4474,  3592,  4409,   320,  4444,  1376,   322,   323,   324,
     842,  1190,  1191,  1192,   325,  3935,   326,   327,  2449,  3047,
    3514,   328,   329,  2268,  2850,   330,   331,   332,  1823,   333,
     334,   335,   336,  1760,   337,  1543,  1544,   338,   339,   846,
    1057,  1547,  1555,   340,   943,  1327,  1328,  1329,  1934,   341,
    1380,  2613,   944,  1320,   945,  1979,  2598,  2599,  2602,   946,
    1871,   345,  1983,  2607,  2610,   947,  2163,  2164,  2165,  2166,
    2167,  2785,   948,   966,  1266,  2508,   949,  1464,   350,   351,
     352,   353,  1061,  1062,  2101,  2750,   984,  1561,  1022,  1072,
    3732,  2180,  2181,  2201,  2202,  1570,  1571,  2191,  2193,  2803,
    2194,  2812,  2186,  3729,  4021,  2197,  2198,  1573,  1574,  2807,
     354,  2754,  2512,  2513,  2514,  3121,  3131,  3603,  3955,  2515,
    1370,  1054,  2516,  3307,  2521,  3076,  3077,  2315,  2440,  1804,
    1465,  1805,  2447,  1466,  2025,  1807,  1467,  1468,  1469,  1810,
    1470,  1471,  1472,  1473,  2009,  2065,  1474,  1475,  2044,  1101,
    1102,  1918,  2663,  1477,  1478,  3698,  4000,  3991,  2688,  2689,
    2138,  3694,  4199,  4306,  4307,  3740,  3737,  4025,  4203,  4378,
    4417,  4418,  1479,  2741,  2093,  1172,  1480,  3497,  2095,  2683,
    2762,  2763,  2256,  2007,  2630,  2646,  2647,  2660,  3223,  2667,
    2672,  3246,  3247,  2684,  2710,  1481,  2633,  2634,  3207,  2011,
    1482,  1533,  1534,  2109,  2706,  1550,  1551,  1059,  1483,  1484,
    1974,  1046,  3951,  1284,   690,  2926,  2154,  1194,   981,  1485,
    1486,  1487,  3178,  1597,   669,   670,  1139,   795,     2,    75,
     950,  3081,   358,   359,   882,   883,   884,  1258,  1259,  1860,
    1863,  1602,  2234,   671,   672,   699,  3948,  4161,  4294,   936,
     360,   361,   362,   363,  1598,  2230,  1103,    76,    84,    77,
    1104,   400,   401,  2212,   364,   812,   365,  1579,  1083,  3364,
     366,   367,   368,   369,   370,   933,   371,  1085,   372,  1086,
     373,   374,   375,   376,  1093,   377,  1581,  1582,  3759,  1583,
     378,   379,   692,   693,  1318,   380,   381,  1120,  1121,  1352,
    1353,  1608,  1623,  1624,  1625,   382,   686,   383,   384,   385,
    1614,  1615,   386,  2116,  2117,  2239,  2118,   387,  2826,  2827,
     388,  3333,  3334,  4032,  3335,   389,  2112,   390,   391,  1049,
    3369,   392,   808,   393,  1134,   673,   674,   675,  1141,   798,
    1009,   700,  1143,  2969,   800,   801,   677,   678,   679,  1954,
      78,  2834,  1955,  1489,   701,  1490,  2107,  1491,  1492,  1493,
    1494,  1495,  1631,   683,  1110,  1310,  1311,  2835,  1313,    82,
    1314,   397,  3509,  1921,  1354,  1940,  1941
};

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
#define YYPACT_NINF -3907
static const int yypact[] =
{
   -3907,   362,  7704, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, 21036, -3907,
   -3907, -3907, -3907, -3907, 91740,   370, -3907, -3907, -3907, 58140,
   -3907, -3907, -3907,   429, 63420, -3907, 66780,   396, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, 70620, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, 50448,  1068, -3907,
     318, -3907, -3907, -3907, -3907, -3907, -3907, -3907,   -99,  3066,
   -3907, -3907, 67260, -3907,   292, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, 67740,   276, -3907,   465,  1350, -3907,    68, 11392,
   -3907, -3907, 59100, 64380, -3907, -3907, 71100,   578,   418,  1938,
   10877,   -99, 20553, 71580, -3907,  1689, -3907, 47527, -3907, -3907,
   -3907, 63900, -3907, -3907, -3907, -3907,   570, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, 77820,  2146,   482, 48016, -3907,
   -3907, -3907, -3907, 77820, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, 72060, -3907,   761,   768, 78300, 78780,
   61020, -3907,  1433, -3907, 77820,  1010, 49967, -3907, 79260, -3907,
   -3907,   697, -3907, 72540, -3907, -3907, -3907, -3907,   482, -3907,
   50448, 45098, 72540,   218,   671, -3907, -3907, 79740, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907,  1441,   755, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,   276,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,   278,
   -3907,   630,   491,  1372,   724, -3907, -3907, -3907,  5692, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, 93171,  1405, -3907, -3907,
   -3907,   786, -3907,   825, -3907, -3907, -3907,  1854, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907,  1064, -3907, -3907, -3907, -3907,
    1313, 92217, 70620, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, 58620, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907,   160, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, 70620, 70620, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, 70620,   943, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907,   470,  1271, -3907, -3907, 50448,  2195,
    2195,  1584, 93171, -3907, -3907, -3907, 51410, 77820, 77820,  1209,
   77820,  1438, 51410, 77820, 77820,  1342, 41177, -3907, 77820, 77820,
   77820, 77820, 72540, 77820,  1361, 77820, 77820, 80220, 77820,  1484,
   -3907,  1764,  1127, -3907, -3907, -3907, 77820, 11319,  2146, -3907,
   -3907, 77820,  1355, 51410, 77820,  1411,  1410, 77820, -3907, 77820,
    1682,  1657, 77820,  1732, 41670,  1572, 77820, 77820, 77820, 77820,
   -3907, -3907,  1565, 77820, 77820, -3907, 80700,  1320,  1856,  1789,
     546, -3907, -3907,  1965,  1566, -3907, -3907,  2018, 70620, -3907,
   68220, -3907, -3907, -3907,  1939, -3907, 72540, -3907, -3907, -3907,
   -3907, 61500,  1938, -3907, -3907, 51891, 77820,  1872, -3907, 81180,
   -3907,  1955, 52372, 81660, -3907, 42163,  2014, 82140, 82620, -3907,
   -3907, 83100, -3907, 83580,  1754, 84060, -3907, 84540, -3907,  1934,
   85020, -3907, 10279, -3907,  1685,  1984,  1717,   727, 70620, 70620,
    2233, 36812,   276, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907,   126,  1669, 48505,  1005, 48994, -3907, -3907,  1133,  1295,
    1375,   126,  2139,  2139,   174, 70620, -3907, -3907,  1669, -3907,
      -1,   726,  1740,  1740,  1740,  1925,   964, -3907,  1740, 77820,
   -3907, -3907, -3907, -3907, 72540, 48505, 48994, -3907,  1774,  2146,
     -26,  2159, 77820, -3907, 77820, -3907, 77820, 77820, -3907, -3907,
   -3907,  2173,  1809,  2030, -3907,  1813, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907,  1982,  2000,  1995,    34,  2146,  1906, -3907,
   -3907,  2026, 25940,   915, 70620,  2146, 49483, 73020, 89820,   240,
   61500,  2146, 85500,  1857,  1127,  2032, -3907,   598, -3907,  2264,
    1881,  2126,     2,  1127, 38748, -3907,  1904,  1549, 72540, 93648,
   -3907, -3907, -3907, 85980,  2008, -3907,   150,  2230, 26438, -3907,
   77820,  1919, -3907,  1978,  1924,  1962, -3907, 77820,  1115,  1115,
    2346,  1115,  1759,  1808, -3907,  2339, -3907,   671,   -99,  1989,
   -3907, -3907, -3907,  2003, -3907,  2001,  2006, -3907,   665,  2260,
   -3907, -3907, -3907, -3907,  2085,  2091,  2094,  2095,  2028,  2102,
     333, -3907, -3907, -3907, -3907,  2329, -3907, -3907, -3907, -3907,
   -3907, -3907,  2434,  2421, 59100, 59100,   412,   511,   123,   305,
   -3907, -3907, -3907,  2296, -3907, -3907,  2285, 77820,  2127, 77820,
   -3907, -3907, -3907, 86460, -3907, -3907,  2195,  2003,  2067, -3907,
     208, -3907,  1549, -3907,   326,   357,   437,  1385,  2061,  1404,
   -3907,   350,  2098,  2691,  2072,   646,  3078,   333, -3907, 77820,
   77820, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
    2073, -3907, -3907,  2078,  1197,  1561,  4987,  1250,  3158,  1781,
     606,  2251,  1429,  2367,  1246,  3676, 77820,  2090,  2324,   -55,
   -3907,   449, -3907,  2158,  2292,   865, 51410,  2121, -3907, 77820,
   -3907, -3907, -3907, 51410, -3907,  2290, 42656, -3907, 77820, -3907,
   -3907, -3907, -3907,  2240, 77820, -3907, -3907,  2357, 77820, -3907,
    1740,  1073,  2138,  2505, 54777, 77820,  2183,  2549,  2190, -3907,
   -3907,  2183, -3907, -3907, 77820, 77820,  2179,  1107,  2183,  2573,
    2578,  2271,  2372,   776,  1855,    97,  2494,  2183, 77820, 77820,
   77820, 77820,  2572, 51410, 77820, -3907,  2370, 73500, -3907,  2226,
    1965, -3907, -3907, -3907, -3907, -3907,  1143,  2276, -3907, -3907,
   -3907, -3907,  2524,  2067,   265,  2527,  2241,  2532, -3907,  2299,
    2536,  2072,  2550,  2275, -3907, 86940, 87420,  2564,  2073, 77820,
    2581,  2275,  2594,  2457,  2597,   265,  2610, -3907,   884,  2611,
    2462,  2613,  1726,  2275, 61980,  2614,    83, -3907, 14991, 10279,
   -3907, 19052,  1503, -3907, -3907, -3907, -3907, -3907, -3907, 29924,
     663,  2405, -3907, -3907,   671, -3907, -3907,  1683, -3907, 47038,
   -3907,  2233,  1669, -3907, 70620,  1669, 70620,   174,  1669, 70620,
    1669, 70620,   174,  1669, 70620, 70620, 70620,  1669, -3907, -3907,
    1680,  1532, -3907, -3907, -3907, -3907, -3907, 70620,  2326, 77820,
   77820, -3907, -3907, -3907, 64860, 77820, 65340, -3907,   351, -3907,
     223, 70620, -3907, 70620, -3907,  2146, -3907, -3907,  1984, 54777,
    2725, 77820,  2612,  2612,  2612, -3907, -3907, -3907,  2561, 77820,
    2619,  2623, 64860, 77820, -3907, 87900,  2344, -3907, -3907, -3907,
   -3907,  1701,  2473,   379,  2762, 29924,  2345,   251,   251,  2347,
   -3907, -3907, -3907,   479,  2348,  2349, -3907,   490,   490,  2506,
    2355,  2358, -3907,   499,  2369, -3907,  2814,   509,  2371,  2376,
    2380,  1975,   251, 29924, -3907,  2383,   490,  2393,  2396,  2401,
    2824,  2402, -3907,  2839,  2407,   181,   272,  2408,  2411, -3907,
    2355, -3907,   229,  2420,  2422,  2424,  2425,  2426,  2429,  2430,
   29924, 29924, -3907, 24944, -3907,  2146, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907,    88, -3907,   568,  4450, -3907, -3907,  2521,
   29924, -3907, -3907,    16, -3907,   582, -3907, -3907,  1549, -3907,
   -3907,  1354, -3907, -3907, -3907, -3907,  1631,  1631,   172, -3907,
   67260, 67260, -3907, -3907,   833,  2418, -3907,  1156, -3907, -3907,
   -3907, -3907, -3907, -3907, 59580,  2766, -3907,   794,   449,   179,
    2743, 46060, 46549,  2668,  2668,  2661, -3907, -3907, 77820, -3907,
   -3907, 29924, 44136, -3907,  1549,   170,  2675, 77820, -3907, 39232,
   -3907, -3907, -3907,  1727, -3907, -3907, -3907,   276, -3907, 10568,
   -3907,  1730,  1919, 77820, 77820,  2836, -3907, -3907,  1978, -3907,
   -3907,  1372,  1372, 29924,  1372,  1016,  1281, 26936, 29924,  2723,
    2621,  1098,  1300,  2726, -3907,  1759,  1808, -3907, -3907,  2003,
    2454,  1658, -3907, 56700, 92694, 92694,  2689, -3907, -3907,  1135,
      58,  2562,  2655,  2139,   923,  1820, -3907, -3907,  2450, -3907,
    2780, 67260,  2511, 59100, -3907, -3907, 77820, -3907, -3907, 73980,
   -3907, -3907, -3907,  1911,  2458, -3907,  2475, 77820,  2955, -3907,
    1820,  1820, -3907, -3907,  2466, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, 93171,  2470, 77820, -3907,  2471,  2476, -3907,
   93648, 44617,  1508,  1549,  2543,  2547, 50448,  2477,  2551,  2552,
   90300, -3907, -3907, -3907, -3907,  1257,   975,   159,  2554,   676,
   -3907, 77820,  2659,   333,  2598, -3907,  2558,  2559,  2669,   333,
     127, 90780, -3907, -3907, -3907, -3907, -3907,  2751, 22990, -3907,
   -3907, -3907,  2563,  2541, 60060,  2850,  2666,   -46,  1516,   102,
   77820,  2746,  2570,  2574,  2508,  -104,  2502, -3907,  2671,  2565,
    2575, 53815,  2672, 43149,  2840,  2590, -3907,  1333,  2592,  2603,
     333, -3907,  2906,   333,   333,  1695,  2912,  2606,   144,  1671,
    2183,  2502,  2390, -3907,  2538,  2609,  1182, -3907,  2710,    91,
    1702,  2502,  2615,  2616,  2508,  2508, 77820, 77820, 77820, 77820,
   77820,  2617,  2620,  2656, 68700,  2625, 89820, -3907, -3907,  2630,
    2035,  2502,  1581, -3907,  1524, -3907, -3907,  1127, -3907, 77820,
   -3907, 77820,  2067, 54777,  2716,  2072,   333, 77820, 77820,  2073,
    1172,  1035,  2717, 77820,  2778,  2582, -3907, -3907,  2183, -3907,
   44617,  2179, -3907,  2553, -3907,  2607, -3907,  2607,  2607,  2566,
    2566,  2568, -3907, -3907,  1975,  2607,  2566, -3907, 55739, -3907,
    1453,  1458, -3907,  2963,  2967, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907,  1147, -3907,  1734, -3907, -3907, -3907,
    2979, -3907, -3907, 54777, 77820, -3907,  2896,  2626, 50448, -3907,
    2618, -3907, 77820,   180,  2146,  2635, 77820,  2790, 77820, 77820,
   77820, 77820, -3907, -3907,   633,    14, -3907, 68700, -3907,  2390,
    2972,   -74,  1740,  2861, -3907, 77820,  2583,  2991,  2827, -3907,
   -3907,  2599,  2139, -3907,  2226, -3907,  1707, -3907,  2719, -3907,
   33894,  2638, 51410,   265, -3907, -3907, -3907, -3907, 54777, 77820,
   88380, 51410,   265, 77820, 77820,  2893,  2657,  2898,  2660, 43149,
     265,    87, 77820, 77820, 77820, 77820, -3907, 77820, -3907, -3907,
   -3907, -3907, 77820, 77820, 77820, 68700,  2899,  2902,   265, 77820,
   77820, -3907, -3907, 16039,  1569, -3907, 10279, -3907, 10568,  1736,
    2668, -3907,   943, 77820,  1200,  2233, 65820, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, 70620, -3907, 70620,   174,
   -3907, -3907, 70620, -3907, 70620,   174, -3907, 70620, -3907, -3907,
   -3907, 70620, 77820,  3094,  2628, -3907,  1354, -3907, 77820,  1745,
   -3907, -3907,  1753,   739, 77820,   444, 51410, 77820,  2792, 77820,
   77820, 77820, 77820,  2684,  2418,   746, -3907,  2662, 38264,  2740,
   -3907,   573, 72540,  2803, -3907, -3907, -3907, -3907, -3907,  1762,
    1233,  1215, -3907, -3907, -3907, -3907, -3907, -3907, 65340, 63900,
    2897,   176, 77820, -3907, 29924, 25442, -3907, -3907, -3907,  2624,
   10568,  2658, 29924, -3907, -3907, 29924,  2139,  2139, 29924, -3907,
   -3907, -3907, -3907,  1218,  2139, -3907, 29924, 29924,  2139,  2139,
    2607,  2607, -3907,  9510, 29924, -3907, 43149, 29924, 31418, 22491,
   29924,  2698,  2646,  2139, -3907,  2139, -3907, 29924, 24446, -3907,
   29924,  2841, 29924,   179,  2843, 29924,   179,  3048,  3048,  1760,
    5160,  2634, -3907,  2741,  2139, -3907,  2139,  1138,   156, 54777,
   29924, 50448,  2715,   116, 29924,  2644,  1660, -3907, 29924,   685,
   -3907,  2650, 29924,  2724, 29924, 29924, 29924, 29924, 29924, 29924,
   29924, 29924, 29924, -3907, 32414,   190, -3907,   417,   336, 66300,
   25940,  2930, -3907, 21992, -3907,   195, 70620, -3907, -3907,  1549,
   -3907, -3907, -3907, -3907, -3907,  1911,  2663, -3907,  2673, -3907,
   -3907, -3907, -3907, -3907, 77820,  2766, -3907, -3907,  2731, -3907,
   -3907, -3907, -3907,   627, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907,  2664, -3907, -3907, -3907, -3907, -3907,  2664, -3907, -3907,
    2668,  2667,  3674, -3907, -3907, -3907, -3907,  2926,  2931,   265,
   93171, -3907, 77820,    37, -3907, -3907, -3907,  2682, -3907, 77820,
     150, 69180, -3907, 26438, -3907,  1768,  2355, -3907,  2910, -3907,
    2676, -3907,  8417,  2910, -3907, -3907,   122,  2847,  2853,  2853,
   -3907,  2677, 10568, -3907,  1878, 10568,  1920, -3907, -3907, -3907,
   -3907, -3907, -3907,   -57, -3907,  2723,  1300,  1865, -3907,  2003,
   -3907, -3907, 19993, -3907, 21513, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907,  2681, -3907, -3907, -3907, -3907,   333,
    2683,  3144, -3907, 59100, -3907, -3907, -3907,  3094, -3907,  2018,
   -3907,  2018,  3170, -3907, 70620, -3907, -3907, -3907, -3907,  1014,
   -3907, 10279, -3907, 10279, -3907,  2685,  1772,  2757,  2759,  2805,
   77820, 77820, -3907, 50448, 77820, 77820, 77820, -3907,  3043,   341,
   63900,  2812, 62460, -3907, -3907,  2699, 77820,  2748,  2932,  2937,
    2700, -3907, -3907, 77820, -3907,  2884, 77820, 29924,  2891, 77820,
     937,  2892, -3907,   757, 77820, 77820,  2885, -3907, -3907, -3907,
   61500, -3907, -3907, -3907,  2877, -3907, -3907, 55739, -3907, -3907,
    1779, -3907, 55258, 52853, -3907, -3907,   413, 77820, 77820, 77820,
    1039, -3907, -3907, 54777, -3907, 77820, 77820, 77820, 69660, 88860,
   89340,  1061,  1136, 77820, 70140, -3907, 77820, 77820, 77820, 50448,
   -3907, 77820,  2887,   614, -3907,  2315,  2785, 77820, 77820,  2718,
    1790,  2788, -3907, 77820, 77820,  6860, -3907, 77820, 77820, -3907,
   -3907,   333, -3907, -3907, -3907, -3907, -3907, 77820, 77820,   333,
   77820,   333,  1391, -3907, 50929, 77820, -3907, -3907, -3907, 77820,
   77820, 77820, 77820, 77820, -3907, -3907,  1033,   471,  2852,  2856,
    2858, 77820, 77820, 77820, -3907, -3907,  2833, -3907, 77820,  6860,
   77820, 77820,  2798,  2799,   154,  2872, -3907, -3907, -3907, -3907,
   -3907, -3907,  2968,  3127, 77820,  2969,  2971,  2791,  2793,  2974,
    1400, 77820, 77820, 77820, 77820, 77820, 77820,  2976,  1400,  2913,
      61,  2744,  1796, -3907,  2760, -3907, 29924,  3143, 54777,  2752,
    2758,  2819, -3907,  2828,  2139, -3907,  1805, -3907,   633,  1297,
   -3907,   -40,  4859,  3039, 77820,  1815, -3907,  2774, 77820,  4859,
   -3907,  1210, 63900, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907,  3041, -3907,  2146,  2179,  2179,  2179,  2179, -3907,
   -3907, -3907,  2943,  1705, -3907,  2769, 77820,  2878,  4859, -3907,
    2390,  3062, 77820, 60540,  1913,  3167,  2146,  2949, -3907, 23475,
    3211,  2950, 61500, 73500, -3907,  2786,  3042,  3044,  3063, -3907,
   33410, 74460,  2781,  1606, -3907, 74460, 74940, -3907,  2787,  1549,
   27434,  2740,  2067, -3907,  3179, -3907,  3076,   265,  2072, -3907,
    2275, -3907, 77820, 77820, 77820, 77820,  2073, -3907, -3907,  2275,
    2964,   265,   265, -3907,  2965,   265,  2275,  2895,  3074, 61500,
   -3907,    83, -3907, -3907, -3907, -3907, -3907, 29924, -3907, -3907,
    2795,  1707, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, 70620,  2018, -3907,  1829, -3907, 77820, -3907,
    3052,  3053,  3055,  2275,  2831, 77820,  2800, -3907,  2275,   333,
    2275,  2418,  2418,  2275, 75420,  3210,  3079, -3907,  1840, -3907,
   -3907, 25940, -3907,   556, -3907,   667,   731,  3010, -3907, -3907,
   -3907, -3907, 54777, -3907, -3907, -3907, -3907, -3907, 77820,    53,
    2981,  2806, 75420,  3190,   265, -3907,  1843, -3907,  1591, -3907,
    1605, 29924, 29924,    69, -3907,  8741,  1847,  2815,  2820,  1850,
   -3907, -3907, -3907, -3907, -3907, -3907,  2823,  3088, -3907, -3907,
    2825,  1859,  1864,  2826,  2829, -3907, -3907,  4643,  2835,  9234,
    2842, 31418, 31418,  1509, -3907, -3907, 31418,  2844, -3907,  1876,
    7224,  2817,  2845,  2832, -3907,  2849,  2854,  8997, 27932, 29924,
   27932, 27932,  9880,  2817,  2855,  1892, 50448, 10203,  1909, -3907,
   29924, 50448,  4723, 29924, -3907, 29924, 77820,  2857,  2859, -3907,
   -3907,  9510, -3907,  2846, -3907, 31418, 31418,  3619, 24944, -3907,
   -3907,  3109, -3907, -3907,  1677, -3907,  2837, -3907, -3907,  5358,
     134, 29924,  2644, 29924,  2911, 43149, 10643, 29924,  4181,  4193,
    4193,   353,   353,   135,   135,   135,  1626,   336, -3907, -3907,
   -3907,  2851,  2402, 29924, -3907,  1990,  1998, 77820,  1963,  2560,
   -3907, -3907, -3907, 33894,  2876, 29924, 29924, 29924,  2863,  3009,
    3274, 10568,   551, -3907,  3277, -3907, -3907, -3907,   457,  3170,
    1911, -3907,  1127,  2139,  1138, 47038, -3907, -3907, -3907, 29924,
   -3907, -3907, -3907, -3907, -3907,  1930, 39232,  2638, 26438,  1549,
    1978, -3907, -3907, -3907, -3907, -3907, -3907, 29924, -3907, -3907,
     674,  1900, 29924,  1878, -3907, -3907, 77820,  2803,  2803, 29924,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907,  1253, -3907, -3907,
   -3907, -3907, -3907, -3907,  2864, -3907,  2867, -3907,  2886, -3907,
   -3907, -3907, -3907,   147,  2871,  2880,  2873,  1344, -3907, -3907,
   77820, 77820, 77820, -3907, -3907, -3907, -3907, -3907, -3907,  3096,
   -3907, 77820, 77820,  3049, 77820,  3056,  3060, 29924,   532, 77820,
    2888,  2889,  2890, 77820,   265, -3907, -3907, 10568, -3907, -3907,
    2934,  2961, 77820,  2710, -3907,  3136, -3907, -3907, -3907, -3907,
    3080, -3907, -3907,  1734, -3907, 52853, 55258, -3907, 55258, -3907,
    1734,  -129, -3907,  2275, -3907, -3907,   725, -3907, -3907, -3907,
   -3907, -3907,  3186,   265,  3188,   265, 77820, 77820, 77820, 77820,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907,  1933, -3907,  1408,
   -3907, -3907, -3907, -3907, -3907, 77820,  1592, -3907,   864, 54777,
   -3907, 54296, 77820, -3907, -3907,  3118, -3907, -3907, -3907,  3057,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,  1529, -3907,
    3058, 77820,  2956, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, 50448, 50448, 50448,  1943, -3907, -3907,  2146, -3907,
   -3907, -3907,  2975, -3907, -3907, -3907,  3112,  3114,  3116,  2977,
    2983,  2984,  2986, -3907,  2989,  2995,  2997, -3907, -3907, -3907,
   77820, -3907, -3907, -3907, 77820, 77820, -3907, -3907, -3907,  1400,
   54777,  3145,  1400,  1400, 77820, 77820,  1400, -3907, -3907, -3907,
    3162,  3164,  3165,  3171,  3172,  3173,  1400, -3907, -3907, -3907,
   -3907,  1073, 50448, -3907,  2649, -3907,  1939, 40684,  5687,  2935,
    2758,  2908,  2139, 36328,  1298,  3140,  2941, -3907,  1708,  3163,
    2960,  2960,  2960,  2960,  2960,  2960,  2960, -3907,   890, -3907,
    3113, 77820,   869, 77820,  2139, -3907, -3907,  3013, -3907, -3907,
   50448, 40684,  1740,   180,  3083,  1337,  3276, -3907, -3907, -3907,
   -3907, -3907, 77820, 77820,   633,  2146,  1948, -3907, 54777, 77820,
   70620,  1441,  2970, 77820,  2948,  2952, -3907, -3907, -3907, -3907,
    1949, -3907, 54777,   -25,  3138,  3135,  1441,  3047, 77820, -3907,
    1968,    48, -3907,  2146, 61500, 53334, -3907,  3335, -3907, -3907,
     875,  3237, -3907, 77820, -3907, -3907, 37780, 35346,  1606,  2978,
   77820, -3907,  2980, 33894,  3203,  3147, -3907, 33894,  3147,  1234,
    3147,  3209, -3907, 39716, -3907,  2985, 21992,  1633,  3161, 10568,
   -3907,   265, 54777, 77820, -3907,   265,  3034,   265,  3037,   265,
     265, 77820, -3907, -3907, 77820, -3907, 77820, 68700,   265, -3907,
   10568, 77820,  3271, -3907, -3907, -3907, -3907,  3110,  3111,  3117,
   77820,  2275, 51410, -3907,  3001, 77820,  1093, -3907, -3907,  3169,
   -3907,  1441, 77820,  1549,   131, -3907, -3907, -3907, -3907,  3286,
    3298, -3907, -3907, -3907, 77820, 64860,   149, 77820, -3907, -3907,
   -3907, -3907,  3011,  1972, 10300, 29924, -3907,  3305, 54777, -3907,
   -3907, -3907, -3907, -3907, 29924, -3907, -3907, -3907, -3907, -3907,
   29924, -3907, 29924,  3283, -3907,  3431,  3431, 54777, 31418,  1568,
    2393, 31418, 31418, 31418, 31418, 31418, 31418, 31418, 31418, 31418,
   32912,   541, -3907, -3907, 29924, 29924,  3299,  3283, -3907, -3907,
    1500,  1500, 54777,  3017,  2817,  3019,  3024, 29924, -3907, -3907,
    1973, 50448, -3907, 29924,  6790,  2051,  3068, 10311,  1549,  5830,
   -3907,  3397,  2146, 29924,  1992,  2104, 29924,  2059, 29924,  3306,
   -3907, -3907, -3907,  3033, -3907, -3907, 54777, 29924, 31418, 31418,
    6140, -3907,  6944, 29924,  3035,  8485, 24944, -3907,   482,   482,
     482,   482, -3907, 77820, 77820,  2781, 29924,  3301,   -11,   -11,
    3036,  3009, 40200, -3907, 29924,  1481, 28430,  3038, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907,  3050, -3907,  3051, -3907, -3907,   449,  3045,
   -3907, -3907,  3730,   147,  3064, 77820, -3907,  2740, -3907, -3907,
   -3907,  3040, -3907,  1900, -3907, -3907, -3907,  6023,  3215,  2418,
   -3907, -3907, -3907,  2139,  3067, -3907,  2018,   457, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907,  2960,  2275,  2275,   851,
    2275,  3325,   851,  6163, -3907, -3907, 34378, 77820, 77820,  2063,
   -3907, -3907, 77820, -3907,  2061, -3907, -3907,  3303,  1550, -3907,
   -3907, -3907,  3121,   890,   844,  2508,   771, -3907,  3122, 77820,
   -3907, 77820, -3907, -3907, -3907, -3907, -3907, -3907, 50448, 40684,
   50448, -3907,  3133,  3134,   950,    92,  3137,  3142,  3069,  3075,
    3085, -3907,   126,  2146, -3907, -3907,  2146,  2275,  2146, -3907,
   -3907, -3907, -3907, 50929, -3907, -3907, 77820,  3337,    57,  1743,
   77820, 77820, 77820, 77820, 77820, 77820, 77820,  2710, -3907, -3907,
   -3907,  3087,  1400, -3907, -3907,  3302,  3309, -3907,  1400,  1400,
    1400,  1400,  1400,  1400, -3907,   121,  2075, -3907, 35831, -3907,
   -3907,  2549,  2549,   538, -3907,  2549, -3907,  2549, -3907, -3907,
    2760,  3040,  2139,  1820, -3907, -3907, -3907, -3907, -3907, -3907,
     963,  2139,  2022,  3081, -3907, 37296, -3907, -3907, -3907,  2150,
    1138, 77820,  2960, -3907,  2556,  2298,  2443,  2633, 75900, 76380,
   76860,  3077, 77820, 31418, -3907,  1467,   111, -3907,  3311, 77820,
    3123, -3907, -3907, -3907,  3089, -3907,  2275, 77820, 77820,  2275,
   -3907, 54777, -3907, -3907,  3473,   727, 77820,  3125,  3095,  3371,
   -3907,  3091,  3098, -3907, -3907, 77820, -3907,  3113,  1717,  3130,
   62940,  1913, -3907,  3348, 60540, -3907, 77820, -3907, -3907, -3907,
    3460,  3185,  3150,  2146,  2748, -3907, 52853, 29924, 29924, -3907,
    3106, -3907,  3119,  4375, -3907,  2179, -3907, -3907, -3907, -3907,
   -3907, -3907,  3180, 77820,  3528, -3907, -3907, 74460,  3132, 77820,
    1606, 33894, -3907, -3907,  2379, -3907, 33894,  3345, -3907, 33894,
   77820,  3146, 77820,   879, 77820, -3907,  3120,   265, -3907, 77820,
   -3907, 77820, -3907, -3907,   265,   265, -3907,  3224, -3907, -3907,
    1441, 77820, 77820, 77820,  2275, -3907,   333, -3907,  3393, 75420,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907,   176,  3402, -3907,
   -3907, -3907, -3907, 29924, 10568, -3907,  3129, 10568,  6373, 10568,
    3299, -3907,  1180,  3409, -3907,  1511,  3148,  1180,   918,   918,
     319,   319,   112,   112,   112,  3431,   541, 10568, 10568, -3907,
   -3907, -3907, -3907,  3139, -3907, -3907, -3907,  2817, -3907, 30422,
   -3907, -3907,  3178,  3182,  3152, -3907, 29924, 30920,  3141, 55739,
   -3907, -3907,  1138,  3048, 31418, 31418,  1832, -3907,   394, 29924,
   54777,  2087,  1832,  2181,  2256, 29924, 29924,  9362,   246, 29924,
    6483, 77820, 77820, 77820, 77820, -3907, -3907, 10568,  3513,  3414,
   29924,  3153, -3907,  3154,  3009, -3907, 91260, -3907, -3907, 10568,
   -3907, -3907, 29924, -3907,  3009,   457,   907,  2146, -3907, -3907,
     671, -3907, -3907, 43149, -3907, -3907, -3907, -3907, 10279, -3907,
   -3907, -3907,   126, -3907, -3907, -3907,  3221, 63900,  3433,   963,
   29924,  2101, -3907,  3189, 77340, 23960,  2106,  2111,  3123, -3907,
    2477, -3907,  3222, -3907,  3347, -3907, -3907,  3350,   126, 77820,
   -3907, 54777,   265,   265, -3907, -3907,  3181, 77820, 77820,  2139,
    2139, 54777,  3166, -3907,  2139,  2139,  3177, -3907, 77820, 77820,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, 77820,
   77820, 77820, 77820,  3462, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907,  3415, -3907,  1400,  1400, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907,  2183,  3496, -3907, 50448, -3907, 57180, -3907,
   -3907, -3907, -3907,  2146,  2146,  3366, 45579,  2146,  2146, -3907,
    1505,  3503, -3907,  3435,   893,  3191,  1224,  3461, -3907,  2307,
   37296, 37296, 37296, 37296, 37296, -3907, -3907,  3466,   126, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, 29924,  1052,  1180, -3907, -3907, -3907,
   -3907,  3123,  1740,  3244, 50448,  2275,  2275,  3246,  1441,   500,
   77820,  3500,  3235, -3907,  2146, -3907, -3907, -3907,   196, -3907,
    2114, -3907, -3907, -3907,  3233,  3135,   686,  3201,  1913, -3907,
   -3907,  1038, 77820, -3907,  1289, -3907,  3478,  3204, -3907, 10568,
   10568,  2146, 56220,  3335, -3907, 77820,  3453, 77820, -3907, -3907,
   77820,  2123, -3907, 29924,  3213, -3907, -3907, 33894,  2379,  2155,
   77820,  2164, 54777,  3009, -3907,   265, -3907,   265,   265, -3907,
   -3907, 77820,  2275,  2275,  2275, -3907,  3380, -3907,   265, 75420,
   10568, -3907, -3907, -3907, 31418,  3489, -3907,  3216, 54777, -3907,
    3218,  2188,  2192, -3907, -3907, -3907,  6501,  3261, 10568,  3313,
    3219,  3220, -3907,  1573,  1573,   394,  2198, -3907, 31418, 31418,
    1832,  1832, 29924,  1832, -3907, -3907, -3907, -3907, -3907, 29924,
   29924,  3256,  3009,  3009, -3907,  3381, -3907,  3225, -3907, -3907,
    1820, -3907, -3907, -3907, -3907,  1138, -3907,  3226, -3907, -3907,
   75420,  3403, 75420, -3907,  6917,  3123, 34378, 43642, 77820, -3907,
     871,   871,  3364,  3123,  3244, -3907, -3907, -3907, -3907, -3907,
    3287, -3907, -3907, 40684, -3907, -3907, 34862, 43149, -3907,   950,
    3238,  3239,    92, -3907, -3907,  1148,  1179,  3266,  2275,  3521,
    1400, -3907, -3907,  2744,  2146, -3907, -3907, -3907,  2201, -3907,
   -3907, -3907, 77820, -3907,  3095, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, 51410,  3638,  3638, -3907,  1498,  1498, -3907,
   -3907, -3907, 77820,   963, -3907,  7828,  3428, -3907,  3244,  3458,
    3502, -3907,  2216, -3907, 77820,  3150, 60540,  3113, -3907,  1140,
    3251,  3543, -3907, -3907,  3583, -3907, 62940,  3426,  3185,   702,
     702, 77820,  3135,  3376, -3907,  3379, -3907,  3628,  3434,  3630,
   77820, 34378, -3907, 55258, -3907,  2221, -3907, -3907,  2876, 77820,
     -40, -3907,  3278,  2229, -3907, 10568, 77820, -3907, -3907, -3907,
    2237, -3907, -3907, -3907, -3907, -3907, -3907, -3907,   149,  1202,
   31418, 54777,  2252, 29924, -3907, 29924, -3907, -3907, -3907,   638,
   -3907, -3907, -3907,  1573,  1573,  1832,  2817, 10568, 77820, -3907,
   -3907, -3907,  3644,  3436,  3009, -3907, -3907, -3907, -3907,  1093,
     851,   149, 77340,  3244, -3907,  3270, -3907, -3907,  1900,  1900,
   77820,  3244,   963, 29924, -3907, -3907, 54777,  2072,   689, -3907,
   54777, 54777, -3907, 77820, 77820, 77820, 77820, 77820, -3907, -3907,
   -3907, -3907, 57180,  3095,  3638,   650, -3907, -3907, -3907,  3551,
   -3907, -3907,   723,  3446,  3351, -3907, 50448,  3559, -3907, -3907,
   -3907, -3907, -3907, 29924,  3420, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907,  2255,  3185, -3907,
   -3907,  3449, -3907,  3455, -3907,  2258, -3907, -3907,  4375, 56220,
    3590, -3907, -3907,  2089,  3703, -3907,  2263, -3907, -3907,  1202,
    2267, -3907,  2274,  2278,  3333, -3907,  3285, -3907,  3683, 29924,
    1435, -3907, -3907,  3566, -3907,   871,  3329, 43149, -3907, -3907,
    1740,   963, -3907, 10568,  2283, -3907, -3907, -3907,  3432,  2291,
    2302,  3292,  3331,  3292, -3907,  2275, -3907, -3907, -3907, -3907,
    3602, -3907, -3907, -3907,   171, -3907,  3479,  3480, 77820, -3907,
   77820,  3698,  7909, 51410,   890, -3907, -3907, -3907, -3907,  3342,
   34378,  3335, -3907,   779, -3907, -3907, -3907, 77820, -3907, -3907,
   -3907, -3907, -3907, 77820,  3310,  2817, 28928, 28928,  3316, 75420,
    1900,  3312,   963,  3317,  3458, -3907, 51410, -3907, -3907, -3907,
   77820,  3430,   799,   799,  3636, -3907,  3374, -3907, -3907, -3907,
     950, -3907,  3324,  2508,  3185, -3907, -3907, -3907, -3907,  2272,
   -3907, -3907, -3907, 31916,  3447,    82,  8407, -3907, -3907, -3907,
   -3907,   149, -3907, 29924, -3907, -3907,  3446,  2072, -3907,  3235,
   -3907,  3735, -3907,   868, -3907, -3907,  3166, 57660, -3907,  2876,
   -3907,  1507, -3907, -3907, -3907, -3907, -3907, -3907, -3907,  3726,
   -3907, -3907, -3907, -3907, -3907, -3907,  8020,   963, -3907,  3623,
   -3907, -3907, -3907, -3907,  2310, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907,  1641, -3907, -3907,  1642,  1962, 29426, -3907, -3907,
    3484, -3907, 57660, -3907,  1507, -3907, 51410, -3907, -3907,  3334,
   57660,  2316, -3907
};

/* YYPGOTO[NTERM-NUM].  */
static const short yypgoto[] =
{
   -3907, -3907,  3486, -3907, -1138,  -198,  2103,  -674, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907,  1377, -3907, -3907,   -56,  1814,  2327,  1063,
   -3907, -1313, -3907, -3907,  -887,   153,  -982, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907,   927,  1512,   965,  1714, -3907, -1665,
   -3907, -3907,   442, -3907, -3907, -3907,   854,  -218, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907,    30, -3907, -3907,  -364, -1741,
    -114, -3907, -3907, -3907, -3907,   315,  -256, -1529, -3907, -2824,
   -3907,   -13, -3907, -3907, -3907,  -257, -1626,  1026,  -969, -1328,
    1308,  -492, -3907,  -153, -3907,  -532,  -452,  -450,  -496, -3907,
   -3364, -3264, -3283, -2589, -3907, -3907, -3907,   334, -3907, -1735,
   -3907, -3907,  2050, -1576, -3907, -1021, -3907, -3907, -3907, -3424,
   -3907,  1612,  -252, -3907,   -29, -3907, -3907, -3907, -3907, -3907,
   -3907, -3391, -3907, -1651, -3907,   460, -2849,   941, -3907, -3907,
   -3907,  2074, -3907, -3907, -3907, -3907, -1752, -3907, -3907, -1726,
   -3907,  1462,   837, -3907, -3907, -3907,  -516,  -576,  -567, -3907,
   -3615,    52,    55, -3907, -3907, -3907, -3907, -1192, -3907,   859,
   -2920, -1159, -3907, -3907,   894, -3907, -3907, -3907,  -478,  -146,
    2099, -3907,  -404, -3907, -3907, -3907,  -145, -3907, -3907, -3907,
   -3907, -3907, -3907, -1875,  2874, -1104, -3907, -3907, -3907, -3907,
   -2332, -3907,  3738,   -15,   252, -1714, -3907,  -209,  -107,  2569,
   -1343, -2548,   295,  -271, -3907, -1925, -3907, -3907, -3907, -2470,
   -3907, -3907, -3907, -3907, -3245, -1712, -3907, -3907, -3907,   366,
   -3907, -3438, -3590, -3565, -3219, -3907, -3907, -1273, -3907, -3907,
   -3907, -1568,  1628, -1636, -3907, -2223,   368, -3432,  -977, -3022,
   -3907, -3365,  -344, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -1261,  -842, -3907, -3907,  3046, -3907, -3193, -3907, -3907, -3907,
   -3907,  1078, -3907,  -569, -3907, -3907, -3907, -3907, -3907, -3907,
    -463,  -537, -3907, -3907, -3907,   166, -3907, -3907, -3907, -3907,
    1696, -1151,  -984,  2907, -1710,  -174, -3907, -3907, -3907, -3907,
   -2805, -3907, -3907, -3907, -3907, -3907, -3907, -3907, -1269, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907,  1782,  1783,  -106,  -221,
   -3907, -3907, -1491, -3907,  -800, -3907,  2027, -3907, -3907, -3907,
   -3907, -3907,   182,   400,   -66, -3907, -3907,   777, -2379,   -65,
   -3907, -3907, -3907, -3907,  -306,   -58, -3907,  1174, -3907, -3907,
   -2033, -3907,   189,    93,  2639,  1403,   -63,    67,  -240,  -220,
    -206, -3907,  2905,  2413, -3907, -3907,  -205,  1629, -3907, -1054,
    -341, -3907,  1170,  -893,  1763,  2399,  2404, -3907,  1169, -3907,
   -3907,  1176, -3907, -3907, -3907,  -889,  1775, -3907,  2410,  1792,
   -3907,  1821,  1232, -2409,  1476, -2367,   858,  -687,    31,  -124,
    2942,  3099, -3907, -3906,  1205, -3367,   439,   749, -2037, -1761,
   -3907, -3907, -1352,  7963, -3907, -3907, -3907,  9946,  9968, -3907,
   -3907, 11142, 12929, -3907, -1236,   732, 14009,  5238, -1390, -1776,
   -1485, 14786,  1366, -1424, -1643, -3907, -3907, -3907,  -187,   734,
     141, -3907, -3907, -3907,  -371, -2677,  -369, -3907, -3907, -3907,
    -368, -3174,  -370, -3907,  -783, -3907, 16186,  1206, -3907, -1288,
   -2535, -2622, -1351, -1883, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -1421, -3060,  -561,  1286, -3907, -3907,  1381, -3907, -3907,
   -3907, -1432, -1109, -1998,  1296, -2010, -3907, -1051,  1414,  1918,
   -1009,  4076,   473, 13333,  -133, -2236, -1484, -1429, -3907,  -725,
   -3907,    59,  1290,  -164,   234,   125,    -6, -2897, -3907, -3907,
     259, -3907, -3907, -3907,  3382,   908, -3907,  2765, -3907,  1517,
    2162, -3907, -3907,  1797,  -924,   -77, -3907,  -336, -3907,  -142,
   -3907, -3907, -3907,   194, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907, -3907, -3907,  2451, -3907, -3907, -1426, -3907, -3907, -3907,
   -3907, -3907,  3670,  -315, -3907,  3104,  -309, -3907, -3907, -3907,
   -3907, -3907, -3907, -3907, -3907, -3907,  2460,  1831, -3907,  2904,
   -3907, -3907, -3907,   -49,  2670, -3907, -3907, -3907, -1152,  -587,
    2925,  2928,  1800, -3907, -3907, -3907, -3907, -3907, -3907, -3907,
   -3907,  1810, -3907, -3907,  1283, -2055,  1812, -3907, -3907,   690,
   -3907, -3907,   310, -3907,   691, -3907,  2567, -3907, -3907, -3907,
     714, -3907, -3907, -3907,  -618, 10607,   197,   -23,  -110,   169,
   -3907,  5554,  8191,   -37,  2479,   -30,  8152, 14597,   244, -3907,
    3659,  1816,  1491,  -995, -3907,   -50,  2110, 13808, -3907, -1117,
      23,    -2, -3907,  2322,  -655, -1133,  2768,  -726, -1871, -3907,
    4065, -3907, -2964, -3907,  -974,  3115, -1181
};

/* YYTABLE[YYPACT[STATE-NUM]].  What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule which
   number is the opposite.  If zero, do what YYDEFACT says.
   If YYTABLE_NINF, syntax error.  */
#define YYTABLE_NINF -2407
static const short yytable[] =
{
      80,  1015,  1628,   968,  1362,  1363,  1065,   797,  1882,  1367,
    1073,   893,   343,   344,  1268,   348,  1931,   691,  1505,   881,
     346,  1575,  1236,  1048,   968,    79,  1577,  1890,  1989,  2340,
    2281,  1919,  1962,  1643,  2551,   877,  1706,  2437,  2445,   680,
    1758,  2587,  2313,  1171,  1647,  2555,  1747,  1118,   395,  2000,
    1518,  1080,   797,  1846,   395,   691,  2046,  1081,  2322,   942,
    2768,    74,   990,  1781,   976,  2019,  2020,  2177,  1526,  2384,
    2385,  3403,   356,  1288,  3196,   885,   892,  2378,   356,  1596,
     799,  1171,  3313,   840,  2035,  3586,   892,   682,  1821,  2887,
    2889,  1138,  2464,  1825,   796,  2487,  3017,  1154,  2465,  1045,
    1831,  3118,  2156,  1016,  2219,  2221,  2222,  2466,  1053,  1848,
    2311,   356,  2928,  3439,  1873,  3441,  1122,   969,  1067,  2467,
     797,  2468,  2629,  2469,  1626,   799,  3180,   892,  1222,  2784,
    3498,   929,  1171,  1075,  3754,  3310,  1698,  3768,   969,   796,
    1323,  3543,  3140,  1512,  2196,   349,  2373,  1076,  3132,  3134,
     886,  3943,   965,  2547,  4043,  2321,   356,   904,  2213,  2213,
    1036,  1946,  2262,  2794,  3498,  3903,  3916,  1654,  1920,  3946,
    2789,  2013,  2014,   965,  2817,  2061,  1676,  3368,  1915,  1569,
    1273,  1113,  2114,  1572,   982,  4051,  3679,  1281,   850,   697,
    1604,  1605,  1135,   799,   416,   416,  2032,  3925,   416,   703,
    3227,  1378,  1748,   355,  2331,  1845,  1312,   796,    45,   355,
    1874,  2156,    45,  2833,  1874,   852,  -127,  2837,  3058,  2485,
    3308,  3309,  2063,  2069,   356,  -127,   967,  2517,  2704,  3577,
    -127,   261,   349,  1262,  2324,   844,  3515,  3516,  3517,  3518,
    3519,  3520,   355,  3959,   321,  3961,  2704,   967,  2072,   895,
    2492,  1775,  4290,   130,   131, -1581, -1380, -1380, -1380, -1380,
     342,  1393, -1581, -1380,  2753, -2133,  2870,   347,  1350,  3205,
   -1687, -1687, -1687, -1687,  1755,   394,  1874, -1687,   399,  3820,
    3194,   394,  2099, -2405, -2405, -2405, -2405,   355,  3019,  2738,
   -2405,  2699,   343,   344,  3899,   348,  2739,  3147, -2405,  3149,
     346,  2996,  3567,  4451, -1365, -1365, -1365, -1365,  1933,  -343,
    2283, -1365,  2298,  1064,   394,    37,    38,    39,    40,  1617,
    2341,  3804,    44,  1070,  2157,  1109, -1370, -1370, -1370, -1370,
    2409,   934,  2136, -1370,  1007,   813,   395,   357,  2461,  2327,
    2284,  1007,  1618,  1007,  2188, -1597,  1922, -1380, -1380, -1380,
   -1380,   794, -1597,  2220, -1380,   355,   809,  4392,   810,   394,
     356,   803,     3, -1365,  1769,  2342,  2343,  1758,  3402,  1498,
    4133,   395,   814,  2018,  2137,  2263,  1540,   416,  1541,  2105,
      37,    38,    39,    40,   402, -1370,    43,    44,  1397,  1619,
    2328,    45,  1874,  2189,  2299,   356,   794,  1350,  2339,  1050,
    3030, -2406, -2406, -2406, -2406,   416,   803,  3227, -2406,  2623,
     702,  2046,  2462,  4054,    43,  2872, -2406,  1908,  1756,    45,
    1074,  1509,  3805,  1171,  2069,   349,  2498,   394,  2493,  3821,
    3900,  4452, -2403, -2403, -2403, -2403, -1174,  2019,  2020, -2403,
    1350,  2069,  1932,  1006,  2035,  1656,  1055, -2403,  1098,  2072,
    1006, -2133,  1006,  1011, -1370, -1370, -1370, -1370,   684,  1875,
    1011, -1370,  1011,  1875,   794,  3318,  2072, -1833,  3319,  3320,
    1981,  1762,   841,  2285,   803,  2332,  1379,  2339,  1765,  3321,
    3322,  3323,  2069,  3324,  3325,  4218,  4219,  2333,  3326,  3327,
    3328,   355,  2415,  3020,  3730,  1123,  2132,  1137,  4249,  3795,
    2145,  2145,  4134,  1081,   881, -2133,  1389,  2072,  2419,  2102,
   -1174,   261, -2402, -2402, -2402, -2402,  2486,   897,  1639, -2402,
   -1337,  2100,  3498,  2379,   321,  1875,   355, -2402,  1856,  1607,
    1610,  1935,  1977,  4471,  2632,  2705,  4118,  3578,  2334,  1366,
     342,  3869,  2786,  1116,  1117,  2158,  2437,   347,  1657,  2148,
    2149,  2013,  2014,  3288, -1997, -1997, -1997, -1997,  1366,  2032,
     885, -1997, -1581,   394,  4142, -1337, -1337, -1337, -1337, -1997,
     246,  3762, -1337,  3842, -1350, -1350, -1350, -1350,  4157,  1613,
    2369, -1350,  2371,  1914, -1377, -1377, -1377, -1377,  1910,  2435,
    2064, -1377,  1884,  4170, -1337,  1107,  2740,  2997,   394,  1828,
    3983,  3613,  3183,  2412,  2076,  2077,  2408,  4322,   892,   892,
    3239,  1542,  1114,  1651,  2664,   962,   963,   357,  2584,   962,
     963,  4393,  4315,  3385,  2802,  1109,  1351,  2127,  2115,  3227,
    2576,  3329,   811,  2092,  3735,   886,  2100,  -127,  -127,  2874,
    2431,  1875,  2292,    37,    38,    39,    40,  3033,  2297, -1177,
      44,  2041, -1597,  2080,  3639, -1174,  1115,    37,    38,    39,
      40,  4138, -2407,  3400,    44,  3401,  2603,  3460,  2275,  2042,
    3463,  3464, -1833,  2156,  3467,  1982,  2886,  2767,  1606,  2235,
    4213,  1884,  2205,  2043,  3474,  1149,  2206,   685,  4221,  2359,
    1586,  1658,  2362,  2363,  3743,  1531,  3268, -1687,   797,  1532,
    2302,  1065,    37,    38,    39,    40,  4385,  3878,  1178,    44,
   -2405,  2008,  2446,  4286,  3600,  3337,  2626,  2628,  3604,  1188,
    1056,  1331,  2851, -1177,  1226,  2356,   813,  2636,  1982, -1833,
    2639, -1365,  1124,  1122,  1576,  4291,  4259,   845,  2651,  2652,
    2277,  1680,  2041,   215, -1833,  2416,  3343, -1174,  1264,  1659,
    4380,  2669,  2671, -1370,  2922,  1736,  2278,  3330,  2566,  1158,
    2042,  4338,  2685,   814,  2569,   898,  3185,  4424,  3465,  3466,
    2559,  1126,  1053,   223,  2045,  1253,  1278,  1609,  3348,  2845,
    1915, -1174,   395,  2604, -1174,   796,  2819,  1332,  2819,  1338,
    2894,  1343,  2852,   847,  2655,  2656,  1737,  1347,  1620,  1621,
    2742,  4269,   356,  2720,  3496,   896,   356,  3331,   234,  3229,
    1189,  1109,  2981,   892,  3236,  3237,  3238,  3239,  1217,  2479,
     237,  1338,  1343,  1321,  2492,  1520,   962,  1595, -2406,  2087,
    2088,  2089,  2090,  2091,  2092,  1326,   979,  1068,  3496,  2008,
    2585,  2982,  4479,   899,  1681,   900,  1219,  4270,  2089,  2090,
    2091,  2092,  3855,  1978,  4271,  4268,  4361,  2287,  1317, -2403,
    1369,  2352,   892,  2313,  1351,    35,   416,  2517, -1177,    37,
      38,    39,    40,    41,    42,    43,    44,  3187,  4278,  4407,
      45, -1370,  3584,  2495,  4272,  1070,  2279,  2087,  2088,  2089,
    2090,  2091,  2092,  2480,  1069,  4139,  4339,  3856,  3332,  1270,
     904,   969, -1337,   969,   983,   969,  4107,  4108,  4109,  4110,
    4111,   969,  4247, -1337,  2373,  2018, -1337,  1646, -1337,  2743,
    1171,  3586,  4405,  3404,  1369,  1838,  4430,  1587,  2721,  1350,
      80,  1254,  2722,   355,  4140,   969,   969,   355,  1336, -2402,
    1341,  2923,  2876,   992,  4304,  3786,  2558,  1109,  1738,   691,
    1545,  4341,  2287,  4273,  1757,    79,  2605,  3186,   861,  3424,
   -1177,  2591,  2592,  1351,  1070,  4313,  1839,  2723,  3752,  2580,
    1371,  1373,  1508,  1828,  2606,  2129,  1516,  1502,  2280,   416,
    2798, -1997,    37,    38,    39,    40,  1255,  1377,    43,    44,
    2288,    74,  2018,    45, -1177,  4356,  4406, -1177,  3340,  4318,
    4319,  2024,  4126,  1399,  3351,   394,  3227,   349,  1064,   394,
     967, -1377,   967,   863,   967,  1394,  1682,  2121,   993,  1536,
     967,  1348,  1349,  1499,  2877,  2284,  3521,  1511,  1270,  1513,
    1521,  1322,  1739,  1898,  3234,  3235,  3236,  3237,  3238,  3239,
    4408,  3522,   794,   356,   967,   967,  1337,  2536,  1342,  4461,
     969,  4337,   803,  4326,  3315,  4123,  3316,  4024,  1356,  1793,
    2799,  3588,  3425,  2289,   680,   680,  4342,  4028,  3188,  1627,
    2066,  3523,  2481,  3524,  1899,  1071,  3859,  2122,  1372,  1374,
    2130,  3763,  1358,  2482,  2103,  3787,   416,  1522,  2724,    37,
      38,    39,    40,   804,  3037,    43,    44,  1397,  1619,  3405,
      45,   991,  1389,   805,  3537,  4431,  1171,   969,  3743,  1020,
    2517,  2275,   682,   682,  3189,  1119,  4274,  1630,  1840,  2330,
    4027,  4439,  4305,  1599,  3406,  2562,  2276,  4343,  2976,  2773,
    3833,  1043,  1628,  2581,  2977,  3589,  3836,  3837,  3838,  3839,
    3840,  3841,  1629,  4225,  3525,  2518,  3859,  2522,    37,    38,
      39,    40,   870,  1007,   871,    44,  2528,  1007,  3784,   967,
    2380,  4422,  2582,  1161,  1162,  1163,  3498,  1164,  1165,  1166,
    1167,  1168,  1169,  1058,   355,  4432,  2776,  3978,  1622,  3799,
    1599,  3190,  3788,  2277,  2422,  3789,  3229,  4462,  3521,   994,
     995,  1701,  3952, -1684,  2658,  2983,  3496,  3956,  4433,  2278,
    3958,   806,  1841,  1021,  3526,  3426,  1339,  3861,  2822,  3527,
    1344,  1345,  1346,  1070,  1559,  2595,   967,  3860,  2225,  1779,
    1357,  2226,  3395,  1065,  4143,  2423,  1900,  1858,  1359,  1077,
    3949,  2978,   956,  3523,  3427,  2184,  4144,  2664,  2664,  4449,
    1094,  1154,  2664,  2870,  3528,  3764,   394,  3635,  3230,  2313,
    3538,  1884,   957,  1171,  1626,  3145,  3529,    37,    38,    39,
      40,  1066,  1006,  1865,    44,  1399,  1006,  3590,  3227,  1724,
    1514, -1785,  1011,  2339,  3765,  3150,  1011,  3861,  2871,   969,
    3800,  2664,  2664,  3068,  3069,  3070,  3071,   962,  1595,    35,
    3227,  2125,  1084,    37,    38,    39,    40,    41,    42,  3349,
      44,  1317,  1270,  4485,  1095,  1980,    80,    80,  1560,    80,
    1901,  2216,  3751,  2227,  2441,  1866,  1565,  3399,  2250,  3651,
    1865,  2185,  2464,  2441,  1081,  3591,  2171,  1270,  2465,  2279,
     807,    79,    79, -2197,    79,  1122,  3530,  2466,   861,  3586,
    2956,  2178,  2179,  3203,  2183,  4200,  4201,  1496,  2959,  2467,
    2961,  2468,  1599,  2469,     8,  1076,  1076,  2767,  1076,  1096,
     956,   856,  1097,  3141,  3801,  1531,  4116,    74,    74,  1532,
      74,  3527,  2561,  1986,  2979,  2217,  2106,  2424,  1095,   668,
     957,  1567,  3963,  3967,  3316,  3968,  1283,  1095,   967,  4145,
    1291,  3254,  2872,   863,  2640,  1119,  1365,  1188,   349, -1816,
    1303,  4030,  1867,  2980,  1497,  3627,  3528,  4349, -2407, -2407,
    3137,  3234,  3235,  3236,  3237,  3238,  3239,  4147,  3529,   157,
    3277,  2280,   797,   691,   691,  4148,   416,  1937,  3568,  1939,
    2218,  4178,  1943,  1096,  1945,   349,  2442,  1948,  1949,  1950,
    2420,   861,  1096,  4354,  1704,  2442,  2906,  3039,  3229,  1868,
    1957,  2119,  2120,  4103,  1098,  2061,   122, -1785,  2641,  1867,
    -792,  2425,  3125,  2062,  1984,  4222,  1985,   969,  2006,  1366,
   -2407,   969,   969,  2067,   126,    37,    38,    39,    40,  2269,
    2517,  4104,    44,  2104,  2517,  1776,  1777,  2022,  1189,  2270,
    3126,  2859,  4209,   176,  4211,  2155,   863,  2907,  3530,  3040,
    2421,  2376,  4081,  4082,  2271,  3606,  1868,  1620,  1621,   796,
    3230, -1785,  1270,  2642,  3128,  2134,  2643,  2049,  1565,  1270,
    1270,  2908,   956,  4260,   691,  1098,   356,  4311,  1098,  4251,
    2059,  1869,   870,  1125,   871,  3389,   797,  1098,  2217,  3037,
    1599,  -798,   957,  3064,  1599,  1599,  1617,  1099,  4167,  2219,
    4261,  4234,  2232,   680,   395,   395,    37,    38,    39,    40,
     796, -1834,  3638,    44,  2364,  1150,  1100,  1705,  3173,  1618,
    -365,  -159,  2909,  3041,  3042,  4149,   967,   356,   356,   356,
     967,   967,  1724,  1567,  1936, -1816,  3043,  1938,  1869,  2831,
    1942,  1725,  1944,  2218,  1399,  1947,  -159,  3227,  3639,  1951,
    1136,   682,   956,   395,    37,    38,    39,    40,  2644,  2155,
    2254,    44,  1152,   969,  3130,  3111,  1745,  4233,  2228,   969,
     209,  2443,   957,   796,  4316,   215,  1568,   356,  1074,  1074,
    2443,  1074,  4321,  2459,   356,   870,  2272,   871,  3044, -1816,
     356, -1863,  2187,  2246,  2248,  1746,   873,  2618,  4235,  2444,
    2488,  3897,  2224,  1884,  1349,   223,   875,   355,  1399,  2324,
     969,  3227,  3158,   969,   969,  1157,  1651,  2329,  2665,  3231,
    3232,  3233,  2238,  3234,  3235,  3236,  3237,  3238,  3239,  2245,
    2247,  2953,  2188,   232,  1884,  2365,  1599,  2366,  1098,  4097,
     234,  4031,  1599,   157,  1952,  3234,  3235,  3236,  3237,  3238,
    3239,  2645,   237,   848,  3985,  2156,  3986,   209,   355,   355,
     355,  3898,  1726,  1248,  2069,  1651,   969,  1953,   797,  3007,
    1884,  3045,   967,  3046,  2377,  2953,  1644,  2744,   967,   394,
    1248,  2189,  1746,  1599,  3876,   246,  1599,  1599,  1065,  2072,
    3785,  3790,  1249,  3774,  3548,  1648,  2525, -1834,  4238,  4098,
    1180,  2767,   416,  3033,  2145,  1645,  3228,  1186,   355,  3546,
    3363,  3663,  1891,  3664,   215,   355,   794,   176,  3124,   967,
    1741,   355,   967,   967,  1649,  1007,   803,  3229,   209,  3398,
     394,   394,   394,  1250,   813,  2518,  1017,  1221,  3338,  1599,
    2620,  2457,   130,   131,   223,  4376,  1007,  3359,  1187,  1742,
    1250, -1834,  3660,  1650,  2664,   796,  3831,  2664,  2664,  2664,
    2664,  2664,  2664,  2664,  2664,  2664,  2664,   794,  3312,  4377,
    1326,   814,   356,   193,   815,   967,  3680, -1863,  1743,   234,
     394,  4421,  2470,   215,  3125,  3987,  2767,   394,  1975,  3230,
    3496,  3229,   849,   394,  3033,  2783,  1225,   937,  3434,  2257,
    3372,  1081,  3648,  2711,  1991,  2712,  1228,   931,  2608,  1087,
    3681,  3682,  3126,   223,  2664,  2664,  2001,   813,  2364,   938,
    3279,  1007,  3280,  1651,   246,   157,  2713,  3127,  2258,  1088,
     794, -1863,  3665,  3294,  1006,  2404,  3128,  4038,  4257,  1089,
     803,  2619,  3666,  3281,  1011,  2405,   956,  3419,   234,   215,
     939,    43,  1708,  3230,   814,  1006,    45,  2259,  1018,  3129,
     237,    80,  3420,  1224,    80,  1011,   957,  2068,  3163,  2406,
    2069,  2504,  2402,  2041,  2614,  2615,  4002,  2617,  2041,   223,
    4287,  1709,  2616,  3422,  3923,  3711,    79,  2511,  4001,    79,
    2313,  2042,  1171,   246,  1237,  2072,  2042,  2336,  1905,   176,
    2073,  2403,  1842,   355,  1243,  2043,  2110,   232,  2517,  2111,
    2045,   797,  3423,  2517,   234,  3822,  2517, -1186,  1906,  3687,
    2041,  1843,    74,  1803,  2714,    74,   237,  1565, -1186,  2715,
    1006,  1566, -1186,   416,  2716,  3823,  3130,  1090,  2042,  2365,
    1011,  2366,   349,  3872,  3873,  3874,  3282,    45,  3231,  3232,
    3233,  3283,  3234,  3235,  3236,  3237,  3238,  3239,  1916,   246,
      35,  1251,  1917,    37,    38,    39,    40,  3352,    41,    42,
      44,  2648,  2804,  1005, -1186,   394, -1218,  2175,  2518,  2564,
   -1218,  2565,  1042,  3073,  2702,  2567,  3511,  2568,  3074,  1252,
    2570,  3074,  1567, -1186,  2571,  1064,  3037,  3782,   796,  1531,
    1257,  1091,  2018,  1532,  2263,  1316,   416,   349,  2370,  3776,
    3777,  2853,   794,  2856,  1545,   356,  3234,  3235,  3236,  3237,
    3238,  3239,   803,  1260,  1916,  2637,  2638,  1399,  2554,  2075,
    3227,   215,  1229,  2650,  1230,  1568, -1186,  2653,  2654,  2381,
     416, -1218,  3200,  3544, -1186,  2341,  2557,  3704,  2717,  2664,
    2076,  2077,  2675,  1721,  2676,  1731,  3201,  2718,  2030,  2031,
    3202,   223,  1751,  1155,  1275,  3284,  1092,  3253,  1174,  3255,
    3256, -1918,  1732,  2697,  3285,  2698,  2341,  1184,  1988,  1279,
     395,  2774,  2847,  1531, -1218, -1687,   969,  1532,  1289,   232,
    2342,  2343,  2709,  1298,  4483,  1556,   234,  4484, -1174,  2080,
     940,  1733,  1231,   797,   356,  1734,  1238,  1232,   237,  1233,
      35,   416,  2081,  2209,  2210,  3849,  1247,  1109,    41,    42,
   -1918,  2342,  2343,  2339,  2238,    45,  2506,  2507,  4244,   969,
    1735, -1918,   395,   680,   395, -1918,  1925,  1758,  1926,  1399,
   -1918,   941,  3227,   932,  2690, -1918,   355,  2693, -1918,  1627,
   -1918,  2005,  1127,   246,  2339, -1186,   356,  1304,   356,  3705,
    3644,   901,  3853,  3854,  1128,  1129,  3857,  3581,  3858,  1319,
    2933,    37,    38,    39,    40,    45,  2155, -1918,    44,   797,
    2169,   682,  2170,  2172,  1130,  2173,  2018,  1131,  1646,  2556,
     796,  2557,  1360,  2796,  3352,   967, -1918,  1630,  2577,    80,
    2578,    80,  1599,  1364,  3731,  3733,  2579,   356,  2578,  4207,
    3229,  2810,  2811,  1556,   797,  2611,  1399,  2612,   394,  3227,
    1065,  2795,  1629,  1884,    79,  2839,    79,  2612,  3352,  1375,
    2664,  2664,  2884,  1381,  2885,   355,  4008,  1386,   967, -1918,
    3780,  2665,  2665,  2930,  1387,  2931,  2665, -1918,  1513,  3025,
    1388,  3026,  2919, -1242, -1242,   794,  4153,  2018,  1622,  2263,
      74,   969,    74,  1390,  2517,   803,   796,  1389,  3059,   969,
    3060,   969,  3230,  1392,    81,  2087,  2088,  2089,  2090,  2091,
    2092,  1391,  3165,   356,  2578,  2665,  2665,   355,  1395,   355,
   -1918,  1399,  1517,  3181,  3227,  3182,  3199,  3065,  2557,  1132,
    3209,   796,  2557,  3212,  1396,  2557,  2530,   394,  4331,  4006,
    4333,  4009,  3216,  1519,  2557,  2539,  1524,  3217,   356,  2557,
    2209,  2815,  3229,    37,    38,    39,    40,  2546,  1523,  3243,
      44,  2557,  3093,  3094,  1599,   983,  3354,  3355,   355,  1133,
    1988,   937,  1599,  3944,  1599,  3259,  1525,  2557,  2518,  1530,
     396,  3992,  2518,  3774,   668,   668,   396,  1539, -1918,   394,
    1684,   394,  3262,   938,  3263,  3298,  1685,  3299,  3009,   157,
     967,  3317,  2401,  3300,  1553,  3301,  3009,  1556,   967, -1918,
     967, -1918, -1918,  3344,  3230,  3345,  3417,  2583,  3418,   396,
    2588,  3605,  2590,  3608,   939,  2593,  3442,  1154,  3443,  3229,
    2350,  3554,  3565,  3555,  3566,  1686,  1546,  3852,   157,  2341,
     394,  1994,  1995, -1918,   355,  1557, -1918, -1918,  1065, -1918,
    1563,  3575,  3067,  3576,   887,  3652,  3688,  2557,  3689,  3882,
    1554,  3231,  3232,  3233,   396,  3234,  3235,  3236,  3237,  3238,
    3239,  3866,  3867,   176,  3097,  1578,  1109,   794,  1580,   355,
    1270,  3360,  3361,  3036,  2342,  2343,  1687,   803,  3774,  1584,
    3923,  3230,  2413,  1688,  1585,  1710,  1689,  1589,    37,    38,
      39,    40,  1588,  1590,  3229,    44,  1591,  1592,  4094,  1988,
    1593,  1012,   176,  1600,  1594,  4086,   394,  2339,  1012,   969,
    1012,  3124,  1601,  3303,  3304,  1603,  1068,  1270, -1341, -1341,
   -1341, -1341,   396,  1633,  3695, -1341,  3696, -1219,  1632,  1635,
    2664, -1219,  3707,  1711,  2557,  1646,  3778,  1690,  2578,  1641,
    1661,   394,  2450,   794,  1678,  1701,   797,  3117,  3845,  1740,
    3846,   797,  1703,   803,  2664,  2664,  3230,  4440,   193,  1744,
    4007,  3850,  2612,  3231,  3232,  3233,  1753,  3234,  3235,  3236,
    3237,  3238,  3239,  1069,  4045,  1754,  4046,  3125,   794,  4052,
    1759,  2578,  1599,  1766,  4053,  3975,  2578,  4135,   803,  4136,
    1761,  1691, -1219,  1763,  3884,   215,  4164,  2524,  1884,  1771,
    1773,    37,    38,    39,    40,  3126,  3352,  4182,    44,  1712,
    1780,  1783,    45,  3870,  3871,  3872,  3873,  3874,   967,  3260,
    3127,  3875,  1651,  4153,  3265,   223,  1692,  1822,  4169,  3128,
    3555,  2518,  1824,   796,   215, -1219,  1643,  4171,   796,  3555,
    3231,  3232,  3233,  1070,  3234,  3235,  3236,  3237,  3238,  3239,
     356,  1828,  3129,   232,  1713,   356,  1714,  1832,   396,  1694,
     234,  4184,  -176,  4185,   223,  4186,  2372,  2557,  1562,  4036,
    1564,  4192,   237,  2612,  4241,  4083,  4242,  3953,    37,    38,
      39,    40,  1834,  1836,  1695,    44,  1847,  3774, -1920,  4255,
    1854,  4256,   232,   396,  4288,   969,  4289,   827,  1870,   234,
    1716,  4196,  4295,  1862,  1884,   246,  1872,  3879,  4438,  1877,
    4297,   237,  3555,  1878,  1879,  3231,  3232,  3233,  1881,  3234,
    3235,  3236,  3237,  3238,  3239,  4301,  2664,  2612,  4355,  3130,
    2124,  4359,  1883,  4360,  4243,  1718,  4368, -1920,  1884,  3479,
    4369,  1880,  2612,  1270,  4441,  2059,  1889,  4370, -1920,  3263,
    1884,  4371, -1920,  2557,  1071,  1894,  4386, -1920,  2612,  2709,
    1903,  2893, -1920,  1892,  4388, -1920,  2612, -1920,  1599,  1720,
    3870,  3871,  3872,  3873,  3874,  4389,  1893,  2612,  3297,  1895,
    4106,   355,  3480,  4481,  3886,  4482,   355,  1662,  2700,  4492,
    2511,  4482,  1897,  1902, -1920,  1904,  1909,  1923,  1958,  2238,
    4300,  3954,  3339,  1990,   967,  1992,  3481, -1348, -1348, -1348,
   -1348,  1998,  1996, -1920, -1348,  1999,  2004,  2012,  1663,  2015,
    2016,  2017,   797,   797,   797,  3482,  2021,   246,  2665,  2097,
    2023,  2665,  2665,  2665,  2665,  2665,  2665,  2665,  2665,  2665,
    2665,  2026,  3483,  2027,  2128,  4324,  2518,  1662,  2028,  4329,
    4330,  2518,  2029,   394,  2518,  2034, -1920,  3484,   394, -1339,
   -1339, -1339, -1339,   668, -1920,  2036, -1339,  4303,  2037, -1342,
   -1342, -1342, -1342,  2038,  2039,  1664, -1342,  2139,  1663,  2040,
    2047,  4037,   797,  2048, -1340, -1340, -1340, -1340,  2665,  2665,
     794, -1340,  2050,  2124,  2051,   794,  2052,  2053,  2054,  4086,
     803,  2055,  2056,  4119,  1350,   803,  1665, -1920,  3558,   796,
     796,   796,  2150,  2160,  2176,  1566,  3435,  1568,  2203,  2208,
     797,  2215,  1098,  2223,  4325,  2229,   356,   356,   356,   887,
    2231,  4087,  2233,  2241,  2242,  1664,  3445,  4328,  3485,  2244,
    1171,  2249,  2251, -2349,  3596,  2260,  3486,   969,  2253,  2261,
     881,  2263,   983,  2264,  2265,  3478,  2286,  2291,  2296,  2293,
    2294,  2295,  2318,  2324,  2326,  2317,  1665,  3009,  2336,   796,
    3009,  3009,  2337,   892,  3009, -1920,  2338,  2345,  3487,  1896,
    2339,   969,  2346,  2351,  3009,  2353,   356,  2347,  3559,  1779,
    1911,  4375,  2354,  2457,  2357,  3499, -1920,  2348, -1920, -1920,
    2360,  3508,  1666,  3572,  2397,  2358,  2367,   796,  2368,   892,
    2374,  2375,  1724,  2393,  2414,  2426,  2428,  2382,  2383,  2391,
    1599,  2429,  2392,  3595,   356,  2436,  1065,  2398,  3171,  3499,
   -1920,  1667,  2400, -1920, -1920,   209, -1920,  2008,  2018,  1668,
    2024,  2438,  2895,  3553,  2439,  1669,  2448,   858,  2454,  2474,
    2491,  2458,  1670,  2496,  1599,  2499,   967,   355,   355,   355,
    1671,  3503,  3506,  3721,  3722,  3723,  3724,  1726,  1672,  2501,
    2502,  3580,  1270,  2503,  2520,  2532,  1673,  2509,  2573,  2533,
    2534,  2548,  2535,  3540,  2549,  2589,  2594,  2601,  3642,  2597,
     967,  2609,  2460,  2632,  2622,   209,  2631,  2301,  2673,  1668,
     396,  2674,  4277,  2574,   396,  1669,  2069,  2397,  1146,  2695,
    2696,  2686,  1670,  2691,  1146,  2703,  2708,   355,   349,  4310,
    1746,   797,  2725,  2665,  4458,  1674,  2727,  2753,  1672,   394,
     394,   394,  2770,   349,   816,  2772,  1673,  2780,  2769,  2775,
    2777,  2788,  2781,  1684,  1069,  1146,  2805,  2806,  2824,  1685,
    2114,  2797,  2809,   349,  2821,   355,  2823,  3031,  2838,  2840,
    2511,  2841,  2842,  2849,  2511,  2397,   794,   794,   794,  2854,
    2859,  2857,  2863,  2865,  2861,  4216,   803,   803,   803,  2862,
    2868,  2875,  2882,  2880,  2921,  1674,  1265,  2925,  1686,   394,
    2932,   817,  2984,  2929,  3690,  4228,  2985,  1146,  2986,  2990,
    2994,  2995,  2518,  2998,  1146,  3000,  2999,  3002,   796,  3003,
    3018,   818,  3006,  3004,  3016,  3005,  3022,   819,   349,  3027,
    3029,  3034,  3032,  1684,    81,   356,   794,   394,  3033,  1685,
    3035,  3057,   820,  3061,  1171,  3066,   803,  3072,  3813,  1687,
    3702,  3075,  3317,  3080,  3079,  3096,  1688,  3098,  3110,  1689,
    3352,  3114,  3113,  3115,  1171,  3116,  3123,  3142,  3143,  3136,
     821,  3156,  3151,  3154,   794,   822,  3157,  3161,  1686,  3167,
    3168,   823,  3169,  3170,   803,  3172,  3179,  3191,   797,  3195,
     797,  1366,  2623,  3741,  3197,  3214,   824,  3249,  3210,  3103,
    4468,  2518,  2557,  3211,  3377,  3378,  3213,  3380,  3215,  3218,
    1690,  3273,  3219,   797,  2665,  2665,  3278,  1662,  3221,  3286,
     825,  4227,  3306,  3293,  1146,  3224,  3312,  3242,  3248,  1687,
    1012,  4384,  3250,  3296,  1012,  4087,  1688,  3251,  3258,  1689,
    3271,  3192,  3272,  2059,  3314,  4468,  3311,  -836,  1663,   969,
    3365,   396,  3366,  4468,  3370,  3367,  3371,  3379,  1154,  3376,
    1146,  2919,   969,  3796,  1691,  1916,   355,  3381,  3382,  3391,
    3386,  3387,  3388,  3392,  3396,   796,   826,   796,  3409,  3397,
    3411,  3432,  3433,  3436,  3447,  3438,  3448,  3446,  3449,  3450,
    1690,  3502,   356,  3462,   356,  3451,  3452,  3499,  3453,  1692,
     796,  3454,  3757,   827,  3437,  1664,  2518,  3455,   969,  3456,
    3468,  3814,  3469,  3470,  3815,  3501,  3816,   356,  2226,  3471,
    3472,  3473,  1599,  3103,  3510,  3534,  3512,   828,  1693,  3513,
    3547,  3563,  1694,   829,  3541,  3545,  1665,  3564,   394,   830,
    3009,  1662,   831,  3570,  1691,  3569,  3009,  3009,  3009,  3009,
    3009,  3009,  3560,  3593,  3601,  4383,  1270,  1695,   967,  3573,
    3609,  3597,  3599,  3602,  3104,  3614,  3619,  3612,   832,  3621,
     833,   967,  1663,  3630,   834,   794,  3645,  3631,  3632,  1692,
    3641,  1599,   835,  3508,  3633,   803,  3636,   836,  3646,  3655,
    3245,  2005,  3881,  3883,  3885,  3887,  2228,   837,  1146,  3227,
    3684,  3244,  3685,   668,  3536,  1146,  3539,  3686,  1729,   838,
    3697,  2063,  1694,  3709,  1171,  3710,  3728,   967,  3718,  3734,
    3746,  3744,  3753,   355,  3756,   355,  1819,  3767,  3747,  1664,
    2843,  1348,  1349,  3750,  2846,  3745,  3758,  1730,  4041,  3819,
    3865,  3781,  3783,  3791,  3506,  3797,  3798,  3595,   355,  3808,
    3834,  3936,  3810,  3880,  3809,  1146,  2866,  3835,  3811,  3894,
    1665,  3908,  3868,  3901,  2878,   209,   969,  2523,  3812,  3105,
    3832,  3904,  3585,  3911,  3913,  1669,  2529,  3910,  4039,  3918,
    2578,  3927,  1670,  3914,  2537,  2538,  3931,  2892,  3104,  3932,
    1746,  3941,  3945,  3947,  2665,   394,  3957,   394,  1672,  3934,
    3971,  3942,  2550,  3965,  4058,  3976,  1673,  2915,  4402,  3979,
      81,    81,  3981,    81,  3950,  2518,  3984,  4019,  2665,  2665,
     394,  1146,  3989,  3634,  2934,  3993,  3999,  2954,  3960,  3994,
    3988,  4020,   794,  4040,   794,  3995,  4022,  4023,  4047,  1599,
    4042,  4427,   803,  4055,   803,  2970,  4056,  3647,  2511,  4057,
    4063,  4069,  2974,  2511,  4079,  1674,  2511,   794,  3428,  3106,
    3430,  2987,  4072,  4080,  4084,  4092,  4099,   803,  2991,  3860,
    4105,  1147,  4102,  4112,  1151,   967,  4120,   349,  4124,  4128,
    4130,  1819,  4137,  4141,  2068,  4150,  4151,  2069,  4159,   209,
    1182,  4176,   969,  1668,  4114,  4166,  4180,  4188,  4181,  1669,
    4183,  4189,  4190,  4191,  4198,  4202,  1670,  1146,  4204,  4208,
    4220,  4210,  2072,  1227,  1746,  4236,   797,  2073,   969,  4223,
    4230,  4231,  1672,  4237,  4034,  4035,  4245,  3900,  1245,  3461,
    1673,  4252,  4254,  4263,  4264,  1146,    80,  4265,  4267,  2068,
    4279,  4489,  2069,  4280,  4281,  4282,  4283,  4293,  4309,  4033,
    1070,  1684,  4317,  4340,  4344,  4348,  4350,  1685,  4353,  2070,
    4357,    79,  1146,  1146,  4363,  1146,  4358,  2072,  4367,  4372,
    4373,  4374,  2073,  4379,   797,  4381,  4326,  1910,  2096,  1674,
    4390,  4391,  1146,  3106,  3585,  2238,  4400,  4394,  4396,  3478,
    2665,  4403,  3736,  4429,  4423,  2068,  1686,    74,  2069,  4420,
    4425,   967,  4392,   796,  4393,  3276,  4437,  3556,   969,  4460,
    4450,  4477,  3009,  3009,  4480,  2070,  4490,  3063,  3341,  2135,
     356,  2895,  4486,  2072,  1079,  4125,  1270,   967,  2073,  2147,
    2399,  4090,  4091,  1146,   396,  4095,  4096,  2924,  4066,  4067,
    3794,  3407, -2407,  4070,  4071,  4239,  2075,  1687,  3508,  3508,
    3508,  3508,  3508,  2782,  1688,  3475,  4085,  1689,  4336,  3929,
    4266,   796,  4117,  4276,  3384,  1146,  3166,  2076,  2077,  1146,
    1146,  3616,  4426,  4214,  4457,  4397,  4395,  4435,   356,  2490,
    3930, -2407,  2873,  3817,  3440,   396,   396,   396,  4292,  2471,
    3038,  3550,  4132,  4459,  4491,  4487,  4101,  2074,  4100,  3542,
    3489,  2075,  4436,  4229,  4387,  2453,   987,  4232,  1690,  3506,
    3506,  3506,  3506,  3506,  3977,  1976,  2080,   967,  4312,  4152,
    3937,  2888,  2076,  2077,  3938,  4362,  4443,  4488,  1271,  2081,
    1527,  4258,  2791,  2563,  2792,   396,  2078,  3656,  3917,  3643,
    3346,  1924,   396,  1819,  3162,  1552,  2174,  3350,   396,  2814,
    2200,   355,  1012,  2074,  2199,   349,  3661,  2075,  3362,  3358,
    2813,  2808,  1691,  2204,  2787,  3305,  3119,  3607,  2079,  4168,
    1535,  2080,  3347,  1012,  3915,  1267,  4302,  3691,  2076,  2077,
    1819,  3683,  4411,  3701,  2081,  4412,  3353,  2082,  3291,  4419,
    3905,  3906,  2078,   969,  3206,  3184,  3289,  1692,  2752,  1112,
    3112,  3594, -2407,  1819,  2511,  1864,  2505,  3225,  3226,   355,
    2825,  4410,  3241,  1699,  1700,  1988,  2214,  1082,  1315,  2207,
    2816,  1640,  1611,   394,  2079,  1612,  1749,  2080,  1987,  2832,
    1694,  2829,  3336,  4206,  2830,  4029,  3760,  3749,  3761,  1105,
    2081,  3499,  2211,  2082,  2113,  3164,  2575,    83,  1012,  2836,
       0,  3274,  3275,     0,     0,  1750,  1913,  2083,  3009,  1355,
     794,     0,  4240,     0,     0,  1819,  1599,     0,     0,  4205,
     803,     0,  1774,     0,     0,     0,     0,     0,     0,     0,
       0,   394,  2434,     0,  3972,  3973,  3974,     0,  1826,  1827,
       0,     0,  2087,  2088,  2089,  2090,  2091,  2092,     0,     0,
    1819,     0,   967,     0,     0,  1853,     0,     0,     0,     0,
    3373,     0,     0,  2083,     0,     0,     0,     0,   794,     0,
       0,     0,     0,     0,     0,  1819,   797,     0,   803,     0,
     396,     0,     0,     0,     0,     0,     0,     0,     0,  1886,
    1888,     0,     0,  2084,  2085,  2086,     0,  2087,  2088,  2089,
    2090,  2091,  2092,     0,     0,  2778,     0,     0,     0,     0,
       0,  2779,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1146,     0,  1146,     0,     0,     0,     0,     0,
    1819,  4476,     0,  1146,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3421,     0,     0,     0,  2084,
    2085,  2086,  3431,  2087,  2088,  2089,  2090,  2091,  2092,     0,
       0,  3748,     0,   796,     0,    81,     0,     0,    81,     0,
    1270,  3144,     0,  4365,     0,     0,     0,     0,     0,     0,
     356,     0,     0,     0,     0,  3152,  3153,     0,     0,  3155,
       0,     0,     0,     0,     0,  3159,  2068,     0,     0,  2069,
       0,     0,     0,     0,     0,     0,     0,     0,  2068,     0,
       0,  2069,     0,     0,  3458,     0,     0,     0,  1146,     0,
    3907,     0,  4075,  4076,  2072,  4078,     0,     0,     0,  2073,
       0,     0,     0,     0,     0,     0,  2072,     0,     0,     0,
       0,  2073,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1146,  1146,     0,     0,
       0,     0,     0,     0,  1146,     0,     0,  1146,  3198,     0,
    1146,     0,     0,  4445,  4446,  2649,  4448,     0,  1146,  1146,
       0,  4447,  4364,     0,     0,     0,  1146,     0,     0,  1146,
    1146,  1146,  1146,     0,     0,     0,     0,     0,     0,  1146,
    1146,     0,  1146,     0,  1146,  4445,  4446,  1146,  4448,     0,
       0,   355,     0,  4447,     0,     0,     0,     0,     0,     0,
       0,  1819,  1146,   396,     0,     0,  1146,     0,     0,     0,
    1146,     0,     0,     0,  1146,     0,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  1146,  1146,     0,  1146,     0,  4445,  4446,
       0,  4448,  1146,  4163,  2074,  1146,  4447,     0,  2075,     0,
       0,     0,     0,  4163,     0,  4470,  2074,     0,     0,     0,
    2075,     0,     0,     0,     0,     0,     0,  2397,     0,  2076,
    2077,     0,     0,   394,     0,     0,     0,     0,     0,  1988,
    4469,  2076,  2077,  2078,     0,  3637,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2078,   349,     0,     0,     0,
    4470,     0,   396,  3103,     0,     0,     0,  3650,  4470,     0,
     794,     0,     0,     0,     0,  1146,  4466,     0,  2080,     0,
     803,  1662,     0,     0,     0,  4469,     0,     0,  4475,     0,
    2080,  2081,     0,  4469,     0,     0,     0,     0,     0,     0,
       0,    35,     0,  2081,     0,     0,     0,     0,     0,    41,
      42,     0,  1663,     0,   396,  2068,   396,     0,  2069,     0,
    4060,  4466,     0,     0,     0,     0,     0,     0,     0,  4466,
    4068,   349,     0,     0,     0,  2070,     0,     0,  2071,     0,
       0,     0,     0,  2072,     0,     0,     0,     0,  2073,     0,
       0,     0,     0,    81,     0,    81,     0,     0,  3390,     0,
       0,     0,     0,     0,  2083,   396,     0,     0,     0,  1664,
       0,     0,     0,     0,  3662,     0,  2083,  3667,  3668,  3669,
    3670,  3671,  3672,  3673,  3674,  3675,  3676,     0,     0,  1146,
    2386,  2387,  2388,  2389,     0,     0,     0,  3410,     0,  3412,
    1665,     0,     0,     0,     0,     0,     0,     0,     0,  1819,
       0,     0,     0,     0,  1819,  1819,     0,     0,     0,  4296,
       0,  2417,  2418,     0,     0,  1819,     0,  2427,  3104,     0,
       0,     0,     0,     0,  3713,  3714,     0,     0,     0,     0,
       0,   396,     0,     0,     0,     0,     0,     0,     0,     0,
    2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,
       0,     0,  3779, -2407, -2407,     0,  2087,  2088,  2089,  2090,
    2091,  2092,     0,  2074,     0,     0,   396,  2075,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4335,  3556,  2475,  2476,  2477,  2478,     0,     0,  2076,  2077,
       0,     0,     0,     0,     0,     0,     0,     0,  2068,     0,
       0,  2069,  2078,     0,     0,     0,     0,  1988,     0,     0,
    3824,     0,  3826,     0,     0,     0,     0,     0,  2070,   209,
       0,     0,     0,  1668,     0,     0,  2072,     0,  1146,  1669,
    1819,  2073,     0,     0,  2079,     0,  1670,  2080,     0,     0,
       0,     0,     0,     0,  1746,     0,     0,     0,     0,     0,
    2081,     0,  1672,  2082,  2552,     0,     0,     0,     0,     0,
    1673,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2068,     0,
       0,  2069,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1819,     0,     0,     0,     0,     0,     0,  2070,     0,
       0,     0,  1146,     0,     0,     0,  2072,     0,     0,  1674,
       0,  2073,  1146,  3106,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2083,     0,  3615,     0,     0,     0,  3618,
       0,  3620,     0,  3622,  3623,     0,     0,     0,     0,     0,
       0,     0,  3628,     0,     0,     0,     0,     0,     0,  1146,
       0,     0,     0,     0,     0,     0,  2074,     0,     0,  3896,
    2075,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1156,     0,     0,     0,     0,     0,  1176,     0,     0,     0,
    3649,  2076,  2077,     0,  1185,     0,     0,     0,     0,     0,
       0,     0,  1193,  1146,     0,  2078,     0,  1220,     0,     0,
    1988,     0,     0,     0,  1819,     0,     0,     0,     0,  2084,
    2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,     0,
       0,     0,     0,  1146,  1146,  3051,     0,  2079,     0,     0,
    2080,     0,     0,     0,     0,     0,  2074,     0,     0,     0,
    2075,     0,     0,  2081,     0,  1988,  2082,     0,     0,  1988,
    1988,     0,     0,  1146,  1146,     0,     0,     0,  1146,     0,
       0,  2076,  2077,     0,     0,     0,     0,     0,     0,     0,
    1146,  1146,  1146,  1146,     0,  2078,     0,     0,   396,  2935,
       0,     0,  1146,   396,     0,  1146,     0,  1146,  2936,  2937,
    2938,     0,     0,     0,     0,     0,     0,  1146,  1146,     0,
    1146,     0,     0,     0,     0,     0,     0,  2079,     0,     0,
    2080,     0,     0,  1146,     0,  1146,  2083,     0,     0,  1146,
       0,     0,     0,  2081,     0,  1368,  2082,     0,     0,     0,
       0,     0,  2939,     0,     0,  1146,     0,     0,     0,     0,
    4003,  4004,  1384,     0,     0,  1146,     0,  1146,  1146,  1146,
       0,     0,  1684,     0,     0,     0,     0,  4064,  1685,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4073,     0,
       0,  1146,     0,  1506,     0,     0,  3052,     0,     0,     0,
    1146,  2940,  1710,     0,     0,     0,     0,     0,     0,  1146,
    1529,     0,     0,     0,  1146,     0,  2083,  1686,     0,     0,
       0,  1146,  2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,
    2091,  2092,     0,  1558,     0,     0,     0,     0,  3220,     0,
    2941,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1711,     0,     0,     0,     0,     0,  2942,  2943,  2944,  2945,
    2946,     0,  2947,     0,     0,     0,     0,     0,  1687,  1146,
       0,     0,     0,     0,     0,  1688,     0,     0,  1689,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2948,     0,     0,  1819,  1819,     0,
    1819,     0,  2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,
    2091,  2092,     0,     0,     0,     0,     0,     0,  3266,     0,
       0,     0,     0,     0,     0,     0,  1712,     0,     0,  1690,
    3053,  2957,     0,     0,     0,  2068,     0,     0,  2069,     0,
       0,  1819,     0,  1819,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2070,     0,     0,     0,     0,
       0,     0,     0,  2072,     0,     0,     0,  2949,  2073,  3054,
       0,  1713,     0,  1714,   396,   396,   396,     0,  3001,     0,
       0,     0,     0,  1715,     0,  3010,  3011,  3012,  3013,  3014,
    3015,     0,     0,  2950,     0,     0,     0,     0,     0,     0,
    2951,     0,     0,  2952,     0,     0,     0,     0,     0,     0,
       0,     0,  1819,     0,  1849,  1851,  1852,  1716,  1692,     0,
       0,  3966,     0,     0,     0,     0,     0,     0,  3969,  3970,
       0,     0,     0,     0,   396,     0,     0,     0,  3490,  1819,
    4179,     0,     0,     0,     0,     0,     0,  1717,     0,     0,
       0,  1694,  1718,     0,     0,     0,  3082,     0,     0,     0,
       0,     0,     0,     0,  4193,  4194,     0,     0,     0,     0,
       0,     0,   396,  1819,     0,     0,  1719,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1720,     0,     0,     0,
    1819,     0,     0,  2074,     0,     0,  3146,  2075,  3148,     0,
       0,     0,     0,     0,  1819,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1819,  2076,  2077,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1506,     0,  2078,  2068,     0,  1146,  2069,     0,     0,  1146,
       0,     0,     0,     0,     0,     0,     0,     0,  1146,     0,
       0,     0,     0,     0,  1819,     0,     0,     0,  1506,     0,
       0,  2072,     0,     0,  2079,     0,  2073,  2080,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2081,     0,     0,  2082,  1146,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  4061,  4062,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1146,     0,     0,
    1819,     0,     0,     0,     0,     0,  1146,     0,     0,     0,
       0,     0,  1146,     0,  1146,     0,  4299,     0,     0,  1819,
    1146,     0,     0,  1146,  1146,  1146,  1146,  1146,  1146,  1146,
    1146,  1146,  1146,  2083,  3287,     0,  1146,  1146,     0,     0,
       0,     0,     0,     0,  1819,     0,     0,     0,     0,  1146,
       0,     0,     0,   396,     0,  1146,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1146,     0,     0,  1146,     0,
    1146, -2407,     0,     0,  2151,  2075,     0,     0,  1819,  1146,
    1146,  1146,     0,     0,     0,  1146,     0,     0,  1146,     0,
       0,     0,     0,     0,     0,     0,  2076,  2077,  1146,     0,
       0,     0,     0,     0,     0,     0,  1146,     0,  1146,     0,
   -2407,     0,     0,   676,     0,     0,     0,     0,   694,  2084,
    2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,     0,
       0,     0,     0,  2694,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2080,     0,     0,     0,  4172,
       0,  4173,  4174,     0,     0,     0,   694,     0,  2081,     0,
       0,     0,  4177,     0,     0,    85,     0,     0,     0,     0,
       0,    89,     0,     0,     0,    93,   694,    94,  1146,    96,
      97,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     106,     0,     0,     0,     0,   978,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   119,   120,   980,
     396,  1819,   396,     0,     0,     0,     0,   988,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0, -2407,   998,     0,   978,   396,  2335,     0,  1019,     0,
       0,     0,  2068,     0,     0,  2069,     0,  1047,     0,     0,
       0,     0,     0,   128,     0,  1052,  1047,     0,     0,     0,
       0,     0,  2070,   129,     0,   130,   131,     0,     0,     0,
    2072,     0,     0,     0,     0,  2073,     0,     0,     0,  1078,
       0,     0,     0,     0,     0,     0,  2390,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   141,
       0,   142,   143,     0,     0,     0,   145,  2411,   146,     0,
       0,     0,     0,     0,     0,  1146,     0,     0,   148,     0,
     149,  2087,  2088,  2089,  2090,  2091,  2092,     0,     0,     0,
       0,     0,     0,  1819,     0,     0,     0,   152,     0,   153,
       0,     0,   156,     0,     0,     0,     0,     0,   157,     0,
       0,     0,     0,     0,   158,     0,   159,     0,     0,     0,
     160,     0,  4298,     0,     0,     0,   161,     0,  1819,  1146,
    1146,     0,     0,   163,     0,   165,     0,     0,     0,     0,
     167,     0,     0,     0,     0,  2068,     0,     0,  2069,     0,
       0,     0,     0,  1146,   171,  4314,     0,     0,  1146,     0,
    2074,  1146,     0,     0,  2075,  2070,     0,     0,     0,     0,
       0,     0,     0,  2072,     0,     0,     0,     0,  2073,     0,
       0,     0,   176,     0,     0,  2076,  2077,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2078,
    2541,     0,     0,     0,     0,  1146,   185,   186,     0,  2545,
       0,     0,   187,     0,     0,     0,     0,     0,     0,     0,
       0,   188,     0,     0,     0,     0,     0,     0,     0,  2560,
       0,  2079,     0,     0,  2080,     0,     0,     0,   193,     0,
       0,  1146,     0,     0,     0,     0,     0,  2081,  1146,  1146,
    2082,  1819,     0,     0,     0,     0,  1146,  1146,     0,     0,
       0,  1146,  1819,     0,     0,     0,     0,  1146,  1146,     0,
       0,  1146,     0,     0,   204,     0,  1506,  1506,     0,     0,
       0,     0,  1146,     0,     0,   206,     0,     0,     0,   207,
       0,   208,     0,     0,  1146,     0,   209,     0,     0,     0,
       0,   210,     0,  2074,   212,     0,     0,  2075,   214,     0,
      81,     0,     0,     0,   215,     0,     0,     0,     0,     0,
    2083,   216,  1146,     0,   218,     0,     0,     0,  2076,  2077,
       0,   221,     0,     0,     0,     0,     0,     0,  2068,     0,
       0,  2069,  2078,  1819,   223,     0,     0,     0,     0,     0,
       0,     0,     0,  1819,     0,     0,     0,     0,  2070,     0,
       0,   228,     0,   229,     0,  4455,  2072,     0,     0,     0,
     231,  2073,   232,     0,  2079,   233,     0,  2080,     0,   234,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2081,   237,     0,  2082,     0,     0,     0,     0,   396,     0,
       0,     0,     0,     0,     0,  2751,  2084,  2085,  2086,     0,
    2087,  2088,  2089,  2090,  2091,  2092,     0,     0,     0,     0,
    3500,   694,     0,     0,   246,     0,     0,     0,     0,     0,
    2771,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1146,     0,     0,     0,
       0,     0,     0,     0,     0,  2068,   396,     0,  2069,     0,
       0,     0,     0,  2083,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2790,     0,  2793,  2068,     0,
       0,  2069,     0,  2072,     0,     0,     0,     0,  2073,     0,
       0,     0,     0,     0,  1819,     0,  2074,     0,  2070,     0,
    2075,     0,     0,     0,     0,  1146,  2072,     0,     0,  1146,
       0,  2073,     0,     0,  1819,     0,     0,     0,     0,     0,
       0,  2076,  2077,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2078,  1146,     0,     0,     0,
    1819,     0,     0,     0,     0,     0,     0,     0,     0,  2084,
    2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,     0,
    1146,  1146,     0,  3700,  1146,     0,     0,  2079,     0,     0,
    2080,  1146,  1146,     0,     0,     0,  3715,     0,     0,     0,
       0,     0,     0,  2081,     0,     0,  2082,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1146,     0,
    1142,  1148,   694,     0,  1148,     0,  1142,   676,  1047,     0,
    1173,     0,   676, -2407,  1047,  1819,  1047,  2075,  1146,     0,
    1148,   676,  1047,     0,     0,     0,     0,     0,     0,     0,
    1195,     0,     0,     0,     0,  1047,  2074,  1142,  2076,  2077,
    2075,   694,  2914,  1148,     0,     0,   676,     0,  1173,     0,
     676,  1240, -2407,     0,     0,  1146,  2083,     0,  1148,     0,
     676,  2076,  2077,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2078,     0,     0,     0,     0,
    1047,     0,     0,     0,     0,  1269,     0,  2080,  2068,  1142,
       0,  2069,  1814,   694,     0,     0,  1142,     0,     0,  1173,
    2081,     0,     0,  1146,     0,  1819,     0,  2079,  2070,     0,
    2080,     0,     0,     0,  1148,     0,  2072,     0,     0,     0,
       0,  2073,     0,  2081,     0,  1330,  2082,     0,     0,     0,
       0,     0,  1146,  1819,     0,  1146,     0,  1146,     0,     0,
       0,     0,  2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,
    2091,  2092,     0,     0,     0,     0,  3755,     0,     0,     0,
       0,     0,     0,  1047,  3062,     0,     0,     0,  1047,     0,
       0,     0,     0, -2407,     0,  1146,     0,     0,  1819,     0,
    1047,  1385,  1819,  1819,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2083,     0,  2068,     0,
       0,  2069,     0,     0,     0,     0,  1488,     0,   396,     0,
     694,  1047,     0,     0,  1269,  1146,  2068,     0,  2070,  2069,
       0,     0,     0,     0,     0,     0,  2072,     0,  1047,     0,
       0,  2073,  1047,     0,     0,     0,  2070,  1538,     0,     0,
       0,  1819,  1488,     0,  2072,  4366,  2074,  1814,     0,  2073,
    2075,  1047,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1146,     0,  2087,  2088,  2089,  2090,  2091,  2092,     0,
       0,  2076,  2077,     0,     0,     0,     0,     0,  4049,  4049,
       0,     0,  2084,  2085,  2086,  2078,  2087,  2088,  2089,  2090,
    2091,  2092,     0,     0,     0,     0,  3769,     0,   676,   676,
       0,     0,     0,     0,     0,  1146,     0,     0,     0,     0,
       0,     0,  1146,     0,     0,     0,     0,  2079,     0,     0,
    2080,     0,     0,     0,     0,  4077,     0,     0,  1146,  1146,
       0,     0,     0,  2081,     0,     0,  2082,     0,  1146,     0,
       0,     0,     0,  1148,  1148,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2074,     0,     0,     0,
    2075,     0,     0,     0,     0,  1146,     0,     0,     0,     0,
       0,     0,     0,     0,  2074,  1146,     0,     0,  2075,     0,
    1142,  2076,  2077,     0,     0,  2133,     0,  1142,     0,     0,
    1173,     0,     0,     0,     0,  2078,     0,     0,     0,  2076,
    2077,     0,  1148,     0,     0,     0,  2083,     0,     0,     0,
       0,     0,     0,  2078,     0,     0,     0,     0,  1148,  1148,
       0,     0,     0,     0,     0,     0,     0,  2079,     0,  1146,
    2080,     0,  1047,  1047,  1047,  1148,     0,  1142,  1146,     0,
       0,  1861,     0,  2081,     0,  2079,  2082,     0,  2080,     0,
       0,     0,     0,  3302,     0,     0,     0,     0,     0,     0,
       0,  2081,     0,     0,  2082,     0,     0,     0,     0,  1148,
    1148,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1269,     0,
       0,     0,  2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,
    2091,  2092,     0,  1488,     0,  2068,  3982,     0,  2069,  1814,
       0,     0,  1506,  1269,     0,     0,  2083,     0,     0,     0,
       0,     0,     0,     0,     0,  2070,     0,     0,     0,     0,
       0,     0,     0,  2072,  2083,     0,     0,     0,  2073,     0,
       0,     0,     0,  1961,  1961,     0,  1814,     0,  1047,     0,
     978,     0,  4217,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1814,
       0,     0,     0,  1997,     0,     0,  1047,     0,     0,  2003,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1488,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,
    2091,  2092,     0,     0,     0,     0,  4014,  1488,     0,     0,
    2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,
       0,  1814,  2068,     0,  4187,  2069,     0,     0,     0,     0,
    2935,     0,     0,     0,  1488,  1488,     0,  1488,  1814,  2936,
    2937,  2938,  2070,     0,  4284,     0,     0,     0,     0,  2068,
    2072,     0,  2069,  2074,  1488,  2073,  1814,  2075,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   694,   694,     0,  2072,  2076,  2077,
       0,  1814,  2073,  2939,     0,     0,     0,     0,  1269,     0,
       0,     0,  2078,     0,     0,  1269,  1269,     0,     0,     0,
       0,     0,  1047,     0,     0,  1488,  4049,     0,     0,     0,
       0,  2161,     0,  2168,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2079,     0,     0,  2080,  4332,     0,
    4334,     0,  2940,     0,     0,     0,  1814,  1488,     0,     0,
    2081,  1488,  1488,  2082,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3692,     0,     0,     0,     0,     0,     0,     0,  3549,
    3716,  2941,     0,     0,     0,   694,     0,   676,     0,  3562,
    2074,     0,     0,     0,  2075,     0,     0,  2942,  2943,  2944,
    2945,  2946,     0,  2947,  3574,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2076,  2077, -2407,     0,     0,
       0,  2075,     0,  2083,     0,     0,     0,     0,     0,  2078,
       0,     0,     0,     0,     0,  2948,  3693,     0,     0,     0,
       0,     0,  2076,  2077,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  4399,     0, -2407,  3624,     0,     0,
    3625,  2079,     0,     0,  2080,     0,     0,     0,  2323,     0,
       0,     0,     0,     0,  1047,     0,     0,  2081,     0,     0,
    2082,     0,     0,     0,     0,     0,     0,  1173,     0,     0,
       0,  2080,     0,     0,  4428,     0,     0,     0,     0,     0,
       0,  1506,     0,     0,  2081,     0,     0,     0,  2949,  2084,
    2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,     0,
    1148,  1148,  1148,  1148,  1047,     0,     0,     0,   676,     0,
       0,     0,     0,     0,  2950,     0,     0,  1814,     0,  2068,
       0,  2951,  2069,  2410,  2952,  1047,     0,     0,     0,     0,
    2083,  1148,  1148,     0,     0,     0,     0,  1148,     0,  2070,
       0,     0,     0,     0,     0,     0,     0,  2072,     0,     0,
       0,     0,  2073,     0,     0,     0,     0, -2407,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3725,
    3726,     0,     0,     0,     0,     0,   676,     0,     0,     0,
       0,     0,  1148,  1148,  1148,  1148,     0,     0,     0,     0,
       0,   676,     0,     0,     0,     0,  2084,  2085,  2086,  2410,
    2087,  2088,  2089,  2090,  2091,  2092,     0,     0,     0,     0,
    4212,     0,     0,     0,  2519,     0,  1142,     0,     0,     0,
       0,     0,     0,   694,     0,  1142,     0,  2087,  2088,  2089,
    2090,  2091,  2092,  1173,     0,     0,  3244,     0,  1047,     0,
       0,  3245,     0,     0,     0,     0,     0,  1047,     0,   676,
       0,     0,     0,  1148,  1148,     0,     0,  2074,     0,     0,
       0,  2075,     0,     0,     0,     0,     0,  1047,     0,     0,
    1330,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2076,  2077,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2078,     0,     0,     0,
       0,     0,  1961,     0,     0,     0,     0,     0,     0,     0,
    1142,     0,     0,     0,  1047,  1047,     0,     0,     0,     0,
       0,     0,  2600,     0,     0,     0,  1047,     0,  2079,     0,
       0,  2080,     0,     0,     0,  1814,     0,     0,     0,     0,
    1814,  1814,   978,   978,  2081,     0,  2625,  2082,  1488,  1488,
       0,  1814,     0,     0,     0,     0,  1488,     0,     0,  1488,
       0,     0,  1488,     0,     0,     0,     0,     0,     0,     0,
    1488,  1488,     0,     0,     0,     0,     0,  3877,  1488,     0,
    1173,  1488,  1488,  1488,  1488,     0,     0,     0,     0,     0,
       0,  1488,  1488,     0,  1488,  3902,  1488,     0,     0,  1488,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3909,     0,  1488,     0,     0,  2083,  1488,     0,
       0,     0,  1488,     0,     0,     0,  1488,     0,  1488,  1488,
    1488,  1488,  1488,  1488,  1488,  1488,  1488,     0,  1488,     0,
       0,     0,     0,  1047,  1488,     0,     0,  1488,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1814,     0,  1047,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     4,
       0,     0,     0,  2084,  2085,  2086,  2168,  2087,  2088,  2089,
    2090,  2091,  2092,  1047,     0,  1047,     0,  1488,     0,     5,
       0,     0,     0,     0,     0,     0,     0,  1814,     0,     6,
       7,     0,     0,     0,     0,     8,     0,     9,    10,     0,
       0,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    34,    35,     0,    36,     0,    37,
      38,    39,    40,    41,    42,    43,    44,   676,     0,     0,
      45,     0,     0,     0,     0,     0,     0,  4015,  4016,  4017,
    4018,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   676,     0,     0,     0,   676,   694,
       0,     0,     0,     0,   978,     0,   978,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    46,     0,     0,
     676,  1488,     0,     0,     0,     0,     0,     0,   676,     0,
    1814,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   676,     0,  2323,     0,     0,     0,     0,     0,  2896,
       0,     0,     0,     0,  2905,     0,     0,     0,     0,     0,
    1047,   676,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2927,  2927,     0,     0,     0,     0,   694,   676,    47,
       0,   676,     0,  2068,     0,     0,  2069,     0,     0,     0,
       0,  1148,     0,     0,    48,     0,     0,     0,     0,   676,
       0,     0,     0,  2070,     0,     0,   676,     0,     0,     0,
       0,  2072,     0,     0,    49,   676,  2073,     0,     0,     0,
       0,     0,   676,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    50,     0,  1148,     0,
       0,     0,     0,     0,     0,  1148,  1148,  1148,  1148,  1148,
    1148,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1488,     0,     0,     0,  2068,     0,     0,  2069,     0,    51,
       0,     0,    52,     0,     0,     0,     0,     0,  2927,     0,
       0,     0,  1047,     0,  2070,     0,   978,     0,     0,     0,
       0,  4158,  2072,    53,     0,     0,     0,  2073,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3078,     0,     0,     0,     0,     0,  1148,  3092,     0,     0,
       0,     0,     0,     0,     0,     0,  1269,  1861,     0,     0,
       0,     0,     0,     0,  2519,  3122,     0,     0,     0,  3122,
    3135,  2074,     0,     0,  1488,  2075,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1148,  2927,  1148,  2927,
       0,     0,     0,     0,    54,     0,  2076,  2077,     0,     0,
       0,     0,     0,  1269,     0,  2068,     0,     0,  2069,     0,
    2078,  1488,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1814,  1814,  2070,  1814,     0,     0,     0,
       0,     0,  1961,  2072,     0,     0,    55,     0,  2073,     0,
       0,     0,  2079,     0,     0,  2080,     0,     0,   676,    56,
       0,     0,  2074,     0,     0,  1488,  2075,     0,  2081,     0,
       0,  2082,    57,     0,     0,     0,     0,  1814,     0,  1814,
       0,     0,     0,     0,     0,     0,   676,  2076,  2077,     0,
       0,     0,     0,     0,     0,  1488,  1488,    58,  4248,     0,
       0,  2078,     0,    59,     0,     0,     0,    60,    61,    62,
      63,    64,     0,     0,    65,    66,    67,    68,     0,    69,
      70,    71,    72,    73,     0,  1488,  1488,  1506,     0,     0,
    1488,     0,     0,  2079,     0,     0,  2080,     0,     0,     0,
       0,  2083,  1488,  1488,  1488,  1488,     0,     0,  1814,  2081,
       0,     0,  2082,     0,  1488,     0,     0,  1488,     0,  1488,
    3270,     0,     0,     0,     0,     0,     0,     0,     0,  1488,
    1488,     0,  1488,  2074,     0,  1814,     0,  2075,     0,   802,
       0,     0,     0,     0,     0,  1488,     0,  1488,     0,  1173,
       0,  1488,     0,     0,     0,     0,     0,     0,  2076,  2077,
       0,     0,     0,     0,     0,     0,  4320,  1488,     0,  1814,
       0,  1047,  2078,     0,     0,     0,     0,  2519,     0,  1488,
    1488,  1488,  2083,     0,   802,     0,  1814,  2084,  2085,  2086,
       0,  2087,  2088,  2089,  2090,  2091,  2092,     0,     0,  1269,
    1814,  4250,     0,  1488,  2079,     0,     0,  2080,     0,     0,
    2168,     0,  1488,  1814,     0,     0,     0,     0,     0,     0,
    2081,  1488,     0,  2082,     0,     0,  1488,     0,     0,     0,
    1047,  1010,     0,  1488,     0,     0,     0,     0,  1010,     0,
    1010,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1814,     0,   802,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   676,     0,     0,     0,  2084,  2085,
    2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,     0,     0,
       0,  1488,  4401,  2927,     0,     0,     0,  1961,     0,     0,
       0,     0,     0,  2083,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1814,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1814,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   676,
       0,     0,     0,     0,     0,     0,   676,     0,     0,     0,
    1814,     0,  2068,     0,     0,  2069,     0,     0,     0,     0,
       0,     0,  2068,     0,     0,  2069,     0,     0,     0,  2084,
    2085,  2086,  2070,  2087,  2088,  2089,  2090,  2091,  2092,     0,
    2072,     0,  2070,  4478,  1814,  2073,  2798,     0,     0,     0,
    2072,     0,     0,     0,     0,  2073,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   676,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2927,  2927,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2068,     0,     0,  2069,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3507,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2072,     0,
       0,     0,     0,  2073,     0,     0,  2799,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1961,  1047,  4453,     0,
       0,     0,     0,     0,     0,     0,     0,  1047,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2074,     0,  1047,     0,  2075,     0,     0,  1814,  1269,     0,
    2074,     0,     0,     0,  2075,     0,     0,   694,     0,     0,
       0,  3122,     0,     0,  3598,  2076,  2077,  2519,     0,     0,
       0,  2519,     0,     0,     0,  2076,  2077,  3611,     0,  2078,
    1488,  3719,     0,     0,     0,     0,     0,     0,     0,  2078,
       0,     0,     0,     0,     0,  1047,     0,     0,  1047,     0,
       0,   676,     0,     0,     0,  3629,     0,     0,     0,     0,
       0,  2079,     0,     0,  2080,     0,  1142,     0, -2407,   676,
       0,  2079,  2075,     0,  2080,     0,  2600,  2081,     0,     0,
    2082,     0,     0,     0,     0,     0,     0,  2081,     0,  1047,
    2082,   676,     0,  2076,  2077,     0,  4454,     0,     0,  1488,
       0,     0,     0,     0,     0,     0,     0, -2407,  1488,     0,
       0,     0,     0,     0,  1488,     0,  1488,     0,     0,  1814,
       0,     0,  1488,     0,     0,  1488,  1488,  1488,  1488,  1488,
    1488,  1488,  1488,  1488,  1488,     0,     0,     0,  1488,  1488,
       0,     0,  2080,     0,     0,     0,     0,     0,     0,     0,
    2083,  1488,     0,     0,  1814,  2081,     0,  1488,     0,     0,
    2083,     0,     0,     0,     0,     0,  2068,  1488,     0,  2069,
    1488,     0,  1488,     0,     0,     0,     0,     0,     0,     0,
       0,  1488,  1488,  1488,     0,     0,  2070,  1488,     0,  3208,
    1488,     0,     0,     0,  2072,     0,     0,  1047,  1047,  2073,
    1488,     0,     0,     0,     0,     0,  3738,     0,  1488,  2800,
    1488,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0, -2407,     0,
       0,     0,     0,     0,     0,     0,  2084,  2085,  2086,  2168,
    2087,  2088,  2089,  2090,  2091,  2092,  2084,  2085,  2086,     0,
    2087,  2088,  2089,  2090,  2091,  2092,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1814,     0,     0,
    3775,  1961,  1961,     0,     0,     0,   676,     0,  1814,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     802,     0,     0,     0,     0,  3793,     0,     0,  1144,     0,
       0,     0,     0,     0,  1144,     0,     0,     0,  2087,  2088,
    2089,  2090,  2091,  2092,  2074,     0,     0,     0,  2075,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   676,  1144,   676,     0,     0,  2076,
    2077,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2078,     0,     0,     0,     0,     0,  1814,
       0,     0,  1269,     0,     0,     0,     0,     0,     0,  1814,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2079,     0,  1144,  2080,  3507,
       0,     0,     0,     0,  1144,  1047,     0,     0,     0,     0,
       0,  2081,     0,     0,  2082,     0,     0,  1488,     0,     0,
       0,     0,  2068,  1047,     0,  2069,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1047,     0,  2070,     0,     0,  3252,     0,     0,     0,  3078,
    2072,     0,     0,     0,  3924,  2073,     0,     0,  2323,     0,
    3629,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1488,  1488,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2083,     0,     0,     0,     0,     0,
       0,  3122,     0,     0,     0,  2519,     0,     0,     0,     0,
    2519,     0,     0,  2519,  3078,     0,  3962,     0,     0,     0,
       0,     0,     0,  2927,  1144,  2927,     0,     0,     0,     0,
    1010,     0,     0,     0,  1010,     0,     0,  1806,     0,     0,
       0,     0,     0,   676,     0,     0,     0,     0,     0,     0,
    1814,     0,     0,     0,     0,     0,     0,  1488,     0,     0,
    1144,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1814,     0,     0,     0,
    2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,
    2074,     0,     0,  1488,  2075,     0,     0,     0,     0,     0,
    1488,  1488,     0,     0,     0,     0,     0,     0,  1488,  1488,
       0,     0,     0,  1488,     0,  2076,  2077,     0,     0,  1488,
    1488,     0,     0,  1488,     0,  1047,  1047,  1047,  1047,  2078,
       0,     0,     0,     0,  1488,     0,     0,     0,     0,     0,
    4026,     0,     0,     0,     0,     0,  1488,     0,     0,     0,
       0,  1814,     0,     0,     0,     0,     0,  1173,     0,     0,
       0,  2079,     0,     0,  2080,     0,     0,     0,     0,  2068,
       0,   978,  2069,     0,  1488,     0,     0,  2081,  1148,  1148,
    2082,     0,     0,     0,     0,     0,     0,     0,     0,  2070,
       0,     0,  1806,  4059,     0,     0,     0,  2072,  1144,     0,
       0,   676,  2073,     0,     0,  1144,     0,     0,     0,     0,
       0,     0,   676,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1148,  1817,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1814,     0,     0,     0,     0,     0,     0,     0,     0,
    2083,     0,  1269,     0,     0,  1144,     0,     0,     0,     0,
    1961,     0,     0,     0,     0,  1816,     0,     0,     0,  1814,
       0,     0,     0,     0,  3507,  3507,  3507,  3507,  3507,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2068,  1488,     0,
    2069,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1814,     0,     0,     0,  1814,  1814,
       0,  1144,     0,     0,     0,  2072,     0,  2074,     0,     0,
    2073,  2075,     0,     0,     0,     0,  2084,  2085,  2086,     0,
    2087,  2088,  2089,  2090,  2091,  2092,     0,     0,     0,  1047,
       0,  4162,  2076,  2077,     0,     0,     0,  1488,     0,     0,
       0,  2519,     0,     0,  3962,     0,  2078,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1817,     0,   676,     0,     0,     0,     0,  1488,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2079,     0,
       0,  2080,     0,     0,     0,     0,     0,  1144,     0,     0,
       0,     0,  1488,  1488,  2081,     0,  1488,  2082,  4012,     0,
    1816,     0,     0,  1488,  1488,     0,     0,     0,     0,     0,
    3222,     0,     0,     0,     0,  1144,     0,     0,     0,     0,
       0,     0,     0,     0,   676,  2068,   676,     0,  2069,     0,
    3775,  1173,  1148,     0,  1806, -2407,     0,     0,     0,  2075,
       0,     0,  1144,  1144,     0,  1144,     0,     0,     0,     0,
    1142,  1173,     0,  2072,     0,     0,     0,     0,  2073,     0,
    2076,  2077,  1144,     0,     0,     0,     0,  2083,     0,     0,
       0,  1806,     0,     0, -2407,     0,  1961,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1142,     0,     0,
       0,     0,     0,     0,  1806,     0,  1047,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2927,  2080,
    2323,     0,     0,  1144,   802,     0,     0,     0,     0,     0,
    3924,     0,  2081,     0,     0,  1047,     0,     0,     0,     0,
       0,     0,     0,     0,  1148,  3775,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1144,     0,     0,     0,  1144,
    1144,     0,     0,  2084,  2085,  2086,  1806,  2087,  2088,  2089,
    2090,  2091,  2092,     0,  1488,     0,     0,  1488,     0,  1488,
       0,     0,     0,  1806,     0,     0,     0,     0,     0,     0,
       0,     0,  4308,  2074,     0,     0,     0,  2075,     0,     0,
       0,  1806,     0,     0,     0, -2407,  1148,     0,     0,     0,
       0,     0,     0,     0,  1047,     0,     0,  1488,  2076,  2077,
       0,     0,     0,     0,     0,     0,  1806,  1148,  1148,  1148,
    1148,     0,  2078,  1817,     0,     0,  1269,     0,   802,     0,
       0,     0,  1010,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1488,     0,     0,
       0,     0,     0,  1010,  2079,     0,     0,  2080,     0,     0,
    1817,     0,  1816,     0,     0,     0,     0,     0,     0,     0,
    2081,  1806,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1817,     0,  2087,  2088,  2089,  2090,  2091,
    2092,     0,     0,  1488,     0,     0,     0,     0,     0,  2316,
       0,  1173,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1816,     0,     0,     0,     0,     0,  1010,     0,
       0,     0,     0,     0,  1148,     0,     0,  1142,     0,     0,
       0,     0,     0,  2083,  3775,  1817,     0,     0,     0,     0,
       0,  4162,     0,     0,     0,     0,     0,  4308,     0,     0,
    1488,  1488,  1817,   676,     0,     0,     0,     0,     0,     0,
    1142,     0,     0,     0,  1148,     0,     0,     0,     0,     0,
    1817,     0,     0,     0,  1816,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2068,     0,  1488,  2069,     0,
       0,  1816,     0,     0,     0,  1817,     0,  1488,     0,     0,
     802,     0,     0,     0,     0,  2070,     0,     0,     0,  1816,
       0,  4467,     0,  2072,     0,     0,     0,     0,  2073,  2084,
    2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,     0,
       0,     0,     0,     0,  1816,     0,     0,     0,     0,     0,
       0,     0,  1144,     0,  1144,     0,     0,     0,     0,     0,
    1817,  1488,  1806,  1144,     0,     0,  4467,     0,     0,     0,
    1142,     0,     0,     0,  4467,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1816,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3257,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1144,     0,
       0,     0,     0,  2074,     0,     0,     0,  2075,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2076,  2077,
       0,     0,     0,     0,     0,     0,  1144,  1144,     0,     0,
       0,     0,  2078,     0,  1144,     0,     0,  1144,     0,     0,
    1144,     0,     0,     0,     0,     0,     0,     0,  1144,  1144,
       0,     0,     0,     0,     0,     0,  1144,     0,     0,  1144,
    1144,  1144,  1144,     0,  2079,     0,     0,  2080,     0,  1144,
    1144,     0,  1144,     0,  1144,     0,     0,  1144,     0,     0,
    2081,     0,     0,  2082,     0,     0,     0,     0,     0,     0,
       0,  1817,  1144,   802,     0,     0,  1144,     0,     0,     0,
    1144,     0,     0,     0,  1144,     0,  1144,  1144,  1144,  1144,
    1144,  1144,  1144,  1144,  1144,     0,  1144,     0,     0,     0,
       0,     0,  1144,     0,     0,  1144,     0,     0,     0,     0,
    1816,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1806,     0,     0,     0,     0,  1806,  1806,     0,     0,     0,
       0,     0,     0,  2083,     4,     0,  1806,     0,  2068,     0,
       0,  2069,     0,     0,  2764,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     5,     0,     0,     0,  2070,     0,
       0,  3261,     0,     0,     6,     7,  2072,     0,     0,     0,
       0,  2073,     9,    10,     0,  1144,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,     0,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,     0,     0,     0,    45,     0,     0,     0,  2084,
    2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,     0,
       0,     0,     0,     0,     0,  2068,     0,     0,  2069,     0,
       0,     0,     0,     0,     0,     0,  2068,     0,     0,  2069,
       0,  1806,     0,     0,     0,  2070,     0,     0,     0,     0,
       0,     0,    46,  2072,     0,   802,  2070,     0,  2073,  3699,
       0,     0,     0,     0,  2072,     0,     0,     0,     0,  2073,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1144,
       0,     0,     0,     0,     0,     0,  2074,     0,     0,     0,
    2075,     0,     0,     0,     0,     0,     0,     0,     0,  1817,
       0,     0,  1806,     0,  1817,  1817,     0,     0,     0,     0,
       0,  2076,  2077,     0,     0,  1817,     0,     0,     0,     0,
       0,     0,     0,     0,    47,  2078,     0,     0,     0,     0,
       0,   802,     0,     0,     0,     0,     0,     0,  2883,    48,
       0,     0,     0,  2316,  2890,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1816,     0,     0,  2079,     0,    49,
    2080,     0,     0,     0,     0,     0,   802,     0,     0,     0,
       0,     0,     0,  2081,     0,     0,  2082,     0,     0,     0,
       0,    50,     0,  2074,     0,     0,     0,  2075,     0,     0,
       0,     0,     0,     0,  2074,     0,     0,     0,  2075,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2076,  2077,
       0,     0,     0,     0,    51,  1806,     0,    52,     0,  2076,
    2077,     0,  2078,     0,     0,     0,     0,     0,  1144,     0,
    1817,     0,     0,  2078,     0,     0,     0,     0,    53,     0,
       0,     0,     0,     0,     0,     0,  2083,     0,     0,     0,
       0,     0,     0,     0,  2079,     0,     0,  2080,     0,     0,
       0,     0,     0,     0,     0,  2079,     0,     0,  2080,  1816,
    2081,     0,     0,  2082,     0,     0,     0,     0,     0,     0,
       0,  2081,     0,     0,  2082,     0,     0,     0,     0,     0,
       0,  1817,     0,  2068,     0,     0,  2069,     0,     0,     0,
       0,     0,  1144,     0,     0,     0,     0,     0,     0,    54,
       0,     0,  1144,  2070,     0,     0,     0,     0,     0,     0,
       0,  2072,     0,     0,     0,     0,  2073,     0,     0,     0,
    2316,     0,  2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,
    2091,  2092,     0,  2083,     0,     0,     0,     0,     0,  1144,
       0,    55,     0,     0,  2083,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    56,     0,     0,     0,  2068,  3653,
       0,  2069,     0,     0,     0,     0,     0,    57,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2070,     0,
       0,     0,     0,  1144,     0,     0,  2072,     0,     0,     0,
       0,  2073,    58,     0,  1817,     0,     0,     0,    59,     0,
       0,     0,    60,    61,    62,    63,    64,     0,     0,    65,
      66,  1308,     0,  1144,  1144,     0,    71,  1309,     0,  2084,
    2085,  2086,     0,  2087,  2088,  2089,  2090,  2091,  2092,     0,
    2084,  2085,  2086,  1816,  2087,  2088,  2089,  2090,  2091,  2092,
       0,  2074,     0,  1144,  1144,  2075,  1008,     0,  1144,     0,
       0,     0,     0,  1008,     0,  1008,     0,     0,     0,     0,
    1144,  1144,  1144,  1144,     0,     0,  2076,  2077,   802,     0,
       0,     0,  1144,   802,     0,  1144,     0,  1144,  1806,  1806,
    2078,  1806,     0,     0,     0,     0,     0,  1144,  1144,     0,
    1144,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1144,     0,  1144,     0,     0,     0,  1144,
       0,     0,  2079,     0,     0,  2080,  2074,     0,     0,     0,
    2075,     0,  1806,     0,  1806,  1144,     0,     0,  2081,     0,
       0,  2082,     0,     0,     0,  1144,     0,  1144,  1144,  1144,
       0,  2076,  2077,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2078,     0,     0,     0,     0,
       0,  1144,     0,     0,     0,     0,     0,     0,     0,     0,
    1144,     0,     0,     0,     0,     0,  2764,  2764,  2764,  1144,
       0,     0,     0,     0,  1144,     0,     0,  2079,     0,     0,
    2080,  1144,     0,  1806,     0,     0,     0,     0,     0,     0,
       0,  2083,     0,  2081,     0,   905,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   906,     0,     0,
    1806,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   907,     0,  1144,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1806,     0,     0,     0,     0,     0,
       0,     0,   908,     0,     0,     0,     0,  1817,  1817,     0,
    1817,  1806,     0,     0,     0,     0,  2083,     0,     0,     0,
       0,     0,   909,     0,     0,  1806,     0,  2084,  2085,  2086,
       0,  2087,  2088,  2089,  2090,  2091,  2092,     0,  1806,     0,
       0,     0,     0,   910,     0,     0,  2316,  2890,     0,  2890,
       0,  1817,     0,  1817,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   911,     0,     0,     0,  1806,   912,     0,     0,     0,
       0,     0,   913,     0,   802,   802,   802,     0,     0,     0,
    1816,     0,  1816,     0,     0,     0,     0,   914,     0,     0,
       0,     0,  2084,  2085,  2086,     0,  2087,  2088,  2089,  2090,
    2091,  2092,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1817,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1808,  1806,     0,     0,   802,     0,     0,     0,     0,  1817,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1806,  1816,  1809,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   915,     0,     0,
       0,     0,   802,  1817,     0,  1806,     0,   916,  2890,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1817,     0,     0,     0,   827,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1817,     0,     0,     0,     0,  1806,
       0,     0,  2890,     0,     0,     0,     0,  1817,   917,     0,
       0,     0,   918,     0,   919,     0,     0,     0,     0,  1816,
     920,     0,     0,   921,     0,  1144,     0,     0,     0,  1144,
       0,     0,     0,  1816,     0,     0,     0,     0,  1144,     0,
       0,     0,     0,     0,  1817,     0,  2890,     0,     0,   922,
       0,   923,     0,     0,     0,   924,     0,     0,     0,     0,
       0,     0,     0,   925,     0,     0,     0,     0,   926,     0,
       0,     0,     0,     0,  1144,  1808,     0,  2764,   927,     0,
       0,     0,     0,  1816,     0,     0,     0,     0,     0,     0,
     928,     0,     0,     0,     0,     0,     0,  1809,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1144,     0,     0,
    1817,     0,     0,     0,     0,     0,  1144,     0,     0,     0,
       0,     0,  1144,     0,  1144,     0,     0,     0,     0,  1817,
    1144,     0,  1806,  1144,  1144,  1144,  1144,  1144,  1144,  1144,
    1144,  1144,  1144,     0,     0,     0,  1144,  1144,     0,  1816,
       0,     0,     0,     0,  1817,     0,     0,     0,     0,  1144,
       0,     0,     0,   802,     0,  1144,     0,  1196,  1816,     0,
       0,     0,     0,  1140,     0,  1144,     0,     0,  1144,  1140,
    1144,     0,     0,     0,     0,     0,     0,     0,  1817,  1144,
    1144,  1144,     0,  1816,     0,  1144,     0,     0,  1144,  1197,
       0,     0,     0,     0,     0,     0,     0,     0,  1144,     0,
    1140,     0,  1198,     0,     0,     0,  1144,     0,  1144,     0,
    1199,     0,     0,     0,  1200,     0,     0,  1816,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     853,     0,     0,     0,  1201,     0,     0,     0,     0,     0,
       0,     0,   854,     0,  1806,     0,     0,  2764,     0,     0,
       0,     0,  1140,     0,     0,  1202,     0,     0,     0,  1140,
       0,     0,   855,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1144,  1806,
       0,     0,     0,   856,     0,     0,     0,  -632,  1203,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   857,     0,  1204,
     802,  1817,   802,   858,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1808,   859,     0,
       0,     0,     0,  1205,     0,   802,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1809,
    2890,     0,     0,     0,     0,     0,   860,     0,     0,     0,
       0,     0,     0,   861,  1808,     0,     0,   862,     0,  1140,
       0,     0,     0,     0,     0,  1008,     0,     0,     0,  1008,
       0,     0,  -792,     0,     0,     0,  1809,  1808,     0,  1206,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1806,     0,     0,  1140,     0,     0,     0,  1809,
       0,     0,     0,  1806,     0,  1144,   827,     0,   863,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1817,     0,     0,     0,     0,     0,     0,
    1207,     0,     0,     0,  1208,     0,  1209,     0,     0,  1808,
       0,     0,  1210,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   864,     0,     0,   865,  1808,     0,  1817,  1144,
    1144,  1809,  1816,     0,     0,     0,     0,     0,     0,     0,
       0,  1211,     0,  1212,  1808,     0,     0,  1213,  1809,     0,
       0,     0,     0,  1144,  1806,  1214,     0,     0,  1144,     0,
    1215,  1144,     0,     0,  1806,     0,  1809,  2316,     0,  1808,
       0,     0,     0,   866,     0,     0,     0,     0,     0,   867,
       0,     0,  1216,     0,     0,  -365,     0,     0,   868,     0,
       0,  1809,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1140,     0,  1144,     0,     0,     0,     0,
    1140,     0,     0,     0,  -365,     0,   869,   870,     0,   871,
     872,     0,     0,     0,  1808,     0,     0,     0,   873,     0,
       0,  1815,     0,   874,     0,     0,     0,     0,   875,     0,
       0,  1144,     0,   876,     0,     0,  1809,     0,  1144,  1144,
       0,  1817,     0,     0,     0,  -365,  1144,  1144,     0,     0,
    1140,  1144,  1817,     0,     0,     0,     0,  1144,  1144,     0,
       0,  1144,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1144,     0,     0,     0,     0,     0,     0,     0,
    1816,     0,     0,     0,  1144,     0,     0,     0,     0,     0,
       0,  1816,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2764,  1144,     0,     0,  1806,  1140,     0,     0,     0,
       0,     0,     0,  2764,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1817,     0,     0,     0,     0,     0,     0,
       0,  1806,     0,  1817,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1816,     0,     0,     0,  1815,     0,     0,     0,
       0,     0,  1816,     0,     0,     0,     0,     0,   802,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1140,     0,     0,  1808,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1806,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1809,     0,     0,
    1140,     0,     0,     0,     0,     0,  1144,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   802,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1140,  1140,     0,
    1140,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1140,     0,     0,
       0,     0,     0,     0,  1817,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1144,     0,     0,     0,  1144,
       0,     0,     0,     0,  1817,     0,  1806,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  4156,     0,     0,  1144,     0,  1140,     0,
    1817,     0,     0,     0,  1806,     0,     0,     0,     0,     0,
       0,     0,     0,  1816,     0,     0,     0,     0,     0,     0,
    1144,  1144,     0,     0,  1144,     0,     0,     0,     0,     0,
    1140,  1144,  1144,     0,  1140,  1140,     0,     0,     0,  1816,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1806,
       0,     0,     0,  1806,  1806,     0,     0,     0,  1144,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1817,     0,     0,  1144,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1815,     0,
       0,     0,     0,  1808,  2890,  1144,     0,  1008,  1808,  1808,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1808,
       0,     0,     0,     0,     0,  1809,     0,     0,  1008,     0,
    1809,  1809,     0,     0,     0,  1815,     0,     0,     0,     0,
       0,  1809,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1144,     0,  1817,     0,     0,  1815,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1144,  1817,     0,  1144,     0,  1144,     0,     0,
       0,     0,     0,     0,  2890,     0,     0,     0,     0,     0,
       0,     0,     0,  1008,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1811,     0,     0,     0,
    1815,     0,  1816,     0,     0,  1144,     0,     0,  1817,     0,
       0,     0,  1817,  1817,  1808,     0,     0,  1815,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1815,  1809,     0,   802,     0,
       0,     0,     0,     0,     0,  1144,     0,  1816,     0,     0,
       0,  1816,  1816,     0,     0,     0,     0,     0,     0,     0,
    1815,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1817,     0,     0,     0,  1808,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1144,     0,     0,     0,     0,     0,  1809,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1140,     0,  1140,
    4156,     0,     0,     0,     0,  1815,     0,     0,  1140,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1144,     0,     0,     0,     0,
       0,     0,  1144,     0,     0,     0,     0,     0,     0,     0,
       0,  1811,     0,     0,     0,     0,     0,     0,  1144,  1144,
       0,     0,     0,     0,     0,     0,     0,     0,  1144,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1808,     0,
       0,     0,     0,     0,     0,  1144,     0,     0,     0,     0,
       0,     0,     0,  1140,     0,  1144,     0,     0,     0,     0,
    1809,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1140,  1140,     0,     0,     0,     0,     0,     0,  1140,
       0,     0,  1140,     0,     0,  1140,     0,     0,     0,  1144,
       0,     0,     0,  1140,  1140,     0,     0,     0,  1144,     0,
       0,  1140,     0,     0,  1140,  1140,  1140,  1140,     0,     0,
       0,     0,     0,     0,  1140,  1140,     0,  1140,     0,  1140,
       0,     0,  1140,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1815,  1140,     0,     0,
       0,  1140,     0,     0,     0,  1140,     0,     0,     0,  1140,
       0,  1140,  1140,  1140,  1140,  1140,  1140,  1140,  1140,  1140,
       0,  1140,     0,     0,     0,     0,     0,  1140,     0,     0,
    1140,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1140,     0,     0,  1811,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1811,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1808,  1808,     0,  1808,     0,     0,     0,     0,     0,
       0,     0,     0,  1811,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1809,  1809,     0,  1809,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1808,     0,  1808,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1140,     0,     0,  1809,     0,  1809,
       0,     0,     0,     0,     0,  1811,     0,     0,     0,     0,
       0,     0,     0,     0,  1815,     0,     0,     0,     0,  1815,
    1815,     0,  1811,     0,     0,     0,     0,     0,     0,     0,
    1815,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1811,     0,     0,     0,     0,     0,  1808,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1811,     0,     0,  1809,     0,
       0,     0,     0,  1808,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1809,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1808,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1811,     0,     0,     0,  1808,     0,     0,     0,     0,  1809,
       0,     0,     0,     0,     0,     0,     0,     0,  1808,     0,
       0,     0,     0,  1140,     0,  1815,  1809,     0,     0,     0,
       0,  1808,     0,     0,     0,     0,     0,     0,     0,     0,
    1809,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1809,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1808,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1815,     0,     0,     0,
    1809,     0,     0,     0,     0,     0,     0,  1140,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1140,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1808,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1140,     0,     0,     0,     0,     0,
       0,     0,     0,  1808,     0,     0,  1809,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1809,     0,     0,  1808,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1140,     0,
       0,  1811,     0,     0,     0,     0,     0,     0,     0,  1815,
    1809,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1808,     0,     0,     0,     0,     0,  1140,  1140,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1809,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1140,  1140,
       0,     0,     0,  1140,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1140,  1140,  1140,  1140,     0,
       0,     0,     0,     0,     0,     0,     0,  1140,     0,     0,
    1140,     0,  1140,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1140,  1140,     0,  1140,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1140,     0,
    1140,     0,     0,     0,  1140,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1140,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1140,     0,  1140,  1140,  1140,  1808,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1140,  1809,     0,     0,
       0,     0,     0,     0,     0,  1140,     0,     0,     0,     0,
       0,     0,     0,     0,  1140,     0,     0,     0,     0,  1140,
       0,     0,     0,     0,     0,     0,  1140,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   698,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   698,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1811,
       0,     0,     0,     0,  1811,  1811,     0,     0,     0,     0,
       0,     0,     0,     0,  1140,  1811,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   698,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   891,  1808,     0,   698,
       0,     0,  1815,  1815,     0,  1815,   891,     0,     0,     0,
     698,     0,     0,     0,     0,     0,     0,     0,     0,  1809,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   698,  1808,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1815,   891,  1815,     0,
       0,     0,     0,     0,  1809,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1063,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1811,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1815,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1815,     0,     0,     0,     0,     0,
       0,  1811,     0,     0,     0,  1808,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1808,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1809,  1815,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1809,     0,
       0,     0,     0,     0,     0,  1815,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1815,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1815,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1140,     0,     0,     0,  1140,  1108,     0,  1808,     0,     0,
       0,     0,     0,  1140,     0,     0,     0,  1808,     0,  1815,
       0,     0,     0,     0,  1811,     0,     0,     0,     0,  1809,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1809,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1140,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1140,     0,     0,  1815,     0,     0,     0,     0,
       0,  1140,     0,     0,     0,     0,     0,  1140,     0,  1140,
       0,     0,     0,     0,  1815,  1140,     0,     0,  1140,  1140,
    1140,  1140,  1140,  1140,  1140,  1140,  1140,  1140,     0,     0,
       0,  1140,  1140,     0,     0,     0,     0,     0,     0,  1815,
       0,     0,     0,     0,  1140,     0,     0,     0,     0,     0,
    1140,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1140,     0,     0,  1140,     0,  1140,     0,     0,     0,     0,
       0,     0,     0,  1815,  1140,  1140,  1140,   681,     0,     0,
    1140,     0,   695,  1140,   695,     0,     0,     0,  1808,     0,
       0,     0,     0,  1140,   695,     0,     0,     0,     0,     0,
       0,  1140,     0,  1140,     0,     0,     0,     0,     0,     0,
    1809,     0,     0,     0,  1808,     0,     0,     0,     0,     0,
     695,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     695,     0,     0,     0,     0,     0,  1809,     0,     0,     0,
     695,   695,     0,     0,   695,     0,     0,     0,     0,     0,
       0,   695,     0,     0,     0,   970,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1140,     0,     0,   970,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1808,
       0,     0,   695,     0,     0,     0,     0,     0,   891,   891,
       0,     0,     0,     0,     0,     0,  1815,  1811,  1811,     0,
    1811,  1809,     0,     0,     0,  1108,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1811,     0,  1811,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1808,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1809,     0,     0,     0,     0,     0,  1808,     0,     0,
    1140,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1811,     0,     0,     0,     0,     0,  1815,  1809,
       0,     0,     0,  1812,     0,     0,     0,     0,     0,     0,
       0,     0,  1175,     0,  1177,     0,  1179,     0,  1181,  1811,
       0,     0,  1808,     0,     0,     0,  1808,  1808,     0,     0,
       0,     0,     0,  1815,  1140,  1140,     0,  1223,     0,     0,
       0,     0,     0,     0,  1809,     0,     0,     0,  1809,  1809,
       0,  1241,  1242,  1811,     0,     0,  1244,     0,  1140,     0,
     695,     0,     0,  1140,     0,     0,  1140,     0,     0,     0,
    1811,  1108,     0,   891,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1811,     0,     0,     0,     0,  1274,
       0,     0,     0,     0,     0,     0,     0,  1811,     0,     0,
       0,  1293,     0,     0,  1295,     0,  1297,     0,  1300,     0,
    1140,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   698,   891,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1811,     0,   698,     0,   698,     0,
       0,     0,     0,     0,     0,     0,  1140,     0,   698,     0,
       0,     0,     0,  1140,  1140,     0,  1815,     0,  1812,     0,
       0,  1140,  1140,     0,     0,     0,  1140,  1815,   698,   698,
       0,     0,  1140,  1140,     0,  1382,  1140,  1383,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1140,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1140,
    1811,     0,     0,     0,     0,     0,     0,  1108,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1811,
       0,     0,     0,     0,     0,     0,     0,  1140,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1063,  1811,     0,     0,     0,  1815,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1815,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1811,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   695,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1634,     0,  1636,     0,     0,     0,  1638,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   695,   695,     0,     0,     0,     0,     0,
       0,  1140,     0,     0,     0,     0,     0,     0,     0,     0,
     695,     0,     0,     0,     0,     0,     0,     0,     0,  1752,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1764,     0,     0,     0,     0,     0,     0,     0,
       0,  1770,     0,     0,     0,     0,     0,  1772,     0,  1815,
       0,     0,     0,     0,     0,     0,     0,     0,  1820,     0,
    1140,  1811,     0,     0,  1140,     0,     0,     0,     0,  1815,
    1812,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1857,     0,     0,
       0,  1140,     0,     0,     0,  1815,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1812,     0,     0,
       0,     0,     0,     0,     0,  1140,  1140,     0,     0,  1140,
       0,     0,     0,     0,     0,     0,  1140,  1140,     0,     0,
    1812,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1140,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   698,     0,   698,
    1815,     0,   698,  1140,   698,     0,     0,   698,   698,   698,
       0,     0,     0,  1811,     0,     0,     0,     0,     0,     0,
     698,     0,  1812,     0,     0,  1261,   695,     0,   695,     0,
       0,     0,     0,     0,   698,     0,   698,     0,     0,  1812,
    1140,     0,     0,     0,     0,     0,     0,     0,  1811,     0,
       0,     0,     0,     0,     0,     0,     0,  1812,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   695,     0,     0,   695,   695,     0,     0,
       0,     0,  1812,     0,     0,     0,     0,     0,  1140,   681,
    1815,   970,     0,   970,     0,     0,     0,     0,     0,   681,
       0,     0,     0,   695,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1140,  1815,     0,
    1140,     0,  1140,   970,   970,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1812,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1140,     0,   695,  1815,   695,     0,     0,  1815,  1815,     0,
       0,  1811,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1811,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1140,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1063,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1815,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   681,     0,
       0,     0,     0,     0,     0,     0,  1140,     0,     0,     0,
       0,     0,   681,   681,     0,     0,  1616,     0,     0,     0,
       0,     0,     0,  1811,     0,     0,     0,     0,     0,  2236,
       0,     0,  2236,  1811,     0,     0,     0,     0,     0,     0,
    2243,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1140,     0,     0,     0,     0,   681,     0,  1140,  2252,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1140,  1140,     0,     0,     0,     0,     0,
       0,     0,     0,  1140,  2290,     0,     4,     0,  1812,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     5,     0,     0,     0,
    1140,     0,     0,     0,     0,     0,     6,     7,     0,     0,
    1140,     0,     0,     0,     9,    10,     0,     0,    11,    12,
      13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
      23,    24,    25,    26,    27,    28,    29,    30,    31,    32,
      33,    34,    35,     0,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,     0,     0,     0,    45,     0,     0,
       0,     0,     0,     0,  1140,     0,     0,     0,     0,     0,
       0,     0,     0,  1140,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1811,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    46,     0,     0,     0,     0,     0,
    1811,     0,     0,     0,     0,     0,     0,   681,     0,     0,
       0,     0,   695,     0,   695,     0,     0,   695,     0,   695,
       0,     0,   695,   695,   695,     0,     0,  2451,  1956,     0,
       0,     0,     0,     0,     0,   695,     0,     0,     0,  2473,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   695,
       0,   695,     0,     0,     0,     0,   695,     0,     0,     0,
       0,     0,     0,     0,     0,     0,    47,     0,     0,     0,
       0,     0,     0,     0,     0,  1811,     0,     0,     0,     0,
       0,    48,     0,  2527,     0,     0,     0,  2531,     0,     0,
       0,     0,     0,     0,     0,     0,  2540,     0,  2542,     0,
    2543,    49,     0,  1813,     0,  2544,  1812,     0,     0,     0,
       0,  1812,  1812,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1812,    50,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   698,
       0,   698,     0,     0,     0,   698,     0,   698,     0,     0,
     698,     0,     0,     0,   698,  2572,    51,     0,     0,    52,
       0,     0,     0,     0,     0,  1811,     0,     0,     0,  2108,
       0,     0,     0,     0,     0,     0,     0,     0,   695,   695,
      53,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1811,     0,   681,     0,     0,     0,   681,
     681,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1812,  1811,     0,
       0,     0,  1811,  1811,     0,     0,     0,     0,     0,     0,
       0,    54,     0,     0,     0,     0,     0,     0,  1813,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   695,
       0,   681,     0,  1145,     0,     0,     0,     0,     0,  1145,
       0,  2240,     0,    55,     0,     0,     0,     0,  1812,     0,
       0,     0,     0,     0,     0,     0,    56,     0,     0,  2765,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    57,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   681,     0,     0,    58,     0,     0,   681,     0,     0,
      59,     0,     0,     0,    60,    61,    62,    63,    64,     0,
       0,    65,    66,  1308,  1912,     0,     0,     0,    71,     0,
       0,     0,  1145,     0,     0,     0,     0,     0,     0,  1145,
       0,     0,     0,     0,     0,     0,     0,     0,   681,     0,
       0,   681,   681,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1812,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   681,     0,     0,  1108,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2844,     0,     0,     0,     0,  2848,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2858,
       0,     0,     0,     0,     0,     0,  2864,     0,     0,  1145,
       0,     0,  2869,     0,     0,     0,     0,     0,  2879,     0,
       0,     0,     0,  2881,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1813,     0,     0,     0,     0,  1145,     0,     0,     0,  2897,
    2898,  2901,  2903,     0,     0,     0,  2910,  2913,     0,     0,
       0,  2916,     0,     0,  2920,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1813,     0,     0,
       0,  2955,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2958,     0,  2960,     0,     0,     0,     0,     0,     0,
    1813,     0,  2971,  2972,  2973,     0,  2975,     0,     0,     0,
       0,     0,     0,     0,     0,  2988,  2989,     0,     0,     0,
       0,     0,     0,  2992,  2993,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   695,     0,   695,     0,     0,     0,
     695,     0,   695,     0,     0,   695,     0,     0,     0,   695,
       0,     0,     0,     0,  2108,     0,     0,     0,     0,     0,
       0,     0,  1813,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1813,
       0,     0,     0,  1145,     0,     0,     0,     0,     0,     0,
    1145,     0,     0,     0,     0,     0,     0,  1813,  1476,     0,
       0,     0,     0,     0,  1812,  1812,     0,  1812,     0,     0,
       0,  1818,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1813,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1549,     0,     0,     0,     0,     0,
    1145,     0,     0,     0,     0,     0,     0,     0,  1812,     0,
    1812,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1813,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1108,  1956,     0,     0,
       0,     0,     0,     0,  2766,     0,  1145,     0,     0,     0,
       0,     0,     0,  2240,     0,     0,     0,     0,     0,  1812,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3193,     0,     0,     0,     0,  1812,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1818,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1812,     0,     0,     0,   681,     0,     0,     0,     0,     0,
       0,     0,  1145,     0,     0,     0,     0,  1812,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1812,     0,     0,     0,     0,     0,     0,     0,     0,
    1145,     0,     0,     0,  1812,     0,     0,   681,     0,     0,
       0,   681,     0,     0,     4,     0,     0,  2828,     0,  1616,
       0,     0,   695,     0,     0,     0,     0,  1145,  1145,     0,
    1145,     0,     0,     0,     5,     0,     0,     0,     0,     0,
       0,  1812,     0,     0,     6,     7,     0,  1145,  1813,     0,
       0,     0,     9,    10,     0,     0,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,     0,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,     0,     0,     0,    45,     0,     0,  1145,     0,
       0,     0,     0,     0,     0,     0,     0,  1812,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1812,     0,     0,     0,
    1145,     0,     0,     0,  1145,  1145,     0,     0,     0,   681,
       0,     0,    46,     0,  3374,  3375,     0,   681,     0,   681,
       0,  1812,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2010,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3394,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1812,     0,     0,     0,  2033,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1818,  3413,
    3414,  3415,  3416,     0,    47,     0,  2057,  2058,     0,  2060,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    48,
       0,     0,     0,     0,     0,     0,  2098,     0,     0,     0,
       0,     0,     0,     0,     0,  1818,     0,     0,     0,    49,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1818,     0,
       0,    50,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1813,  2152,     0,     0,
       0,  1813,  1813,  3457,     0,     0,     0,     0,  3459,     0,
       0,     0,  1813,     0,    51,     0,     0,    52,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1812,  2182,
       0,     0,     0,  2192,  2195,     0,     0,     0,    53,     0,
    1818,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1818,     0,     0,
       0,   695,  1956,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1818,     0,   681,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3557,   891,     0,     0,     0,     0,     0,     0,
    1818,     0,     0,     0,     0,     0,     0,     0,     0,    54,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1813,     0,   891,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1145,     0,  1145,
    1812,    55,     0,     0,     0,  1818,  3617,     0,  1145,     0,
       0,     0,     0,     0,    56,     0,     0,     0,     0,  3626,
       0,     0,     0,     0,     0,     0,     0,    57,     0,     0,
       0,     0,     0,     0,     0,  1812,     0,     0,  1813,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    58,     0,     0,     0,     0,     0,    59,     0,
       0,     0,    60,    61,    62,    63,    64,     0,     0,    65,
      66,  1308,  2553,     0,     0,     0,    71,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1145,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2240,     0,
       0,     0,     0,   681,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1145,  1145,     0,     0,     0,     0,     0,     0,  1145,
       0,     0,  1145,     0,     0,  1145,     0,     0,     0,     0,
       0,  1813,     0,  1145,  1145,     0,     0,     0,  1812,     0,
       0,  1145,     0,     0,  1145,  1145,  1145,  1145,     0,  1812,
       0,     0,     0,     0,  1145,  1145,     0,  1145,     0,  1145,
       0,     0,  1145,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1818,  1145,     0,     0,
       0,  1145,     0,     0,     0,  1145,     0,     0,     0,  1145,
       0,  1145,  1145,  1145,  1145,  1145,  1145,  1145,  1145,  1145,
       0,  1145,     0,     0,     0,     0,     0,  1145,     0,     0,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1812,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1812,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3792,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,  3818,
       0,     0,     0,     0,  3825,     0,  3827,  3828,  3829,  3830,
       0,     0,     0,     0,     0,     0,     0,     0,  2635,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2657,     0,     0,  2659,     0,     0,  2670,     0,     0,     0,
       0,     0,     0,  2677,  2682,   681,     0,     0,  2687,     0,
       0,  2692,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3889,  3891,  3893,     0,  3895,  2701,     0,     0,     0,
    2707,     0,     0,     0,  2719,     0,     0,     0,  2726,   681,
    2728,  2729,  2730,  2731,  2732,  2733,  2734,  2735,  2736,     0,
    2737,     0,     0,     0,  1145,     0,  1476,     0,   695,  2761,
       0,  1812,     0,     0,  1813,  1813,     0,  1813,     0,     0,
       0,     0,     0,     0,  1818,     0,     0,     0,     0,  1818,
    1818,     0,     0,     0,     0,     0,     0,  1812,     0,     0,
    1818,     0,     0,     0,   695,     0,  3394,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1813,     0,
    1813,     0,     0,     0,     0,     0,     0,  3964,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1549,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1812,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1813,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1145,     0,  1818,  1813,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1813,     0,     0,  2867,     0,     0,     0,     0,     0,     0,
       0,     0,  1812,     0,     0,     0,     0,  1813,     0,     0,
       0,     0,     0,     0,     0,     0,  1818,     0,     0,     0,
       0,  1813,     0,     0,     0,     0,     0,  1145,     0,     0,
    1812,     0,     0,     0,  1813,     0,     0,  1145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  4065,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4074,     0,     0,     0,     0,     0,     0,     0,
       0,  1813,     0,     0,  1145,  1812,     0,     0,     0,  1812,
    1812,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2828,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1145,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1818,
       0,     0,     0,     0,     0,     0,     0,  1813,     0,     0,
       0,     0,  3028,     0,     0,     0,     0,   681,  1145,  1145,
       0,     0,     0,     0,     0,     0,  1813,     0,     0,     0,
     681,     0,     0,  4127,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1145,  1145,
       0,  1813,     0,  1145,     0,  4146,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1145,  1145,  1145,  1145,     0,
       0,     0,     0,     0,     0,     0,   681,  1145,     0,     0,
    1145,     0,  1145,     0,     0,  1813,     0,     0,     0,     0,
       0,     0,  1145,  1145,  4175,  1145,  3139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1145,     0,
    1145,     0,     0,     0,  1145,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1145,     0,     0,  3160,     0,     0,     0,     0,     0,     0,
    1145,     0,  1145,  1145,  1145,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1145,     0,     0,     0,
       0,     0,     0,     0,     0,  1145,     0,  1476,     0,     0,
       0,     0,     0,     0,  1145,     0,     0,     0,     0,  1145,
       0,     0,     0,     0,     0,     0,  1145,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  3204,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1813,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   681,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1145,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2682,     0,  2682,  2682,     0,     0,
       0,     0,     0,     0,     0,     0,  3264,     0,     0,  3267,
       0,  3269,  1818,  1818,     0,  1818,     0,     0,     0,     0,
       0,     0,  3394,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  3290,     0,  3292,
       0,     0,     0,  3295,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  1818,     0,  1818,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  2761,  2761,  2761,     0,     0,     0,     0,     0,     0,
    1813,     0,     0,     0,  2240,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3342,     0,     0,     0,     0,
     681,     0,     0,     0,  1549,     0,     0,     0,     0,     0,
       0,     0,     0,  2182,     0,  1813,     0,     0,  3357,     0,
       0,     0,     0,     0,     0,  2195,   681,  1818,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1818,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3383,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1818,     0,
       0,     0,  2094,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1818,     0,     0,     0,     0,
       0,  4398,     0,     0,     0,     0,   681,     0,     0,  1818,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1818,     0,     0,     0,     0,     0,  1813,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1813,
    1145,     0,     0,     0,  1145,     0,     0,     0,     0,     0,
       0,     0,     0,  1145,     0,  2094,     0,     0,     0,  1818,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1145,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1813,     0,  1145,     0,     0,  1818,     0,     0,     0,     0,
    1813,  1145,     0,     0,     0,     0,     0,  1145,     0,  1145,
       0,     0,     0,     0,  1818,  1145,     0,     0,  1145,  1145,
    1145,  1145,  1145,  1145,  1145,  1145,  1145,  1145,     0,     0,
       0,  1145,  1145,     0,     0,     0,     0,     0,     0,  1818,
       0,     0,     0,     0,  1145,     0,     0,     0,     0,     0,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1145,   681,     0,  1145,     0,  1145,     0,     0,     0,     0,
       0,     0,     0,  1818,  1145,  1145,  1145,     0,     0,     0,
    1145,     0,     0,  1145,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1145,     0,     0,     0,     0,     0,     0,
       0,  1145,     0,  1145,     0,     0,     0,     0,     0,     0,
       0,     0,  2761,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1813,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1145,     0,     0,     0,     0,     0,     0,
       0,  3654,     0,     0,     0,     0,     0,  1813,     0,     0,
    3657,     0,     0,     0,     0,     0,  3658,     0,  3659,     0,
       0,     0,     0,     0,     0,     0,  1818,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    3677,  3678,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2687,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3703,
       0,     0,  3706,     0,  3708,     0,     0,     0,     0,     0,
       0,     0,  1813,  3712,     0,     0,     0,     0,     0,  3717,
       0,     0,  3720,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3727,     0,     0,     0,     0,     0,     0,     0,
    3739,   681,  2761,     0,  2094,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1818,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  1813,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1818,  1145,  1145,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1813,     0,     0,     0,     0,     0,  2094,     0,  1145,     0,
       0,     0,     0,  1145,     0,     0,  1145,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2094,
       0,     0,     0,     0,  2666,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1813,     0,     0,     0,  1813,
    1813,     0,     0,  2094,  2094,     0,  2094,     0,     0,     0,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2094,     0,  1145,     0,     0,     0,
       0,     0,     0,  1145,  1145,     0,  1818,     0,     0,     0,
       0,  1145,  1145,     0,     0,     0,  1145,  1818,     0,     0,
       0,     0,  1145,  1145,     0,     0,  1145,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2094,  1145,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  3939,  3940,     0,     0,  1145,  2094,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2094,     0,
       0,  2094,     0,     0,     0,     0,     0,     0,  1818,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  1818,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  3980,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  3996,  3998,     0,     0,     0,     0,     0,     0,
       0,  1145,     0,     0,     0,  4005,     0,     0,     0,     0,
       0,  4010,  4011,     0,     0,  4013,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2761,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2761,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  1818,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1145,     0,     0,     0,  1145,     0,  4044,     0,     0,  1818,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  1145,     0,     0,     0,  1818,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  1145,  1145,     0,     0,  1145,
       0,     0,     0,     0,     0,     0,  1145,  1145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  1145,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1818,     0,     0,  1145,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    4115,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4165,
       0,     0,     0,     0,     0,     0,     0,     0,  1145,     0,
    1818,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  1145,  1818,     0,
    1145,     0,  1145,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  4195,     0,
       0,     0,     0,     0,     0,     0,  4197,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1145,  2094,     0,  1818,     0,     0,     0,  1818,  1818,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,  2094,     0,  2094,     0,  2666,  2666,  3240,
       0,     0,  2666,     0,     0,     0,  2094,     0,     0,     0,
    1145,     0,     0,  2094,     0,     0,     0,     0,  2094,     0,
       0,     0,     0,  2094,     0,     0,     0,     0,  2094,     0,
       0,     0,     0,     0,     0,     0,  1818,  2094,     0,     0,
       0,  2666,  2666,  2094,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2094,  1145,     0,     0,     0,
       0,     0,  2094,     0,  2094,  2094,  2094,  2094,  2094,  2094,
    2094,  2094,  2094,  2094,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,  2094,     0,     0,
    1145,     0,     0,     0,     0,     0,     0,  1145,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2687,
       0,     0,     0,  1145,  1145,     0,     0,     0,     0,     0,
       0,     0,     0,  1145,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4323,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    1145,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4352,
       0,     0,     0,  2094,     0,     0,     0,     4,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  1145,     0,     0,     5,     0,     0,
       0,     0,     0,  1145,     0,     0,     0,     6,     7,     0,
       0,     0,     0,     0,     0,     9,    10,     0,     0,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    34,    35,     0,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,     0,     0,     0,    45,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  4416,  4416,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    46,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4416,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  4456,
       0,     0,     0,     0,  2094,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    47,     0,     0,
       0,     0,     0,  4416,     0,     0,     0,     0,     0,     0,
       0,     0,    48,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    49,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    50,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2094,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,  2094,    51,     0,     0,
      52,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    53,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2094,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,  3240,  3240,     0,  2666,     0,     0,  2666,  2666,  2666,
    2666,  2666,  2666,  2666,  2666,  2666,  2666,  3240,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    54,     0,     0,     0,     0,     0,     0,     0,
    2094,     0,     0,  2094,     0,  2094,     0,     0,     0,     0,
    3240,  3240,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,  2666,  2666,  2094,     0,  2094,     0,
       0,  2094,     0,     0,    55,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    56,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
      57,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2094,     0,
       0,     0,     0,     0,     0,    58,     0,     0,     0,     0,
       0,    59,     0,  2094,     0,    60,    61,    62,    63,    64,
       0,     0,    65,    66,  1308,     0,     0,     0,     0,    71,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2094,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2666,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
    2094,     0,     0,  2094,  2094,  2094,     0,     0,  3240,     0,
       0,     0,     0,  3240,  3240,  3240,  3240,  3240,  3240,  3240,
    3240,  3240,  3240,  2094,  2094,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,  2094,
    2666,  2666,  2094,     0,  2094,     0,     0,     0,  2094,  3240,
    3240,     0,     0,  2094,     0,     0,  2094,     0,     0,     0,
       0,     0,     0,  2094,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2094,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    86,
      87,    88,     0,    90,    91,    92,     0,     0,     0,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,     0,     0,     0,   107,   108,   109,   110,     0,   111,
     112,   113,   114,   115,     0,   116,   117,   118,     0,     0,
       0,     0,     0,   121,   122,     0,     0,     0,     0,   123,
       0,     0,     0,     0,     0,     0,     0,     0,   124,     0,
     125,     0,   126,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,  3240,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   133,     0,     0,
       0,   135,   136,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  2094,  2094,   140,     0,     0,
       0,     0,     0,     0,   144,     0,     0,     0,     0,     0,
       0,   147,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   150,     0,     0,     0,     0,
       0,   151,     0,     0,     0,     0,  2094,     0,     0,     0,
    2666,   154,   155,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2094,     0,  2094,     0,     0,     0,     0,  3240,
    3240,  2094,     0,     0,  2666,  2666,  2094,  2094,   162,  2094,
       0,     0,     0,     0,     0,   164,     0,     0,   166,     0,
       0,     0,     0,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   172,     0,     0,
    2094,     0,     0,     0,     0,     0,   173,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   174,
     175,     0,     0,     0,     0,     0,   177,     0,   178,     0,
       0,   179,   180,     0,   181,     0,     0,     0,     0,     0,
       0,     0,   182,   183,     0,   184,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
       0,  2094,     0,     0,     0,   192,     0,     0,     0,     0,
     194,     0,     0,   195,     0,   196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   197,   198,
     199,   200,   201,     0,     0,     0,     0,     0,     0,     0,
       0,   202,     0,   203,     0,     0,     0,     0,     0,     0,
       0,  2094,     0,     0,     0,   205,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3240,  2666,     0,     0,     0,
       0,     0,     0,   211,     0,     0,   213,     0,     0,  3240,
    3240,  2094,     0,  2094,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   217,     0,     0,   219,     0,   220,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     222,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   224,   225,     0,     0,     0,   226,     0,
     227,     0,     0,     0,     0,     0,     0,     0,   230,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   235,     0,     0,   236,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   238,   239,
     240,   241,   242,   243,   244,   245,     0,     0,     0,     0,
       0,     0,     0,     0,     0,  3240,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,  2818,     0,     0,     0,     0,     0,     0,  2094,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,  2094,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   704,    86,
      87,    88,   403,    90,    91,    92,   404,     0,   405,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   705,   104,
     105,   406,   706,     0,   107,   108,   109,   110,   707,   708,
     112,   113,   114,   115,     0,   116,   709,   710,   407,   408,
       0,     0,  2094,   409,   410,     0,     0,     0,     0,   411,
       0,     0,     0,     0,     0,     0,     0,     0,   412,     0,
     413,     0,   414,   415,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,  2094,     0,   417,   418,   419,   420,   421,   422,
     423,   424,   711,   425,   426,   427,   712,   713,   714,   715,
     716,   717,   718,   428,   429,   719,   430,   133,   431,   432,
     433,   135,   136,   137,   138,   139,   720,   434,   435,   436,
     437,   438,   721,   722,   439,   440,   723,   140,   442,   724,
     443,   444,   445,   446,   144,   725,   726,   447,   448,   449,
     450,   147,   451,   727,   728,   453,   454,   455,   456,   457,
     458,   729,   459,   460,   461,   150,   462,   730,   731,   732,
     733,   151,   734,   735,   736,   463,   464,   465,   466,   467,
     468,   154,   155,   469,   737,   470,   738,   471,   472,   473,
     474,   475,   739,   476,   477,   478,   740,   741,   479,   480,
     481,   482,   483,   742,   484,   485,   486,   743,   487,   488,
     744,   489,   490,   491,   492,   164,   493,   494,   166,   745,
     495,   746,   496,   168,   497,   747,   498,   748,   499,   169,
     749,   170,   500,   501,   502,   750,   503,   172,   751,   504,
     752,   505,   506,   507,   508,   509,   173,   510,   511,   512,
     753,   513,   514,   515,   516,   517,   518,   754,   519,   174,
     175,   755,   520,   521,   522,   756,   177,   757,   178,   758,
     523,   179,   180,   524,   181,   525,   526,   527,   528,   529,
     530,   759,   182,   183,   531,   184,   760,   532,   533,   534,
     761,   762,   535,   536,   537,   538,   539,   540,   541,   542,
     543,   544,   545,   546,   547,   189,   190,   191,   548,   549,
     550,   551,   552,   553,   554,   192,   555,   763,   556,   557,
     194,   558,   764,   195,   559,   196,   560,   561,   765,   766,
     562,   767,   768,   563,   564,   565,   769,   770,   197,   198,
     199,   200,   201,   566,   567,   568,   569,   570,   571,   771,
     572,   202,   573,   203,   574,   575,   576,   772,   577,   578,
     579,   580,   581,   582,   583,   205,   584,   585,   586,   773,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
     774,   597,   598,   211,   599,   600,   213,   601,   602,   603,
     604,   605,   606,   607,   608,   775,   609,   610,   611,   612,
     613,   776,   614,   217,   615,   616,   219,   617,   220,   777,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,   628,   778,   629,   630,   779,   631,   632,   633,   634,
     635,   636,   780,   224,   225,   781,   782,   638,   226,   639,
     227,   783,   640,   641,   642,   643,   644,   645,   784,   785,
     646,   647,   648,   649,   786,   787,   650,   651,   652,   653,
     788,   235,   789,   655,   236,   656,   657,   658,   790,   791,
     659,   792,   793,   660,   661,   662,   663,   664,   238,   239,
     240,   241,   242,   243,   244,   245,   665,   666,   667,    85,
       0,     0,    86,    87,    88,    89,    90,    91,    92,    93,
       0,    94,    95,    96,    97,    98,    99,   100,   101,   102,
     103,   932,   104,   105,   106,     0,     0,   107,   108,   109,
     110,     0,   111,   112,   113,   114,   115,     0,   116,   117,
     118,   119,   120,     0,     0,     0,   121,   122,     0,     0,
       0,     0,   123,     0,     0,     0,     0,     0,     0,     0,
       0,   124,     0,   125,     0,   126,   127,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   128,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   129,     0,   130,
     131,     0,     0,     0,     0,     0,     0,     0,     0,   132,
     133,     0,     0,   134,   135,   136,   137,   138,   139,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     140,     0,     0,   141,     0,   142,   143,   144,     0,     0,
     145,     0,   146,     0,   147,     0,     0,     0,     0,     0,
       0,     0,   148,     0,   149,     0,     0,     0,   150,     0,
       0,     0,     0,     0,   151,     0,     0,     0,     0,     0,
       0,   152,     0,   153,   154,   155,   156,     0,     0,     0,
       0,     0,   157,     0,     0,     0,     0,     0,   158,     0,
     159,     0,     0,     0,   160,     0,     0,     0,     0,     0,
     161,   162,     0,     0,     0,     0,     0,   163,   164,   165,
       0,   166,     0,     0,   167,     0,   168,     0,     0,     0,
       0,     0,   169,     0,   170,     0,     0,     0,   171,     0,
     172,     0,     0,     0,     0,     0,     0,     0,     0,   173,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   174,   175,     0,     0,   176,     0,     0,   177,
       0,   178,     0,     0,   179,   180,     0,   181,     0,     0,
       0,     0,     0,     0,     0,   182,   183,     0,   184,     0,
     185,   186,     0,     0,     0,     0,   187,     0,     0,     0,
       0,     0,     0,     0,     0,   188,     0,     0,   189,   190,
     191,     0,     0,     0,     0,     0,     0,     0,   192,     0,
       0,     0,   193,   194,     0,     0,   195,     0,   196,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   197,   198,   199,   200,   201,     0,     0,     0,     0,
       0,     0,     0,     0,   202,     0,   203,     0,   204,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   205,   206,
       0,     0,     0,   207,     0,   208,     0,     0,     0,     0,
     209,     0,     0,     0,     0,   210,   211,     0,   212,   213,
       0,     0,   214,     0,     0,     0,     0,     0,   215,     0,
       0,     0,     0,     0,     0,   216,   217,     0,   218,   219,
       0,   220,     0,     0,     0,   221,     0,     0,     0,     0,
       0,     0,     0,   222,     0,     0,     0,     0,   223,     0,
       0,     0,     0,     0,     0,     0,   224,   225,     0,     0,
       0,   226,     0,   227,     0,   228,     0,   229,     0,     0,
       0,   230,     0,     0,   231,     0,   232,     0,     0,   233,
       0,     0,     0,   234,   235,     0,     0,   236,     0,     0,
       0,     0,     0,     0,     0,   237,     0,     0,     0,     0,
       0,   238,   239,   240,   241,   242,   243,   244,   245,    86,
      87,    88,     0,    90,    91,    92,     0,     0,     0,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   246,   104,
     105,     0,  -124,     0,   107,   108,   109,   110,     0,   111,
     112,   113,   114,   115,     0,   116,   117,   118,     0,     0,
       0,     0,     0,   121,   122,     0,     0,     0,     0,   123,
       0,     0,     0,     0,     0,     0,     0,     0,   124,     0,
     125,     0,   126,     0,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   133,     0,     0,
       0,   135,   136,   137,   138,   139,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   140,     0,     0,
       0,     0,     0,     0,   144,     0,     0,     0,     0,     0,
       0,   147,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   150,     0,     0,     0,     0,
       0,   151,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   154,   155,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   162,     0,
       0,     0,     0,     0,     0,   164,     0,     0,   166,     0,
       0,     0,     0,   168,     0,     0,     0,     0,     0,   169,
       0,   170,     0,     0,     0,     0,     0,   172,     0,     0,
       0,     0,     0,     0,     0,     0,   173,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   174,
     175,     0,     0,     0,     0,     0,   177,     0,   178,     0,
       0,   179,   180,     0,   181,     0,     0,     0,     0,     0,
       0,     0,   182,   183,     0,   184,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   189,   190,   191,     0,     0,
       0,     0,     0,     0,     0,   192,     0,     0,     0,     0,
     194,     0,     0,   195,     0,   196,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   197,   198,
     199,   200,   201,     0,     0,     0,     0,     0,     0,     0,
       0,   202,     0,   203,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   205,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   211,     0,     0,   213,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   217,     0,     0,   219,     0,   220,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     222,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   224,   225,     0,     0,     0,   226,     0,
     227,     0,     0,     0,     0,     0,     0,     0,   230,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   235,     0,     0,   236,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   238,   239,
     240,   241,   242,   243,   244,   245,     0,   704,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   705,   104,   105,
     406,   706,  2820,   107,   108,   109,   110,   707,   708,   112,
     113,   114,   115,     0,   116,   709,   710,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1397,  1398,  1399,    45,  1400,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,  2755,   425,   426,   427,     0,     0,     0,     0,  1401,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
     135,  1402,   137,  1403,  1404,     0,   434,   435,   436,   437,
     438,  1405,  1406,   439,   440,  1407,  1408,   442,     0,   443,
     444,   445,   446,  1409,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,  1410,  1411,  1412,
    1413,  1414,  1415,  1416,   463,   464,   465,   466,   467,   468,
    1417,  1418,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,  2756,     0,   479,   480,  1419,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,  1420,   493,   494,  1421,  1422,   495,
       0,   496,  1423,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1424,     0,   504,     0,
     505,   506,   507,   508,   509,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,  1425,  1426,     0,  1427,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,  1428,   183,   531,   184,     0,   532,   533,   534,  1429,
    1430,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,  1431,   190,  1432,   548,   549,   550,
     551,   552,   553,   554,   192,   555,  1433,   556,   557,   194,
     558,  1434,  1435,   559,  1436,   560,   561,     0,     0,   562,
       0,     0,  1437,   564,   565,     0,     0,   197,   198,   199,
     200,  1438,   566,   567,   568,   569,   570,   571,     0,   572,
    1439,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,  1440,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   211,   599,   600,  1441,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
    1442,   614,   217,   615,   616,   219,   617,  1443,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1444,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,  1445,  1446,     0,     0,   638,  1447,   639,  1448,
    1449,   640,   641,   642,   643,   644,   645,     0,  1450,   646,
     647,   648,   649,  1451,     0,   650,   651,   652,   653,   654,
    1452,  2757,   655,   236,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,  1453,  1454,
    1455,  1456,  1457,  1458,  1459,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,  1460,  1461,  2758,     0,     0,
       0,     0,     0,     0,  1463,  2759,   704,    86,    87,    88,
     403,    90,    91,    92,   404,     0,   405,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   705,   104,   105,   406,
     706,     0,   107,   108,   109,   110,   707,   708,   112,   113,
     114,   115,     0,   116,   709,   710,   407,   408,     0,     0,
       0,   409,   410,     0,     0,     0,     0,   411,     0,     0,
       0,     0,     0,     0,     0,     0,   412,     0,   413,     0,
     414,   415,    35,   416,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,  1397,  1398,  1399,    45,  1400,     0,
       0,     0,   417,   418,   419,   420,   421,   422,   423,   424,
       0,   425,   426,   427,     0,     0,     0,     0,  1401,     0,
       0,   428,   429,     0,   430,   133,   431,   432,   433,   135,
    1402,   137,  1403,  1404,     0,   434,   435,   436,   437,   438,
    1405,  1406,   439,   440,  1407,  1408,   442,     0,   443,   444,
     445,   446,  1409,     0,     0,   447,   448,   449,   450,   147,
     451,   452,     0,   453,   454,   455,   456,   457,   458,     0,
     459,   460,   461,   150,   462,     0,  1410,  1411,  1412,  1413,
    1414,  1415,  1416,   463,   464,   465,   466,   467,   468,  1417,
    1418,   469,     0,   470,     0,   471,   472,   473,   474,   475,
       0,   476,   477,   478,     0,     0,   479,   480,  1419,   482,
     483,     0,   484,   485,   486,     0,   487,   488,     0,   489,
     490,   491,   492,  1420,   493,   494,  1421,  1422,   495,     0,
     496,  1423,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,  1424,     0,   504,     0,   505,
     506,   507,   508,   509,   173,   510,   511,   512,     0,   513,
     514,   515,   516,   517,   518,     0,   519,   174,   175,     0,
     520,   521,   522,  1425,  1426,     0,  1427,     0,   523,   179,
     180,   524,   181,   525,   526,   527,   528,   529,   530,     0,
    1428,   183,   531,   184,     0,   532,   533,   534,  1429,  1430,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,  1431,   190,  1432,   548,   549,   550,   551,
     552,   553,   554,   192,   555,  1433,   556,   557,   194,   558,
    1434,  1435,   559,  1436,   560,   561,     0,     0,   562,     0,
       0,  1437,   564,   565,     0,     0,   197,   198,   199,   200,
    1438,   566,   567,   568,   569,   570,   571,     0,   572,  1439,
     573,   203,   574,   575,   576,     0,   577,   578,   579,   580,
     581,   582,   583,  1440,   584,   585,   586,     0,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,   211,   599,   600,  1441,   601,   602,   603,   604,   605,
     606,   607,   608,     0,   609,   610,   611,   612,   613,  1442,
     614,   217,   615,   616,   219,   617,  1443,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,  1444,   628,
       0,   629,   630,     0,   631,   632,   633,   634,   635,   636,
       0,  1445,  1446,     0,     0,   638,  1447,   639,  1448,  1449,
     640,   641,   642,   643,   644,   645,     0,  1450,   646,   647,
     648,   649,  1451,     0,   650,   651,   652,   653,   654,  1452,
       0,   655,   236,   656,   657,   658,     0,     0,   659,     0,
       0,   660,   661,   662,   663,   664,   238,  1453,  1454,  1455,
    1456,  1457,  1458,  1459,   665,   666,   667,     0,     0,     0,
       0,     0,     0,     0,  1460,  1461,     0,     0,     0,     0,
       0,     0,     0,  1463,  2668,   704,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   705,   104,   105,   406,   706,
       0,   107,   108,   109,   110,   707,   708,   112,   113,   114,
     115,     0,   116,   709,   710,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,     0,  1784,
     137,  1785,  1786,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,  1787,  1788,   442,     0,   443,   444,   445,
     446,     0,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,     0,     0,     0,   151,     0,
       0,     0,   463,   464,   465,   466,   467,   468,  1789,  1790,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,  1419,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,     0,   493,   494,     0,     0,   495,     0,   496,
    1791,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,     0,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,  2304,   513,   514,
     515,   516,   517,   518,     0,   519,   174,  2305,     0,   520,
     521,   522,  1425,  1792,     0,  1793,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,     0,
     183,   531,   184,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,  1794,   190,  1795,   548,   549,   550,   551,   552,
     553,   554,     0,   555,     0,   556,   557,   194,   558,     0,
       0,   559,  1796,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,  2306,   198,   199,   200,     0,
     566,   567,   568,   569,   570,   571,     0,   572,     0,   573,
       0,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,  1797,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     211,   599,   600,     0,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
    2307,   615,   616,   219,   617,  1799,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,     0,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1800,  1801,     0,     0,   638,     0,   639,     0,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,     0,  1802,  2308,
     655,   236,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,     0,     0,     0,     0,     0,
       0,     0,     0,   665,   666,   667,     0,     0,     0,     0,
     704,    86,    87,    88,   403,    90,    91,    92,   404,     0,
     405,    95,     0,  2309,    98,    99,   100,   101,   102,   103,
     705,   104,   105,   406,   706,     0,   107,   108,   109,   110,
     707,   708,   112,   113,   114,   115,     0,   116,   709,   710,
     407,   408,     0,     0,     0,   409,   410,     0,     0,     0,
       0,   411,     0,     0,     0,     0,     0,     0,     0,     0,
     412,     0,   413,     0,   414,   415,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   417,   418,   419,   420,
     421,   422,   423,   424,     0,   425,   426,   427,     0,     0,
       0,     0,     0,     0,     0,   428,   429,     0,   430,   133,
     431,   432,   433,     0,  1784,   137,  1785,  1786,     0,   434,
     435,   436,   437,   438,     0,     0,   439,   440,  1787,  1788,
     442,     0,   443,   444,   445,   446,     0,     0,     0,   447,
     448,   449,   450,   147,   451,   452,     0,   453,   454,   455,
     456,   457,   458,     0,   459,   460,   461,   150,   462,     0,
       0,     0,     0,   151,     0,     0,     0,   463,   464,   465,
     466,   467,   468,  1789,  1790,   469,     0,   470,     0,   471,
     472,   473,   474,   475,     0,   476,   477,   478,     0,     0,
     479,   480,  1419,   482,   483,     0,   484,   485,   486,     0,
     487,   488,     0,   489,   490,   491,   492,     0,   493,   494,
       0,     0,   495,     0,   496,  1791,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,     0,
       0,   504,     0,   505,   506,   507,   508,   509,   173,   510,
     511,   512,  2304,   513,   514,   515,   516,   517,   518,     0,
     519,   174,  2305,     0,   520,   521,   522,  1425,  1792,     0,
    1793,     0,   523,   179,   180,   524,   181,   525,   526,   527,
     528,   529,   530,     0,     0,   183,   531,   184,     0,   532,
     533,   534,     0,     0,   535,   536,   537,   538,   539,   540,
     541,   542,   543,   544,   545,   546,   547,  1794,   190,  1795,
     548,   549,   550,   551,   552,   553,   554,     0,   555,     0,
     556,   557,   194,   558,     0,     0,   559,  1796,   560,   561,
       0,     0,   562,     0,     0,   563,   564,   565,     0,     0,
    2306,   198,   199,   200,     0,   566,   567,   568,   569,   570,
     571,     0,   572,     0,   573,     0,   574,   575,   576,     0,
     577,   578,   579,   580,   581,   582,   583,  1797,   584,   585,
     586,     0,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,   211,   599,   600,     0,   601,
     602,   603,   604,   605,   606,   607,   608,     0,   609,   610,
     611,   612,   613,     0,   614,  2307,   615,   616,   219,   617,
    1799,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,     0,   628,     0,   629,   630,     0,   631,   632,
     633,   634,   635,   636,     0,  1800,  1801,     0,     0,   638,
       0,   639,     0,     0,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,     0,  1802,  2308,   655,   236,   656,   657,   658,
       0,     0,   659,     0,     0,   660,   661,   662,   663,   664,
       0,     0,     0,     0,     0,     0,     0,     0,   665,   666,
     667,     0,     0,     0,     0,     0,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,  3099,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,  4048,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,     0,     0,     0,     0,
       0,   704,    86,    87,    88,   403,    90,    91,    92,   404,
    1531,   405,    95,     0,  1532,    98,    99,   100,   101,   102,
     103,   705,   104,   105,   406,   706,     0,   107,   108,   109,
     110,   707,   708,   112,   113,   114,   115,     0,   116,   709,
     710,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1397,
    1398,  1399,    45,  1400,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,  1401,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433,   135,  1402,   137,  1403,  1404,  2678,
     434,   435,   436,   437,   438,  1405,  1406,   439,   440,  1407,
    1408,   442,     0,   443,   444,   445,   446,  1409,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
       0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,   463,   464,
     465,   466,   467,   468,  1417,  1418,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,  1419,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,  1420,   493,
     494,  1421,  1422,   495,     0,   496,  1423,   497,     0,   498,
       0,   499,   169,  2679,   170,   500,   501,   502,     0,   503,
    1424,     0,   504,     0,   505,   506,   507,   508,   509,   173,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,   175,     0,   520,   521,   522,  1425,  1426,
       0,  1427,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,  2680,  1428,   183,   531,   184,     0,
     532,   533,   534,  1429,  1430,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,  1431,   190,
    1432,   548,   549,   550,   551,   552,   553,   554,   192,   555,
    1433,   556,   557,   194,   558,  1434,  1435,   559,  1436,   560,
     561,     0,     0,   562,     0,     0,  1437,   564,   565,     0,
       0,   197,   198,   199,   200,  1438,   566,   567,   568,   569,
     570,   571,     0,   572,  1439,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,  1440,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   211,   599,   600,  1441,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,  1442,   614,   217,   615,   616,   219,
     617,  1443,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,  1444,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,  1445,  1446,     0,  2681,
     638,  1447,   639,  1448,  1449,   640,   641,   642,   643,   644,
     645,     0,  1450,   646,   647,   648,   649,  1451,     0,   650,
     651,   652,   653,   654,  1452,     0,   655,   236,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,  1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,
     666,   667,     0,     0,     0,     0,     0,     0,     0,  1460,
    1461,     0,     0,     0,     0,     0,     0,     0,  1463,   704,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   705,
     104,   105,   406,   706,     0,   107,   108,   109,   110,   707,
     708,   112,   113,   114,   115,     0,   116,   709,   710,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,   416,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1397,  1398,  1399,
      45,  1400,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,  1401,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,   135,  1402,   137,  1403,  1404,     0,   434,   435,
     436,   437,   438,  1405,  1406,   439,   440,  1407,  1408,   442,
       0,   443,   444,   445,   446,  1409,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,     0,  1410,
    1411,  1412,  1413,  1414,  1415,  1416,   463,   464,   465,   466,
     467,   468,  1417,  1418,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,  1419,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,  1420,   493,   494,  1421,
    1422,   495,     0,   496,  1423,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1424,     0,
     504,     0,   505,   506,   507,   508,   509,   173,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,   175,     0,   520,   521,   522,  1425,  1426,     0,  1427,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,  1428,   183,   531,   184,     0,   532,   533,
     534,  1429,  1430,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,  1431,   190,  1432,   548,
     549,   550,   551,   552,   553,   554,   192,   555,  1433,   556,
     557,   194,   558,  1434,  1435,   559,  1436,   560,   561,     0,
       0,   562,     0,     0,  1437,   564,   565,     0,     0,   197,
     198,   199,   200,  1438,   566,   567,   568,   569,   570,   571,
       0,   572,  1439,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,  1440,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   211,   599,   600,  1441,   601,   602,
     603,   604,   605,   606,   607,   608,   215,   609,   610,   611,
     612,   613,  1442,   614,   217,   615,   616,   219,   617,  1443,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1444,   628,     0,   629,   630,   223,   631,   632,   633,
     634,   635,   636,     0,  1445,  1446,     0,     0,   638,  1447,
     639,  1448,  1449,   640,   641,   642,   643,   644,   645,     0,
    1450,   646,   647,   648,   649,  1451,     0,   650,   651,   652,
     653,  1324,  1452,     0,   655,   236,   656,   657,   658,     0,
       0,   659,     0,   237,   660,   661,   662,   663,   664,   238,
    1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,   666,   667,
       0,     0,     0,     0,     0,     0,     0,  1460,  1461,     0,
       0,     0,     0,     0,     0,     0,  1463,   704,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   705,   104,   105,
     406,   706,     0,   107,   108,   109,   110,   707,   708,   112,
     113,   114,   115,     0,   116,   709,   710,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1397,  1398,  1399,    45,  1400,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,  1401,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
     135,  1402,   137,  1403,  1404,     0,   434,   435,   436,   437,
     438,  1405,  1406,   439,   440,  1407,  1408,   442,     0,   443,
     444,   445,   446,  1409,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,  1410,  1411,  1412,
    1413,  1414,  1415,  1416,   463,   464,   465,   466,   467,   468,
    1417,  1418,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,  1419,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,  1420,   493,   494,  1421,  1422,   495,
       0,   496,  1423,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1424,     0,   504,     0,
     505,   506,   507,   508,   509,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,  1425,  1426,     0,  1427,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,  1428,   183,   531,   184,     0,   532,   533,   534,  1429,
    1430,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,  1431,   190,  1432,   548,   549,   550,
     551,   552,   553,   554,   192,   555,  1433,   556,   557,   194,
     558,  1434,  1435,   559,  1436,   560,   561,     0,     0,   562,
       0,     0,  1437,   564,   565,     0,     0,   197,   198,   199,
     200,  1438,   566,   567,   568,   569,   570,   571,     0,   572,
    1439,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,  1440,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   211,   599,   600,  1441,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
    1442,   614,   217,   615,   616,   219,   617,  1443,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1444,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,  1445,  1446,     0,     0,   638,  1447,   639,  1448,
    1449,   640,   641,   642,   643,   644,   645,     0,  1450,   646,
     647,   648,   649,  1451,     0,   650,   651,   652,   653,   654,
    1452,     0,   655,   236,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,  1453,  1454,
    1455,  1456,  1457,  1458,  1459,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,  1460,  1461,     0,     0,     0,
       0,     0,  2005,  2627,  1463,   704,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   705,   104,   105,   406,   706,
       0,   107,   108,   109,   110,   707,   708,   112,   113,   114,
     115,     0,   116,   709,   710,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1397,  1398,  1399,    45,  1400,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,  1401,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,   135,  1402,
     137,  1403,  1404,     0,   434,   435,   436,   437,   438,  1405,
    1406,   439,   440,  1407,  1408,   442,     0,   443,   444,   445,
     446,  1409,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,  1410,  1411,  1412,  1413,  1414,
    1415,  1416,   463,   464,   465,   466,   467,   468,  1417,  1418,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,  1419,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,  1420,   493,   494,  1421,  1422,   495,     0,   496,
    1423,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1424,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,   175,     0,   520,
     521,   522,  1425,  1426,     0,  1427,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,  1428,
     183,   531,   184,     0,   532,   533,   534,  1429,  1430,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,  1431,   190,  1432,   548,   549,   550,   551,   552,
     553,   554,   192,   555,  1433,   556,   557,   194,   558,  1434,
    1435,   559,  1436,   560,   561,     0,     0,   562,     0,     0,
    1437,   564,   565,     0,     0,   197,   198,   199,   200,  1438,
     566,   567,   568,   569,   570,   571,     0,   572,  1439,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,  1440,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     211,   599,   600,  1441,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,  1442,   614,
     217,   615,   616,   219,   617,  1443,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1444,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1445,  1446,     0,     0,   638,  1447,   639,  1448,  1449,   640,
     641,   642,   643,   644,   645,     0,  1450,   646,   647,   648,
     649,  1451,     0,   650,   651,   652,   653,   654,  1452,     0,
     655,   236,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,  1453,  1454,  1455,  1456,
    1457,  1458,  1459,   665,   666,   667,     0,     0,     0,     0,
       0,     0,     0,  1460,  1461,  1462,     0,     0,     0,     0,
       0,     0,  1463,   704,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   705,   104,   105,   406,   706,     0,   107,
     108,   109,   110,   707,   708,   112,   113,   114,   115,     0,
     116,   709,   710,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
     416,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1397,  1398,  1399,    45,  1400,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,  1401,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433,   135,  1402,   137,  1403,
    1404,     0,   434,   435,   436,   437,   438,  1405,  1406,   439,
     440,  1407,  1408,   442,     0,   443,   444,   445,   446,  1409,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,     0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,
     463,   464,   465,   466,   467,   468,  1417,  1418,   469,  1548,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,  1419,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
    1420,   493,   494,  1421,  1422,   495,     0,   496,  1423,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,  1424,     0,   504,     0,   505,   506,   507,   508,
     509,   173,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,   175,     0,   520,   521,   522,
    1425,  1426,     0,  1427,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,     0,  1428,   183,   531,
     184,     0,   532,   533,   534,  1429,  1430,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
    1431,   190,  1432,   548,   549,   550,   551,   552,   553,   554,
     192,   555,  1433,   556,   557,   194,   558,  1434,  1435,   559,
    1436,   560,   561,     0,     0,   562,     0,     0,  1437,   564,
     565,     0,     0,   197,   198,   199,   200,  1438,   566,   567,
     568,   569,   570,   571,     0,   572,  1439,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
    1440,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   211,   599,
     600,  1441,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,  1442,   614,   217,   615,
     616,   219,   617,  1443,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1444,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,  1445,  1446,
       0,     0,   638,  1447,   639,  1448,  1449,   640,   641,   642,
     643,   644,   645,     0,  1450,   646,   647,   648,   649,  1451,
       0,   650,   651,   652,   653,   654,  1452,     0,   655,   236,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,  1453,  1454,  1455,  1456,  1457,  1458,
    1459,   665,   666,   667,     0,     0,     0,     0,     0,     0,
       0,  1460,  1461,     0,     0,     0,     0,     0,     0,     0,
    1463,   704,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   705,   104,   105,   406,   706,     0,   107,   108,   109,
     110,   707,   708,   112,   113,   114,   115,     0,   116,   709,
     710,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1397,
    1398,  1399,    45,  1400,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,  2190,   425,   426,   427,     0,
       0,     0,     0,  1401,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433,   135,  1402,   137,  1403,  1404,     0,
     434,   435,   436,   437,   438,  1405,  1406,   439,   440,  1407,
    1408,   442,     0,   443,   444,   445,   446,  1409,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
       0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,   463,   464,
     465,   466,   467,   468,  1417,  1418,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,  1419,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,  1420,   493,
     494,  1421,  1422,   495,     0,   496,  1423,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1424,     0,   504,     0,   505,   506,   507,   508,   509,   173,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,   175,     0,   520,   521,   522,  1425,  1426,
       0,  1427,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,     0,  1428,   183,   531,   184,     0,
     532,   533,   534,  1429,  1430,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,  1431,   190,
    1432,   548,   549,   550,   551,   552,   553,   554,   192,   555,
    1433,   556,   557,   194,   558,  1434,  1435,   559,  1436,   560,
     561,     0,     0,   562,     0,     0,  1437,   564,   565,     0,
       0,   197,   198,   199,   200,  1438,   566,   567,   568,   569,
     570,   571,     0,   572,  1439,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,  1440,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   211,   599,   600,  1441,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,  1442,   614,   217,   615,   616,   219,
     617,  1443,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,  1444,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,  1445,  1446,     0,     0,
     638,  1447,   639,  1448,  1449,   640,   641,   642,   643,   644,
     645,     0,  1450,   646,   647,   648,   649,  1451,     0,   650,
     651,   652,   653,   654,  1452,     0,   655,   236,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,  1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,
     666,   667,     0,     0,     0,     0,     0,     0,     0,  1460,
    1461,     0,     0,     0,     0,     0,     0,     0,  1463,   704,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   705,
     104,   105,   406,   706,     0,   107,   108,   109,   110,   707,
     708,   112,   113,   114,   115,     0,   116,   709,   710,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,   416,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1397,  1398,  1399,
      45,  1400,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,  1401,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,   135,  1402,   137,  1403,  1404,     0,   434,   435,
     436,   437,   438,  1405,  1406,   439,   440,  1407,  1408,   442,
       0,   443,   444,   445,   446,  1409,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,  3138,  1410,
    1411,  1412,  1413,  1414,  1415,  1416,   463,   464,   465,   466,
     467,   468,  1417,  1418,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,  1419,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,  1420,   493,   494,  1421,
    1422,   495,     0,   496,  1423,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1424,     0,
     504,     0,   505,   506,   507,   508,   509,   173,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,   175,     0,   520,   521,   522,  1425,  1426,     0,  1427,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,  1428,   183,   531,   184,     0,   532,   533,
     534,  1429,  1430,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,  1431,   190,  1432,   548,
     549,   550,   551,   552,   553,   554,   192,   555,  1433,   556,
     557,   194,   558,  1434,  1435,   559,  1436,   560,   561,     0,
       0,   562,     0,     0,  1437,   564,   565,     0,     0,   197,
     198,   199,   200,  1438,   566,   567,   568,   569,   570,   571,
       0,   572,  1439,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,  1440,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   211,   599,   600,  1441,   601,   602,
     603,   604,   605,   606,   607,   608,     0,   609,   610,   611,
     612,   613,  1442,   614,   217,   615,   616,   219,   617,  1443,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1444,   628,     0,   629,   630,     0,   631,   632,   633,
     634,   635,   636,     0,  1445,  1446,     0,     0,   638,  1447,
     639,  1448,  1449,   640,   641,   642,   643,   644,   645,     0,
    1450,   646,   647,   648,   649,  1451,     0,   650,   651,   652,
     653,   654,  1452,     0,   655,   236,   656,   657,   658,     0,
       0,   659,     0,     0,   660,   661,   662,   663,   664,   238,
    1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,   666,   667,
       0,     0,     0,     0,     0,     0,     0,  1460,  1461,     0,
       0,     0,     0,     0,     0,     0,  1463,   704,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   705,   104,   105,
     406,   706,     0,   107,   108,   109,   110,   707,   708,   112,
     113,   114,   115,     0,   116,   709,   710,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1397,  1398,  1399,    45,  1400,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,  1401,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
     135,  1402,   137,  1403,  1404,     0,   434,   435,   436,   437,
     438,  1405,  1406,   439,   440,  1407,  1408,   442,     0,   443,
     444,   445,   446,  1409,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,  1410,  1411,  1412,
    1413,  1414,  1415,  1416,   463,   464,   465,   466,   467,   468,
    1417,  1418,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,  1419,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,  1420,   493,   494,  1421,  1422,   495,
       0,   496,  1423,   497,     0,   498,     0,   499,   169,  2679,
     170,   500,   501,   502,     0,   503,  1424,     0,   504,     0,
     505,   506,   507,   508,   509,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,  1425,  1426,     0,  1427,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,  1428,   183,   531,   184,     0,   532,   533,   534,  1429,
    1430,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,  1431,   190,  1432,   548,   549,   550,
     551,   552,   553,   554,   192,   555,  1433,   556,   557,   194,
     558,  1434,  1435,   559,  1436,   560,   561,     0,     0,   562,
       0,     0,  1437,   564,   565,     0,     0,   197,   198,   199,
     200,  1438,   566,   567,   568,   569,   570,   571,     0,   572,
    1439,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,  1440,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   211,   599,   600,  1441,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
    1442,   614,   217,   615,   616,   219,   617,  1443,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1444,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,  1445,  1446,     0,     0,   638,  1447,   639,  1448,
    1449,   640,   641,   642,   643,   644,   645,     0,  1450,   646,
     647,   648,   649,  1451,     0,   650,   651,   652,   653,   654,
    1452,     0,   655,   236,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,  1453,  1454,
    1455,  1456,  1457,  1458,  1459,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,  1460,  1461,     0,     0,     0,
       0,     0,     0,     0,  1463,   704,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   705,   104,   105,   406,   706,
       0,   107,   108,   109,   110,   707,   708,   112,   113,   114,
     115,     0,   116,   709,   710,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1397,  1398,  1399,    45,  1400,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,  1401,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,   135,  1402,
     137,  1403,  1404,     0,   434,   435,   436,   437,   438,  1405,
    1406,   439,   440,  1407,  1408,   442,     0,   443,   444,   445,
     446,  1409,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,  1410,  1411,  1412,  1413,  1414,
    1415,  1416,   463,   464,   465,   466,   467,   468,  1417,  1418,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,  1419,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,  1420,   493,   494,  1421,  1422,   495,     0,   496,
    1423,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1424,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,   175,     0,   520,
     521,   522,  1425,  1426,     0,  1427,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,  1428,
     183,   531,   184,     0,   532,   533,   534,  1429,  1430,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,  1431,   190,  1432,   548,   549,   550,   551,   552,
     553,   554,   192,   555,  1433,   556,   557,   194,   558,  1434,
    1435,   559,  1436,   560,   561,     0,     0,   562,     0,     0,
    1437,   564,   565,     0,     0,   197,   198,   199,   200,  1438,
     566,   567,   568,   569,   570,   571,     0,   572,  1439,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,  1440,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     211,   599,   600,  1441,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,  1442,   614,
     217,   615,   616,   219,   617,  1443,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1444,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1445,  1446,     0,     0,   638,  1447,   639,  1448,  1449,   640,
     641,   642,   643,   644,   645,     0,  1450,   646,   647,   648,
     649,  1451,     0,   650,   651,   652,   653,   654,  1452,  3742,
     655,   236,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,  1453,  1454,  1455,  1456,
    1457,  1458,  1459,   665,   666,   667,     0,     0,     0,     0,
       0,     0,     0,  1460,  1461,     0,     0,     0,     0,     0,
       0,     0,  1463,   704,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   705,   104,   105,   406,   706,     0,   107,
     108,   109,   110,   707,   708,   112,   113,   114,   115,     0,
     116,   709,   710,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
     416,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1397,  1398,  1399,    45,  1400,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,  1401,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433,  4413,  1402,   137,  1403,
    1404,     0,   434,   435,   436,   437,   438,  1405,  1406,   439,
     440,  1407,  1408,   442,     0,   443,   444,   445,   446,  1409,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,  4414,  1410,  1411,  1412,  1413,  1414,  1415,  1416,
     463,   464,   465,   466,   467,   468,  1417,  1418,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,  1419,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
    1420,   493,   494,  1421,  1422,   495,     0,   496,  1423,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,  1424,     0,   504,     0,   505,   506,   507,   508,
     509,   173,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,   175,     0,   520,   521,   522,
    1425,  1426,     0,  1427,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,     0,  1428,   183,   531,
     184,     0,   532,   533,   534,  1429,  1430,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
    1431,   190,  1432,   548,   549,   550,   551,   552,   553,   554,
     192,   555,  1433,   556,   557,   194,   558,  1434,  1435,   559,
    1436,   560,   561,     0,     0,   562,     0,     0,  1437,   564,
     565,     0,     0,   197,   198,   199,   200,  1438,   566,   567,
     568,   569,   570,   571,     0,   572,  1439,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
    1440,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   211,   599,
     600,  1441,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,  1442,   614,   217,   615,
     616,   219,   617,  1443,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1444,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,  1445,  1446,
       0,     0,   638,  1447,   639,  1448,  1449,   640,   641,   642,
    4415,   644,   645,     0,  1450,   646,   647,   648,   649,  1451,
       0,   650,   651,   652,   653,   654,  1452,     0,   655,   236,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,  1453,  1454,  1455,  1456,  1457,  1458,
    1459,   665,   666,   667,     0,     0,     0,     0,     0,     0,
       0,  1460,  1461,     0,     0,     0,     0,     0,     0,     0,
    1463,   704,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   705,   104,   105,   406,   706,     0,   107,   108,   109,
     110,   707,   708,   112,   113,   114,   115,     0,   116,   709,
     710,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1397,
    1398,  1399,    45,  1400,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,  1401,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433,   135,  1402,   137,  1403,  1404,     0,
     434,   435,   436,   437,   438,  1405,  1406,   439,   440,  1407,
    1408,   442,     0,   443,   444,   445,   446,  1409,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
    4414,  1410,  1411,  1412,  1413,  1414,  1415,  1416,   463,   464,
     465,   466,   467,   468,  1417,  1418,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,  1419,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,  1420,   493,
     494,  1421,  1422,   495,     0,   496,  1423,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1424,     0,   504,     0,   505,   506,   507,   508,   509,   173,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,   175,     0,   520,   521,   522,  1425,  1426,
       0,  1427,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,     0,  1428,   183,   531,   184,     0,
     532,   533,   534,  1429,  1430,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,  1431,   190,
    1432,   548,   549,   550,   551,   552,   553,   554,   192,   555,
    1433,   556,   557,   194,   558,  1434,  1435,   559,  1436,   560,
     561,     0,     0,   562,     0,     0,  1437,   564,   565,     0,
       0,   197,   198,   199,   200,  1438,   566,   567,   568,   569,
     570,   571,     0,   572,  1439,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,  1440,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   211,   599,   600,  1441,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,  1442,   614,   217,   615,   616,   219,
     617,  1443,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,  1444,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,  1445,  1446,     0,     0,
     638,  1447,   639,  1448,  1449,   640,   641,   642,  4415,   644,
     645,     0,  1450,   646,   647,   648,   649,  1451,     0,   650,
     651,   652,   653,   654,  1452,     0,   655,   236,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,  1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,
     666,   667,     0,     0,     0,     0,     0,     0,     0,  1460,
    1461,     0,     0,     0,     0,     0,     0,     0,  1463,   704,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   705,
     104,   105,   406,   706,     0,   107,   108,   109,   110,   707,
     708,   112,   113,   114,   115,     0,   116,   709,   710,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,   416,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1397,  1398,  1399,
      45,  1400,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,  1401,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,   135,  1402,   137,  1403,  1404,     0,   434,   435,
     436,   437,   438,  1405,  1406,   439,   440,  1407,  1408,   442,
       0,   443,   444,   445,   446,  1409,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,     0,  1410,
    1411,  1412,  1413,  1414,  1415,  1416,   463,   464,   465,   466,
     467,   468,  1417,  1418,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,  1419,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,  1420,   493,   494,  1421,
    1422,   495,     0,   496,  1423,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1424,     0,
     504,     0,   505,   506,   507,   508,   509,   173,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,   175,     0,   520,   521,   522,  1425,  1426,     0,  1427,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,  1428,   183,   531,   184,     0,   532,   533,
     534,  1429,  1430,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,  1431,   190,  1432,   548,
     549,   550,   551,   552,   553,   554,   192,   555,  1433,   556,
     557,   194,   558,  1434,  1435,   559,  1436,   560,   561,     0,
       0,   562,     0,     0,  1437,   564,   565,     0,     0,   197,
     198,   199,   200,  1438,   566,   567,   568,   569,   570,   571,
       0,   572,  1439,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,  1440,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   211,   599,   600,  1441,   601,   602,
     603,   604,   605,   606,   607,   608,     0,   609,   610,   611,
     612,   613,  1442,   614,   217,   615,   616,   219,   617,  1443,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1444,   628,     0,   629,   630,     0,   631,   632,   633,
     634,   635,   636,     0,  1445,  1446,     0,     0,   638,  1447,
     639,  1448,  1449,   640,   641,   642,   643,   644,   645,     0,
    1450,   646,   647,   648,   649,  1451,     0,   650,   651,   652,
     653,   654,  1452,     0,   655,   236,   656,   657,   658,     0,
       0,   659,     0,     0,   660,   661,   662,   663,   664,   238,
    1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,   666,   667,
       0,     0,     0,     0,     0,     0,     0,  1460,  1461,     0,
       0,     0,     0,     0,     0,     0,  1463,   704,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   705,   104,   105,
     406,   706,     0,   107,   108,   109,   110,   707,   708,   112,
     113,   114,   115,     0,   116,   709,   710,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1397,  1398,  1399,    45,  1400,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,  1401,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
     135,  1402,   137,  1403,  1404,     0,   434,   435,   436,   437,
     438,  1405,  1406,   439,   440,  1407,  1408,   442,     0,   443,
     444,   445,   446,  1409,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,  1410,  1411,  1412,
    1413,  1414,  1415,  1416,   463,   464,   465,   466,   467,   468,
    1417,  1418,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,  1419,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,  1420,   493,   494,  1421,  1422,   495,
       0,   496,  1423,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1424,     0,   504,     0,
     505,   506,   507,   508,   509,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,  1425,  1426,     0,  1427,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,  1428,   183,   531,   184,     0,   532,   533,   534,  1429,
    1430,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,  1431,   190,  1432,   548,   549,   550,
     551,   552,   553,   554,   192,   555,  1433,   556,   557,   194,
     558,  1434,  1435,   559,  1436,   560,   561,     0,     0,   562,
       0,     0,  1437,   564,   565,     0,     0,   197,   198,   199,
     200,  1438,   566,   567,   568,   569,   570,   571,     0,   572,
    1439,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,  1440,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   211,   599,   600,  1441,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
    1442,   614,   217,   615,   616,   219,   617,  1443,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1444,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,  1445,  1446,     0,     0,   638,  1447,   639,  1448,
    1449,   640,   641,   642,   643,   644,   645,     0,  1450,   646,
     647,   648,   649,  1451,     0,   650,   651,   652,   653,   654,
    1452,     0,   655,   236,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,  3990,  1453,  1454,
    1455,  1456,  1457,  1458,  1459,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,  1460,  1461,     0,     0,     0,
       0,     0,     0,     0,  1463,   704,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   705,   104,   105,   406,   706,
       0,   107,   108,   109,   110,   707,   708,   112,   113,   114,
     115,     0,   116,   709,   710,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1397,  1398,  1399,    45,  1400,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,  1401,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,   135,  1402,
     137,  1403,  1404,     0,   434,   435,   436,   437,   438,  1405,
    1406,   439,   440,  1407,  1408,   442,     0,   443,   444,   445,
     446,  1409,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,  1410,  1411,  1412,  1413,  1414,
    1415,  1416,   463,   464,   465,   466,   467,   468,  1417,  1418,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,  1419,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,  1420,   493,   494,  1421,  1422,   495,     0,   496,
    1423,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1424,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,   175,     0,   520,
     521,   522,  1425,  1426,     0,  1427,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,  1428,
     183,   531,   184,     0,   532,   533,   534,  1429,  1430,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,  1431,   190,  1432,   548,  3997,   550,   551,   552,
     553,   554,   192,   555,  1433,   556,   557,   194,   558,  1434,
    1435,   559,  1436,   560,   561,     0,     0,   562,     0,     0,
    1437,   564,   565,     0,     0,   197,   198,   199,   200,  1438,
     566,   567,   568,   569,   570,   571,     0,   572,  1439,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,  1440,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     211,   599,   600,  1441,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,  1442,   614,
     217,   615,   616,   219,   617,  1443,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1444,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1445,  1446,     0,     0,   638,  1447,   639,  1448,  1449,   640,
     641,   642,   643,   644,   645,     0,  1450,   646,   647,   648,
     649,  1451,     0,   650,   651,   652,   653,   654,  1452,     0,
     655,   236,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,  1453,  1454,  1455,  1456,
    1457,  1458,  1459,   665,   666,   667,     0,     0,     0,     0,
       0,     0,     0,  1460,  1461,     0,     0,     0,     0,     0,
       0,     0,  1463,   704,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   705,   104,   105,   406,   706,     0,   107,
     108,   109,   110,   707,   708,   112,   113,   114,   115,     0,
     116,   709,   710,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
     416,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,  1397,  1398,  1399,    45,  1400,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,  1401,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433,   135,  1402,   137,  1403,
    1404,     0,   434,   435,   436,   437,   438,  1405,  1406,   439,
     440,  1407,  1408,   442,     0,   443,   444,   445,   446,  1409,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,     0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,
     463,   464,   465,   466,   467,   468,  1417,  1418,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,  1419,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
    1420,   493,   494,  1421,  1422,   495,     0,   496,  1423,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,  1424,     0,   504,     0,   505,   506,   507,   508,
     509,   173,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,   175,     0,   520,   521,   522,
    1425,  1426,     0,  1427,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,     0,  1428,   183,   531,
     184,     0,   532,   533,   534,  1429,  1430,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
    1431,   190,  1432,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,   194,   558,  1434,  1435,   559,
    1436,   560,   561,     0,     0,   562,     0,     0,  1437,   564,
     565,     0,     0,   197,   198,   199,   200,  1438,   566,   567,
     568,   569,   570,   571,     0,   572,  1439,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
    1440,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   211,   599,
     600,  1441,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,  1442,   614,   217,   615,
     616,   219,   617,  1443,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1444,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,  1445,  1446,
       0,     0,   638,  1447,   639,  1448,  1449,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,  1451,
       0,   650,   651,   652,   653,   654,  1452,     0,   655,   236,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,  1453,  1454,  1455,  1456,  1457,  1458,
    1459,   665,   666,   667,     0,     0,     0,     0,     0,     0,
       0,  2661,  2662,     0,     0,     0,     0,     0,     0,     0,
    1463,   704,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   705,   104,   105,   406,   706,     0,   107,   108,   109,
     110,   707,   708,   112,   113,   114,   115,     0,   116,   709,
     710,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,    37,    38,    39,    40,    41,    42,    43,    44,  1397,
    1398,  1399,    45,  1400,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,  1401,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433, -2407,  1402,   137,  1403,  1404,     0,
     434,   435,   436,   437,   438,  1405,  1406,   439,   440,  1407,
    1408,   442,     0,   443,   444,   445,   446,  1409,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
    4414,  1410,  1411,  1412,  1413,  1414,  1415,  1416,   463,   464,
     465,   466,   467,   468,  1417,  1418,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,  1419,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,  1420,   493,
     494,  1421,  1422,   495,     0,   496,  1423,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
    1424,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,   175,     0,   520,   521,   522,  1425,  1426,
       0,  1427,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,     0,  1428,   183,   531,     0,     0,
     532,   533,   534,  1429,  1430,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,  1431,   190,
    1432,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,   194,   558,  1434,  1435,   559,  1436,   560,
     561,     0,     0,   562,     0,     0,  1437,   564,   565,     0,
       0,   197,   198,   199,   200,  1438,   566,   567,   568,   569,
     570,   571,     0,   572,  1439,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,  1440,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   211,   599,   600,  1441,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,  1442,   614,   217,   615,   616,     0,
     617,  1443,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,  1444,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,  1445,  1446,     0,     0,
     638,  1447,   639,  1448,  1449,   640,   641,   642,  4415,   644,
     645,     0,  1450,   646,   647,   648,   649,  1451,     0,   650,
     651,   652,   653,   654,  1452,     0,   655,   236,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,  1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,
     666,   667,     0,     0,     0,     0,     0,     0,     0,  1460,
    1461,     0,     0,     0,     0,     0,     0,     0,  1463,   704,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   705,
     104,   105,   406,   706,     0,   107,   108,   109,   110,   707,
     708,   112,   113,   114,   115,     0,   116,   709,   710,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,   416,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,  1397,  1398,  1399,
      45,  1400,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,  1401,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,     0,  1402,   137,  1403,  1404,     0,   434,   435,
     436,   437,   438,  1405,  1406,   439,   440,  1407,  1408,   442,
       0,   443,   444,   445,   446,  1409,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,     0,  1410,
    1411,  1412,  1413,  1414,  1415,  1416,   463,   464,   465,   466,
     467,   468,  1417,  1418,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,  1419,   482,   483,     0,   484,   485,   486,     0,   487,
       0,     0,   489,   490,   491,   492,  1420,   493,   494,  1421,
    1422,   495,     0,   496,  1423,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1424,     0,
     504,     0,   505,   506,   507,   508,   509,     0,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,   175,     0,   520,   521,   522,  1425,  1426,     0,  1427,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,  1428,   183,   531,     0,     0,   532,   533,
     534,  1429,  1430,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,  1431,   190,  1432,   548,
     549,   550,   551,   552,   553,   554,   192,   555,     0,   556,
     557,   194,   558,  1434,  1435,   559,  1436,   560,   561,     0,
       0,   562,     0,     0,  1437,   564,   565,     0,     0,   197,
     198,   199,   200,  1438,   566,   567,   568,   569,   570,   571,
       0,   572,  1439,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,  1440,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   211,   599,   600,  1441,   601,   602,
     603,   604,   605,   606,   607,   608,     0,   609,   610,   611,
     612,   613,  1442,   614,   217,   615,   616,     0,   617,  1443,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1444,   628,     0,   629,   630,     0,   631,   632,   633,
     634,   635,   636,     0,  1445,  1446,     0,     0,   638,  1447,
     639,  1448,  1449,   640,   641,   642,   643,   644,   645,     0,
    1450,   646,   647,   648,   649,  1451,     0,   650,   651,   652,
     653,   654,  1452,     0,   655,   236,   656,   657,   658,     0,
       0,   659,     0,     0,   660,   661,   662,   663,   664,   238,
    1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,   666,   667,
       0,     0,     0,     0,     0,     0,     0,  1460,  1461,     0,
       0,     0,     0,     0,     0,     0,  1463,   704,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   705,   104,   105,
     406,   706,     0,   107,   108,   109,   110,   707,   708,   112,
     113,   114,   115,     0,   116,   709,   710,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,   416,     0,     0,    37,    38,    39,
      40,    41,    42,    43,    44,  1397,  1398,  1399,    45,  1400,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,  1401,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
       0,  1402,   137,  1403,  1404,     0,   434,   435,   436,   437,
     438,  1405,  1406,   439,   440,  1407,  1408,   442,     0,   443,
     444,   445,   446,  1409,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,  1410,  1411,  1412,
    1413,  1414,  1415,  1416,   463,   464,   465,   466,   467,   468,
    1417,  1418,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,  1419,
     482,   483,     0,   484,   485,   486,     0,   487,     0,     0,
     489,   490,   491,   492,  1420,   493,   494,  1421,  1422,   495,
       0,   496,  1423,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,  1424,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,  1425,  1426,     0,  1427,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,  1428,   183,   531,     0,     0,   532,   533,   534,  1429,
    1430,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,  1431,   190,  1432,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,   194,
     558,  1434,  1435,   559,  1436,   560,   561,     0,     0,   562,
       0,     0,  1437,   564,   565,     0,     0,   197,   198,   199,
     200,  1438,   566,   567,   568,   569,   570,   571,     0,   572,
    1439,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,  1440,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   211,   599,   600,  1441,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
    1442,   614,   217,   615,   616,     0,   617,  1443,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,  1444,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,  1445,  1446,     0,     0,   638,  1447,   639,  1448,
    1449,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,  1451,     0,   650,   651,   652,   653,   654,
    1452,     0,   655,   236,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,  1453,  1454,
    1455,  1456,  1457,  1458,  1459,   665,   666,   667,     0,     0,
       0,     0,     0,     0,     0,  2661,  2662,     0,     0,     0,
       0,     0,     0,     0,  1463,   704,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   705,   104,   105,   406,   706,
       0,   107,   108,   109,   110,   707,   708,   112,   113,   114,
     115,     0,   116,   709,   710,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,   135,   136,
     137,   138,   139,     0,   434,   435,   436,   437,   438,     0,
    1406,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,  1409,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,  1410,  1411,  1412,  1413,  1414,
    1415,  1416,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,  1421,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,  1424,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,  1428,
     183,   531,   184,     0,   532,   533,   534,  1429,  1430,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,   190,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,   194,   558,     0,
    1435,   559,   196,   560,   561,     0,     0,   562,     0,  1044,
     563,   564,   565,     0,     0,   197,   198,   199,   200,  1438,
     566,   567,   568,   569,   570,   571,     0,   572,  1439,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     211,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,   215,   609,   610,   611,   612,   613,  1442,   614,
     217,   615,   616,   219,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,  1444,   628,     0,
     629,   630,   223,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,  1447,   639,  1448,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,  1451,     0,   650,   651,   652,   653,  1324,   235,     0,
     655,   236,   656,   657,   658,     0,     0,   659,     0,   237,
     660,   661,   662,   663,   664,   238,  1453,  1454,  1455,  1456,
    1457,  1458,  1459,   665,   666,   667,     0,     0,     0,   704,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,  2510,    98,    99,   100,   101,   102,   103,   705,
     104,   105,   406,   706,     0,   107,   108,   109,   110,   707,
     708,   112,   113,   114,   115,     0,   116,   709,   710,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,     0,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,   135,   136,   137,   138,   139,     0,   434,   435,
     436,   437,   438,     0,  1406,   439,   440,   441,   140,   442,
       0,   443,   444,   445,   446,  1409,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,     0,  1410,
    1411,  1412,  1413,  1414,  1415,  1416,   463,   464,   465,   466,
     467,   468,   154,   155,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,   164,   493,   494,  1421,
       0,   495,     0,   496,   168,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,  1424,     0,
     504,     0,   505,   506,   507,   508,   509,   173,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,   175,     0,   520,   521,   522,     0,   177,     0,   178,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,  1428,   183,   531,   184,     0,   532,   533,
     534,  1429,  1430,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,   189,   190,   191,   548,
     549,   550,   551,   552,   553,   554,   192,   555,     0,   556,
     557,   194,   558,     0,  1435,   559,   196,   560,   561,     0,
       0,   562,     0,  1044,   563,   564,   565,     0,     0,   197,
     198,   199,   200,  1438,   566,   567,   568,   569,   570,   571,
       0,   572,  1439,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,   205,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   211,   599,   600,   213,   601,   602,
     603,   604,   605,   606,   607,   608,     0,   609,   610,   611,
     612,   613,  1442,   614,   217,   615,   616,   219,   617,   220,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,  1444,   628,     0,   629,   630,     0,   631,   632,   633,
     634,   635,   636,     0,   224,   225,     0,     0,   638,  1447,
     639,  1448,     0,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,  1451,     0,   650,   651,   652,
     653,   654,   235,     0,   655,   236,   656,   657,   658,     0,
       0,   659,     0,     0,   660,   661,   662,   663,   664,   238,
    1453,  1454,  1455,  1456,  1457,  1458,  1459,   665,   666,   667,
       0,     0,     0,   704,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,  2510,    98,    99,   100,
     101,   102,   103,   705,   104,   105,   406,   706,     0,   107,
     108,   109,   110,   707,   708,   112,   113,   114,   115,     0,
     116,   709,   710,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,     0,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433,   135,   136,   137,   138,
     139,     0,   434,   435,   436,   437,   438,     0,  1406,   439,
     440,   441,   140,   442,     0,   443,   444,   445,   446,  1409,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,     0,  1410,  1411,  1412,  1413,  1414,  1415,  1416,
     463,   464,   465,   466,   467,   468,   154,   155,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
     164,   493,   494,  1421,     0,   495,     0,   496,   168,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,  1424,     0,   504,     0,   505,   506,   507,   508,
     509,   173,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,   175,     0,   520,   521,   522,
       0,   177,     0,   178,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,     0,  1428,   183,   531,
     184,     0,   532,   533,   534,  1429,  1430,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,   190,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,   194,   558,     0,  1435,   559,
     196,   560,   561,     0,     0,   562,     0,     0,   563,   564,
     565,     0,     0,   197,   198,   199,   200,  1438,   566,   567,
     568,   569,   570,   571,     0,   572,  1439,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
     205,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   211,   599,
     600,   213,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,  1442,   614,   217,   615,
     616,   219,   617,   220,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,  1444,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,   224,   225,
       0,     0,   638,  1447,   639,  1448,     0,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,  1451,
       0,   650,   651,   652,   653,   654,   235,     0,   655,   236,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,  1453,  1454,  1455,  1456,  1457,  1458,
    1459,   665,   666,   667,     0,     0,     0,   704,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
    3770,    98,    99,   100,   101,   102,   103,   705,   104,   105,
     406,   706,     0,   107,   108,   109,   110,   707,   708,   112,
     113,   114,   115,     0,   116,   709,   710,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
     135,   136,   137,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,     0,     0,     0,
     151,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,   182,   183,   531,   184,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,   190,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,   194,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,   198,   199,
     200,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   211,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,   219,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,   236,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,     0,     0,
       0,     0,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,  4226,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,  3120,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461, -1274,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0, -1274,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519, -1274,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524, -1274,   525,   526,
     527,   528,   529,   530,     0,   182, -1274,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189, -1274,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,     0,     0,   562,     0,     0,   563,   564,   565,     0,
       0,   197,     0,     0,     0,   201,   566,   567,   568,   569,
     570,   571,     0,   572,   202,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,   205,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598, -1274,   599,   600,   213,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,     0,   614,   217,   615,   616,     0,
     617,   220,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,   224,   225,     0,     0,
     638,   226,   639,   227,     0,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,   235,     0,   655,     0,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,   239,   240,   241,   242,   243,   244,   245,   665,
     666,   667,     0,     0,     0,     0,     0,    86,    87,    88,
     403,    90,    91,    92,   404,     0,   405,    95,     0,  1556,
      98,    99,   100,   101,   102,   103,     0,   104,   105,   406,
       0,     0,   107,   108,   109,   110,     0,     0,   112,   113,
     114,   115,     0,   116,     0,     0,   407,   408,     0,     0,
       0,   409,   410,     0,     0,     0,     0,   411,     0,     0,
       0,     0,     0,     0,     0,     0,   412,     0,   413,     0,
     414,   415,    35,   416,     0,     0,    37,    38,    39,    40,
      41,    42,    43,    44,     0,     0,     0,    45,     0,     0,
       0,     0,   417,   418,   419,   420,   421,   422,   423,   424,
       0,   425,   426,   427,     0,     0,     0,     0,     0,     0,
       0,   428,   429,     0,   430,     0,   431,   432,   433,   135,
     136,     0,   138,   139,     0,   434,   435,   436,   437,   438,
       0,     0,   439,   440,   441,   140,   442,     0,   443,   444,
     445,   446,   144,     0,     0,   447,   448,   449,   450,     0,
     451,   452,     0,   453,   454,   455,   456,   457,   458,     0,
     459,   460,   461,     0,   462,     0,     0,     0,     0,     0,
       0,     0,     0,   463,   464,   465,   466,   467,   468,   154,
     155,   469,     0,   470,     0,   471,   472,   473,   474,   475,
       0,   476,   477,   478,     0,     0,   479,   480,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,     0,   489,
     490,   491,   492,   164,   493,   494,   166,  1927,   495,     0,
     496,   168,   497,     0,   498,     0,   499,     0,     0,     0,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   507,   508,   509,     0,   510,   511,   512,     0,   513,
     514,   515,   516,   517,   518,     0,   519,     0,   175,     0,
     520,   521,   522,     0,   177,     0,   178,     0,   523,     0,
       0,   524,     0,   525,   526,   527,   528,   529,   530,     0,
     182,     0,   531,     0,     0,   532,   533,   534,     0,     0,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   189,     0,   191,   548,   549,   550,   551,
     552,   553,   554,   192,   555,     0,   556,   557,     0,   558,
       0,   195,   559,   196,   560,   561,  1928,     0,   562,  1929,
       0,   563,   564,   565,     0,     0,   197,     0,     0,     0,
     201,   566,   567,   568,   569,   570,   571,     0,   572,   202,
     573,   203,   574,   575,   576,     0,   577,   578,   579,   580,
     581,   582,   583,   205,   584,   585,   586,     0,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,     0,   599,   600,   213,   601,   602,   603,   604,   605,
     606,   607,   608,     0,   609,   610,   611,   612,   613,     0,
     614,   217,   615,   616,     0,   617,   220,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,   628,
       0,   629,   630,     0,   631,   632,   633,   634,   635,   636,
       0,   224,   225,     0,     0,   638,   226,   639,   227,  1930,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,   235,
       0,   655,     0,   656,   657,   658,     0,     0,   659,     0,
       0,   660,   661,   662,   663,   664,   238,   239,   240,   241,
     242,   243,   244,   245,   665,   666,   667,     0,     0,     0,
       0,     0,     0,     0,   962,  1595,  3847,     0,     0,     0,
       0,     0,     0,  3848,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   406,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,    37,    38,    39,    40,    41,    42,     0,
      44,     0,     0,     0,    45,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,     0,     0,     0,   428,   429,
       0,   430,     0,   431,   432,   433,   135,   136,     0,   138,
     139,     0,   434,   435,   436,   437,   438,     0,     0,   439,
     440,   441,   140,   442,     0,   443,   444,   445,   446,   144,
       0,     0,   447,   448,   449,   450,     0,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
       0,   462,     0,     0,     0,     0,     0,     0,     0,     0,
     463,   464,   465,   466,   467,   468,   154,   155,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
     164,   493,   494,   166,     0,   495,     0,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   507,   508,
     509,     0,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,     0,   175,     0,   520,   521,   522,
       0,   177,     0,   178,     0,   523,     0,     0,   524,     0,
     525,   526,   527,   528,   529,   530,     0,   182,     0,   531,
       0,     0,   532,   533,   534,     0,     0,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,     0,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,     0,   558,     0,   195,   559,
     196,   560,   561,     0,     0,   562,     0,     0,   563,   564,
     565,     0,     0,   197,     0,     0,     0,   201,   566,   567,
     568,   569,   570,   571,     0,   572,   202,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
     205,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   213,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,     0,   614,   217,   615,
     616,     0,   617,   220,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,   224,   225,
       0,     0,   638,   226,   639,   227,     0,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,   235,     0,   655,     0,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,   239,   240,   241,   242,   243,   244,
     245,   665,   666,   667,     0,     0,     0,     0,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,  3504,
    3505,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,   130,   131,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,   215,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,   223,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,  1324,
     235,     0,   655,  1325,   656,   657,   658,     0,     0,   659,
       0,   237,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,     0,     0,
       0,     0,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,   246,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,    37,    38,    39,    40,    41,    42,     0,    44,     0,
       0,     0,    45,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,     0,     0,   562,     0,     0,   563,   564,   565,     0,
       0,   197,     0,     0,     0,   201,   566,   567,   568,   569,
     570,   571,     0,   572,   202,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,   205,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,     0,   599,   600,   213,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,     0,   614,   217,   615,   616,     0,
     617,   220,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,   224,   225,     0,     0,
     638,   226,   639,   227,     0,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,   235,     0,   655,     0,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,   239,   240,   241,   242,   243,   244,   245,   665,
     666,   667,     0,     0,     0,     0,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,  3505,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,   215,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,   223,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,  1324,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,   237,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,     0,     0,     0,     0,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,   246,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   406,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,     0,     0,     0,   428,   429,     0,   430,     0,   431,
     432,   433,   135,   136,     0,   138,   139,     0,   434,   435,
     436,   437,   438,     0,     0,   439,   440,   441,   140,   442,
       0,   443,   444,   445,   446,   144,     0,     0,   447,   448,
     449,   450,     0,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,     0,   462,     0,     0,
       0,     0,     0,     0,     0,     0,   463,   464,   465,   466,
     467,   468,   154,   155,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,   164,   493,   494,   166,
       0,   495,     0,   496,   168,   497,     0,   498,     0,   499,
       0,     0,     0,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,   507,   508,   509,     0,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
       0,   175,     0,   520,   521,   522,     0,   177,     0,   178,
       0,   523,     0,     0,   524,     0,   525,   526,   527,   528,
     529,   530,     0,   182,     0,   531,     0,     0,   532,   533,
     534,     0,     0,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,   189,     0,   191,   548,
     549,   550,   551,   552,   553,   554,   192,   555,     0,   556,
     557,     0,   558,     0,   195,   559,   196,   560,   561,     0,
       0,   562,     0,     0,   563,   564,   565,     0,     0,   197,
       0,     0,     0,   201,   566,   567,   568,   569,   570,   571,
       0,   572,   202,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,   205,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   213,   601,   602,
     603,   604,   605,   606,   607,   608,   215,   609,   610,   611,
     612,   613,     0,   614,   217,   615,   616,     0,   617,   220,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,   628,     0,   629,   630,   223,   631,   632,   633,
     634,   635,   636,     0,   224,   225,     0,     0,   638,   226,
     639,   227,     0,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,  1324,   235,     0,   655,     0,   656,   657,   658,     0,
       0,   659,     0,   237,   660,   661,   662,   663,   664,   238,
     239,   240,   241,   242,   243,   244,   245,   665,   666,   667,
       0,     0,     0,     0,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,   246,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   406,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,     0,     0,     0,   428,   429,
       0,   430,     0,   431,   432,   433,   135,   136,     0,   138,
     139,     0,   434,   435,   436,   437,   438,     0,     0,   439,
     440,   441,   140,   442,     0,   443,   444,   445,   446,   144,
       0,     0,   447,   448,   449,   450,     0,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
       0,   462,     0,     0,     0,     0,     0,     0,     0,     0,
     463,   464,   465,   466,   467,   468,   154,   155,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
     164,   493,   494,   166,     0,   495,     0,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   507,   508,
     509,     0,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,     0,   175,     0,   520,   521,   522,
       0,   177,     0,   178,     0,   523,     0,     0,   524,     0,
     525,   526,   527,   528,   529,   530,     0,   182,     0,   531,
       0,     0,   532,   533,   534,     0,     0,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,     0,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,     0,   558,     0,   195,   559,
     196,   560,   561,     0,     0,   562,     0,     0,   563,   564,
     565,     0,     0,   197,     0,     0,     0,   201,   566,   567,
     568,   569,   570,   571,     0,   572,   202,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
     205,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   213,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,     0,   614,   217,   615,
     616,     0,   617,   220,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,   224,   225,
       0,     0,   638,   226,   639,   227,     0,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,   235,     0,   655,     0,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,   239,   240,   241,   242,   243,   244,
     245,   665,   666,   667,     0,     0,     0,     0,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
    1528,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,     0,     0,
       0,     0,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,  2162,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,     0,     0,   562,     0,     0,   563,   564,   565,     0,
       0,   197,     0,     0,     0,   201,   566,   567,   568,   569,
     570,   571,     0,   572,   202,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,   205,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,     0,   599,   600,   213,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,     0,   614,   217,   615,   616,     0,
     617,   220,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,   224,   225,     0,     0,
     638,   226,   639,   227,     0,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,   235,     0,   655,     0,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,   239,   240,   241,   242,   243,   244,   245,   665,
     666,   667,     0,     0,     0,     0,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,  3610,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,     0,     0,     0,   704,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,  3736,    98,    99,   100,   101,   102,   103,   705,
     104,   105,   406,   706,     0,   107,   108,   109,   110,   707,
     708,   112,   113,   114,   115,     0,   116,   709,   710,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,   416,     0,     0,    37,
      38,    39,    40,    41,    42,    43,    44,     0,     0,  1158,
      45,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,   711,   425,   426,   427,   712,   713,   714,
     715,   716,   717,   718,   428,   429,   719,   430,   133,   431,
     432,   433,     0,  1784,   137,  1785,  1786,   720,   434,   435,
     436,   437,   438,   721,   722,   439,   440,  1787,  1788,   442,
     724,   443,   444,   445,   446,     0,   725,   726,   447,   448,
     449,   450,   147,   451,   452,   728,   453,   454,   455,   456,
     457,   458,   729,   459,   460,   461,   150,   462,     0,   731,
     732,   733,   151,   734,   735,   736,   463,   464,   465,   466,
     467,   468,  1789,  1790,   469,   737,   470,   738,   471,   472,
     473,   474,   475,   739,   476,   477,   478,   740,   741,   479,
     480,  1419,   482,   483,   742,   484,   485,   486,   743,   487,
     488,   744,   489,   490,   491,   492,     0,   493,   494,     0,
     745,   495,   746,   496,  1791,   497,   747,   498,   748,   499,
     169,   749,   170,   500,   501,   502,   750,   503,     0,   751,
     504,   752,   505,   506,   507,   508,   509,   173,   510,   511,
     512,   753,   513,   514,   515,   516,   517,   518,   754,   519,
     174,     0,     0,   520,   521,   522,  1425,  1792,   757,  1793,
     758,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,   759,     0,   183,   531,   184,   760,   532,   533,
     534,   761,   762,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,  1794,   190,  1795,   548,
     549,   550,   551,   552,   553,   554,     0,   555,   763,   556,
     557,   194,   558,   764,     0,   559,  1796,   560,   561,   765,
     766,   562,   767,   768,  3491,   564,   565,   769,   770,     0,
     198,   199,   200,     0,   566,   567,   568,   569,   570,   571,
     771,   572,     0,   573,     0,   574,   575,   576,   772,   577,
     578,   579,   580,   581,   582,   583,  1797,   584,   585,   586,
     773,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,   774,   597,   598,   211,   599,   600,     0,   601,   602,
     603,   604,   605,   606,   607,   608,   775,   609,   610,   611,
     612,   613,   776,   614,  2307,   615,   616,   219,   617,  1799,
     777,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,     0,   628,   778,   629,   630,   779,   631,   632,   633,
     634,   635,   636,   780,  1800,  1801,     0,   782,   638,     0,
     639,     0,   783,   640,   641,   642,   643,   644,   645,     0,
     785,   646,   647,   648,   649,   786,   787,   650,   651,   652,
     653,     0,  1802,   789,   655,   236,   656,   657,   658,   790,
     791,   659,   792,   793,   660,   661,   662,   663,   664,     0,
       0,     0,     0,     0,     0,     0,     0,   665,   666,   667,
       0,     0,     0,  1161,  1162,  1163,     0,  3492,  3493,  1166,
    1167,  1168,  1169,    86,    87,    88,   403,    90,    91,    92,
     404,     0,   405,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   406,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   407,   408,     0,     0,     0,   409,   410,     0,
       0,     0,     0,   411,     0,     0,     0,     0,     0,     0,
       0,     0,   412,     0,   413,     0,   414,   415,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,  1158,     0,     0,     0,     0,     0,   417,   418,
     419,   420,   421,   422,   423,   424,     0,   425,   426,   427,
       0,     0,     0,     0,     0,     0,     0,   428,   429,     0,
     430,     0,   431,   432,   433,   135,   136,     0,   138,   139,
       0,   434,   435,   436,   437,   438,     0,     0,   439,   440,
     441,   140,   442,     0,   443,  1159,   445,   446,   144,     0,
       0,   447,   448,   449,   450,     0,   451,   452,     0,   453,
     454,   455,   456,   457,   458,     0,   459,   460,   461,     0,
     462,     0,     0,     0,     0,     0,     0,     0,     0,   463,
     464,   465,   466,   467,   468,   154,   155,   469,     0,   470,
       0,   471,   472,   473,   474,   475,     0,   476,   477,   478,
       0,     0,   479,   480,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,     0,   489,   490,   491,   492,   164,
     493,   494,   166,     0,  1160,     0,   496,   168,   497,     0,
     498,     0,   499,     0,     0,     0,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,   507,   508,   509,
       0,   510,   511,   512,     0,   513,   514,   515,   516,   517,
     518,     0,   519,     0,   175,     0,   520,   521,   522,     0,
     177,     0,   178,     0,   523,     0,     0,   524,     0,   525,
     526,   527,   528,   529,   530,     0,   182,     0,   531,     0,
       0,   532,   533,   534,     0,     0,   535,   536,   537,   538,
     539,   540,   541,   542,   543,   544,   545,   546,   547,   189,
       0,   191,   548,   549,   550,   551,   552,   553,   554,   192,
     555,     0,   556,   557,     0,   558,     0,   195,   559,   196,
     560,   561,     0,     0,   562,     0,     0,   563,   564,   565,
       0,     0,   197,     0,     0,     0,   201,   566,   567,   568,
     569,   570,   571,     0,   572,   202,   573,   203,   574,   575,
     576,     0,   577,   578,   579,   580,   581,   582,   583,   205,
     584,   585,   586,     0,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,     0,   599,   600,
     213,   601,   602,   603,   604,   605,   606,   607,   608,     0,
     609,   610,   611,   612,   613,     0,   614,   217,   615,   616,
       0,   617,   220,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,   628,     0,   629,   630,     0,
     631,   632,   633,   634,   635,   636,     0,   224,   225,     0,
       0,   638,   226,   639,   227,     0,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,   235,     0,   655,     0,   656,
     657,   658,     0,     0,   659,     0,     0,   660,   661,   662,
     663,   664,   238,   239,   240,   241,   242,   243,   244,   245,
     665,   666,   667,     0,     0,     0,  1161,  1162,  1163,     0,
    1164,  1165,  1166,  1167,  1168,  1169,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,  1158,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,  1234,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,  1235,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,     0,     0,     0,  1161,
    1162,  1163,     0,  1164,  1165,  1166,  1167,  1168,  1169,    86,
      87,    88,   403,    90,    91,    92,   404,     0,   405,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   406,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   407,   408,
       0,     0,     0,   409,   410,     0,     0,     0,     0,   411,
       0,     0,     0,     0,     0,     0,     0,     0,   412,     0,
     413,     0,   414,   415,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,  1158,     0,
       0,     0,     0,     0,   417,   418,   419,   420,   421,   422,
     423,   424,     0,   425,   426,   427,     0,     0,     0,     0,
       0,     0,     0,   428,   429,     0,   430,     0,   431,   432,
     433,   135,   136,     0,   138,   139,     0,   434,   435,   436,
     437,   438,     0,     0,   439,   440,   441,   140,   442,     0,
     443,  1285,   445,   446,   144,     0,     0,   447,   448,   449,
     450,     0,   451,   452,     0,   453,   454,   455,   456,   457,
     458,     0,   459,   460,   461,     0,   462,     0,     0,     0,
       0,     0,     0,     0,     0,   463,   464,   465,   466,   467,
     468,   154,   155,   469,     0,   470,     0,   471,   472,   473,
     474,   475,     0,   476,   477,   478,     0,     0,   479,   480,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
       0,   489,   490,   491,   492,   164,   493,   494,   166,     0,
    1286,     0,   496,   168,   497,     0,   498,     0,   499,     0,
       0,     0,   500,   501,   502,     0,   503,   172,     0,   504,
       0,   505,   506,   507,   508,  1287,     0,   510,   511,   512,
       0,   513,   514,   515,   516,   517,   518,     0,   519,     0,
     175,     0,   520,   521,   522,     0,   177,     0,   178,     0,
     523,     0,     0,   524,     0,   525,   526,   527,   528,   529,
     530,     0,   182,     0,   531,     0,     0,   532,   533,   534,
       0,     0,   535,   536,   537,   538,   539,   540,   541,   542,
     543,   544,   545,   546,   547,   189,     0,   191,   548,   549,
     550,   551,   552,   553,   554,   192,   555,     0,   556,   557,
       0,   558,     0,   195,   559,   196,   560,   561,     0,     0,
     562,     0,     0,   563,   564,   565,     0,     0,   197,     0,
       0,     0,   201,   566,   567,   568,   569,   570,   571,     0,
     572,   202,   573,   203,   574,   575,   576,     0,   577,   578,
     579,   580,   581,   582,   583,   205,   584,   585,   586,     0,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,     0,   599,   600,   213,   601,   602,   603,
     604,   605,   606,   607,   608,     0,   609,   610,   611,   612,
     613,     0,   614,   217,   615,   616,     0,   617,   220,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,   628,     0,   629,   630,     0,   631,   632,   633,   634,
     635,   636,     0,   224,   225,     0,     0,   638,   226,   639,
     227,     0,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,   235,     0,   655,     0,   656,   657,   658,     0,     0,
     659,     0,     0,   660,   661,   662,   663,   664,   238,   239,
     240,   241,   242,   243,   244,   245,   665,   666,   667,     0,
       0,     0,  1161,  1162,  1163,     0,  1164,  1165,  1166,  1167,
    1168,  1169,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,  1158,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   431,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,  1767,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,  1768,     0,   496,   168,   497,     0,   498,
       0,   499,     0,     0,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   528,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,     0,     0,   562,     0,     0,   563,   564,   565,     0,
       0,   197,     0,     0,     0,   201,   566,   567,   568,   569,
     570,   571,     0,   572,   202,   573,   203,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,   205,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,     0,   599,   600,   213,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,     0,   614,   217,   615,   616,     0,
     617,   220,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,   224,   225,     0,     0,
     638,   226,   639,   227,     0,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,   235,     0,   655,     0,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,   239,   240,   241,   242,   243,   244,   245,   665,
     666,   667,     0,     0,     0,  1161,  1162,  1163,     0,  1164,
    1165,  1166,  1167,  1168,  1169,    86,    87,    88,   403,    90,
      91,    92,   404,     0,   405,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   406,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   407,   408,     0,     0,     0,   409,
     410,     0,     0,     0,     0,   411,     0,     0,     0,     0,
       0,     0,     0,     0,   412,     0,   413,     0,   414,   415,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,  1158,     0,     0,     0,     0,     0,
     417,   418,   419,   420,   421,   422,   423,   424,     0,   425,
     426,   427,     0,     0,     0,     0,     0,     0,     0,   428,
     429,     0,   430,     0,   431,   432,   433,   135,   136,     0,
     138,   139,     0,   434,   435,   436,   437,   438,     0,     0,
     439,   440,   441,   140,   442,     0,   443,   444,   445,   446,
     144,     0,     0,   447,   448,   449,   450,     0,   451,   452,
       0,   453,   454,   455,   456,   457,   458,     0,   459,   460,
     461,     0,   462,     0,     0,     0,     0,     0,     0,     0,
       0,   463,   464,   465,   466,   467,   468,   154,   155,   469,
       0,   470,     0,   471,   472,   473,   474,   475,     0,   476,
     477,   478,     0,     0,   479,   480,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,   491,
     492,   164,   493,   494,   166,     0,   495,     0,   496,   168,
     497,     0,   498,     0,   499,     0,     0,     0,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,   507,
     508,   509,     0,   510,   511,   512,     0,   513,   514,   515,
     516,   517,   518,     0,   519,     0,   175,     0,   520,   521,
     522,     0,   177,     0,   178,     0,   523,     0,     0,   524,
       0,   525,   526,   527,   528,   529,   530,     0,   182,     0,
     531,     0,     0,   532,   533,   534,     0,     0,   535,   536,
     537,   538,   539,   540,   541,   542,   543,   544,   545,   546,
     547,   189,     0,   191,   548,   549,   550,   551,   552,   553,
     554,   192,   555,     0,   556,   557,     0,   558,     0,   195,
     559,   196,   560,   561,     0,     0,   562,     0,     0,   563,
     564,   565,     0,     0,   197,     0,     0,     0,   201,   566,
     567,   568,   569,   570,   571,     0,   572,   202,   573,   203,
     574,   575,   576,     0,   577,   578,   579,   580,   581,   582,
     583,   205,   584,   585,   586,     0,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,     0,
     599,   600,   213,   601,   602,   603,   604,   605,   606,   607,
     608,     0,   609,   610,   611,   612,   613,     0,   614,   217,
     615,   616,     0,   617,   220,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,   628,     0,   629,
     630,     0,   631,   632,   633,   634,   635,   636,     0,   224,
     225,     0,     0,   638,   226,   639,   227,     0,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,   235,     0,   655,
       0,   656,   657,   658,     0,     0,   659,     0,     0,   660,
     661,   662,   663,   664,   238,   239,   240,   241,   242,   243,
     244,   245,   665,   666,   667,     0,     0,     0,  1161,  1162,
    1163,     0,  1164,  1165,  1166,  1167,  1168,  1169,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,     0,   104,   105,
     406,     0,     0,   107,   108,   109,   110,     0,     0,   112,
     113,   114,   115,     0,   116,     0,     0,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,  1158,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,     0,   431,   432,   433,
     135,   136,     0,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
       0,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,     0,   462,     0,     0,     0,     0,
       0,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,     0,     0,
       0,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,   509,     0,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,     0,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
       0,     0,   524,     0,   525,   526,   527,   528,   529,   530,
       0,   182,     0,   531,     0,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,     0,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,     0,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,  4215,   564,   565,     0,     0,   197,     0,     0,
       0,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,     0,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,     0,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,     0,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,     0,     0,
       0,  1161,  1162,  1163,     0,  1164,  1165,  1166,  1167,  1168,
    1169,   704,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   705,   104,   105,   406,   706,     0,   107,   108,   109,
     110,   707,   708,   112,   113,   114,   115,     0,   116,   709,
     710,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,   711,   425,   426,   427,   712,
     713,   714,   715,   716,   717,   718,   428,   429,   719,   430,
     133,   431,   432,   433,   135,   136,   137,   138,   139,   720,
     434,   435,   436,   437,   438,   721,   722,   439,   440,   723,
     140,   442,   724,   443,   444,   445,   446,   144,   725,   726,
     447,   448,   449,   450,   147,   451,   727,   728,   453,   454,
     455,   456,   457,   458,   729,   459,   460,   461,   150,   462,
     730,   731,   732,   733,   151,   734,   735,   736,   463,   464,
     465,   466,   467,   468,   154,   155,   469,   737,   470,   738,
     471,   472,   473,   474,   475,   739,   476,   477,   478,   740,
     741,   479,   480,   481,   482,   483,   742,   484,   485,   486,
     743,   487,   488,   744,   489,   490,   491,   492,   164,   493,
     494,   166,   745,   495,   746,   496,   168,   497,   747,   498,
     748,   499,   169,   749,   170,   500,   501,   502,   750,   503,
     172,   751,   504,   752,   505,   506,   507,   508,   509,   173,
     510,   511,   512,   753,   513,   514,   515,   516,   517,   518,
     754,   519,   174,   175,   755,   520,   521,   522,   756,   177,
     757,   178,   758,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,   759,   182,   183,   531,   184,   760,
     532,   533,   534,   761,   762,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,   190,
     191,   548,   549,   550,   551,   552,   553,   554,   192,   555,
     763,   556,   557,   194,   558,   764,   195,   559,   196,   560,
     561,   765,   766,   562,   767,   768,   563,   564,   565,   769,
     770,   197,   198,   199,   200,   201,   566,   567,   568,   569,
     570,   571,   771,   572,   202,   573,   203,   574,   575,   576,
     772,   577,   578,   579,   580,   581,   582,   583,   205,   584,
     585,   586,   773,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,   774,   597,   598,   211,   599,   600,   213,
     601,   602,   603,   604,   605,   606,   607,   608,   775,   609,
     610,   611,   612,   613,   776,   614,   217,   615,   616,   219,
     617,   220,   777,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,   628,   778,   629,   630,   779,   631,
     632,   633,   634,   635,   636,   780,   224,   225,   781,   782,
     638,   226,   639,   227,   783,   640,   641,   642,   643,   644,
     645,   784,   785,   646,   647,   648,   649,   786,   787,   650,
     651,   652,   653,   788,   235,   789,   655,   236,   656,   657,
     658,   790,   791,   659,   792,   793,   660,   661,   662,   663,
     664,   238,   239,   240,   241,   242,   243,   244,   245,   665,
     666,   667,   704,    86,    87,    88,   403,    90,    91,    92,
     404,  2153,   405,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   705,   104,   105,   406,   706,     0,   107,   108,
     109,   110,   707,   708,   112,   113,   114,   115,     0,   116,
     709,   710,   407,   408,     0,     0,     0,   409,   410,     0,
       0,     0,     0,   411,     0,     0,     0,     0,     0,     0,
       0,     0,   412,     0,   413,     0,   414,   415,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   417,   418,
     419,   420,   421,   422,   423,   424,     0,   425,   426,   427,
       0,     0,     0,     0,     0,     0,     0,   428,   429,     0,
     430,   133,   431,   432,   433,     0,  1784,   137,  1785,  1786,
       0,   434,   435,   436,   437,   438,     0,     0,   439,   440,
    1787,  1788,   442,     0,   443,   444,   445,   446,     0,     0,
       0,   447,   448,   449,   450,   147,   451,   452,     0,   453,
     454,   455,   456,   457,   458,     0,   459,   460,   461,   150,
     462,     0,     0,     0,     0,   151,     0,     0,     0,   463,
     464,   465,   466,   467,   468,  1789,  1790,   469,     0,   470,
       0,   471,   472,   473,   474,   475,     0,   476,   477,   478,
       0,     0,   479,   480,  1419,   482,   483,     0,   484,   485,
     486,     0,   487,   488,     0,   489,   490,   491,   492,     0,
     493,   494,     0,     0,   495,     0,   496,  1791,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,     0,     0,   504,     0,   505,   506,   507,   508,   509,
     173,   510,   511,   512,     0,   513,   514,   515,   516,   517,
     518,     0,   519,   174,     0,     0,   520,   521,   522,  1425,
    1792,     0,  1793,     0,   523,   179,   180,   524,   181,   525,
     526,   527,   528,   529,   530,     0,     0,   183,   531,   184,
       0,   532,   533,   534,     0,     0,   535,   536,   537,   538,
     539,   540,   541,   542,   543,   544,   545,   546,   547,  1794,
     190,  1795,   548,   549,   550,   551,   552,   553,   554,     0,
     555,     0,   556,   557,   194,   558,     0,     0,   559,  1796,
     560,   561,     0,     0,   562,     0,     0,   563,   564,   565,
       0,     0,     0,   198,   199,   200,     0,   566,   567,   568,
     569,   570,   571,     0,   572,     0,   573,     0,   574,   575,
     576,     0,   577,   578,   579,   580,   581,   582,   583,  1797,
     584,   585,   586,     0,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   211,   599,   600,
       0,   601,   602,   603,   604,   605,   606,   607,   608,     0,
     609,   610,   611,   612,   613,     0,   614,  1798,   615,   616,
     219,   617,  1799,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,     0,   628,     0,   629,   630,     0,
     631,   632,   633,   634,   635,   636,     0,  1800,  1801,     0,
       0,   638,     0,   639,     0,     0,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,     0,  1802,     0,   655,   236,   656,
     657,   658,     0,     0,   659,     0,     0,   660,   661,   662,
     663,   664,     0,     0,     0,     0,     0,     0,     0,     0,
     665,   666,   667,     0,    86,    87,    88,   403,    90,    91,
      92,   404,  2255,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   406,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,     0,     0,     0,   428,   429,
       0,   430,     0,   431,   432,   433,   135,   136,     0,   138,
     139,     0,   434,   435,   436,   437,   438,     0,     0,   439,
     440,   441,   140,   442,     0,   443,   444,   445,   446,   144,
       0,     0,   447,   448,   449,   450,     0,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
       0,   462,     0,     0,     0,     0,     0,     0,     0,     0,
     463,   464,   465,   466,   467,   468,   154,   155,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
     164,   493,   494,   166,     0,   495,     0,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   507,   508,
     509,     0,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,     0,   175,     0,   520,   521,   522,
       0,   177,     0,   178,     0,   523,     0,     0,   524,     0,
     525,   526,   527,   528,   529,   530,     0,   182,     0,   531,
       0,     0,   532,   533,   534,     0,     0,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,     0,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,     0,   558,     0,   195,   559,
     196,   560,   561,     0,     0,   562,     0,     0,   563,   564,
     565,     0,     0,   197,     0,     0,     0,   201,   566,   567,
     568,   569,   570,   571,     0,   572,   202,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
     205,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   213,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,     0,   614,   217,   615,
     616,     0,   617,   220,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,   224,   225,
       0,     0,   638,   226,   639,   227,     0,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,   235,     0,   655,     0,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,   239,   240,   241,   242,   243,   244,
     245,   665,   666,   667,     0,    86,    87,    88,   403,    90,
      91,    92,   404,  1051,   405,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   406,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   407,   408,     0,     0,     0,   409,
     410,     0,     0,     0,     0,   411,     0,     0,     0,     0,
       0,     0,     0,     0,   412,     0,   413,     0,   414,   415,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     417,   418,   419,   420,   421,   422,   423,   424,     0,   425,
     426,   427,     0,     0,     0,     0,     0,     0,     0,   428,
     429,     0,   430,     0,   431,   432,   433,   135,   136,     0,
     138,   139,     0,   434,   435,   436,   437,   438,     0,     0,
     439,   440,   441,   140,   442,     0,   443,   444,   445,   446,
     144,     0,     0,   447,   448,   449,   450,     0,   451,   452,
       0,   453,   454,   455,   456,   457,   458,     0,   459,   460,
     461,     0,   462,     0,     0,     0,     0,     0,     0,     0,
       0,   463,   464,   465,   466,   467,   468,   154,   155,   469,
       0,   470,     0,   471,   472,   473,   474,   475,     0,   476,
     477,   478,     0,     0,   479,   480,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,   491,
     492,   164,   493,   494,   166,     0,   495,     0,   496,   168,
     497,     0,   498,     0,   499,     0,     0,     0,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,   507,
     508,   509,     0,   510,   511,   512,     0,   513,   514,   515,
     516,   517,   518,     0,   519,     0,   175,     0,   520,   521,
     522,     0,   177,     0,   178,     0,   523,     0,     0,   524,
       0,   525,   526,   527,   528,   529,   530,     0,   182,     0,
     531,     0,     0,   532,   533,   534,     0,     0,   535,   536,
     537,   538,   539,   540,   541,   542,   543,   544,   545,   546,
     547,   189,     0,   191,   548,   549,   550,   551,   552,   553,
     554,   192,   555,     0,   556,   557,     0,   558,     0,   195,
     559,   196,   560,   561,     0,     0,   562,     0,     0,   563,
     564,   565,     0,     0,   197,     0,     0,     0,   201,   566,
     567,   568,   569,   570,   571,     0,   572,   202,   573,   203,
     574,   575,   576,     0,   577,   578,   579,   580,   581,   582,
     583,   205,   584,   585,   586,     0,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,     0,
     599,   600,   213,   601,   602,   603,   604,   605,   606,   607,
     608,     0,   609,   610,   611,   612,   613,     0,   614,   217,
     615,   616,     0,   617,   220,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,   628,     0,   629,
     630,     0,   631,   632,   633,   634,   635,   636,     0,   224,
     225,     0,     0,   638,   226,   639,   227,     0,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,   235,     0,   655,
       0,   656,   657,   658,     0,     0,   659,     0,     0,   660,
     661,   662,   663,   664,   238,   239,   240,   241,   242,   243,
     244,   245,   665,   666,   667,     0,    86,    87,    88,   403,
      90,    91,    92,   404,  4093,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,     0,     0,     0,    45,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,  2140,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,  1927,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,  1928,     0,   562,  1929,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,  1930,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,     0,     0,     0,     0,
       0,     0,     0,   962,  1595,    86,    87,    88,   403,    90,
      91,    92,   404,     0,   405,    95,     0,     0,    98,    99,
     100,   101,   102,   103,     0,   104,   105,   406,     0,     0,
     107,   108,   109,   110,     0,     0,   112,   113,   114,   115,
       0,   116,     0,     0,   407,   408,     0,     0,     0,   409,
     410,     0,     0,     0,     0,   411,     0,     0,     0,     0,
       0,     0,     0,     0,   412,     0,   413,     0,   414,   415,
      35,   416,     0,     0,    37,    38,    39,    40,    41,    42,
      43,    44,     0,     0,     0,    45,     0,     0,     0,     0,
     417,   418,   419,   420,   421,   422,   423,   424,     0,   425,
     426,   427,     0,     0,     0,     0,     0,     0,     0,   428,
     429,     0,   430,     0,   431,   432,   433,   135,   136,     0,
     138,   139,     0,   434,   435,   436,   437,   438,     0,     0,
     439,   440,   441,   140,   442,     0,   443,   444,   445,   446,
     144,     0,     0,   447,   448,   449,   450,     0,   451,   452,
       0,   453,   454,   455,   456,   457,   458,     0,   459,   460,
     461,     0,   462,     0,     0,     0,     0,     0,     0,     0,
       0,   463,   464,   465,   466,   467,   468,   154,   155,   469,
    2146,   470,     0,   471,   472,   473,   474,   475,     0,   476,
     477,   478,     0,     0,   479,   480,   481,   482,   483,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,   491,
     492,   164,   493,   494,   166,  1927,   495,     0,   496,   168,
     497,     0,   498,     0,   499,     0,     0,     0,   500,   501,
     502,     0,   503,   172,     0,   504,     0,   505,   506,   507,
     508,   509,     0,   510,   511,   512,     0,   513,   514,   515,
     516,   517,   518,     0,   519,     0,   175,     0,   520,   521,
     522,     0,   177,     0,   178,     0,   523,     0,     0,   524,
       0,   525,   526,   527,   528,   529,   530,     0,   182,     0,
     531,     0,     0,   532,   533,   534,     0,     0,   535,   536,
     537,   538,   539,   540,   541,   542,   543,   544,   545,   546,
     547,   189,     0,   191,   548,   549,   550,   551,   552,   553,
     554,   192,   555,     0,   556,   557,     0,   558,     0,   195,
     559,   196,   560,   561,  1928,     0,   562,  1929,     0,   563,
     564,   565,     0,     0,   197,     0,     0,     0,   201,   566,
     567,   568,   569,   570,   571,     0,   572,   202,   573,   203,
     574,   575,   576,     0,   577,   578,   579,   580,   581,   582,
     583,   205,   584,   585,   586,     0,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,     0,
     599,   600,   213,   601,   602,   603,   604,   605,   606,   607,
     608,     0,   609,   610,   611,   612,   613,     0,   614,   217,
     615,   616,     0,   617,   220,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,   628,     0,   629,
     630,     0,   631,   632,   633,   634,   635,   636,     0,   224,
     225,     0,     0,   638,   226,   639,   227,  1930,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,   654,   235,     0,   655,
       0,   656,   657,   658,     0,     0,   659,     0,     0,   660,
     661,   662,   663,   664,   238,   239,   240,   241,   242,   243,
     244,   245,   665,   666,   667,     0,     0,     0,     0,     0,
       0,     0,   962,  1595,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,   406,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
     416,     0,     0,    37,    38,    39,    40,    41,    42,    43,
      44,     0,     0,     0,    45,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,     0,     0,     0,   428,   429,
       0,   430,     0,   431,   432,   433,   135,   136,     0,   138,
     139,     0,   434,   435,   436,   437,   438,     0,     0,   439,
     440,   441,   140,   442,     0,   443,   444,   445,   446,   144,
       0,     0,   447,   448,   449,   450,     0,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
       0,   462,     0,     0,     0,     0,     0,     0,     0,     0,
     463,   464,   465,   466,   467,   468,   154,   155,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,   481,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
     164,   493,   494,   166,  1927,   495,     0,   496,   168,   497,
       0,   498,     0,   499,     0,     0,     0,   500,   501,   502,
       0,   503,   172,     0,   504,     0,   505,   506,   507,   508,
     509,     0,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,     0,   175,     0,   520,   521,   522,
       0,   177,     0,   178,     0,   523,     0,     0,   524,     0,
     525,   526,   527,   528,   529,   530,     0,   182,     0,   531,
       0,     0,   532,   533,   534,     0,     0,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,     0,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,     0,   556,   557,     0,   558,     0,   195,   559,
     196,   560,   561,  1928,     0,   562,  1929,     0,   563,   564,
     565,     0,     0,   197,     0,     0,     0,   201,   566,   567,
     568,   569,   570,   571,     0,   572,   202,   573,   203,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
     205,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,     0,   599,
     600,   213,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,     0,   614,   217,   615,
     616,     0,   617,   220,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,   224,   225,
       0,     0,   638,   226,   639,   227,  1930,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,   654,   235,     0,   655,     0,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,   238,   239,   240,   241,   242,   243,   244,
     245,   665,   666,   667,     0,     0,     0,     0,     0,     0,
       0,   962,  1595,    86,    87,    88,   403,    90,    91,    92,
     404,     0,   405,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   406,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   407,   408,     0,     0,     0,   409,   410,     0,
       0,     0,     0,   411,     0,     0,     0,     0,     0,     0,
       0,     0,   412,     0,   413,     0,   414,   415,    35,   416,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,    45,     0,     0,     0,     0,   417,   951,
     419,   420,   421,   422,   423,   424,   952,   425,   426,   427,
       0,     0,     0,     0,     0,     0,     0,   428,   429,     0,
     430,     0,   953,   432,   433,   135,   136,     0,   138,   139,
       0,   434,   435,   436,   437,   438,     0,     0,   439,   440,
     441,   140,   442,     0,   443,   444,   445,   446,   144,     0,
       0,   447,   448,   449,   450,     0,   451,   452,     0,   453,
     454,   455,   456,   457,   458,     0,   459,   460,   461,     0,
     462,     0,     0,     0,     0,     0,     0,     0,     0,   463,
     464,   465,   466,   467,   468,   154,   155,   469,     0,   470,
       0,   471,   472,   473,   474,   475,     0,   476,   477,   478,
       0,     0,   479,   480,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,     0,   489,   490,   491,   492,   164,
     493,   494,   166,     0,   495,     0,   954,   168,   497,     0,
     498,     0,   955,     0,   956,     0,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,   507,   508,   509,
       0,   510,   511,   512,   957,   513,   514,   515,   516,   517,
     518,     0,   519,     0,   175,     0,   520,   521,   522,     0,
     177,     0,   178,     0,   523,     0,     0,   524,     0,   525,
     526,   527,   958,   529,   530,     0,   182,     0,   531,     0,
       0,   532,   533,   534,     0,     0,   535,   536,   537,   538,
     539,   540,   541,   542,   543,   544,   545,   546,   547,   189,
       0,   191,   959,   549,   550,   551,   552,   553,   554,   192,
     555,     0,   556,   557,     0,   558,     0,   195,   559,   196,
     560,   561,     0,     0,   562,     0,     0,   563,   564,   565,
       0,     0,   197,     0,     0,     0,   201,   566,   567,   568,
     569,   570,   571,     0,   572,   202,   573,   203,   574,   575,
     576,     0,   960,   578,   579,   580,   581,   582,   583,   205,
     584,   585,   586,     0,   587,   961,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,     0,   599,   600,
     213,   601,   602,   603,   604,   605,   606,   607,   608,     0,
     609,   610,   611,   612,   613,     0,   614,   217,   615,   616,
       0,   617,   220,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,   628,     0,   629,   630,     0,
     631,   632,   633,   634,   635,   636,     0,   224,   225,     0,
       0,   638,   226,   639,   227,     0,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,   654,   235,     0,   655,     0,   656,
     657,   658,     0,     0,   659,     0,     0,   660,   661,   662,
     663,   664,   238,   239,   240,   241,   242,   243,   244,   245,
     665,   666,   667,     0,     0,     0,     0,     0,     0,     0,
     962,   963,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,     0,   104,   105,   406,     0,     0,   107,   108,   109,
     110,     0,     0,   112,   113,   114,   115,     0,   116,     0,
       0,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,   416,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,    45,     0,     0,     0,     0,   417,   951,   419,
     420,   421,   422,   423,   424,   952,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
       0,   985,   432,   433,   135,   136,     0,   138,   139,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,   441,
     140,   442,     0,   443,   444,   445,   446,   144,     0,     0,
     447,   448,   449,   450,     0,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,     0,   462,
       0,     0,     0,     0,     0,     0,     0,     0,   463,   464,
     465,   466,   467,   468,   154,   155,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,   481,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,   164,   493,
     494,   166,     0,   495,     0,   954,   168,   497,     0,   498,
       0,   986,     0,   956,     0,   500,   501,   502,     0,   503,
     172,     0,   504,     0,   505,   506,   507,   508,   509,     0,
     510,   511,   512,   957,   513,   514,   515,   516,   517,   518,
       0,   519,     0,   175,     0,   520,   521,   522,     0,   177,
       0,   178,     0,   523,     0,     0,   524,     0,   525,   526,
     527,   958,   529,   530,     0,   182,     0,   531,     0,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,   189,     0,
     191,   959,   549,   550,   551,   552,   553,   554,   192,   555,
       0,   556,   557,     0,   558,     0,   195,   559,   196,   560,
     561,     0,     0,   562,     0,     0,   563,   564,   565,     0,
       0,   197,     0,     0,     0,   201,   566,   567,   568,   569,
     570,   571,     0,   572,   202,   573,   203,   574,   575,   576,
       0,   960,   578,   579,   580,   581,   582,   583,   205,   584,
     585,   586,     0,   587,   961,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,     0,   599,   600,   213,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,     0,   614,   217,   615,   616,     0,
     617,   220,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,   222,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,   224,   225,     0,     0,
     638,   226,   639,   227,     0,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,   654,   235,     0,   655,     0,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,   238,   239,   240,   241,   242,   243,   244,   245,   665,
     666,   667,     0,     0,     0,     0,     0,     0,     0,   962,
     963,    86,    87,    88,   403,    90,    91,    92,   404,     0,
     405,    95,     0,     0,    98,    99,   100,   101,   102,   103,
       0,   104,   105,   406,     0,     0,   107,   108,   109,   110,
       0,     0,   112,   113,   114,   115,     0,   116,     0,     0,
     407,   408,     0,     0,     0,   409,   410,     0,     0,     0,
       0,   411,     0,     0,     0,     0,     0,     0,     0,     0,
     412,     0,   413,     0,   414,   415,    35,   416,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,    45,     0,     0,     0,     0,   417,   418,   419,   420,
     421,   422,   423,   424,  1335,   425,   426,   427,     0,     0,
       0,     0,     0,     0,     0,   428,   429,     0,   430,     0,
     431,   432,   433,   135,   136,     0,   138,   139,     0,   434,
     435,   436,   437,   438,     0,     0,   439,   440,   441,   140,
     442,     0,   443,   444,   445,   446,   144,     0,     0,   447,
     448,   449,   450,     0,   451,   452,     0,   453,   454,   455,
     456,   457,   458,     0,   459,   460,   461,     0,   462,     0,
       0,     0,     0,     0,     0,     0,     0,   463,   464,   465,
     466,   467,   468,   154,   155,   469,     0,   470,     0,   471,
     472,   473,   474,   475,     0,   476,   477,   478,     0,     0,
     479,   480,   481,   482,   483,     0,   484,   485,   486,     0,
     487,   488,     0,   489,   490,   491,   492,   164,   493,   494,
     166,     0,   495,     0,   496,   168,   497,     0,   498,     0,
     499,     0,   956,     0,   500,   501,   502,     0,   503,   172,
       0,   504,     0,   505,   506,   507,   508,   509,     0,   510,
     511,   512,   957,   513,   514,   515,   516,   517,   518,     0,
     519,     0,   175,     0,   520,   521,   522,     0,   177,     0,
     178,     0,   523,     0,     0,   524,     0,   525,   526,   527,
     528,   529,   530,     0,   182,     0,   531,     0,     0,   532,
     533,   534,     0,     0,   535,   536,   537,   538,   539,   540,
     541,   542,   543,   544,   545,   546,   547,   189,     0,   191,
     548,   549,   550,   551,   552,   553,   554,   192,   555,     0,
     556,   557,     0,   558,     0,   195,   559,   196,   560,   561,
       0,     0,   562,     0,     0,   563,   564,   565,     0,     0,
     197,     0,     0,     0,   201,   566,   567,   568,   569,   570,
     571,     0,   572,   202,   573,   203,   574,   575,   576,     0,
     577,   578,   579,   580,   581,   582,   583,   205,   584,   585,
     586,     0,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,     0,   599,   600,   213,   601,
     602,   603,   604,   605,   606,   607,   608,     0,   609,   610,
     611,   612,   613,     0,   614,   217,   615,   616,     0,   617,
     220,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,   222,   628,     0,   629,   630,     0,   631,   632,
     633,   634,   635,   636,     0,   224,   225,     0,     0,   638,
     226,   639,   227,     0,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,   654,   235,     0,   655,     0,   656,   657,   658,
       0,     0,   659,     0,     0,   660,   661,   662,   663,   664,
     238,   239,   240,   241,   242,   243,   244,   245,   665,   666,
     667,     0,     0,     0,     0,     0,     0,     0,   962,   963,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,   406,     0,     0,   107,   108,   109,   110,     0,
       0,   112,   113,   114,   115,     0,   116,     0,     0,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,   416,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
      45,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,  1340,   425,   426,   427,     0,     0,     0,
       0,     0,     0,     0,   428,   429,     0,   430,     0,   431,
     432,   433,   135,   136,     0,   138,   139,     0,   434,   435,
     436,   437,   438,     0,     0,   439,   440,   441,   140,   442,
       0,   443,   444,   445,   446,   144,     0,     0,   447,   448,
     449,   450,     0,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,     0,   462,     0,     0,
       0,     0,     0,     0,     0,     0,   463,   464,   465,   466,
     467,   468,   154,   155,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,   481,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,   164,   493,   494,   166,
       0,   495,     0,   496,   168,   497,     0,   498,     0,   499,
       0,   956,     0,   500,   501,   502,     0,   503,   172,     0,
     504,     0,   505,   506,   507,   508,   509,     0,   510,   511,
     512,   957,   513,   514,   515,   516,   517,   518,     0,   519,
       0,   175,     0,   520,   521,   522,     0,   177,     0,   178,
       0,   523,     0,     0,   524,     0,   525,   526,   527,   528,
     529,   530,     0,   182,     0,   531,     0,     0,   532,   533,
     534,     0,     0,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,   189,     0,   191,   548,
     549,   550,   551,   552,   553,   554,   192,   555,     0,   556,
     557,     0,   558,     0,   195,   559,   196,   560,   561,     0,
       0,   562,     0,     0,   563,   564,   565,     0,     0,   197,
       0,     0,     0,   201,   566,   567,   568,   569,   570,   571,
       0,   572,   202,   573,   203,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,   205,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,     0,   599,   600,   213,   601,   602,
     603,   604,   605,   606,   607,   608,     0,   609,   610,   611,
     612,   613,     0,   614,   217,   615,   616,     0,   617,   220,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,   222,   628,     0,   629,   630,     0,   631,   632,   633,
     634,   635,   636,     0,   224,   225,     0,     0,   638,   226,
     639,   227,     0,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,   654,   235,     0,   655,     0,   656,   657,   658,     0,
       0,   659,     0,     0,   660,   661,   662,   663,   664,   238,
     239,   240,   241,   242,   243,   244,   245,   665,   666,   667,
       0,     0,     0,     0,     0,     0,     0,   962,   963,    86,
      87,    88,   403,    90,    91,    92,   404,     0,   405,    95,
       0,     0,    98,    99,   100,   101,   102,   103,     0,   104,
     105,   406,     0,     0,   107,   108,   109,   110,     0,     0,
     112,   113,   114,   115,     0,   116,     0,     0,   407,   408,
       0,     0,     0,   409,   410,     0,     0,     0,     0,   411,
       0,     0,     0,     0,     0,     0,     0,     0,   412,     0,
     413,     0,   414,   415,    35,   416,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   417,   418,   419,   420,   421,   422,
     423,   424,     0,   425,   426,   427,     0,     0,     0,     0,
       0,     0,     0,   428,   429,     0,   430,     0,   431,   432,
     433,   135,   136,     0,   138,   139,     0,   434,   435,   436,
     437,   438,     0,     0,   439,   440,   441,   140,   442,     0,
     443,   444,   445,   446,   144,     0,     0,   447,   448,   449,
     450,     0,   451,   452,     0,   453,   454,   455,   456,   457,
     458,     0,   459,   460,   461,     0,   462,     0,     0,     0,
       0,     0,     0,     0,     0,   463,   464,   465,   466,   467,
     468,   154,   155,   469,   689,   470,     0,   471,   472,   473,
     474,   475,     0,   476,   477,   478,     0,     0,   479,   480,
     481,   482,   483,     0,   484,   485,   486,     0,   487,   488,
       0,   489,   490,   491,   492,   164,   493,   494,   166,     0,
     495,     0,   496,   168,   497,     0,   498,     0,   499,     0,
       0,     0,   500,   501,   502,     0,   503,   172,     0,   504,
       0,   505,   506,   507,   508,   509,     0,   510,   511,   512,
       0,   513,   514,   515,   516,   517,   518,     0,   519,     0,
     175,     0,   520,   521,   522,     0,   177,     0,   178,     0,
     523,     0,     0,   524,     0,   525,   526,   527,   528,   529,
     530,     0,   182,     0,   531,     0,     0,   532,   533,   534,
       0,     0,   535,   536,   537,   538,   539,   540,   541,   542,
     543,   544,   545,   546,   547,   189,     0,   191,   548,   549,
     550,   551,   552,   553,   554,   192,   555,     0,   556,   557,
       0,   558,     0,   195,   559,   196,   560,   561,     0,     0,
     562,     0,     0,   563,   564,   565,     0,     0,   197,     0,
       0,     0,   201,   566,   567,   568,   569,   570,   571,     0,
     572,   202,   573,   203,   574,   575,   576,     0,   577,   578,
     579,   580,   581,   582,   583,   205,   584,   585,   586,     0,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,     0,   599,   600,   213,   601,   602,   603,
     604,   605,   606,   607,   608,     0,   609,   610,   611,   612,
     613,     0,   614,   217,   615,   616,     0,   617,   220,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
     222,   628,     0,   629,   630,     0,   631,   632,   633,   634,
     635,   636,     0,   224,   225,  1500,     0,   638,   226,   639,
     227,     0,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
     654,   235,     0,   655,     0,   656,   657,   658,     0,     0,
     659,     0,     0,   660,   661,   662,   663,   664,   238,   239,
     240,   241,   242,   243,   244,   245,   665,   666,   667,     0,
       0,  1023,  1501,    86,    87,    88,   403,    90,    91,    92,
     404,  1024,   405,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,   406,     0,     0,   107,   108,
     109,   110,     0,     0,   112,   113,   114,   115,     0,   116,
       0,     0,   407,   408,     0,     0,     0,   409,   410,     0,
       0,     0,     0,   411,     0,     0,     0,     0,     0,     0,
       0,     0,   412,     0,   413,     0,   414,   415,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   417,   418,
     419,   420,   421,   422,   423,   424,     0,   425,   426,   427,
       0,     0,     0,     0,     0,     0,     0,   428,   429,     0,
     430,     0,   431,   432,   433,   135,   136,     0,   138,   139,
       0,   434,   435,   436,   437,   438,     0,     0,  1025,   440,
    1000,   140,   442,     0,   443,   444,   445,   446,   144,     0,
       0,   447,   448,   449,   450,     0,   451,  1026,     0,  1027,
     454,   455,   456,   457,   458,     0,   459,   460,   461,     0,
     462,     0,     0,     0,     0,     0,     0,     0,     0,   463,
     464,   465,   466,   467,   468,   154,   155,   469,     0,   470,
       0,   471,   472,   473,   474,   475,     0,   476,   477,   478,
       0,     0,   479,   480,   481,   482,   483,     0,   484,   485,
     486,     0,   487,   488,     0,   489,   490,   491,   492,   164,
     493,   494,   166,     0,   495,     0,   496,   168,   497,     0,
     498,     0,   499,     0,     0,     0,   500,   501,   502,     0,
     503,   172,     0,   504,     0,   505,   506,   507,   508,   509,
       0,   510,   511,   512,     0,   513,   514,   515,   516,   517,
     518,     0,   519,     0,   175,     0,   520,   521,   522,     0,
     177,     0,   178,     0,   523,     0,     0,   524,     0,   525,
     526,   527,   528,   529,   530,     0,   182,     0,   531,     0,
       0,   532,   533,  1028,     0,     0,   535,   536,   537,   538,
     539,   540,   541,   542,   543,   544,   545,   546,  1029,   189,
       0,   191,   548,   549,   550,   551,   552,   553,   554,   192,
     555,     0,   556,   557,     0,   558,     0,   195,   559,   196,
     560,   561,     0,     0,   562,     0,     0,   563,   564,   565,
       0,     0,   197,     0,     0,     0,   201,   566,   567,   568,
     569,   570,   571,     0,   572,   202,   573,   203,   574,   575,
     576,     0,   577,   578,   579,   580,   581,   582,   583,   205,
     584,   585,   586,     0,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,     0,  1030,   600,
     213,   601,   602,   603,  1031,   605,   606,   607,   608,     0,
     609,   610,   611,   612,  1032,     0,   614,   217,   615,   616,
       0,   617,   220,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,   222,   628,     0,   629,   630,     0,
     631,   632,   633,   634,   635,   636,     0,  1033,   225,     0,
       0,  1034,   226,   639,   227,     0,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,  1004,   235,     0,   655,     0,   656,
     657,   658,     0,     0,   659,     0,     0,   660,   661,   662,
     663,  1035,   238,   239,   240,   241,   242,   243,   244,   245,
     665,   666,   667,   704,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   705,   104,   105,   406,   706,     0,   107,
     108,   109,   110,   707,   708,   112,   113,   114,   115,     0,
     116,   709,   710,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,   711,   425,   426,
     427,   712,   713,   714,   715,   716,   717,   718,   428,   429,
     719,   430,   133,   431,   432,   433,   135,   136,   137,   138,
     139,   720,   434,   435,   436,   437,   438,   721,   722,   439,
     440,   723,   140,   442,   724,   443,   444,   445,   446,   144,
     725,   726,   447,   448,   449,   450,   147,   451,   727,   728,
     453,   454,   455,   456,   457,   458,   729,   459,   460,   461,
     150,   462,   730,   731,   732,   733,   151,   734,   735,   736,
     463,   464,   465,   466,   467,   468,   154,   155,   469,   737,
     470,   738,   471,   472,   473,   474,   475,   739,   476,   477,
     478,   740,   741,   479,   480,   481,   482,   483,   742,   484,
     485,   486,   743,   487,   488,   744,   489,   490,   491,   492,
     164,   493,   494,   166,   745,   495,   746,   496,   168,   497,
     747,   498,   748,   499,   169,   749,   170,   500,   501,   502,
     750,   503,   172,   751,   504,   752,   505,   506,   507,   508,
     509,   173,   510,   511,   512,   753,   513,   514,   515,   516,
     517,   518,   754,   519,   174,   175,   755,   520,   521,   522,
     756,   177,   757,   178,   758,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,   759,   182,   183,   531,
     184,   760,   532,   533,   534,   761,   762,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
     189,   190,   191,   548,   549,   550,   551,   552,   553,   554,
     192,   555,   763,   556,   557,   194,   558,   764,   195,   559,
     196,   560,   561,   765,   766,   562,   767,   768,   563,   564,
     565,   769,   770,   197,   198,   199,   200,   201,   566,   567,
     568,   569,   570,   571,   771,   572,   202,   573,   203,   574,
     575,   576,   772,   577,   578,   579,   580,   581,   582,   583,
     205,   584,   585,   586,   773,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,   774,   597,   598,   211,   599,
     600,   213,   601,   602,   603,   604,   605,   606,   607,   608,
     775,   609,   610,   611,   612,   613,   776,   614,   217,   615,
     616,   219,   617,   220,   777,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,   222,   628,   778,   629,   630,
     779,   631,   632,   633,   634,   635,   636,   780,   224,   225,
     781,   782,   638,   226,   639,   227,   783,   640,   641,   642,
     643,   644,   645,   784,   785,   646,   647,   648,   649,   786,
     787,   650,   651,   652,   653,   788,   235,   789,   655,   236,
     656,   657,   658,   790,   791,   659,   792,   793,   660,   661,
     662,   663,   664,   238,   239,   240,   241,   242,   243,   244,
     245,   665,   666,   667,   704,    86,    87,    88,   403,    90,
      91,    92,   404,     0,   405,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   705,   104,   105,   406,   706,     0,
     107,   108,   109,   110,   707,   708,   112,   113,   114,   115,
       0,   116,   709,   710,   407,   408,     0,     0,     0,   409,
     410,     0,     0,     0,     0,   411,     0,     0,     0,     0,
       0,     0,     0,     0,   412,     0,   413,     0,   414,   415,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     417,   418,   419,   420,  2962,   422,   423,   424,   711,   425,
     426,   427,   712,   713,   714,   715,   716,   717,   718,   428,
     429,   719,   430,   133,   431,   432,   433,   135,   136,   137,
     138,   139,   720,   434,   435,   436,   437,   438,   721,   722,
     439,   440,   723,   140,   442,   724,   443,   444,   445,   446,
     144,   725,   726,   447,   448,   449,   450,   147,   451,   727,
     728,   453,   454,   455,   456,   457,   458,   729,   459,   460,
     461,   150,   462,   730,   731,   732,   733,   151,   734,   735,
     736,   463,   464,   465,   466,   467,   468,   154,   155,   469,
     737,   470,   738,   471,   472,   473,   474,   475,   739,   476,
     477,   478,   740,   741,   479,   480,   481,  2963,   483,   742,
     484,   485,   486,   743,   487,   488,   744,   489,   490,   491,
     492,   164,   493,   494,   166,   745,   495,   746,   496,   168,
     497,   747,   498,   748,   499,   169,   749,   170,   500,   501,
     502,   750,   503,   172,   751,   504,   752,   505,   506,   507,
     508,   509,   173,   510,   511,   512,   753,   513,   514,   515,
     516,   517,   518,   754,   519,   174,   175,   755,   520,   521,
     522,   756,   177,   757,   178,   758,   523,   179,   180,   524,
     181,   525,   526,   527,   528,   529,   530,   759,   182,   183,
     531,   184,   760,   532,   533,   534,   761,   762,   535,   536,
     537,   538,   539,   540,   541,   542,   543,   544,   545,   546,
     547,   189,   190,   191,   548,   549,   550,   551,   552,   553,
     554,   192,   555,   763,   556,   557,   194,   558,   764,   195,
     559,   196,   560,   561,   765,   766,   562,   767,   768,   563,
     564,   565,   769,   770,   197,   198,   199,   200,   201,   566,
     567,   568,   569,   570,   571,   771,   572,   202,   573,   203,
     574,   575,   576,   772,   577,   578,   579,   580,   581,   582,
     583,   205,   584,   585,   586,   773,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,   774,   597,   598,   211,
     599,   600,   213,   601,   602,   603,   604,   605,   606,   607,
     608,   775,   609,   610,   611,   612,   613,   776,  2964,   217,
     615,   616,   219,   617,   220,   777,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,   222,   628,   778,   629,
     630,   779,   631,   632,   633,   634,   635,   636,   780,   224,
     225,   781,   782,   638,   226,   639,   227,   783,   640,   641,
     642,   643,   644,   645,   784,   785,   646,   647,   648,   649,
     786,   787,   650,   651,   652,   653,   788,   235,   789,   655,
     236,   656,   657,   658,   790,   791,   659,   792,   793,   660,
     661,   662,   663,   664,   238,   239,   240,   241,   242,   243,
     244,   245,   665,   666,   667,   704,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   705,   104,   105,   406,   706,
       0,   107,   108,   109,   110,   707,   708,   112,   113,   114,
     115,     0,   116,   709,   710,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,   135,   136,
     137,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,     0,     0,     0,   151,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,   182,
     183,   531,   184,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,   190,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,   194,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,   198,   199,   200,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     211,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,   219,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,   236,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,   704,    86,    87,    88,
     403,    90,    91,    92,   404,     0,   405,    95,     0,     0,
      98,    99,   100,   101,   102,   103,   705,   104,   105,   406,
     706,     0,   107,   108,   109,   110,   707,   708,   112,   113,
     114,   115,     0,   116,   709,   710,   407,   408,     0,     0,
       0,   409,   410,     0,     0,     0,     0,   411,     0,     0,
       0,     0,     0,     0,     0,     0,   412,     0,   413,     0,
     414,   415,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   417,   418,   419,   420,   421,   422,   423,   424,
       0,   425,   426,   427,     0,     0,     0,     0,     0,     0,
       0,   428,   429,     0,   430,   133,   431,   432,   433,   135,
     136,   137,   138,   139,     0,   434,   435,   436,   437,   438,
       0,     0,   439,   440,   441,   140,   442,     0,   443,   444,
     445,   446,   144,     0,     0,   447,   448,   449,   450,   147,
     451,   452,     0,   453,   454,   455,   456,   457,   458,     0,
     459,   460,   461,   150,   462,     0,     0,     0,     0,   151,
       0,     0,     0,   463,   464,   465,   466,   467,   468,   154,
     155,   469,     0,   470,     0,   471,   472,   473,   474,   475,
       0,   476,   477,   478,     0,     0,   479,   480,   481,   482,
     483,     0,   484,   485,   486,     0,   487,   488,     0,   489,
     490,   491,   492,   164,   493,   494,   166,     0,   495,     0,
     496,   168,   497,     0,   498,     0,   499,   169,     0,   170,
     500,   501,   502,     0,   503,   172,     0,   504,     0,   505,
     506,   507,   508,  1272,   173,   510,   511,   512,     0,   513,
     514,   515,   516,   517,   518,     0,   519,   174,   175,     0,
     520,   521,   522,     0,   177,     0,   178,     0,   523,   179,
     180,   524,   181,   525,   526,   527,   528,   529,   530,     0,
     182,   183,   531,   184,     0,   532,   533,   534,     0,     0,
     535,   536,   537,   538,   539,   540,   541,   542,   543,   544,
     545,   546,   547,   189,   190,   191,   548,   549,   550,   551,
     552,   553,   554,   192,   555,     0,   556,   557,   194,   558,
       0,   195,   559,   196,   560,   561,     0,     0,   562,     0,
       0,   563,   564,   565,     0,     0,   197,   198,   199,   200,
     201,   566,   567,   568,   569,   570,   571,     0,   572,   202,
     573,   203,   574,   575,   576,     0,   577,   578,   579,   580,
     581,   582,   583,   205,   584,   585,   586,     0,   587,   588,
     589,   590,   591,   592,   593,   594,   595,   596,     0,   597,
     598,   211,   599,   600,   213,   601,   602,   603,   604,   605,
     606,   607,   608,     0,   609,   610,   611,   612,   613,     0,
     614,   217,   615,   616,   219,   617,   220,     0,   618,   619,
     620,   621,   622,   623,   624,   625,   626,   627,   222,   628,
       0,   629,   630,     0,   631,   632,   633,   634,   635,   636,
       0,   224,   225,     0,     0,   638,   226,   639,   227,     0,
     640,   641,   642,   643,   644,   645,     0,     0,   646,   647,
     648,   649,     0,     0,   650,   651,   652,   653,   654,   235,
       0,   655,   236,   656,   657,   658,     0,     0,   659,     0,
       0,   660,   661,   662,   663,   664,   238,   239,   240,   241,
     242,   243,   244,   245,   665,   666,   667,   704,    86,    87,
      88,   403,    90,    91,    92,   404,     0,   405,    95,     0,
       0,    98,    99,   100,   101,   102,   103,   705,   104,   105,
     406,   706,     0,   107,   108,   109,   110,   707,   708,   112,
     113,   114,   115,     0,   116,   709,   710,   407,   408,     0,
       0,     0,   409,   410,     0,     0,     0,     0,   411,     0,
       0,     0,     0,     0,     0,     0,     0,   412,     0,   413,
       0,   414,   415,    35,     0,     0,     0,     0,     0,     0,
       0,    41,    42,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   417,   418,   419,   420,   421,   422,   423,
     424,     0,   425,   426,   427,     0,     0,     0,     0,     0,
       0,     0,   428,   429,     0,   430,   133,   431,   432,   433,
     135,   136,   137,   138,   139,     0,   434,   435,   436,   437,
     438,     0,     0,   439,   440,   441,   140,   442,     0,   443,
     444,   445,   446,   144,     0,     0,   447,   448,   449,   450,
     147,   451,   452,     0,   453,   454,   455,   456,   457,   458,
       0,   459,   460,   461,   150,   462,     0,     0,     0,     0,
     151,     0,     0,     0,   463,   464,   465,   466,   467,   468,
     154,   155,   469,     0,   470,     0,   471,   472,   473,   474,
     475,     0,   476,   477,   478,     0,     0,   479,   480,   481,
     482,   483,     0,   484,   485,   486,     0,   487,   488,     0,
     489,   490,   491,   492,   164,   493,   494,   166,     0,   495,
       0,   496,   168,   497,     0,   498,     0,   499,   169,     0,
     170,   500,   501,   502,     0,   503,   172,     0,   504,     0,
     505,   506,   507,   508,  1280,   173,   510,   511,   512,     0,
     513,   514,   515,   516,   517,   518,     0,   519,   174,   175,
       0,   520,   521,   522,     0,   177,     0,   178,     0,   523,
     179,   180,   524,   181,   525,   526,   527,   528,   529,   530,
       0,   182,   183,   531,   184,     0,   532,   533,   534,     0,
       0,   535,   536,   537,   538,   539,   540,   541,   542,   543,
     544,   545,   546,   547,   189,   190,   191,   548,   549,   550,
     551,   552,   553,   554,   192,   555,     0,   556,   557,   194,
     558,     0,   195,   559,   196,   560,   561,     0,     0,   562,
       0,     0,   563,   564,   565,     0,     0,   197,   198,   199,
     200,   201,   566,   567,   568,   569,   570,   571,     0,   572,
     202,   573,   203,   574,   575,   576,     0,   577,   578,   579,
     580,   581,   582,   583,   205,   584,   585,   586,     0,   587,
     588,   589,   590,   591,   592,   593,   594,   595,   596,     0,
     597,   598,   211,   599,   600,   213,   601,   602,   603,   604,
     605,   606,   607,   608,     0,   609,   610,   611,   612,   613,
       0,   614,   217,   615,   616,   219,   617,   220,     0,   618,
     619,   620,   621,   622,   623,   624,   625,   626,   627,   222,
     628,     0,   629,   630,     0,   631,   632,   633,   634,   635,
     636,     0,   224,   225,     0,     0,   638,   226,   639,   227,
       0,   640,   641,   642,   643,   644,   645,     0,     0,   646,
     647,   648,   649,     0,     0,   650,   651,   652,   653,   654,
     235,     0,   655,   236,   656,   657,   658,     0,     0,   659,
       0,     0,   660,   661,   662,   663,   664,   238,   239,   240,
     241,   242,   243,   244,   245,   665,   666,   667,   704,    86,
      87,    88,   403,    90,    91,    92,   404,     0,   405,    95,
       0,     0,    98,    99,   100,   101,   102,   103,   705,   104,
     105,   406,   706,     0,   107,   108,   109,   110,   707,   708,
     112,   113,   114,   115,     0,   116,   709,   710,   407,   408,
       0,     0,     0,   409,   410,     0,     0,     0,     0,   411,
       0,     0,     0,     0,     0,     0,     0,     0,   412,     0,
     413,     0,   414,   415,    35,     0,     0,     0,     0,     0,
       0,     0,    41,    42,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   417,   418,   419,   420,   421,   422,
     423,   424,     0,   425,   426,   427,     0,     0,     0,     0,
       0,     0,     0,   428,   429,     0,   430,   133,   431,   432,
     433,     0,  1784,   137,  1785,  1786,     0,   434,   435,   436,
     437,   438,     0,     0,   439,   440,  1787,  1788,   442,     0,
     443,   444,   445,   446,     0,     0,     0,   447,   448,   449,
     450,   147,   451,   452,     0,   453,   454,   455,   456,   457,
     458,     0,   459,   460,   461,   150,   462,     0,     0,     0,
       0,   151,     0,     0,     0,   463,   464,   465,   466,   467,
     468,  1789,  1790,   469,     0,   470,     0,   471,   472,   473,
     474,   475,     0,   476,   477,   478,     0,     0,   479,   480,
    1419,   482,   483,     0,   484,   485,   486,     0,   487,   488,
       0,   489,   490,   491,   492,     0,   493,   494,     0,     0,
     495,     0,   496,  1791,   497,     0,   498,     0,   499,   169,
       0,   170,   500,   501,   502,     0,   503,     0,     0,   504,
       0,   505,   506,   507,   508,   509,   173,   510,   511,   512,
    2304,   513,   514,   515,   516,   517,   518,     0,   519,   174,
    2305,     0,   520,   521,   522,  1425,  1792,     0,  1793,     0,
     523,   179,   180,   524,   181,   525,   526,   527,   528,   529,
     530,     0,     0,   183,   531,   184,     0,   532,   533,   534,
       0,     0,   535,   536,   537,   538,   539,   540,   541,   542,
     543,   544,   545,   546,   547,  1794,   190,  1795,   548,   549,
     550,   551,   552,   553,   554,     0,   555,     0,   556,   557,
     194,   558,     0,     0,   559,  1796,   560,   561,     0,     0,
     562,     0,     0,   563,   564,   565,     0,     0,  2306,   198,
     199,   200,     0,   566,   567,   568,   569,   570,   571,     0,
     572,     0,   573,     0,   574,   575,   576,     0,   577,   578,
     579,   580,   581,   582,   583,  1797,   584,   585,   586,     0,
     587,   588,   589,   590,   591,   592,   593,   594,   595,   596,
       0,   597,   598,   211,   599,   600,     0,   601,   602,   603,
     604,   605,   606,   607,   608,     0,   609,   610,   611,   612,
     613,     0,   614,  2307,   615,   616,   219,   617,  1799,     0,
     618,   619,   620,   621,   622,   623,   624,   625,   626,   627,
       0,   628,     0,   629,   630,     0,   631,   632,   633,   634,
     635,   636,     0,  1800,  1801,     0,     0,   638,     0,   639,
       0,     0,   640,   641,   642,   643,   644,   645,     0,     0,
     646,   647,   648,   649,     0,     0,   650,   651,   652,   653,
       0,  1802,  2308,   655,   236,   656,   657,   658,     0,     0,
     659,     0,     0,   660,   661,   662,   663,   664,     0,     0,
       0,     0,     0,     0,     0,     0,   665,   666,   667,   704,
      86,    87,    88,   403,    90,    91,    92,   404,     0,   405,
      95,     0,     0,    98,    99,   100,   101,   102,   103,   705,
     104,   105,   406,   706,     0,   107,   108,   109,   110,   707,
     708,   112,   113,   114,   115,     0,   116,   709,   710,   407,
     408,     0,     0,     0,   409,   410,     0,     0,     0,     0,
     411,     0,     0,     0,     0,     0,     0,     0,     0,   412,
       0,   413,     0,   414,   415,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   417,   418,   419,   420,   421,
     422,   423,   424,     0,   425,   426,   427,     0,     0,     0,
       0,     0,     0,     0,   428,   429,     0,   430,   133,   431,
     432,   433,     0,  1784,   137,  1785,  1786,     0,   434,   435,
     436,   437,   438,     0,     0,   439,   440,  1787,  1788,   442,
       0,   443,   444,   445,   446,     0,     0,     0,   447,   448,
     449,   450,   147,   451,   452,     0,   453,   454,   455,   456,
     457,   458,     0,   459,   460,   461,   150,   462,     0,     0,
       0,     0,   151,     0,     0,     0,   463,   464,   465,   466,
     467,   468,  1789,  1790,   469,     0,   470,     0,   471,   472,
     473,   474,   475,     0,   476,   477,   478,     0,     0,   479,
     480,  1419,   482,   483,     0,   484,   485,   486,     0,   487,
     488,     0,   489,   490,   491,   492,     0,   493,   494,     0,
       0,   495,     0,   496,  1791,   497,     0,   498,     0,   499,
     169,     0,   170,   500,   501,   502,     0,   503,     0,     0,
     504,     0,   505,   506,   507,   508,   509,   173,   510,   511,
     512,     0,   513,   514,   515,   516,   517,   518,     0,   519,
     174,     0,     0,   520,   521,   522,  1425,  1792,     0,  1793,
       0,   523,   179,   180,   524,   181,   525,   526,   527,   528,
     529,   530,     0,     0,   183,   531,   184,     0,   532,   533,
     534,     0,     0,   535,   536,   537,   538,   539,   540,   541,
     542,   543,   544,   545,   546,   547,  1794,   190,  1795,   548,
     549,   550,   551,   552,   553,   554,     0,   555,     0,   556,
     557,   194,   558,  2296,     0,   559,  1796,   560,   561,     0,
       0,   562,     0,     0,   563,   564,   565,     0,     0,     0,
     198,   199,   200,     0,   566,   567,   568,   569,   570,   571,
       0,   572,     0,   573,     0,   574,   575,   576,     0,   577,
     578,   579,   580,   581,   582,   583,  1797,   584,   585,   586,
       0,   587,   588,   589,   590,   591,   592,   593,   594,   595,
     596,     0,   597,   598,   211,   599,   600,     0,   601,   602,
     603,   604,   605,   606,   607,   608,     0,   609,   610,   611,
     612,   613,     0,   614,  2307,   615,   616,   219,   617,  1799,
       0,   618,   619,   620,   621,   622,   623,   624,   625,   626,
     627,     0,   628,     0,   629,   630,  3582,   631,   632,   633,
     634,   635,   636,     0,  1800,  1801,     0,     0,   638,     0,
     639,     0,     0,   640,   641,   642,   643,   644,   645,     0,
       0,   646,   647,   648,   649,     0,     0,   650,   651,   652,
     653,     0,  1802,     0,   655,   236,   656,   657,   658,     0,
       0,   659,     0,     0,   660,   661,   662,   663,   664,     0,
       0,     0,     0,     0,     0,     0,     0,   665,   666,   667,
     704,    86,    87,    88,   403,    90,    91,    92,   404,     0,
     405,    95,     0,     0,    98,    99,   100,   101,   102,   103,
     705,   104,   105,   406,   706,     0,   107,   108,   109,   110,
     707,   708,   112,   113,   114,   115,     0,   116,   709,   710,
     407,   408,     0,     0,     0,   409,   410,     0,     0,     0,
       0,   411,     0,     0,     0,     0,     0,     0,     0,     0,
     412,     0,   413,     0,   414,   415,    35,     0,     0,     0,
       0,     0,     0,     0,    41,    42,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   417,   418,   419,   420,
     421,   422,   423,   424,     0,   425,   426,   427,     0,     0,
       0,     0,     0,     0,     0,   428,   429,     0,   430,   133,
     431,   432,   433,     0,  1784,   137,  1785,  1786,     0,   434,
     435,   436,   437,   438,     0,     0,   439,   440,  1787,  1788,
     442,     0,   443,   444,   445,   446,     0,     0,     0,   447,
     448,   449,   450,   147,   451,   452,     0,   453,   454,   455,
     456,   457,   458,     0,   459,   460,   461,   150,   462,     0,
       0,     0,     0,   151,     0,     0,     0,   463,   464,   465,
     466,   467,   468,  1789,  1790,   469,     0,   470,     0,   471,
     472,   473,   474,   475,     0,   476,   477,   478,     0,     0,
     479,   480,  1419,   482,   483,     0,   484,   485,   486,     0,
     487,   488,     0,   489,   490,   491,   492,     0,   493,   494,
       0,     0,   495,     0,   496,  1791,   497,     0,   498,     0,
     499,   169,     0,   170,   500,   501,   502,     0,   503,     0,
       0,   504,     0,   505,   506,   507,   508,   509,   173,   510,
     511,   512,     0,   513,   514,   515,   516,   517,   518,     0,
     519,   174,     0,     0,   520,   521,   522,  1425,  1792,     0,
    1793,     0,   523,   179,   180,   524,   181,   525,   526,   527,
     528,   529,   530,     0,     0,   183,   531,   184,     0,   532,
     533,   534,     0,     0,   535,   536,   537,   538,   539,   540,
     541,   542,   543,   544,   545,   546,   547,  1794,   190,  1795,
     548,   549,   550,   551,   552,   553,   554,  2349,   555,     0,
     556,   557,   194,   558,     0,     0,   559,  1796,   560,   561,
       0,     0,   562,     0,     0,   563,   564,   565,     0,     0,
       0,   198,   199,   200,     0,   566,   567,   568,   569,   570,
     571,     0,   572,     0,   573,     0,   574,   575,   576,     0,
     577,   578,   579,   580,   581,   582,   583,  1797,   584,   585,
     586,     0,   587,   588,   589,   590,   591,   592,   593,   594,
     595,   596,     0,   597,   598,   211,   599,   600,     0,   601,
     602,   603,   604,   605,   606,   607,   608,     0,   609,   610,
     611,   612,   613,     0,   614,  1798,   615,   616,   219,   617,
    1799,     0,   618,   619,   620,   621,   622,   623,   624,   625,
     626,   627,     0,   628,     0,   629,   630,     0,   631,   632,
     633,   634,   635,   636,     0,  1800,  1801,     0,     0,   638,
       0,   639,     0,     0,   640,   641,   642,   643,   644,   645,
       0,     0,   646,   647,   648,   649,     0,     0,   650,   651,
     652,   653,     0,  1802,     0,   655,   236,   656,   657,   658,
       0,     0,   659,     0,     0,   660,   661,   662,   663,   664,
       0,     0,     0,     0,     0,     0,     0,     0,   665,   666,
     667,   704,    86,    87,    88,   403,    90,    91,    92,   404,
       0,   405,    95,     0,     0,    98,    99,   100,   101,   102,
     103,   705,   104,   105,   406,   706,     0,   107,   108,   109,
     110,   707,   708,   112,   113,   114,   115,     0,   116,   709,
     710,   407,   408,     0,     0,     0,   409,   410,     0,     0,
       0,     0,   411,     0,     0,     0,     0,     0,     0,     0,
       0,   412,     0,   413,     0,   414,   415,    35,     0,     0,
       0,     0,     0,     0,     0,    41,    42,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   417,   418,   419,
     420,   421,   422,   423,   424,     0,   425,   426,   427,     0,
       0,     0,     0,     0,     0,     0,   428,   429,     0,   430,
     133,   431,   432,   433,     0,  1784,   137,  1785,  1786,     0,
     434,   435,   436,   437,   438,     0,     0,   439,   440,  1787,
    1788,   442,     0,   443,   444,   445,   446,     0,     0,     0,
     447,   448,   449,   450,   147,   451,   452,     0,   453,   454,
     455,   456,   457,   458,     0,   459,   460,   461,   150,   462,
       0,     0,     0,     0,   151,     0,     0,     0,   463,   464,
     465,   466,   467,   468,  1789,  1790,   469,     0,   470,     0,
     471,   472,   473,   474,   475,     0,   476,   477,   478,     0,
       0,   479,   480,  1419,   482,   483,     0,   484,   485,   486,
       0,   487,   488,     0,   489,   490,   491,   492,     0,   493,
     494,     0,     0,   495,     0,   496,  1791,   497,     0,   498,
       0,   499,   169,     0,   170,   500,   501,   502,     0,   503,
       0,     0,   504,     0,   505,   506,   507,   508,   509,   173,
     510,   511,   512,     0,   513,   514,   515,   516,   517,   518,
       0,   519,   174,     0,     0,   520,   521,   522,  1425,  1792,
       0,  1793,     0,   523,   179,   180,   524,   181,   525,   526,
     527,   528,   529,   530,     0,     0,   183,   531,   184,     0,
     532,   533,   534,     0,     0,   535,   536,   537,   538,   539,
     540,   541,   542,   543,   544,   545,   546,   547,  1794,   190,
    1795,   548,   549,   550,   551,   552,   553,   554,  3429,   555,
       0,   556,   557,   194,   558,     0,     0,   559,  1796,   560,
     561,     0,     0,   562,     0,     0,   563,   564,   565,     0,
       0,     0,   198,   199,   200,     0,   566,   567,   568,   569,
     570,   571,     0,   572,     0,   573,     0,   574,   575,   576,
       0,   577,   578,   579,   580,   581,   582,   583,  1797,   584,
     585,   586,     0,   587,   588,   589,   590,   591,   592,   593,
     594,   595,   596,     0,   597,   598,   211,   599,   600,     0,
     601,   602,   603,   604,   605,   606,   607,   608,     0,   609,
     610,   611,   612,   613,     0,   614,  1798,   615,   616,   219,
     617,  1799,     0,   618,   619,   620,   621,   622,   623,   624,
     625,   626,   627,     0,   628,     0,   629,   630,     0,   631,
     632,   633,   634,   635,   636,     0,  1800,  1801,     0,     0,
     638,     0,   639,     0,     0,   640,   641,   642,   643,   644,
     645,     0,     0,   646,   647,   648,   649,     0,     0,   650,
     651,   652,   653,     0,  1802,     0,   655,   236,   656,   657,
     658,     0,     0,   659,     0,     0,   660,   661,   662,   663,
     664,     0,     0,     0,     0,     0,     0,     0,     0,   665,
     666,   667,   704,    86,    87,    88,   403,    90,    91,    92,
     404,     0,   405,    95,     0,     0,    98,    99,   100,   101,
     102,   103,   705,   104,   105,   406,   706,     0,   107,   108,
     109,   110,   707,   708,   112,   113,   114,   115,     0,   116,
     709,   710,   407,   408,     0,     0,     0,   409,   410,     0,
       0,     0,     0,   411,     0,     0,     0,     0,     0,     0,
       0,     0,   412,     0,   413,     0,   414,   415,    35,     0,
       0,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   417,   418,
     419,   420,   421,   422,   423,   424,     0,   425,   426,   427,
       0,     0,     0,     0,     0,     0,     0,   428,   429,     0,
     430,   133,   431,   432,   433,     0,  1784,   137,  1785,  1786,
       0,   434,   435,   436,   437,   438,     0,     0,   439,   440,
    1787,  1788,   442,     0,   443,   444,   445,   446,     0,     0,
       0,   447,   448,   449,   450,   147,   451,   452,     0,   453,
     454,   455,   456,   457,   458,     0,   459,   460,   461,   150,
     462,     0,     0,     0,     0,   151,     0,     0,     0,   463,
     464,   465,   466,   467,   468,  1789,  1790,   469,     0,   470,
       0,   471,   472,   473,   474,   475,     0,   476,   477,   478,
       0,     0,   479,   480,  1419,   482,   483,     0,   484,   485,
     486,     0,   487,   488,     0,   489,   490,   491,   492,     0,
     493,   494,     0,     0,   495,     0,   496,  1791,   497,     0,
     498,     0,   499,   169,     0,   170,   500,   501,   502,     0,
     503,     0,     0,   504,     0,   505,   506,   507,   508,   509,
     173,   510,   511,   512,     0,   513,   514,   515,   516,   517,
     518,     0,   519,   174,     0,     0,   520,   521,   522,  1425,
    1792,     0,  1793,     0,   523,   179,   180,   524,   181,   525,
     526,   527,   528,   529,   530,     0,     0,   183,   531,   184,
       0,   532,   533,   534,     0,     0,   535,   536,   537,   538,
     539,   540,   541,   542,   543,   544,   545,   546,   547,  1794,
     190,  1795,   548,   549,   550,   551,   552,   553,   554,     0,
     555,     0,   556,   557,   194,   558,     0,     0,   559,  1796,
     560,   561,     0,     0,   562,     0,     0,   563,   564,   565,
       0,     0,     0,   198,   199,   200,     0,   566,   567,   568,
     569,   570,   571,     0,   572,     0,   573,     0,   574,   575,
     576,     0,   577,   578,   579,   580,   581,   582,   583,  1797,
     584,   585,   586,     0,   587,   588,   589,   590,   591,   592,
     593,   594,   595,   596,     0,   597,   598,   211,   599,   600,
       0,   601,   602,   603,   604,   605,   606,   607,   608,     0,
     609,   610,   611,   612,   613,     0,   614,  1798,   615,   616,
     219,   617,  1799,     0,   618,   619,   620,   621,   622,   623,
     624,   625,   626,   627,     0,   628,     0,   629,   630,     0,
     631,   632,   633,   634,   635,   636,     0,  1800,  1801,     0,
       0,   638,     0,   639,     0,     0,   640,   641,   642,   643,
     644,   645,     0,     0,   646,   647,   648,   649,     0,     0,
     650,   651,   652,   653,     0,  1802,     0,   655,   236,   656,
     657,   658,     0,     0,   659,     0,     0,   660,   661,   662,
     663,   664,     0,     0,     0,     0,     0,     0,     0,     0,
     665,   666,   667,   704,    86,    87,    88,   403,    90,    91,
      92,   404,     0,   405,    95,     0,     0,    98,    99,   100,
     101,   102,   103,   705,   104,   105,   406,   706,     0,   107,
     108,   109,   110,   707,   708,   112,   113,   114,   115,     0,
     116,   709,   710,   407,   408,     0,     0,     0,   409,   410,
       0,     0,     0,     0,   411,     0,     0,     0,     0,     0,
       0,     0,     0,   412,     0,   413,     0,   414,   415,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   417,
     418,   419,   420,   421,   422,   423,   424,     0,   425,   426,
     427,     0,     0,     0,     0,     0,     0,     0,   428,   429,
       0,   430,   133,   431,   432,   433,     0,  1784,   137,  1785,
    1786,     0,   434,   435,   436,   437,   438,     0,     0,   439,
     440,  1787,  1788,   442,     0,   443,   444,   445,   446,     0,
       0,     0,   447,   448,   449,   450,   147,   451,   452,     0,
     453,   454,   455,   456,   457,   458,     0,   459,   460,   461,
     150,   462,     0,     0,     0,     0,   151,     0,     0,     0,
     463,   464,   465,   466,   467,   468,  1789,  1790,   469,     0,
     470,     0,   471,   472,   473,   474,   475,     0,   476,   477,
     478,     0,     0,   479,   480,  1419,   482,   483,     0,   484,
     485,   486,     0,   487,   488,     0,   489,   490,   491,   492,
       0,   493,   494,     0,     0,   495,     0,   496,  1791,   497,
       0,   498,     0,   499,   169,     0,   170,   500,   501,   502,
       0,   503,     0,     0,   504,     0,   505,   506,   507,   508,
     509,   173,   510,   511,   512,     0,   513,   514,   515,   516,
     517,   518,     0,   519,   174,     0,     0,   520,   521,   522,
    1425,  1792,     0,  1793,     0,   523,   179,   180,   524,   181,
     525,   526,   527,   528,   529,   530,     0,     0,   183,   531,
     184,     0,   532,   533,   534,     0,     0,   535,   536,   537,
     538,   539,   540,   541,   542,   543,   544,   545,   546,   547,
    1794,   190,  1795,   548,   549,   550,   551,   552,   553,   554,
       0,   555,     0,   556,   557,   194,   558,     0,     0,   559,
    1796,   560,   561,     0,     0,   562,     0,     0,   563,   564,
     565,     0,     0,     0,   198,   199,   200,     0,   566,   567,
     568,   569,   570,   571,     0,   572,     0,   573,     0,   574,
     575,   576,     0,   577,   578,   579,   580,   581,   582,   583,
    1797,   584,   585,   586,     0,   587,   588,   589,   590,   591,
     592,   593,   594,   595,   596,     0,   597,   598,   211,   599,
     600,     0,   601,   602,   603,   604,   605,   606,   607,   608,
       0,   609,   610,   611,   612,   613,     0,   614,  2307,   615,
     616,   219,   617,  1799,     0,   618,   619,   620,   621,   622,
     623,   624,   625,   626,   627,     0,   628,     0,   629,   630,
       0,   631,   632,   633,   634,   635,   636,     0,  1800,  1801,
       0,     0,   638,     0,   639,     0,     0,   640,   641,   642,
     643,   644,   645,     0,     0,   646,   647,   648,   649,     0,
       0,   650,   651,   652,   653,     0,  1802,     0,   655,   236,
     656,   657,   658,     0,     0,   659,     0,     0,   660,   661,
     662,   663,   664,     0,     0,     0,     0,     0,     0,     0,
       0,   665,   666,   667,   704,    86,    87,    88,   403,    90,
      91,    92,   404,     0,   405,    95,     0,     0,    98,    99,
     100,   101,   102,   103,   705,   104,   105,   406,   706,     0,
     107,   108,   109,   110,   707,   708,   112,   113,   114,   115,
       0,   116,   709,   710,   407,   408,     0,     0,     0,   409,
     410,     0,     0,     0,     0,   411,     0,     0,     0,     0,
       0,     0,     0,     0,   412,     0,   413,     0,   414,   415,
      35,     0,     0,     0,     0,     0,     0,     0,    41,    42,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     417,   418,   419,   420,   421,   422,   423,   424,     0,   425,
     426,   427,     0,     0,     0,     0,     0,     0,     0,   428,
     429,     0,   430,   133,   431,   432,   433,     0,  1784,   137,
    1785,  1786,     0,   434,   435,   436,   437,   438,     0,     0,
     439,   440,  1787,  1788,   442,     0,   443,   444,   445,   446,
       0,     0,     0,   447,   448,   449,   450,   147,   451,   452,
       0,   453,   454,   455,   456,   457,   458,     0,   459,   460,
     461,   150,   462,     0,     0,     0,     0,   151,     0,     0,
       0,   463,   464,   465,   466,   467,   468,  1789,  1790,   469,
       0,   470,     0,   471,   472,   473,   474,   475,     0,   476,
     477,   478,     0,     0,   479,   480,  1419,   482,   483,     0,
     484,   485,   486,     0,   487,   488,     0,   489,   490,   491,
     492,     0,   493,   494,     0,     0,   495,     0,   496,  1791,
     497,     0,   498,     0,   499,   169,     0,   170,   500,   501,
     502,     0,   503,     0,     0,   504,     0,   505,   506,   507,
     508,   509,   173,   510,   511,   512,     0,   513,   514,   515,
     516,   517,   518,     0,   519,   174,     0,     0,   520,   521,
     522,  1425,  1792,     0,  1793,     0,   523,   179,   180,   524,
     181,   525,   526,   527,   528,   529,   530,     0,     0,   183,
     531,   184,     0,   532,   533,   534,     0,     0,   535,   536,
     537,   538,   539,   540,   541,   542,   543,   544,   545,   546,
     547,  1794,   190,  1795,   548,   549,   550,   551,   552,   553,
     554,     0,   555,     0,   556,   557,   194,   558,     0,     0,
     559,  1796,   560,   561,     0,     0,   562,     0,     0,   563,
     564,   565,     0,     0,     0,   198,   199,   200,     0,   566,
     567,   568,   569,   570,   571,     0,   572,     0,   573,     0,
     574,   575,   576,     0,   577,   578,   579,   580,   581,   582,
     583,  1797,   584,   585,   586,     0,   587,   588,   589,   590,
     591,   592,   593,   594,   595,   596,     0,   597,   598,   211,
     599,   600,     0,   601,   602,   603,   604,   605,   606,   607,
     608,     0,   609,   610,   611,   612,   613,     0,   614,     0,
     615,   616,   219,   617,  1799,     0,   618,   619,   620,   621,
     622,   623,   624,   625,   626,   627,     0,   628,     0,   629,
     630,     0,   631,   632,   633,   634,   635,   636,     0,  1800,
    1801,     0,     0,   638,     0,   639,     0,     0,   640,   641,
     642,   643,   644,   645,     0,     0,   646,   647,   648,   649,
       0,     0,   650,   651,   652,   653,     0,  1802,     0,   655,
     236,   656,   657,   658,     0,     0,   659,     0,     0,   660,
     661,   662,   663,   664,     0,     0,     0,     0,     0,     0,
       0,     0,   665,   666,   667,   704,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,   705,   104,   105,   406,   706,
       0,   107,   108,   109,   110,   707,   708,   112,   113,   114,
     115,     0,   116,   709,   710,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,   133,   431,   432,   433,     0,     0,
     137,     0,     0,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,     0,     0,   442,     0,   443,   444,   445,
     446,     0,     0,     0,   447,   448,   449,   450,   147,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,   150,   462,     0,     0,     0,     0,   151,     0,
       0,     0,   463,   464,   465,   466,   467,   468,     0,     0,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,     0,   493,   494,     0,     0,   495,     0,   496,
       0,   497,     0,   498,     0,   499,   169,     0,   170,   500,
     501,   502,     0,   503,     0,     0,   504,     0,   505,   506,
     507,   508,   509,   173,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,   174,     0,     0,   520,
     521,   522,     0,     0,     0,     0,     0,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,     0,     0,
     183,   531,   184,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,     0,   190,     0,   548,   549,   550,   551,   552,
     553,   554,     0,   555,     0,   556,   557,   194,   558,     0,
       0,   559,     0,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,     0,   198,   199,   200,     0,
     566,   567,   568,   569,   570,   571,     0,   572,     0,   573,
       0,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,     0,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
     211,   599,   600,     0,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
       0,   615,   616,   219,   617,     0,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,     0,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
       0,     0,     0,     0,   638,     0,   639,     0,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,     0,     0,     0,
     655,   236,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,     0,     0,     0,     0,     0,
       0,     0,     0,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,   711,
     425,   426,   427,   712,   713,   714,   715,   716,   717,   718,
     428,   429,   719,   430,   133,   431,   432,   433,   135,   136,
     137,   138,   139,   720,   434,   435,   436,   437,   438,   721,
     722,   439,   440,     0,   140,   442,   724,   443,   444,   445,
     446,   144,   725,   726,   447,   448,   449,   450,   147,   451,
     727,   728,   453,   454,   455,   456,   457,   458,   729,   459,
     460,   461,   150,   462,     0,   731,   732,   733,   151,   734,
     735,   736,   463,   464,   465,   466,     0,   468,   154,   155,
     469,   737,   470,   738,   471,   472,   473,   474,   475,   739,
     476,   477,   478,   740,   741,   479,   480,   481,   482,   483,
     742,   484,   485,   486,   743,   487,   488,   744,   489,   490,
     491,   492,   164,   493,   494,   166,   745,   495,   746,   496,
     168,   497,   747,   498,   748,   499,   169,   749,   170,   500,
     501,   502,   750,   503,   172,   751,   504,   752,   505,   506,
       0,   508,   509,   173,   510,   511,   512,   753,   513,   514,
     515,   516,   517,   518,   754,   519,   174,   175,     0,   520,
     521,   522,     0,   177,   757,   178,   758,   523,   179,   180,
     524,   181,   525,   526,   527,   528,   529,   530,   759,   182,
     183,   531,   184,   760,   532,   533,   534,   761,   762,   535,
     536,   537,   538,   539,   540,     0,   542,   543,     0,   545,
     546,   547,   189,   190,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,   763,   556,   557,   194,   558,   764,
     195,   559,   196,   560,   561,   765,   766,   562,   767,   768,
     563,   564,   565,   769,   770,   197,   198,   199,   200,   201,
     566,   567,   568,   569,   570,   571,   771,   572,   202,   573,
     203,   574,   575,   576,   772,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,   773,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,   774,   597,   598,
     211,   599,   600,   213,   601,   602,   603,   604,   605,   606,
       0,   608,   775,   609,   610,   611,   612,   613,   776,   614,
     217,   615,   616,   219,   617,   220,   777,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,   778,
     629,   630,   779,   631,   632,   633,   634,   635,   636,   780,
     224,   225,     0,   782,   638,   226,   639,   227,   783,   640,
     641,   642,   643,   644,   645,     0,   785,   646,   647,   648,
     649,   786,   787,   650,   651,   652,   653,     0,   235,   789,
     655,   236,   656,   657,   658,   790,   791,   659,   792,   793,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,     0,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,  1927,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,  1928,     0,   562,  1929,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,  1930,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,    43,    44,  1397,  4463,     0,    45,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,   637,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,  1111,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,  2126,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,  2275,   443,   444,   445,
     446,   144,     0,  2319,   447,   448,   449,   450,     0,   451,
     452,  2276,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,  2320,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,  2278,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,  2279,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,  2280,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,  2275,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,  2276,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,  2320,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,  2278,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,  3083,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,  2279,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,  2280,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,  1013,   423,   424,   971,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,   972,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,  1014,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,   973,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,   974,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,    37,    38,    39,    40,    41,
      42,     0,    44,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1907,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,   971,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,   972,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,  2855,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,   973,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,   974,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,  2275,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,  2276,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,  2320,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,  2278,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,  2279,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,  2280,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,   687,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,   688,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,   689,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,   971,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,   972,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,   973,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,   974,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,   888,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,   889,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   890,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,  1963,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,  1964,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,  1965,   499,     0,     0,     0,  1966,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,  1967,  1968,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,  1969,   605,   606,
     607,   608,     0,  1970,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,  1971,   631,  1972,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,   972,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,   973,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,   974,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,   130,   131,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,  1325,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,  1952,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,  2237,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,  2745,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,  2746,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,  2747,   631,   632,  2748,   634,  2749,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,   696,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,   689,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,   843,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,  1263,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,  2394,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,  2395,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,   130,   131,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,  2899,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,  2900,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,  2911,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,  2912,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     894,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   935,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,   416,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   989,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,  1044,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,  1503,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,  1859,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,  1952,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,  2237,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,  3120,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,  3133,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,  3175,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,  3888,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,  3890,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,  3892,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,  4048,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   997,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,   999,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,  1000,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
       0,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,  1001,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1002,   225,     0,     0,  1003,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,  1004,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,  1038,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,  1000,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
       0,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,  1039,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1040,   225,     0,     0,  1041,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,  1004,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,  1060,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,  1183,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,  1246,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1277,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1282,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1290,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1292,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1294,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1296,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1299,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1301,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,  1302,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1305,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,  1514,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,  1025,   440,  1000,   140,  1515,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
       0,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,  1029,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,  1030,   600,   213,   601,   602,   603,  1031,   605,   606,
     607,   608,     0,   609,   610,   611,   612,  1507,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1033,   225,     0,     0,  1034,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,  1004,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,  1035,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,  1537,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,     0,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,  1637,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1885,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  1887,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,  2002,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  2526,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  2902,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,  2904,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,   601,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,  1025,   440,  1000,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
       0,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,  1029,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,  1030,   600,   213,   601,   602,   603,  1031,   605,   606,
     607,   608,     0,   609,   610,   611,   612,  1507,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1033,   225,     0,     0,  1034,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,  1004,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,  1035,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,  1025,   440,  1000,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
       0,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,  1029,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,  1030,   600,   213,   601,   602,   603,  1031,   605,   606,
     607,   608,     0,   609,   610,   611,   612,  1507,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,  2266,   633,   634,   635,   636,     0,
    1033,   225,     0,     0,  1034,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,  1004,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,  1035,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,  1025,   440,  1000,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
       0,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,  1029,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,   570,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
     582,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,  1030,   600,   213,   601,   602,   603,  2300,   605,   606,
     607,   608,     0,   609,   610,   611,   612,  1507,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
    1033,   225,     0,     0,  1034,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,  1004,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,  1035,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,   403,
      90,    91,    92,   404,     0,   405,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,   406,     0,
       0,   107,   108,   109,   110,     0,     0,   112,   113,   114,
     115,     0,   116,     0,     0,   407,   408,     0,     0,     0,
     409,   410,     0,     0,     0,     0,   411,     0,     0,     0,
       0,     0,     0,     0,     0,   412,     0,   413,     0,   414,
     415,    35,     0,     0,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   417,   418,   419,   420,   421,   422,   423,   424,     0,
     425,   426,   427,     0,     0,     0,     0,     0,     0,     0,
     428,   429,     0,   430,     0,   431,   432,   433,   135,   136,
       0,   138,   139,     0,   434,   435,   436,   437,   438,     0,
       0,   439,   440,   441,   140,   442,     0,   443,   444,   445,
     446,   144,     0,     0,   447,   448,   449,   450,     0,   451,
     452,     0,   453,   454,   455,   456,   457,   458,     0,   459,
     460,   461,     0,   462,     0,     0,     0,     0,     0,     0,
       0,     0,   463,   464,   465,   466,   467,   468,   154,   155,
     469,     0,   470,     0,   471,   472,   473,   474,   475,     0,
     476,   477,   478,     0,     0,   479,   480,   481,   482,   483,
       0,   484,   485,   486,     0,   487,   488,     0,   489,   490,
     491,   492,   164,   493,   494,   166,     0,   495,     0,   496,
     168,   497,     0,   498,     0,   499,     0,     0,     0,   500,
     501,   502,     0,   503,   172,     0,   504,     0,   505,   506,
     507,   508,   509,     0,   510,   511,   512,     0,   513,   514,
     515,   516,   517,   518,     0,   519,     0,   175,     0,   520,
     521,   522,     0,   177,     0,   178,     0,   523,     0,     0,
     524,     0,   525,   526,   527,   528,   529,   530,     0,   182,
       0,   531,     0,     0,   532,   533,   534,     0,     0,   535,
     536,   537,   538,   539,   540,   541,   542,   543,   544,   545,
     546,   547,   189,     0,   191,   548,   549,   550,   551,   552,
     553,   554,   192,   555,     0,   556,   557,     0,   558,     0,
     195,   559,   196,   560,   561,     0,     0,   562,     0,     0,
     563,   564,   565,     0,     0,   197,     0,     0,     0,   201,
     566,   567,   568,   569,     0,   571,     0,   572,   202,   573,
     203,   574,   575,   576,     0,   577,   578,   579,   580,   581,
       0,   583,   205,   584,   585,   586,     0,   587,   588,   589,
     590,   591,   592,   593,   594,   595,   596,     0,   597,   598,
       0,   599,   600,   213,     0,   602,   603,   604,   605,   606,
     607,   608,     0,   609,   610,   611,   612,   613,     0,   614,
     217,   615,   616,     0,   617,   220,     0,   618,   619,   620,
     621,   622,   623,   624,   625,   626,   627,   222,   628,     0,
     629,   630,     0,   631,   632,   633,   634,   635,   636,     0,
     224,   225,     0,     0,   638,   226,   639,   227,     0,   640,
     641,   642,   643,   644,   645,     0,     0,   646,   647,   648,
     649,     0,     0,   650,   651,   652,   653,   654,   235,     0,
     655,     0,   656,   657,   658,     0,     0,   659,     0,     0,
     660,   661,   662,   663,   664,   238,   239,   240,   241,   242,
     243,   244,   245,   665,   666,   667,    86,    87,    88,     0,
      90,    91,    92,     0,     0,     0,    95,     0,     0,    98,
      99,   100,   101,   102,   103,     0,   104,   105,     0,     0,
       0,   107,   108,   109,   110,     0,   111,   112,   113,   114,
     115, -2161,   116,   117,   118,     0,     0,     0,     0,     0,
     121,   122,     0,     0,     0,     0,   123,     0,     0,     0,
       0,     0,     0,     0,     0,   124,     0,   125,     0,   126,
     127,    35,     0,   398,     0,     0,     0,     0,     0,    41,
      42,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   133,     0,     0,     0,   135,   136,
     137,   138,   139,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   140,     0,     0,     0,     0,     0,
       0,   144,     0,     0,     0,     0,     0,     0,   147,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   150,     0,     0,     0,     0,     0,   151,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   154,   155,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   162,     0,     0,     0,     0,
       0,     0,   164,     0,     0,   166,     0,     0,     0,     0,
     168,     0,     0,     0,     0,     0,   169,     0,   170,     0,
       0,     0,     0,     0,   172,     0,     0,     0,     0,     0,
       0,     0,     0,   173,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   174,   175,     0,     0,
       0,     0,     0,   177,     0,   178,     0,     0,   179,   180,
       0,   181,     0,     0,     0,     0,     0,     0,     0,   182,
     183,     0,   184,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   189,   190,   191,     0,     0,     0,     0,     0,
       0,     0,   192,     0,     0,     0,     0,   194,     0,     0,
     195,     0,   196,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   197,   198,   199,   200,   201,
       0,     0,     0,     0,     0,     0,     0,     0,   202,     0,
     203,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   205,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     211,     0,     0,   213,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     217,     0,     0,   219,     0,   220,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   222,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     224,   225,     0,     0,     0,   226,     0,   227,     0,     0,
       0,     0,     0,     0,     0,   230,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   235,     0,
       0,   236,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   238,   239,   240,   241,   242,
     243,   244,   245,    86,    87,    88,     0,    90,    91,    92,
       0,     0,     0,    95,     0,     0,    98,    99,   100,   101,
     102,   103,     0,   104,   105,     0,     0,     0,   107,   108,
     109,   110,     0,   111,   112,   113,   114,   115, -2162,   116,
     117,   118,     0,     0,     0,     0,     0,   121,   122,     0,
       0,     0,     0,   123,     0,     0,     0,     0,     0,     0,
       0,     0,   124,     0,   125,     0,   126,   127,    35,     0,
    1106,     0,     0,     0,     0,     0,    41,    42,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   133,     0,     0,     0,   135,   136,   137,   138,   139,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   140,     0,     0,     0,     0,     0,     0,   144,     0,
       0,     0,     0,     0,     0,   147,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   150,
       0,     0,     0,     0,     0,   151,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   154,   155,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   162,     0,     0,     0,     0,     0,     0,   164,
       0,     0,   166,     0,     0,     0,     0,   168,     0,     0,
       0,     0,     0,   169,     0,   170,     0,     0,     0,     0,
       0,   172,     0,     0,     0,     0,     0,     0,     0,     0,
     173,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   174,   175,     0,     0,     0,     0,     0,
     177,     0,   178,     0,     0,   179,   180,     0,   181,     0,
       0,     0,     0,     0,     0,     0,   182,   183,     0,   184,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   189,
     190,   191,     0,     0,     0,     0,     0,     0,     0,   192,
       0,     0,     0,     0,   194,     0,     0,   195,     0,   196,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   197,   198,   199,   200,   201,     0,     0,     0,
       0,     0,     0,     0,     0,   202,     0,   203,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   205,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   211,     0,     0,
     213,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   217,     0,     0,
     219,     0,   220,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   222,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   224,   225,     0,
       0,     0,   226,     0,   227,     0,     0,     0,     0,     0,
       0,     0,   230,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   235,     0,     0,   236,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   238,   239,   240,   241,   242,   243,   244,   245,
      86,    87,    88,     0,    90,    91,    92,     0,     0,     0,
      95,     0,     0,    98,    99,   100,   101,   102,   103,     0,
     104,   105,     0,     0,     0,   107,   108,   109,   110,     0,
     111,   112,   113,   114,   115,     0,   116,   117,   118,     0,
       0,     0,     0,     0,   121,   122,     0,     0,     0,     0,
     123,     0,     0,     0,     0,     0,     0,     0,     0,   124,
       0,   125,     0,   126,     0,    35,     0,     0,     0,     0,
       0,     0,     0,    41,    42,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   133,     0,
       0,     0,   135,   136,   137,   138,   139,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   140,     0,
       0,     0,     0,     0,     0,   144,     0,     0,     0,     0,
       0,     0,   147,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   150,     0,     0,     0,
       0,     0,   151,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   154,   155,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   162,
       0,     0,     0,     0,     0,     0,   164,     0,     0,   166,
       0,     0,     0,     0,   168,     0,     0,     0,     0,     0,
     169,     0,   170,     0,     0,     0,     0,     0,   172,     0,
       0,     0,     0,     0,     0,     0,     0,   173,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     174,   175,     0,     0,     0,     0,     0,   177,     0,   178,
       0,     0,   179,   180,     0,   181,     0,     0,     0,     0,
       0,     0,     0,   182,   183,     0,   184,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   189,   190,   191,     0,
       0,     0,     0,     0,     0,     0,   192,     0,     0,     0,
       0,   194,     0,     0,   195,     0,   196,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   197,
     198,   199,   200,   201,     0,     0,     0,     0,     0,     0,
       0,     0,   202,     0,   203,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   205,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   211,     0,     0,   213,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   217,     0,     0,   219,     0,   220,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   222,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   224,   225,     0,     0,     0,   226,
       0,   227,     0,     0,     0,     0,     0,     0,     0,   230,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   235,     0,     0,   236,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   238,
     239,   240,   241,   242,   243,   244,   245,    86,    87,    88,
       0,    90,    91,    92,     0,     0,     0,    95,     0,     0,
      98,    99,   100,   101,   102,   103,     0,   104,   105,     0,
       0,     0,   107,   108,   109,   110,     0,   111,   112,   113,
     114,   115,     0,   116,   117,   118,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,    35,     0,     0,     0,     0,     0,     0,     0,
      41,    42,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   133,     0,     0,     0,   135,
     136,   137,   138,   139,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   140,     0,     0,     0,     0,
       0,     0,   144,     0,     0,     0,     0,     0,     0,   147,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   150,     0,     0,     0,     0,     0,   151,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   154,
     155,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   162,     0,     0,     0,
       0,     0,     0,   164,     0,     0,   166,     0,     0,     0,
       0,   168,     0,     0,     0,     0,     0,   169,     0,   170,
       0,     0,     0,     0,     0,   172,     0,     0,     0,     0,
       0,     0,     0,     0,   173,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,   174,   175,     0,
       0,     0,     0,     0,   177,     0,   178,     0,     0,   179,
     180,     0,   181,     0,     0,     0,     0,     0,     0,     0,
     182,   183,     0,   184,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   189,   190,   191,     0,     0,     0,     0,
       0,     0,     0,   192,     0,     0,     0,     0,   194,     0,
       0,   195,     0,   196,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   197,   198,   199,   200,
     201,     0,     0,     0,     0,     0,     0,     0,     0,   202,
       0,   203,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   205,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   211,     0,     0,   213,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   217,     0,     0,   219,     0,   220,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   222,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,   224,   225,     0,     0,     0,   226,     0,   227,     0,
       0,     0,     0,     0,     0,     0,   230,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,   235,
       0,     0,   236,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   238,   239,   240,   241,
     242,   243,   244,   245,    86,    87,    88,     0,    90,    91,
      92,     0,     0,     0,    95,     0,     0,    98,    99,   100,
     101,   102,   103,     0,   104,   105,     0,     0,     0,   107,
     108,   109,   110,     0,     0,   112,   113,   114,   115,     0,
     116,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,    35,
       0,     0,     0,     0,     0,     0,     0,    41,    42,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   133,     0,     0,     0,   135,   136,   137,   138,
     139,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   140,     0,     0,     0,     0,     0,     0,   144,
       0,     0,     0,     0,     0,     0,   147,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     150,     0,     0,     0,     0,     0,   151,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   154,   155,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     164,     0,     0,   166,     0,     0,     0,     0,   168,     0,
       0,     0,     0,     0,   169,     0,   170,     0,     0,     0,
       0,     0,   172,     0,     0,     0,     0,     0,     0,     0,
       0,   173,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,   174,   175,     0,     0,     0,     0,
       0,   177,     0,   178,     0,     0,   179,   180,     0,   181,
       0,     0,     0,     0,     0,     0,     0,   182,   183,     0,
     184,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     189,   190,   191,     0,     0,     0,     0,     0,     0,     0,
     192,     0,     0,     0,     0,   194,     0,     0,   195,     0,
     196,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   197,   198,   199,   200,   201,     0,     0,
       0,     0,     0,     0,     0,     0,   202,     0,   203,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
     205,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   211,     0,
       0,   213,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   217,     0,
       0,   219,     0,   220,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,   222,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,   224,   225,
       0,     0,     0,   226,     0,   227,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,   235,     0,     0,   236,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,   238,   239,   240,   241,   242,   243,   244,
     245
};

static const short yycheck[] =
{
       2,   210,  1119,   167,   973,   974,   246,   117,  1281,   978,
     351,   153,    78,    78,   901,    78,  1329,    94,  1027,   152,
      78,  1075,   864,   228,   188,     2,  1077,  1288,  1379,  1694,
    1656,  1319,  1360,  1142,  1909,   149,  1174,  1798,  1814,    89,
    1191,  1966,  1678,   826,  1148,  1916,  1184,   702,    78,  1392,
    1034,   366,   162,  1245,    84,   132,  1446,   366,  1684,   165,
    2115,     2,   204,  1222,   171,  1417,  1418,  1558,  1042,  1734,
    1735,  2895,    78,   915,  2622,   152,   153,  1728,    84,  1100,
     117,   864,  2759,   132,  1436,  3107,   163,    89,  1226,  2312,
    2313,   816,  1833,  1231,   117,  1847,  2428,   822,  1833,   223,
    1238,  2510,  1534,   210,  1589,  1590,  1591,  1833,   232,  1247,
    1678,   117,  2348,  2962,  1273,  2964,   703,   167,   339,  1833,
     230,  1833,  2005,  1833,  1119,   162,  2596,   204,   853,  2162,
    3027,   160,   915,   353,  3353,  2757,  1157,  3382,   188,   162,
     940,  3061,  2521,  1030,  1568,    78,  1722,   353,  2515,  2516,
     152,  3583,   167,  1905,  3769,  1684,   162,   159,  1584,  1585,
     216,  1342,  1646,  2173,  3061,  3530,  3557,  1149,  1320,  3593,
    2168,  1407,  1408,   188,  2211,  1463,  1153,    30,  1311,  1072,
     905,    21,    10,  1072,   186,  3775,  3246,   912,   120,    96,
    1114,  1115,   810,   230,    72,    72,  1432,  3561,    72,   106,
      88,   227,  1184,    78,   102,   108,   932,   230,    86,    84,
     127,  1643,    86,  2250,   127,   148,    72,  2254,  2454,   205,
    2755,  2756,   134,    88,   230,    81,   167,  1870,   112,   181,
      86,    78,   165,   888,   143,   142,  3041,  3042,  3043,  3044,
    3045,  3046,   117,  3610,    78,  3612,   112,   188,   113,   156,
     324,  1220,  4158,   103,   104,    99,    75,    76,    77,    78,
      78,   227,   106,    82,   227,   266,   306,    78,   266,   200,
      75,    76,    77,    78,   329,    78,   127,    82,    84,   222,
     227,    84,   266,    75,    76,    77,    78,   162,   227,    99,
      82,  2067,   358,   358,   183,   358,   106,  2533,    90,  2535,
     358,   147,   327,   221,    75,    76,    77,    78,  1329,   188,
     151,    82,   185,   246,   117,    75,    76,    77,    78,    14,
     424,   229,    82,   334,   154,   402,    75,    76,    77,    78,
    1759,   162,   153,    82,   209,   434,   366,    78,   158,   385,
     181,   216,    37,   218,   401,    99,  1320,    75,    76,    77,
      78,   117,   106,   295,    82,   230,    38,   186,    40,   162,
     366,   117,     0,   134,  1206,   469,   470,  1518,   497,  1024,
     174,   401,   471,   502,   195,   504,   226,    72,   228,  1488,
      75,    76,    77,    78,    14,   134,    81,    82,    83,    84,
     436,    86,   127,   450,   267,   401,   162,   266,   502,   230,
    2437,    75,    76,    77,    78,    72,   162,    88,    82,   233,
      14,  1801,   232,  3778,    81,   455,    90,  1304,   473,    86,
     353,   181,   330,  1206,    88,   358,  1855,   230,   502,   372,
     319,   349,    75,    76,    77,    78,   158,  1789,  1790,    82,
     266,    88,  1329,   209,  1796,    95,   228,    90,   390,   113,
     216,   452,   218,   209,    75,    76,    77,    78,    29,   376,
     216,    82,   218,   376,   230,     8,   113,   227,    11,    12,
     247,  1196,   180,   314,   230,   373,   502,   502,  1203,    22,
      23,    24,    88,    26,    27,  4050,  4051,   385,    31,    32,
      33,   366,  1765,   432,   505,    25,  1517,   812,  4113,  3419,
    1521,  1522,   306,   812,   637,   506,   504,   113,  1769,  1483,
     232,   358,    75,    76,    77,    78,   502,    99,  1136,    82,
     107,   505,  3419,   432,   358,   376,   401,    90,  1253,  1116,
    1117,  1331,   181,  4439,   465,   419,  3901,   489,   436,   505,
     358,  3505,   505,   685,   686,   375,  2307,   358,   198,  1523,
    1524,  1787,  1788,   419,    75,    76,    77,    78,   505,  1795,
     637,    82,   406,   366,  3928,    75,    76,    77,    78,    90,
     502,  3376,    82,   452,    75,    76,    77,    78,  3943,   456,
    1718,    82,  1720,  1309,    75,    76,    77,    78,   505,  1781,
     502,    82,   505,  3960,   181,   401,   406,   443,   401,   502,
    3660,  3136,  2600,  1762,   268,   269,  1757,  4222,   685,   686,
     498,   461,   452,   469,  2038,   493,   494,   358,   174,   493,
     494,   450,  4212,  2859,   502,   702,   452,  1514,   456,    88,
    1958,   174,   314,   498,  3311,   637,   505,   493,   494,  2290,
    1778,   376,  1663,    75,    76,    77,    78,   500,  1669,   158,
      82,   470,   406,   317,   505,   377,   496,    75,    76,    77,
      78,  3925,   268,  2886,    82,  2888,    93,  2999,   136,   488,
    3002,  3003,   432,  2105,  3006,   505,  2312,  2109,   266,  1603,
    4045,   505,  1575,   502,  3016,   818,  1575,   258,  4053,  1710,
      25,   341,  1713,  1714,  3316,   500,  2694,   502,   808,   504,
    1677,   941,    75,    76,    77,    78,  4321,  3512,   832,    82,
     502,   460,  1816,  4151,  3123,  2770,  2004,  2005,  3127,   270,
     502,   942,   381,   232,   857,  1707,   434,  2015,   505,   489,
    2018,   502,   262,  1320,  1075,  4159,  4127,   461,  2026,  2027,
     208,    95,   470,   392,   504,  1766,  2783,   469,   890,   399,
    4315,  2039,  2040,   502,   140,   149,   224,   300,  1939,    85,
     488,   111,  2050,   471,  1945,   347,   210,  4382,  3004,  3005,
    1922,   808,   896,   422,   502,   229,   909,   266,  2788,  2263,
    1913,   503,   812,   210,   506,   808,  2212,   951,  2214,   953,
    2319,   955,   451,   328,  2030,  2031,   190,   961,   493,   494,
     383,    99,   808,   118,  3027,   227,   812,   350,   457,   268,
     361,   888,   341,   890,   495,   496,   497,   498,   847,   186,
     469,   985,   986,   937,   324,   227,   493,   494,   502,   493,
     494,   495,   496,   497,   498,   941,   266,   207,  3061,   460,
     396,   370,  4457,   425,   198,   427,   848,   145,   495,   496,
     497,   498,   314,   502,   152,  4138,  4288,   181,   935,   502,
     984,  1703,   939,  2499,   452,    71,    72,  2510,   377,    75,
      76,    77,    78,    79,    80,    81,    82,   210,  4142,   100,
      86,   502,  3105,  1852,   182,   334,   354,   493,   494,   495,
     496,   497,   498,   260,   264,   209,   246,   359,   441,   901,
     902,   951,   489,   953,   422,   955,  3870,  3871,  3872,  3873,
    3874,   961,  4105,   500,  2490,   502,   503,   504,   505,   502,
    1703,  3943,  4360,   198,  1048,   149,   127,   262,   243,   266,
     932,   385,   247,   808,   248,   985,   986,   812,   953,   502,
     955,   327,   185,   175,   306,   174,  1920,  1024,   342,  1026,
    1056,   228,   181,   251,   505,   932,   383,   401,   231,    95,
     469,  1970,  1971,   452,   334,  4210,   190,   282,  3347,   230,
     985,   986,  1028,   502,   401,   181,  1032,  1026,   446,    72,
     109,   502,    75,    76,    77,    78,   440,   989,    81,    82,
     314,   932,   502,    86,   503,  4278,  4361,   506,  2774,  4218,
    4219,   502,   502,    85,   330,   808,    88,   940,   941,   812,
     951,   502,   953,   286,   955,  1017,   370,   184,   250,  1049,
     961,   962,   963,  1025,   267,   181,   136,  1029,  1030,  1031,
     432,   938,   426,   149,   493,   494,   495,   496,   497,   498,
     261,   151,   808,  1049,   985,   986,   953,  1889,   955,   181,
    1100,  4244,   808,   364,   503,  3904,   505,  3734,   965,   265,
     189,   186,   198,   387,  1114,  1115,   343,  3744,   401,  1119,
     502,   181,   439,   183,   190,   445,   183,   244,   985,   986,
     286,   230,   356,   450,   502,   314,    72,   489,   403,    75,
      76,    77,    78,    25,  2446,    81,    82,    83,    84,   374,
      86,   340,   504,    35,   235,   306,  1889,  1157,  3730,    99,
    2753,   136,  1114,  1115,   383,   452,   414,  1119,   342,  1688,
    3742,  4404,   484,  1100,   399,  1925,   151,   404,    95,   502,
    3462,   434,  2249,   394,   101,   260,  3468,  3469,  3470,  3471,
    3472,  3473,  1119,  4063,   254,  1870,   183,  1872,    75,    76,
      77,    78,   425,  1028,   427,    82,  1881,  1032,   314,  1100,
    1729,  4380,   423,   489,   490,   491,  4063,   493,   494,   495,
     496,   497,   498,   502,  1049,   376,  2150,  3647,  1119,   229,
    1157,   450,   411,   208,   149,   414,   268,   319,   136,   421,
     422,   502,  3601,   328,  2036,  2387,  3419,  3606,   399,   224,
    3609,   133,   426,   193,   314,   341,   954,   314,  2229,   319,
     958,   959,   960,   334,    99,   469,  1157,   254,   295,  1221,
     968,   298,  2873,  1463,   186,   190,   342,  1256,   502,   505,
    3597,   198,   227,   181,   370,   219,   198,  2661,  2662,  4413,
     176,  1966,  2666,   306,   354,   394,  1049,  3172,   330,  2885,
     381,   505,   247,  2036,  2249,  2528,   366,    75,    76,    77,
      78,   506,  1028,   120,    82,    85,  1032,   392,    88,   332,
     114,   266,  1028,   502,   423,  2536,  1032,   314,   341,  1329,
     330,  2705,  2706,  2475,  2476,  2477,  2478,   493,   494,    71,
      88,   135,   506,    75,    76,    77,    78,    79,    80,  2790,
      82,  1378,  1304,  4477,   240,  1368,  1308,  1309,   193,  1311,
     426,   176,  3345,   390,   176,   172,   218,  2885,  1633,  3202,
     120,   305,  3063,   176,  1633,   450,  1547,  1329,  3063,   354,
     262,  1308,  1309,   508,  1311,  1922,   446,  3063,   231,  4361,
    2361,  1561,  1562,  2631,  1564,  4022,  4023,   432,  2369,  3063,
    2371,  3063,  1329,  3063,    41,  1561,  1562,  2789,  1564,   295,
     227,   151,   298,  2522,   414,   500,   314,  1308,  1309,   504,
    1311,   319,   172,  1375,   341,   240,    22,   342,   240,    89,
     247,   283,   503,  3619,   505,  3621,   913,   240,  1329,   351,
     917,  2679,   455,   286,   176,   452,   432,   270,  1331,   266,
     927,   494,   259,   370,   489,  3157,   354,  4256,   490,   491,
    2519,   493,   494,   495,   496,   497,   498,   128,   366,   186,
    2708,   446,  1532,  1500,  1501,   136,    72,  1334,  3093,  1336,
     295,  3979,  1339,   295,  1341,  1368,   298,  1344,  1345,  1346,
     268,   231,   295,  4267,   247,   298,   385,   150,   268,   306,
    1357,  1500,  1501,   229,   390,  2743,    51,   452,   240,   259,
     250,   426,   228,  1465,  1371,  4054,  1373,  1517,  1401,   505,
     268,  1521,  1522,  1475,    69,    75,    76,    77,    78,   222,
    3123,   257,    82,  1485,  3127,   412,   413,  1420,   361,   232,
     256,   452,  4040,   260,  4042,  1532,   286,   436,   446,   202,
     328,   319,  3834,  3835,   247,   271,   306,   493,   494,  1532,
     330,   506,  1514,   295,   280,  1517,   298,  1450,   218,  1521,
    1522,   385,   227,   383,  1601,   390,  1532,  4204,   390,  4118,
    1463,   388,   425,   262,   427,  2863,  1646,   390,   240,  2891,
    1517,   502,   247,   333,  1521,  1522,    14,   483,  3957,  3034,
     410,   372,  1601,  1603,  1584,  1585,    75,    76,    77,    78,
    1583,   266,   469,    82,   173,   356,   502,   370,  2589,    37,
     463,   374,   436,   276,   277,   286,  1517,  1583,  1584,  1585,
    1521,  1522,   332,   283,  1332,   452,   289,  1335,   388,  2244,
    1338,   341,  1340,   295,    85,  1343,   399,    88,   505,  1347,
      16,  1603,   227,  1633,    75,    76,    77,    78,   390,  1646,
    1640,    82,   174,  1663,   380,  2502,   370,   469,  1595,  1669,
     374,   483,   247,  1646,  4213,   392,   326,  1633,  1561,  1562,
     483,  1564,  4221,  1831,  1640,   425,   379,   427,   341,   506,
    1646,   266,   361,  1620,  1621,   399,   436,   432,   469,   502,
    1848,   184,  1593,   505,  1595,   422,   446,  1532,    85,   143,
    1710,    88,  2549,  1713,  1714,   323,   469,   151,  2038,   489,
     490,   491,  1613,   493,   494,   495,   496,   497,   498,  1620,
    1621,  2355,   401,   450,   505,   294,  1663,   296,   390,   184,
     457,  3746,  1669,   186,    14,   493,   494,   495,   496,   497,
     498,   483,   469,   353,   193,  3137,   195,   374,  1583,  1584,
    1585,   244,   462,   393,    88,   469,  1766,    37,  1828,   319,
     505,   424,  1663,   426,  1726,  2399,   341,  2097,  1669,  1532,
     393,   450,   399,  1710,  3510,   502,  1713,  1714,  1978,   113,
    3405,  3406,   422,  3386,  3072,   341,  1879,   452,  4080,   244,
     389,  3183,    72,   500,  2775,   370,   247,   273,  1633,   422,
     507,   193,  1289,   195,   392,  1640,  1532,   260,   162,  1710,
     341,  1646,  1713,  1714,   370,  1650,  1532,   268,   374,  2883,
    1583,  1584,  1585,   463,   434,  2510,   353,   432,  2772,  1766,
    1999,  1828,   103,   104,   422,   360,  1671,  2806,    34,   370,
     463,   506,  3223,   399,  3228,  1828,  3457,  3231,  3232,  3233,
    3234,  3235,  3236,  3237,  3238,  3239,  3240,  1583,   337,   384,
    1926,   471,  1828,   316,   128,  1766,  3247,   452,   399,   457,
    1633,  4379,  1834,   392,   228,   324,  3268,  1640,  1365,   330,
    4063,   268,   146,  1646,   500,  2160,   436,   158,   319,   341,
     506,  2160,  3195,   193,  1381,   195,   174,   161,  1982,     5,
    3250,  3251,   256,   422,  3288,  3289,  1393,   434,   173,   180,
     193,  1746,   195,   469,   502,   186,   216,   271,   370,    25,
    1646,   506,   314,  2725,  1650,   361,   280,  3758,  4124,    35,
    1646,  1998,   324,   216,  1650,   371,   227,   489,   457,   392,
     211,    81,   341,   330,   471,  1671,    86,   399,   212,   303,
     469,  1913,   504,   502,  1916,  1671,   247,    85,  2573,   395,
      88,  1862,   341,   470,  1990,  1990,  3702,  1990,   470,   422,
    4153,   370,  1990,   341,  3560,  3286,  1913,  1870,  3699,  1916,
    3576,   488,  2725,   502,   372,   113,   488,   252,   222,   260,
     118,   370,    97,  1828,   389,   502,   325,   450,  3601,   328,
     502,  2071,   370,  3606,   457,   222,  3609,   207,   242,  3257,
     470,   116,  1913,  1224,   314,  1916,   469,   218,   218,   319,
    1746,   222,   222,    72,   324,   242,   380,   133,   488,   294,
    1746,   296,  1925,   495,   496,   497,   319,    86,   489,   490,
     491,   324,   493,   494,   495,   496,   497,   498,   505,   502,
      71,   155,   509,    75,    76,    77,    78,  2800,    79,    80,
      82,  2023,  2186,   209,   264,  1828,   218,  1554,  2753,  1936,
     222,  1938,   218,   328,  2071,  1942,   328,  1944,   333,   250,
    1947,   333,   283,   283,  1951,  1978,  3398,   497,  2071,   500,
      85,   197,   502,   504,   504,    71,    72,  1990,   387,  3387,
    3388,  2270,  1828,  2272,  2170,  2071,   493,   494,   495,   496,
     497,   498,  1828,   507,   505,  2016,  2017,    85,   509,   247,
      88,   392,   425,  2024,   427,   326,   326,  2028,  2029,   387,
      72,   283,   501,  3062,   334,   424,   505,   105,   438,  3523,
     268,   269,  2043,  1176,  2045,  1178,   501,   447,   133,   134,
     505,   422,  1185,   823,   242,   438,   262,  2678,   828,  2680,
    2681,   158,   341,  2064,   447,  2066,   424,   837,  1379,   174,
    2160,  2133,  2265,   500,   326,   502,  2186,   504,   124,   450,
     469,   470,  2075,   389,   503,   503,   457,   506,   506,   317,
     461,   370,   862,  2263,  2160,   374,   866,   425,   469,   427,
      71,    72,   330,   505,   506,  3478,   876,  2244,    79,    80,
     207,   469,   470,   502,  2115,    86,   469,   470,  4103,  2229,
     399,   218,  2212,  2233,  2214,   222,   503,  3338,   505,    85,
     227,   502,    88,   508,  2053,   232,  2071,  2056,   235,  2249,
     237,   500,     7,   502,   502,   445,  2212,   273,  2214,   105,
    3184,   273,  3481,  3482,    19,    20,  3485,  3104,  3487,   502,
    2353,    75,    76,    77,    78,    86,  2263,   264,    82,  2339,
     503,  2233,   505,   503,    39,   505,   502,    42,   504,   503,
    2263,   505,   502,  2176,  3027,  2186,   283,  2249,   503,  2251,
     505,  2253,  2229,   328,  3308,  3309,   503,  2263,   505,  4035,
     268,   383,   384,   503,  2374,   503,    85,   505,  2071,    88,
    2510,   503,  2249,   505,  2251,   503,  2253,   505,  3061,   505,
    3704,  3705,   503,   124,   505,  2160,   105,   114,  2229,   326,
    3394,  2661,  2662,   503,   485,   505,  2666,   334,  2300,   503,
     270,   505,  2339,   383,   384,  2071,  3942,   502,  2249,   504,
    2251,  2361,  2253,   331,  3957,  2071,  2339,   504,   503,  2369,
     505,  2371,   330,   328,     2,   493,   494,   495,   496,   497,
     498,   331,   503,  2339,   505,  2705,  2706,  2212,   432,  2214,
     377,    85,   485,   503,    88,   505,   503,  2461,   505,   154,
     503,  2374,   505,   503,   328,   505,  1883,  2160,  4233,  3710,
    4235,   105,   503,   331,   505,  1892,   485,   503,  2374,   505,
     505,   506,   268,    75,    76,    77,    78,  1904,   114,   503,
      82,   505,   469,   470,  2361,   422,   486,   487,  2263,   194,
    1641,   158,  2369,  3585,  2371,   503,   270,   505,  3123,   495,
      78,  3689,  3127,  4046,  1114,  1115,    84,   399,   445,  2212,
      95,  2214,   503,   180,   505,   425,   101,   427,  2420,   186,
    2361,  2762,   387,   425,   505,   427,  2428,   503,  2369,   466,
    2371,   468,   469,   503,   330,   505,   503,  1964,   505,   117,
    1967,  3128,  1969,  3130,   211,  1972,   503,  3172,   505,   268,
    1701,   503,   503,   505,   505,   140,   226,  3478,   186,   424,
    2263,  1383,  1384,   500,  2339,   503,   503,   504,  2708,   506,
     124,   503,  2474,   505,   152,   503,   503,   505,   505,   181,
     502,   489,   490,   491,   162,   493,   494,   495,   496,   497,
     498,   469,   470,   260,  2496,   506,  2573,  2263,   495,  2374,
    2502,  2807,  2808,  2444,   469,   470,   191,  2263,  4151,   508,
    4136,   330,  1763,   198,   508,   125,   201,   432,    75,    76,
      77,    78,   262,   432,   268,    82,   432,   432,  3856,  1780,
     502,   209,   260,   204,   432,  3848,  2339,   502,   216,  2589,
     218,   162,   108,  2748,  2749,   124,   207,  2549,    75,    76,
      77,    78,   230,   268,   503,    82,   505,   218,   262,   432,
    3984,   222,   503,   173,   505,   504,   503,   252,   505,   502,
     472,  2374,  1823,  2339,   502,   502,  2686,  2510,   503,   328,
     505,  2691,   504,  2339,  4008,  4009,   330,   315,   316,   222,
     503,  3478,   505,   489,   490,   491,   506,   493,   494,   495,
     496,   497,   498,   264,   503,   281,   505,   228,  2374,   503,
     452,   505,  2589,   323,   503,  3636,   505,   503,  2374,   505,
     328,   306,   283,   502,   181,   392,   503,  1878,   505,   389,
     273,    75,    76,    77,    78,   256,  3419,  3988,    82,   249,
     502,   136,    86,   493,   494,   495,   496,   497,  2589,  2686,
     271,   501,   469,  4289,  2691,   422,   341,   108,   503,   280,
     505,  3386,   472,  2686,   392,   326,  3775,   503,  2691,   505,
     489,   490,   491,   334,   493,   494,   495,   496,   497,   498,
    2686,   502,   303,   450,   294,  2691,   296,   114,   366,   374,
     457,   503,   114,   505,   422,   503,   306,   505,  1069,  3750,
    1071,   503,   469,   505,   503,  3843,   505,   328,    75,    76,
      77,    78,   441,   341,   399,    82,   222,  4360,   158,   503,
     148,   505,   450,   401,   503,  2775,   505,   357,   452,   457,
     340,  4019,   503,   507,   505,   502,   212,   181,  4403,   212,
     503,   469,   505,   502,   212,   489,   490,   491,   212,   493,
     494,   495,   496,   497,   498,   503,  4180,   505,   503,   380,
     505,   503,   212,   505,  4092,   375,   503,   207,   505,   120,
     503,   472,   505,  2775,   502,  2708,   212,   503,   218,   505,
     505,   503,   222,   505,   445,   328,   503,   227,   505,  2722,
     328,  2318,   232,   212,   503,   235,   505,   237,  2775,   409,
     493,   494,   495,   496,   497,   503,   212,   505,  2741,   212,
     503,  2686,   163,   503,   181,   505,  2691,   126,  2069,   503,
    2753,   505,   212,   212,   264,   212,   212,   422,   502,  2770,
    4181,   452,  2773,   108,  2775,   223,   187,    75,    76,    77,
      78,   222,   281,   283,    82,   222,   502,   502,   157,   502,
     502,   502,  2962,  2963,  2964,   206,   350,   502,  3228,   338,
     502,  3231,  3232,  3233,  3234,  3235,  3236,  3237,  3238,  3239,
    3240,   502,   223,   502,   108,  4226,  3601,   126,   502,  4230,
    4231,  3606,   502,  2686,  3609,   502,   326,   238,  2691,    75,
      76,    77,    78,  1603,   334,   502,    82,  4185,   502,    75,
      76,    77,    78,   502,   502,   214,    82,   164,   157,   502,
     502,  3753,  3022,   502,    75,    76,    77,    78,  3288,  3289,
    2686,    82,   502,   505,   502,  2691,   502,   502,   502,  4242,
    2686,   502,   502,  3902,   266,  2691,   245,   377,  3080,  2962,
    2963,  2964,   281,   268,   108,   222,  2948,   326,   222,   495,
    3060,   262,   390,   298,  4227,   505,  2962,  2963,  2964,   637,
     180,  3848,   451,   505,   489,   214,  2968,  4228,   319,    14,
    3753,   505,   502,   502,  3116,   432,   327,  3027,   502,   432,
    3113,   504,   422,   432,   432,  3022,   432,   328,   319,   391,
     432,   432,   451,   143,   328,   432,   245,  2999,   252,  3022,
    3002,  3003,   432,  3080,  3006,   445,   432,   505,   359,  1295,
     502,  3061,   341,   341,  3016,   175,  3022,   452,  3081,  3021,
    1306,  4309,   432,  3060,   432,  3027,   466,   452,   468,   469,
     124,  3033,   341,  3096,  1744,   432,   124,  3060,   432,  3116,
     502,   432,   332,   387,   328,   328,   268,   432,   432,   432,
    3027,   469,   432,  3116,  3060,   502,  3296,   432,  2585,  3061,
     500,   370,   432,   503,   504,   374,   506,   460,   502,   378,
     502,   108,  2323,  3075,   107,   384,    97,   181,   452,   289,
     108,   463,   391,   222,  3061,   502,  3027,  2962,  2963,  2964,
     399,  3032,  3033,  3298,  3299,  3300,  3301,   462,   407,   108,
     273,  3103,  3104,   504,   466,   212,   415,   388,    14,   452,
     212,   212,   452,  3054,   212,   323,   432,   377,  3181,   457,
    3061,   318,  1832,   465,   227,   374,   502,   376,   430,   378,
     808,   485,  4141,   505,   812,   384,    88,  1847,   816,   505,
     399,   300,   391,   300,   822,   430,   502,  3022,  3081,  4203,
     399,  3261,   502,  3523,  4427,   464,   432,   227,   407,  2962,
    2963,  2964,   489,  3096,    98,   434,   415,   241,   505,   505,
     503,   489,   241,    95,   264,   853,   329,   324,    34,   101,
      10,   505,   505,  3116,   503,  3060,   503,  2438,   503,   432,
    3123,   432,   387,   150,  3127,  1905,  2962,  2963,  2964,   387,
     452,   502,   502,   319,   272,  4047,  2962,  2963,  2964,   272,
     319,   319,   335,   328,   327,   464,   894,   432,   140,  3022,
     432,   155,   370,   505,  3261,  4067,   370,   905,   370,   396,
     432,   432,  3957,   361,   912,   108,   268,   268,  3261,   268,
     327,   175,   268,   452,   268,   452,   502,   181,  3181,   489,
     107,   432,   500,    95,   932,  3261,  3022,  3060,   500,   101,
     432,   222,   196,   489,  4047,   224,  3022,   324,  3432,   191,
    3272,   502,  3613,   211,   396,   108,   198,   328,   328,   201,
    4063,   239,   496,   239,  4067,   222,   505,   108,   212,   502,
     224,   396,   328,   328,  3060,   229,   222,   502,   140,   247,
     247,   235,   247,   472,  3060,   505,    96,   297,  3418,   328,
    3420,   505,   233,  3315,   124,   227,   250,   485,   503,   108,
    4437,  4046,   505,   503,  2851,  2852,   503,  2854,   503,   503,
     252,   485,   503,  3443,  3704,  3705,   227,   126,   503,   502,
     274,  4066,   466,   432,  1022,   503,   337,   503,   503,   191,
    1028,  4320,   503,   502,  1032,  4242,   198,   503,   503,   201,
     503,  2612,   503,  3296,    90,  4482,   503,    90,   157,  3419,
     506,  1049,   505,  4490,   503,   489,   503,   328,  4103,   283,
    1058,  3418,  3432,  3420,   306,   505,  3261,   331,   328,   455,
     502,   502,   502,   432,   258,  3418,   330,  3420,   212,   319,
     212,   283,   345,   345,   292,   449,   292,   432,   292,   432,
     252,   503,  3418,   268,  3420,   432,   432,  3419,   432,   341,
    3443,   432,  3363,   357,  2951,   214,  4151,   432,  3478,   432,
     268,  3433,   268,   268,  3436,   500,  3438,  3443,   298,   268,
     268,   268,  3419,   108,   503,   332,   283,   381,   370,   489,
     174,   503,   374,   387,   441,   372,   245,   505,  3261,   393,
    3462,   126,   396,   328,   306,   327,  3468,  3469,  3470,  3471,
    3472,  3473,   502,   236,   271,  4317,  3478,   399,  3419,   432,
     271,   503,   502,   336,   273,   324,   452,   502,   422,   452,
     424,  3432,   157,   222,   428,  3261,   210,   387,   387,   341,
     331,  3478,   436,  3505,   387,  3261,   505,   441,   210,   204,
     227,   500,  3514,  3515,  3516,  3517,  3493,   451,  1196,    88,
     503,   222,   503,  2233,  3051,  1203,  3053,   503,   370,   463,
     462,   134,   374,   227,  4317,   502,   235,  3478,   503,   503,
     489,   503,   502,  3418,   329,  3420,  1224,   222,   503,   214,
    2260,  3492,  3493,   489,  2264,   505,   489,   399,  3767,   222,
    3501,   258,   441,   441,  3505,   432,   432,  3630,  3443,   432,
     268,  3573,   503,  3514,   432,  1253,  2286,   268,   503,   502,
     245,   108,   501,   272,  2294,   374,  3636,  1873,   503,   378,
     503,   502,   469,   222,   503,   384,  1882,   472,  3762,   469,
     505,   253,   391,   505,  1890,  1891,   146,  2317,   273,   424,
     399,   505,   432,    85,  3984,  3418,   271,  3420,   407,   469,
     396,   502,  1908,   503,  3788,   232,   415,  2337,  4353,   227,
    1308,  1309,   503,  1311,   502,  4360,   227,   124,  4008,  4009,
    3443,  1319,   503,  3170,  2354,   467,   505,  2357,   502,   467,
     502,   237,  3418,   432,  3420,   503,   503,   503,   469,  3636,
     227,  4386,  3418,   441,  3420,  2375,   319,  3194,  3601,   319,
     489,   505,  2382,  3606,   212,   464,  3609,  3443,  2929,   468,
    2931,  2391,   505,   268,   188,   319,   183,  3443,  2398,   254,
     229,   817,   501,   227,   820,  3636,   452,  3630,   452,   199,
     465,  1379,   469,   502,    85,   227,   502,    88,   255,   374,
     836,   331,  3762,   378,  3878,   502,   227,   456,   502,   384,
     502,   408,   503,   503,   468,   344,   391,  1405,   503,   503,
     366,   328,   113,   859,   399,   469,  3846,   118,  3788,   452,
     502,   502,   407,   222,  3746,  3747,   108,   319,   874,  3000,
     415,   293,   250,   502,   211,  1433,  3758,   174,   332,    85,
     384,  4486,    88,   384,   136,   331,   136,   489,   124,  3746,
     334,    95,   502,   222,   328,   424,   217,   101,   358,   105,
     331,  3758,  1460,  1461,   194,  1463,   331,   113,    85,   456,
     505,   108,   118,   227,  3904,   466,   364,   505,  1476,   464,
     469,   199,  1480,   468,   469,  3746,   108,   328,   328,  3846,
    4180,   469,   502,   383,   502,    85,   140,  3758,    88,   503,
     503,  3762,   186,  3846,   450,   206,   502,  3078,  3878,    94,
     383,   105,  3834,  3835,   211,   105,   502,  2460,  2775,  1517,
    3846,  3092,   358,   113,   358,  3908,  3848,  3788,   118,  1522,
    1747,  3853,  3854,  1531,  1532,  3857,  3858,  2345,  3799,  3800,
    3418,  2896,   243,  3804,  3805,  4083,   247,   191,  3870,  3871,
    3872,  3873,  3874,  2159,   198,  3021,  3846,   201,  4242,  3564,
    4136,  3904,  3895,  4140,  2858,  1563,  2578,   268,   269,  1567,
    1568,  3142,  4384,  4046,  4426,  4347,  4346,  4393,  3904,  1849,
    3566,   282,  2290,  3443,  2963,  1583,  1584,  1585,  4160,  1835,
    2448,  3074,  3914,  4429,  4490,  4482,  3864,   243,  3863,  3060,
    3026,   247,  4400,  4069,  4328,  1826,   188,  4072,   252,  3870,
    3871,  3872,  3873,  3874,  3639,  1366,   317,  3878,  4209,  3941,
    3574,  2313,   268,   269,  3576,  4289,  4409,  4484,   902,   330,
    1043,  4125,  2170,  1926,  2171,  1633,   282,  3208,  3558,  3182,
    2786,  1322,  1640,  1641,  2561,  1060,  1553,  2797,  1646,  2206,
    1571,  3846,  1650,   243,  1570,  3908,  3227,   247,  2809,  2803,
    2205,  2189,   306,  1573,  2163,  2753,  2510,  3129,   314,  3958,
    1048,   317,  2787,  1671,  3555,   896,  4183,  3263,   268,   269,
    1678,  3252,  4373,  3271,   330,  4374,  2800,   333,  2722,  4377,
    3537,  3538,   282,  4063,  2633,  2601,  2720,   341,  2100,   637,
    2503,  3113,   403,  1701,  3957,  1260,  1864,  2661,  2662,  3904,
    2233,  4367,  2666,  1159,  1160,  3286,  1585,   367,   934,  1579,
    2209,  1137,  1117,  3846,   314,  1117,   370,   317,  1378,  2249,
     374,  2241,  2769,  4030,  2242,  3745,  3366,  3343,  3367,   400,
     330,  4063,  1583,   333,  1497,  2574,  1956,     2,  1746,  2253,
      -1,  2705,  2706,    -1,    -1,   399,  1308,   403,  4080,   964,
    3846,    -1,  4084,    -1,    -1,  1763,  4063,    -1,    -1,  4030,
    3846,    -1,  1218,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,  3904,  1780,    -1,  3631,  3632,  3633,    -1,  1234,  1235,
      -1,    -1,   493,   494,   495,   496,   497,   498,    -1,    -1,
    1798,    -1,  4063,    -1,    -1,  1251,    -1,    -1,    -1,    -1,
    2840,    -1,    -1,   403,    -1,    -1,    -1,    -1,  3904,    -1,
      -1,    -1,    -1,    -1,    -1,  1823,  4256,    -1,  3904,    -1,
    1828,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,  1285,
    1286,    -1,    -1,   489,   490,   491,    -1,   493,   494,   495,
     496,   497,   498,    -1,    -1,   501,    -1,    -1,    -1,    -1,
      -1,   507,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,  1870,    -1,  1872,    -1,    -1,    -1,    -1,    -1,
    1878,  4441,    -1,  1881,    -1,    -1,    -1,    -1,    -1,    -1,
      -1,    -1,    -1,    -1,    -1,  2925,    -1,    -1,    -1,   489,
     490,   491,  2932,   493,   494,   495,   496,   497,   498,    -1,
      -1,   501,    -1,  4256,    -1,  1913,    -1,    -1,  1916,    -1,
    4242,  2527,    -1,  4293,    -1,    -1,    -1,    -1,    -1,    -1,
    4256,    -1,    -1,    -1,    -1,  2541,  2542,    -1,    -1,  2545,
      -1,    -1,    -1,    -1,    -1,  2551,    85,    -1,    -1,    88,
      -1,    -1,    -1,    -1,    -1,    -1,    -1,    -1,    85,    -1,
      -1,    88,    -1,    -1,  2994,    -1,    -1,    -1,  1966,    -1,
    3541,    -1,  3819,  3820,   11