.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "DROP SCHEMA" "" "2012-02-23" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP SCHEMA \- remove a schema

.SH SYNOPSIS
.sp
.nf
DROP SCHEMA [ IF EXISTS ] \fIname\fR [, ...] [ CASCADE | RESTRICT ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDROP SCHEMA\fR removes schemas from the database.
.PP
A schema can only be dropped by its owner or a superuser. Note that
the owner can drop the schema (and thereby all contained objects)
even if he does not own some of the objects within the schema.
.SH "PARAMETERS"
.TP
\fBIF EXISTS\fR
Do not throw an error if the schema does not exist. A notice is issued 
in this case.
.TP
\fB\fIname\fB\fR
The name of a schema.
.TP
\fBCASCADE\fR
Automatically drop objects (tables, functions, etc.) that are
contained in the schema.
.TP
\fBRESTRICT\fR
Refuse to drop the schema if it contains any objects. This is
the default.
.SH "EXAMPLES"
.PP
To remove schema mystuff from the database,
along with everything it contains:
.sp
.nf
DROP SCHEMA mystuff CASCADE;
.sp
.fi
.SH "COMPATIBILITY"
.PP
\fBDROP SCHEMA\fR is fully conforming with the SQL
standard, except that the standard only allows one schema to be
dropped per command, and apart from the 
IF EXISTS option, which is a PostgreSQL 
extension.
.SH "SEE ALSO"
ALTER SCHEMA [\fBalter_schema\fR(l)], CREATE SCHEMA [\fBcreate_schema\fR(l)]
