.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "CREATE CAST" "" "2011-09-22" "SQL - Language Statements" "SQL Commands"
.SH NAME
CREATE CAST \- define a new cast

.SH SYNOPSIS
.sp
.nf
CREATE CAST (\fIsourcetype\fR AS \fItargettype\fR)
    WITH FUNCTION \fIfuncname\fR (\fIargtypes\fR)
    [ AS ASSIGNMENT | AS IMPLICIT ]

CREATE CAST (\fIsourcetype\fR AS \fItargettype\fR)
    WITHOUT FUNCTION
    [ AS ASSIGNMENT | AS IMPLICIT ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBCREATE CAST\fR defines a new cast. A cast
specifies how to perform a conversion between
two data types. For example:
.sp
.nf
SELECT CAST(42 AS float8);
.sp
.fi
converts the integer constant 42 to type \fBfloat8\fR by
invoking a previously specified function, in this case
float8(int4). (If no suitable cast has been defined, the
conversion fails.)
.PP
Two types can be \fIbinary compatible\fR, which
means that they can be converted into one another ``for
free'' without invoking any function. This requires that
corresponding values use the same internal representation. For
instance, the types \fBtext\fR and \fBvarchar\fR are
binary compatible.
.PP
By default, a cast can be invoked only by an explicit cast request,
that is an explicit CAST(\fIx\fR AS
\fItypename\fR) or
\fIx\fR::\fItypename\fR
construct.
.PP
If the cast is marked AS ASSIGNMENT then it can be invoked
implicitly when assigning a value to a column of the target data type.
For example, supposing that foo.f1 is a column of
type \fBtext\fR, then:
.sp
.nf
INSERT INTO foo (f1) VALUES (42);
.sp
.fi
will be allowed if the cast from type \fBinteger\fR to type
\fBtext\fR is marked AS ASSIGNMENT, otherwise not.
(We generally use the term \fIassignment
cast\fR to describe this kind of cast.)
.PP
If the cast is marked AS IMPLICIT then it can be invoked
implicitly in any context, whether assignment or internally in an
expression. (We generally use the term \fIimplicit
cast\fR to describe this kind of cast.)
For example, consider this query:
.sp
.nf
SELECT 2 + 4.0;
.sp
.fi
The parser initially marks the constants as being of type \fBinteger\fR
and \fBnumeric\fR respectively. There is no \fBinteger\fR
+ \fBnumeric\fR operator in the system catalogs,
but there is a \fBnumeric\fR + \fBnumeric\fR operator.
The query will therefore succeed if a cast from \fBinteger\fR to
\fBnumeric\fR is available and is marked AS IMPLICIT \(em
which in fact it is. The parser will apply the implicit cast and resolve
the query as if it had been written
.sp
.nf
SELECT CAST ( 2 AS numeric ) + 4.0;
.sp
.fi
.PP
Now, the catalogs also provide a cast from \fBnumeric\fR to
\fBinteger\fR. If that cast were marked AS IMPLICIT \(em
which it is not \(em then the parser would be faced with choosing
between the above interpretation and the alternative of casting the
\fBnumeric\fR constant to \fBinteger\fR and applying the
\fBinteger\fR + \fBinteger\fR operator. Lacking any
knowledge of which choice to prefer, it would give up and declare the
query ambiguous. The fact that only one of the two casts is
implicit is the way in which we teach the parser to prefer resolution
of a mixed \fBnumeric\fR-and-\fBinteger\fR expression as
\fBnumeric\fR; there is no built-in knowledge about that.
.PP
It is wise to be conservative about marking casts as implicit. An
overabundance of implicit casting paths can cause
PostgreSQL to choose surprising
interpretations of commands, or to be unable to resolve commands at
all because there are multiple possible interpretations. A good
rule of thumb is to make a cast implicitly invokable only for
information-preserving transformations between types in the same
general type category. For example, the cast from \fBint2\fR to
\fBint4\fR can reasonably be implicit, but the cast from
\fBfloat8\fR to \fBint4\fR should probably be
assignment-only. Cross-type-category casts, such as \fBtext\fR
to \fBint4\fR, are best made explicit-only.
.PP
To be able to create a cast, you must own the source or the target
data type. To create a binary-compatible cast, you must be superuser.
(This restriction is made because an erroneous binary-compatible cast
conversion can easily crash the server.)
.SH "PARAMETERS"
.TP
\fB\fIsourcetype\fB\fR
The name of the source data type of the cast.
.TP
\fB\fItargettype\fB\fR
The name of the target data type of the cast.
.TP
\fB\fIfuncname\fB(\fIargtypes\fB)\fR
The function used to perform the cast. The function name can
be schema-qualified. If it is not, the function will be looked
up in the schema search path. The function's result data type must
match the target type of the cast. Its arguments are discussed below.
.TP
\fBWITHOUT FUNCTION\fR
Indicates that the source type and the target type are binary
compatible, so no function is required to perform the cast.
.TP
\fBAS ASSIGNMENT\fR
Indicates that the cast can be invoked implicitly in assignment
contexts.
.TP
\fBAS IMPLICIT\fR
Indicates that the cast can be invoked implicitly in any context.
.PP
Cast implementation functions can have one to three arguments.
The first argument type must be identical to the cast's source type.
The second argument,
if present, must be type \fBinteger\fR; it receives the type
modifier associated with the destination type, or -1
if there is none. The third argument,
if present, must be type \fBboolean\fR; it receives true
if the cast is an explicit cast, false otherwise.
(Bizarrely, the SQL spec demands different behaviors for explicit and
implicit casts in some cases. This argument is supplied for functions
that must implement such casts. It is not recommended that you design
your own data types so that this matters.)
.PP
.PP
Ordinarily a cast must have different source and target data types.
However, it is allowed to declare a cast with identical source and
target types if it has a cast implementation function with more than one
argument. This is used to represent type-specific length coercion
functions in the system catalogs. The named function is used to
coerce a value of the type to the type modifier value given by its
second argument.
.PP
.PP
When a cast has different source and
target types and a function that takes more than one argument, it
represents converting from one type to another and applying a length
coercion in a single step. When no such entry is available, coercion
to a type that uses a type modifier involves two steps, one to
convert between data types and a second to apply the modifier.
.PP
.SH "NOTES"
.PP
Use DROP CAST [\fBdrop_cast\fR(l)] to remove user-defined casts.
.PP
Remember that if you want to be able to convert types both ways you
need to declare casts both ways explicitly.

.PP
It is normally not necessary to create casts between user-defined types
and the standard string types (\fBtext\fR, \fBvarchar\fR, and
\fBchar(\fIn\fB)\fR). PostgreSQL will
automatically handle a cast to a string type by invoking the other
type's output function, or conversely handle a cast from a string type
by invoking the other type's input function. These
automatically-provided casts are known as \fII/O conversion
casts\fR. I/O conversion casts to string types are treated as
assignment casts, while I/O conversion casts from string types are
explicit-only. You can override this behavior by declaring your own
cast to replace an I/O conversion cast, but usually the only reason to
do so is if you want the conversion to be more easily invokable than the
standard assignment-only or explicit-only setting. Another possible
reason is that you want the conversion to behave differently from the
type's I/O function; but that is sufficiently surprising that you
should think twice about whether it's a good idea. (A small number of
the built-in types do indeed have different behaviors for conversions,
mostly because of requirements of the SQL standard.)
.PP
Prior to PostgreSQL 7.3, every function that had
the same name as a data type, returned that data type, and took one
argument of a different type was automatically a cast function.
This convention has been abandoned in face of the introduction of
schemas and to be able to represent binary compatible casts in the
system catalogs. The built-in cast functions still follow this naming
scheme, but they have to be shown as casts in the system catalog
\fBpg_cast\fR as well.
.PP
While not required, it is recommended that you continue to follow this old
convention of naming cast implementation functions after the target data
type. Many users are used to being able to cast data types using a
function-style notation, that is
\fItypename\fR(\fIx\fR). This notation is in fact
nothing more nor less than a call of the cast implementation function; it
is not specially treated as a cast. If your conversion functions are not
named to support this convention then you will have surprised users.
Since PostgreSQL allows overloading of the same function
name with different argument types, there is no difficulty in having
multiple conversion functions from different types that all use the
target type's name.
.sp
.RS
.B "Note:"
Actually the preceding paragraph is an oversimplification: there are
two cases in which a function-call construct will be treated as a cast
request without having matched it to an actual function.
If a function call \fIname\fR(\fIx\fR) does not
exactly match any existing function, but \fIname\fR is the name
of a data type and \fBpg_cast\fR provides a binary-compatible cast
to this type from the type of \fIx\fR, then the call will be
construed as a binary-compatible cast. This exception is made so that
binary-compatible casts can be invoked using functional syntax, even
though they lack any function. Likewise, if there is no
\fBpg_cast\fR entry but the cast would be to or from a string
type, the call will be construed as an I/O conversion cast. This
exception allows I/O conversion casts to be invoked using functional
syntax.
.RE
.sp
.SH "EXAMPLES"
.PP
To create a cast from type \fBbigint\fR to type
\fBint4\fR using the function int4(bigint):
.sp
.nf
CREATE CAST (bigint AS int4) WITH FUNCTION int4(bigint);
.sp
.fi
(This cast is already predefined in the system.)
.SH "COMPATIBILITY"
.PP
The \fBCREATE CAST\fR command conforms to the
SQL standard,
except that SQL does not make provisions for binary-compatible
types or extra arguments to implementation functions.
AS IMPLICIT is a PostgreSQL 
extension, too.
.SH "SEE ALSO"
.PP
CREATE FUNCTION [\fBcreate_function\fR(l)],
CREATE TYPE [\fBcreate_type\fR(l)],
DROP CAST [\fBdrop_cast\fR(l)]
