.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "DROP AGGREGATE" "" "2011-01-27" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP AGGREGATE \- remove an aggregate function

.SH SYNOPSIS
.sp
.nf
DROP AGGREGATE [ IF EXISTS ] \fIname\fR ( \fItype\fR [ , ... ] ) [ CASCADE | RESTRICT ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDROP AGGREGATE\fR will delete an existing
aggregate function. To execute this command the current
user must be the owner of the aggregate function.
.SH "PARAMETERS"
.TP
\fBIF EXISTS\fR
Do not throw an error if the aggregate does not exist. A notice is issued
in this case.
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing aggregate function.
.TP
\fB\fItype\fB\fR
An input data type on which the aggregate function operates.
To reference a zero-argument aggregate function, write *
in place of the list of input data types.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the aggregate function.
.TP
\fBRESTRICT\fR
Refuse to drop the aggregate function if any objects depend on
it. This is the default.
.SH "EXAMPLES"
.PP
To remove the aggregate function myavg for type
\fBinteger\fR:
.sp
.nf
DROP AGGREGATE myavg(integer);
.sp
.fi
.SH "COMPATIBILITY"
.PP
There is no \fBDROP AGGREGATE\fR statement in the SQL
standard.
.SH "SEE ALSO"
ALTER AGGREGATE [\fBalter_aggregate\fR(l)], CREATE AGGREGATE [\fBcreate_aggregate\fR(l)]
