.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "ALTER OPERATOR CLASS" "" "2010-12-14" "SQL - Language Statements" "SQL Commands"
.SH NAME
ALTER OPERATOR CLASS \- change the definition of an operator class

.SH SYNOPSIS
.sp
.nf
ALTER OPERATOR CLASS \fIname\fR USING \fIindex_method\fR RENAME TO \fInewname\fR
ALTER OPERATOR CLASS \fIname\fR USING \fIindex_method\fR OWNER TO \fInewowner\fR
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBALTER OPERATOR CLASS\fR changes the definition of
an operator class.
.PP
You must own the operator class to use \fBALTER OPERATOR CLASS\fR.
To alter the owner, you must also be a direct or indirect member of the new
owning role, and that role must have CREATE privilege on
the operator class's schema. (These restrictions enforce that altering the
owner doesn't do anything you couldn't do by dropping and recreating the
operator class. However, a superuser can alter ownership of any operator
class anyway.)
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing operator
class.
.TP
\fB\fIindex_method\fB\fR
The name of the index method this operator class is for.
.TP
\fB\fInewname\fB\fR
The new name of the operator class.
.TP
\fB\fInewowner\fB\fR
The new owner of the operator class.
.SH "COMPATIBILITY"
.PP
There is no \fBALTER OPERATOR CLASS\fR statement in
the SQL standard.
.SH "SEE ALSO"
CREATE OPERATOR CLASS [\fBcreate_operator_class\fR(l)], DROP OPERATOR CLASS [\fBdrop_operator_class\fR(l)]
