.\\" auto-generated by docbook2man-spec $Revision: 1.25 $
.TH "DROP FUNCTION" "l" "2003-11-02" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP FUNCTION \- remove a function

.SH SYNOPSIS
.sp
.nf
DROP FUNCTION \fIname\fR ( [ \fItype\fR [, ...] ] ) [ CASCADE | RESTRICT ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDROP FUNCTION\fR removes the definition of an existing
function. To execute this command the user must be the
owner of the function. The argument types to the
function must be specified, since several different functions
may exist with the same name and different argument lists.
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of an existing function.
.TP
\fB\fItype\fB\fR
The data type of an argument of the function.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the function (such as
operators or triggers).
.TP
\fBRESTRICT\fR
Refuse to drop the function if any objects depend on it. This
is the default.
.SH "EXAMPLES"
.PP
This command removes the square root function:
.sp
.nf
DROP FUNCTION sqrt(integer);
.sp
.fi
.SH "COMPATIBILITY"
.PP
A \fBDROP FUNCTION\fR statement is defined in the SQL
standard, but it is not compatible with this command.
.SH "SEE ALSO"
CREATE FUNCTION [\fBcreate_function\fR(l)], ALTER FUNCTION [\fBalter_function\fR(l)]

