.\\" auto-generated by docbook2man-spec $Revision: 1.1.1.1 $
.TH "DROP TABLE" "" "2010-05-14" "SQL - Language Statements" "SQL Commands"
.SH NAME
DROP TABLE \- remove a table

.SH SYNOPSIS
.sp
.nf
DROP TABLE \fIname\fR [, ...] [ CASCADE | RESTRICT ]
.sp
.fi
.SH "DESCRIPTION"
.PP
\fBDROP TABLE\fR removes tables from the database.
Only its owner may destroy a table. To empty a table of rows,
without destroying the table, use \fBDELETE\fR.
.PP
\fBDROP TABLE\fR always removes any indexes, rules,
triggers, and constraints that exist for the target table.
However, to drop a table that is referenced by a foreign-key
constraint of another table, CASCADE must be
specified. (CASCADE will remove the foreign-key
constraint, not the other table entirely.)
.SH "PARAMETERS"
.TP
\fB\fIname\fB\fR
The name (optionally schema-qualified) of the table to drop.
.TP
\fBCASCADE\fR
Automatically drop objects that depend on the table (such as
views).
.TP
\fBRESTRICT\fR
Refuse to drop the table if any objects depend on it. This is
the default.
.SH "EXAMPLES"
.PP
To destroy two tables, films and 
distributors:
.sp
.nf
DROP TABLE films, distributors;
.sp
.fi
.SH "COMPATIBILITY"
.PP
This command conforms to the SQL standard.
.SH "SEE ALSO"
ALTER TABLE [\fBalter_table\fR(l)], CREATE TABLE [\fBcreate_table\fR(l)]
