.\" This manpage has been automatically generated by docbook2man 
.\" from a DocBook document.  This tool can be found at:
.\" <http://shell.ipoline.com/~elmert/hacks/docbook2X/> 
.\" Please send any bug reports, improvements, comments, patches, 
.\" etc. to Steve Cheng <steve@ggi-project.org>.
.\" Patched 1999-08-03 by Thomas Lockhart <lockhart@alumni.caltech.edu>
.\" for the PostgreSQL RDBMS project (http://postgresql.org).
.TH "CREATE_DATABASE" "l" "08 May 2000" "SQL - Language Statements" ""
.SH NAME
CREATE DATABASE \- Creates a new database
.SH SYNOPSIS
.sp
.nf
CREATE DATABASE \fIname\fR [ WITH LOCATION = '\fIdbpath\fR' ]
  
.sp
.fi
.SS "INPUTS"
.PP
.TP
\fB\fIname\fB\fR
The name of a database to create.
.TP
\fB\fIdbpath\fB\fR
An alternate location where to store the new database in the filesystem.
See below for caveats.
.PP
.SS "OUTPUTS"
.PP
.TP
\fBCREATE DATABASE\fR
Message returned if the command completes successfully.
.TP
\fBERROR: user '\fIusername\fB' is not allowed to create/drop databases\fR
You must have the special CREATEDB privilege to create databases.
See \fBcreate_user\fR(l).
.TP
\fBERROR: createdb: database "\fIname\fB" already exists\fR
This occurs if a database with the \fIname\fR
specified already exists.
.TP
\fBERROR: Single quotes are not allowed in database names.\fR
.TP
\fBERROR: Single quotes are not allowed in database paths.\fR
The database \fIname\fR and
\fIdbpath\fR cannot contain
single quotes. This is required so that the shell commands that
create the database directory can execute safely.
.TP
\fBERROR: The path 'xxx' is invalid.\fR
The expansion of the specified \fIdbpath\fR
(see below how) failed. Check the path you entered or make sure that the
environment variable you are referencing does exist.
.TP
\fBERROR: createdb: May not be called in a transaction block.\fR
If you have an explicit transaction block in progress you cannot call
\fBCREATE DATABASE\fR. You must finish the transaction first.
.TP
\fBERROR: Unable to create database directory '\fIpath\fB'.\fR
.TP
\fBERROR: Could not initialize database directory.\fR
These are most likely related to insufficient permissions on the data
directory, a full disk, or other file system problems. The user under
which the database server is running, must have access to the location.
.PP
.SH "DESCRIPTION"
.PP
\fBCREATE DATABASE\fR creates a new
Postgres database.
The creator becomes the owner of the new database.
.PP
An alternate location can be specified in order to,
for example, store the database on a different disk.
The path must have been prepared with the 
\fBinitlocation\fR(1)
command.
.PP
If the path contains a slash, the leading part is interpreted
as an environment variable, which must be known to the
server process. This way the database administrator can
exercise control over at which locations databases can be created.
(A customary choice is, e.g., '\fBPGDATA2\fR'.)
If the server is compiled with ALLOW_ABSOLUTE_DBPATHS
(not so by default), absolute path names, as identified by
a leading slash
(e.g. '\fI/usr/local/pgsql/data\fR'),
are allowed as well.
.SS "NOTES"
.PP
\fBCREATE DATABASE\fR is a Postgres
language extension.
.PP
Use \fBdrop_database\fR(l) to remove a database.
.PP
The program \fBcreatedb\fR(1) is a
shell script wrapper around this command, provided for convenience.
.PP
There are security and data integrity issues
involved with using alternate database locations
specified with absolute path names, and by default
only an environment variable known to the backend may be
specified for an alternate location.
See the Administrator's Guide for more information.
.SH "USAGE"
.PP
To create a new database:
.sp
.nf
olly=> \fBcreate database lusiadas;\fR
   
.sp
.fi
.PP
To create a new database in an alternate area \fI~/private_db\fR:
.sp
.nf
$ \fBmkdir private_db\fR
$ \fBinitlocation ~/private_db\fR
Creating Postgres database system directory /home/olly/private_db/base
   
$ \fBpsql olly\fR
Welcome to psql, the PostgreSQL interactive terminal.
 
Type:  \\copyright for distribution terms
       \\h for help with SQL commands
       \\? for help on internal slash commands
       \\g or terminate with semicolon to execute query
       \\q to quit

olly=> \fBCREATE DATABASE elsewhere WITH LOCATION = '/home/olly/private_db';\fR
CREATE DATABASE
   
.sp
.fi
.SH "COMPATIBILITY"
.SS "SQL92"
.PP
There is no \fBCREATE DATABASE\fR statement in SQL92.
Databases are equivalent to catalogs whose creation is implementation-defined.
