#line 2 "scan.c"
/*-------------------------------------------------------------------------
 *
 * scan.l
 *	  lexical scanner for PostgreSQL
 *
 * NOTE NOTE NOTE:
 *
 * The rules in this file must be kept in sync with src/fe_utils/psqlscan.l
 * and src/interfaces/ecpg/preproc/pgc.l!
 *
 * The rules are designed so that the scanner never has to backtrack,
 * in the sense that there is always a rule that can match the input
 * consumed so far (the rule action may internally throw back some input
 * with yyless(), however).  As explained in the flex manual, this makes
 * for a useful speed increase --- several percent faster when measuring
 * raw parsing (Flex + Bison).  The extra complexity is mostly in the rules
 * for handling float numbers and continued string literals.  If you change
 * the lexical rules, verify that you haven't broken the no-backtrack
 * property by running flex with the "-b" option and checking that the
 * resulting "lex.backup" file says that no backing up is needed.  (As of
 * Postgres 9.2, this check is made automatically by the Makefile.)
 *
 *
 * Portions Copyright (c) 1996-2023, PostgreSQL Global Development Group
 * Portions Copyright (c) 1994, Regents of the University of California
 *
 * IDENTIFICATION
 *	  src/backend/parser/scan.l
 *
 *-------------------------------------------------------------------------
 */
#include "postgres.h"

#include <ctype.h>
#include <unistd.h>

#include "common/string.h"
#include "gramparse.h"
#include "nodes/miscnodes.h"
#include "parser/parser.h"		/* only needed for GUC variables */
#include "parser/scansup.h"
#include "port/pg_bitutils.h"
#include "mb/pg_wchar.h"
#include "utils/builtins.h"

#line 48 "scan.c"

#define  YY_INT_ALIGNED short int

/* A lexical scanner generated by flex */

#define FLEX_SCANNER
#define YY_FLEX_MAJOR_VERSION 2
#define YY_FLEX_MINOR_VERSION 6
#define YY_FLEX_SUBMINOR_VERSION 4
#if YY_FLEX_SUBMINOR_VERSION > 0
#define FLEX_BETA
#endif

#ifdef yy_create_buffer
#define core_yy_create_buffer_ALREADY_DEFINED
#else
#define yy_create_buffer core_yy_create_buffer
#endif

#ifdef yy_delete_buffer
#define core_yy_delete_buffer_ALREADY_DEFINED
#else
#define yy_delete_buffer core_yy_delete_buffer
#endif

#ifdef yy_scan_buffer
#define core_yy_scan_buffer_ALREADY_DEFINED
#else
#define yy_scan_buffer core_yy_scan_buffer
#endif

#ifdef yy_scan_string
#define core_yy_scan_string_ALREADY_DEFINED
#else
#define yy_scan_string core_yy_scan_string
#endif

#ifdef yy_scan_bytes
#define core_yy_scan_bytes_ALREADY_DEFINED
#else
#define yy_scan_bytes core_yy_scan_bytes
#endif

#ifdef yy_init_buffer
#define core_yy_init_buffer_ALREADY_DEFINED
#else
#define yy_init_buffer core_yy_init_buffer
#endif

#ifdef yy_flush_buffer
#define core_yy_flush_buffer_ALREADY_DEFINED
#else
#define yy_flush_buffer core_yy_flush_buffer
#endif

#ifdef yy_load_buffer_state
#define core_yy_load_buffer_state_ALREADY_DEFINED
#else
#define yy_load_buffer_state core_yy_load_buffer_state
#endif

#ifdef yy_switch_to_buffer
#define core_yy_switch_to_buffer_ALREADY_DEFINED
#else
#define yy_switch_to_buffer core_yy_switch_to_buffer
#endif

#ifdef yypush_buffer_state
#define core_yypush_buffer_state_ALREADY_DEFINED
#else
#define yypush_buffer_state core_yypush_buffer_state
#endif

#ifdef yypop_buffer_state
#define core_yypop_buffer_state_ALREADY_DEFINED
#else
#define yypop_buffer_state core_yypop_buffer_state
#endif

#ifdef yyensure_buffer_stack
#define core_yyensure_buffer_stack_ALREADY_DEFINED
#else
#define yyensure_buffer_stack core_yyensure_buffer_stack
#endif

#ifdef yylex
#define core_yylex_ALREADY_DEFINED
#else
#define yylex core_yylex
#endif

#ifdef yyrestart
#define core_yyrestart_ALREADY_DEFINED
#else
#define yyrestart core_yyrestart
#endif

#ifdef yylex_init
#define core_yylex_init_ALREADY_DEFINED
#else
#define yylex_init core_yylex_init
#endif

#ifdef yylex_init_extra
#define core_yylex_init_extra_ALREADY_DEFINED
#else
#define yylex_init_extra core_yylex_init_extra
#endif

#ifdef yylex_destroy
#define core_yylex_destroy_ALREADY_DEFINED
#else
#define yylex_destroy core_yylex_destroy
#endif

#ifdef yyget_debug
#define core_yyget_debug_ALREADY_DEFINED
#else
#define yyget_debug core_yyget_debug
#endif

#ifdef yyset_debug
#define core_yyset_debug_ALREADY_DEFINED
#else
#define yyset_debug core_yyset_debug
#endif

#ifdef yyget_extra
#define core_yyget_extra_ALREADY_DEFINED
#else
#define yyget_extra core_yyget_extra
#endif

#ifdef yyset_extra
#define core_yyset_extra_ALREADY_DEFINED
#else
#define yyset_extra core_yyset_extra
#endif

#ifdef yyget_in
#define core_yyget_in_ALREADY_DEFINED
#else
#define yyget_in core_yyget_in
#endif

#ifdef yyset_in
#define core_yyset_in_ALREADY_DEFINED
#else
#define yyset_in core_yyset_in
#endif

#ifdef yyget_out
#define core_yyget_out_ALREADY_DEFINED
#else
#define yyget_out core_yyget_out
#endif

#ifdef yyset_out
#define core_yyset_out_ALREADY_DEFINED
#else
#define yyset_out core_yyset_out
#endif

#ifdef yyget_leng
#define core_yyget_leng_ALREADY_DEFINED
#else
#define yyget_leng core_yyget_leng
#endif

#ifdef yyget_text
#define core_yyget_text_ALREADY_DEFINED
#else
#define yyget_text core_yyget_text
#endif

#ifdef yyget_lineno
#define core_yyget_lineno_ALREADY_DEFINED
#else
#define yyget_lineno core_yyget_lineno
#endif

#ifdef yyset_lineno
#define core_yyset_lineno_ALREADY_DEFINED
#else
#define yyset_lineno core_yyset_lineno
#endif

#ifdef yyget_column
#define core_yyget_column_ALREADY_DEFINED
#else
#define yyget_column core_yyget_column
#endif

#ifdef yyset_column
#define core_yyset_column_ALREADY_DEFINED
#else
#define yyset_column core_yyset_column
#endif

#ifdef yywrap
#define core_yywrap_ALREADY_DEFINED
#else
#define yywrap core_yywrap
#endif

#ifdef yyget_lval
#define core_yyget_lval_ALREADY_DEFINED
#else
#define yyget_lval core_yyget_lval
#endif

#ifdef yyset_lval
#define core_yyset_lval_ALREADY_DEFINED
#else
#define yyset_lval core_yyset_lval
#endif

#ifdef yyget_lloc
#define core_yyget_lloc_ALREADY_DEFINED
#else
#define yyget_lloc core_yyget_lloc
#endif

#ifdef yyset_lloc
#define core_yyset_lloc_ALREADY_DEFINED
#else
#define yyset_lloc core_yyset_lloc
#endif

#ifdef yyalloc
#define core_yyalloc_ALREADY_DEFINED
#else
#define yyalloc core_yyalloc
#endif

#ifdef yyrealloc
#define core_yyrealloc_ALREADY_DEFINED
#else
#define yyrealloc core_yyrealloc
#endif

#ifdef yyfree
#define core_yyfree_ALREADY_DEFINED
#else
#define yyfree core_yyfree
#endif

/* First, we deal with  platform-specific or compiler-specific issues. */

/* begin standard C headers. */
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h>

/* end standard C headers. */

/* flex integer type definitions */

#ifndef FLEXINT_H
#define FLEXINT_H

/* C99 systems have <inttypes.h>. Non-C99 systems may or may not. */

#if defined (__STDC_VERSION__) && __STDC_VERSION__ >= 199901L

/* C99 says to define __STDC_LIMIT_MACROS before including stdint.h,
 * if you want the limit (max/min) macros for int types. 
 */
#ifndef __STDC_LIMIT_MACROS
#define __STDC_LIMIT_MACROS 1
#endif

#include <inttypes.h>
typedef int8_t flex_int8_t;
typedef uint8_t flex_uint8_t;
typedef int16_t flex_int16_t;
typedef uint16_t flex_uint16_t;
typedef int32_t flex_int32_t;
typedef uint32_t flex_uint32_t;
#else
typedef signed char flex_int8_t;
typedef short int flex_int16_t;
typedef int flex_int32_t;
typedef unsigned char flex_uint8_t; 
typedef unsigned short int flex_uint16_t;
typedef unsigned int flex_uint32_t;

/* Limits of integral types. */
#ifndef INT8_MIN
#define INT8_MIN               (-128)
#endif
#ifndef INT16_MIN
#define INT16_MIN              (-32767-1)
#endif
#ifndef INT32_MIN
#define INT32_MIN              (-2147483647-1)
#endif
#ifndef INT8_MAX
#define INT8_MAX               (127)
#endif
#ifndef INT16_MAX
#define INT16_MAX              (32767)
#endif
#ifndef INT32_MAX
#define INT32_MAX              (2147483647)
#endif
#ifndef UINT8_MAX
#define UINT8_MAX              (255U)
#endif
#ifndef UINT16_MAX
#define UINT16_MAX             (65535U)
#endif
#ifndef UINT32_MAX
#define UINT32_MAX             (4294967295U)
#endif

#ifndef SIZE_MAX
#define SIZE_MAX               (~(size_t)0)
#endif

#endif /* ! C99 */

#endif /* ! FLEXINT_H */

/* begin standard C++ headers. */

/* TODO: this is always defined, so inline it */
#define yyconst const

#if defined(__GNUC__) && __GNUC__ >= 3
#define yynoreturn __attribute__((__noreturn__))
#else
#define yynoreturn
#endif

/* Returned upon end-of-file. */
#define YY_NULL 0

/* Promotes a possibly negative, possibly signed char to an
 *   integer in range [0..255] for use as an array index.
 */
#define YY_SC_TO_UI(c) ((YY_CHAR) (c))

/* An opaque pointer. */
#ifndef YY_TYPEDEF_YY_SCANNER_T
#define YY_TYPEDEF_YY_SCANNER_T
typedef void* yyscan_t;
#endif

/* For convenience, these vars (plus the bison vars far below)
   are macros in the reentrant scanner. */
#define yyin yyg->yyin_r
#define yyout yyg->yyout_r
#define yyextra yyg->yyextra_r
#define yyleng yyg->yyleng_r
#define yytext yyg->yytext_r
#define yylineno (YY_CURRENT_BUFFER_LVALUE->yy_bs_lineno)
#define yycolumn (YY_CURRENT_BUFFER_LVALUE->yy_bs_column)
#define yy_flex_debug yyg->yy_flex_debug_r

/* Enter a start condition.  This macro really ought to take a parameter,
 * but we do it the disgusting crufty way forced on us by the ()-less
 * definition of BEGIN.
 */
#define BEGIN yyg->yy_start = 1 + 2 *
/* Translate the current start state into a value that can be later handed
 * to BEGIN to return to the state.  The YYSTATE alias is for lex
 * compatibility.
 */
#define YY_START ((yyg->yy_start - 1) / 2)
#define YYSTATE YY_START
/* Action number for EOF rule of a given start state. */
#define YY_STATE_EOF(state) (YY_END_OF_BUFFER + state + 1)
/* Special action meaning "start processing a new file". */
#define YY_NEW_FILE yyrestart( yyin , yyscanner )
#define YY_END_OF_BUFFER_CHAR 0

/* Size of default input buffer. */
#ifndef YY_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k.
 * Moreover, YY_BUF_SIZE is 2*YY_READ_BUF_SIZE in the general case.
 * Ditto for the __ia64__ case accordingly.
 */
#define YY_BUF_SIZE 32768
#else
#define YY_BUF_SIZE 16384
#endif /* __ia64__ */
#endif

/* The state buf must be large enough to hold one state per character in the main buffer.
 */
#define YY_STATE_BUF_SIZE   ((YY_BUF_SIZE + 2) * sizeof(yy_state_type))

#ifndef YY_TYPEDEF_YY_BUFFER_STATE
#define YY_TYPEDEF_YY_BUFFER_STATE
typedef struct yy_buffer_state *YY_BUFFER_STATE;
#endif

#ifndef YY_TYPEDEF_YY_SIZE_T
#define YY_TYPEDEF_YY_SIZE_T
typedef size_t yy_size_t;
#endif

#define EOB_ACT_CONTINUE_SCAN 0
#define EOB_ACT_END_OF_FILE 1
#define EOB_ACT_LAST_MATCH 2
    
    #define YY_LESS_LINENO(n)
    #define YY_LINENO_REWIND_TO(ptr)
    
/* Return all but the first "n" matched characters back to the input stream. */
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		*yy_cp = yyg->yy_hold_char; \
		YY_RESTORE_YY_MORE_OFFSET \
		yyg->yy_c_buf_p = yy_cp = yy_bp + yyless_macro_arg - YY_MORE_ADJ; \
		YY_DO_BEFORE_ACTION; /* set up yytext again */ \
		} \
	while ( 0 )
#define unput(c) yyunput( c, yyg->yytext_ptr , yyscanner )

#ifndef YY_STRUCT_YY_BUFFER_STATE
#define YY_STRUCT_YY_BUFFER_STATE
struct yy_buffer_state
	{
	FILE *yy_input_file;

	char *yy_ch_buf;		/* input buffer */
	char *yy_buf_pos;		/* current position in input buffer */

	/* Size of input buffer in bytes, not including room for EOB
	 * characters.
	 */
	int yy_buf_size;

	/* Number of characters read into yy_ch_buf, not including EOB
	 * characters.
	 */
	int yy_n_chars;

	/* Whether we "own" the buffer - i.e., we know we created it,
	 * and can realloc() it to grow it, and should free() it to
	 * delete it.
	 */
	int yy_is_our_buffer;

	/* Whether this is an "interactive" input source; if so, and
	 * if we're using stdio for input, then we want to use getc()
	 * instead of fread(), to make sure we stop fetching input after
	 * each newline.
	 */
	int yy_is_interactive;

	/* Whether we're considered to be at the beginning of a line.
	 * If so, '^' rules will be active on the next match, otherwise
	 * not.
	 */
	int yy_at_bol;

    int yy_bs_lineno; /**< The line count. */
    int yy_bs_column; /**< The column count. */

	/* Whether to try to fill the input buffer when we reach the
	 * end of it.
	 */
	int yy_fill_buffer;

	int yy_buffer_status;

#define YY_BUFFER_NEW 0
#define YY_BUFFER_NORMAL 1
	/* When an EOF's been seen but there's still some text to process
	 * then we mark the buffer as YY_EOF_PENDING, to indicate that we
	 * shouldn't try reading from the input source any more.  We might
	 * still have a bunch of tokens to match, though, because of
	 * possible backing-up.
	 *
	 * When we actually see the EOF, we change the status to "new"
	 * (via yyrestart()), so that the user can continue scanning by
	 * just pointing yyin at a new input file.
	 */
#define YY_BUFFER_EOF_PENDING 2

	};
#endif /* !YY_STRUCT_YY_BUFFER_STATE */

/* We provide macros for accessing buffer states in case in the
 * future we want to put the buffer states in a more general
 * "scanner state".
 *
 * Returns the top of the stack, or NULL.
 */
#define YY_CURRENT_BUFFER ( yyg->yy_buffer_stack \
                          ? yyg->yy_buffer_stack[yyg->yy_buffer_stack_top] \
                          : NULL)
/* Same as previous macro, but useful when we know that the buffer stack is not
 * NULL or when we need an lvalue. For internal use only.
 */
#define YY_CURRENT_BUFFER_LVALUE yyg->yy_buffer_stack[yyg->yy_buffer_stack_top]

void yyrestart ( FILE *input_file , yyscan_t yyscanner );
void yy_switch_to_buffer ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
YY_BUFFER_STATE yy_create_buffer ( FILE *file, int size , yyscan_t yyscanner );
void yy_delete_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yy_flush_buffer ( YY_BUFFER_STATE b , yyscan_t yyscanner );
void yypush_buffer_state ( YY_BUFFER_STATE new_buffer , yyscan_t yyscanner );
void yypop_buffer_state ( yyscan_t yyscanner );

static void yyensure_buffer_stack ( yyscan_t yyscanner );
static void yy_load_buffer_state ( yyscan_t yyscanner );
static void yy_init_buffer ( YY_BUFFER_STATE b, FILE *file , yyscan_t yyscanner );
#define YY_FLUSH_BUFFER yy_flush_buffer( YY_CURRENT_BUFFER , yyscanner)

YY_BUFFER_STATE yy_scan_buffer ( char *base, yy_size_t size , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_string ( const char *yy_str , yyscan_t yyscanner );
YY_BUFFER_STATE yy_scan_bytes ( const char *bytes, int len , yyscan_t yyscanner );

void *yyalloc ( yy_size_t , yyscan_t yyscanner );
void *yyrealloc ( void *, yy_size_t , yyscan_t yyscanner );
void yyfree ( void * , yyscan_t yyscanner );

#define yy_new_buffer yy_create_buffer
#define yy_set_interactive(is_interactive) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){ \
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_is_interactive = is_interactive; \
	}
#define yy_set_bol(at_bol) \
	{ \
	if ( ! YY_CURRENT_BUFFER ){\
        yyensure_buffer_stack (yyscanner); \
		YY_CURRENT_BUFFER_LVALUE =    \
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner); \
	} \
	YY_CURRENT_BUFFER_LVALUE->yy_at_bol = at_bol; \
	}
#define YY_AT_BOL() (YY_CURRENT_BUFFER_LVALUE->yy_at_bol)

/* Begin user sect3 */

#define core_yywrap(yyscanner) (/*CONSTCOND*/1)
#define YY_SKIP_YYWRAP
typedef flex_uint8_t YY_CHAR;

typedef const struct yy_trans_info *yy_state_type;

#define yytext_ptr yytext_r

static yy_state_type yy_get_previous_state ( yyscan_t yyscanner );
static yy_state_type yy_try_NUL_trans ( yy_state_type current_state  , yyscan_t yyscanner);
static int yy_get_next_buffer ( yyscan_t yyscanner );
static void yynoreturn yy_fatal_error ( const char* msg , yyscan_t yyscanner );

/* Done after the current pattern has been matched and before the
 * corresponding action - sets up yytext.
 */
#define YY_DO_BEFORE_ACTION \
	yyg->yytext_ptr = yy_bp; \
	yyleng = (int) (yy_cp - yy_bp); \
	yyg->yy_hold_char = *yy_cp; \
	*yy_cp = '\0'; \
	yyg->yy_c_buf_p = yy_cp;
#define YY_NUM_RULES 76
#define YY_END_OF_BUFFER 77
struct yy_trans_info
	{
	flex_int16_t yy_verify;
	flex_int16_t yy_nxt;
	};
static const struct yy_trans_info yy_transition[24396] =
    {
 {   0,   0 }, {   0,24140 }, {   0,   0 }, {   0,24138 }, {   1,6192 },
 {   2,6192 }, {   3,6192 }, {   4,6192 }, {   5,6192 }, {   6,6192 },
 {   7,6192 }, {   8,6192 }, {   9,6194 }, {  10,6199 }, {  11,6192 },
 {  12,6194 }, {  13,6194 }, {  14,6192 }, {  15,6192 }, {  16,6192 },
 {  17,6192 }, {  18,6192 }, {  19,6192 }, {  20,6192 }, {  21,6192 },
 {  22,6192 }, {  23,6192 }, {  24,6192 }, {  25,6192 }, {  26,6192 },
 {  27,6192 }, {  28,6192 }, {  29,6192 }, {  30,6192 }, {  31,6192 },
 {  32,6194 }, {  33,6201 }, {  34,6196 }, {  35,6241 }, {  36,6307 },
 {  37,6564 }, {  38,6241 }, {  39,6214 }, {  40,6216 }, {  41,6216 },
 {  42,6564 }, {  43,6564 }, {  44,6216 }, {  45,6575 }, {  46,6594 },

 {  47,6665 }, {  48,6697 }, {  49,6954 }, {  50,6954 }, {  51,6954 },
 {  52,6954 }, {  53,6954 }, {  54,6954 }, {  55,6954 }, {  56,6954 },
 {  57,6954 }, {  58,6219 }, {  59,6216 }, {  60,7211 }, {  61,7222 },
 {  62,7289 }, {  63,6241 }, {  64,6241 }, {  65,7321 }, {  66,7578 },
 {  67,7321 }, {  68,7321 }, {  69,7835 }, {  70,7321 }, {  71,7321 },
 {  72,7321 }, {  73,7321 }, {  74,7321 }, {  75,7321 }, {  76,7321 },
 {  77,7321 }, {  78,8092 }, {  79,7321 }, {  80,7321 }, {  81,7321 },
 {  82,7321 }, {  83,7321 }, {  84,7321 }, {  85,8349 }, {  86,7321 },
 {  87,7321 }, {  88,8606 }, {  89,7321 }, {  90,7321 }, {  91,6216 },
 {  92,6192 }, {  93,6216 }, {  94,6564 }, {  95,7321 }, {  96,6241 },

 {  97,7321 }, {  98,7578 }, {  99,7321 }, { 100,7321 }, { 101,7835 },
 { 102,7321 }, { 103,7321 }, { 104,7321 }, { 105,7321 }, { 106,7321 },
 { 107,7321 }, { 108,7321 }, { 109,7321 }, { 110,8092 }, { 111,7321 },
 { 112,7321 }, { 113,7321 }, { 114,7321 }, { 115,7321 }, { 116,7321 },
 { 117,8349 }, { 118,7321 }, { 119,7321 }, { 120,8606 }, { 121,7321 },
 { 122,7321 }, { 123,6192 }, { 124,6241 }, { 125,6192 }, { 126,6241 },
 { 127,6192 }, { 128,7321 }, { 129,7321 }, { 130,7321 }, { 131,7321 },
 { 132,7321 }, { 133,7321 }, { 134,7321 }, { 135,7321 }, { 136,7321 },
 { 137,7321 }, { 138,7321 }, { 139,7321 }, { 140,7321 }, { 141,7321 },
 { 142,7321 }, { 143,7321 }, { 144,7321 }, { 145,7321 }, { 146,7321 },

 { 147,7321 }, { 148,7321 }, { 149,7321 }, { 150,7321 }, { 151,7321 },
 { 152,7321 }, { 153,7321 }, { 154,7321 }, { 155,7321 }, { 156,7321 },
 { 157,7321 }, { 158,7321 }, { 159,7321 }, { 160,7321 }, { 161,7321 },
 { 162,7321 }, { 163,7321 }, { 164,7321 }, { 165,7321 }, { 166,7321 },
 { 167,7321 }, { 168,7321 }, { 169,7321 }, { 170,7321 }, { 171,7321 },
 { 172,7321 }, { 173,7321 }, { 174,7321 }, { 175,7321 }, { 176,7321 },
 { 177,7321 }, { 178,7321 }, { 179,7321 }, { 180,7321 }, { 181,7321 },
 { 182,7321 }, { 183,7321 }, { 184,7321 }, { 185,7321 }, { 186,7321 },
 { 187,7321 }, { 188,7321 }, { 189,7321 }, { 190,7321 }, { 191,7321 },
 { 192,7321 }, { 193,7321 }, { 194,7321 }, { 195,7321 }, { 196,7321 },

 { 197,7321 }, { 198,7321 }, { 199,7321 }, { 200,7321 }, { 201,7321 },
 { 202,7321 }, { 203,7321 }, { 204,7321 }, { 205,7321 }, { 206,7321 },
 { 207,7321 }, { 208,7321 }, { 209,7321 }, { 210,7321 }, { 211,7321 },
 { 212,7321 }, { 213,7321 }, { 214,7321 }, { 215,7321 }, { 216,7321 },
 { 217,7321 }, { 218,7321 }, { 219,7321 }, { 220,7321 }, { 221,7321 },
 { 222,7321 }, { 223,7321 }, { 224,7321 }, { 225,7321 }, { 226,7321 },
 { 227,7321 }, { 228,7321 }, { 229,7321 }, { 230,7321 }, { 231,7321 },
 { 232,7321 }, { 233,7321 }, { 234,7321 }, { 235,7321 }, { 236,7321 },
 { 237,7321 }, { 238,7321 }, { 239,7321 }, { 240,7321 }, { 241,7321 },
 { 242,7321 }, { 243,7321 }, { 244,7321 }, { 245,7321 }, { 246,7321 },

 { 247,7321 }, { 248,7321 }, { 249,7321 }, { 250,7321 }, { 251,7321 },
 { 252,7321 }, { 253,7321 }, { 254,7321 }, { 255,7321 }, { 256,6192 },
 {   0,   0 }, {   0,23880 }, {   1,5934 }, {   2,5934 }, {   3,5934 },
 {   4,5934 }, {   5,5934 }, {   6,5934 }, {   7,5934 }, {   8,5934 },
 {   9,5936 }, {  10,5941 }, {  11,5934 }, {  12,5936 }, {  13,5936 },
 {  14,5934 }, {  15,5934 }, {  16,5934 }, {  17,5934 }, {  18,5934 },
 {  19,5934 }, {  20,5934 }, {  21,5934 }, {  22,5934 }, {  23,5934 },
 {  24,5934 }, {  25,5934 }, {  26,5934 }, {  27,5934 }, {  28,5934 },
 {  29,5934 }, {  30,5934 }, {  31,5934 }, {  32,5936 }, {  33,5943 },
 {  34,5938 }, {  35,5983 }, {  36,6049 }, {  37,6306 }, {  38,5983 },

 {  39,5956 }, {  40,5958 }, {  41,5958 }, {  42,6306 }, {  43,6306 },
 {  44,5958 }, {  45,6317 }, {  46,6336 }, {  47,6407 }, {  48,6439 },
 {  49,6696 }, {  50,6696 }, {  51,6696 }, {  52,6696 }, {  53,6696 },
 {  54,6696 }, {  55,6696 }, {  56,6696 }, {  57,6696 }, {  58,5961 },
 {  59,5958 }, {  60,6953 }, {  61,6964 }, {  62,7031 }, {  63,5983 },
 {  64,5983 }, {  65,7063 }, {  66,7320 }, {  67,7063 }, {  68,7063 },
 {  69,7577 }, {  70,7063 }, {  71,7063 }, {  72,7063 }, {  73,7063 },
 {  74,7063 }, {  75,7063 }, {  76,7063 }, {  77,7063 }, {  78,7834 },
 {  79,7063 }, {  80,7063 }, {  81,7063 }, {  82,7063 }, {  83,7063 },
 {  84,7063 }, {  85,8091 }, {  86,7063 }, {  87,7063 }, {  88,8348 },

 {  89,7063 }, {  90,7063 }, {  91,5958 }, {  92,5934 }, {  93,5958 },
 {  94,6306 }, {  95,7063 }, {  96,5983 }, {  97,7063 }, {  98,7320 },
 {  99,7063 }, { 100,7063 }, { 101,7577 }, { 102,7063 }, { 103,7063 },
 { 104,7063 }, { 105,7063 }, { 106,7063 }, { 107,7063 }, { 108,7063 },
 { 109,7063 }, { 110,7834 }, { 111,7063 }, { 112,7063 }, { 113,7063 },
 { 114,7063 }, { 115,7063 }, { 116,7063 }, { 117,8091 }, { 118,7063 },
 { 119,7063 }, { 120,8348 }, { 121,7063 }, { 122,7063 }, { 123,5934 },
 { 124,5983 }, { 125,5934 }, { 126,5983 }, { 127,5934 }, { 128,7063 },
 { 129,7063 }, { 130,7063 }, { 131,7063 }, { 132,7063 }, { 133,7063 },
 { 134,7063 }, { 135,7063 }, { 136,7063 }, { 137,7063 }, { 138,7063 },

 { 139,7063 }, { 140,7063 }, { 141,7063 }, { 142,7063 }, { 143,7063 },
 { 144,7063 }, { 145,7063 }, { 146,7063 }, { 147,7063 }, { 148,7063 },
 { 149,7063 }, { 150,7063 }, { 151,7063 }, { 152,7063 }, { 153,7063 },
 { 154,7063 }, { 155,7063 }, { 156,7063 }, { 157,7063 }, { 158,7063 },
 { 159,7063 }, { 160,7063 }, { 161,7063 }, { 162,7063 }, { 163,7063 },
 { 164,7063 }, { 165,7063 }, { 166,7063 }, { 167,7063 }, { 168,7063 },
 { 169,7063 }, { 170,7063 }, { 171,7063 }, { 172,7063 }, { 173,7063 },
 { 174,7063 }, { 175,7063 }, { 176,7063 }, { 177,7063 }, { 178,7063 },
 { 179,7063 }, { 180,7063 }, { 181,7063 }, { 182,7063 }, { 183,7063 },
 { 184,7063 }, { 185,7063 }, { 186,7063 }, { 187,7063 }, { 188,7063 },

 { 189,7063 }, { 190,7063 }, { 191,7063 }, { 192,7063 }, { 193,7063 },
 { 194,7063 }, { 195,7063 }, { 196,7063 }, { 197,7063 }, { 198,7063 },
 { 199,7063 }, { 200,7063 }, { 201,7063 }, { 202,7063 }, { 203,7063 },
 { 204,7063 }, { 205,7063 }, { 206,7063 }, { 207,7063 }, { 208,7063 },
 { 209,7063 }, { 210,7063 }, { 211,7063 }, { 212,7063 }, { 213,7063 },
 { 214,7063 }, { 215,7063 }, { 216,7063 }, { 217,7063 }, { 218,7063 },
 { 219,7063 }, { 220,7063 }, { 221,7063 }, { 222,7063 }, { 223,7063 },
 { 224,7063 }, { 225,7063 }, { 226,7063 }, { 227,7063 }, { 228,7063 },
 { 229,7063 }, { 230,7063 }, { 231,7063 }, { 232,7063 }, { 233,7063 },
 { 234,7063 }, { 235,7063 }, { 236,7063 }, { 237,7063 }, { 238,7063 },

 { 239,7063 }, { 240,7063 }, { 241,7063 }, { 242,7063 }, { 243,7063 },
 { 244,7063 }, { 245,7063 }, { 246,7063 }, { 247,7063 }, { 248,7063 },
 { 249,7063 }, { 250,7063 }, { 251,7063 }, { 252,7063 }, { 253,7063 },
 { 254,7063 }, { 255,7063 }, { 256,5934 }, {   0,  10 }, {   0,23622 },
 {   1,8347 }, {   2,8347 }, {   3,8347 }, {   4,8347 }, {   5,8347 },
 {   6,8347 }, {   7,8347 }, {   8,8347 }, {   9,8347 }, {  10,8347 },
 {  11,8347 }, {  12,8347 }, {  13,8347 }, {  14,8347 }, {  15,8347 },
 {  16,8347 }, {  17,8347 }, {  18,8347 }, {  19,8347 }, {  20,8347 },
 {  21,8347 }, {  22,8347 }, {  23,8347 }, {  24,8347 }, {  25,8347 },
 {  26,8347 }, {  27,8347 }, {  28,8347 }, {  29,8347 }, {  30,8347 },

 {  31,8347 }, {  32,8347 }, {  33,8347 }, {  34,8347 }, {  35,8347 },
 {  36,8347 }, {  37,8347 }, {  38,8347 }, {  39,5705 }, {  40,8347 },
 {  41,8347 }, {  42,8347 }, {  43,8347 }, {  44,8347 }, {  45,8347 },
 {  46,8347 }, {  47,8347 }, {  48,8347 }, {  49,8347 }, {  50,8347 },
 {  51,8347 }, {  52,8347 }, {  53,8347 }, {  54,8347 }, {  55,8347 },
 {  56,8347 }, {  57,8347 }, {  58,8347 }, {  59,8347 }, {  60,8347 },
 {  61,8347 }, {  62,8347 }, {  63,8347 }, {  64,8347 }, {  65,8347 },
 {  66,8347 }, {  67,8347 }, {  68,8347 }, {  69,8347 }, {  70,8347 },
 {  71,8347 }, {  72,8347 }, {  73,8347 }, {  74,8347 }, {  75,8347 },
 {  76,8347 }, {  77,8347 }, {  78,8347 }, {  79,8347 }, {  80,8347 },

 {  81,8347 }, {  82,8347 }, {  83,8347 }, {  84,8347 }, {  85,8347 },
 {  86,8347 }, {  87,8347 }, {  88,8347 }, {  89,8347 }, {  90,8347 },
 {  91,8347 }, {  92,8347 }, {  93,8347 }, {  94,8347 }, {  95,8347 },
 {  96,8347 }, {  97,8347 }, {  98,8347 }, {  99,8347 }, { 100,8347 },
 { 101,8347 }, { 102,8347 }, { 103,8347 }, { 104,8347 }, { 105,8347 },
 { 106,8347 }, { 107,8347 }, { 108,8347 }, { 109,8347 }, { 110,8347 },
 { 111,8347 }, { 112,8347 }, { 113,8347 }, { 114,8347 }, { 115,8347 },
 { 116,8347 }, { 117,8347 }, { 118,8347 }, { 119,8347 }, { 120,8347 },
 { 121,8347 }, { 122,8347 }, { 123,8347 }, { 124,8347 }, { 125,8347 },
 { 126,8347 }, { 127,8347 }, { 128,8347 }, { 129,8347 }, { 130,8347 },

 { 131,8347 }, { 132,8347 }, { 133,8347 }, { 134,8347 }, { 135,8347 },
 { 136,8347 }, { 137,8347 }, { 138,8347 }, { 139,8347 }, { 140,8347 },
 { 141,8347 }, { 142,8347 }, { 143,8347 }, { 144,8347 }, { 145,8347 },
 { 146,8347 }, { 147,8347 }, { 148,8347 }, { 149,8347 }, { 150,8347 },
 { 151,8347 }, { 152,8347 }, { 153,8347 }, { 154,8347 }, { 155,8347 },
 { 156,8347 }, { 157,8347 }, { 158,8347 }, { 159,8347 }, { 160,8347 },
 { 161,8347 }, { 162,8347 }, { 163,8347 }, { 164,8347 }, { 165,8347 },
 { 166,8347 }, { 167,8347 }, { 168,8347 }, { 169,8347 }, { 170,8347 },
 { 171,8347 }, { 172,8347 }, { 173,8347 }, { 174,8347 }, { 175,8347 },
 { 176,8347 }, { 177,8347 }, { 178,8347 }, { 179,8347 }, { 180,8347 },

 { 181,8347 }, { 182,8347 }, { 183,8347 }, { 184,8347 }, { 185,8347 },
 { 186,8347 }, { 187,8347 }, { 188,8347 }, { 189,8347 }, { 190,8347 },
 { 191,8347 }, { 192,8347 }, { 193,8347 }, { 194,8347 }, { 195,8347 },
 { 196,8347 }, { 197,8347 }, { 198,8347 }, { 199,8347 }, { 200,8347 },
 { 201,8347 }, { 202,8347 }, { 203,8347 }, { 204,8347 }, { 205,8347 },
 { 206,8347 }, { 207,8347 }, { 208,8347 }, { 209,8347 }, { 210,8347 },
 { 211,8347 }, { 212,8347 }, { 213,8347 }, { 214,8347 }, { 215,8347 },
 { 216,8347 }, { 217,8347 }, { 218,8347 }, { 219,8347 }, { 220,8347 },
 { 221,8347 }, { 222,8347 }, { 223,8347 }, { 224,8347 }, { 225,8347 },
 { 226,8347 }, { 227,8347 }, { 228,8347 }, { 229,8347 }, { 230,8347 },

 { 231,8347 }, { 232,8347 }, { 233,8347 }, { 234,8347 }, { 235,8347 },
 { 236,8347 }, { 237,8347 }, { 238,8347 }, { 239,8347 }, { 240,8347 },
 { 241,8347 }, { 242,8347 }, { 243,8347 }, { 244,8347 }, { 245,8347 },
 { 246,8347 }, { 247,8347 }, { 248,8347 }, { 249,8347 }, { 250,8347 },
 { 251,8347 }, { 252,8347 }, { 253,8347 }, { 254,8347 }, { 255,8347 },
 { 256,8347 }, {   0,  10 }, {   0,23364 }, {   1,8089 }, {   2,8089 },
 {   3,8089 }, {   4,8089 }, {   5,8089 }, {   6,8089 }, {   7,8089 },
 {   8,8089 }, {   9,8089 }, {  10,8089 }, {  11,8089 }, {  12,8089 },
 {  13,8089 }, {  14,8089 }, {  15,8089 }, {  16,8089 }, {  17,8089 },
 {  18,8089 }, {  19,8089 }, {  20,8089 }, {  21,8089 }, {  22,8089 },

 {  23,8089 }, {  24,8089 }, {  25,8089 }, {  26,8089 }, {  27,8089 },
 {  28,8089 }, {  29,8089 }, {  30,8089 }, {  31,8089 }, {  32,8089 },
 {  33,8089 }, {  34,8089 }, {  35,8089 }, {  36,8089 }, {  37,8089 },
 {  38,8089 }, {  39,5447 }, {  40,8089 }, {  41,8089 }, {  42,8089 },
 {  43,8089 }, {  44,8089 }, {  45,8089 }, {  46,8089 }, {  47,8089 },
 {  48,8089 }, {  49,8089 }, {  50,8089 }, {  51,8089 }, {  52,8089 },
 {  53,8089 }, {  54,8089 }, {  55,8089 }, {  56,8089 }, {  57,8089 },
 {  58,8089 }, {  59,8089 }, {  60,8089 }, {  61,8089 }, {  62,8089 },
 {  63,8089 }, {  64,8089 }, {  65,8089 }, {  66,8089 }, {  67,8089 },
 {  68,8089 }, {  69,8089 }, {  70,8089 }, {  71,8089 }, {  72,8089 },

 {  73,8089 }, {  74,8089 }, {  75,8089 }, {  76,8089 }, {  77,8089 },
 {  78,8089 }, {  79,8089 }, {  80,8089 }, {  81,8089 }, {  82,8089 },
 {  83,8089 }, {  84,8089 }, {  85,8089 }, {  86,8089 }, {  87,8089 },
 {  88,8089 }, {  89,8089 }, {  90,8089 }, {  91,8089 }, {  92,8089 },
 {  93,8089 }, {  94,8089 }, {  95,8089 }, {  96,8089 }, {  97,8089 },
 {  98,8089 }, {  99,8089 }, { 100,8089 }, { 101,8089 }, { 102,8089 },
 { 103,8089 }, { 104,8089 }, { 105,8089 }, { 106,8089 }, { 107,8089 },
 { 108,8089 }, { 109,8089 }, { 110,8089 }, { 111,8089 }, { 112,8089 },
 { 113,8089 }, { 114,8089 }, { 115,8089 }, { 116,8089 }, { 117,8089 },
 { 118,8089 }, { 119,8089 }, { 120,8089 }, { 121,8089 }, { 122,8089 },

 { 123,8089 }, { 124,8089 }, { 125,8089 }, { 126,8089 }, { 127,8089 },
 { 128,8089 }, { 129,8089 }, { 130,8089 }, { 131,8089 }, { 132,8089 },
 { 133,8089 }, { 134,8089 }, { 135,8089 }, { 136,8089 }, { 137,8089 },
 { 138,8089 }, { 139,8089 }, { 140,8089 }, { 141,8089 }, { 142,8089 },
 { 143,8089 }, { 144,8089 }, { 145,8089 }, { 146,8089 }, { 147,8089 },
 { 148,8089 }, { 149,8089 }, { 150,8089 }, { 151,8089 }, { 152,8089 },
 { 153,8089 }, { 154,8089 }, { 155,8089 }, { 156,8089 }, { 157,8089 },
 { 158,8089 }, { 159,8089 }, { 160,8089 }, { 161,8089 }, { 162,8089 },
 { 163,8089 }, { 164,8089 }, { 165,8089 }, { 166,8089 }, { 167,8089 },
 { 168,8089 }, { 169,8089 }, { 170,8089 }, { 171,8089 }, { 172,8089 },

 { 173,8089 }, { 174,8089 }, { 175,8089 }, { 176,8089 }, { 177,8089 },
 { 178,8089 }, { 179,8089 }, { 180,8089 }, { 181,8089 }, { 182,8089 },
 { 183,8089 }, { 184,8089 }, { 185,8089 }, { 186,8089 }, { 187,8089 },
 { 188,8089 }, { 189,8089 }, { 190,8089 }, { 191,8089 }, { 192,8089 },
 { 193,8089 }, { 194,8089 }, { 195,8089 }, { 196,8089 }, { 197,8089 },
 { 198,8089 }, { 199,8089 }, { 200,8089 }, { 201,8089 }, { 202,8089 },
 { 203,8089 }, { 204,8089 }, { 205,8089 }, { 206,8089 }, { 207,8089 },
 { 208,8089 }, { 209,8089 }, { 210,8089 }, { 211,8089 }, { 212,8089 },
 { 213,8089 }, { 214,8089 }, { 215,8089 }, { 216,8089 }, { 217,8089 },
 { 218,8089 }, { 219,8089 }, { 220,8089 }, { 221,8089 }, { 222,8089 },

 { 223,8089 }, { 224,8089 }, { 225,8089 }, { 226,8089 }, { 227,8089 },
 { 228,8089 }, { 229,8089 }, { 230,8089 }, { 231,8089 }, { 232,8089 },
 { 233,8089 }, { 234,8089 }, { 235,8089 }, { 236,8089 }, { 237,8089 },
 { 238,8089 }, { 239,8089 }, { 240,8089 }, { 241,8089 }, { 242,8089 },
 { 243,8089 }, { 244,8089 }, { 245,8089 }, { 246,8089 }, { 247,8089 },
 { 248,8089 }, { 249,8089 }, { 250,8089 }, { 251,8089 }, { 252,8089 },
 { 253,8089 }, { 254,8089 }, { 255,8089 }, { 256,8089 }, {   0,   0 },
 {   0,23106 }, {   1,8089 }, {   2,8089 }, {   3,8089 }, {   4,8089 },
 {   5,8089 }, {   6,8089 }, {   7,8089 }, {   8,8089 }, {   9,8089 },
 {  10,8089 }, {  11,8089 }, {  12,8089 }, {  13,8089 }, {  14,8089 },

 {  15,8089 }, {  16,8089 }, {  17,8089 }, {  18,8089 }, {  19,8089 },
 {  20,8089 }, {  21,8089 }, {  22,8089 }, {  23,8089 }, {  24,8089 },
 {  25,8089 }, {  26,8089 }, {  27,8089 }, {  28,8089 }, {  29,8089 },
 {  30,8089 }, {  31,8089 }, {  32,8089 }, {  33,8347 }, {  34,8089 },
 {  35,8347 }, {  36,8089 }, {  37,8347 }, {  38,8347 }, {  39,8089 },
 {  40,8089 }, {  41,8089 }, {  42,5192 }, {  43,8347 }, {  44,8089 },
 {  45,8347 }, {  46,8089 }, {  47,5196 }, {  48,8089 }, {  49,8089 },
 {  50,8089 }, {  51,8089 }, {  52,8089 }, {  53,8089 }, {  54,8089 },
 {  55,8089 }, {  56,8089 }, {  57,8089 }, {  58,8089 }, {  59,8089 },
 {  60,8347 }, {  61,8347 }, {  62,8347 }, {  63,8347 }, {  64,8347 },

 {  65,8089 }, {  66,8089 }, {  67,8089 }, {  68,8089 }, {  69,8089 },
 {  70,8089 }, {  71,8089 }, {  72,8089 }, {  73,8089 }, {  74,8089 },
 {  75,8089 }, {  76,8089 }, {  77,8089 }, {  78,8089 }, {  79,8089 },
 {  80,8089 }, {  81,8089 }, {  82,8089 }, {  83,8089 }, {  84,8089 },
 {  85,8089 }, {  86,8089 }, {  87,8089 }, {  88,8089 }, {  89,8089 },
 {  90,8089 }, {  91,8089 }, {  92,8089 }, {  93,8089 }, {  94,8347 },
 {  95,8089 }, {  96,8347 }, {  97,8089 }, {  98,8089 }, {  99,8089 },
 { 100,8089 }, { 101,8089 }, { 102,8089 }, { 103,8089 }, { 104,8089 },
 { 105,8089 }, { 106,8089 }, { 107,8089 }, { 108,8089 }, { 109,8089 },
 { 110,8089 }, { 111,8089 }, { 112,8089 }, { 113,8089 }, { 114,8089 },

 { 115,8089 }, { 116,8089 }, { 117,8089 }, { 118,8089 }, { 119,8089 },
 { 120,8089 }, { 121,8089 }, { 122,8089 }, { 123,8089 }, { 124,8347 },
 { 125,8089 }, { 126,8347 }, { 127,8089 }, { 128,8089 }, { 129,8089 },
 { 130,8089 }, { 131,8089 }, { 132,8089 }, { 133,8089 }, { 134,8089 },
 { 135,8089 }, { 136,8089 }, { 137,8089 }, { 138,8089 }, { 139,8089 },
 { 140,8089 }, { 141,8089 }, { 142,8089 }, { 143,8089 }, { 144,8089 },
 { 145,8089 }, { 146,8089 }, { 147,8089 }, { 148,8089 }, { 149,8089 },
 { 150,8089 }, { 151,8089 }, { 152,8089 }, { 153,8089 }, { 154,8089 },
 { 155,8089 }, { 156,8089 }, { 157,8089 }, { 158,8089 }, { 159,8089 },
 { 160,8089 }, { 161,8089 }, { 162,8089 }, { 163,8089 }, { 164,8089 },

 { 165,8089 }, { 166,8089 }, { 167,8089 }, { 168,8089 }, { 169,8089 },
 { 170,8089 }, { 171,8089 }, { 172,8089 }, { 173,8089 }, { 174,8089 },
 { 175,8089 }, { 176,8089 }, { 177,8089 }, { 178,8089 }, { 179,8089 },
 { 180,8089 }, { 181,8089 }, { 182,8089 }, { 183,8089 }, { 184,8089 },
 { 185,8089 }, { 186,8089 }, { 187,8089 }, { 188,8089 }, { 189,8089 },
 { 190,8089 }, { 191,8089 }, { 192,8089 }, { 193,8089 }, { 194,8089 },
 { 195,8089 }, { 196,8089 }, { 197,8089 }, { 198,8089 }, { 199,8089 },
 { 200,8089 }, { 201,8089 }, { 202,8089 }, { 203,8089 }, { 204,8089 },
 { 205,8089 }, { 206,8089 }, { 207,8089 }, { 208,8089 }, { 209,8089 },
 { 210,8089 }, { 211,8089 }, { 212,8089 }, { 213,8089 }, { 214,8089 },

 { 215,8089 }, { 216,8089 }, { 217,8089 }, { 218,8089 }, { 219,8089 },
 { 220,8089 }, { 221,8089 }, { 222,8089 }, { 223,8089 }, { 224,8089 },
 { 225,8089 }, { 226,8089 }, { 227,8089 }, { 228,8089 }, { 229,8089 },
 { 230,8089 }, { 231,8089 }, { 232,8089 }, { 233,8089 }, { 234,8089 },
 { 235,8089 }, { 236,8089 }, { 237,8089 }, { 238,8089 }, { 239,8089 },
 { 240,8089 }, { 241,8089 }, { 242,8089 }, { 243,8089 }, { 244,8089 },
 { 245,8089 }, { 246,8089 }, { 247,8089 }, { 248,8089 }, { 249,8089 },
 { 250,8089 }, { 251,8089 }, { 252,8089 }, { 253,8089 }, { 254,8089 },
 { 255,8089 }, { 256,8089 }, {   0,   0 }, {   0,22848 }, {   1,7831 },
 {   2,7831 }, {   3,7831 }, {   4,7831 }, {   5,7831 }, {   6,7831 },

 {   7,7831 }, {   8,7831 }, {   9,7831 }, {  10,7831 }, {  11,7831 },
 {  12,7831 }, {  13,7831 }, {  14,7831 }, {  15,7831 }, {  16,7831 },
 {  17,7831 }, {  18,7831 }, {  19,7831 }, {  20,7831 }, {  21,7831 },
 {  22,7831 }, {  23,7831 }, {  24,7831 }, {  25,7831 }, {  26,7831 },
 {  27,7831 }, {  28,7831 }, {  29,7831 }, {  30,7831 }, {  31,7831 },
 {  32,7831 }, {  33,8089 }, {  34,7831 }, {  35,8089 }, {  36,7831 },
 {  37,8089 }, {  38,8089 }, {  39,7831 }, {  40,7831 }, {  41,7831 },
 {  42,4934 }, {  43,8089 }, {  44,7831 }, {  45,8089 }, {  46,7831 },
 {  47,4938 }, {  48,7831 }, {  49,7831 }, {  50,7831 }, {  51,7831 },
 {  52,7831 }, {  53,7831 }, {  54,7831 }, {  55,7831 }, {  56,7831 },

 {  57,7831 }, {  58,7831 }, {  59,7831 }, {  60,8089 }, {  61,8089 },
 {  62,8089 }, {  63,8089 }, {  64,8089 }, {  65,7831 }, {  66,7831 },
 {  67,7831 }, {  68,7831 }, {  69,7831 }, {  70,7831 }, {  71,7831 },
 {  72,7831 }, {  73,7831 }, {  74,7831 }, {  75,7831 }, {  76,7831 },
 {  77,7831 }, {  78,7831 }, {  79,7831 }, {  80,7831 }, {  81,7831 },
 {  82,7831 }, {  83,7831 }, {  84,7831 }, {  85,7831 }, {  86,7831 },
 {  87,7831 }, {  88,7831 }, {  89,7831 }, {  90,7831 }, {  91,7831 },
 {  92,7831 }, {  93,7831 }, {  94,8089 }, {  95,7831 }, {  96,8089 },
 {  97,7831 }, {  98,7831 }, {  99,7831 }, { 100,7831 }, { 101,7831 },
 { 102,7831 }, { 103,7831 }, { 104,7831 }, { 105,7831 }, { 106,7831 },

 { 107,7831 }, { 108,7831 }, { 109,7831 }, { 110,7831 }, { 111,7831 },
 { 112,7831 }, { 113,7831 }, { 114,7831 }, { 115,7831 }, { 116,7831 },
 { 117,7831 }, { 118,7831 }, { 119,7831 }, { 120,7831 }, { 121,7831 },
 { 122,7831 }, { 123,7831 }, { 124,8089 }, { 125,7831 }, { 126,8089 },
 { 127,7831 }, { 128,7831 }, { 129,7831 }, { 130,7831 }, { 131,7831 },
 { 132,7831 }, { 133,7831 }, { 134,7831 }, { 135,7831 }, { 136,7831 },
 { 137,7831 }, { 138,7831 }, { 139,7831 }, { 140,7831 }, { 141,7831 },
 { 142,7831 }, { 143,7831 }, { 144,7831 }, { 145,7831 }, { 146,7831 },
 { 147,7831 }, { 148,7831 }, { 149,7831 }, { 150,7831 }, { 151,7831 },
 { 152,7831 }, { 153,7831 }, { 154,7831 }, { 155,7831 }, { 156,7831 },

 { 157,7831 }, { 158,7831 }, { 159,7831 }, { 160,7831 }, { 161,7831 },
 { 162,7831 }, { 163,7831 }, { 164,7831 }, { 165,7831 }, { 166,7831 },
 { 167,7831 }, { 168,7831 }, { 169,7831 }, { 170,7831 }, { 171,7831 },
 { 172,7831 }, { 173,7831 }, { 174,7831 }, { 175,7831 }, { 176,7831 },
 { 177,7831 }, { 178,7831 }, { 179,7831 }, { 180,7831 }, { 181,7831 },
 { 182,7831 }, { 183,7831 }, { 184,7831 }, { 185,7831 }, { 186,7831 },
 { 187,7831 }, { 188,7831 }, { 189,7831 }, { 190,7831 }, { 191,7831 },
 { 192,7831 }, { 193,7831 }, { 194,7831 }, { 195,7831 }, { 196,7831 },
 { 197,7831 }, { 198,7831 }, { 199,7831 }, { 200,7831 }, { 201,7831 },
 { 202,7831 }, { 203,7831 }, { 204,7831 }, { 205,7831 }, { 206,7831 },

 { 207,7831 }, { 208,7831 }, { 209,7831 }, { 210,7831 }, { 211,7831 },
 { 212,7831 }, { 213,7831 }, { 214,7831 }, { 215,7831 }, { 216,7831 },
 { 217,7831 }, { 218,7831 }, { 219,7831 }, { 220,7831 }, { 221,7831 },
 { 222,7831 }, { 223,7831 }, { 224,7831 }, { 225,7831 }, { 226,7831 },
 { 227,7831 }, { 228,7831 }, { 229,7831 }, { 230,7831 }, { 231,7831 },
 { 232,7831 }, { 233,7831 }, { 234,7831 }, { 235,7831 }, { 236,7831 },
 { 237,7831 }, { 238,7831 }, { 239,7831 }, { 240,7831 }, { 241,7831 },
 { 242,7831 }, { 243,7831 }, { 244,7831 }, { 245,7831 }, { 246,7831 },
 { 247,7831 }, { 248,7831 }, { 249,7831 }, { 250,7831 }, { 251,7831 },
 { 252,7831 }, { 253,7831 }, { 254,7831 }, { 255,7831 }, { 256,7831 },

 {   0,   0 }, {   0,22590 }, {   1,8089 }, {   2,8089 }, {   3,8089 },
 {   4,8089 }, {   5,8089 }, {   6,8089 }, {   7,8089 }, {   8,8089 },
 {   9,8089 }, {  10,8089 }, {  11,8089 }, {  12,8089 }, {  13,8089 },
 {  14,8089 }, {  15,8089 }, {  16,8089 }, {  17,8089 }, {  18,8089 },
 {  19,8089 }, {  20,8089 }, {  21,8089 }, {  22,8089 }, {  23,8089 },
 {  24,8089 }, {  25,8089 }, {  26,8089 }, {  27,8089 }, {  28,8089 },
 {  29,8089 }, {  30,8089 }, {  31,8089 }, {  32,8089 }, {  33,8089 },
 {  34,4685 }, {  35,8089 }, {  36,8089 }, {  37,8089 }, {  38,8089 },
 {  39,8089 }, {  40,8089 }, {  41,8089 }, {  42,8089 }, {  43,8089 },
 {  44,8089 }, {  45,8089 }, {  46,8089 }, {  47,8089 }, {  48,8089 },

 {  49,8089 }, {  50,8089 }, {  51,8089 }, {  52,8089 }, {  53,8089 },
 {  54,8089 }, {  55,8089 }, {  56,8089 }, {  57,8089 }, {  58,8089 },
 {  59,8089 }, {  60,8089 }, {  61,8089 }, {  62,8089 }, {  63,8089 },
 {  64,8089 }, {  65,8089 }, {  66,8089 }, {  67,8089 }, {  68,8089 },
 {  69,8089 }, {  70,8089 }, {  71,8089 }, {  72,8089 }, {  73,8089 },
 {  74,8089 }, {  75,8089 }, {  76,8089 }, {  77,8089 }, {  78,8089 },
 {  79,8089 }, {  80,8089 }, {  81,8089 }, {  82,8089 }, {  83,8089 },
 {  84,8089 }, {  85,8089 }, {  86,8089 }, {  87,8089 }, {  88,8089 },
 {  89,8089 }, {  90,8089 }, {  91,8089 }, {  92,8089 }, {  93,8089 },
 {  94,8089 }, {  95,8089 }, {  96,8089 }, {  97,8089 }, {  98,8089 },

 {  99,8089 }, { 100,8089 }, { 101,8089 }, { 102,8089 }, { 103,8089 },
 { 104,8089 }, { 105,8089 }, { 106,8089 }, { 107,8089 }, { 108,8089 },
 { 109,8089 }, { 110,8089 }, { 111,8089 }, { 112,8089 }, { 113,8089 },
 { 114,8089 }, { 115,8089 }, { 116,8089 }, { 117,8089 }, { 118,8089 },
 { 119,8089 }, { 120,8089 }, { 121,8089 }, { 122,8089 }, { 123,8089 },
 { 124,8089 }, { 125,8089 }, { 126,8089 }, { 127,8089 }, { 128,8089 },
 { 129,8089 }, { 130,8089 }, { 131,8089 }, { 132,8089 }, { 133,8089 },
 { 134,8089 }, { 135,8089 }, { 136,8089 }, { 137,8089 }, { 138,8089 },
 { 139,8089 }, { 140,8089 }, { 141,8089 }, { 142,8089 }, { 143,8089 },
 { 144,8089 }, { 145,8089 }, { 146,8089 }, { 147,8089 }, { 148,8089 },

 { 149,8089 }, { 150,8089 }, { 151,8089 }, { 152,8089 }, { 153,8089 },
 { 154,8089 }, { 155,8089 }, { 156,8089 }, { 157,8089 }, { 158,8089 },
 { 159,8089 }, { 160,8089 }, { 161,8089 }, { 162,8089 }, { 163,8089 },
 { 164,8089 }, { 165,8089 }, { 166,8089 }, { 167,8089 }, { 168,8089 },
 { 169,8089 }, { 170,8089 }, { 171,8089 }, { 172,8089 }, { 173,8089 },
 { 174,8089 }, { 175,8089 }, { 176,8089 }, { 177,8089 }, { 178,8089 },
 { 179,8089 }, { 180,8089 }, { 181,8089 }, { 182,8089 }, { 183,8089 },
 { 184,8089 }, { 185,8089 }, { 186,8089 }, { 187,8089 }, { 188,8089 },
 { 189,8089 }, { 190,8089 }, { 191,8089 }, { 192,8089 }, { 193,8089 },
 { 194,8089 }, { 195,8089 }, { 196,8089 }, { 197,8089 }, { 198,8089 },

 { 199,8089 }, { 200,8089 }, { 201,8089 }, { 202,8089 }, { 203,8089 },
 { 204,8089 }, { 205,8089 }, { 206,8089 }, { 207,8089 }, { 208,8089 },
 { 209,8089 }, { 210,8089 }, { 211,8089 }, { 212,8089 }, { 213,8089 },
 { 214,8089 }, { 215,8089 }, { 216,8089 }, { 217,8089 }, { 218,8089 },
 { 219,8089 }, { 220,8089 }, { 221,8089 }, { 222,8089 }, { 223,8089 },
 { 224,8089 }, { 225,8089 }, { 226,8089 }, { 227,8089 }, { 228,8089 },
 { 229,8089 }, { 230,8089 }, { 231,8089 }, { 232,8089 }, { 233,8089 },
 { 234,8089 }, { 235,8089 }, { 236,8089 }, { 237,8089 }, { 238,8089 },
 { 239,8089 }, { 240,8089 }, { 241,8089 }, { 242,8089 }, { 243,8089 },
 { 244,8089 }, { 245,8089 }, { 246,8089 }, { 247,8089 }, { 248,8089 },

 { 249,8089 }, { 250,8089 }, { 251,8089 }, { 252,8089 }, { 253,8089 },
 { 254,8089 }, { 255,8089 }, { 256,8089 }, {   0,   0 }, {   0,22332 },
 {   1,7831 }, {   2,7831 }, {   3,7831 }, {   4,7831 }, {   5,7831 },
 {   6,7831 }, {   7,7831 }, {   8,7831 }, {   9,7831 }, {  10,7831 },
 {  11,7831 }, {  12,7831 }, {  13,7831 }, {  14,7831 }, {  15,7831 },
 {  16,7831 }, {  17,7831 }, {  18,7831 }, {  19,7831 }, {  20,7831 },
 {  21,7831 }, {  22,7831 }, {  23,7831 }, {  24,7831 }, {  25,7831 },
 {  26,7831 }, {  27,7831 }, {  28,7831 }, {  29,7831 }, {  30,7831 },
 {  31,7831 }, {  32,7831 }, {  33,7831 }, {  34,4427 }, {  35,7831 },
 {  36,7831 }, {  37,7831 }, {  38,7831 }, {  39,7831 }, {  40,7831 },

 {  41,7831 }, {  42,7831 }, {  43,7831 }, {  44,7831 }, {  45,7831 },
 {  46,7831 }, {  47,7831 }, {  48,7831 }, {  49,7831 }, {  50,7831 },
 {  51,7831 }, {  52,7831 }, {  53,7831 }, {  54,7831 }, {  55,7831 },
 {  56,7831 }, {  57,7831 }, {  58,7831 }, {  59,7831 }, {  60,7831 },
 {  61,7831 }, {  62,7831 }, {  63,7831 }, {  64,7831 }, {  65,7831 },
 {  66,7831 }, {  67,7831 }, {  68,7831 }, {  69,7831 }, {  70,7831 },
 {  71,7831 }, {  72,7831 }, {  73,7831 }, {  74,7831 }, {  75,7831 },
 {  76,7831 }, {  77,7831 }, {  78,7831 }, {  79,7831 }, {  80,7831 },
 {  81,7831 }, {  82,7831 }, {  83,7831 }, {  84,7831 }, {  85,7831 },
 {  86,7831 }, {  87,7831 }, {  88,7831 }, {  89,7831 }, {  90,7831 },

 {  91,7831 }, {  92,7831 }, {  93,7831 }, {  94,7831 }, {  95,7831 },
 {  96,7831 }, {  97,7831 }, {  98,7831 }, {  99,7831 }, { 100,7831 },
 { 101,7831 }, { 102,7831 }, { 103,7831 }, { 104,7831 }, { 105,7831 },
 { 106,7831 }, { 107,7831 }, { 108,7831 }, { 109,7831 }, { 110,7831 },
 { 111,7831 }, { 112,7831 }, { 113,7831 }, { 114,7831 }, { 115,7831 },
 { 116,7831 }, { 117,7831 }, { 118,7831 }, { 119,7831 }, { 120,7831 },
 { 121,7831 }, { 122,7831 }, { 123,7831 }, { 124,7831 }, { 125,7831 },
 { 126,7831 }, { 127,7831 }, { 128,7831 }, { 129,7831 }, { 130,7831 },
 { 131,7831 }, { 132,7831 }, { 133,7831 }, { 134,7831 }, { 135,7831 },
 { 136,7831 }, { 137,7831 }, { 138,7831 }, { 139,7831 }, { 140,7831 },

 { 141,7831 }, { 142,7831 }, { 143,7831 }, { 144,7831 }, { 145,7831 },
 { 146,7831 }, { 147,7831 }, { 148,7831 }, { 149,7831 }, { 150,7831 },
 { 151,7831 }, { 152,7831 }, { 153,7831 }, { 154,7831 }, { 155,7831 },
 { 156,7831 }, { 157,7831 }, { 158,7831 }, { 159,7831 }, { 160,7831 },
 { 161,7831 }, { 162,7831 }, { 163,7831 }, { 164,7831 }, { 165,7831 },
 { 166,7831 }, { 167,7831 }, { 168,7831 }, { 169,7831 }, { 170,7831 },
 { 171,7831 }, { 172,7831 }, { 173,7831 }, { 174,7831 }, { 175,7831 },
 { 176,7831 }, { 177,7831 }, { 178,7831 }, { 179,7831 }, { 180,7831 },
 { 181,7831 }, { 182,7831 }, { 183,7831 }, { 184,7831 }, { 185,7831 },
 { 186,7831 }, { 187,7831 }, { 188,7831 }, { 189,7831 }, { 190,7831 },

 { 191,7831 }, { 192,7831 }, { 193,7831 }, { 194,7831 }, { 195,7831 },
 { 196,7831 }, { 197,7831 }, { 198,7831 }, { 199,7831 }, { 200,7831 },
 { 201,7831 }, { 202,7831 }, { 203,7831 }, { 204,7831 }, { 205,7831 },
 { 206,7831 }, { 207,7831 }, { 208,7831 }, { 209,7831 }, { 210,7831 },
 { 211,7831 }, { 212,7831 }, { 213,7831 }, { 214,7831 }, { 215,7831 },
 { 216,7831 }, { 217,7831 }, { 218,7831 }, { 219,7831 }, { 220,7831 },
 { 221,7831 }, { 222,7831 }, { 223,7831 }, { 224,7831 }, { 225,7831 },
 { 226,7831 }, { 227,7831 }, { 228,7831 }, { 229,7831 }, { 230,7831 },
 { 231,7831 }, { 232,7831 }, { 233,7831 }, { 234,7831 }, { 235,7831 },
 { 236,7831 }, { 237,7831 }, { 238,7831 }, { 239,7831 }, { 240,7831 },

 { 241,7831 }, { 242,7831 }, { 243,7831 }, { 244,7831 }, { 245,7831 },
 { 246,7831 }, { 247,7831 }, { 248,7831 }, { 249,7831 }, { 250,7831 },
 { 251,7831 }, { 252,7831 }, { 253,7831 }, { 254,7831 }, { 255,7831 },
 { 256,7831 }, {   0,   9 }, {   0,22074 }, {   1,7831 }, {   2,7831 },
 {   3,7831 }, {   4,7831 }, {   5,7831 }, {   6,7831 }, {   7,7831 },
 {   8,7831 }, {   9,7831 }, {  10,7831 }, {  11,7831 }, {  12,7831 },
 {  13,7831 }, {  14,7831 }, {  15,7831 }, {  16,7831 }, {  17,7831 },
 {  18,7831 }, {  19,7831 }, {  20,7831 }, {  21,7831 }, {  22,7831 },
 {  23,7831 }, {  24,7831 }, {  25,7831 }, {  26,7831 }, {  27,7831 },
 {  28,7831 }, {  29,7831 }, {  30,7831 }, {  31,7831 }, {  32,7831 },

 {  33,7831 }, {  34,7831 }, {  35,7831 }, {  36,7831 }, {  37,7831 },
 {  38,7831 }, {  39,4157 }, {  40,7831 }, {  41,7831 }, {  42,7831 },
 {  43,7831 }, {  44,7831 }, {  45,7831 }, {  46,7831 }, {  47,7831 },
 {  48,7831 }, {  49,7831 }, {  50,7831 }, {  51,7831 }, {  52,7831 },
 {  53,7831 }, {  54,7831 }, {  55,7831 }, {  56,7831 }, {  57,7831 },
 {  58,7831 }, {  59,7831 }, {  60,7831 }, {  61,7831 }, {  62,7831 },
 {  63,7831 }, {  64,7831 }, {  65,7831 }, {  66,7831 }, {  67,7831 },
 {  68,7831 }, {  69,7831 }, {  70,7831 }, {  71,7831 }, {  72,7831 },
 {  73,7831 }, {  74,7831 }, {  75,7831 }, {  76,7831 }, {  77,7831 },
 {  78,7831 }, {  79,7831 }, {  80,7831 }, {  81,7831 }, {  82,7831 },

 {  83,7831 }, {  84,7831 }, {  85,7831 }, {  86,7831 }, {  87,7831 },
 {  88,7831 }, {  89,7831 }, {  90,7831 }, {  91,7831 }, {  92,7831 },
 {  93,7831 }, {  94,7831 }, {  95,7831 }, {  96,7831 }, {  97,7831 },
 {  98,7831 }, {  99,7831 }, { 100,7831 }, { 101,7831 }, { 102,7831 },
 { 103,7831 }, { 104,7831 }, { 105,7831 }, { 106,7831 }, { 107,7831 },
 { 108,7831 }, { 109,7831 }, { 110,7831 }, { 111,7831 }, { 112,7831 },
 { 113,7831 }, { 114,7831 }, { 115,7831 }, { 116,7831 }, { 117,7831 },
 { 118,7831 }, { 119,7831 }, { 120,7831 }, { 121,7831 }, { 122,7831 },
 { 123,7831 }, { 124,7831 }, { 125,7831 }, { 126,7831 }, { 127,7831 },
 { 128,7831 }, { 129,7831 }, { 130,7831 }, { 131,7831 }, { 132,7831 },

 { 133,7831 }, { 134,7831 }, { 135,7831 }, { 136,7831 }, { 137,7831 },
 { 138,7831 }, { 139,7831 }, { 140,7831 }, { 141,7831 }, { 142,7831 },
 { 143,7831 }, { 144,7831 }, { 145,7831 }, { 146,7831 }, { 147,7831 },
 { 148,7831 }, { 149,7831 }, { 150,7831 }, { 151,7831 }, { 152,7831 },
 { 153,7831 }, { 154,7831 }, { 155,7831 }, { 156,7831 }, { 157,7831 },
 { 158,7831 }, { 159,7831 }, { 160,7831 }, { 161,7831 }, { 162,7831 },
 { 163,7831 }, { 164,7831 }, { 165,7831 }, { 166,7831 }, { 167,7831 },
 { 168,7831 }, { 169,7831 }, { 170,7831 }, { 171,7831 }, { 172,7831 },
 { 173,7831 }, { 174,7831 }, { 175,7831 }, { 176,7831 }, { 177,7831 },
 { 178,7831 }, { 179,7831 }, { 180,7831 }, { 181,7831 }, { 182,7831 },

 { 183,7831 }, { 184,7831 }, { 185,7831 }, { 186,7831 }, { 187,7831 },
 { 188,7831 }, { 189,7831 }, { 190,7831 }, { 191,7831 }, { 192,7831 },
 { 193,7831 }, { 194,7831 }, { 195,7831 }, { 196,7831 }, { 197,7831 },
 { 198,7831 }, { 199,7831 }, { 200,7831 }, { 201,7831 }, { 202,7831 },
 { 203,7831 }, { 204,7831 }, { 205,7831 }, { 206,7831 }, { 207,7831 },
 { 208,7831 }, { 209,7831 }, { 210,7831 }, { 211,7831 }, { 212,7831 },
 { 213,7831 }, { 214,7831 }, { 215,7831 }, { 216,7831 }, { 217,7831 },
 { 218,7831 }, { 219,7831 }, { 220,7831 }, { 221,7831 }, { 222,7831 },
 { 223,7831 }, { 224,7831 }, { 225,7831 }, { 226,7831 }, { 227,7831 },
 { 228,7831 }, { 229,7831 }, { 230,7831 }, { 231,7831 }, { 232,7831 },

 { 233,7831 }, { 234,7831 }, { 235,7831 }, { 236,7831 }, { 237,7831 },
 { 238,7831 }, { 239,7831 }, { 240,7831 }, { 241,7831 }, { 242,7831 },
 { 243,7831 }, { 244,7831 }, { 245,7831 }, { 246,7831 }, { 247,7831 },
 { 248,7831 }, { 249,7831 }, { 250,7831 }, { 251,7831 }, { 252,7831 },
 { 253,7831 }, { 254,7831 }, { 255,7831 }, { 256,7831 }, {   0,   9 },
 {   0,21816 }, {   1,7573 }, {   2,7573 }, {   3,7573 }, {   4,7573 },
 {   5,7573 }, {   6,7573 }, {   7,7573 }, {   8,7573 }, {   9,7573 },
 {  10,7573 }, {  11,7573 }, {  12,7573 }, {  13,7573 }, {  14,7573 },
 {  15,7573 }, {  16,7573 }, {  17,7573 }, {  18,7573 }, {  19,7573 },
 {  20,7573 }, {  21,7573 }, {  22,7573 }, {  23,7573 }, {  24,7573 },

 {  25,7573 }, {  26,7573 }, {  27,7573 }, {  28,7573 }, {  29,7573 },
 {  30,7573 }, {  31,7573 }, {  32,7573 }, {  33,7573 }, {  34,7573 },
 {  35,7573 }, {  36,7573 }, {  37,7573 }, {  38,7573 }, {  39,3899 },
 {  40,7573 }, {  41,7573 }, {  42,7573 }, {  43,7573 }, {  44,7573 },
 {  45,7573 }, {  46,7573 }, {  47,7573 }, {  48,7573 }, {  49,7573 },
 {  50,7573 }, {  51,7573 }, {  52,7573 }, {  53,7573 }, {  54,7573 },
 {  55,7573 }, {  56,7573 }, {  57,7573 }, {  58,7573 }, {  59,7573 },
 {  60,7573 }, {  61,7573 }, {  62,7573 }, {  63,7573 }, {  64,7573 },
 {  65,7573 }, {  66,7573 }, {  67,7573 }, {  68,7573 }, {  69,7573 },
 {  70,7573 }, {  71,7573 }, {  72,7573 }, {  73,7573 }, {  74,7573 },

 {  75,7573 }, {  76,7573 }, {  77,7573 }, {  78,7573 }, {  79,7573 },
 {  80,7573 }, {  81,7573 }, {  82,7573 }, {  83,7573 }, {  84,7573 },
 {  85,7573 }, {  86,7573 }, {  87,7573 }, {  88,7573 }, {  89,7573 },
 {  90,7573 }, {  91,7573 }, {  92,7573 }, {  93,7573 }, {  94,7573 },
 {  95,7573 }, {  96,7573 }, {  97,7573 }, {  98,7573 }, {  99,7573 },
 { 100,7573 }, { 101,7573 }, { 102,7573 }, { 103,7573 }, { 104,7573 },
 { 105,7573 }, { 106,7573 }, { 107,7573 }, { 108,7573 }, { 109,7573 },
 { 110,7573 }, { 111,7573 }, { 112,7573 }, { 113,7573 }, { 114,7573 },
 { 115,7573 }, { 116,7573 }, { 117,7573 }, { 118,7573 }, { 119,7573 },
 { 120,7573 }, { 121,7573 }, { 122,7573 }, { 123,7573 }, { 124,7573 },

 { 125,7573 }, { 126,7573 }, { 127,7573 }, { 128,7573 }, { 129,7573 },
 { 130,7573 }, { 131,7573 }, { 132,7573 }, { 133,7573 }, { 134,7573 },
 { 135,7573 }, { 136,7573 }, { 137,7573 }, { 138,7573 }, { 139,7573 },
 { 140,7573 }, { 141,7573 }, { 142,7573 }, { 143,7573 }, { 144,7573 },
 { 145,7573 }, { 146,7573 }, { 147,7573 }, { 148,7573 }, { 149,7573 },
 { 150,7573 }, { 151,7573 }, { 152,7573 }, { 153,7573 }, { 154,7573 },
 { 155,7573 }, { 156,7573 }, { 157,7573 }, { 158,7573 }, { 159,7573 },
 { 160,7573 }, { 161,7573 }, { 162,7573 }, { 163,7573 }, { 164,7573 },
 { 165,7573 }, { 166,7573 }, { 167,7573 }, { 168,7573 }, { 169,7573 },
 { 170,7573 }, { 171,7573 }, { 172,7573 }, { 173,7573 }, { 174,7573 },

 { 175,7573 }, { 176,7573 }, { 177,7573 }, { 178,7573 }, { 179,7573 },
 { 180,7573 }, { 181,7573 }, { 182,7573 }, { 183,7573 }, { 184,7573 },
 { 185,7573 }, { 186,7573 }, { 187,7573 }, { 188,7573 }, { 189,7573 },
 { 190,7573 }, { 191,7573 }, { 192,7573 }, { 193,7573 }, { 194,7573 },
 { 195,7573 }, { 196,7573 }, { 197,7573 }, { 198,7573 }, { 199,7573 },
 { 200,7573 }, { 201,7573 }, { 202,7573 }, { 203,7573 }, { 204,7573 },
 { 205,7573 }, { 206,7573 }, { 207,7573 }, { 208,7573 }, { 209,7573 },
 { 210,7573 }, { 211,7573 }, { 212,7573 }, { 213,7573 }, { 214,7573 },
 { 215,7573 }, { 216,7573 }, { 217,7573 }, { 218,7573 }, { 219,7573 },
 { 220,7573 }, { 221,7573 }, { 222,7573 }, { 223,7573 }, { 224,7573 },

 { 225,7573 }, { 226,7573 }, { 227,7573 }, { 228,7573 }, { 229,7573 },
 { 230,7573 }, { 231,7573 }, { 232,7573 }, { 233,7573 }, { 234,7573 },
 { 235,7573 }, { 236,7573 }, { 237,7573 }, { 238,7573 }, { 239,7573 },
 { 240,7573 }, { 241,7573 }, { 242,7573 }, { 243,7573 }, { 244,7573 },
 { 245,7573 }, { 246,7573 }, { 247,7573 }, { 248,7573 }, { 249,7573 },
 { 250,7573 }, { 251,7573 }, { 252,7573 }, { 253,7573 }, { 254,7573 },
 { 255,7573 }, { 256,7573 }, {   0,   0 }, {   0,21558 }, {   1,7573 },
 {   2,7573 }, {   3,7573 }, {   4,7573 }, {   5,7573 }, {   6,7573 },
 {   7,7573 }, {   8,7573 }, {   9,7573 }, {  10,7573 }, {  11,7573 },
 {  12,7573 }, {  13,7573 }, {  14,7573 }, {  15,7573 }, {  16,7573 },

 {  17,7573 }, {  18,7573 }, {  19,7573 }, {  20,7573 }, {  21,7573 },
 {  22,7573 }, {  23,7573 }, {  24,7573 }, {  25,7573 }, {  26,7573 },
 {  27,7573 }, {  28,7573 }, {  29,7573 }, {  30,7573 }, {  31,7573 },
 {  32,7573 }, {  33,7573 }, {  34,7573 }, {  35,7573 }, {  36,7573 },
 {  37,7573 }, {  38,7573 }, {  39,3670 }, {  40,7573 }, {  41,7573 },
 {  42,7573 }, {  43,7573 }, {  44,7573 }, {  45,7573 }, {  46,7573 },
 {  47,7573 }, {  48,7573 }, {  49,7573 }, {  50,7573 }, {  51,7573 },
 {  52,7573 }, {  53,7573 }, {  54,7573 }, {  55,7573 }, {  56,7573 },
 {  57,7573 }, {  58,7573 }, {  59,7573 }, {  60,7573 }, {  61,7573 },
 {  62,7573 }, {  63,7573 }, {  64,7573 }, {  65,7573 }, {  66,7573 },

 {  67,7573 }, {  68,7573 }, {  69,7573 }, {  70,7573 }, {  71,7573 },
 {  72,7573 }, {  73,7573 }, {  74,7573 }, {  75,7573 }, {  76,7573 },
 {  77,7573 }, {  78,7573 }, {  79,7573 }, {  80,7573 }, {  81,7573 },
 {  82,7573 }, {  83,7573 }, {  84,7573 }, {  85,7573 }, {  86,7573 },
 {  87,7573 }, {  88,7573 }, {  89,7573 }, {  90,7573 }, {  91,7573 },
 {  92,7573 }, {  93,7573 }, {  94,7573 }, {  95,7573 }, {  96,7573 },
 {  97,7573 }, {  98,7573 }, {  99,7573 }, { 100,7573 }, { 101,7573 },
 { 102,7573 }, { 103,7573 }, { 104,7573 }, { 105,7573 }, { 106,7573 },
 { 107,7573 }, { 108,7573 }, { 109,7573 }, { 110,7573 }, { 111,7573 },
 { 112,7573 }, { 113,7573 }, { 114,7573 }, { 115,7573 }, { 116,7573 },

 { 117,7573 }, { 118,7573 }, { 119,7573 }, { 120,7573 }, { 121,7573 },
 { 122,7573 }, { 123,7573 }, { 124,7573 }, { 125,7573 }, { 126,7573 },
 { 127,7573 }, { 128,7573 }, { 129,7573 }, { 130,7573 }, { 131,7573 },
 { 132,7573 }, { 133,7573 }, { 134,7573 }, { 135,7573 }, { 136,7573 },
 { 137,7573 }, { 138,7573 }, { 139,7573 }, { 140,7573 }, { 141,7573 },
 { 142,7573 }, { 143,7573 }, { 144,7573 }, { 145,7573 }, { 146,7573 },
 { 147,7573 }, { 148,7573 }, { 149,7573 }, { 150,7573 }, { 151,7573 },
 { 152,7573 }, { 153,7573 }, { 154,7573 }, { 155,7573 }, { 156,7573 },
 { 157,7573 }, { 158,7573 }, { 159,7573 }, { 160,7573 }, { 161,7573 },
 { 162,7573 }, { 163,7573 }, { 164,7573 }, { 165,7573 }, { 166,7573 },

 { 167,7573 }, { 168,7573 }, { 169,7573 }, { 170,7573 }, { 171,7573 },
 { 172,7573 }, { 173,7573 }, { 174,7573 }, { 175,7573 }, { 176,7573 },
 { 177,7573 }, { 178,7573 }, { 179,7573 }, { 180,7573 }, { 181,7573 },
 { 182,7573 }, { 183,7573 }, { 184,7573 }, { 185,7573 }, { 186,7573 },
 { 187,7573 }, { 188,7573 }, { 189,7573 }, { 190,7573 }, { 191,7573 },
 { 192,7573 }, { 193,7573 }, { 194,7573 }, { 195,7573 }, { 196,7573 },
 { 197,7573 }, { 198,7573 }, { 199,7573 }, { 200,7573 }, { 201,7573 },
 { 202,7573 }, { 203,7573 }, { 204,7573 }, { 205,7573 }, { 206,7573 },
 { 207,7573 }, { 208,7573 }, { 209,7573 }, { 210,7573 }, { 211,7573 },
 { 212,7573 }, { 213,7573 }, { 214,7573 }, { 215,7573 }, { 216,7573 },

 { 217,7573 }, { 218,7573 }, { 219,7573 }, { 220,7573 }, { 221,7573 },
 { 222,7573 }, { 223,7573 }, { 224,7573 }, { 225,7573 }, { 226,7573 },
 { 227,7573 }, { 228,7573 }, { 229,7573 }, { 230,7573 }, { 231,7573 },
 { 232,7573 }, { 233,7573 }, { 234,7573 }, { 235,7573 }, { 236,7573 },
 { 237,7573 }, { 238,7573 }, { 239,7573 }, { 240,7573 }, { 241,7573 },
 { 242,7573 }, { 243,7573 }, { 244,7573 }, { 245,7573 }, { 246,7573 },
 { 247,7573 }, { 248,7573 }, { 249,7573 }, { 250,7573 }, { 251,7573 },
 { 252,7573 }, { 253,7573 }, { 254,7573 }, { 255,7573 }, { 256,7573 },
 {   0,   0 }, {   0,21300 }, {   1,7315 }, {   2,7315 }, {   3,7315 },
 {   4,7315 }, {   5,7315 }, {   6,7315 }, {   7,7315 }, {   8,7315 },

 {   9,7315 }, {  10,7315 }, {  11,7315 }, {  12,7315 }, {  13,7315 },
 {  14,7315 }, {  15,7315 }, {  16,7315 }, {  17,7315 }, {  18,7315 },
 {  19,7315 }, {  20,7315 }, {  21,7315 }, {  22,7315 }, {  23,7315 },
 {  24,7315 }, {  25,7315 }, {  26,7315 }, {  27,7315 }, {  28,7315 },
 {  29,7315 }, {  30,7315 }, {  31,7315 }, {  32,7315 }, {  33,7315 },
 {  34,7315 }, {  35,7315 }, {  36,7315 }, {  37,7315 }, {  38,7315 },
 {  39,3412 }, {  40,7315 }, {  41,7315 }, {  42,7315 }, {  43,7315 },
 {  44,7315 }, {  45,7315 }, {  46,7315 }, {  47,7315 }, {  48,7315 },
 {  49,7315 }, {  50,7315 }, {  51,7315 }, {  52,7315 }, {  53,7315 },
 {  54,7315 }, {  55,7315 }, {  56,7315 }, {  57,7315 }, {  58,7315 },

 {  59,7315 }, {  60,7315 }, {  61,7315 }, {  62,7315 }, {  63,7315 },
 {  64,7315 }, {  65,7315 }, {  66,7315 }, {  67,7315 }, {  68,7315 },
 {  69,7315 }, {  70,7315 }, {  71,7315 }, {  72,7315 }, {  73,7315 },
 {  74,7315 }, {  75,7315 }, {  76,7315 }, {  77,7315 }, {  78,7315 },
 {  79,7315 }, {  80,7315 }, {  81,7315 }, {  82,7315 }, {  83,7315 },
 {  84,7315 }, {  85,7315 }, {  86,7315 }, {  87,7315 }, {  88,7315 },
 {  89,7315 }, {  90,7315 }, {  91,7315 }, {  92,7315 }, {  93,7315 },
 {  94,7315 }, {  95,7315 }, {  96,7315 }, {  97,7315 }, {  98,7315 },
 {  99,7315 }, { 100,7315 }, { 101,7315 }, { 102,7315 }, { 103,7315 },
 { 104,7315 }, { 105,7315 }, { 106,7315 }, { 107,7315 }, { 108,7315 },

 { 109,7315 }, { 110,7315 }, { 111,7315 }, { 112,7315 }, { 113,7315 },
 { 114,7315 }, { 115,7315 }, { 116,7315 }, { 117,7315 }, { 118,7315 },
 { 119,7315 }, { 120,7315 }, { 121,7315 }, { 122,7315 }, { 123,7315 },
 { 124,7315 }, { 125,7315 }, { 126,7315 }, { 127,7315 }, { 128,7315 },
 { 129,7315 }, { 130,7315 }, { 131,7315 }, { 132,7315 }, { 133,7315 },
 { 134,7315 }, { 135,7315 }, { 136,7315 }, { 137,7315 }, { 138,7315 },
 { 139,7315 }, { 140,7315 }, { 141,7315 }, { 142,7315 }, { 143,7315 },
 { 144,7315 }, { 145,7315 }, { 146,7315 }, { 147,7315 }, { 148,7315 },
 { 149,7315 }, { 150,7315 }, { 151,7315 }, { 152,7315 }, { 153,7315 },
 { 154,7315 }, { 155,7315 }, { 156,7315 }, { 157,7315 }, { 158,7315 },

 { 159,7315 }, { 160,7315 }, { 161,7315 }, { 162,7315 }, { 163,7315 },
 { 164,7315 }, { 165,7315 }, { 166,7315 }, { 167,7315 }, { 168,7315 },
 { 169,7315 }, { 170,7315 }, { 171,7315 }, { 172,7315 }, { 173,7315 },
 { 174,7315 }, { 175,7315 }, { 176,7315 }, { 177,7315 }, { 178,7315 },
 { 179,7315 }, { 180,7315 }, { 181,7315 }, { 182,7315 }, { 183,7315 },
 { 184,7315 }, { 185,7315 }, { 186,7315 }, { 187,7315 }, { 188,7315 },
 { 189,7315 }, { 190,7315 }, { 191,7315 }, { 192,7315 }, { 193,7315 },
 { 194,7315 }, { 195,7315 }, { 196,7315 }, { 197,7315 }, { 198,7315 },
 { 199,7315 }, { 200,7315 }, { 201,7315 }, { 202,7315 }, { 203,7315 },
 { 204,7315 }, { 205,7315 }, { 206,7315 }, { 207,7315 }, { 208,7315 },

 { 209,7315 }, { 210,7315 }, { 211,7315 }, { 212,7315 }, { 213,7315 },
 { 214,7315 }, { 215,7315 }, { 216,7315 }, { 217,7315 }, { 218,7315 },
 { 219,7315 }, { 220,7315 }, { 221,7315 }, { 222,7315 }, { 223,7315 },
 { 224,7315 }, { 225,7315 }, { 226,7315 }, { 227,7315 }, { 228,7315 },
 { 229,7315 }, { 230,7315 }, { 231,7315 }, { 232,7315 }, { 233,7315 },
 { 234,7315 }, { 235,7315 }, { 236,7315 }, { 237,7315 }, { 238,7315 },
 { 239,7315 }, { 240,7315 }, { 241,7315 }, { 242,7315 }, { 243,7315 },
 { 244,7315 }, { 245,7315 }, { 246,7315 }, { 247,7315 }, { 248,7315 },
 { 249,7315 }, { 250,7315 }, { 251,7315 }, { 252,7315 }, { 253,7315 },
 { 254,7315 }, { 255,7315 }, { 256,7315 }, {   0,  18 }, {   0,21042 },

 {   1,3156 }, {   2,3156 }, {   3,3156 }, {   4,3156 }, {   5,3156 },
 {   6,3156 }, {   7,3156 }, {   8,3156 }, {   9,7315 }, {  10,7320 },
 {  11,3156 }, {  12,7315 }, {  13,7336 }, {  14,3156 }, {  15,3156 },
 {  16,3156 }, {  17,3156 }, {  18,3156 }, {  19,3156 }, {  20,3156 },
 {  21,3156 }, {  22,3156 }, {  23,3156 }, {  24,3156 }, {  25,3156 },
 {  26,3156 }, {  27,3156 }, {  28,3156 }, {  29,3156 }, {  30,3156 },
 {  31,3156 }, {  32,7315 }, {  33,3156 }, {  34,3156 }, {  35,3156 },
 {  36,3156 }, {  37,3156 }, {  38,3156 }, {  39,3156 }, {  40,3156 },
 {  41,3156 }, {  42,3156 }, {  43,3156 }, {  44,3156 }, {  45,3158 },
 {  46,3156 }, {  47,3156 }, {  48,3156 }, {  49,3156 }, {  50,3156 },

 {  51,3156 }, {  52,3156 }, {  53,3156 }, {  54,3156 }, {  55,3156 },
 {  56,3156 }, {  57,3156 }, {  58,3156 }, {  59,3156 }, {  60,3156 },
 {  61,3156 }, {  62,3156 }, {  63,3156 }, {  64,3156 }, {  65,3156 },
 {  66,3156 }, {  67,3156 }, {  68,3156 }, {  69,3156 }, {  70,3156 },
 {  71,3156 }, {  72,3156 }, {  73,3156 }, {  74,3156 }, {  75,3156 },
 {  76,3156 }, {  77,3156 }, {  78,3156 }, {  79,3156 }, {  80,3156 },
 {  81,3156 }, {  82,3156 }, {  83,3156 }, {  84,3156 }, {  85,3156 },
 {  86,3156 }, {  87,3156 }, {  88,3156 }, {  89,3156 }, {  90,3156 },
 {  91,3156 }, {  92,3156 }, {  93,3156 }, {  94,3156 }, {  95,3156 },
 {  96,3156 }, {  97,3156 }, {  98,3156 }, {  99,3156 }, { 100,3156 },

 { 101,3156 }, { 102,3156 }, { 103,3156 }, { 104,3156 }, { 105,3156 },
 { 106,3156 }, { 107,3156 }, { 108,3156 }, { 109,3156 }, { 110,3156 },
 { 111,3156 }, { 112,3156 }, { 113,3156 }, { 114,3156 }, { 115,3156 },
 { 116,3156 }, { 117,3156 }, { 118,3156 }, { 119,3156 }, { 120,3156 },
 { 121,3156 }, { 122,3156 }, { 123,3156 }, { 124,3156 }, { 125,3156 },
 { 126,3156 }, { 127,3156 }, { 128,3156 }, { 129,3156 }, { 130,3156 },
 { 131,3156 }, { 132,3156 }, { 133,3156 }, { 134,3156 }, { 135,3156 },
 { 136,3156 }, { 137,3156 }, { 138,3156 }, { 139,3156 }, { 140,3156 },
 { 141,3156 }, { 142,3156 }, { 143,3156 }, { 144,3156 }, { 145,3156 },
 { 146,3156 }, { 147,3156 }, { 148,3156 }, { 149,3156 }, { 150,3156 },

 { 151,3156 }, { 152,3156 }, { 153,3156 }, { 154,3156 }, { 155,3156 },
 { 156,3156 }, { 157,3156 }, { 158,3156 }, { 159,3156 }, { 160,3156 },
 { 161,3156 }, { 162,3156 }, { 163,3156 }, { 164,3156 }, { 165,3156 },
 { 166,3156 }, { 167,3156 }, { 168,3156 }, { 169,3156 }, { 170,3156 },
 { 171,3156 }, { 172,3156 }, { 173,3156 }, { 174,3156 }, { 175,3156 },
 { 176,3156 }, { 177,3156 }, { 178,3156 }, { 179,3156 }, { 180,3156 },
 { 181,3156 }, { 182,3156 }, { 183,3156 }, { 184,3156 }, { 185,3156 },
 { 186,3156 }, { 187,3156 }, { 188,3156 }, { 189,3156 }, { 190,3156 },
 { 191,3156 }, { 192,3156 }, { 193,3156 }, { 194,3156 }, { 195,3156 },
 { 196,3156 }, { 197,3156 }, { 198,3156 }, { 199,3156 }, { 200,3156 },

 { 201,3156 }, { 202,3156 }, { 203,3156 }, { 204,3156 }, { 205,3156 },
 { 206,3156 }, { 207,3156 }, { 208,3156 }, { 209,3156 }, { 210,3156 },
 { 211,3156 }, { 212,3156 }, { 213,3156 }, { 214,3156 }, { 215,3156 },
 { 216,3156 }, { 217,3156 }, { 218,3156 }, { 219,3156 }, { 220,3156 },
 { 221,3156 }, { 222,3156 }, { 223,3156 }, { 224,3156 }, { 225,3156 },
 { 226,3156 }, { 227,3156 }, { 228,3156 }, { 229,3156 }, { 230,3156 },
 { 231,3156 }, { 232,3156 }, { 233,3156 }, { 234,3156 }, { 235,3156 },
 { 236,3156 }, { 237,3156 }, { 238,3156 }, { 239,3156 }, { 240,3156 },
 { 241,3156 }, { 242,3156 }, { 243,3156 }, { 244,3156 }, { 245,3156 },
 { 246,3156 }, { 247,3156 }, { 248,3156 }, { 249,3156 }, { 250,3156 },

 { 251,3156 }, { 252,3156 }, { 253,3156 }, { 254,3156 }, { 255,3156 },
 { 256,3156 }, {   0,  18 }, {   0,20784 }, {   1,2898 }, {   2,2898 },
 {   3,2898 }, {   4,2898 }, {   5,2898 }, {   6,2898 }, {   7,2898 },
 {   8,2898 }, {   9,7057 }, {  10,7062 }, {  11,2898 }, {  12,7057 },
 {  13,7078 }, {  14,2898 }, {  15,2898 }, {  16,2898 }, {  17,2898 },
 {  18,2898 }, {  19,2898 }, {  20,2898 }, {  21,2898 }, {  22,2898 },
 {  23,2898 }, {  24,2898 }, {  25,2898 }, {  26,2898 }, {  27,2898 },
 {  28,2898 }, {  29,2898 }, {  30,2898 }, {  31,2898 }, {  32,7057 },
 {  33,2898 }, {  34,2898 }, {  35,2898 }, {  36,2898 }, {  37,2898 },
 {  38,2898 }, {  39,2898 }, {  40,2898 }, {  41,2898 }, {  42,2898 },

 {  43,2898 }, {  44,2898 }, {  45,2900 }, {  46,2898 }, {  47,2898 },
 {  48,2898 }, {  49,2898 }, {  50,2898 }, {  51,2898 }, {  52,2898 },
 {  53,2898 }, {  54,2898 }, {  55,2898 }, {  56,2898 }, {  57,2898 },
 {  58,2898 }, {  59,2898 }, {  60,2898 }, {  61,2898 }, {  62,2898 },
 {  63,2898 }, {  64,2898 }, {  65,2898 }, {  66,2898 }, {  67,2898 },
 {  68,2898 }, {  69,2898 }, {  70,2898 }, {  71,2898 }, {  72,2898 },
 {  73,2898 }, {  74,2898 }, {  75,2898 }, {  76,2898 }, {  77,2898 },
 {  78,2898 }, {  79,2898 }, {  80,2898 }, {  81,2898 }, {  82,2898 },
 {  83,2898 }, {  84,2898 }, {  85,2898 }, {  86,2898 }, {  87,2898 },
 {  88,2898 }, {  89,2898 }, {  90,2898 }, {  91,2898 }, {  92,2898 },

 {  93,2898 }, {  94,2898 }, {  95,2898 }, {  96,2898 }, {  97,2898 },
 {  98,2898 }, {  99,2898 }, { 100,2898 }, { 101,2898 }, { 102,2898 },
 { 103,2898 }, { 104,2898 }, { 105,2898 }, { 106,2898 }, { 107,2898 },
 { 108,2898 }, { 109,2898 }, { 110,2898 }, { 111,2898 }, { 112,2898 },
 { 113,2898 }, { 114,2898 }, { 115,2898 }, { 116,2898 }, { 117,2898 },
 { 118,2898 }, { 119,2898 }, { 120,2898 }, { 121,2898 }, { 122,2898 },
 { 123,2898 }, { 124,2898 }, { 125,2898 }, { 126,2898 }, { 127,2898 },
 { 128,2898 }, { 129,2898 }, { 130,2898 }, { 131,2898 }, { 132,2898 },
 { 133,2898 }, { 134,2898 }, { 135,2898 }, { 136,2898 }, { 137,2898 },
 { 138,2898 }, { 139,2898 }, { 140,2898 }, { 141,2898 }, { 142,2898 },

 { 143,2898 }, { 144,2898 }, { 145,2898 }, { 146,2898 }, { 147,2898 },
 { 148,2898 }, { 149,2898 }, { 150,2898 }, { 151,2898 }, { 152,2898 },
 { 153,2898 }, { 154,2898 }, { 155,2898 }, { 156,2898 }, { 157,2898 },
 { 158,2898 }, { 159,2898 }, { 160,2898 }, { 161,2898 }, { 162,2898 },
 { 163,2898 }, { 164,2898 }, { 165,2898 }, { 166,2898 }, { 167,2898 },
 { 168,2898 }, { 169,2898 }, { 170,2898 }, { 171,2898 }, { 172,2898 },
 { 173,2898 }, { 174,2898 }, { 175,2898 }, { 176,2898 }, { 177,2898 },
 { 178,2898 }, { 179,2898 }, { 180,2898 }, { 181,2898 }, { 182,2898 },
 { 183,2898 }, { 184,2898 }, { 185,2898 }, { 186,2898 }, { 187,2898 },
 { 188,2898 }, { 189,2898 }, { 190,2898 }, { 191,2898 }, { 192,2898 },

 { 193,2898 }, { 194,2898 }, { 195,2898 }, { 196,2898 }, { 197,2898 },
 { 198,2898 }, { 199,2898 }, { 200,2898 }, { 201,2898 }, { 202,2898 },
 { 203,2898 }, { 204,2898 }, { 205,2898 }, { 206,2898 }, { 207,2898 },
 { 208,2898 }, { 209,2898 }, { 210,2898 }, { 211,2898 }, { 212,2898 },
 { 213,2898 }, { 214,2898 }, { 215,2898 }, { 216,2898 }, { 217,2898 },
 { 218,2898 }, { 219,2898 }, { 220,2898 }, { 221,2898 }, { 222,2898 },
 { 223,2898 }, { 224,2898 }, { 225,2898 }, { 226,2898 }, { 227,2898 },
 { 228,2898 }, { 229,2898 }, { 230,2898 }, { 231,2898 }, { 232,2898 },
 { 233,2898 }, { 234,2898 }, { 235,2898 }, { 236,2898 }, { 237,2898 },
 { 238,2898 }, { 239,2898 }, { 240,2898 }, { 241,2898 }, { 242,2898 },

 { 243,2898 }, { 244,2898 }, { 245,2898 }, { 246,2898 }, { 247,2898 },
 { 248,2898 }, { 249,2898 }, { 250,2898 }, { 251,2898 }, { 252,2898 },
 { 253,2898 }, { 254,2898 }, { 255,2898 }, { 256,2898 }, {   0,   0 },
 {   0,20526 }, {   1,6867 }, {   2,6867 }, {   3,6867 }, {   4,6867 },
 {   5,6867 }, {   6,6867 }, {   7,6867 }, {   8,6867 }, {   9,6867 },
 {  10,7125 }, {  11,6867 }, {  12,6867 }, {  13,6867 }, {  14,6867 },
 {  15,6867 }, {  16,6867 }, {  17,6867 }, {  18,6867 }, {  19,6867 },
 {  20,6867 }, {  21,6867 }, {  22,6867 }, {  23,6867 }, {  24,6867 },
 {  25,6867 }, {  26,6867 }, {  27,6867 }, {  28,6867 }, {  29,6867 },
 {  30,6867 }, {  31,6867 }, {  32,6867 }, {  33,6867 }, {  34,6867 },

 {  35,6867 }, {  36,6867 }, {  37,6867 }, {  38,6867 }, {  39,2645 },
 {  40,6867 }, {  41,6867 }, {  42,6867 }, {  43,6867 }, {  44,6867 },
 {  45,6867 }, {  46,6867 }, {  47,6867 }, {  48,6867 }, {  49,6867 },
 {  50,6867 }, {  51,6867 }, {  52,6867 }, {  53,6867 }, {  54,6867 },
 {  55,6867 }, {  56,6867 }, {  57,6867 }, {  58,6867 }, {  59,6867 },
 {  60,6867 }, {  61,6867 }, {  62,6867 }, {  63,6867 }, {  64,6867 },
 {  65,6867 }, {  66,6867 }, {  67,6867 }, {  68,6867 }, {  69,6867 },
 {  70,6867 }, {  71,6867 }, {  72,6867 }, {  73,6867 }, {  74,6867 },
 {  75,6867 }, {  76,6867 }, {  77,6867 }, {  78,6867 }, {  79,6867 },
 {  80,6867 }, {  81,6867 }, {  82,6867 }, {  83,6867 }, {  84,6867 },

 {  85,6867 }, {  86,6867 }, {  87,6867 }, {  88,6867 }, {  89,6867 },
 {  90,6867 }, {  91,6867 }, {  92,7383 }, {  93,6867 }, {  94,6867 },
 {  95,6867 }, {  96,6867 }, {  97,6867 }, {  98,6867 }, {  99,6867 },
 { 100,6867 }, { 101,6867 }, { 102,6867 }, { 103,6867 }, { 104,6867 },
 { 105,6867 }, { 106,6867 }, { 107,6867 }, { 108,6867 }, { 109,6867 },
 { 110,6867 }, { 111,6867 }, { 112,6867 }, { 113,6867 }, { 114,6867 },
 { 115,6867 }, { 116,6867 }, { 117,6867 }, { 118,6867 }, { 119,6867 },
 { 120,6867 }, { 121,6867 }, { 122,6867 }, { 123,6867 }, { 124,6867 },
 { 125,6867 }, { 126,6867 }, { 127,6867 }, { 128,6867 }, { 129,6867 },
 { 130,6867 }, { 131,6867 }, { 132,6867 }, { 133,6867 }, { 134,6867 },

 { 135,6867 }, { 136,6867 }, { 137,6867 }, { 138,6867 }, { 139,6867 },
 { 140,6867 }, { 141,6867 }, { 142,6867 }, { 143,6867 }, { 144,6867 },
 { 145,6867 }, { 146,6867 }, { 147,6867 }, { 148,6867 }, { 149,6867 },
 { 150,6867 }, { 151,6867 }, { 152,6867 }, { 153,6867 }, { 154,6867 },
 { 155,6867 }, { 156,6867 }, { 157,6867 }, { 158,6867 }, { 159,6867 },
 { 160,6867 }, { 161,6867 }, { 162,6867 }, { 163,6867 }, { 164,6867 },
 { 165,6867 }, { 166,6867 }, { 167,6867 }, { 168,6867 }, { 169,6867 },
 { 170,6867 }, { 171,6867 }, { 172,6867 }, { 173,6867 }, { 174,6867 },
 { 175,6867 }, { 176,6867 }, { 177,6867 }, { 178,6867 }, { 179,6867 },
 { 180,6867 }, { 181,6867 }, { 182,6867 }, { 183,6867 }, { 184,6867 },

 { 185,6867 }, { 186,6867 }, { 187,6867 }, { 188,6867 }, { 189,6867 },
 { 190,6867 }, { 191,6867 }, { 192,6867 }, { 193,6867 }, { 194,6867 },
 { 195,6867 }, { 196,6867 }, { 197,6867 }, { 198,6867 }, { 199,6867 },
 { 200,6867 }, { 201,6867 }, { 202,6867 }, { 203,6867 }, { 204,6867 },
 { 205,6867 }, { 206,6867 }, { 207,6867 }, { 208,6867 }, { 209,6867 },
 { 210,6867 }, { 211,6867 }, { 212,6867 }, { 213,6867 }, { 214,6867 },
 { 215,6867 }, { 216,6867 }, { 217,6867 }, { 218,6867 }, { 219,6867 },
 { 220,6867 }, { 221,6867 }, { 222,6867 }, { 223,6867 }, { 224,6867 },
 { 225,6867 }, { 226,6867 }, { 227,6867 }, { 228,6867 }, { 229,6867 },
 { 230,6867 }, { 231,6867 }, { 232,6867 }, { 233,6867 }, { 234,6867 },

 { 235,6867 }, { 236,6867 }, { 237,6867 }, { 238,6867 }, { 239,6867 },
 { 240,6867 }, { 241,6867 }, { 242,6867 }, { 243,6867 }, { 244,6867 },
 { 245,6867 }, { 246,6867 }, { 247,6867 }, { 248,6867 }, { 249,6867 },
 { 250,6867 }, { 251,6867 }, { 252,6867 }, { 253,6867 }, { 254,6867 },
 { 255,6867 }, { 256,6867 }, {   0,   0 }, {   0,20268 }, {   1,6609 },
 {   2,6609 }, {   3,6609 }, {   4,6609 }, {   5,6609 }, {   6,6609 },
 {   7,6609 }, {   8,6609 }, {   9,6609 }, {  10,6867 }, {  11,6609 },
 {  12,6609 }, {  13,6609 }, {  14,6609 }, {  15,6609 }, {  16,6609 },
 {  17,6609 }, {  18,6609 }, {  19,6609 }, {  20,6609 }, {  21,6609 },
 {  22,6609 }, {  23,6609 }, {  24,6609 }, {  25,6609 }, {  26,6609 },

 {  27,6609 }, {  28,6609 }, {  29,6609 }, {  30,6609 }, {  31,6609 },
 {  32,6609 }, {  33,6609 }, {  34,6609 }, {  35,6609 }, {  36,6609 },
 {  37,6609 }, {  38,6609 }, {  39,2387 }, {  40,6609 }, {  41,6609 },
 {  42,6609 }, {  43,6609 }, {  44,6609 }, {  45,6609 }, {  46,6609 },
 {  47,6609 }, {  48,6609 }, {  49,6609 }, {  50,6609 }, {  51,6609 },
 {  52,6609 }, {  53,6609 }, {  54,6609 }, {  55,6609 }, {  56,6609 },
 {  57,6609 }, {  58,6609 }, {  59,6609 }, {  60,6609 }, {  61,6609 },
 {  62,6609 }, {  63,6609 }, {  64,6609 }, {  65,6609 }, {  66,6609 },
 {  67,6609 }, {  68,6609 }, {  69,6609 }, {  70,6609 }, {  71,6609 },
 {  72,6609 }, {  73,6609 }, {  74,6609 }, {  75,6609 }, {  76,6609 },

 {  77,6609 }, {  78,6609 }, {  79,6609 }, {  80,6609 }, {  81,6609 },
 {  82,6609 }, {  83,6609 }, {  84,6609 }, {  85,6609 }, {  86,6609 },
 {  87,6609 }, {  88,6609 }, {  89,6609 }, {  90,6609 }, {  91,6609 },
 {  92,7125 }, {  93,6609 }, {  94,6609 }, {  95,6609 }, {  96,6609 },
 {  97,6609 }, {  98,6609 }, {  99,6609 }, { 100,6609 }, { 101,6609 },
 { 102,6609 }, { 103,6609 }, { 104,6609 }, { 105,6609 }, { 106,6609 },
 { 107,6609 }, { 108,6609 }, { 109,6609 }, { 110,6609 }, { 111,6609 },
 { 112,6609 }, { 113,6609 }, { 114,6609 }, { 115,6609 }, { 116,6609 },
 { 117,6609 }, { 118,6609 }, { 119,6609 }, { 120,6609 }, { 121,6609 },
 { 122,6609 }, { 123,6609 }, { 124,6609 }, { 125,6609 }, { 126,6609 },

 { 127,6609 }, { 128,6609 }, { 129,6609 }, { 130,6609 }, { 131,6609 },
 { 132,6609 }, { 133,6609 }, { 134,6609 }, { 135,6609 }, { 136,6609 },
 { 137,6609 }, { 138,6609 }, { 139,6609 }, { 140,6609 }, { 141,6609 },
 { 142,6609 }, { 143,6609 }, { 144,6609 }, { 145,6609 }, { 146,6609 },
 { 147,6609 }, { 148,6609 }, { 149,6609 }, { 150,6609 }, { 151,6609 },
 { 152,6609 }, { 153,6609 }, { 154,6609 }, { 155,6609 }, { 156,6609 },
 { 157,6609 }, { 158,6609 }, { 159,6609 }, { 160,6609 }, { 161,6609 },
 { 162,6609 }, { 163,6609 }, { 164,6609 }, { 165,6609 }, { 166,6609 },
 { 167,6609 }, { 168,6609 }, { 169,6609 }, { 170,6609 }, { 171,6609 },
 { 172,6609 }, { 173,6609 }, { 174,6609 }, { 175,6609 }, { 176,6609 },

 { 177,6609 }, { 178,6609 }, { 179,6609 }, { 180,6609 }, { 181,6609 },
 { 182,6609 }, { 183,6609 }, { 184,6609 }, { 185,6609 }, { 186,6609 },
 { 187,6609 }, { 188,6609 }, { 189,6609 }, { 190,6609 }, { 191,6609 },
 { 192,6609 }, { 193,6609 }, { 194,6609 }, { 195,6609 }, { 196,6609 },
 { 197,6609 }, { 198,6609 }, { 199,6609 }, { 200,6609 }, { 201,6609 },
 { 202,6609 }, { 203,6609 }, { 204,6609 }, { 205,6609 }, { 206,6609 },
 { 207,6609 }, { 208,6609 }, { 209,6609 }, { 210,6609 }, { 211,6609 },
 { 212,6609 }, { 213,6609 }, { 214,6609 }, { 215,6609 }, { 216,6609 },
 { 217,6609 }, { 218,6609 }, { 219,6609 }, { 220,6609 }, { 221,6609 },
 { 222,6609 }, { 223,6609 }, { 224,6609 }, { 225,6609 }, { 226,6609 },

 { 227,6609 }, { 228,6609 }, { 229,6609 }, { 230,6609 }, { 231,6609 },
 { 232,6609 }, { 233,6609 }, { 234,6609 }, { 235,6609 }, { 236,6609 },
 { 237,6609 }, { 238,6609 }, { 239,6609 }, { 240,6609 }, { 241,6609 },
 { 242,6609 }, { 243,6609 }, { 244,6609 }, { 245,6609 }, { 246,6609 },
 { 247,6609 }, { 248,6609 }, { 249,6609 }, { 250,6609 }, { 251,6609 },
 { 252,6609 }, { 253,6609 }, { 254,6609 }, { 255,6609 }, { 256,6609 },
 {   0,   0 }, {   0,20010 }, {   1,7125 }, {   2,7125 }, {   3,7125 },
 {   4,7125 }, {   5,7125 }, {   6,7125 }, {   7,7125 }, {   8,7125 },
 {   9,7125 }, {  10,7383 }, {  11,7125 }, {  12,7125 }, {  13,7125 },
 {  14,7125 }, {  15,7125 }, {  16,7125 }, {  17,7125 }, {  18,7125 },

 {  19,7125 }, {  20,7125 }, {  21,7125 }, {  22,7125 }, {  23,7125 },
 {  24,7125 }, {  25,7125 }, {  26,7125 }, {  27,7125 }, {  28,7125 },
 {  29,7125 }, {  30,7125 }, {  31,7125 }, {  32,7125 }, {  33,7125 },
 {  34,7125 }, {  35,7125 }, {  36,7641 }, {  37,7125 }, {  38,7125 },
 {  39,7125 }, {  40,7125 }, {  41,7125 }, {  42,7125 }, {  43,7125 },
 {  44,7125 }, {  45,7125 }, {  46,7125 }, {  47,7125 }, {  48,7125 },
 {  49,7125 }, {  50,7125 }, {  51,7125 }, {  52,7125 }, {  53,7125 },
 {  54,7125 }, {  55,7125 }, {  56,7125 }, {  57,7125 }, {  58,7125 },
 {  59,7125 }, {  60,7125 }, {  61,7125 }, {  62,7125 }, {  63,7125 },
 {  64,7125 }, {  65,7125 }, {  66,7125 }, {  67,7125 }, {  68,7125 },

 {  69,7125 }, {  70,7125 }, {  71,7125 }, {  72,7125 }, {  73,7125 },
 {  74,7125 }, {  75,7125 }, {  76,7125 }, {  77,7125 }, {  78,7125 },
 {  79,7125 }, {  80,7125 }, {  81,7125 }, {  82,7125 }, {  83,7125 },
 {  84,7125 }, {  85,7125 }, {  86,7125 }, {  87,7125 }, {  88,7125 },
 {  89,7125 }, {  90,7125 }, {  91,7125 }, {  92,7125 }, {  93,7125 },
 {  94,7125 }, {  95,7125 }, {  96,7125 }, {  97,7125 }, {  98,7125 },
 {  99,7125 }, { 100,7125 }, { 101,7125 }, { 102,7125 }, { 103,7125 },
 { 104,7125 }, { 105,7125 }, { 106,7125 }, { 107,7125 }, { 108,7125 },
 { 109,7125 }, { 110,7125 }, { 111,7125 }, { 112,7125 }, { 113,7125 },
 { 114,7125 }, { 115,7125 }, { 116,7125 }, { 117,7125 }, { 118,7125 },

 { 119,7125 }, { 120,7125 }, { 121,7125 }, { 122,7125 }, { 123,7125 },
 { 124,7125 }, { 125,7125 }, { 126,7125 }, { 127,7125 }, { 128,7125 },
 { 129,7125 }, { 130,7125 }, { 131,7125 }, { 132,7125 }, { 133,7125 },
 { 134,7125 }, { 135,7125 }, { 136,7125 }, { 137,7125 }, { 138,7125 },
 { 139,7125 }, { 140,7125 }, { 141,7125 }, { 142,7125 }, { 143,7125 },
 { 144,7125 }, { 145,7125 }, { 146,7125 }, { 147,7125 }, { 148,7125 },
 { 149,7125 }, { 150,7125 }, { 151,7125 }, { 152,7125 }, { 153,7125 },
 { 154,7125 }, { 155,7125 }, { 156,7125 }, { 157,7125 }, { 158,7125 },
 { 159,7125 }, { 160,7125 }, { 161,7125 }, { 162,7125 }, { 163,7125 },
 { 164,7125 }, { 165,7125 }, { 166,7125 }, { 167,7125 }, { 168,7125 },

 { 169,7125 }, { 170,7125 }, { 171,7125 }, { 172,7125 }, { 173,7125 },
 { 174,7125 }, { 175,7125 }, { 176,7125 }, { 177,7125 }, { 178,7125 },
 { 179,7125 }, { 180,7125 }, { 181,7125 }, { 182,7125 }, { 183,7125 },
 { 184,7125 }, { 185,7125 }, { 186,7125 }, { 187,7125 }, { 188,7125 },
 { 189,7125 }, { 190,7125 }, { 191,7125 }, { 192,7125 }, { 193,7125 },
 { 194,7125 }, { 195,7125 }, { 196,7125 }, { 197,7125 }, { 198,7125 },
 { 199,7125 }, { 200,7125 }, { 201,7125 }, { 202,7125 }, { 203,7125 },
 { 204,7125 }, { 205,7125 }, { 206,7125 }, { 207,7125 }, { 208,7125 },
 { 209,7125 }, { 210,7125 }, { 211,7125 }, { 212,7125 }, { 213,7125 },
 { 214,7125 }, { 215,7125 }, { 216,7125 }, { 217,7125 }, { 218,7125 },

 { 219,7125 }, { 220,7125 }, { 221,7125 }, { 222,7125 }, { 223,7125 },
 { 224,7125 }, { 225,7125 }, { 226,7125 }, { 227,7125 }, { 228,7125 },
 { 229,7125 }, { 230,7125 }, { 231,7125 }, { 232,7125 }, { 233,7125 },
 { 234,7125 }, { 235,7125 }, { 236,7125 }, { 237,7125 }, { 238,7125 },
 { 239,7125 }, { 240,7125 }, { 241,7125 }, { 242,7125 }, { 243,7125 },
 { 244,7125 }, { 245,7125 }, { 246,7125 }, { 247,7125 }, { 248,7125 },
 { 249,7125 }, { 250,7125 }, { 251,7125 }, { 252,7125 }, { 253,7125 },
 { 254,7125 }, { 255,7125 }, { 256,7125 }, {   0,   0 }, {   0,19752 },
 {   1,6867 }, {   2,6867 }, {   3,6867 }, {   4,6867 }, {   5,6867 },
 {   6,6867 }, {   7,6867 }, {   8,6867 }, {   9,6867 }, {  10,7125 },

 {  11,6867 }, {  12,6867 }, {  13,6867 }, {  14,6867 }, {  15,6867 },
 {  16,6867 }, {  17,6867 }, {  18,6867 }, {  19,6867 }, {  20,6867 },
 {  21,6867 }, {  22,6867 }, {  23,6867 }, {  24,6867 }, {  25,6867 },
 {  26,6867 }, {  27,6867 }, {  28,6867 }, {  29,6867 }, {  30,6867 },
 {  31,6867 }, {  32,6867 }, {  33,6867 }, {  34,6867 }, {  35,6867 },
 {  36,7383 }, {  37,6867 }, {  38,6867 }, {  39,6867 }, {  40,6867 },
 {  41,6867 }, {  42,6867 }, {  43,6867 }, {  44,6867 }, {  45,6867 },
 {  46,6867 }, {  47,6867 }, {  48,6867 }, {  49,6867 }, {  50,6867 },
 {  51,6867 }, {  52,6867 }, {  53,6867 }, {  54,6867 }, {  55,6867 },
 {  56,6867 }, {  57,6867 }, {  58,6867 }, {  59,6867 }, {  60,6867 },

 {  61,6867 }, {  62,6867 }, {  63,6867 }, {  64,6867 }, {  65,6867 },
 {  66,6867 }, {  67,6867 }, {  68,6867 }, {  69,6867 }, {  70,6867 },
 {  71,6867 }, {  72,6867 }, {  73,6867 }, {  74,6867 }, {  75,6867 },
 {  76,6867 }, {  77,6867 }, {  78,6867 }, {  79,6867 }, {  80,6867 },
 {  81,6867 }, {  82,6867 }, {  83,6867 }, {  84,6867 }, {  85,6867 },
 {  86,6867 }, {  87,6867 }, {  88,6867 }, {  89,6867 }, {  90,6867 },
 {  91,6867 }, {  92,6867 }, {  93,6867 }, {  94,6867 }, {  95,6867 },
 {  96,6867 }, {  97,6867 }, {  98,6867 }, {  99,6867 }, { 100,6867 },
 { 101,6867 }, { 102,6867 }, { 103,6867 }, { 104,6867 }, { 105,6867 },
 { 106,6867 }, { 107,6867 }, { 108,6867 }, { 109,6867 }, { 110,6867 },

 { 111,6867 }, { 112,6867 }, { 113,6867 }, { 114,6867 }, { 115,6867 },
 { 116,6867 }, { 117,6867 }, { 118,6867 }, { 119,6867 }, { 120,6867 },
 { 121,6867 }, { 122,6867 }, { 123,6867 }, { 124,6867 }, { 125,6867 },
 { 126,6867 }, { 127,6867 }, { 128,6867 }, { 129,6867 }, { 130,6867 },
 { 131,6867 }, { 132,6867 }, { 133,6867 }, { 134,6867 }, { 135,6867 },
 { 136,6867 }, { 137,6867 }, { 138,6867 }, { 139,6867 }, { 140,6867 },
 { 141,6867 }, { 142,6867 }, { 143,6867 }, { 144,6867 }, { 145,6867 },
 { 146,6867 }, { 147,6867 }, { 148,6867 }, { 149,6867 }, { 150,6867 },
 { 151,6867 }, { 152,6867 }, { 153,6867 }, { 154,6867 }, { 155,6867 },
 { 156,6867 }, { 157,6867 }, { 158,6867 }, { 159,6867 }, { 160,6867 },

 { 161,6867 }, { 162,6867 }, { 163,6867 }, { 164,6867 }, { 165,6867 },
 { 166,6867 }, { 167,6867 }, { 168,6867 }, { 169,6867 }, { 170,6867 },
 { 171,6867 }, { 172,6867 }, { 173,6867 }, { 174,6867 }, { 175,6867 },
 { 176,6867 }, { 177,6867 }, { 178,6867 }, { 179,6867 }, { 180,6867 },
 { 181,6867 }, { 182,6867 }, { 183,6867 }, { 184,6867 }, { 185,6867 },
 { 186,6867 }, { 187,6867 }, { 188,6867 }, { 189,6867 }, { 190,6867 },
 { 191,6867 }, { 192,6867 }, { 193,6867 }, { 194,6867 }, { 195,6867 },
 { 196,6867 }, { 197,6867 }, { 198,6867 }, { 199,6867 }, { 200,6867 },
 { 201,6867 }, { 202,6867 }, { 203,6867 }, { 204,6867 }, { 205,6867 },
 { 206,6867 }, { 207,6867 }, { 208,6867 }, { 209,6867 }, { 210,6867 },

 { 211,6867 }, { 212,6867 }, { 213,6867 }, { 214,6867 }, { 215,6867 },
 { 216,6867 }, { 217,6867 }, { 218,6867 }, { 219,6867 }, { 220,6867 },
 { 221,6867 }, { 222,6867 }, { 223,6867 }, { 224,6867 }, { 225,6867 },
 { 226,6867 }, { 227,6867 }, { 228,6867 }, { 229,6867 }, { 230,6867 },
 { 231,6867 }, { 232,6867 }, { 233,6867 }, { 234,6867 }, { 235,6867 },
 { 236,6867 }, { 237,6867 }, { 238,6867 }, { 239,6867 }, { 240,6867 },
 { 241,6867 }, { 242,6867 }, { 243,6867 }, { 244,6867 }, { 245,6867 },
 { 246,6867 }, { 247,6867 }, { 248,6867 }, { 249,6867 }, { 250,6867 },
 { 251,6867 }, { 252,6867 }, { 253,6867 }, { 254,6867 }, { 255,6867 },
 { 256,6867 }, {   0,   0 }, {   0,19494 }, {   1,4993 }, {   2,4993 },

 {   3,4993 }, {   4,4993 }, {   5,4993 }, {   6,4993 }, {   7,4993 },
 {   8,4993 }, {   9,4993 }, {  10,4993 }, {  11,4993 }, {  12,4993 },
 {  13,4993 }, {  14,4993 }, {  15,4993 }, {  16,4993 }, {  17,4993 },
 {  18,4993 }, {  19,4993 }, {  20,4993 }, {  21,4993 }, {  22,4993 },
 {  23,4993 }, {  24,4993 }, {  25,4993 }, {  26,4993 }, {  27,4993 },
 {  28,4993 }, {  29,4993 }, {  30,4993 }, {  31,4993 }, {  32,4993 },
 {  33,4993 }, {  34,1615 }, {  35,4993 }, {  36,4993 }, {  37,4993 },
 {  38,4993 }, {  39,4993 }, {  40,4993 }, {  41,4993 }, {  42,4993 },
 {  43,4993 }, {  44,4993 }, {  45,4993 }, {  46,4993 }, {  47,4993 },
 {  48,4993 }, {  49,4993 }, {  50,4993 }, {  51,4993 }, {  52,4993 },

 {  53,4993 }, {  54,4993 }, {  55,4993 }, {  56,4993 }, {  57,4993 },
 {  58,4993 }, {  59,4993 }, {  60,4993 }, {  61,4993 }, {  62,4993 },
 {  63,4993 }, {  64,4993 }, {  65,4993 }, {  66,4993 }, {  67,4993 },
 {  68,4993 }, {  69,4993 }, {  70,4993 }, {  71,4993 }, {  72,4993 },
 {  73,4993 }, {  74,4993 }, {  75,4993 }, {  76,4993 }, {  77,4993 },
 {  78,4993 }, {  79,4993 }, {  80,4993 }, {  81,4993 }, {  82,4993 },
 {  83,4993 }, {  84,4993 }, {  85,4993 }, {  86,4993 }, {  87,4993 },
 {  88,4993 }, {  89,4993 }, {  90,4993 }, {  91,4993 }, {  92,4993 },
 {  93,4993 }, {  94,4993 }, {  95,4993 }, {  96,4993 }, {  97,4993 },
 {  98,4993 }, {  99,4993 }, { 100,4993 }, { 101,4993 }, { 102,4993 },

 { 103,4993 }, { 104,4993 }, { 105,4993 }, { 106,4993 }, { 107,4993 },
 { 108,4993 }, { 109,4993 }, { 110,4993 }, { 111,4993 }, { 112,4993 },
 { 113,4993 }, { 114,4993 }, { 115,4993 }, { 116,4993 }, { 117,4993 },
 { 118,4993 }, { 119,4993 }, { 120,4993 }, { 121,4993 }, { 122,4993 },
 { 123,4993 }, { 124,4993 }, { 125,4993 }, { 126,4993 }, { 127,4993 },
 { 128,4993 }, { 129,4993 }, { 130,4993 }, { 131,4993 }, { 132,4993 },
 { 133,4993 }, { 134,4993 }, { 135,4993 }, { 136,4993 }, { 137,4993 },
 { 138,4993 }, { 139,4993 }, { 140,4993 }, { 141,4993 }, { 142,4993 },
 { 143,4993 }, { 144,4993 }, { 145,4993 }, { 146,4993 }, { 147,4993 },
 { 148,4993 }, { 149,4993 }, { 150,4993 }, { 151,4993 }, { 152,4993 },

 { 153,4993 }, { 154,4993 }, { 155,4993 }, { 156,4993 }, { 157,4993 },
 { 158,4993 }, { 159,4993 }, { 160,4993 }, { 161,4993 }, { 162,4993 },
 { 163,4993 }, { 164,4993 }, { 165,4993 }, { 166,4993 }, { 167,4993 },
 { 168,4993 }, { 169,4993 }, { 170,4993 }, { 171,4993 }, { 172,4993 },
 { 173,4993 }, { 174,4993 }, { 175,4993 }, { 176,4993 }, { 177,4993 },
 { 178,4993 }, { 179,4993 }, { 180,4993 }, { 181,4993 }, { 182,4993 },
 { 183,4993 }, { 184,4993 }, { 185,4993 }, { 186,4993 }, { 187,4993 },
 { 188,4993 }, { 189,4993 }, { 190,4993 }, { 191,4993 }, { 192,4993 },
 { 193,4993 }, { 194,4993 }, { 195,4993 }, { 196,4993 }, { 197,4993 },
 { 198,4993 }, { 199,4993 }, { 200,4993 }, { 201,4993 }, { 202,4993 },

 { 203,4993 }, { 204,4993 }, { 205,4993 }, { 206,4993 }, { 207,4993 },
 { 208,4993 }, { 209,4993 }, { 210,4993 }, { 211,4993 }, { 212,4993 },
 { 213,4993 }, { 214,4993 }, { 215,4993 }, { 216,4993 }, { 217,4993 },
 { 218,4993 }, { 219,4993 }, { 220,4993 }, { 221,4993 }, { 222,4993 },
 { 223,4993 }, { 224,4993 }, { 225,4993 }, { 226,4993 }, { 227,4993 },
 { 228,4993 }, { 229,4993 }, { 230,4993 }, { 231,4993 }, { 232,4993 },
 { 233,4993 }, { 234,4993 }, { 235,4993 }, { 236,4993 }, { 237,4993 },
 { 238,4993 }, { 239,4993 }, { 240,4993 }, { 241,4993 }, { 242,4993 },
 { 243,4993 }, { 244,4993 }, { 245,4993 }, { 246,4993 }, { 247,4993 },
 { 248,4993 }, { 249,4993 }, { 250,4993 }, { 251,4993 }, { 252,4993 },

 { 253,4993 }, { 254,4993 }, { 255,4993 }, { 256,4993 }, {   0,   0 },
 {   0,19236 }, {   1,4735 }, {   2,4735 }, {   3,4735 }, {   4,4735 },
 {   5,4735 }, {   6,4735 }, {   7,4735 }, {   8,4735 }, {   9,4735 },
 {  10,4735 }, {  11,4735 }, {  12,4735 }, {  13,4735 }, {  14,4735 },
 {  15,4735 }, {  16,4735 }, {  17,4735 }, {  18,4735 }, {  19,4735 },
 {  20,4735 }, {  21,4735 }, {  22,4735 }, {  23,4735 }, {  24,4735 },
 {  25,4735 }, {  26,4735 }, {  27,4735 }, {  28,4735 }, {  29,4735 },
 {  30,4735 }, {  31,4735 }, {  32,4735 }, {  33,4735 }, {  34,1357 },
 {  35,4735 }, {  36,4735 }, {  37,4735 }, {  38,4735 }, {  39,4735 },
 {  40,4735 }, {  41,4735 }, {  42,4735 }, {  43,4735 }, {  44,4735 },

 {  45,4735 }, {  46,4735 }, {  47,4735 }, {  48,4735 }, {  49,4735 },
 {  50,4735 }, {  51,4735 }, {  52,4735 }, {  53,4735 }, {  54,4735 },
 {  55,4735 }, {  56,4735 }, {  57,4735 }, {  58,4735 }, {  59,4735 },
 {  60,4735 }, {  61,4735 }, {  62,4735 }, {  63,4735 }, {  64,4735 },
 {  65,4735 }, {  66,4735 }, {  67,4735 }, {  68,4735 }, {  69,4735 },
 {  70,4735 }, {  71,4735 }, {  72,4735 }, {  73,4735 }, {  74,4735 },
 {  75,4735 }, {  76,4735 }, {  77,4735 }, {  78,4735 }, {  79,4735 },
 {  80,4735 }, {  81,4735 }, {  82,4735 }, {  83,4735 }, {  84,4735 },
 {  85,4735 }, {  86,4735 }, {  87,4735 }, {  88,4735 }, {  89,4735 },
 {  90,4735 }, {  91,4735 }, {  92,4735 }, {  93,4735 }, {  94,4735 },

 {  95,4735 }, {  96,4735 }, {  97,4735 }, {  98,4735 }, {  99,4735 },
 { 100,4735 }, { 101,4735 }, { 102,4735 }, { 103,4735 }, { 104,4735 },
 { 105,4735 }, { 106,4735 }, { 107,4735 }, { 108,4735 }, { 109,4735 },
 { 110,4735 }, { 111,4735 }, { 112,4735 }, { 113,4735 }, { 114,4735 },
 { 115,4735 }, { 116,4735 }, { 117,4735 }, { 118,4735 }, { 119,4735 },
 { 120,4735 }, { 121,4735 }, { 122,4735 }, { 123,4735 }, { 124,4735 },
 { 125,4735 }, { 126,4735 }, { 127,4735 }, { 128,4735 }, { 129,4735 },
 { 130,4735 }, { 131,4735 }, { 132,4735 }, { 133,4735 }, { 134,4735 },
 { 135,4735 }, { 136,4735 }, { 137,4735 }, { 138,4735 }, { 139,4735 },
 { 140,4735 }, { 141,4735 }, { 142,4735 }, { 143,4735 }, { 144,4735 },

 { 145,4735 }, { 146,4735 }, { 147,4735 }, { 148,4735 }, { 149,4735 },
 { 150,4735 }, { 151,4735 }, { 152,4735 }, { 153,4735 }, { 154,4735 },
 { 155,4735 }, { 156,4735 }, { 157,4735 }, { 158,4735 }, { 159,4735 },
 { 160,4735 }, { 161,4735 }, { 162,4735 }, { 163,4735 }, { 164,4735 },
 { 165,4735 }, { 166,4735 }, { 167,4735 }, { 168,4735 }, { 169,4735 },
 { 170,4735 }, { 171,4735 }, { 172,4735 }, { 173,4735 }, { 174,4735 },
 { 175,4735 }, { 176,4735 }, { 177,4735 }, { 178,4735 }, { 179,4735 },
 { 180,4735 }, { 181,4735 }, { 182,4735 }, { 183,4735 }, { 184,4735 },
 { 185,4735 }, { 186,4735 }, { 187,4735 }, { 188,4735 }, { 189,4735 },
 { 190,4735 }, { 191,4735 }, { 192,4735 }, { 193,4735 }, { 194,4735 },

 { 195,4735 }, { 196,4735 }, { 197,4735 }, { 198,4735 }, { 199,4735 },
 { 200,4735 }, { 201,4735 }, { 202,4735 }, { 203,4735 }, { 204,4735 },
 { 205,4735 }, { 206,4735 }, { 207,4735 }, { 208,4735 }, { 209,4735 },
 { 210,4735 }, { 211,4735 }, { 212,4735 }, { 213,4735 }, { 214,4735 },
 { 215,4735 }, { 216,4735 }, { 217,4735 }, { 218,4735 }, { 219,4735 },
 { 220,4735 }, { 221,4735 }, { 222,4735 }, { 223,4735 }, { 224,4735 },
 { 225,4735 }, { 226,4735 }, { 227,4735 }, { 228,4735 }, { 229,4735 },
 { 230,4735 }, { 231,4735 }, { 232,4735 }, { 233,4735 }, { 234,4735 },
 { 235,4735 }, { 236,4735 }, { 237,4735 }, { 238,4735 }, { 239,4735 },
 { 240,4735 }, { 241,4735 }, { 242,4735 }, { 243,4735 }, { 244,4735 },

 { 245,4735 }, { 246,4735 }, { 247,4735 }, { 248,4735 }, { 249,4735 },
 { 250,4735 }, { 251,4735 }, { 252,4735 }, { 253,4735 }, { 254,4735 },
 { 255,4735 }, { 256,4735 }, {   0,   0 }, {   0,18978 }, {   1,4993 },
 {   2,4993 }, {   3,4993 }, {   4,4993 }, {   5,4993 }, {   6,4993 },
 {   7,4993 }, {   8,4993 }, {   9,4993 }, {  10,4993 }, {  11,4993 },
 {  12,4993 }, {  13,4993 }, {  14,4993 }, {  15,4993 }, {  16,4993 },
 {  17,4993 }, {  18,4993 }, {  19,4993 }, {  20,4993 }, {  21,4993 },
 {  22,4993 }, {  23,4993 }, {  24,4993 }, {  25,4993 }, {  26,4993 },
 {  27,4993 }, {  28,4993 }, {  29,4993 }, {  30,4993 }, {  31,4993 },
 {  32,4993 }, {  33,4993 }, {  34,4993 }, {  35,4993 }, {  36,4993 },

 {  37,4993 }, {  38,4993 }, {  39,1090 }, {  40,4993 }, {  41,4993 },
 {  42,4993 }, {  43,4993 }, {  44,4993 }, {  45,4993 }, {  46,4993 },
 {  47,4993 }, {  48,4993 }, {  49,4993 }, {  50,4993 }, {  51,4993 },
 {  52,4993 }, {  53,4993 }, {  54,4993 }, {  55,4993 }, {  56,4993 },
 {  57,4993 }, {  58,4993 }, {  59,4993 }, {  60,4993 }, {  61,4993 },
 {  62,4993 }, {  63,4993 }, {  64,4993 }, {  65,4993 }, {  66,4993 },
 {  67,4993 }, {  68,4993 }, {  69,4993 }, {  70,4993 }, {  71,4993 },
 {  72,4993 }, {  73,4993 }, {  74,4993 }, {  75,4993 }, {  76,4993 },
 {  77,4993 }, {  78,4993 }, {  79,4993 }, {  80,4993 }, {  81,4993 },
 {  82,4993 }, {  83,4993 }, {  84,4993 }, {  85,4993 }, {  86,4993 },

 {  87,4993 }, {  88,4993 }, {  89,4993 }, {  90,4993 }, {  91,4993 },
 {  92,4993 }, {  93,4993 }, {  94,4993 }, {  95,4993 }, {  96,4993 },
 {  97,4993 }, {  98,4993 }, {  99,4993 }, { 100,4993 }, { 101,4993 },
 { 102,4993 }, { 103,4993 }, { 104,4993 }, { 105,4993 }, { 106,4993 },
 { 107,4993 }, { 108,4993 }, { 109,4993 }, { 110,4993 }, { 111,4993 },
 { 112,4993 }, { 113,4993 }, { 114,4993 }, { 115,4993 }, { 116,4993 },
 { 117,4993 }, { 118,4993 }, { 119,4993 }, { 120,4993 }, { 121,4993 },
 { 122,4993 }, { 123,4993 }, { 124,4993 }, { 125,4993 }, { 126,4993 },
 { 127,4993 }, { 128,4993 }, { 129,4993 }, { 130,4993 }, { 131,4993 },
 { 132,4993 }, { 133,4993 }, { 134,4993 }, { 135,4993 }, { 136,4993 },

 { 137,4993 }, { 138,4993 }, { 139,4993 }, { 140,4993 }, { 141,4993 },
 { 142,4993 }, { 143,4993 }, { 144,4993 }, { 145,4993 }, { 146,4993 },
 { 147,4993 }, { 148,4993 }, { 149,4993 }, { 150,4993 }, { 151,4993 },
 { 152,4993 }, { 153,4993 }, { 154,4993 }, { 155,4993 }, { 156,4993 },
 { 157,4993 }, { 158,4993 }, { 159,4993 }, { 160,4993 }, { 161,4993 },
 { 162,4993 }, { 163,4993 }, { 164,4993 }, { 165,4993 }, { 166,4993 },
 { 167,4993 }, { 168,4993 }, { 169,4993 }, { 170,4993 }, { 171,4993 },
 { 172,4993 }, { 173,4993 }, { 174,4993 }, { 175,4993 }, { 176,4993 },
 { 177,4993 }, { 178,4993 }, { 179,4993 }, { 180,4993 }, { 181,4993 },
 { 182,4993 }, { 183,4993 }, { 184,4993 }, { 185,4993 }, { 186,4993 },

 { 187,4993 }, { 188,4993 }, { 189,4993 }, { 190,4993 }, { 191,4993 },
 { 192,4993 }, { 193,4993 }, { 194,4993 }, { 195,4993 }, { 196,4993 },
 { 197,4993 }, { 198,4993 }, { 199,4993 }, { 200,4993 }, { 201,4993 },
 { 202,4993 }, { 203,4993 }, { 204,4993 }, { 205,4993 }, { 206,4993 },
 { 207,4993 }, { 208,4993 }, { 209,4993 }, { 210,4993 }, { 211,4993 },
 { 212,4993 }, { 213,4993 }, { 214,4993 }, { 215,4993 }, { 216,4993 },
 { 217,4993 }, { 218,4993 }, { 219,4993 }, { 220,4993 }, { 221,4993 },
 { 222,4993 }, { 223,4993 }, { 224,4993 }, { 225,4993 }, { 226,4993 },
 { 227,4993 }, { 228,4993 }, { 229,4993 }, { 230,4993 }, { 231,4993 },
 { 232,4993 }, { 233,4993 }, { 234,4993 }, { 235,4993 }, { 236,4993 },

 { 237,4993 }, { 238,4993 }, { 239,4993 }, { 240,4993 }, { 241,4993 },
 { 242,4993 }, { 243,4993 }, { 244,4993 }, { 245,4993 }, { 246,4993 },
 { 247,4993 }, { 248,4993 }, { 249,4993 }, { 250,4993 }, { 251,4993 },
 { 252,4993 }, { 253,4993 }, { 254,4993 }, { 255,4993 }, { 256,4993 },
 {   0,   0 }, {   0,18720 }, {   1,4735 }, {   2,4735 }, {   3,4735 },
 {   4,4735 }, {   5,4735 }, {   6,4735 }, {   7,4735 }, {   8,4735 },
 {   9,4735 }, {  10,4735 }, {  11,4735 }, {  12,4735 }, {  13,4735 },
 {  14,4735 }, {  15,4735 }, {  16,4735 }, {  17,4735 }, {  18,4735 },
 {  19,4735 }, {  20,4735 }, {  21,4735 }, {  22,4735 }, {  23,4735 },
 {  24,4735 }, {  25,4735 }, {  26,4735 }, {  27,4735 }, {  28,4735 },

 {  29,4735 }, {  30,4735 }, {  31,4735 }, {  32,4735 }, {  33,4735 },
 {  34,4735 }, {  35,4735 }, {  36,4735 }, {  37,4735 }, {  38,4735 },
 {  39, 832 }, {  40,4735 }, {  41,4735 }, {  42,4735 }, {  43,4735 },
 {  44,4735 }, {  45,4735 }, {  46,4735 }, {  47,4735 }, {  48,4735 },
 {  49,4735 }, {  50,4735 }, {  51,4735 }, {  52,4735 }, {  53,4735 },
 {  54,4735 }, {  55,4735 }, {  56,4735 }, {  57,4735 }, {  58,4735 },
 {  59,4735 }, {  60,4735 }, {  61,4735 }, {  62,4735 }, {  63,4735 },
 {  64,4735 }, {  65,4735 }, {  66,4735 }, {  67,4735 }, {  68,4735 },
 {  69,4735 }, {  70,4735 }, {  71,4735 }, {  72,4735 }, {  73,4735 },
 {  74,4735 }, {  75,4735 }, {  76,4735 }, {  77,4735 }, {  78,4735 },

 {  79,4735 }, {  80,4735 }, {  81,4735 }, {  82,4735 }, {  83,4735 },
 {  84,4735 }, {  85,4735 }, {  86,4735 }, {  87,4735 }, {  88,4735 },
 {  89,4735 }, {  90,4735 }, {  91,4735 }, {  92,4735 }, {  93,4735 },
 {  94,4735 }, {  95,4735 }, {  96,4735 }, {  97,4735 }, {  98,4735 },
 {  99,4735 }, { 100,4735 }, { 101,4735 }, { 102,4735 }, { 103,4735 },
 { 104,4735 }, { 105,4735 }, { 106,4735 }, { 107,4735 }, { 108,4735 },
 { 109,4735 }, { 110,4735 }, { 111,4735 }, { 112,4735 }, { 113,4735 },
 { 114,4735 }, { 115,4735 }, { 116,4735 }, { 117,4735 }, { 118,4735 },
 { 119,4735 }, { 120,4735 }, { 121,4735 }, { 122,4735 }, { 123,4735 },
 { 124,4735 }, { 125,4735 }, { 126,4735 }, { 127,4735 }, { 128,4735 },

 { 129,4735 }, { 130,4735 }, { 131,4735 }, { 132,4735 }, { 133,4735 },
 { 134,4735 }, { 135,4735 }, { 136,4735 }, { 137,4735 }, { 138,4735 },
 { 139,4735 }, { 140,4735 }, { 141,4735 }, { 142,4735 }, { 143,4735 },
 { 144,4735 }, { 145,4735 }, { 146,4735 }, { 147,4735 }, { 148,4735 },
 { 149,4735 }, { 150,4735 }, { 151,4735 }, { 152,4735 }, { 153,4735 },
 { 154,4735 }, { 155,4735 }, { 156,4735 }, { 157,4735 }, { 158,4735 },
 { 159,4735 }, { 160,4735 }, { 161,4735 }, { 162,4735 }, { 163,4735 },
 { 164,4735 }, { 165,4735 }, { 166,4735 }, { 167,4735 }, { 168,4735 },
 { 169,4735 }, { 170,4735 }, { 171,4735 }, { 172,4735 }, { 173,4735 },
 { 174,4735 }, { 175,4735 }, { 176,4735 }, { 177,4735 }, { 178,4735 },

 { 179,4735 }, { 180,4735 }, { 181,4735 }, { 182,4735 }, { 183,4735 },
 { 184,4735 }, { 185,4735 }, { 186,4735 }, { 187,4735 }, { 188,4735 },
 { 189,4735 }, { 190,4735 }, { 191,4735 }, { 192,4735 }, { 193,4735 },
 { 194,4735 }, { 195,4735 }, { 196,4735 }, { 197,4735 }, { 198,4735 },
 { 199,4735 }, { 200,4735 }, { 201,4735 }, { 202,4735 }, { 203,4735 },
 { 204,4735 }, { 205,4735 }, { 206,4735 }, { 207,4735 }, { 208,4735 },
 { 209,4735 }, { 210,4735 }, { 211,4735 }, { 212,4735 }, { 213,4735 },
 { 214,4735 }, { 215,4735 }, { 216,4735 }, { 217,4735 }, { 218,4735 },
 { 219,4735 }, { 220,4735 }, { 221,4735 }, { 222,4735 }, { 223,4735 },
 { 224,4735 }, { 225,4735 }, { 226,4735 }, { 227,4735 }, { 228,4735 },

 { 229,4735 }, { 230,4735 }, { 231,4735 }, { 232,4735 }, { 233,4735 },
 { 234,4735 }, { 235,4735 }, { 236,4735 }, { 237,4735 }, { 238,4735 },
 { 239,4735 }, { 240,4735 }, { 241,4735 }, { 242,4735 }, { 243,4735 },
 { 244,4735 }, { 245,4735 }, { 246,4735 }, { 247,4735 }, { 248,4735 },
 { 249,4735 }, { 250,4735 }, { 251,4735 }, { 252,4735 }, { 253,4735 },
 { 254,4735 }, { 255,4735 }, { 256,4735 }, {   0,   0 }, {   0,18462 },
 {   1, 593 }, {   2, 593 }, {   3, 593 }, {   4, 593 }, {   5, 593 },
 {   6, 593 }, {   7, 593 }, {   8, 593 }, {   9, 593 }, {  10, 597 },
 {  11, 593 }, {  12, 593 }, {  13, 593 }, {  14, 593 }, {  15, 593 },
 {  16, 593 }, {  17, 593 }, {  18, 593 }, {  19, 593 }, {  20, 593 },

 {  21, 593 }, {  22, 593 }, {  23, 593 }, {  24, 593 }, {  25, 593 },
 {  26, 593 }, {  27, 593 }, {  28, 593 }, {  29, 593 }, {  30, 593 },
 {  31, 593 }, {  32, 593 }, {  33, 593 }, {  34, 593 }, {  35, 593 },
 {  36, 593 }, {  37, 593 }, {  38, 593 }, {  39, 593 }, {  40, 593 },
 {  41, 593 }, {  42, 593 }, {  43, 593 }, {  44, 593 }, {  45, 593 },
 {  46, 593 }, {  47, 593 }, {  48, 593 }, {  49, 593 }, {  50, 593 },
 {  51, 593 }, {  52, 593 }, {  53, 593 }, {  54, 593 }, {  55, 593 },
 {  56, 593 }, {  57, 593 }, {  58, 593 }, {  59, 593 }, {  60, 593 },
 {  61, 593 }, {  62, 593 }, {  63, 593 }, {  64, 593 }, {  65, 593 },
 {  66, 593 }, {  67, 593 }, {  68, 593 }, {  69, 593 }, {  70, 593 },

 {  71, 593 }, {  72, 593 }, {  73, 593 }, {  74, 593 }, {  75, 593 },
 {  76, 593 }, {  77, 593 }, {  78, 593 }, {  79, 593 }, {  80, 593 },
 {  81, 593 }, {  82, 593 }, {  83, 593 }, {  84, 593 }, {  85, 593 },
 {  86, 593 }, {  87, 593 }, {  88, 593 }, {  89, 593 }, {  90, 593 },
 {  91, 593 }, {  92, 637 }, {  93, 593 }, {  94, 593 }, {  95, 593 },
 {  96, 593 }, {  97, 593 }, {  98, 593 }, {  99, 593 }, { 100, 593 },
 { 101, 593 }, { 102, 593 }, { 103, 593 }, { 104, 593 }, { 105, 593 },
 { 106, 593 }, { 107, 593 }, { 108, 593 }, { 109, 593 }, { 110, 593 },
 { 111, 593 }, { 112, 593 }, { 113, 593 }, { 114, 593 }, { 115, 593 },
 { 116, 593 }, { 117, 593 }, { 118, 593 }, { 119, 593 }, { 120, 593 },

 { 121, 593 }, { 122, 593 }, { 123, 593 }, { 124, 593 }, { 125, 593 },
 { 126, 593 }, { 127, 593 }, { 128, 593 }, { 129, 593 }, { 130, 593 },
 { 131, 593 }, { 132, 593 }, { 133, 593 }, { 134, 593 }, { 135, 593 },
 { 136, 593 }, { 137, 593 }, { 138, 593 }, { 139, 593 }, { 140, 593 },
 { 141, 593 }, { 142, 593 }, { 143, 593 }, { 144, 593 }, { 145, 593 },
 { 146, 593 }, { 147, 593 }, { 148, 593 }, { 149, 593 }, { 150, 593 },
 { 151, 593 }, { 152, 593 }, { 153, 593 }, { 154, 593 }, { 155, 593 },
 { 156, 593 }, { 157, 593 }, { 158, 593 }, { 159, 593 }, { 160, 593 },
 { 161, 593 }, { 162, 593 }, { 163, 593 }, { 164, 593 }, { 165, 593 },
 { 166, 593 }, { 167, 593 }, { 168, 593 }, { 169, 593 }, { 170, 593 },

 { 171, 593 }, { 172, 593 }, { 173, 593 }, { 174, 593 }, { 175, 593 },
 { 176, 593 }, { 177, 593 }, { 178, 593 }, { 179, 593 }, { 180, 593 },
 { 181, 593 }, { 182, 593 }, { 183, 593 }, { 184, 593 }, { 185, 593 },
 { 186, 593 }, { 187, 593 }, { 188, 593 }, { 189, 593 }, { 190, 593 },
 { 191, 593 }, { 192, 593 }, { 193, 593 }, { 194, 593 }, { 195, 593 },
 { 196, 593 }, { 197, 593 }, { 198, 593 }, { 199, 593 }, { 200, 593 },
 { 201, 593 }, { 202, 593 }, { 203, 593 }, { 204, 593 }, { 205, 593 },
 { 206, 593 }, { 207, 593 }, { 208, 593 }, { 209, 593 }, { 210, 593 },
 { 211, 593 }, { 212, 593 }, { 213, 593 }, { 214, 593 }, { 215, 593 },
 { 216, 593 }, { 217, 593 }, { 218, 593 }, { 219, 593 }, { 220, 593 },

 { 221, 593 }, { 222, 593 }, { 223, 593 }, { 224, 593 }, { 225, 593 },
 { 226, 593 }, { 227, 593 }, { 228, 593 }, { 229, 593 }, { 230, 593 },
 { 231, 593 }, { 232, 593 }, { 233, 593 }, { 234, 593 }, { 235, 593 },
 { 236, 593 }, { 237, 593 }, { 238, 593 }, { 239, 593 }, { 240, 593 },
 { 241, 593 }, { 242, 593 }, { 243, 593 }, { 244, 593 }, { 245, 593 },
 { 246, 593 }, { 247, 593 }, { 248, 593 }, { 249, 593 }, { 250, 593 },
 { 251, 593 }, { 252, 593 }, { 253, 593 }, { 254, 593 }, { 255, 593 },
 { 256, 593 }, {   0,   0 }, {   0,18204 }, {   1, 335 }, {   2, 335 },
 {   3, 335 }, {   4, 335 }, {   5, 335 }, {   6, 335 }, {   7, 335 },
 {   8, 335 }, {   9, 335 }, {  10, 339 }, {  11, 335 }, {  12, 335 },

 {  13, 335 }, {  14, 335 }, {  15, 335 }, {  16, 335 }, {  17, 335 },
 {  18, 335 }, {  19, 335 }, {  20, 335 }, {  21, 335 }, {  22, 335 },
 {  23, 335 }, {  24, 335 }, {  25, 335 }, {  26, 335 }, {  27, 335 },
 {  28, 335 }, {  29, 335 }, {  30, 335 }, {  31, 335 }, {  32, 335 },
 {  33, 335 }, {  34, 335 }, {  35, 335 }, {  36, 335 }, {  37, 335 },
 {  38, 335 }, {  39, 335 }, {  40, 335 }, {  41, 335 }, {  42, 335 },
 {  43, 335 }, {  44, 335 }, {  45, 335 }, {  46, 335 }, {  47, 335 },
 {  48, 335 }, {  49, 335 }, {  50, 335 }, {  51, 335 }, {  52, 335 },
 {  53, 335 }, {  54, 335 }, {  55, 335 }, {  56, 335 }, {  57, 335 },
 {  58, 335 }, {  59, 335 }, {  60, 335 }, {  61, 335 }, {  62, 335 },

 {  63, 335 }, {  64, 335 }, {  65, 335 }, {  66, 335 }, {  67, 335 },
 {  68, 335 }, {  69, 335 }, {  70, 335 }, {  71, 335 }, {  72, 335 },
 {  73, 335 }, {  74, 335 }, {  75, 335 }, {  76, 335 }, {  77, 335 },
 {  78, 335 }, {  79, 335 }, {  80, 335 }, {  81, 335 }, {  82, 335 },
 {  83, 335 }, {  84, 335 }, {  85, 335 }, {  86, 335 }, {  87, 335 },
 {  88, 335 }, {  89, 335 }, {  90, 335 }, {  91, 335 }, {  92, 379 },
 {  93, 335 }, {  94, 335 }, {  95, 335 }, {  96, 335 }, {  97, 335 },
 {  98, 335 }, {  99, 335 }, { 100, 335 }, { 101, 335 }, { 102, 335 },
 { 103, 335 }, { 104, 335 }, { 105, 335 }, { 106, 335 }, { 107, 335 },
 { 108, 335 }, { 109, 335 }, { 110, 335 }, { 111, 335 }, { 112, 335 },

 { 113, 335 }, { 114, 335 }, { 115, 335 }, { 116, 335 }, { 117, 335 },
 { 118, 335 }, { 119, 335 }, { 120, 335 }, { 121, 335 }, { 122, 335 },
 { 123, 335 }, { 124, 335 }, { 125, 335 }, { 126, 335 }, { 127, 335 },
 { 128, 335 }, { 129, 335 }, { 130, 335 }, { 131, 335 }, { 132, 335 },
 { 133, 335 }, { 134, 335 }, { 135, 335 }, { 136, 335 }, { 137, 335 },
 { 138, 335 }, { 139, 335 }, { 140, 335 }, { 141, 335 }, { 142, 335 },
 { 143, 335 }, { 144, 335 }, { 145, 335 }, { 146, 335 }, { 147, 335 },
 { 148, 335 }, { 149, 335 }, { 150, 335 }, { 151, 335 }, { 152, 335 },
 { 153, 335 }, { 154, 335 }, { 155, 335 }, { 156, 335 }, { 157, 335 },
 { 158, 335 }, { 159, 335 }, { 160, 335 }, { 161, 335 }, { 162, 335 },

 { 163, 335 }, { 164, 335 }, { 165, 335 }, { 166, 335 }, { 167, 335 },
 { 168, 335 }, { 169, 335 }, { 170, 335 }, { 171, 335 }, { 172, 335 },
 { 173, 335 }, { 174, 335 }, { 175, 335 }, { 176, 335 }, { 177, 335 },
 { 178, 335 }, { 179, 335 }, { 180, 335 }, { 181, 335 }, { 182, 335 },
 { 183, 335 }, { 184, 335 }, { 185, 335 }, { 186, 335 }, { 187, 335 },
 { 188, 335 }, { 189, 335 }, { 190, 335 }, { 191, 335 }, { 192, 335 },
 { 193, 335 }, { 194, 335 }, { 195, 335 }, { 196, 335 }, { 197, 335 },
 { 198, 335 }, { 199, 335 }, { 200, 335 }, { 201, 335 }, { 202, 335 },
 { 203, 335 }, { 204, 335 }, { 205, 335 }, { 206, 335 }, { 207, 335 },
 { 208, 335 }, { 209, 335 }, { 210, 335 }, { 211, 335 }, { 212, 335 },

 { 213, 335 }, { 214, 335 }, { 215, 335 }, { 216, 335 }, { 217, 335 },
 { 218, 335 }, { 219, 335 }, { 220, 335 }, { 221, 335 }, { 222, 335 },
 { 223, 335 }, { 224, 335 }, { 225, 335 }, { 226, 335 }, { 227, 335 },
 { 228, 335 }, { 229, 335 }, { 230, 335 }, { 231, 335 }, { 232, 335 },
 { 233, 335 }, { 234, 335 }, { 235, 335 }, { 236, 335 }, { 237, 335 },
 { 238, 335 }, { 239, 335 }, { 240, 335 }, { 241, 335 }, { 242, 335 },
 { 243, 335 }, { 244, 335 }, { 245, 335 }, { 246, 335 }, { 247, 335 },
 { 248, 335 }, { 249, 335 }, { 250, 335 }, { 251, 335 }, { 252, 335 },
 { 253, 335 }, { 254, 335 }, { 255, 335 }, { 256, 335 }, {   0,  75 },
 {   0,17946 }, {   0,   1 }, {   0,17944 }, {   0,  38 }, {   0,17942 },

 {   0,   0 }, {   0,   1 }, {   0,17939 }, {   0,  54 }, {   0,17937 },
 {   0,   0 }, {   9,5577 }, {  10,5577 }, {   0,   0 }, {  12,5577 },
 {  13,5577 }, {   9,5572 }, {  10,5572 }, {   0,   0 }, {  12,5572 },
 {  13,5572 }, {   0,  13 }, {   0,17924 }, {   0,  53 }, {   0,17922 },
 {   0,   0 }, {   0,  53 }, {   0,17919 }, {   0,  16 }, {   0,17917 },
 {   0,   0 }, {   0,   6 }, {   0,17914 }, {   0,   0 }, {  32,5577 },
 {   0,   6 }, {   0,17910 }, {   0,   0 }, {   0,   0 }, {  32,5572 },
 {   0,  40 }, {   0,17905 }, {  33,5825 }, {   0,   0 }, {  35,5825 },
 {   0,   0 }, {  37,5825 }, {  38,5825 }, {   0,  54 }, {   0,17897 },
 {   0,   0 }, {  42,5825 }, {  43,5825 }, {   0,   0 }, {  45,5825 },

 {   0,   0 }, {  47,5825 }, {   0,  16 }, {   0,17888 }, {   0,  19 },
 {   0,17886 }, {   0,  18 }, {   0,17884 }, {   0,   0 }, {   0,  16 },
 {   0,17881 }, {   0,  41 }, {   0,17879 }, {   0,   0 }, {  60,5825 },
 {  61,5836 }, {  62,5825 }, {  63,5825 }, {  64,5825 }, {  42, 363 },
 {  34, 358 }, {   0,  25 }, {   0,17869 }, {  42,8520 }, {  47, 365 },
 {   0,  26 }, {   0,17865 }, {  33,5785 }, {   0,   0 }, {  35,5785 },
 {  58, 349 }, {  37,5785 }, {  38,5785 }, {  61, 351 }, {   0,   0 },
 {   0,   0 }, {  42,5785 }, {  43,5785 }, {   0,   0 }, {  45,5785 },
 {   0,   0 }, {  47,5785 }, {  39, 346 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  34, 332 }, {   0,   0 }, {  94,5825 }, {  39, 339 },

 {  96,5825 }, {   0,   0 }, {  45,9464 }, {   0,   0 }, {  60,5785 },
 {  61,5785 }, {  62,5785 }, {  63,5785 }, {  64,5785 }, {   0,  75 },
 {   0,17831 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  25 }, {   0,17825 }, {   0,  32 }, {   0,17823 }, {   0,  46 },
 {   0,17821 }, {   0,  68 }, {   0,17819 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,5825 }, {   0,   0 },
 { 126,5825 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,5785 }, {   0,   0 },
 {  96,5785 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,   8 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,5809 }, {  49,5809 },
 {  50,5809 }, {  51,5809 }, {  52,5809 }, {  53,5809 }, {  54,5809 },
 {  55,5809 }, {  56,5809 }, {  57,5809 }, { 124,5785 }, {   0,   0 },
 { 126,5785 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,6066 }, {  66,6066 }, {  67,6066 }, {  68,6066 }, {  69,6066 },
 {  70,6066 }, {  71,6066 }, {  72,6066 }, {  73,6066 }, {  74,6066 },
 {  75,6066 }, {  76,6066 }, {  77,6066 }, {  78,6066 }, {  79,6066 },
 {  80,6066 }, {  81,6066 }, {  82,6066 }, {  83,6066 }, {  84,6066 },
 {  85,6066 }, {  86,6066 }, {  87,6066 }, {  88,6066 }, {  89,6066 },

 {  90,6066 }, {  85,10609 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,6066 }, {   0,   0 }, {  97,6066 }, {  98,6066 }, {  99,6066 },
 { 100,6066 }, { 101,6066 }, { 102,6066 }, { 103,6066 }, { 104,6066 },
 { 105,6066 }, { 106,6066 }, { 107,6066 }, { 108,6066 }, { 109,6066 },
 { 110,6066 }, { 111,6066 }, { 112,6066 }, { 113,6066 }, { 114,6066 },
 { 115,6066 }, { 116,6066 }, { 117,6066 }, { 118,6066 }, { 119,6066 },
 { 120,6066 }, { 121,6066 }, { 122,6066 }, { 117,10632 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,6066 }, { 129,6066 },
 { 130,6066 }, { 131,6066 }, { 132,6066 }, { 133,6066 }, { 134,6066 },
 { 135,6066 }, { 136,6066 }, { 137,6066 }, { 138,6066 }, { 139,6066 },

 { 140,6066 }, { 141,6066 }, { 142,6066 }, { 143,6066 }, { 144,6066 },
 { 145,6066 }, { 146,6066 }, { 147,6066 }, { 148,6066 }, { 149,6066 },
 { 150,6066 }, { 151,6066 }, { 152,6066 }, { 153,6066 }, { 154,6066 },
 { 155,6066 }, { 156,6066 }, { 157,6066 }, { 158,6066 }, { 159,6066 },
 { 160,6066 }, { 161,6066 }, { 162,6066 }, { 163,6066 }, { 164,6066 },
 { 165,6066 }, { 166,6066 }, { 167,6066 }, { 168,6066 }, { 169,6066 },
 { 170,6066 }, { 171,6066 }, { 172,6066 }, { 173,6066 }, { 174,6066 },
 { 175,6066 }, { 176,6066 }, { 177,6066 }, { 178,6066 }, { 179,6066 },
 { 180,6066 }, { 181,6066 }, { 182,6066 }, { 183,6066 }, { 184,6066 },
 { 185,6066 }, { 186,6066 }, { 187,6066 }, { 188,6066 }, { 189,6066 },

 { 190,6066 }, { 191,6066 }, { 192,6066 }, { 193,6066 }, { 194,6066 },
 { 195,6066 }, { 196,6066 }, { 197,6066 }, { 198,6066 }, { 199,6066 },
 { 200,6066 }, { 201,6066 }, { 202,6066 }, { 203,6066 }, { 204,6066 },
 { 205,6066 }, { 206,6066 }, { 207,6066 }, { 208,6066 }, { 209,6066 },
 { 210,6066 }, { 211,6066 }, { 212,6066 }, { 213,6066 }, { 214,6066 },
 { 215,6066 }, { 216,6066 }, { 217,6066 }, { 218,6066 }, { 219,6066 },
 { 220,6066 }, { 221,6066 }, { 222,6066 }, { 223,6066 }, { 224,6066 },
 { 225,6066 }, { 226,6066 }, { 227,6066 }, { 228,6066 }, { 229,6066 },
 { 230,6066 }, { 231,6066 }, { 232,6066 }, { 233,6066 }, { 234,6066 },
 { 235,6066 }, { 236,6066 }, { 237,6066 }, { 238,6066 }, { 239,6066 },

 { 240,6066 }, { 241,6066 }, { 242,6066 }, { 243,6066 }, { 244,6066 },
 { 245,6066 }, { 246,6066 }, { 247,6066 }, { 248,6066 }, { 249,6066 },
 { 250,6066 }, { 251,6066 }, { 252,6066 }, { 253,6066 }, { 254,6066 },
 { 255,6066 }, {   0,  53 }, {   0,17574 }, {   0,  63 }, {   0,17572 },
 {   0,  45 }, {   0,17570 }, {   0,  47 }, {   0,17568 }, {   0,   8 },
 {   0,17566 }, {   0,   0 }, {   0,  53 }, {   0,17563 }, {   0,  14 },
 {   0,17561 }, {   0,  12 }, {   0,17559 }, {   0,   0 }, {   0,  44 },
 {   0,17556 }, {   0,  11 }, {   0,17554 }, {   0,   0 }, {   0,   7 },
 {   0,17551 }, {   0,   4 }, {   0,17549 }, {   0,  42 }, {   0,17547 },
 {   0,   0 }, {   0,  53 }, {   0,17544 }, {   0,  20 }, {   0,17542 },

 {  33,5462 }, {   0,   0 }, {  35,5462 }, {   0,   0 }, {  37,5462 },
 {  38,5462 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,5462 },
 {  43,5462 }, {  33,5451 }, {  45,5462 }, {  35,5451 }, {  47,5462 },
 {  37,5451 }, {  38,5451 }, {  48,11826 }, {  49,11826 }, {  34, 104 },
 {  42,5451 }, {  43,5451 }, {   0,   0 }, {  45,6055 }, {  39, 110 },
 {  47,5451 }, {   0,   0 }, {  60,5462 }, {  61,5462 }, {  62,5462 },
 {  63,5462 }, {  64,5462 }, {  42,   0 }, {   0,  18 }, {   0,17507 },
 {   0,  17 }, {   0,17505 }, {  47,   2 }, {  60,5451 }, {  61,5451 },
 {  62,5451 }, {  63,5451 }, {  64,5451 }, {  46,-277 }, {   0,   0 },
 {  48,6294 }, {  49,6294 }, {  50,6294 }, {  51,6294 }, {  52,6294 },

 {  53,6294 }, {  54,6294 }, {  55,6294 }, {  56,6294 }, {  57,6294 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,5462 }, {   0,   0 }, {  96,5462 }, {  95, 118 },
 {   0,   0 }, {   0,   0 }, {   0,  53 }, {   0,17473 }, {   0,   0 },
 {   0,  18 }, {   0,17470 }, {  94,5451 }, {   0,   0 }, {  96,5451 },
 {   0,  28 }, {   0,17465 }, {   0,  34 }, {   0,17463 }, {  45,9087 },
 {   0,  56 }, {   0,17460 }, {   0,  72 }, {   0,17458 }, {   0,  65 },
 {   0,17456 }, {   0,  63 }, {   0,17454 }, {   0,  39 }, {   0,17452 },
 {   0,   0 }, { 124,5462 }, {   0,   0 }, { 126,5462 }, {   0,  15 },
 {   0,17446 }, {   0,  71 }, {   0,17444 }, {   0,   0 }, {   0,  57 },

 {   0,17441 }, {  33,5361 }, { 124,5451 }, {  35,5361 }, { 126,5451 },
 {  37,5361 }, {  38,5361 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  42,6480 }, {  43,5361 }, {   0,   0 }, {  45,5361 }, {   0,   0 },
 {  47,5361 }, {  45,12923 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,5361 }, {  61,5361 },
 {  62,5361 }, {  63,5361 }, {  64,5361 }, {   0,   0 }, {   0,   0 },
 {  48,11708 }, {  49,11708 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  46,6480 }, {   0,   0 }, {  48,6737 }, {  49,6737 },

 {  50,6737 }, {  51,6737 }, {  52,6737 }, {  53,6737 }, {  54,6737 },
 {  55,6737 }, {  56,6737 }, {  57,6737 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,5361 }, {   0,   0 }, {  96,5361 },
 {  65,-378 }, {  66,-131 }, {  67,-378 }, {  68,-378 }, {  69,6994 },
 {  70,-378 }, {  71,-378 }, {  72,-378 }, {  73,-378 }, {  74,-378 },
 {  75,-378 }, {  76,-378 }, {  77,-378 }, {  78,-378 }, {  79,7004 },
 {  80,-378 }, {  81,-378 }, {  82,-378 }, {  83,-378 }, {  84,-378 },
 {  85,-378 }, {  86,-378 }, {  87,-378 }, {  88,7012 }, {  89,-378 },
 {  90,-378 }, {   0,   0 }, { 124,5361 }, {   0,   0 }, { 126,5361 },
 {  95,7035 }, {   0,   0 }, {  97,-378 }, {  98,-131 }, {  99,-378 },

 { 100,-378 }, { 101,6994 }, { 102,-378 }, { 103,-378 }, { 104,-378 },
 { 105,-378 }, { 106,-378 }, { 107,-378 }, { 108,-378 }, { 109,-378 },
 { 110,-378 }, { 111,7004 }, { 112,-378 }, { 113,-378 }, { 114,-378 },
 { 115,-378 }, { 116,-378 }, { 117,-378 }, { 118,-378 }, { 119,-378 },
 { 120,7012 }, { 121,-378 }, { 122,-378 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-378 }, { 129,-378 },
 { 130,-378 }, { 131,-378 }, { 132,-378 }, { 133,-378 }, { 134,-378 },
 { 135,-378 }, { 136,-378 }, { 137,-378 }, { 138,-378 }, { 139,-378 },
 { 140,-378 }, { 141,-378 }, { 142,-378 }, { 143,-378 }, { 144,-378 },
 { 145,-378 }, { 146,-378 }, { 147,-378 }, { 148,-378 }, { 149,-378 },

 { 150,-378 }, { 151,-378 }, { 152,-378 }, { 153,-378 }, { 154,-378 },
 { 155,-378 }, { 156,-378 }, { 157,-378 }, { 158,-378 }, { 159,-378 },
 { 160,-378 }, { 161,-378 }, { 162,-378 }, { 163,-378 }, { 164,-378 },
 { 165,-378 }, { 166,-378 }, { 167,-378 }, { 168,-378 }, { 169,-378 },
 { 170,-378 }, { 171,-378 }, { 172,-378 }, { 173,-378 }, { 174,-378 },
 { 175,-378 }, { 176,-378 }, { 177,-378 }, { 178,-378 }, { 179,-378 },
 { 180,-378 }, { 181,-378 }, { 182,-378 }, { 183,-378 }, { 184,-378 },
 { 185,-378 }, { 186,-378 }, { 187,-378 }, { 188,-378 }, { 189,-378 },
 { 190,-378 }, { 191,-378 }, { 192,-378 }, { 193,-378 }, { 194,-378 },
 { 195,-378 }, { 196,-378 }, { 197,-378 }, { 198,-378 }, { 199,-378 },

 { 200,-378 }, { 201,-378 }, { 202,-378 }, { 203,-378 }, { 204,-378 },
 { 205,-378 }, { 206,-378 }, { 207,-378 }, { 208,-378 }, { 209,-378 },
 { 210,-378 }, { 211,-378 }, { 212,-378 }, { 213,-378 }, { 214,-378 },
 { 215,-378 }, { 216,-378 }, { 217,-378 }, { 218,-378 }, { 219,-378 },
 { 220,-378 }, { 221,-378 }, { 222,-378 }, { 223,-378 }, { 224,-378 },
 { 225,-378 }, { 226,-378 }, { 227,-378 }, { 228,-378 }, { 229,-378 },
 { 230,-378 }, { 231,-378 }, { 232,-378 }, { 233,-378 }, { 234,-378 },
 { 235,-378 }, { 236,-378 }, { 237,-378 }, { 238,-378 }, { 239,-378 },
 { 240,-378 }, { 241,-378 }, { 242,-378 }, { 243,-378 }, { 244,-378 },
 { 245,-378 }, { 246,-378 }, { 247,-378 }, { 248,-378 }, { 249,-378 },

 { 250,-378 }, { 251,-378 }, { 252,-378 }, { 253,-378 }, { 254,-378 },
 { 255,-378 }, {   0,  57 }, {   0,17184 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  71 }, {   0,17174 }, {   0,  73 }, {   0,17172 },
 {   0,  70 }, {   0,17170 }, {   0,  69 }, {   0,17168 }, {   0,  29 },
 {   0,17166 }, {   0,  30 }, {   0,17164 }, {   0,  23 }, {   0,17162 },
 {   0,  24 }, {   0,17160 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  46,6223 }, {   0,   0 },
 {  48,6480 }, {  49,6480 }, {  50,6480 }, {  51,6480 }, {  52,6480 },
 {  53,6480 }, {  54,6480 }, {  55,6480 }, {  56,6480 }, {  57,6480 },
 {  48,11428 }, {  49,11428 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-635 }, {  66,-635 }, {  67,-635 },
 {  68,-635 }, {  69,6737 }, {  70,-635 }, {  71,-635 }, {  72,-635 },
 {  73,-635 }, {  74,-635 }, {  75,-635 }, {  76,-635 }, {  77,-635 },
 {  78,-635 }, {  79,-635 }, {  80,-635 }, {  81,-635 }, {  82,-635 },
 {  83,-635 }, {  84,-635 }, {  85,-635 }, {  86,-635 }, {  87,-635 },
 {  88,-635 }, {  89,-635 }, {  90,-635 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  95,6778 }, {   0,   0 }, {  97,-635 },
 {  98,-635 }, {  99,-635 }, { 100,-635 }, { 101,6737 }, { 102,-635 },
 { 103,-635 }, { 104,-635 }, { 105,-635 }, { 106,-635 }, { 107,-635 },
 { 108,-635 }, { 109,-635 }, { 110,-635 }, { 111,-635 }, { 112,-635 },
 { 113,-635 }, { 114,-635 }, { 115,-635 }, { 116,-635 }, { 117,-635 },
 { 118,-635 }, { 119,-635 }, { 120,-635 }, { 121,-635 }, { 122,-635 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,-635 }, { 129,-635 }, { 130,-635 }, { 131,-635 }, { 132,-635 },
 { 133,-635 }, { 134,-635 }, { 135,-635 }, { 136,-635 }, { 137,-635 },
 { 138,-635 }, { 139,-635 }, { 140,-635 }, { 141,-635 }, { 142,-635 },

 { 143,-635 }, { 144,-635 }, { 145,-635 }, { 146,-635 }, { 147,-635 },
 { 148,-635 }, { 149,-635 }, { 150,-635 }, { 151,-635 }, { 152,-635 },
 { 153,-635 }, { 154,-635 }, { 155,-635 }, { 156,-635 }, { 157,-635 },
 { 158,-635 }, { 159,-635 }, { 160,-635 }, { 161,-635 }, { 162,-635 },
 { 163,-635 }, { 164,-635 }, { 165,-635 }, { 166,-635 }, { 167,-635 },
 { 168,-635 }, { 169,-635 }, { 170,-635 }, { 171,-635 }, { 172,-635 },
 { 173,-635 }, { 174,-635 }, { 175,-635 }, { 176,-635 }, { 177,-635 },
 { 178,-635 }, { 179,-635 }, { 180,-635 }, { 181,-635 }, { 182,-635 },
 { 183,-635 }, { 184,-635 }, { 185,-635 }, { 186,-635 }, { 187,-635 },
 { 188,-635 }, { 189,-635 }, { 190,-635 }, { 191,-635 }, { 192,-635 },

 { 193,-635 }, { 194,-635 }, { 195,-635 }, { 196,-635 }, { 197,-635 },
 { 198,-635 }, { 199,-635 }, { 200,-635 }, { 201,-635 }, { 202,-635 },
 { 203,-635 }, { 204,-635 }, { 205,-635 }, { 206,-635 }, { 207,-635 },
 { 208,-635 }, { 209,-635 }, { 210,-635 }, { 211,-635 }, { 212,-635 },
 { 213,-635 }, { 214,-635 }, { 215,-635 }, { 216,-635 }, { 217,-635 },
 { 218,-635 }, { 219,-635 }, { 220,-635 }, { 221,-635 }, { 222,-635 },
 { 223,-635 }, { 224,-635 }, { 225,-635 }, { 226,-635 }, { 227,-635 },
 { 228,-635 }, { 229,-635 }, { 230,-635 }, { 231,-635 }, { 232,-635 },
 { 233,-635 }, { 234,-635 }, { 235,-635 }, { 236,-635 }, { 237,-635 },
 { 238,-635 }, { 239,-635 }, { 240,-635 }, { 241,-635 }, { 242,-635 },

 { 243,-635 }, { 244,-635 }, { 245,-635 }, { 246,-635 }, { 247,-635 },
 { 248,-635 }, { 249,-635 }, { 250,-635 }, { 251,-635 }, { 252,-635 },
 { 253,-635 }, { 254,-635 }, { 255,-635 }, {   0,  53 }, {   0,16927 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  53 },
 {   0,16916 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  33,4815 }, {   0,   0 }, {  35,4815 },

 {   0,   0 }, {  37,4815 }, {  38,4815 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  42,4815 }, {  43,4815 }, {  33,4804 }, {  45,4815 },
 {  35,4804 }, {  47,4815 }, {  37,4804 }, {  38,4804 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42,4804 }, {  43,4804 }, {   0,   0 },
 {  45,4804 }, {   0,   0 }, {  47,4804 }, {   0,   0 }, {  60,4815 },
 {  61,6580 }, {  62,6591 }, {  63,4815 }, {  64,4815 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  60,4804 }, {  61,4804 }, {  62,6647 }, {  63,4804 }, {  64,4804 },
 {   0,   0 }, {   0,  53 }, {   0,16849 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,4815 }, {   0,   0 },
 {  96,4815 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,4804 },
 {   0,   0 }, {  96,4804 }, {   0,   0 }, {   0,  74 }, {   0,16817 },
 {  33,4737 }, {   0,   0 }, {  35,4737 }, {   0,   0 }, {  37,4737 },
 {  38,4737 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,4737 },
 {  43,4737 }, {   0,   0 }, {  45,4737 }, { 124,4815 }, {  47,4737 },
 { 126,4815 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,4804 },

 {   0,   0 }, { 126,4804 }, {  60,4737 }, {  61,6620 }, {  62,4737 },
 {  63,4737 }, {  64,4737 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,6654 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,6654 }, {  49,6654 }, {  50,6654 },
 {  51,6654 }, {  52,6654 }, {  53,6654 }, {  54,6654 }, {  55,6654 },
 {  56,6654 }, {  57,6654 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,4737 }, {   0,   0 }, {  96,4737 }, {  65,6654 },
 {  66,6654 }, {  67,6654 }, {  68,6654 }, {  69,6654 }, {  70,6654 },
 {  71,6654 }, {  72,6654 }, {  73,6654 }, {  74,6654 }, {  75,6654 },

 {  76,6654 }, {  77,6654 }, {  78,6654 }, {  79,6654 }, {  80,6654 },
 {  81,6654 }, {  82,6654 }, {  83,6654 }, {  84,6654 }, {  85,6654 },
 {  86,6654 }, {  87,6654 }, {  88,6654 }, {  89,6654 }, {  90,6654 },
 {   0,   0 }, { 124,4737 }, {   0,   0 }, { 126,4737 }, {  95,6654 },
 {   0,   0 }, {  97,6654 }, {  98,6654 }, {  99,6654 }, { 100,6654 },
 { 101,6654 }, { 102,6654 }, { 103,6654 }, { 104,6654 }, { 105,6654 },
 { 106,6654 }, { 107,6654 }, { 108,6654 }, { 109,6654 }, { 110,6654 },
 { 111,6654 }, { 112,6654 }, { 113,6654 }, { 114,6654 }, { 115,6654 },
 { 116,6654 }, { 117,6654 }, { 118,6654 }, { 119,6654 }, { 120,6654 },
 { 121,6654 }, { 122,6654 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, { 128,6654 }, { 129,6654 }, { 130,6654 },
 { 131,6654 }, { 132,6654 }, { 133,6654 }, { 134,6654 }, { 135,6654 },
 { 136,6654 }, { 137,6654 }, { 138,6654 }, { 139,6654 }, { 140,6654 },
 { 141,6654 }, { 142,6654 }, { 143,6654 }, { 144,6654 }, { 145,6654 },
 { 146,6654 }, { 147,6654 }, { 148,6654 }, { 149,6654 }, { 150,6654 },
 { 151,6654 }, { 152,6654 }, { 153,6654 }, { 154,6654 }, { 155,6654 },
 { 156,6654 }, { 157,6654 }, { 158,6654 }, { 159,6654 }, { 160,6654 },
 { 161,6654 }, { 162,6654 }, { 163,6654 }, { 164,6654 }, { 165,6654 },
 { 166,6654 }, { 167,6654 }, { 168,6654 }, { 169,6654 }, { 170,6654 },
 { 171,6654 }, { 172,6654 }, { 173,6654 }, { 174,6654 }, { 175,6654 },

 { 176,6654 }, { 177,6654 }, { 178,6654 }, { 179,6654 }, { 180,6654 },
 { 181,6654 }, { 182,6654 }, { 183,6654 }, { 184,6654 }, { 185,6654 },
 { 186,6654 }, { 187,6654 }, { 188,6654 }, { 189,6654 }, { 190,6654 },
 { 191,6654 }, { 192,6654 }, { 193,6654 }, { 194,6654 }, { 195,6654 },
 { 196,6654 }, { 197,6654 }, { 198,6654 }, { 199,6654 }, { 200,6654 },
 { 201,6654 }, { 202,6654 }, { 203,6654 }, { 204,6654 }, { 205,6654 },
 { 206,6654 }, { 207,6654 }, { 208,6654 }, { 209,6654 }, { 210,6654 },
 { 211,6654 }, { 212,6654 }, { 213,6654 }, { 214,6654 }, { 215,6654 },
 { 216,6654 }, { 217,6654 }, { 218,6654 }, { 219,6654 }, { 220,6654 },
 { 221,6654 }, { 222,6654 }, { 223,6654 }, { 224,6654 }, { 225,6654 },

 { 226,6654 }, { 227,6654 }, { 228,6654 }, { 229,6654 }, { 230,6654 },
 { 231,6654 }, { 232,6654 }, { 233,6654 }, { 234,6654 }, { 235,6654 },
 { 236,6654 }, { 237,6654 }, { 238,6654 }, { 239,6654 }, { 240,6654 },
 { 241,6654 }, { 242,6654 }, { 243,6654 }, { 244,6654 }, { 245,6654 },
 { 246,6654 }, { 247,6654 }, { 248,6654 }, { 249,6654 }, { 250,6654 },
 { 251,6654 }, { 252,6654 }, { 253,6654 }, { 254,6654 }, { 255,6654 },
 {   0,  74 }, {   0,16560 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,6397 }, {   0,   0 }, {   0,   0 },
 {  39,-1006 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,6397 },
 {  49,6397 }, {  50,6397 }, {  51,6397 }, {  52,6397 }, {  53,6397 },
 {  54,6397 }, {  55,6397 }, {  56,6397 }, {  57,6397 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,6397 }, {  66,6397 }, {  67,6397 }, {  68,6397 },

 {  69,6397 }, {  70,6397 }, {  71,6397 }, {  72,6397 }, {  73,6397 },
 {  74,6397 }, {  75,6397 }, {  76,6397 }, {  77,6397 }, {  78,6397 },
 {  79,6397 }, {  80,6397 }, {  81,6397 }, {  82,6397 }, {  83,6397 },
 {  84,6397 }, {  85,6397 }, {  86,6397 }, {  87,6397 }, {  88,6397 },
 {  89,6397 }, {  90,6397 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,6397 }, {   0,   0 }, {  97,6397 }, {  98,6397 },
 {  99,6397 }, { 100,6397 }, { 101,6397 }, { 102,6397 }, { 103,6397 },
 { 104,6397 }, { 105,6397 }, { 106,6397 }, { 107,6397 }, { 108,6397 },
 { 109,6397 }, { 110,6397 }, { 111,6397 }, { 112,6397 }, { 113,6397 },
 { 114,6397 }, { 115,6397 }, { 116,6397 }, { 117,6397 }, { 118,6397 },

 { 119,6397 }, { 120,6397 }, { 121,6397 }, { 122,6397 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,6397 },
 { 129,6397 }, { 130,6397 }, { 131,6397 }, { 132,6397 }, { 133,6397 },
 { 134,6397 }, { 135,6397 }, { 136,6397 }, { 137,6397 }, { 138,6397 },
 { 139,6397 }, { 140,6397 }, { 141,6397 }, { 142,6397 }, { 143,6397 },
 { 144,6397 }, { 145,6397 }, { 146,6397 }, { 147,6397 }, { 148,6397 },
 { 149,6397 }, { 150,6397 }, { 151,6397 }, { 152,6397 }, { 153,6397 },
 { 154,6397 }, { 155,6397 }, { 156,6397 }, { 157,6397 }, { 158,6397 },
 { 159,6397 }, { 160,6397 }, { 161,6397 }, { 162,6397 }, { 163,6397 },
 { 164,6397 }, { 165,6397 }, { 166,6397 }, { 167,6397 }, { 168,6397 },

 { 169,6397 }, { 170,6397 }, { 171,6397 }, { 172,6397 }, { 173,6397 },
 { 174,6397 }, { 175,6397 }, { 176,6397 }, { 177,6397 }, { 178,6397 },
 { 179,6397 }, { 180,6397 }, { 181,6397 }, { 182,6397 }, { 183,6397 },
 { 184,6397 }, { 185,6397 }, { 186,6397 }, { 187,6397 }, { 188,6397 },
 { 189,6397 }, { 190,6397 }, { 191,6397 }, { 192,6397 }, { 193,6397 },
 { 194,6397 }, { 195,6397 }, { 196,6397 }, { 197,6397 }, { 198,6397 },
 { 199,6397 }, { 200,6397 }, { 201,6397 }, { 202,6397 }, { 203,6397 },
 { 204,6397 }, { 205,6397 }, { 206,6397 }, { 207,6397 }, { 208,6397 },
 { 209,6397 }, { 210,6397 }, { 211,6397 }, { 212,6397 }, { 213,6397 },
 { 214,6397 }, { 215,6397 }, { 216,6397 }, { 217,6397 }, { 218,6397 },

 { 219,6397 }, { 220,6397 }, { 221,6397 }, { 222,6397 }, { 223,6397 },
 { 224,6397 }, { 225,6397 }, { 226,6397 }, { 227,6397 }, { 228,6397 },
 { 229,6397 }, { 230,6397 }, { 231,6397 }, { 232,6397 }, { 233,6397 },
 { 234,6397 }, { 235,6397 }, { 236,6397 }, { 237,6397 }, { 238,6397 },
 { 239,6397 }, { 240,6397 }, { 241,6397 }, { 242,6397 }, { 243,6397 },
 { 244,6397 }, { 245,6397 }, { 246,6397 }, { 247,6397 }, { 248,6397 },
 { 249,6397 }, { 250,6397 }, { 251,6397 }, { 252,6397 }, { 253,6397 },
 { 254,6397 }, { 255,6397 }, {   0,  74 }, {   0,16303 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,6140 },
 {   0,   0 }, {   0,   0 }, {  39,-1258 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,6140 }, {  49,6140 }, {  50,6140 }, {  51,6140 },
 {  52,6140 }, {  53,6140 }, {  54,6140 }, {  55,6140 }, {  56,6140 },
 {  57,6140 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,6140 }, {  66,6140 },
 {  67,6140 }, {  68,6140 }, {  69,6140 }, {  70,6140 }, {  71,6140 },
 {  72,6140 }, {  73,6140 }, {  74,6140 }, {  75,6140 }, {  76,6140 },
 {  77,6140 }, {  78,6140 }, {  79,6140 }, {  80,6140 }, {  81,6140 },
 {  82,6140 }, {  83,6140 }, {  84,6140 }, {  85,6140 }, {  86,6140 },
 {  87,6140 }, {  88,6140 }, {  89,6140 }, {  90,6140 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,6140 }, {   0,   0 },
 {  97,6140 }, {  98,6140 }, {  99,6140 }, { 100,6140 }, { 101,6140 },
 { 102,6140 }, { 103,6140 }, { 104,6140 }, { 105,6140 }, { 106,6140 },
 { 107,6140 }, { 108,6140 }, { 109,6140 }, { 110,6140 }, { 111,6140 },

 { 112,6140 }, { 113,6140 }, { 114,6140 }, { 115,6140 }, { 116,6140 },
 { 117,6140 }, { 118,6140 }, { 119,6140 }, { 120,6140 }, { 121,6140 },
 { 122,6140 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,6140 }, { 129,6140 }, { 130,6140 }, { 131,6140 },
 { 132,6140 }, { 133,6140 }, { 134,6140 }, { 135,6140 }, { 136,6140 },
 { 137,6140 }, { 138,6140 }, { 139,6140 }, { 140,6140 }, { 141,6140 },
 { 142,6140 }, { 143,6140 }, { 144,6140 }, { 145,6140 }, { 146,6140 },
 { 147,6140 }, { 148,6140 }, { 149,6140 }, { 150,6140 }, { 151,6140 },
 { 152,6140 }, { 153,6140 }, { 154,6140 }, { 155,6140 }, { 156,6140 },
 { 157,6140 }, { 158,6140 }, { 159,6140 }, { 160,6140 }, { 161,6140 },

 { 162,6140 }, { 163,6140 }, { 164,6140 }, { 165,6140 }, { 166,6140 },
 { 167,6140 }, { 168,6140 }, { 169,6140 }, { 170,6140 }, { 171,6140 },
 { 172,6140 }, { 173,6140 }, { 174,6140 }, { 175,6140 }, { 176,6140 },
 { 177,6140 }, { 178,6140 }, { 179,6140 }, { 180,6140 }, { 181,6140 },
 { 182,6140 }, { 183,6140 }, { 184,6140 }, { 185,6140 }, { 186,6140 },
 { 187,6140 }, { 188,6140 }, { 189,6140 }, { 190,6140 }, { 191,6140 },
 { 192,6140 }, { 193,6140 }, { 194,6140 }, { 195,6140 }, { 196,6140 },
 { 197,6140 }, { 198,6140 }, { 199,6140 }, { 200,6140 }, { 201,6140 },
 { 202,6140 }, { 203,6140 }, { 204,6140 }, { 205,6140 }, { 206,6140 },
 { 207,6140 }, { 208,6140 }, { 209,6140 }, { 210,6140 }, { 211,6140 },

 { 212,6140 }, { 213,6140 }, { 214,6140 }, { 215,6140 }, { 216,6140 },
 { 217,6140 }, { 218,6140 }, { 219,6140 }, { 220,6140 }, { 221,6140 },
 { 222,6140 }, { 223,6140 }, { 224,6140 }, { 225,6140 }, { 226,6140 },
 { 227,6140 }, { 228,6140 }, { 229,6140 }, { 230,6140 }, { 231,6140 },
 { 232,6140 }, { 233,6140 }, { 234,6140 }, { 235,6140 }, { 236,6140 },
 { 237,6140 }, { 238,6140 }, { 239,6140 }, { 240,6140 }, { 241,6140 },
 { 242,6140 }, { 243,6140 }, { 244,6140 }, { 245,6140 }, { 246,6140 },
 { 247,6140 }, { 248,6140 }, { 249,6140 }, { 250,6140 }, { 251,6140 },
 { 252,6140 }, { 253,6140 }, { 254,6140 }, { 255,6140 }, {   0,  74 },
 {   0,16046 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  36,5883 }, {   0,   0 }, {   0,   0 }, {  39,-1513 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,5883 }, {  49,5883 },
 {  50,5883 }, {  51,5883 }, {  52,5883 }, {  53,5883 }, {  54,5883 },

 {  55,5883 }, {  56,5883 }, {  57,5883 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,5883 }, {  66,5883 }, {  67,5883 }, {  68,5883 }, {  69,5883 },
 {  70,5883 }, {  71,5883 }, {  72,5883 }, {  73,5883 }, {  74,5883 },
 {  75,5883 }, {  76,5883 }, {  77,5883 }, {  78,5883 }, {  79,5883 },
 {  80,5883 }, {  81,5883 }, {  82,5883 }, {  83,5883 }, {  84,5883 },
 {  85,5883 }, {  86,5883 }, {  87,5883 }, {  88,5883 }, {  89,5883 },
 {  90,5883 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,5883 }, {   0,   0 }, {  97,5883 }, {  98,5883 }, {  99,5883 },
 { 100,5883 }, { 101,5883 }, { 102,5883 }, { 103,5883 }, { 104,5883 },

 { 105,5883 }, { 106,5883 }, { 107,5883 }, { 108,5883 }, { 109,5883 },
 { 110,5883 }, { 111,5883 }, { 112,5883 }, { 113,5883 }, { 114,5883 },
 { 115,5883 }, { 116,5883 }, { 117,5883 }, { 118,5883 }, { 119,5883 },
 { 120,5883 }, { 121,5883 }, { 122,5883 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,5883 }, { 129,5883 },
 { 130,5883 }, { 131,5883 }, { 132,5883 }, { 133,5883 }, { 134,5883 },
 { 135,5883 }, { 136,5883 }, { 137,5883 }, { 138,5883 }, { 139,5883 },
 { 140,5883 }, { 141,5883 }, { 142,5883 }, { 143,5883 }, { 144,5883 },
 { 145,5883 }, { 146,5883 }, { 147,5883 }, { 148,5883 }, { 149,5883 },
 { 150,5883 }, { 151,5883 }, { 152,5883 }, { 153,5883 }, { 154,5883 },

 { 155,5883 }, { 156,5883 }, { 157,5883 }, { 158,5883 }, { 159,5883 },
 { 160,5883 }, { 161,5883 }, { 162,5883 }, { 163,5883 }, { 164,5883 },
 { 165,5883 }, { 166,5883 }, { 167,5883 }, { 168,5883 }, { 169,5883 },
 { 170,5883 }, { 171,5883 }, { 172,5883 }, { 173,5883 }, { 174,5883 },
 { 175,5883 }, { 176,5883 }, { 177,5883 }, { 178,5883 }, { 179,5883 },
 { 180,5883 }, { 181,5883 }, { 182,5883 }, { 183,5883 }, { 184,5883 },
 { 185,5883 }, { 186,5883 }, { 187,5883 }, { 188,5883 }, { 189,5883 },
 { 190,5883 }, { 191,5883 }, { 192,5883 }, { 193,5883 }, { 194,5883 },
 { 195,5883 }, { 196,5883 }, { 197,5883 }, { 198,5883 }, { 199,5883 },
 { 200,5883 }, { 201,5883 }, { 202,5883 }, { 203,5883 }, { 204,5883 },

 { 205,5883 }, { 206,5883 }, { 207,5883 }, { 208,5883 }, { 209,5883 },
 { 210,5883 }, { 211,5883 }, { 212,5883 }, { 213,5883 }, { 214,5883 },
 { 215,5883 }, { 216,5883 }, { 217,5883 }, { 218,5883 }, { 219,5883 },
 { 220,5883 }, { 221,5883 }, { 222,5883 }, { 223,5883 }, { 224,5883 },
 { 225,5883 }, { 226,5883 }, { 227,5883 }, { 228,5883 }, { 229,5883 },
 { 230,5883 }, { 231,5883 }, { 232,5883 }, { 233,5883 }, { 234,5883 },
 { 235,5883 }, { 236,5883 }, { 237,5883 }, { 238,5883 }, { 239,5883 },
 { 240,5883 }, { 241,5883 }, { 242,5883 }, { 243,5883 }, { 244,5883 },
 { 245,5883 }, { 246,5883 }, { 247,5883 }, { 248,5883 }, { 249,5883 },
 { 250,5883 }, { 251,5883 }, { 252,5883 }, { 253,5883 }, { 254,5883 },

 { 255,5883 }, {   0,  74 }, {   0,15789 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,5626 }, {   0,   0 },
 {  38,-1767 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  48,5626 }, {  49,5626 }, {  50,5626 }, {  51,5626 }, {  52,5626 },
 {  53,5626 }, {  54,5626 }, {  55,5626 }, {  56,5626 }, {  57,5626 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,5626 }, {  66,5626 }, {  67,5626 },
 {  68,5626 }, {  69,5626 }, {  70,5626 }, {  71,5626 }, {  72,5626 },
 {  73,5626 }, {  74,5626 }, {  75,5626 }, {  76,5626 }, {  77,5626 },
 {  78,5626 }, {  79,5626 }, {  80,5626 }, {  81,5626 }, {  82,5626 },
 {  83,5626 }, {  84,5626 }, {  85,5626 }, {  86,5626 }, {  87,5626 },
 {  88,5626 }, {  89,5626 }, {  90,5626 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,5626 }, {   0,   0 }, {  97,5626 },

 {  98,5626 }, {  99,5626 }, { 100,5626 }, { 101,5626 }, { 102,5626 },
 { 103,5626 }, { 104,5626 }, { 105,5626 }, { 106,5626 }, { 107,5626 },
 { 108,5626 }, { 109,5626 }, { 110,5626 }, { 111,5626 }, { 112,5626 },
 { 113,5626 }, { 114,5626 }, { 115,5626 }, { 116,5626 }, { 117,5626 },
 { 118,5626 }, { 119,5626 }, { 120,5626 }, { 121,5626 }, { 122,5626 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,5626 }, { 129,5626 }, { 130,5626 }, { 131,5626 }, { 132,5626 },
 { 133,5626 }, { 134,5626 }, { 135,5626 }, { 136,5626 }, { 137,5626 },
 { 138,5626 }, { 139,5626 }, { 140,5626 }, { 141,5626 }, { 142,5626 },
 { 143,5626 }, { 144,5626 }, { 145,5626 }, { 146,5626 }, { 147,5626 },

 { 148,5626 }, { 149,5626 }, { 150,5626 }, { 151,5626 }, { 152,5626 },
 { 153,5626 }, { 154,5626 }, { 155,5626 }, { 156,5626 }, { 157,5626 },
 { 158,5626 }, { 159,5626 }, { 160,5626 }, { 161,5626 }, { 162,5626 },
 { 163,5626 }, { 164,5626 }, { 165,5626 }, { 166,5626 }, { 167,5626 },
 { 168,5626 }, { 169,5626 }, { 170,5626 }, { 171,5626 }, { 172,5626 },
 { 173,5626 }, { 174,5626 }, { 175,5626 }, { 176,5626 }, { 177,5626 },
 { 178,5626 }, { 179,5626 }, { 180,5626 }, { 181,5626 }, { 182,5626 },
 { 183,5626 }, { 184,5626 }, { 185,5626 }, { 186,5626 }, { 187,5626 },
 { 188,5626 }, { 189,5626 }, { 190,5626 }, { 191,5626 }, { 192,5626 },
 { 193,5626 }, { 194,5626 }, { 195,5626 }, { 196,5626 }, { 197,5626 },

 { 198,5626 }, { 199,5626 }, { 200,5626 }, { 201,5626 }, { 202,5626 },
 { 203,5626 }, { 204,5626 }, { 205,5626 }, { 206,5626 }, { 207,5626 },
 { 208,5626 }, { 209,5626 }, { 210,5626 }, { 211,5626 }, { 212,5626 },
 { 213,5626 }, { 214,5626 }, { 215,5626 }, { 216,5626 }, { 217,5626 },
 { 218,5626 }, { 219,5626 }, { 220,5626 }, { 221,5626 }, { 222,5626 },
 { 223,5626 }, { 224,5626 }, { 225,5626 }, { 226,5626 }, { 227,5626 },
 { 228,5626 }, { 229,5626 }, { 230,5626 }, { 231,5626 }, { 232,5626 },
 { 233,5626 }, { 234,5626 }, { 235,5626 }, { 236,5626 }, { 237,5626 },
 { 238,5626 }, { 239,5626 }, { 240,5626 }, { 241,5626 }, { 242,5626 },
 { 243,5626 }, { 244,5626 }, { 245,5626 }, { 246,5626 }, { 247,5626 },

 { 248,5626 }, { 249,5626 }, { 250,5626 }, { 251,5626 }, { 252,5626 },
 { 253,5626 }, { 254,5626 }, { 255,5626 }, {   0,  74 }, {   0,15532 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  36,5369 }, {   0,   0 }, {   0,   0 }, {  39,-2022 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,5369 }, {  49,5369 }, {  50,5369 },
 {  51,5369 }, {  52,5369 }, {  53,5369 }, {  54,5369 }, {  55,5369 },
 {  56,5369 }, {  57,5369 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,5369 },
 {  66,5369 }, {  67,5369 }, {  68,5369 }, {  69,5369 }, {  70,5369 },
 {  71,5369 }, {  72,5369 }, {  73,5369 }, {  74,5369 }, {  75,5369 },
 {  76,5369 }, {  77,5369 }, {  78,5369 }, {  79,5369 }, {  80,5369 },
 {  81,5369 }, {  82,5369 }, {  83,5369 }, {  84,5369 }, {  85,5369 },
 {  86,5369 }, {  87,5369 }, {  88,5369 }, {  89,5369 }, {  90,5369 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,5369 },
 {   0,   0 }, {  97,5369 }, {  98,5369 }, {  99,5369 }, { 100,5369 },
 { 101,5369 }, { 102,5369 }, { 103,5369 }, { 104,5369 }, { 105,5369 },
 { 106,5369 }, { 107,5369 }, { 108,5369 }, { 109,5369 }, { 110,5369 },
 { 111,5369 }, { 112,5369 }, { 113,5369 }, { 114,5369 }, { 115,5369 },
 { 116,5369 }, { 117,5369 }, { 118,5369 }, { 119,5369 }, { 120,5369 },
 { 121,5369 }, { 122,5369 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,5369 }, { 129,5369 }, { 130,5369 },
 { 131,5369 }, { 132,5369 }, { 133,5369 }, { 134,5369 }, { 135,5369 },
 { 136,5369 }, { 137,5369 }, { 138,5369 }, { 139,5369 }, { 140,5369 },

 { 141,5369 }, { 142,5369 }, { 143,5369 }, { 144,5369 }, { 145,5369 },
 { 146,5369 }, { 147,5369 }, { 148,5369 }, { 149,5369 }, { 150,5369 },
 { 151,5369 }, { 152,5369 }, { 153,5369 }, { 154,5369 }, { 155,5369 },
 { 156,5369 }, { 157,5369 }, { 158,5369 }, { 159,5369 }, { 160,5369 },
 { 161,5369 }, { 162,5369 }, { 163,5369 }, { 164,5369 }, { 165,5369 },
 { 166,5369 }, { 167,5369 }, { 168,5369 }, { 169,5369 }, { 170,5369 },
 { 171,5369 }, { 172,5369 }, { 173,5369 }, { 174,5369 }, { 175,5369 },
 { 176,5369 }, { 177,5369 }, { 178,5369 }, { 179,5369 }, { 180,5369 },
 { 181,5369 }, { 182,5369 }, { 183,5369 }, { 184,5369 }, { 185,5369 },
 { 186,5369 }, { 187,5369 }, { 188,5369 }, { 189,5369 }, { 190,5369 },

 { 191,5369 }, { 192,5369 }, { 193,5369 }, { 194,5369 }, { 195,5369 },
 { 196,5369 }, { 197,5369 }, { 198,5369 }, { 199,5369 }, { 200,5369 },
 { 201,5369 }, { 202,5369 }, { 203,5369 }, { 204,5369 }, { 205,5369 },
 { 206,5369 }, { 207,5369 }, { 208,5369 }, { 209,5369 }, { 210,5369 },
 { 211,5369 }, { 212,5369 }, { 213,5369 }, { 214,5369 }, { 215,5369 },
 { 216,5369 }, { 217,5369 }, { 218,5369 }, { 219,5369 }, { 220,5369 },
 { 221,5369 }, { 222,5369 }, { 223,5369 }, { 224,5369 }, { 225,5369 },
 { 226,5369 }, { 227,5369 }, { 228,5369 }, { 229,5369 }, { 230,5369 },
 { 231,5369 }, { 232,5369 }, { 233,5369 }, { 234,5369 }, { 235,5369 },
 { 236,5369 }, { 237,5369 }, { 238,5369 }, { 239,5369 }, { 240,5369 },

 { 241,5369 }, { 242,5369 }, { 243,5369 }, { 244,5369 }, { 245,5369 },
 { 246,5369 }, { 247,5369 }, { 248,5369 }, { 249,5369 }, { 250,5369 },
 { 251,5369 }, { 252,5369 }, { 253,5369 }, { 254,5369 }, { 255,5369 },
 {   0,  10 }, {   0,15275 }, {   1,5369 }, {   2,5369 }, {   3,5369 },
 {   4,5369 }, {   5,5369 }, {   6,5369 }, {   7,5369 }, {   8,5369 },
 {   9,5369 }, {  10,5369 }, {  11,5369 }, {  12,5369 }, {  13,5369 },
 {  14,5369 }, {  15,5369 }, {  16,5369 }, {  17,5369 }, {  18,5369 },
 {  19,5369 }, {  20,5369 }, {  21,5369 }, {  22,5369 }, {  23,5369 },
 {  24,5369 }, {  25,5369 }, {  26,5369 }, {  27,5369 }, {  28,5369 },
 {  29,5369 }, {  30,5369 }, {  31,5369 }, {  32,5369 }, {  33,5369 },

 {  34,5369 }, {  35,5369 }, {  36,5369 }, {  37,5369 }, {  38,5369 },
 {   0,   0 }, {  40,5369 }, {  41,5369 }, {  42,5369 }, {  43,5369 },
 {  44,5369 }, {  45,5369 }, {  46,5369 }, {  47,5369 }, {  48,5369 },
 {  49,5369 }, {  50,5369 }, {  51,5369 }, {  52,5369 }, {  53,5369 },
 {  54,5369 }, {  55,5369 }, {  56,5369 }, {  57,5369 }, {  58,5369 },
 {  59,5369 }, {  60,5369 }, {  61,5369 }, {  62,5369 }, {  63,5369 },
 {  64,5369 }, {  65,5369 }, {  66,5369 }, {  67,5369 }, {  68,5369 },
 {  69,5369 }, {  70,5369 }, {  71,5369 }, {  72,5369 }, {  73,5369 },
 {  74,5369 }, {  75,5369 }, {  76,5369 }, {  77,5369 }, {  78,5369 },
 {  79,5369 }, {  80,5369 }, {  81,5369 }, {  82,5369 }, {  83,5369 },

 {  84,5369 }, {  85,5369 }, {  86,5369 }, {  87,5369 }, {  88,5369 },
 {  89,5369 }, {  90,5369 }, {  91,5369 }, {  92,5369 }, {  93,5369 },
 {  94,5369 }, {  95,5369 }, {  96,5369 }, {  97,5369 }, {  98,5369 },
 {  99,5369 }, { 100,5369 }, { 101,5369 }, { 102,5369 }, { 103,5369 },
 { 104,5369 }, { 105,5369 }, { 106,5369 }, { 107,5369 }, { 108,5369 },
 { 109,5369 }, { 110,5369 }, { 111,5369 }, { 112,5369 }, { 113,5369 },
 { 114,5369 }, { 115,5369 }, { 116,5369 }, { 117,5369 }, { 118,5369 },
 { 119,5369 }, { 120,5369 }, { 121,5369 }, { 122,5369 }, { 123,5369 },
 { 124,5369 }, { 125,5369 }, { 126,5369 }, { 127,5369 }, { 128,5369 },
 { 129,5369 }, { 130,5369 }, { 131,5369 }, { 132,5369 }, { 133,5369 },

 { 134,5369 }, { 135,5369 }, { 136,5369 }, { 137,5369 }, { 138,5369 },
 { 139,5369 }, { 140,5369 }, { 141,5369 }, { 142,5369 }, { 143,5369 },
 { 144,5369 }, { 145,5369 }, { 146,5369 }, { 147,5369 }, { 148,5369 },
 { 149,5369 }, { 150,5369 }, { 151,5369 }, { 152,5369 }, { 153,5369 },
 { 154,5369 }, { 155,5369 }, { 156,5369 }, { 157,5369 }, { 158,5369 },
 { 159,5369 }, { 160,5369 }, { 161,5369 }, { 162,5369 }, { 163,5369 },
 { 164,5369 }, { 165,5369 }, { 166,5369 }, { 167,5369 }, { 168,5369 },
 { 169,5369 }, { 170,5369 }, { 171,5369 }, { 172,5369 }, { 173,5369 },
 { 174,5369 }, { 175,5369 }, { 176,5369 }, { 177,5369 }, { 178,5369 },
 { 179,5369 }, { 180,5369 }, { 181,5369 }, { 182,5369 }, { 183,5369 },

 { 184,5369 }, { 185,5369 }, { 186,5369 }, { 187,5369 }, { 188,5369 },
 { 189,5369 }, { 190,5369 }, { 191,5369 }, { 192,5369 }, { 193,5369 },
 { 194,5369 }, { 195,5369 }, { 196,5369 }, { 197,5369 }, { 198,5369 },
 { 199,5369 }, { 200,5369 }, { 201,5369 }, { 202,5369 }, { 203,5369 },
 { 204,5369 }, { 205,5369 }, { 206,5369 }, { 207,5369 }, { 208,5369 },
 { 209,5369 }, { 210,5369 }, { 211,5369 }, { 212,5369 }, { 213,5369 },
 { 214,5369 }, { 215,5369 }, { 216,5369 }, { 217,5369 }, { 218,5369 },
 { 219,5369 }, { 220,5369 }, { 221,5369 }, { 222,5369 }, { 223,5369 },
 { 224,5369 }, { 225,5369 }, { 226,5369 }, { 227,5369 }, { 228,5369 },
 { 229,5369 }, { 230,5369 }, { 231,5369 }, { 232,5369 }, { 233,5369 },

 { 234,5369 }, { 235,5369 }, { 236,5369 }, { 237,5369 }, { 238,5369 },
 { 239,5369 }, { 240,5369 }, { 241,5369 }, { 242,5369 }, { 243,5369 },
 { 244,5369 }, { 245,5369 }, { 246,5369 }, { 247,5369 }, { 248,5369 },
 { 249,5369 }, { 250,5369 }, { 251,5369 }, { 252,5369 }, { 253,5369 },
 { 254,5369 }, { 255,5369 }, { 256,5369 }, {   0,   5 }, {   0,15017 },
 {   1,5369 }, {   2,5369 }, {   3,5369 }, {   4,5369 }, {   5,5369 },
 {   6,5369 }, {   7,5369 }, {   8,5369 }, {   9,5369 }, {  10,5369 },
 {  11,5369 }, {  12,5369 }, {  13,5369 }, {  14,5369 }, {  15,5369 },
 {  16,5369 }, {  17,5369 }, {  18,5369 }, {  19,5369 }, {  20,5369 },
 {  21,5369 }, {  22,5369 }, {  23,5369 }, {  24,5369 }, {  25,5369 },

 {  26,5369 }, {  27,5369 }, {  28,5369 }, {  29,5369 }, {  30,5369 },
 {  31,5369 }, {  32,5369 }, {  33,5369 }, {  34,5369 }, {  35,5369 },
 {  36,5369 }, {  37,5369 }, {  38,5369 }, {  39,5369 }, {  40,5369 },
 {  41,5369 }, {   0,   0 }, {  43,5369 }, {  44,5369 }, {  45,5369 },
 {  46,5369 }, {   0,   0 }, {  48,5369 }, {  49,5369 }, {  50,5369 },
 {  51,5369 }, {  52,5369 }, {  53,5369 }, {  54,5369 }, {  55,5369 },
 {  56,5369 }, {  57,5369 }, {  58,5369 }, {  59,5369 }, {  60,5369 },
 {  61,5369 }, {  62,5369 }, {  63,5369 }, {  64,5369 }, {  65,5369 },
 {  66,5369 }, {  67,5369 }, {  68,5369 }, {  69,5369 }, {  70,5369 },
 {  71,5369 }, {  72,5369 }, {  73,5369 }, {  74,5369 }, {  75,5369 },

 {  76,5369 }, {  77,5369 }, {  78,5369 }, {  79,5369 }, {  80,5369 },
 {  81,5369 }, {  82,5369 }, {  83,5369 }, {  84,5369 }, {  85,5369 },
 {  86,5369 }, {  87,5369 }, {  88,5369 }, {  89,5369 }, {  90,5369 },
 {  91,5369 }, {  92,5369 }, {  93,5369 }, {  94,5369 }, {  95,5369 },
 {  96,5369 }, {  97,5369 }, {  98,5369 }, {  99,5369 }, { 100,5369 },
 { 101,5369 }, { 102,5369 }, { 103,5369 }, { 104,5369 }, { 105,5369 },
 { 106,5369 }, { 107,5369 }, { 108,5369 }, { 109,5369 }, { 110,5369 },
 { 111,5369 }, { 112,5369 }, { 113,5369 }, { 114,5369 }, { 115,5369 },
 { 116,5369 }, { 117,5369 }, { 118,5369 }, { 119,5369 }, { 120,5369 },
 { 121,5369 }, { 122,5369 }, { 123,5369 }, { 124,5369 }, { 125,5369 },

 { 126,5369 }, { 127,5369 }, { 128,5369 }, { 129,5369 }, { 130,5369 },
 { 131,5369 }, { 132,5369 }, { 133,5369 }, { 134,5369 }, { 135,5369 },
 { 136,5369 }, { 137,5369 }, { 138,5369 }, { 139,5369 }, { 140,5369 },
 { 141,5369 }, { 142,5369 }, { 143,5369 }, { 144,5369 }, { 145,5369 },
 { 146,5369 }, { 147,5369 }, { 148,5369 }, { 149,5369 }, { 150,5369 },
 { 151,5369 }, { 152,5369 }, { 153,5369 }, { 154,5369 }, { 155,5369 },
 { 156,5369 }, { 157,5369 }, { 158,5369 }, { 159,5369 }, { 160,5369 },
 { 161,5369 }, { 162,5369 }, { 163,5369 }, { 164,5369 }, { 165,5369 },
 { 166,5369 }, { 167,5369 }, { 168,5369 }, { 169,5369 }, { 170,5369 },
 { 171,5369 }, { 172,5369 }, { 173,5369 }, { 174,5369 }, { 175,5369 },

 { 176,5369 }, { 177,5369 }, { 178,5369 }, { 179,5369 }, { 180,5369 },
 { 181,5369 }, { 182,5369 }, { 183,5369 }, { 184,5369 }, { 185,5369 },
 { 186,5369 }, { 187,5369 }, { 188,5369 }, { 189,5369 }, { 190,5369 },
 { 191,5369 }, { 192,5369 }, { 193,5369 }, { 194,5369 }, { 195,5369 },
 { 196,5369 }, { 197,5369 }, { 198,5369 }, { 199,5369 }, { 200,5369 },
 { 201,5369 }, { 202,5369 }, { 203,5369 }, { 204,5369 }, { 205,5369 },
 { 206,5369 }, { 207,5369 }, { 208,5369 }, { 209,5369 }, { 210,5369 },
 { 211,5369 }, { 212,5369 }, { 213,5369 }, { 214,5369 }, { 215,5369 },
 { 216,5369 }, { 217,5369 }, { 218,5369 }, { 219,5369 }, { 220,5369 },
 { 221,5369 }, { 222,5369 }, { 223,5369 }, { 224,5369 }, { 225,5369 },

 { 226,5369 }, { 227,5369 }, { 228,5369 }, { 229,5369 }, { 230,5369 },
 { 231,5369 }, { 232,5369 }, { 233,5369 }, { 234,5369 }, { 235,5369 },
 { 236,5369 }, { 237,5369 }, { 238,5369 }, { 239,5369 }, { 240,5369 },
 { 241,5369 }, { 242,5369 }, { 243,5369 }, { 244,5369 }, { 245,5369 },
 { 246,5369 }, { 247,5369 }, { 248,5369 }, { 249,5369 }, { 250,5369 },
 { 251,5369 }, { 252,5369 }, { 253,5369 }, { 254,5369 }, { 255,5369 },
 { 256,5369 }, {   0,   5 }, {   0,14759 }, {   1,5111 }, {   2,5111 },
 {   3,5111 }, {   4,5111 }, {   5,5111 }, {   6,5111 }, {   7,5111 },
 {   8,5111 }, {   9,5111 }, {  10,5111 }, {  11,5111 }, {  12,5111 },
 {  13,5111 }, {  14,5111 }, {  15,5111 }, {  16,5111 }, {  17,5111 },

 {  18,5111 }, {  19,5111 }, {  20,5111 }, {  21,5111 }, {  22,5111 },
 {  23,5111 }, {  24,5111 }, {  25,5111 }, {  26,5111 }, {  27,5111 },
 {  28,5111 }, {  29,5111 }, {  30,5111 }, {  31,5111 }, {  32,5111 },
 {  33,5111 }, {  34,5111 }, {  35,5111 }, {  36,5111 }, {  37,5111 },
 {  38,5111 }, {  39,5111 }, {  40,5111 }, {  41,5111 }, {   0,   0 },
 {  43,5111 }, {  44,5111 }, {  45,5111 }, {  46,5111 }, {   0,   0 },
 {  48,5111 }, {  49,5111 }, {  50,5111 }, {  51,5111 }, {  52,5111 },
 {  53,5111 }, {  54,5111 }, {  55,5111 }, {  56,5111 }, {  57,5111 },
 {  58,5111 }, {  59,5111 }, {  60,5111 }, {  61,5111 }, {  62,5111 },
 {  63,5111 }, {  64,5111 }, {  65,5111 }, {  66,5111 }, {  67,5111 },

 {  68,5111 }, {  69,5111 }, {  70,5111 }, {  71,5111 }, {  72,5111 },
 {  73,5111 }, {  74,5111 }, {  75,5111 }, {  76,5111 }, {  77,5111 },
 {  78,5111 }, {  79,5111 }, {  80,5111 }, {  81,5111 }, {  82,5111 },
 {  83,5111 }, {  84,5111 }, {  85,5111 }, {  86,5111 }, {  87,5111 },
 {  88,5111 }, {  89,5111 }, {  90,5111 }, {  91,5111 }, {  92,5111 },
 {  93,5111 }, {  94,5111 }, {  95,5111 }, {  96,5111 }, {  97,5111 },
 {  98,5111 }, {  99,5111 }, { 100,5111 }, { 101,5111 }, { 102,5111 },
 { 103,5111 }, { 104,5111 }, { 105,5111 }, { 106,5111 }, { 107,5111 },
 { 108,5111 }, { 109,5111 }, { 110,5111 }, { 111,5111 }, { 112,5111 },
 { 113,5111 }, { 114,5111 }, { 115,5111 }, { 116,5111 }, { 117,5111 },

 { 118,5111 }, { 119,5111 }, { 120,5111 }, { 121,5111 }, { 122,5111 },
 { 123,5111 }, { 124,5111 }, { 125,5111 }, { 126,5111 }, { 127,5111 },
 { 128,5111 }, { 129,5111 }, { 130,5111 }, { 131,5111 }, { 132,5111 },
 { 133,5111 }, { 134,5111 }, { 135,5111 }, { 136,5111 }, { 137,5111 },
 { 138,5111 }, { 139,5111 }, { 140,5111 }, { 141,5111 }, { 142,5111 },
 { 143,5111 }, { 144,5111 }, { 145,5111 }, { 146,5111 }, { 147,5111 },
 { 148,5111 }, { 149,5111 }, { 150,5111 }, { 151,5111 }, { 152,5111 },
 { 153,5111 }, { 154,5111 }, { 155,5111 }, { 156,5111 }, { 157,5111 },
 { 158,5111 }, { 159,5111 }, { 160,5111 }, { 161,5111 }, { 162,5111 },
 { 163,5111 }, { 164,5111 }, { 165,5111 }, { 166,5111 }, { 167,5111 },

 { 168,5111 }, { 169,5111 }, { 170,5111 }, { 171,5111 }, { 172,5111 },
 { 173,5111 }, { 174,5111 }, { 175,5111 }, { 176,5111 }, { 177,5111 },
 { 178,5111 }, { 179,5111 }, { 180,5111 }, { 181,5111 }, { 182,5111 },
 { 183,5111 }, { 184,5111 }, { 185,5111 }, { 186,5111 }, { 187,5111 },
 { 188,5111 }, { 189,5111 }, { 190,5111 }, { 191,5111 }, { 192,5111 },
 { 193,5111 }, { 194,5111 }, { 195,5111 }, { 196,5111 }, { 197,5111 },
 { 198,5111 }, { 199,5111 }, { 200,5111 }, { 201,5111 }, { 202,5111 },
 { 203,5111 }, { 204,5111 }, { 205,5111 }, { 206,5111 }, { 207,5111 },
 { 208,5111 }, { 209,5111 }, { 210,5111 }, { 211,5111 }, { 212,5111 },
 { 213,5111 }, { 214,5111 }, { 215,5111 }, { 216,5111 }, { 217,5111 },

 { 218,5111 }, { 219,5111 }, { 220,5111 }, { 221,5111 }, { 222,5111 },
 { 223,5111 }, { 224,5111 }, { 225,5111 }, { 226,5111 }, { 227,5111 },
 { 228,5111 }, { 229,5111 }, { 230,5111 }, { 231,5111 }, { 232,5111 },
 { 233,5111 }, { 234,5111 }, { 235,5111 }, { 236,5111 }, { 237,5111 },
 { 238,5111 }, { 239,5111 }, { 240,5111 }, { 241,5111 }, { 242,5111 },
 { 243,5111 }, { 244,5111 }, { 245,5111 }, { 246,5111 }, { 247,5111 },
 { 248,5111 }, { 249,5111 }, { 250,5111 }, { 251,5111 }, { 252,5111 },
 { 253,5111 }, { 254,5111 }, { 255,5111 }, { 256,5111 }, {   0,  43 },
 {   0,14501 }, {   1,5239 }, {   2,5239 }, {   3,5239 }, {   4,5239 },
 {   5,5239 }, {   6,5239 }, {   7,5239 }, {   8,5239 }, {   9,5239 },

 {  10,5239 }, {  11,5239 }, {  12,5239 }, {  13,5239 }, {  14,5239 },
 {  15,5239 }, {  16,5239 }, {  17,5239 }, {  18,5239 }, {  19,5239 },
 {  20,5239 }, {  21,5239 }, {  22,5239 }, {  23,5239 }, {  24,5239 },
 {  25,5239 }, {  26,5239 }, {  27,5239 }, {  28,5239 }, {  29,5239 },
 {  30,5239 }, {  31,5239 }, {  32,5239 }, {  33,5239 }, {   0,   0 },
 {  35,5239 }, {  36,5239 }, {  37,5239 }, {  38,5239 }, {  39,5239 },
 {  40,5239 }, {  41,5239 }, {  42,5239 }, {  43,5239 }, {  44,5239 },
 {  45,5239 }, {  46,5239 }, {  47,5239 }, {  48,5239 }, {  49,5239 },
 {  50,5239 }, {  51,5239 }, {  52,5239 }, {  53,5239 }, {  54,5239 },
 {  55,5239 }, {  56,5239 }, {  57,5239 }, {  58,5239 }, {  59,5239 },

 {  60,5239 }, {  61,5239 }, {  62,5239 }, {  63,5239 }, {  64,5239 },
 {  65,5239 }, {  66,5239 }, {  67,5239 }, {  68,5239 }, {  69,5239 },
 {  70,5239 }, {  71,5239 }, {  72,5239 }, {  73,5239 }, {  74,5239 },
 {  75,5239 }, {  76,5239 }, {  77,5239 }, {  78,5239 }, {  79,5239 },
 {  80,5239 }, {  81,5239 }, {  82,5239 }, {  83,5239 }, {  84,5239 },
 {  85,5239 }, {  86,5239 }, {  87,5239 }, {  88,5239 }, {  89,5239 },
 {  90,5239 }, {  91,5239 }, {  92,5239 }, {  93,5239 }, {  94,5239 },
 {  95,5239 }, {  96,5239 }, {  97,5239 }, {  98,5239 }, {  99,5239 },
 { 100,5239 }, { 101,5239 }, { 102,5239 }, { 103,5239 }, { 104,5239 },
 { 105,5239 }, { 106,5239 }, { 107,5239 }, { 108,5239 }, { 109,5239 },

 { 110,5239 }, { 111,5239 }, { 112,5239 }, { 113,5239 }, { 114,5239 },
 { 115,5239 }, { 116,5239 }, { 117,5239 }, { 118,5239 }, { 119,5239 },
 { 120,5239 }, { 121,5239 }, { 122,5239 }, { 123,5239 }, { 124,5239 },
 { 125,5239 }, { 126,5239 }, { 127,5239 }, { 128,5239 }, { 129,5239 },
 { 130,5239 }, { 131,5239 }, { 132,5239 }, { 133,5239 }, { 134,5239 },
 { 135,5239 }, { 136,5239 }, { 137,5239 }, { 138,5239 }, { 139,5239 },
 { 140,5239 }, { 141,5239 }, { 142,5239 }, { 143,5239 }, { 144,5239 },
 { 145,5239 }, { 146,5239 }, { 147,5239 }, { 148,5239 }, { 149,5239 },
 { 150,5239 }, { 151,5239 }, { 152,5239 }, { 153,5239 }, { 154,5239 },
 { 155,5239 }, { 156,5239 }, { 157,5239 }, { 158,5239 }, { 159,5239 },

 { 160,5239 }, { 161,5239 }, { 162,5239 }, { 163,5239 }, { 164,5239 },
 { 165,5239 }, { 166,5239 }, { 167,5239 }, { 168,5239 }, { 169,5239 },
 { 170,5239 }, { 171,5239 }, { 172,5239 }, { 173,5239 }, { 174,5239 },
 { 175,5239 }, { 176,5239 }, { 177,5239 }, { 178,5239 }, { 179,5239 },
 { 180,5239 }, { 181,5239 }, { 182,5239 }, { 183,5239 }, { 184,5239 },
 { 185,5239 }, { 186,5239 }, { 187,5239 }, { 188,5239 }, { 189,5239 },
 { 190,5239 }, { 191,5239 }, { 192,5239 }, { 193,5239 }, { 194,5239 },
 { 195,5239 }, { 196,5239 }, { 197,5239 }, { 198,5239 }, { 199,5239 },
 { 200,5239 }, { 201,5239 }, { 202,5239 }, { 203,5239 }, { 204,5239 },
 { 205,5239 }, { 206,5239 }, { 207,5239 }, { 208,5239 }, { 209,5239 },

 { 210,5239 }, { 211,5239 }, { 212,5239 }, { 213,5239 }, { 214,5239 },
 { 215,5239 }, { 216,5239 }, { 217,5239 }, { 218,5239 }, { 219,5239 },
 { 220,5239 }, { 221,5239 }, { 222,5239 }, { 223,5239 }, { 224,5239 },
 { 225,5239 }, { 226,5239 }, { 227,5239 }, { 228,5239 }, { 229,5239 },
 { 230,5239 }, { 231,5239 }, { 232,5239 }, { 233,5239 }, { 234,5239 },
 { 235,5239 }, { 236,5239 }, { 237,5239 }, { 238,5239 }, { 239,5239 },
 { 240,5239 }, { 241,5239 }, { 242,5239 }, { 243,5239 }, { 244,5239 },
 { 245,5239 }, { 246,5239 }, { 247,5239 }, { 248,5239 }, { 249,5239 },
 { 250,5239 }, { 251,5239 }, { 252,5239 }, { 253,5239 }, { 254,5239 },
 { 255,5239 }, { 256,5239 }, {   0,   9 }, {   0,14243 }, {   1,5239 },

 {   2,5239 }, {   3,5239 }, {   4,5239 }, {   5,5239 }, {   6,5239 },
 {   7,5239 }, {   8,5239 }, {   9,5239 }, {  10,5239 }, {  11,5239 },
 {  12,5239 }, {  13,5239 }, {  14,5239 }, {  15,5239 }, {  16,5239 },
 {  17,5239 }, {  18,5239 }, {  19,5239 }, {  20,5239 }, {  21,5239 },
 {  22,5239 }, {  23,5239 }, {  24,5239 }, {  25,5239 }, {  26,5239 },
 {  27,5239 }, {  28,5239 }, {  29,5239 }, {  30,5239 }, {  31,5239 },
 {  32,5239 }, {  33,5239 }, {  34,5239 }, {  35,5239 }, {  36,5239 },
 {  37,5239 }, {  38,5239 }, {   0,   0 }, {  40,5239 }, {  41,5239 },
 {  42,5239 }, {  43,5239 }, {  44,5239 }, {  45,5239 }, {  46,5239 },
 {  47,5239 }, {  48,5239 }, {  49,5239 }, {  50,5239 }, {  51,5239 },

 {  52,5239 }, {  53,5239 }, {  54,5239 }, {  55,5239 }, {  56,5239 },
 {  57,5239 }, {  58,5239 }, {  59,5239 }, {  60,5239 }, {  61,5239 },
 {  62,5239 }, {  63,5239 }, {  64,5239 }, {  65,5239 }, {  66,5239 },
 {  67,5239 }, {  68,5239 }, {  69,5239 }, {  70,5239 }, {  71,5239 },
 {  72,5239 }, {  73,5239 }, {  74,5239 }, {  75,5239 }, {  76,5239 },
 {  77,5239 }, {  78,5239 }, {  79,5239 }, {  80,5239 }, {  81,5239 },
 {  82,5239 }, {  83,5239 }, {  84,5239 }, {  85,5239 }, {  86,5239 },
 {  87,5239 }, {  88,5239 }, {  89,5239 }, {  90,5239 }, {  91,5239 },
 {  92,5239 }, {  93,5239 }, {  94,5239 }, {  95,5239 }, {  96,5239 },
 {  97,5239 }, {  98,5239 }, {  99,5239 }, { 100,5239 }, { 101,5239 },

 { 102,5239 }, { 103,5239 }, { 104,5239 }, { 105,5239 }, { 106,5239 },
 { 107,5239 }, { 108,5239 }, { 109,5239 }, { 110,5239 }, { 111,5239 },
 { 112,5239 }, { 113,5239 }, { 114,5239 }, { 115,5239 }, { 116,5239 },
 { 117,5239 }, { 118,5239 }, { 119,5239 }, { 120,5239 }, { 121,5239 },
 { 122,5239 }, { 123,5239 }, { 124,5239 }, { 125,5239 }, { 126,5239 },
 { 127,5239 }, { 128,5239 }, { 129,5239 }, { 130,5239 }, { 131,5239 },
 { 132,5239 }, { 133,5239 }, { 134,5239 }, { 135,5239 }, { 136,5239 },
 { 137,5239 }, { 138,5239 }, { 139,5239 }, { 140,5239 }, { 141,5239 },
 { 142,5239 }, { 143,5239 }, { 144,5239 }, { 145,5239 }, { 146,5239 },
 { 147,5239 }, { 148,5239 }, { 149,5239 }, { 150,5239 }, { 151,5239 },

 { 152,5239 }, { 153,5239 }, { 154,5239 }, { 155,5239 }, { 156,5239 },
 { 157,5239 }, { 158,5239 }, { 159,5239 }, { 160,5239 }, { 161,5239 },
 { 162,5239 }, { 163,5239 }, { 164,5239 }, { 165,5239 }, { 166,5239 },
 { 167,5239 }, { 168,5239 }, { 169,5239 }, { 170,5239 }, { 171,5239 },
 { 172,5239 }, { 173,5239 }, { 174,5239 }, { 175,5239 }, { 176,5239 },
 { 177,5239 }, { 178,5239 }, { 179,5239 }, { 180,5239 }, { 181,5239 },
 { 182,5239 }, { 183,5239 }, { 184,5239 }, { 185,5239 }, { 186,5239 },
 { 187,5239 }, { 188,5239 }, { 189,5239 }, { 190,5239 }, { 191,5239 },
 { 192,5239 }, { 193,5239 }, { 194,5239 }, { 195,5239 }, { 196,5239 },
 { 197,5239 }, { 198,5239 }, { 199,5239 }, { 200,5239 }, { 201,5239 },

 { 202,5239 }, { 203,5239 }, { 204,5239 }, { 205,5239 }, { 206,5239 },
 { 207,5239 }, { 208,5239 }, { 209,5239 }, { 210,5239 }, { 211,5239 },
 { 212,5239 }, { 213,5239 }, { 214,5239 }, { 215,5239 }, { 216,5239 },
 { 217,5239 }, { 218,5239 }, { 219,5239 }, { 220,5239 }, { 221,5239 },
 { 222,5239 }, { 223,5239 }, { 224,5239 }, { 225,5239 }, { 226,5239 },
 { 227,5239 }, { 228,5239 }, { 229,5239 }, { 230,5239 }, { 231,5239 },
 { 232,5239 }, { 233,5239 }, { 234,5239 }, { 235,5239 }, { 236,5239 },
 { 237,5239 }, { 238,5239 }, { 239,5239 }, { 240,5239 }, { 241,5239 },
 { 242,5239 }, { 243,5239 }, { 244,5239 }, { 245,5239 }, { 246,5239 },
 { 247,5239 }, { 248,5239 }, { 249,5239 }, { 250,5239 }, { 251,5239 },

 { 252,5239 }, { 253,5239 }, { 254,5239 }, { 255,5239 }, { 256,5239 },
 {   0,  21 }, {   0,13985 }, {   1,5239 }, {   2,5239 }, {   3,5239 },
 {   4,5239 }, {   5,5239 }, {   6,5239 }, {   7,5239 }, {   8,5239 },
 {   9,5239 }, {  10,5239 }, {  11,5239 }, {  12,5239 }, {  13,5239 },
 {  14,5239 }, {  15,5239 }, {  16,5239 }, {  17,5239 }, {  18,5239 },
 {  19,5239 }, {  20,5239 }, {  21,5239 }, {  22,5239 }, {  23,5239 },
 {  24,5239 }, {  25,5239 }, {  26,5239 }, {  27,5239 }, {  28,5239 },
 {  29,5239 }, {  30,5239 }, {  31,5239 }, {  32,5239 }, {  33,5239 },
 {  34,5239 }, {  35,5239 }, {  36,5239 }, {  37,5239 }, {  38,5239 },
 {   0,   0 }, {  40,5239 }, {  41,5239 }, {  42,5239 }, {  43,5239 },

 {  44,5239 }, {  45,5239 }, {  46,5239 }, {  47,5239 }, {  48,5239 },
 {  49,5239 }, {  50,5239 }, {  51,5239 }, {  52,5239 }, {  53,5239 },
 {  54,5239 }, {  55,5239 }, {  56,5239 }, {  57,5239 }, {  58,5239 },
 {  59,5239 }, {  60,5239 }, {  61,5239 }, {  62,5239 }, {  63,5239 },
 {  64,5239 }, {  65,5239 }, {  66,5239 }, {  67,5239 }, {  68,5239 },
 {  69,5239 }, {  70,5239 }, {  71,5239 }, {  72,5239 }, {  73,5239 },
 {  74,5239 }, {  75,5239 }, {  76,5239 }, {  77,5239 }, {  78,5239 },
 {  79,5239 }, {  80,5239 }, {  81,5239 }, {  82,5239 }, {  83,5239 },
 {  84,5239 }, {  85,5239 }, {  86,5239 }, {  87,5239 }, {  88,5239 },
 {  89,5239 }, {  90,5239 }, {  91,5239 }, {  92,5239 }, {  93,5239 },

 {  94,5239 }, {  95,5239 }, {  96,5239 }, {  97,5239 }, {  98,5239 },
 {  99,5239 }, { 100,5239 }, { 101,5239 }, { 102,5239 }, { 103,5239 },
 { 104,5239 }, { 105,5239 }, { 106,5239 }, { 107,5239 }, { 108,5239 },
 { 109,5239 }, { 110,5239 }, { 111,5239 }, { 112,5239 }, { 113,5239 },
 { 114,5239 }, { 115,5239 }, { 116,5239 }, { 117,5239 }, { 118,5239 },
 { 119,5239 }, { 120,5239 }, { 121,5239 }, { 122,5239 }, { 123,5239 },
 { 124,5239 }, { 125,5239 }, { 126,5239 }, { 127,5239 }, { 128,5239 },
 { 129,5239 }, { 130,5239 }, { 131,5239 }, { 132,5239 }, { 133,5239 },
 { 134,5239 }, { 135,5239 }, { 136,5239 }, { 137,5239 }, { 138,5239 },
 { 139,5239 }, { 140,5239 }, { 141,5239 }, { 142,5239 }, { 143,5239 },

 { 144,5239 }, { 145,5239 }, { 146,5239 }, { 147,5239 }, { 148,5239 },
 { 149,5239 }, { 150,5239 }, { 151,5239 }, { 152,5239 }, { 153,5239 },
 { 154,5239 }, { 155,5239 }, { 156,5239 }, { 157,5239 }, { 158,5239 },
 { 159,5239 }, { 160,5239 }, { 161,5239 }, { 162,5239 }, { 163,5239 },
 { 164,5239 }, { 165,5239 }, { 166,5239 }, { 167,5239 }, { 168,5239 },
 { 169,5239 }, { 170,5239 }, { 171,5239 }, { 172,5239 }, { 173,5239 },
 { 174,5239 }, { 175,5239 }, { 176,5239 }, { 177,5239 }, { 178,5239 },
 { 179,5239 }, { 180,5239 }, { 181,5239 }, { 182,5239 }, { 183,5239 },
 { 184,5239 }, { 185,5239 }, { 186,5239 }, { 187,5239 }, { 188,5239 },
 { 189,5239 }, { 190,5239 }, { 191,5239 }, { 192,5239 }, { 193,5239 },

 { 194,5239 }, { 195,5239 }, { 196,5239 }, { 197,5239 }, { 198,5239 },
 { 199,5239 }, { 200,5239 }, { 201,5239 }, { 202,5239 }, { 203,5239 },
 { 204,5239 }, { 205,5239 }, { 206,5239 }, { 207,5239 }, { 208,5239 },
 { 209,5239 }, { 210,5239 }, { 211,5239 }, { 212,5239 }, { 213,5239 },
 { 214,5239 }, { 215,5239 }, { 216,5239 }, { 217,5239 }, { 218,5239 },
 { 219,5239 }, { 220,5239 }, { 221,5239 }, { 222,5239 }, { 223,5239 },
 { 224,5239 }, { 225,5239 }, { 226,5239 }, { 227,5239 }, { 228,5239 },
 { 229,5239 }, { 230,5239 }, { 231,5239 }, { 232,5239 }, { 233,5239 },
 { 234,5239 }, { 235,5239 }, { 236,5239 }, { 237,5239 }, { 238,5239 },
 { 239,5239 }, { 240,5239 }, { 241,5239 }, { 242,5239 }, { 243,5239 },

 { 244,5239 }, { 245,5239 }, { 246,5239 }, { 247,5239 }, { 248,5239 },
 { 249,5239 }, { 250,5239 }, { 251,5239 }, { 252,5239 }, { 253,5239 },
 { 254,5239 }, { 255,5239 }, { 256,5239 }, {   0,  18 }, {   0,13727 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  18 }, {   0,13722 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,5239 }, {  10,5244 },
 {   0,   0 }, {  12,5239 }, {  13,5244 }, {   9,5255 }, {  10,5255 },
 {   0,   0 }, {  12,5255 }, {  13,5255 }, {   0,   0 }, {   0,  18 },
 {   0,13706 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,5239 },
 {  10,5239 }, {  32,5239 }, {  12,5239 }, {  13,5239 }, {   0,   0 },

 {   0,   0 }, {  32,5255 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-3783 }, {  45,-3780 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-3748 },
 {   0,   0 }, {   0,   0 }, {  32,5239 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-3799 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  45,-3764 }, {   0,  22 }, {   0,13659 }, {   1,5497 }, {   2,5497 },
 {   3,5497 }, {   4,5497 }, {   5,5497 }, {   6,5497 }, {   7,5497 },
 {   8,5497 }, {   9,5497 }, {  10,5497 }, {  11,5497 }, {  12,5497 },
 {  13,5497 }, {  14,5497 }, {  15,5497 }, {  16,5497 }, {  17,5497 },

 {  18,5497 }, {  19,5497 }, {  20,5497 }, {  21,5497 }, {  22,5497 },
 {  23,5497 }, {  24,5497 }, {  25,5497 }, {  26,5497 }, {  27,5497 },
 {  28,5497 }, {  29,5497 }, {  30,5497 }, {  31,5497 }, {  32,5497 },
 {  33,5497 }, {  34,5497 }, {  35,5497 }, {  36,5497 }, {  37,5497 },
 {  38,5497 }, {   0,   0 }, {  40,5497 }, {  41,5497 }, {  42,5497 },
 {  43,5497 }, {  44,5497 }, {  45,5497 }, {  46,5497 }, {  47,5497 },
 {  48,5497 }, {  49,5497 }, {  50,5497 }, {  51,5497 }, {  52,5497 },
 {  53,5497 }, {  54,5497 }, {  55,5497 }, {  56,5497 }, {  57,5497 },
 {  58,5497 }, {  59,5497 }, {  60,5497 }, {  61,5497 }, {  62,5497 },
 {  63,5497 }, {  64,5497 }, {  65,5497 }, {  66,5497 }, {  67,5497 },

 {  68,5497 }, {  69,5497 }, {  70,5497 }, {  71,5497 }, {  72,5497 },
 {  73,5497 }, {  74,5497 }, {  75,5497 }, {  76,5497 }, {  77,5497 },
 {  78,5497 }, {  79,5497 }, {  80,5497 }, {  81,5497 }, {  82,5497 },
 {  83,5497 }, {  84,5497 }, {  85,5497 }, {  86,5497 }, {  87,5497 },
 {  88,5497 }, {  89,5497 }, {  90,5497 }, {  91,5497 }, {   0,   0 },
 {  93,5497 }, {  94,5497 }, {  95,5497 }, {  96,5497 }, {  97,5497 },
 {  98,5497 }, {  99,5497 }, { 100,5497 }, { 101,5497 }, { 102,5497 },
 { 103,5497 }, { 104,5497 }, { 105,5497 }, { 106,5497 }, { 107,5497 },
 { 108,5497 }, { 109,5497 }, { 110,5497 }, { 111,5497 }, { 112,5497 },
 { 113,5497 }, { 114,5497 }, { 115,5497 }, { 116,5497 }, { 117,5497 },

 { 118,5497 }, { 119,5497 }, { 120,5497 }, { 121,5497 }, { 122,5497 },
 { 123,5497 }, { 124,5497 }, { 125,5497 }, { 126,5497 }, { 127,5497 },
 { 128,5497 }, { 129,5497 }, { 130,5497 }, { 131,5497 }, { 132,5497 },
 { 133,5497 }, { 134,5497 }, { 135,5497 }, { 136,5497 }, { 137,5497 },
 { 138,5497 }, { 139,5497 }, { 140,5497 }, { 141,5497 }, { 142,5497 },
 { 143,5497 }, { 144,5497 }, { 145,5497 }, { 146,5497 }, { 147,5497 },
 { 148,5497 }, { 149,5497 }, { 150,5497 }, { 151,5497 }, { 152,5497 },
 { 153,5497 }, { 154,5497 }, { 155,5497 }, { 156,5497 }, { 157,5497 },
 { 158,5497 }, { 159,5497 }, { 160,5497 }, { 161,5497 }, { 162,5497 },
 { 163,5497 }, { 164,5497 }, { 165,5497 }, { 166,5497 }, { 167,5497 },

 { 168,5497 }, { 169,5497 }, { 170,5497 }, { 171,5497 }, { 172,5497 },
 { 173,5497 }, { 174,5497 }, { 175,5497 }, { 176,5497 }, { 177,5497 },
 { 178,5497 }, { 179,5497 }, { 180,5497 }, { 181,5497 }, { 182,5497 },
 { 183,5497 }, { 184,5497 }, { 185,5497 }, { 186,5497 }, { 187,5497 },
 { 188,5497 }, { 189,5497 }, { 190,5497 }, { 191,5497 }, { 192,5497 },
 { 193,5497 }, { 194,5497 }, { 195,5497 }, { 196,5497 }, { 197,5497 },
 { 198,5497 }, { 199,5497 }, { 200,5497 }, { 201,5497 }, { 202,5497 },
 { 203,5497 }, { 204,5497 }, { 205,5497 }, { 206,5497 }, { 207,5497 },
 { 208,5497 }, { 209,5497 }, { 210,5497 }, { 211,5497 }, { 212,5497 },
 { 213,5497 }, { 214,5497 }, { 215,5497 }, { 216,5497 }, { 217,5497 },

 { 218,5497 }, { 219,5497 }, { 220,5497 }, { 221,5497 }, { 222,5497 },
 { 223,5497 }, { 224,5497 }, { 225,5497 }, { 226,5497 }, { 227,5497 },
 { 228,5497 }, { 229,5497 }, { 230,5497 }, { 231,5497 }, { 232,5497 },
 { 233,5497 }, { 234,5497 }, { 235,5497 }, { 236,5497 }, { 237,5497 },
 { 238,5497 }, { 239,5497 }, { 240,5497 }, { 241,5497 }, { 242,5497 },
 { 243,5497 }, { 244,5497 }, { 245,5497 }, { 246,5497 }, { 247,5497 },
 { 248,5497 }, { 249,5497 }, { 250,5497 }, { 251,5497 }, { 252,5497 },
 { 253,5497 }, { 254,5497 }, { 255,5497 }, { 256,5497 }, {   0,  22 },
 {   0,13401 }, {   1,5239 }, {   2,5239 }, {   3,5239 }, {   4,5239 },
 {   5,5239 }, {   6,5239 }, {   7,5239 }, {   8,5239 }, {   9,5239 },

 {  10,5239 }, {  11,5239 }, {  12,5239 }, {  13,5239 }, {  14,5239 },
 {  15,5239 }, {  16,5239 }, {  17,5239 }, {  18,5239 }, {  19,5239 },
 {  20,5239 }, {  21,5239 }, {  22,5239 }, {  23,5239 }, {  24,5239 },
 {  25,5239 }, {  26,5239 }, {  27,5239 }, {  28,5239 }, {  29,5239 },
 {  30,5239 }, {  31,5239 }, {  32,5239 }, {  33,5239 }, {  34,5239 },
 {  35,5239 }, {  36,5239 }, {  37,5239 }, {  38,5239 }, {   0,   0 },
 {  40,5239 }, {  41,5239 }, {  42,5239 }, {  43,5239 }, {  44,5239 },
 {  45,5239 }, {  46,5239 }, {  47,5239 }, {  48,5239 }, {  49,5239 },
 {  50,5239 }, {  51,5239 }, {  52,5239 }, {  53,5239 }, {  54,5239 },
 {  55,5239 }, {  56,5239 }, {  57,5239 }, {  58,5239 }, {  59,5239 },

 {  60,5239 }, {  61,5239 }, {  62,5239 }, {  63,5239 }, {  64,5239 },
 {  65,5239 }, {  66,5239 }, {  67,5239 }, {  68,5239 }, {  69,5239 },
 {  70,5239 }, {  71,5239 }, {  72,5239 }, {  73,5239 }, {  74,5239 },
 {  75,5239 }, {  76,5239 }, {  77,5239 }, {  78,5239 }, {  79,5239 },
 {  80,5239 }, {  81,5239 }, {  82,5239 }, {  83,5239 }, {  84,5239 },
 {  85,5239 }, {  86,5239 }, {  87,5239 }, {  88,5239 }, {  89,5239 },
 {  90,5239 }, {  91,5239 }, {   0,   0 }, {  93,5239 }, {  94,5239 },
 {  95,5239 }, {  96,5239 }, {  97,5239 }, {  98,5239 }, {  99,5239 },
 { 100,5239 }, { 101,5239 }, { 102,5239 }, { 103,5239 }, { 104,5239 },
 { 105,5239 }, { 106,5239 }, { 107,5239 }, { 108,5239 }, { 109,5239 },

 { 110,5239 }, { 111,5239 }, { 112,5239 }, { 113,5239 }, { 114,5239 },
 { 115,5239 }, { 116,5239 }, { 117,5239 }, { 118,5239 }, { 119,5239 },
 { 120,5239 }, { 121,5239 }, { 122,5239 }, { 123,5239 }, { 124,5239 },
 { 125,5239 }, { 126,5239 }, { 127,5239 }, { 128,5239 }, { 129,5239 },
 { 130,5239 }, { 131,5239 }, { 132,5239 }, { 133,5239 }, { 134,5239 },
 { 135,5239 }, { 136,5239 }, { 137,5239 }, { 138,5239 }, { 139,5239 },
 { 140,5239 }, { 141,5239 }, { 142,5239 }, { 143,5239 }, { 144,5239 },
 { 145,5239 }, { 146,5239 }, { 147,5239 }, { 148,5239 }, { 149,5239 },
 { 150,5239 }, { 151,5239 }, { 152,5239 }, { 153,5239 }, { 154,5239 },
 { 155,5239 }, { 156,5239 }, { 157,5239 }, { 158,5239 }, { 159,5239 },

 { 160,5239 }, { 161,5239 }, { 162,5239 }, { 163,5239 }, { 164,5239 },
 { 165,5239 }, { 166,5239 }, { 167,5239 }, { 168,5239 }, { 169,5239 },
 { 170,5239 }, { 171,5239 }, { 172,5239 }, { 173,5239 }, { 174,5239 },
 { 175,5239 }, { 176,5239 }, { 177,5239 }, { 178,5239 }, { 179,5239 },
 { 180,5239 }, { 181,5239 }, { 182,5239 }, { 183,5239 }, { 184,5239 },
 { 185,5239 }, { 186,5239 }, { 187,5239 }, { 188,5239 }, { 189,5239 },
 { 190,5239 }, { 191,5239 }, { 192,5239 }, { 193,5239 }, { 194,5239 },
 { 195,5239 }, { 196,5239 }, { 197,5239 }, { 198,5239 }, { 199,5239 },
 { 200,5239 }, { 201,5239 }, { 202,5239 }, { 203,5239 }, { 204,5239 },
 { 205,5239 }, { 206,5239 }, { 207,5239 }, { 208,5239 }, { 209,5239 },

 { 210,5239 }, { 211,5239 }, { 212,5239 }, { 213,5239 }, { 214,5239 },
 { 215,5239 }, { 216,5239 }, { 217,5239 }, { 218,5239 }, { 219,5239 },
 { 220,5239 }, { 221,5239 }, { 222,5239 }, { 223,5239 }, { 224,5239 },
 { 225,5239 }, { 226,5239 }, { 227,5239 }, { 228,5239 }, { 229,5239 },
 { 230,5239 }, { 231,5239 }, { 232,5239 }, { 233,5239 }, { 234,5239 },
 { 235,5239 }, { 236,5239 }, { 237,5239 }, { 238,5239 }, { 239,5239 },
 { 240,5239 }, { 241,5239 }, { 242,5239 }, { 243,5239 }, { 244,5239 },
 { 245,5239 }, { 246,5239 }, { 247,5239 }, { 248,5239 }, { 249,5239 },
 { 250,5239 }, { 251,5239 }, { 252,5239 }, { 253,5239 }, { 254,5239 },
 { 255,5239 }, { 256,5239 }, {   0,  31 }, {   0,13143 }, {   1,-4322 },

 {   2,-4322 }, {   3,-4322 }, {   4,-4322 }, {   5,-4322 }, {   6,-4322 },
 {   7,-4322 }, {   8,-4322 }, {   9,-4322 }, {  10,-4322 }, {  11,-4322 },
 {  12,-4322 }, {  13,-4322 }, {  14,-4322 }, {  15,-4322 }, {  16,-4322 },
 {  17,-4322 }, {  18,-4322 }, {  19,-4322 }, {  20,-4322 }, {  21,-4322 },
 {  22,-4322 }, {  23,-4322 }, {  24,-4322 }, {  25,-4322 }, {  26,-4322 },
 {  27,-4322 }, {  28,-4322 }, {  29,-4322 }, {  30,-4322 }, {  31,-4322 },
 {  32,-4322 }, {  33,-4322 }, {  34,-4322 }, {  35,-4322 }, {  36,-4322 },
 {  37,-4322 }, {  38,-4322 }, {  39,-4322 }, {  40,-4322 }, {  41,-4322 },
 {  42,-4322 }, {  43,-4322 }, {  44,-4322 }, {  45,-4322 }, {  46,-4322 },
 {  47,-4322 }, {  48,5239 }, {  49,5239 }, {  50,5239 }, {  51,5239 },

 {  52,5239 }, {  53,5239 }, {  54,5239 }, {  55,5239 }, {  56,-4322 },
 {  57,-4322 }, {  58,-4322 }, {  59,-4322 }, {  60,-4322 }, {  61,-4322 },
 {  62,-4322 }, {  63,-4322 }, {  64,-4322 }, {  65,-4322 }, {  66,-4322 },
 {  67,-4322 }, {  68,-4322 }, {  69,-4322 }, {  70,-4322 }, {  71,-4322 },
 {  72,-4322 }, {  73,-4322 }, {  74,-4322 }, {  75,-4322 }, {  76,-4322 },
 {  77,-4322 }, {  78,-4322 }, {  79,-4322 }, {  80,-4322 }, {  81,-4322 },
 {  82,-4322 }, {  83,-4322 }, {  84,-4322 }, {  85,5247 }, {  86,-4322 },
 {  87,-4322 }, {  88,-4322 }, {  89,-4322 }, {  90,-4322 }, {  91,-4322 },
 {  92,-4322 }, {  93,-4322 }, {  94,-4322 }, {  95,-4322 }, {  96,-4322 },
 {  97,-4322 }, {  98,-4322 }, {  99,-4322 }, { 100,-4322 }, { 101,-4322 },

 { 102,-4322 }, { 103,-4322 }, { 104,-4322 }, { 105,-4322 }, { 106,-4322 },
 { 107,-4322 }, { 108,-4322 }, { 109,-4322 }, { 110,-4322 }, { 111,-4322 },
 { 112,-4322 }, { 113,-4322 }, { 114,-4322 }, { 115,-4322 }, { 116,-4322 },
 { 117,5270 }, { 118,-4322 }, { 119,-4322 }, { 120,5308 }, { 121,-4322 },
 { 122,-4322 }, { 123,-4322 }, { 124,-4322 }, { 125,-4322 }, { 126,-4322 },
 { 127,-4322 }, { 128,-4322 }, { 129,-4322 }, { 130,-4322 }, { 131,-4322 },
 { 132,-4322 }, { 133,-4322 }, { 134,-4322 }, { 135,-4322 }, { 136,-4322 },
 { 137,-4322 }, { 138,-4322 }, { 139,-4322 }, { 140,-4322 }, { 141,-4322 },
 { 142,-4322 }, { 143,-4322 }, { 144,-4322 }, { 145,-4322 }, { 146,-4322 },
 { 147,-4322 }, { 148,-4322 }, { 149,-4322 }, { 150,-4322 }, { 151,-4322 },

 { 152,-4322 }, { 153,-4322 }, { 154,-4322 }, { 155,-4322 }, { 156,-4322 },
 { 157,-4322 }, { 158,-4322 }, { 159,-4322 }, { 160,-4322 }, { 161,-4322 },
 { 162,-4322 }, { 163,-4322 }, { 164,-4322 }, { 165,-4322 }, { 166,-4322 },
 { 167,-4322 }, { 168,-4322 }, { 169,-4322 }, { 170,-4322 }, { 171,-4322 },
 { 172,-4322 }, { 173,-4322 }, { 174,-4322 }, { 175,-4322 }, { 176,-4322 },
 { 177,-4322 }, { 178,-4322 }, { 179,-4322 }, { 180,-4322 }, { 181,-4322 },
 { 182,-4322 }, { 183,-4322 }, { 184,-4322 }, { 185,-4322 }, { 186,-4322 },
 { 187,-4322 }, { 188,-4322 }, { 189,-4322 }, { 190,-4322 }, { 191,-4322 },
 { 192,-4322 }, { 193,-4322 }, { 194,-4322 }, { 195,-4322 }, { 196,-4322 },
 { 197,-4322 }, { 198,-4322 }, { 199,-4322 }, { 200,-4322 }, { 201,-4322 },

 { 202,-4322 }, { 203,-4322 }, { 204,-4322 }, { 205,-4322 }, { 206,-4322 },
 { 207,-4322 }, { 208,-4322 }, { 209,-4322 }, { 210,-4322 }, { 211,-4322 },
 { 212,-4322 }, { 213,-4322 }, { 214,-4322 }, { 215,-4322 }, { 216,-4322 },
 { 217,-4322 }, { 218,-4322 }, { 219,-4322 }, { 220,-4322 }, { 221,-4322 },
 { 222,-4322 }, { 223,-4322 }, { 224,-4322 }, { 225,-4322 }, { 226,-4322 },
 { 227,-4322 }, { 228,-4322 }, { 229,-4322 }, { 230,-4322 }, { 231,-4322 },
 { 232,-4322 }, { 233,-4322 }, { 234,-4322 }, { 235,-4322 }, { 236,-4322 },
 { 237,-4322 }, { 238,-4322 }, { 239,-4322 }, { 240,-4322 }, { 241,-4322 },
 { 242,-4322 }, { 243,-4322 }, { 244,-4322 }, { 245,-4322 }, { 246,-4322 },
 { 247,-4322 }, { 248,-4322 }, { 249,-4322 }, { 250,-4322 }, { 251,-4322 },

 { 252,-4322 }, { 253,-4322 }, { 254,-4322 }, { 255,-4322 }, { 256,-4322 },
 {   0,  35 }, {   0,12885 }, {   1,5154 }, {   2,5154 }, {   3,5154 },
 {   4,5154 }, {   5,5154 }, {   6,5154 }, {   7,5154 }, {   8,5154 },
 {   9,5154 }, {  10,5154 }, {  11,5154 }, {  12,5154 }, {  13,5154 },
 {  14,5154 }, {  15,5154 }, {  16,5154 }, {  17,5154 }, {  18,5154 },
 {  19,5154 }, {  20,5154 }, {  21,5154 }, {  22,5154 }, {  23,5154 },
 {  24,5154 }, {  25,5154 }, {  26,5154 }, {  27,5154 }, {  28,5154 },
 {  29,5154 }, {  30,5154 }, {  31,5154 }, {  32,5154 }, {  33,5154 },
 {  34,5154 }, {  35,5154 }, {   0,   0 }, {  37,5154 }, {  38,5154 },
 {  39,5154 }, {  40,5154 }, {  41,5154 }, {  42,5154 }, {  43,5154 },

 {  44,5154 }, {  45,5154 }, {  46,5154 }, {  47,5154 }, {  48,5154 },
 {  49,5154 }, {  50,5154 }, {  51,5154 }, {  52,5154 }, {  53,5154 },
 {  54,5154 }, {  55,5154 }, {  56,5154 }, {  57,5154 }, {  58,5154 },
 {  59,5154 }, {  60,5154 }, {  61,5154 }, {  62,5154 }, {  63,5154 },
 {  64,5154 }, {  65,5154 }, {  66,5154 }, {  67,5154 }, {  68,5154 },
 {  69,5154 }, {  70,5154 }, {  71,5154 }, {  72,5154 }, {  73,5154 },
 {  74,5154 }, {  75,5154 }, {  76,5154 }, {  77,5154 }, {  78,5154 },
 {  79,5154 }, {  80,5154 }, {  81,5154 }, {  82,5154 }, {  83,5154 },
 {  84,5154 }, {  85,5154 }, {  86,5154 }, {  87,5154 }, {  88,5154 },
 {  89,5154 }, {  90,5154 }, {  91,5154 }, {  92,5154 }, {  93,5154 },

 {  94,5154 }, {  95,5154 }, {  96,5154 }, {  97,5154 }, {  98,5154 },
 {  99,5154 }, { 100,5154 }, { 101,5154 }, { 102,5154 }, { 103,5154 },
 { 104,5154 }, { 105,5154 }, { 106,5154 }, { 107,5154 }, { 108,5154 },
 { 109,5154 }, { 110,5154 }, { 111,5154 }, { 112,5154 }, { 113,5154 },
 { 114,5154 }, { 115,5154 }, { 116,5154 }, { 117,5154 }, { 118,5154 },
 { 119,5154 }, { 120,5154 }, { 121,5154 }, { 122,5154 }, { 123,5154 },
 { 124,5154 }, { 125,5154 }, { 126,5154 }, { 127,5154 }, { 128,5154 },
 { 129,5154 }, { 130,5154 }, { 131,5154 }, { 132,5154 }, { 133,5154 },
 { 134,5154 }, { 135,5154 }, { 136,5154 }, { 137,5154 }, { 138,5154 },
 { 139,5154 }, { 140,5154 }, { 141,5154 }, { 142,5154 }, { 143,5154 },

 { 144,5154 }, { 145,5154 }, { 146,5154 }, { 147,5154 }, { 148,5154 },
 { 149,5154 }, { 150,5154 }, { 151,5154 }, { 152,5154 }, { 153,5154 },
 { 154,5154 }, { 155,5154 }, { 156,5154 }, { 157,5154 }, { 158,5154 },
 { 159,5154 }, { 160,5154 }, { 161,5154 }, { 162,5154 }, { 163,5154 },
 { 164,5154 }, { 165,5154 }, { 166,5154 }, { 167,5154 }, { 168,5154 },
 { 169,5154 }, { 170,5154 }, { 171,5154 }, { 172,5154 }, { 173,5154 },
 { 174,5154 }, { 175,5154 }, { 176,5154 }, { 177,5154 }, { 178,5154 },
 { 179,5154 }, { 180,5154 }, { 181,5154 }, { 182,5154 }, { 183,5154 },
 { 184,5154 }, { 185,5154 }, { 186,5154 }, { 187,5154 }, { 188,5154 },
 { 189,5154 }, { 190,5154 }, { 191,5154 }, { 192,5154 }, { 193,5154 },

 { 194,5154 }, { 195,5154 }, { 196,5154 }, { 197,5154 }, { 198,5154 },
 { 199,5154 }, { 200,5154 }, { 201,5154 }, { 202,5154 }, { 203,5154 },
 { 204,5154 }, { 205,5154 }, { 206,5154 }, { 207,5154 }, { 208,5154 },
 { 209,5154 }, { 210,5154 }, { 211,5154 }, { 212,5154 }, { 213,5154 },
 { 214,5154 }, { 215,5154 }, { 216,5154 }, { 217,5154 }, { 218,5154 },
 { 219,5154 }, { 220,5154 }, { 221,5154 }, { 222,5154 }, { 223,5154 },
 { 224,5154 }, { 225,5154 }, { 226,5154 }, { 227,5154 }, { 228,5154 },
 { 229,5154 }, { 230,5154 }, { 231,5154 }, { 232,5154 }, { 233,5154 },
 { 234,5154 }, { 235,5154 }, { 236,5154 }, { 237,5154 }, { 238,5154 },
 { 239,5154 }, { 240,5154 }, { 241,5154 }, { 242,5154 }, { 243,5154 },

 { 244,5154 }, { 245,5154 }, { 246,5154 }, { 247,5154 }, { 248,5154 },
 { 249,5154 }, { 250,5154 }, { 251,5154 }, { 252,5154 }, { 253,5154 },
 { 254,5154 }, { 255,5154 }, { 256,5154 }, {   0,  35 }, {   0,12627 },
 {   1,4896 }, {   2,4896 }, {   3,4896 }, {   4,4896 }, {   5,4896 },
 {   6,4896 }, {   7,4896 }, {   8,4896 }, {   9,4896 }, {  10,4896 },
 {  11,4896 }, {  12,4896 }, {  13,4896 }, {  14,4896 }, {  15,4896 },
 {  16,4896 }, {  17,4896 }, {  18,4896 }, {  19,4896 }, {  20,4896 },
 {  21,4896 }, {  22,4896 }, {  23,4896 }, {  24,4896 }, {  25,4896 },
 {  26,4896 }, {  27,4896 }, {  28,4896 }, {  29,4896 }, {  30,4896 },
 {  31,4896 }, {  32,4896 }, {  33,4896 }, {  34,4896 }, {  35,4896 },

 {   0,   0 }, {  37,4896 }, {  38,4896 }, {  39,4896 }, {  40,4896 },
 {  41,4896 }, {  42,4896 }, {  43,4896 }, {  44,4896 }, {  45,4896 },
 {  46,4896 }, {  47,4896 }, {  48,4896 }, {  49,4896 }, {  50,4896 },
 {  51,4896 }, {  52,4896 }, {  53,4896 }, {  54,4896 }, {  55,4896 },
 {  56,4896 }, {  57,4896 }, {  58,4896 }, {  59,4896 }, {  60,4896 },
 {  61,4896 }, {  62,4896 }, {  63,4896 }, {  64,4896 }, {  65,4896 },
 {  66,4896 }, {  67,4896 }, {  68,4896 }, {  69,4896 }, {  70,4896 },
 {  71,4896 }, {  72,4896 }, {  73,4896 }, {  74,4896 }, {  75,4896 },
 {  76,4896 }, {  77,4896 }, {  78,4896 }, {  79,4896 }, {  80,4896 },
 {  81,4896 }, {  82,4896 }, {  83,4896 }, {  84,4896 }, {  85,4896 },

 {  86,4896 }, {  87,4896 }, {  88,4896 }, {  89,4896 }, {  90,4896 },
 {  91,4896 }, {  92,4896 }, {  93,4896 }, {  94,4896 }, {  95,4896 },
 {  96,4896 }, {  97,4896 }, {  98,4896 }, {  99,4896 }, { 100,4896 },
 { 101,4896 }, { 102,4896 }, { 103,4896 }, { 104,4896 }, { 105,4896 },
 { 106,4896 }, { 107,4896 }, { 108,4896 }, { 109,4896 }, { 110,4896 },
 { 111,4896 }, { 112,4896 }, { 113,4896 }, { 114,4896 }, { 115,4896 },
 { 116,4896 }, { 117,4896 }, { 118,4896 }, { 119,4896 }, { 120,4896 },
 { 121,4896 }, { 122,4896 }, { 123,4896 }, { 124,4896 }, { 125,4896 },
 { 126,4896 }, { 127,4896 }, { 128,4896 }, { 129,4896 }, { 130,4896 },
 { 131,4896 }, { 132,4896 }, { 133,4896 }, { 134,4896 }, { 135,4896 },

 { 136,4896 }, { 137,4896 }, { 138,4896 }, { 139,4896 }, { 140,4896 },
 { 141,4896 }, { 142,4896 }, { 143,4896 }, { 144,4896 }, { 145,4896 },
 { 146,4896 }, { 147,4896 }, { 148,4896 }, { 149,4896 }, { 150,4896 },
 { 151,4896 }, { 152,4896 }, { 153,4896 }, { 154,4896 }, { 155,4896 },
 { 156,4896 }, { 157,4896 }, { 158,4896 }, { 159,4896 }, { 160,4896 },
 { 161,4896 }, { 162,4896 }, { 163,4896 }, { 164,4896 }, { 165,4896 },
 { 166,4896 }, { 167,4896 }, { 168,4896 }, { 169,4896 }, { 170,4896 },
 { 171,4896 }, { 172,4896 }, { 173,4896 }, { 174,4896 }, { 175,4896 },
 { 176,4896 }, { 177,4896 }, { 178,4896 }, { 179,4896 }, { 180,4896 },
 { 181,4896 }, { 182,4896 }, { 183,4896 }, { 184,4896 }, { 185,4896 },

 { 186,4896 }, { 187,4896 }, { 188,4896 }, { 189,4896 }, { 190,4896 },
 { 191,4896 }, { 192,4896 }, { 193,4896 }, { 194,4896 }, { 195,4896 },
 { 196,4896 }, { 197,4896 }, { 198,4896 }, { 199,4896 }, { 200,4896 },
 { 201,4896 }, { 202,4896 }, { 203,4896 }, { 204,4896 }, { 205,4896 },
 { 206,4896 }, { 207,4896 }, { 208,4896 }, { 209,4896 }, { 210,4896 },
 { 211,4896 }, { 212,4896 }, { 213,4896 }, { 214,4896 }, { 215,4896 },
 { 216,4896 }, { 217,4896 }, { 218,4896 }, { 219,4896 }, { 220,4896 },
 { 221,4896 }, { 222,4896 }, { 223,4896 }, { 224,4896 }, { 225,4896 },
 { 226,4896 }, { 227,4896 }, { 228,4896 }, { 229,4896 }, { 230,4896 },
 { 231,4896 }, { 232,4896 }, { 233,4896 }, { 234,4896 }, { 235,4896 },

 { 236,4896 }, { 237,4896 }, { 238,4896 }, { 239,4896 }, { 240,4896 },
 { 241,4896 }, { 242,4896 }, { 243,4896 }, { 244,4896 }, { 245,4896 },
 { 246,4896 }, { 247,4896 }, { 248,4896 }, { 249,4896 }, { 250,4896 },
 { 251,4896 }, { 252,4896 }, { 253,4896 }, { 254,4896 }, { 255,4896 },
 { 256,4896 }, {   0,  37 }, {   0,12369 }, {   0,   1 }, {   0,12367 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,   0 }, {  10,   0 },
 {   0,   0 }, {  12,   0 }, {  13,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  32,   0 }, {   0,   0 }, {  36,-5094 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,4896 }, {  66,4896 }, {  67,4896 },
 {  68,4896 }, {  69,4896 }, {  70,4896 }, {  71,4896 }, {  72,4896 },
 {  73,4896 }, {  74,4896 }, {  75,4896 }, {  76,4896 }, {  77,4896 },

 {  78,4896 }, {  79,4896 }, {  80,4896 }, {  81,4896 }, {  82,4896 },
 {  83,4896 }, {  84,4896 }, {  85,4896 }, {  86,4896 }, {  87,4896 },
 {  88,4896 }, {  89,4896 }, {  90,4896 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,4896 }, {   0,   0 }, {  97,4896 },
 {  98,4896 }, {  99,4896 }, { 100,4896 }, { 101,4896 }, { 102,4896 },
 { 103,4896 }, { 104,4896 }, { 105,4896 }, { 106,4896 }, { 107,4896 },
 { 108,4896 }, { 109,4896 }, { 110,4896 }, { 111,4896 }, { 112,4896 },
 { 113,4896 }, { 114,4896 }, { 115,4896 }, { 116,4896 }, { 117,4896 },
 { 118,4896 }, { 119,4896 }, { 120,4896 }, { 121,4896 }, { 122,4896 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 { 128,4896 }, { 129,4896 }, { 130,4896 }, { 131,4896 }, { 132,4896 },
 { 133,4896 }, { 134,4896 }, { 135,4896 }, { 136,4896 }, { 137,4896 },
 { 138,4896 }, { 139,4896 }, { 140,4896 }, { 141,4896 }, { 142,4896 },
 { 143,4896 }, { 144,4896 }, { 145,4896 }, { 146,4896 }, { 147,4896 },
 { 148,4896 }, { 149,4896 }, { 150,4896 }, { 151,4896 }, { 152,4896 },
 { 153,4896 }, { 154,4896 }, { 155,4896 }, { 156,4896 }, { 157,4896 },
 { 158,4896 }, { 159,4896 }, { 160,4896 }, { 161,4896 }, { 162,4896 },
 { 163,4896 }, { 164,4896 }, { 165,4896 }, { 166,4896 }, { 167,4896 },
 { 168,4896 }, { 169,4896 }, { 170,4896 }, { 171,4896 }, { 172,4896 },
 { 173,4896 }, { 174,4896 }, { 175,4896 }, { 176,4896 }, { 177,4896 },

 { 178,4896 }, { 179,4896 }, { 180,4896 }, { 181,4896 }, { 182,4896 },
 { 183,4896 }, { 184,4896 }, { 185,4896 }, { 186,4896 }, { 187,4896 },
 { 188,4896 }, { 189,4896 }, { 190,4896 }, { 191,4896 }, { 192,4896 },
 { 193,4896 }, { 194,4896 }, { 195,4896 }, { 196,4896 }, { 197,4896 },
 { 198,4896 }, { 199,4896 }, { 200,4896 }, { 201,4896 }, { 202,4896 },
 { 203,4896 }, { 204,4896 }, { 205,4896 }, { 206,4896 }, { 207,4896 },
 { 208,4896 }, { 209,4896 }, { 210,4896 }, { 211,4896 }, { 212,4896 },
 { 213,4896 }, { 214,4896 }, { 215,4896 }, { 216,4896 }, { 217,4896 },
 { 218,4896 }, { 219,4896 }, { 220,4896 }, { 221,4896 }, { 222,4896 },
 { 223,4896 }, { 224,4896 }, { 225,4896 }, { 226,4896 }, { 227,4896 },

 { 228,4896 }, { 229,4896 }, { 230,4896 }, { 231,4896 }, { 232,4896 },
 { 233,4896 }, { 234,4896 }, { 235,4896 }, { 236,4896 }, { 237,4896 },
 { 238,4896 }, { 239,4896 }, { 240,4896 }, { 241,4896 }, { 242,4896 },
 { 243,4896 }, { 244,4896 }, { 245,4896 }, { 246,4896 }, { 247,4896 },
 { 248,4896 }, { 249,4896 }, { 250,4896 }, { 251,4896 }, { 252,4896 },
 { 253,4896 }, { 254,4896 }, { 255,4896 }, {   0,  54 }, {   0,12112 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  52 },
 {   0,12101 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  33,   0 }, {   0,   0 }, {  35,   0 },
 {   0,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  42,   0 }, {  43,   0 }, {  33, -11 }, {  45,   0 },
 {  35, -11 }, {  47,   0 }, {  37, -11 }, {  38, -11 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42, -11 }, {  43, -11 }, {   0,   0 },
 {  45, -11 }, {   0,   0 }, {  47, -11 }, {   0,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  60, -11 }, {  61, -11 }, {  62, -11 }, {  63, -11 }, {  64, -11 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  55 }, {   0,12022 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,   0 }, {   0,   0 },
 {  96,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94, -11 },
 {   0,   0 }, {  96, -11 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,   0 }, {   0,   0 },
 { 126,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124, -11 },
 {   0,   0 }, { 126, -11 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-5438 },
 {  66,-5438 }, {  67,-5438 }, {  68,-5438 }, {  69,-5438 }, {  70,-5438 },
 {  71,-5438 }, {  72,-5438 }, {  73,-5438 }, {  74,-5438 }, {  75,-5438 },
 {  76,-5438 }, {  77,-5438 }, {  78,-5438 }, {  79,-5438 }, {  80,-5438 },

 {  81,-5438 }, {  82,-5438 }, {  83,-5438 }, {  84,-5438 }, {  85,-5438 },
 {  86,-5438 }, {  87,-5438 }, {  88,-5438 }, {  89,-5438 }, {  90,-5438 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,-5438 },
 {   0,   0 }, {  97,-5438 }, {  98,-5438 }, {  99,-5438 }, { 100,-5438 },
 { 101,-5438 }, { 102,-5438 }, { 103,-5438 }, { 104,-5438 }, { 105,-5438 },
 { 106,-5438 }, { 107,-5438 }, { 108,-5438 }, { 109,-5438 }, { 110,-5438 },
 { 111,-5438 }, { 112,-5438 }, { 113,-5438 }, { 114,-5438 }, { 115,-5438 },
 { 116,-5438 }, { 117,-5438 }, { 118,-5438 }, { 119,-5438 }, { 120,-5438 },
 { 121,-5438 }, { 122,-5438 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,-5438 }, { 129,-5438 }, { 130,-5438 },

 { 131,-5438 }, { 132,-5438 }, { 133,-5438 }, { 134,-5438 }, { 135,-5438 },
 { 136,-5438 }, { 137,-5438 }, { 138,-5438 }, { 139,-5438 }, { 140,-5438 },
 { 141,-5438 }, { 142,-5438 }, { 143,-5438 }, { 144,-5438 }, { 145,-5438 },
 { 146,-5438 }, { 147,-5438 }, { 148,-5438 }, { 149,-5438 }, { 150,-5438 },
 { 151,-5438 }, { 152,-5438 }, { 153,-5438 }, { 154,-5438 }, { 155,-5438 },
 { 156,-5438 }, { 157,-5438 }, { 158,-5438 }, { 159,-5438 }, { 160,-5438 },
 { 161,-5438 }, { 162,-5438 }, { 163,-5438 }, { 164,-5438 }, { 165,-5438 },
 { 166,-5438 }, { 167,-5438 }, { 168,-5438 }, { 169,-5438 }, { 170,-5438 },
 { 171,-5438 }, { 172,-5438 }, { 173,-5438 }, { 174,-5438 }, { 175,-5438 },
 { 176,-5438 }, { 177,-5438 }, { 178,-5438 }, { 179,-5438 }, { 180,-5438 },

 { 181,-5438 }, { 182,-5438 }, { 183,-5438 }, { 184,-5438 }, { 185,-5438 },
 { 186,-5438 }, { 187,-5438 }, { 188,-5438 }, { 189,-5438 }, { 190,-5438 },
 { 191,-5438 }, { 192,-5438 }, { 193,-5438 }, { 194,-5438 }, { 195,-5438 },
 { 196,-5438 }, { 197,-5438 }, { 198,-5438 }, { 199,-5438 }, { 200,-5438 },
 { 201,-5438 }, { 202,-5438 }, { 203,-5438 }, { 204,-5438 }, { 205,-5438 },
 { 206,-5438 }, { 207,-5438 }, { 208,-5438 }, { 209,-5438 }, { 210,-5438 },
 { 211,-5438 }, { 212,-5438 }, { 213,-5438 }, { 214,-5438 }, { 215,-5438 },
 { 216,-5438 }, { 217,-5438 }, { 218,-5438 }, { 219,-5438 }, { 220,-5438 },
 { 221,-5438 }, { 222,-5438 }, { 223,-5438 }, { 224,-5438 }, { 225,-5438 },
 { 226,-5438 }, { 227,-5438 }, { 228,-5438 }, { 229,-5438 }, { 230,-5438 },

 { 231,-5438 }, { 232,-5438 }, { 233,-5438 }, { 234,-5438 }, { 235,-5438 },
 { 236,-5438 }, { 237,-5438 }, { 238,-5438 }, { 239,-5438 }, { 240,-5438 },
 { 241,-5438 }, { 242,-5438 }, { 243,-5438 }, { 244,-5438 }, { 245,-5438 },
 { 246,-5438 }, { 247,-5438 }, { 248,-5438 }, { 249,-5438 }, { 250,-5438 },
 { 251,-5438 }, { 252,-5438 }, { 253,-5438 }, { 254,-5438 }, { 255,-5438 },
 {   0,  33 }, {   0,11765 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  36,-6058 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,4631 },
 {  49,4631 }, {  50,4631 }, {  51,4631 }, {  52,4631 }, {  53,4631 },
 {  54,4631 }, {  55,4631 }, {  56,4631 }, {  57,4631 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,4631 }, {  66,4631 }, {  67,4631 }, {  68,4631 },
 {  69,4631 }, {  70,4631 }, {  71,4631 }, {  72,4631 }, {  73,4631 },

 {  74,4631 }, {  75,4631 }, {  76,4631 }, {  77,4631 }, {  78,4631 },
 {  79,4631 }, {  80,4631 }, {  81,4631 }, {  82,4631 }, {  83,4631 },
 {  84,4631 }, {  85,4631 }, {  86,4631 }, {  87,4631 }, {  88,4631 },
 {  89,4631 }, {  90,4631 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,4631 }, {   0,   0 }, {  97,4631 }, {  98,4631 },
 {  99,4631 }, { 100,4631 }, { 101,4631 }, { 102,4631 }, { 103,4631 },
 { 104,4631 }, { 105,4631 }, { 106,4631 }, { 107,4631 }, { 108,4631 },
 { 109,4631 }, { 110,4631 }, { 111,4631 }, { 112,4631 }, { 113,4631 },
 { 114,4631 }, { 115,4631 }, { 116,4631 }, { 117,4631 }, { 118,4631 },
 { 119,4631 }, { 120,4631 }, { 121,4631 }, { 122,4631 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,4631 },
 { 129,4631 }, { 130,4631 }, { 131,4631 }, { 132,4631 }, { 133,4631 },
 { 134,4631 }, { 135,4631 }, { 136,4631 }, { 137,4631 }, { 138,4631 },
 { 139,4631 }, { 140,4631 }, { 141,4631 }, { 142,4631 }, { 143,4631 },
 { 144,4631 }, { 145,4631 }, { 146,4631 }, { 147,4631 }, { 148,4631 },
 { 149,4631 }, { 150,4631 }, { 151,4631 }, { 152,4631 }, { 153,4631 },
 { 154,4631 }, { 155,4631 }, { 156,4631 }, { 157,4631 }, { 158,4631 },
 { 159,4631 }, { 160,4631 }, { 161,4631 }, { 162,4631 }, { 163,4631 },
 { 164,4631 }, { 165,4631 }, { 166,4631 }, { 167,4631 }, { 168,4631 },
 { 169,4631 }, { 170,4631 }, { 171,4631 }, { 172,4631 }, { 173,4631 },

 { 174,4631 }, { 175,4631 }, { 176,4631 }, { 177,4631 }, { 178,4631 },
 { 179,4631 }, { 180,4631 }, { 181,4631 }, { 182,4631 }, { 183,4631 },
 { 184,4631 }, { 185,4631 }, { 186,4631 }, { 187,4631 }, { 188,4631 },
 { 189,4631 }, { 190,4631 }, { 191,4631 }, { 192,4631 }, { 193,4631 },
 { 194,4631 }, { 195,4631 }, { 196,4631 }, { 197,4631 }, { 198,4631 },
 { 199,4631 }, { 200,4631 }, { 201,4631 }, { 202,4631 }, { 203,4631 },
 { 204,4631 }, { 205,4631 }, { 206,4631 }, { 207,4631 }, { 208,4631 },
 { 209,4631 }, { 210,4631 }, { 211,4631 }, { 212,4631 }, { 213,4631 },
 { 214,4631 }, { 215,4631 }, { 216,4631 }, { 217,4631 }, { 218,4631 },
 { 219,4631 }, { 220,4631 }, { 221,4631 }, { 222,4631 }, { 223,4631 },

 { 224,4631 }, { 225,4631 }, { 226,4631 }, { 227,4631 }, { 228,4631 },
 { 229,4631 }, { 230,4631 }, { 231,4631 }, { 232,4631 }, { 233,4631 },
 { 234,4631 }, { 235,4631 }, { 236,4631 }, { 237,4631 }, { 238,4631 },
 { 239,4631 }, { 240,4631 }, { 241,4631 }, { 242,4631 }, { 243,4631 },
 { 244,4631 }, { 245,4631 }, { 246,4631 }, { 247,4631 }, { 248,4631 },
 { 249,4631 }, { 250,4631 }, { 251,4631 }, { 252,4631 }, { 253,4631 },
 { 254,4631 }, { 255,4631 }, {   0,   1 }, {   0,11508 }, {   1,4631 },
 {   2,4631 }, {   3,4631 }, {   4,4631 }, {   5,4631 }, {   6,4631 },
 {   7,4631 }, {   8,4631 }, {   9,4631 }, {   0,   0 }, {  11,4631 },
 {  12,4631 }, {   0,   0 }, {  14,4631 }, {  15,4631 }, {  16,4631 },

 {  17,4631 }, {  18,4631 }, {  19,4631 }, {  20,4631 }, {  21,4631 },
 {  22,4631 }, {  23,4631 }, {  24,4631 }, {  25,4631 }, {  26,4631 },
 {  27,4631 }, {  28,4631 }, {  29,4631 }, {  30,4631 }, {  31,4631 },
 {  32,4631 }, {  33,4889 }, {  34,4631 }, {  35,4889 }, {  36,4631 },
 {  37,4889 }, {  38,4889 }, {  39,4631 }, {  40,4631 }, {  41,4631 },
 {  42,4889 }, {  43,4889 }, {  44,4631 }, {  45,4889 }, {  46,4631 },
 {  47,4889 }, {  48,4631 }, {  49,4631 }, {  50,4631 }, {  51,4631 },
 {  52,4631 }, {  53,4631 }, {  54,4631 }, {  55,4631 }, {  56,4631 },
 {  57,4631 }, {  58,4631 }, {  59,4631 }, {  60,4889 }, {  61,4889 },
 {  62,4889 }, {  63,4889 }, {  64,4889 }, {  65,4631 }, {  66,4631 },

 {  67,4631 }, {  68,4631 }, {  69,4631 }, {  70,4631 }, {  71,4631 },
 {  72,4631 }, {  73,4631 }, {  74,4631 }, {  75,4631 }, {  76,4631 },
 {  77,4631 }, {  78,4631 }, {  79,4631 }, {  80,4631 }, {  81,4631 },
 {  82,4631 }, {  83,4631 }, {  84,4631 }, {  85,4631 }, {  86,4631 },
 {  87,4631 }, {  88,4631 }, {  89,4631 }, {  90,4631 }, {  91,4631 },
 {  92,4631 }, {  93,4631 }, {  94,4889 }, {  95,4631 }, {  96,4889 },
 {  97,4631 }, {  98,4631 }, {  99,4631 }, { 100,4631 }, { 101,4631 },
 { 102,4631 }, { 103,4631 }, { 104,4631 }, { 105,4631 }, { 106,4631 },
 { 107,4631 }, { 108,4631 }, { 109,4631 }, { 110,4631 }, { 111,4631 },
 { 112,4631 }, { 113,4631 }, { 114,4631 }, { 115,4631 }, { 116,4631 },

 { 117,4631 }, { 118,4631 }, { 119,4631 }, { 120,4631 }, { 121,4631 },
 { 122,4631 }, { 123,4631 }, { 124,4889 }, { 125,4631 }, { 126,4889 },
 { 127,4631 }, { 128,4631 }, { 129,4631 }, { 130,4631 }, { 131,4631 },
 { 132,4631 }, { 133,4631 }, { 134,4631 }, { 135,4631 }, { 136,4631 },
 { 137,4631 }, { 138,4631 }, { 139,4631 }, { 140,4631 }, { 141,4631 },
 { 142,4631 }, { 143,4631 }, { 144,4631 }, { 145,4631 }, { 146,4631 },
 { 147,4631 }, { 148,4631 }, { 149,4631 }, { 150,4631 }, { 151,4631 },
 { 152,4631 }, { 153,4631 }, { 154,4631 }, { 155,4631 }, { 156,4631 },
 { 157,4631 }, { 158,4631 }, { 159,4631 }, { 160,4631 }, { 161,4631 },
 { 162,4631 }, { 163,4631 }, { 164,4631 }, { 165,4631 }, { 166,4631 },

 { 167,4631 }, { 168,4631 }, { 169,4631 }, { 170,4631 }, { 171,4631 },
 { 172,4631 }, { 173,4631 }, { 174,4631 }, { 175,4631 }, { 176,4631 },
 { 177,4631 }, { 178,4631 }, { 179,4631 }, { 180,4631 }, { 181,4631 },
 { 182,4631 }, { 183,4631 }, { 184,4631 }, { 185,4631 }, { 186,4631 },
 { 187,4631 }, { 188,4631 }, { 189,4631 }, { 190,4631 }, { 191,4631 },
 { 192,4631 }, { 193,4631 }, { 194,4631 }, { 195,4631 }, { 196,4631 },
 { 197,4631 }, { 198,4631 }, { 199,4631 }, { 200,4631 }, { 201,4631 },
 { 202,4631 }, { 203,4631 }, { 204,4631 }, { 205,4631 }, { 206,4631 },
 { 207,4631 }, { 208,4631 }, { 209,4631 }, { 210,4631 }, { 211,4631 },
 { 212,4631 }, { 213,4631 }, { 214,4631 }, { 215,4631 }, { 216,4631 },

 { 217,4631 }, { 218,4631 }, { 219,4631 }, { 220,4631 }, { 221,4631 },
 { 222,4631 }, { 223,4631 }, { 224,4631 }, { 225,4631 }, { 226,4631 },
 { 227,4631 }, { 228,4631 }, { 229,4631 }, { 230,4631 }, { 231,4631 },
 { 232,4631 }, { 233,4631 }, { 234,4631 }, { 235,4631 }, { 236,4631 },
 { 237,4631 }, { 238,4631 }, { 239,4631 }, { 240,4631 }, { 241,4631 },
 { 242,4631 }, { 243,4631 }, { 244,4631 }, { 245,4631 }, { 246,4631 },
 { 247,4631 }, { 248,4631 }, { 249,4631 }, { 250,4631 }, { 251,4631 },
 { 252,4631 }, { 253,4631 }, { 254,4631 }, { 255,4631 }, { 256,4631 },
 {   0,  64 }, {   0,11250 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,4889 },
 {  49,4889 }, {  50,4889 }, {  51,4889 }, {  52,4889 }, {  53,4889 },
 {  54,4889 }, {  55,4889 }, {  56,4889 }, {  57,4889 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,-6208 }, {  66,-6208 }, {  67,-6208 }, {  68,-6208 },
 {  69,5146 }, {  70,-6208 }, {  71,-6208 }, {  72,-6208 }, {  73,-6208 },
 {  74,-6208 }, {  75,-6208 }, {  76,-6208 }, {  77,-6208 }, {  78,-6208 },
 {  79,-6208 }, {  80,-6208 }, {  81,-6208 }, {  82,-6208 }, {  83,-6208 },
 {  84,-6208 }, {  85,-6208 }, {  86,-6208 }, {  87,-6208 }, {  88,-6208 },
 {  89,-6208 }, {  90,-6208 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,5156 }, {   0,   0 }, {  97,-6208 }, {  98,-6208 },
 {  99,-6208 }, { 100,-6208 }, { 101,5146 }, { 102,-6208 }, { 103,-6208 },
 { 104,-6208 }, { 105,-6208 }, { 106,-6208 }, { 107,-6208 }, { 108,-6208 },

 { 109,-6208 }, { 110,-6208 }, { 111,-6208 }, { 112,-6208 }, { 113,-6208 },
 { 114,-6208 }, { 115,-6208 }, { 116,-6208 }, { 117,-6208 }, { 118,-6208 },
 { 119,-6208 }, { 120,-6208 }, { 121,-6208 }, { 122,-6208 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-6208 },
 { 129,-6208 }, { 130,-6208 }, { 131,-6208 }, { 132,-6208 }, { 133,-6208 },
 { 134,-6208 }, { 135,-6208 }, { 136,-6208 }, { 137,-6208 }, { 138,-6208 },
 { 139,-6208 }, { 140,-6208 }, { 141,-6208 }, { 142,-6208 }, { 143,-6208 },
 { 144,-6208 }, { 145,-6208 }, { 146,-6208 }, { 147,-6208 }, { 148,-6208 },
 { 149,-6208 }, { 150,-6208 }, { 151,-6208 }, { 152,-6208 }, { 153,-6208 },
 { 154,-6208 }, { 155,-6208 }, { 156,-6208 }, { 157,-6208 }, { 158,-6208 },

 { 159,-6208 }, { 160,-6208 }, { 161,-6208 }, { 162,-6208 }, { 163,-6208 },
 { 164,-6208 }, { 165,-6208 }, { 166,-6208 }, { 167,-6208 }, { 168,-6208 },
 { 169,-6208 }, { 170,-6208 }, { 171,-6208 }, { 172,-6208 }, { 173,-6208 },
 { 174,-6208 }, { 175,-6208 }, { 176,-6208 }, { 177,-6208 }, { 178,-6208 },
 { 179,-6208 }, { 180,-6208 }, { 181,-6208 }, { 182,-6208 }, { 183,-6208 },
 { 184,-6208 }, { 185,-6208 }, { 186,-6208 }, { 187,-6208 }, { 188,-6208 },
 { 189,-6208 }, { 190,-6208 }, { 191,-6208 }, { 192,-6208 }, { 193,-6208 },
 { 194,-6208 }, { 195,-6208 }, { 196,-6208 }, { 197,-6208 }, { 198,-6208 },
 { 199,-6208 }, { 200,-6208 }, { 201,-6208 }, { 202,-6208 }, { 203,-6208 },
 { 204,-6208 }, { 205,-6208 }, { 206,-6208 }, { 207,-6208 }, { 208,-6208 },

 { 209,-6208 }, { 210,-6208 }, { 211,-6208 }, { 212,-6208 }, { 213,-6208 },
 { 214,-6208 }, { 215,-6208 }, { 216,-6208 }, { 217,-6208 }, { 218,-6208 },
 { 219,-6208 }, { 220,-6208 }, { 221,-6208 }, { 222,-6208 }, { 223,-6208 },
 { 224,-6208 }, { 225,-6208 }, { 226,-6208 }, { 227,-6208 }, { 228,-6208 },
 { 229,-6208 }, { 230,-6208 }, { 231,-6208 }, { 232,-6208 }, { 233,-6208 },
 { 234,-6208 }, { 235,-6208 }, { 236,-6208 }, { 237,-6208 }, { 238,-6208 },
 { 239,-6208 }, { 240,-6208 }, { 241,-6208 }, { 242,-6208 }, { 243,-6208 },
 { 244,-6208 }, { 245,-6208 }, { 246,-6208 }, { 247,-6208 }, { 248,-6208 },
 { 249,-6208 }, { 250,-6208 }, { 251,-6208 }, { 252,-6208 }, { 253,-6208 },
 { 254,-6208 }, { 255,-6208 }, {   0,   2 }, {   0,10993 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  64 },
 {   0,10961 }, {  33,4924 }, {   0,   0 }, {  35,4924 }, {   0,   0 },
 {  37,4924 }, {  38,4924 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  42,4924 }, {  43,4924 }, {   0,   0 }, {  45,4924 }, {   0,   0 },
 {  47,4924 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  60,4924 }, {  61,4924 },
 {  62,4924 }, {  63,4924 }, {  64,4924 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  46,-6495 }, {   0,   0 }, {  48,4958 }, {  49,4958 },
 {  50,4958 }, {  51,4958 }, {  52,4958 }, {  53,4958 }, {  54,4958 },
 {  55,4958 }, {  56,4958 }, {  57,4958 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  94,4924 }, {   0,   0 }, {  96,4924 },
 {  65,-6497 }, {  66,-6497 }, {  67,-6497 }, {  68,-6497 }, {  69,4857 },

 {  70,-6497 }, {  71,-6497 }, {  72,-6497 }, {  73,-6497 }, {  74,-6497 },
 {  75,-6497 }, {  76,-6497 }, {  77,-6497 }, {  78,-6497 }, {  79,-6497 },
 {  80,-6497 }, {  81,-6497 }, {  82,-6497 }, {  83,-6497 }, {  84,-6497 },
 {  85,-6497 }, {  86,-6497 }, {  87,-6497 }, {  88,-6497 }, {  89,-6497 },
 {  90,-6497 }, {   0,   0 }, { 124,4924 }, {   0,   0 }, { 126,4924 },
 {  95,-6497 }, {   0,   0 }, {  97,-6497 }, {  98,-6497 }, {  99,-6497 },
 { 100,-6497 }, { 101,4857 }, { 102,-6497 }, { 103,-6497 }, { 104,-6497 },
 { 105,-6497 }, { 106,-6497 }, { 107,-6497 }, { 108,-6497 }, { 109,-6497 },
 { 110,-6497 }, { 111,-6497 }, { 112,-6497 }, { 113,-6497 }, { 114,-6497 },
 { 115,-6497 }, { 116,-6497 }, { 117,-6497 }, { 118,-6497 }, { 119,-6497 },

 { 120,-6497 }, { 121,-6497 }, { 122,-6497 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-6497 }, { 129,-6497 },
 { 130,-6497 }, { 131,-6497 }, { 132,-6497 }, { 133,-6497 }, { 134,-6497 },
 { 135,-6497 }, { 136,-6497 }, { 137,-6497 }, { 138,-6497 }, { 139,-6497 },
 { 140,-6497 }, { 141,-6497 }, { 142,-6497 }, { 143,-6497 }, { 144,-6497 },
 { 145,-6497 }, { 146,-6497 }, { 147,-6497 }, { 148,-6497 }, { 149,-6497 },
 { 150,-6497 }, { 151,-6497 }, { 152,-6497 }, { 153,-6497 }, { 154,-6497 },
 { 155,-6497 }, { 156,-6497 }, { 157,-6497 }, { 158,-6497 }, { 159,-6497 },
 { 160,-6497 }, { 161,-6497 }, { 162,-6497 }, { 163,-6497 }, { 164,-6497 },
 { 165,-6497 }, { 166,-6497 }, { 167,-6497 }, { 168,-6497 }, { 169,-6497 },

 { 170,-6497 }, { 171,-6497 }, { 172,-6497 }, { 173,-6497 }, { 174,-6497 },
 { 175,-6497 }, { 176,-6497 }, { 177,-6497 }, { 178,-6497 }, { 179,-6497 },
 { 180,-6497 }, { 181,-6497 }, { 182,-6497 }, { 183,-6497 }, { 184,-6497 },
 { 185,-6497 }, { 186,-6497 }, { 187,-6497 }, { 188,-6497 }, { 189,-6497 },
 { 190,-6497 }, { 191,-6497 }, { 192,-6497 }, { 193,-6497 }, { 194,-6497 },
 { 195,-6497 }, { 196,-6497 }, { 197,-6497 }, { 198,-6497 }, { 199,-6497 },
 { 200,-6497 }, { 201,-6497 }, { 202,-6497 }, { 203,-6497 }, { 204,-6497 },
 { 205,-6497 }, { 206,-6497 }, { 207,-6497 }, { 208,-6497 }, { 209,-6497 },
 { 210,-6497 }, { 211,-6497 }, { 212,-6497 }, { 213,-6497 }, { 214,-6497 },
 { 215,-6497 }, { 216,-6497 }, { 217,-6497 }, { 218,-6497 }, { 219,-6497 },

 { 220,-6497 }, { 221,-6497 }, { 222,-6497 }, { 223,-6497 }, { 224,-6497 },
 { 225,-6497 }, { 226,-6497 }, { 227,-6497 }, { 228,-6497 }, { 229,-6497 },
 { 230,-6497 }, { 231,-6497 }, { 232,-6497 }, { 233,-6497 }, { 234,-6497 },
 { 235,-6497 }, { 236,-6497 }, { 237,-6497 }, { 238,-6497 }, { 239,-6497 },
 { 240,-6497 }, { 241,-6497 }, { 242,-6497 }, { 243,-6497 }, { 244,-6497 },
 { 245,-6497 }, { 246,-6497 }, { 247,-6497 }, { 248,-6497 }, { 249,-6497 },
 { 250,-6497 }, { 251,-6497 }, { 252,-6497 }, { 253,-6497 }, { 254,-6497 },
 { 255,-6497 }, {   0,  57 }, {   0,10704 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  46,-257 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  65,-7115 }, {  66,-7115 }, {  67,-7115 },
 {  68,-7115 }, {  69, 257 }, {  70,-7115 }, {  71,-7115 }, {  72,-7115 },
 {  73,-7115 }, {  74,-7115 }, {  75,-7115 }, {  76,-7115 }, {  77,-7115 },
 {  78,-7115 }, {  79,-7115 }, {  80,-7115 }, {  81,-7115 }, {  82,-7115 },
 {  83,-7115 }, {  84,-7115 }, {  85,-7115 }, {  86,-7115 }, {  87,-7115 },
 {  88,-7115 }, {  89,-7115 }, {  90,-7115 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95, 298 }, {   0,   0 }, {  97,-7115 },
 {  98,-7115 }, {  99,-7115 }, { 100,-7115 }, { 101, 257 }, { 102,-7115 },
 { 103,-7115 }, { 104,-7115 }, { 105,-7115 }, { 106,-7115 }, { 107,-7115 },
 { 108,-7115 }, { 109,-7115 }, { 110,-7115 }, { 111,-7115 }, { 112,-7115 },

 { 113,-7115 }, { 114,-7115 }, { 115,-7115 }, { 116,-7115 }, { 117,-7115 },
 { 118,-7115 }, { 119,-7115 }, { 120,-7115 }, { 121,-7115 }, { 122,-7115 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,-7115 }, { 129,-7115 }, { 130,-7115 }, { 131,-7115 }, { 132,-7115 },
 { 133,-7115 }, { 134,-7115 }, { 135,-7115 }, { 136,-7115 }, { 137,-7115 },
 { 138,-7115 }, { 139,-7115 }, { 140,-7115 }, { 141,-7115 }, { 142,-7115 },
 { 143,-7115 }, { 144,-7115 }, { 145,-7115 }, { 146,-7115 }, { 147,-7115 },
 { 148,-7115 }, { 149,-7115 }, { 150,-7115 }, { 151,-7115 }, { 152,-7115 },
 { 153,-7115 }, { 154,-7115 }, { 155,-7115 }, { 156,-7115 }, { 157,-7115 },
 { 158,-7115 }, { 159,-7115 }, { 160,-7115 }, { 161,-7115 }, { 162,-7115 },

 { 163,-7115 }, { 164,-7115 }, { 165,-7115 }, { 166,-7115 }, { 167,-7115 },
 { 168,-7115 }, { 169,-7115 }, { 170,-7115 }, { 171,-7115 }, { 172,-7115 },
 { 173,-7115 }, { 174,-7115 }, { 175,-7115 }, { 176,-7115 }, { 177,-7115 },
 { 178,-7115 }, { 179,-7115 }, { 180,-7115 }, { 181,-7115 }, { 182,-7115 },
 { 183,-7115 }, { 184,-7115 }, { 185,-7115 }, { 186,-7115 }, { 187,-7115 },
 { 188,-7115 }, { 189,-7115 }, { 190,-7115 }, { 191,-7115 }, { 192,-7115 },
 { 193,-7115 }, { 194,-7115 }, { 195,-7115 }, { 196,-7115 }, { 197,-7115 },
 { 198,-7115 }, { 199,-7115 }, { 200,-7115 }, { 201,-7115 }, { 202,-7115 },
 { 203,-7115 }, { 204,-7115 }, { 205,-7115 }, { 206,-7115 }, { 207,-7115 },
 { 208,-7115 }, { 209,-7115 }, { 210,-7115 }, { 211,-7115 }, { 212,-7115 },

 { 213,-7115 }, { 214,-7115 }, { 215,-7115 }, { 216,-7115 }, { 217,-7115 },
 { 218,-7115 }, { 219,-7115 }, { 220,-7115 }, { 221,-7115 }, { 222,-7115 },
 { 223,-7115 }, { 224,-7115 }, { 225,-7115 }, { 226,-7115 }, { 227,-7115 },
 { 228,-7115 }, { 229,-7115 }, { 230,-7115 }, { 231,-7115 }, { 232,-7115 },
 { 233,-7115 }, { 234,-7115 }, { 235,-7115 }, { 236,-7115 }, { 237,-7115 },
 { 238,-7115 }, { 239,-7115 }, { 240,-7115 }, { 241,-7115 }, { 242,-7115 },
 { 243,-7115 }, { 244,-7115 }, { 245,-7115 }, { 246,-7115 }, { 247,-7115 },
 { 248,-7115 }, { 249,-7115 }, { 250,-7115 }, { 251,-7115 }, { 252,-7115 },
 { 253,-7115 }, { 254,-7115 }, { 255,-7115 }, {   0,  68 }, {   0,10447 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  62 }, {   0,10437 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  61 }, {   0,10429 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  68 },
 {   0,10406 }, {   0,   0 }, {  43,4703 }, {   0,   0 }, {  45,4703 },
 {   0,   0 }, {   0,   0 }, {  48,4958 }, {  49,4958 }, {  50,4958 },
 {  51,4958 }, {  52,4958 }, {  53,4958 }, {  54,4958 }, {  55,4958 },

 {  56,4958 }, {  57,4958 }, {  48,5205 }, {  49,5205 }, {  50,5205 },
 {  51,5205 }, {  52,5205 }, {  53,5205 }, {  54,5205 }, {  55,5205 },
 {  48,5454 }, {  49,5454 }, {  50,5454 }, {  51,5454 }, {  52,5454 },
 {  53,5454 }, {  54,5454 }, {  55,5454 }, {  56,5454 }, {  57,5454 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,5454 }, {  66,5454 }, {  67,5454 },
 {  68,5454 }, {  69,5454 }, {  70,5454 }, {  48,-298 }, {  49,-298 },
 {  50,-298 }, {  51,-298 }, {  52,-298 }, {  53,-298 }, {  54,-298 },
 {  55,-298 }, {  56,-298 }, {  57,-298 }, {   0,  49 }, {   0,10347 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,5213 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  51 },
 {   0,10336 }, {   0,   0 }, {  95,5711 }, {   0,   0 }, {  97,5454 },
 {  98,5454 }, {  99,5454 }, { 100,5454 }, { 101,5454 }, { 102,5454 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  33,-1765 }, {   0,   0 }, {  35,-1765 },
 {   0,   0 }, {  37,-1765 }, {  38,-1765 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  42,-1765 }, {  43,-1765 }, {  33,-1776 }, {  45,-1765 },
 {  35,-1776 }, {  47,-1765 }, {  37,-1776 }, {  38,-1776 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  42,-1776 }, {  43,-1776 }, {   0,   0 },

 {  45,-1776 }, {   0,   0 }, {  47,-1776 }, {   0,   0 }, {  60,-1765 },
 {  61,-1765 }, {  62,-1765 }, {  63,-1765 }, {  64,-1765 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  60,-1776 }, {  61,-1776 }, {  62,-1776 }, {  63,-1776 }, {  64,-1776 },
 {   0,   0 }, {   0,  48 }, {   0,10269 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-1765 }, {   0,   0 },
 {  96,-1765 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  94,-1776 },

 {   0,   0 }, {  96,-1776 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  33,-1843 }, {   0,   0 }, {  35,-1843 }, {   0,   0 }, {  37,-1843 },
 {  38,-1843 }, {   0,  50 }, {   0,10229 }, {   0,   0 }, {  42,-1843 },
 {  43,-1843 }, {   0,   0 }, {  45,-1843 }, { 124,-1765 }, {  47,-1843 },
 { 126,-1765 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 124,-1776 },
 {   0,   0 }, { 126,-1776 }, {  60,-1843 }, {  61,-1843 }, {  62,-1843 },
 {  63,-1843 }, {  64,-1843 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  33,-1883 }, {   0,   0 }, {  35,-1883 }, {   0,   0 }, {  37,-1883 },

 {  38,-1883 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,-1883 },
 {  43,-1883 }, {   0,   0 }, {  45,-1883 }, {   0,   0 }, {  47,-1883 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,-1843 }, {   0,   0 }, {  96,-1843 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  60,-1883 }, {  61,-1883 }, {  62,-1883 },
 {  63,-1883 }, {  64,-1883 }, {   0,  74 }, {   0,10163 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 124,-1843 }, {   0,   0 }, { 126,-1843 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,-1883 }, {   0,   0 }, {  96,-1883 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, { 124,-1883 }, {   0,   0 }, { 126,-1883 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },

 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },
 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,   0 }, {   0,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },
 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },

 { 122,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },
 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },

 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },
 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },
 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },

 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },
 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, {   0,  10 },
 {   0,9906 }, {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 },
 {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 },
 {  10,   0 }, {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 },

 {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 },
 {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 },
 {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 },
 {  30,   0 }, {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 },
 {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 },
 {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 },
 {  45,   0 }, {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 },
 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },

 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 },
 {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },

 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 },
 { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },

 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },

 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, { 256,   0 }, {   0,   5 }, {   0,9648 }, {   1,   0 },
 {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 },

 {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 },
 {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 },
 {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 },
 {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 },
 {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 },
 {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 },
 {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 },
 {   0,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 },
 {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },

 {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 },
 {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },
 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },
 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 },
 {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },

 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },
 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },
 { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 },
 { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },

 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },
 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },
 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },
 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },

 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },
 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },
 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },
 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 },

 {   0,   3 }, {   0,9390 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,4715 },
 {   0,   0 }, {  35,4715 }, {   0,   0 }, {  37,4715 }, {  38,4715 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,4715 }, {  43,4715 },
 {   0,   0 }, {  45,4715 }, {   0,   0 }, {  47,4715 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  60,4715 }, {  61,4715 }, {  62,4715 }, {  63,4715 },
 {  64,4715 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  94,4715 }, {   0,   0 }, {  96,4715 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 124,4715 }, {   0,   0 }, { 126,4715 }, {   0,  43 }, {   0,9262 },
 {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 },
 {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 },
 {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 },
 {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 },

 {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 },
 {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 },
 {  31,   0 }, {  32,   0 }, {  33,   0 }, {   0,   0 }, {  35,   0 },
 {  36,   0 }, {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 },
 {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 },
 {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },

 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 },
 {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },
 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },

 { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 },
 { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },
 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },

 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },
 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },

 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 { 256,   0 }, {   0,   9 }, {   0,9004 }, {   1,   0 }, {   2,   0 },
 {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 },
 {   8,   0 }, {   9,   0 }, {  10,   0 }, {  11,   0 }, {  12,   0 },

 {  13,   0 }, {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 },
 {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 },
 {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 },
 {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32,   0 },
 {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 },
 {  38,   0 }, {   0,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 },
 {  43,   0 }, {  44,   0 }, {  45,   0 }, {  46,   0 }, {  47,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },

 {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 },
 {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },

 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },

 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },

 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  21 },
 {   0,8746 }, {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 },

 {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 },
 {  10,   0 }, {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 },
 {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 },
 {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 },
 {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 },
 {  30,   0 }, {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 },
 {  35,   0 }, {  36,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 },
 {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 },
 {  45,   0 }, {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },

 {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 },
 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },
 {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 },
 {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },

 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 },
 { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },
 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },

 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },
 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },

 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },
 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },

 { 255,   0 }, { 256,   0 }, {   0,  18 }, {   0,8488 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  18 }, {   0,8483 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   9,   0 }, {  10,   5 }, {   0,   0 },
 {  12,   0 }, {  13,   5 }, {   9,  16 }, {  10,  16 }, {   0,   0 },
 {  12,  16 }, {  13,  16 }, {   0,   0 }, {   0,  18 }, {   0,8467 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,   0 }, {  10,   0 },
 {  32,   0 }, {  12,   0 }, {  13,   0 }, {   0,   0 }, {   0,   0 },
 {  32,  16 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  39,-9022 }, {  45,-9019 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-8987 }, {   0,   0 },
 {   0,   0 }, {  32,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-9038 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-9003 },
 {   0,  18 }, {   0,8420 }, {   1,4131 }, {   2,4131 }, {   3,4131 },
 {   4,4131 }, {   5,4131 }, {   6,4131 }, {   7,4131 }, {   8,4131 },
 {   9,4389 }, {  10, -63 }, {  11,4131 }, {  12,4389 }, {  13, -63 },
 {  14,4131 }, {  15,4131 }, {  16,4131 }, {  17,4131 }, {  18,4131 },
 {  19,4131 }, {  20,4131 }, {  21,4131 }, {  22,4131 }, {  23,4131 },
 {  24,4131 }, {  25,4131 }, {  26,4131 }, {  27,4131 }, {  28,4131 },

 {  29,4131 }, {  30,4131 }, {  31,4131 }, {  32,4389 }, {  33,4131 },
 {  34,4131 }, {  35,4131 }, {  36,4131 }, {  37,4131 }, {  38,4131 },
 {  39,4131 }, {  40,4131 }, {  41,4131 }, {  42,4131 }, {  43,4131 },
 {  44,4131 }, {  45,4647 }, {  46,4131 }, {  47,4131 }, {  48,4131 },
 {  49,4131 }, {  50,4131 }, {  51,4131 }, {  52,4131 }, {  53,4131 },
 {  54,4131 }, {  55,4131 }, {  56,4131 }, {  57,4131 }, {  58,4131 },
 {  59,4131 }, {  60,4131 }, {  61,4131 }, {  62,4131 }, {  63,4131 },
 {  64,4131 }, {  65,4131 }, {  66,4131 }, {  67,4131 }, {  68,4131 },
 {  69,4131 }, {  70,4131 }, {  71,4131 }, {  72,4131 }, {  73,4131 },
 {  74,4131 }, {  75,4131 }, {  76,4131 }, {  77,4131 }, {  78,4131 },

 {  79,4131 }, {  80,4131 }, {  81,4131 }, {  82,4131 }, {  83,4131 },
 {  84,4131 }, {  85,4131 }, {  86,4131 }, {  87,4131 }, {  88,4131 },
 {  89,4131 }, {  90,4131 }, {  91,4131 }, {  92,4131 }, {  93,4131 },
 {  94,4131 }, {  95,4131 }, {  96,4131 }, {  97,4131 }, {  98,4131 },
 {  99,4131 }, { 100,4131 }, { 101,4131 }, { 102,4131 }, { 103,4131 },
 { 104,4131 }, { 105,4131 }, { 106,4131 }, { 107,4131 }, { 108,4131 },
 { 109,4131 }, { 110,4131 }, { 111,4131 }, { 112,4131 }, { 113,4131 },
 { 114,4131 }, { 115,4131 }, { 116,4131 }, { 117,4131 }, { 118,4131 },
 { 119,4131 }, { 120,4131 }, { 121,4131 }, { 122,4131 }, { 123,4131 },
 { 124,4131 }, { 125,4131 }, { 126,4131 }, { 127,4131 }, { 128,4131 },

 { 129,4131 }, { 130,4131 }, { 131,4131 }, { 132,4131 }, { 133,4131 },
 { 134,4131 }, { 135,4131 }, { 136,4131 }, { 137,4131 }, { 138,4131 },
 { 139,4131 }, { 140,4131 }, { 141,4131 }, { 142,4131 }, { 143,4131 },
 { 144,4131 }, { 145,4131 }, { 146,4131 }, { 147,4131 }, { 148,4131 },
 { 149,4131 }, { 150,4131 }, { 151,4131 }, { 152,4131 }, { 153,4131 },
 { 154,4131 }, { 155,4131 }, { 156,4131 }, { 157,4131 }, { 158,4131 },
 { 159,4131 }, { 160,4131 }, { 161,4131 }, { 162,4131 }, { 163,4131 },
 { 164,4131 }, { 165,4131 }, { 166,4131 }, { 167,4131 }, { 168,4131 },
 { 169,4131 }, { 170,4131 }, { 171,4131 }, { 172,4131 }, { 173,4131 },
 { 174,4131 }, { 175,4131 }, { 176,4131 }, { 177,4131 }, { 178,4131 },

 { 179,4131 }, { 180,4131 }, { 181,4131 }, { 182,4131 }, { 183,4131 },
 { 184,4131 }, { 185,4131 }, { 186,4131 }, { 187,4131 }, { 188,4131 },
 { 189,4131 }, { 190,4131 }, { 191,4131 }, { 192,4131 }, { 193,4131 },
 { 194,4131 }, { 195,4131 }, { 196,4131 }, { 197,4131 }, { 198,4131 },
 { 199,4131 }, { 200,4131 }, { 201,4131 }, { 202,4131 }, { 203,4131 },
 { 204,4131 }, { 205,4131 }, { 206,4131 }, { 207,4131 }, { 208,4131 },
 { 209,4131 }, { 210,4131 }, { 211,4131 }, { 212,4131 }, { 213,4131 },
 { 214,4131 }, { 215,4131 }, { 216,4131 }, { 217,4131 }, { 218,4131 },
 { 219,4131 }, { 220,4131 }, { 221,4131 }, { 222,4131 }, { 223,4131 },
 { 224,4131 }, { 225,4131 }, { 226,4131 }, { 227,4131 }, { 228,4131 },

 { 229,4131 }, { 230,4131 }, { 231,4131 }, { 232,4131 }, { 233,4131 },
 { 234,4131 }, { 235,4131 }, { 236,4131 }, { 237,4131 }, { 238,4131 },
 { 239,4131 }, { 240,4131 }, { 241,4131 }, { 242,4131 }, { 243,4131 },
 { 244,4131 }, { 245,4131 }, { 246,4131 }, { 247,4131 }, { 248,4131 },
 { 249,4131 }, { 250,4131 }, { 251,4131 }, { 252,4131 }, { 253,4131 },
 { 254,4131 }, { 255,4131 }, { 256,4131 }, {   0,  22 }, {   0,8162 },
 {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 },
 {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 }, {  10,   0 },
 {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 }, {  15,   0 },
 {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 },

 {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 },
 {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 },
 {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 },
 {  36,   0 }, {  37,   0 }, {  38,   0 }, {   0,   0 }, {  40,   0 },
 {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 },
 {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },

 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },
 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {  91,   0 }, {   0,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 },
 {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },
 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },

 { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 },
 { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },
 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },
 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },

 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },
 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },
 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },

 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },
 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 { 256,   0 }, {   0,  29 }, {   0,7904 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  27 },
 {   0,7896 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0,7873 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,4389 }, {  49,4389 }, {  50,4389 }, {  51,4389 }, {  52,4389 },
 {  53,4389 }, {  54,4389 }, {  55,4389 }, {  48,4389 }, {  49,4389 },
 {  50,4389 }, {  51,4389 }, {  52,4389 }, {  53,4389 }, {  54,4389 },

 {  55,4389 }, {  56,4389 }, {  57,4389 }, {   0,   0 }, {   0,   0 },
 {   0,  28 }, {   0,7835 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,4389 }, {  66,4389 }, {  67,4389 }, {  68,4389 }, {  69,4389 },
 {  70,4389 }, {  48,4389 }, {  49,4389 }, {  50,4389 }, {  51,4389 },
 {  52,4389 }, {  53,4389 }, {  54,4389 }, {  55,4389 }, {  56,4389 },
 {  57,4389 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,4389 }, {  66,4389 },
 {  67,4389 }, {  68,4389 }, {  69,4389 }, {  70,4389 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97,4389 }, {  98,4389 }, {  99,4389 },
 { 100,4389 }, { 101,4389 }, { 102,4389 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,4389 },
 {  49,4389 }, {  50,4389 }, {  51,4389 }, {  52,4389 }, {  53,4389 },
 {  54,4389 }, {  55,4389 }, {  56,4389 }, {  57,4389 }, {   0,   0 },
 {  97,4389 }, {  98,4389 }, {  99,4389 }, { 100,4389 }, { 101,4389 },
 { 102,4389 }, {  65,4389 }, {  66,4389 }, {  67,4389 }, {  68,4389 },
 {  69,4389 }, {  70,4389 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,4389 }, {  98,4389 },
 {  99,4389 }, { 100,4389 }, { 101,4389 }, { 102,4389 }, {   0,  35 },
 {   0,7731 }, {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 },
 {   5,   0 }, {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 },
 {  10,   0 }, {  11,   0 }, {  12,   0 }, {  13,   0 }, {  14,   0 },
 {  15,   0 }, {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 },
 {  20,   0 }, {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 },
 {  25,   0 }, {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 },
 {  30,   0 }, {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 },
 {  35,   0 }, {   0,   0 }, {  37,   0 }, {  38,   0 }, {  39,   0 },

 {  40,   0 }, {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 },
 {  45,   0 }, {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 },
 {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 },
 {  65,   0 }, {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 },
 {  70,   0 }, {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 },
 {  75,   0 }, {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 },
 {  80,   0 }, {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 },
 {  85,   0 }, {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 },

 {  90,   0 }, {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 },
 {  95,   0 }, {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 },
 { 100,   0 }, { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 },
 { 105,   0 }, { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 },
 { 110,   0 }, { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 },
 { 115,   0 }, { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 },
 { 120,   0 }, { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 },
 { 125,   0 }, { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 },
 { 130,   0 }, { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 },
 { 135,   0 }, { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 },

 { 140,   0 }, { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 },
 { 145,   0 }, { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 },
 { 150,   0 }, { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 },
 { 155,   0 }, { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 },
 { 160,   0 }, { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 },
 { 165,   0 }, { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 },
 { 170,   0 }, { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 },
 { 175,   0 }, { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 },
 { 180,   0 }, { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 },
 { 185,   0 }, { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 },

 { 190,   0 }, { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 },
 { 195,   0 }, { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 },
 { 200,   0 }, { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 },
 { 205,   0 }, { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 },
 { 210,   0 }, { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 },
 { 215,   0 }, { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 },
 { 220,   0 }, { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 },
 { 225,   0 }, { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 },
 { 230,   0 }, { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 },
 { 235,   0 }, { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 },

 { 240,   0 }, { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 },
 { 245,   0 }, { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 },
 { 250,   0 }, { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 },
 { 255,   0 }, { 256,   0 }, {   0,  36 }, {   0,7473 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-9990 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,4099 }, {  49,4099 }, {  50,4099 }, {  51,4099 },
 {  52,4099 }, {  53,4099 }, {  54,4099 }, {  55,4099 }, {  56,4099 },
 {  57,4099 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,4099 }, {  66,4099 },
 {  67,4099 }, {  68,4099 }, {  69,4099 }, {  70,4099 }, {  71,4099 },
 {  72,4099 }, {  73,4099 }, {  74,4099 }, {  75,4099 }, {  76,4099 },
 {  77,4099 }, {  78,4099 }, {  79,4099 }, {  80,4099 }, {  81,4099 },

 {  82,4099 }, {  83,4099 }, {  84,4099 }, {  85,4099 }, {  86,4099 },
 {  87,4099 }, {  88,4099 }, {  89,4099 }, {  90,4099 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,4099 }, {   0,   0 },
 {  97,4099 }, {  98,4099 }, {  99,4099 }, { 100,4099 }, { 101,4099 },
 { 102,4099 }, { 103,4099 }, { 104,4099 }, { 105,4099 }, { 106,4099 },
 { 107,4099 }, { 108,4099 }, { 109,4099 }, { 110,4099 }, { 111,4099 },
 { 112,4099 }, { 113,4099 }, { 114,4099 }, { 115,4099 }, { 116,4099 },
 { 117,4099 }, { 118,4099 }, { 119,4099 }, { 120,4099 }, { 121,4099 },
 { 122,4099 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,4099 }, { 129,4099 }, { 130,4099 }, { 131,4099 },

 { 132,4099 }, { 133,4099 }, { 134,4099 }, { 135,4099 }, { 136,4099 },
 { 137,4099 }, { 138,4099 }, { 139,4099 }, { 140,4099 }, { 141,4099 },
 { 142,4099 }, { 143,4099 }, { 144,4099 }, { 145,4099 }, { 146,4099 },
 { 147,4099 }, { 148,4099 }, { 149,4099 }, { 150,4099 }, { 151,4099 },
 { 152,4099 }, { 153,4099 }, { 154,4099 }, { 155,4099 }, { 156,4099 },
 { 157,4099 }, { 158,4099 }, { 159,4099 }, { 160,4099 }, { 161,4099 },
 { 162,4099 }, { 163,4099 }, { 164,4099 }, { 165,4099 }, { 166,4099 },
 { 167,4099 }, { 168,4099 }, { 169,4099 }, { 170,4099 }, { 171,4099 },
 { 172,4099 }, { 173,4099 }, { 174,4099 }, { 175,4099 }, { 176,4099 },
 { 177,4099 }, { 178,4099 }, { 179,4099 }, { 180,4099 }, { 181,4099 },

 { 182,4099 }, { 183,4099 }, { 184,4099 }, { 185,4099 }, { 186,4099 },
 { 187,4099 }, { 188,4099 }, { 189,4099 }, { 190,4099 }, { 191,4099 },
 { 192,4099 }, { 193,4099 }, { 194,4099 }, { 195,4099 }, { 196,4099 },
 { 197,4099 }, { 198,4099 }, { 199,4099 }, { 200,4099 }, { 201,4099 },
 { 202,4099 }, { 203,4099 }, { 204,4099 }, { 205,4099 }, { 206,4099 },
 { 207,4099 }, { 208,4099 }, { 209,4099 }, { 210,4099 }, { 211,4099 },
 { 212,4099 }, { 213,4099 }, { 214,4099 }, { 215,4099 }, { 216,4099 },
 { 217,4099 }, { 218,4099 }, { 219,4099 }, { 220,4099 }, { 221,4099 },
 { 222,4099 }, { 223,4099 }, { 224,4099 }, { 225,4099 }, { 226,4099 },
 { 227,4099 }, { 228,4099 }, { 229,4099 }, { 230,4099 }, { 231,4099 },

 { 232,4099 }, { 233,4099 }, { 234,4099 }, { 235,4099 }, { 236,4099 },
 { 237,4099 }, { 238,4099 }, { 239,4099 }, { 240,4099 }, { 241,4099 },
 { 242,4099 }, { 243,4099 }, { 244,4099 }, { 245,4099 }, { 246,4099 },
 { 247,4099 }, { 248,4099 }, { 249,4099 }, { 250,4099 }, { 251,4099 },
 { 252,4099 }, { 253,4099 }, { 254,4099 }, { 255,4099 }, {   0,  27 },
 {   0,7216 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0,7193 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,4099 }, {  49,4099 },
 {  50,4099 }, {  51,4099 }, {  52,4099 }, {  53,4099 }, {  54,4099 },
 {  55,4099 }, {  56,4099 }, {  57,4099 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,4099 }, {  66,4099 }, {  67,4099 }, {  68,4099 }, {  69,4099 },
 {  70,4099 }, {  48,4099 }, {  49,4099 }, {  50,4099 }, {  51,4099 },

 {  52,4099 }, {  53,4099 }, {  54,4099 }, {  55,4099 }, {  56,4099 },
 {  57,4099 }, {   0,  33 }, {   0,7134 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,4099 }, {  66,4099 },
 {  67,4099 }, {  68,4099 }, {  69,4099 }, {  70,4099 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97,4099 }, {  98,4099 }, {  99,4099 },
 { 100,4099 }, { 101,4099 }, { 102,4099 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-10689 }, {   0,   0 },
 {  97,4099 }, {  98,4099 }, {  99,4099 }, { 100,4099 }, { 101,4099 },

 { 102,4099 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },

 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },

 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },

 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, {   0,   1 }, {   0,6877 },
 {   1,   0 }, {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 },
 {   6,   0 }, {   7,   0 }, {   8,   0 }, {   9,   0 }, {   0,   0 },
 {  11,   0 }, {  12,   0 }, {   0,   0 }, {  14,   0 }, {  15,   0 },
 {  16,   0 }, {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 },
 {  21,   0 }, {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 },
 {  26,   0 }, {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 },
 {  31,   0 }, {  32,   0 }, {  33,   0 }, {  34,   0 }, {  35,   0 },

 {  36,   0 }, {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 },
 {  41,   0 }, {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45,   0 },
 {  46,   0 }, {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  56,   0 }, {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 },
 {  61,   0 }, {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 },
 {  66,   0 }, {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 },
 {  71,   0 }, {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 },
 {  76,   0 }, {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 },
 {  81,   0 }, {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 },

 {  86,   0 }, {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 },
 {  91,   0 }, {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 },
 {  96,   0 }, {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 },
 { 101,   0 }, { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 },
 { 106,   0 }, { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 },
 { 111,   0 }, { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 },
 { 116,   0 }, { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 },
 { 121,   0 }, { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 },
 { 126,   0 }, { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 },
 { 131,   0 }, { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 },

 { 136,   0 }, { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 },
 { 141,   0 }, { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 },
 { 146,   0 }, { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 },
 { 151,   0 }, { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 },
 { 156,   0 }, { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 },
 { 161,   0 }, { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 },
 { 166,   0 }, { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 },
 { 171,   0 }, { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 },
 { 176,   0 }, { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 },
 { 181,   0 }, { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 },

 { 186,   0 }, { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 },
 { 191,   0 }, { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 },
 { 196,   0 }, { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 },
 { 201,   0 }, { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 },
 { 206,   0 }, { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 },
 { 211,   0 }, { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 },
 { 216,   0 }, { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 },
 { 221,   0 }, { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 },
 { 226,   0 }, { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 },
 { 231,   0 }, { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 },

 { 236,   0 }, { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 },
 { 241,   0 }, { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 },
 { 246,   0 }, { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 },
 { 251,   0 }, { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 },
 { 256,   0 }, {   0,   1 }, {   0,6619 }, {   1,-258 }, {   2,-258 },
 {   3,-258 }, {   4,-258 }, {   5,-258 }, {   6,-258 }, {   7,-258 },
 {   8,-258 }, {   9,-258 }, {   0,   0 }, {  11,-258 }, {  12,-258 },
 {   0,   0 }, {  14,-258 }, {  15,-258 }, {  16,-258 }, {  17,-258 },
 {  18,-258 }, {  19,-258 }, {  20,-258 }, {  21,-258 }, {  22,-258 },
 {  23,-258 }, {  24,-258 }, {  25,-258 }, {  26,-258 }, {  27,-258 },

 {  28,-258 }, {  29,-258 }, {  30,-258 }, {  31,-258 }, {  32,-258 },
 {  33,   0 }, {  34,-258 }, {  35,   0 }, {  36,-258 }, {  37,   0 },
 {  38,   0 }, {  39,-258 }, {  40,-258 }, {  41,-258 }, {  42,   0 },
 {  43,   0 }, {  44,-258 }, {  45,   0 }, {  46,-258 }, {  47,   0 },
 {  48,-258 }, {  49,-258 }, {  50,-258 }, {  51,-258 }, {  52,-258 },
 {  53,-258 }, {  54,-258 }, {  55,-258 }, {  56,-258 }, {  57,-258 },
 {  58,-258 }, {  59,-258 }, {  60,   0 }, {  61,   0 }, {  62,   0 },
 {  63,   0 }, {  64,   0 }, {  65,-258 }, {  66,-258 }, {  67,-258 },
 {  68,-258 }, {  69,-258 }, {  70,-258 }, {  71,-258 }, {  72,-258 },
 {  73,-258 }, {  74,-258 }, {  75,-258 }, {  76,-258 }, {  77,-258 },

 {  78,-258 }, {  79,-258 }, {  80,-258 }, {  81,-258 }, {  82,-258 },
 {  83,-258 }, {  84,-258 }, {  85,-258 }, {  86,-258 }, {  87,-258 },
 {  88,-258 }, {  89,-258 }, {  90,-258 }, {  91,-258 }, {  92,-258 },
 {  93,-258 }, {  94,   0 }, {  95,-258 }, {  96,   0 }, {  97,-258 },
 {  98,-258 }, {  99,-258 }, { 100,-258 }, { 101,-258 }, { 102,-258 },
 { 103,-258 }, { 104,-258 }, { 105,-258 }, { 106,-258 }, { 107,-258 },
 { 108,-258 }, { 109,-258 }, { 110,-258 }, { 111,-258 }, { 112,-258 },
 { 113,-258 }, { 114,-258 }, { 115,-258 }, { 116,-258 }, { 117,-258 },
 { 118,-258 }, { 119,-258 }, { 120,-258 }, { 121,-258 }, { 122,-258 },
 { 123,-258 }, { 124,   0 }, { 125,-258 }, { 126,   0 }, { 127,-258 },

 { 128,-258 }, { 129,-258 }, { 130,-258 }, { 131,-258 }, { 132,-258 },
 { 133,-258 }, { 134,-258 }, { 135,-258 }, { 136,-258 }, { 137,-258 },
 { 138,-258 }, { 139,-258 }, { 140,-258 }, { 141,-258 }, { 142,-258 },
 { 143,-258 }, { 144,-258 }, { 145,-258 }, { 146,-258 }, { 147,-258 },
 { 148,-258 }, { 149,-258 }, { 150,-258 }, { 151,-258 }, { 152,-258 },
 { 153,-258 }, { 154,-258 }, { 155,-258 }, { 156,-258 }, { 157,-258 },
 { 158,-258 }, { 159,-258 }, { 160,-258 }, { 161,-258 }, { 162,-258 },
 { 163,-258 }, { 164,-258 }, { 165,-258 }, { 166,-258 }, { 167,-258 },
 { 168,-258 }, { 169,-258 }, { 170,-258 }, { 171,-258 }, { 172,-258 },
 { 173,-258 }, { 174,-258 }, { 175,-258 }, { 176,-258 }, { 177,-258 },

 { 178,-258 }, { 179,-258 }, { 180,-258 }, { 181,-258 }, { 182,-258 },
 { 183,-258 }, { 184,-258 }, { 185,-258 }, { 186,-258 }, { 187,-258 },
 { 188,-258 }, { 189,-258 }, { 190,-258 }, { 191,-258 }, { 192,-258 },
 { 193,-258 }, { 194,-258 }, { 195,-258 }, { 196,-258 }, { 197,-258 },
 { 198,-258 }, { 199,-258 }, { 200,-258 }, { 201,-258 }, { 202,-258 },
 { 203,-258 }, { 204,-258 }, { 205,-258 }, { 206,-258 }, { 207,-258 },
 { 208,-258 }, { 209,-258 }, { 210,-258 }, { 211,-258 }, { 212,-258 },
 { 213,-258 }, { 214,-258 }, { 215,-258 }, { 216,-258 }, { 217,-258 },
 { 218,-258 }, { 219,-258 }, { 220,-258 }, { 221,-258 }, { 222,-258 },
 { 223,-258 }, { 224,-258 }, { 225,-258 }, { 226,-258 }, { 227,-258 },

 { 228,-258 }, { 229,-258 }, { 230,-258 }, { 231,-258 }, { 232,-258 },
 { 233,-258 }, { 234,-258 }, { 235,-258 }, { 236,-258 }, { 237,-258 },
 { 238,-258 }, { 239,-258 }, { 240,-258 }, { 241,-258 }, { 242,-258 },
 { 243,-258 }, { 244,-258 }, { 245,-258 }, { 246,-258 }, { 247,-258 },
 { 248,-258 }, { 249,-258 }, { 250,-258 }, { 251,-258 }, { 252,-258 },
 { 253,-258 }, { 254,-258 }, { 255,-258 }, { 256,-258 }, {   0,  64 },
 {   0,6361 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-11097 }, {  66,-11097 }, {  67,-11097 }, {  68,-11097 }, {  69, 257 },

 {  70,-11097 }, {  71,-11097 }, {  72,-11097 }, {  73,-11097 }, {  74,-11097 },
 {  75,-11097 }, {  76,-11097 }, {  77,-11097 }, {  78,-11097 }, {  79,-11097 },
 {  80,-11097 }, {  81,-11097 }, {  82,-11097 }, {  83,-11097 }, {  84,-11097 },
 {  85,-11097 }, {  86,-11097 }, {  87,-11097 }, {  88,-11097 }, {  89,-11097 },
 {  90,-11097 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95, 267 }, {   0,   0 }, {  97,-11097 }, {  98,-11097 }, {  99,-11097 },
 { 100,-11097 }, { 101, 257 }, { 102,-11097 }, { 103,-11097 }, { 104,-11097 },
 { 105,-11097 }, { 106,-11097 }, { 107,-11097 }, { 108,-11097 }, { 109,-11097 },
 { 110,-11097 }, { 111,-11097 }, { 112,-11097 }, { 113,-11097 }, { 114,-11097 },
 { 115,-11097 }, { 116,-11097 }, { 117,-11097 }, { 118,-11097 }, { 119,-11097 },

 { 120,-11097 }, { 121,-11097 }, { 122,-11097 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-11097 }, { 129,-11097 },
 { 130,-11097 }, { 131,-11097 }, { 132,-11097 }, { 133,-11097 }, { 134,-11097 },
 { 135,-11097 }, { 136,-11097 }, { 137,-11097 }, { 138,-11097 }, { 139,-11097 },
 { 140,-11097 }, { 141,-11097 }, { 142,-11097 }, { 143,-11097 }, { 144,-11097 },
 { 145,-11097 }, { 146,-11097 }, { 147,-11097 }, { 148,-11097 }, { 149,-11097 },
 { 150,-11097 }, { 151,-11097 }, { 152,-11097 }, { 153,-11097 }, { 154,-11097 },
 { 155,-11097 }, { 156,-11097 }, { 157,-11097 }, { 158,-11097 }, { 159,-11097 },
 { 160,-11097 }, { 161,-11097 }, { 162,-11097 }, { 163,-11097 }, { 164,-11097 },
 { 165,-11097 }, { 166,-11097 }, { 167,-11097 }, { 168,-11097 }, { 169,-11097 },

 { 170,-11097 }, { 171,-11097 }, { 172,-11097 }, { 173,-11097 }, { 174,-11097 },
 { 175,-11097 }, { 176,-11097 }, { 177,-11097 }, { 178,-11097 }, { 179,-11097 },
 { 180,-11097 }, { 181,-11097 }, { 182,-11097 }, { 183,-11097 }, { 184,-11097 },
 { 185,-11097 }, { 186,-11097 }, { 187,-11097 }, { 188,-11097 }, { 189,-11097 },
 { 190,-11097 }, { 191,-11097 }, { 192,-11097 }, { 193,-11097 }, { 194,-11097 },
 { 195,-11097 }, { 196,-11097 }, { 197,-11097 }, { 198,-11097 }, { 199,-11097 },
 { 200,-11097 }, { 201,-11097 }, { 202,-11097 }, { 203,-11097 }, { 204,-11097 },
 { 205,-11097 }, { 206,-11097 }, { 207,-11097 }, { 208,-11097 }, { 209,-11097 },
 { 210,-11097 }, { 211,-11097 }, { 212,-11097 }, { 213,-11097 }, { 214,-11097 },
 { 215,-11097 }, { 216,-11097 }, { 217,-11097 }, { 218,-11097 }, { 219,-11097 },

 { 220,-11097 }, { 221,-11097 }, { 222,-11097 }, { 223,-11097 }, { 224,-11097 },
 { 225,-11097 }, { 226,-11097 }, { 227,-11097 }, { 228,-11097 }, { 229,-11097 },
 { 230,-11097 }, { 231,-11097 }, { 232,-11097 }, { 233,-11097 }, { 234,-11097 },
 { 235,-11097 }, { 236,-11097 }, { 237,-11097 }, { 238,-11097 }, { 239,-11097 },
 { 240,-11097 }, { 241,-11097 }, { 242,-11097 }, { 243,-11097 }, { 244,-11097 },
 { 245,-11097 }, { 246,-11097 }, { 247,-11097 }, { 248,-11097 }, { 249,-11097 },
 { 250,-11097 }, { 251,-11097 }, { 252,-11097 }, { 253,-11097 }, { 254,-11097 },
 { 255,-11097 }, {   0,  72 }, {   0,6104 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  72 }, {   0,6094 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   2 }, {   0,6069 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  43, 360 }, {   0,   0 }, {  45, 360 }, {   0,   0 }, {   0,   0 },
 {  48, 615 }, {  49, 615 }, {  50, 615 }, {  51, 615 }, {  52, 615 },
 {  53, 615 }, {  54, 615 }, {  55, 615 }, {  56, 615 }, {  57, 615 },
 {  48,-267 }, {  49,-267 }, {  50,-267 }, {  51,-267 }, {  52,-267 },

 {  53,-267 }, {  54,-267 }, {  55,-267 }, {  56,-267 }, {  57,-267 },
 {  33,   0 }, {   0,   0 }, {  35,   0 }, {   0,   0 }, {  37,   0 },
 {  38,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,   0 },
 {  43,   0 }, {   0,   0 }, {  45,   0 }, {   0,   0 }, {  47,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },
 {  63,   0 }, {  64,   0 }, {   0,  64 }, {   0,6003 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  94,   0 }, {   0,   0 }, {  96,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,2947 }, {  49,2947 }, {  50,2947 }, {  51,2947 },
 {  52,2947 }, {  53,2947 }, {  54,2947 }, {  55,2947 }, {  56,2947 },
 {  57,2947 }, { 124,   0 }, {   0,   0 }, { 126,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-11455 }, {  66,-11455 },
 {  67,-11455 }, {  68,-11455 }, {  69,-101 }, {  70,-11455 }, {  71,-11455 },
 {  72,-11455 }, {  73,-11455 }, {  74,-11455 }, {  75,-11455 }, {  76,-11455 },
 {  77,-11455 }, {  78,-11455 }, {  79,-11455 }, {  80,-11455 }, {  81,-11455 },
 {  82,-11455 }, {  83,-11455 }, {  84,-11455 }, {  85,-11455 }, {  86,-11455 },
 {  87,-11455 }, {  88,-11455 }, {  89,-11455 }, {  90,-11455 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,3204 }, {   0,   0 },
 {  97,-11455 }, {  98,-11455 }, {  99,-11455 }, { 100,-11455 }, { 101,-101 },
 { 102,-11455 }, { 103,-11455 }, { 104,-11455 }, { 105,-11455 }, { 106,-11455 },
 { 107,-11455 }, { 108,-11455 }, { 109,-11455 }, { 110,-11455 }, { 111,-11455 },

 { 112,-11455 }, { 113,-11455 }, { 114,-11455 }, { 115,-11455 }, { 116,-11455 },
 { 117,-11455 }, { 118,-11455 }, { 119,-11455 }, { 120,-11455 }, { 121,-11455 },
 { 122,-11455 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, { 128,-11455 }, { 129,-11455 }, { 130,-11455 }, { 131,-11455 },
 { 132,-11455 }, { 133,-11455 }, { 134,-11455 }, { 135,-11455 }, { 136,-11455 },
 { 137,-11455 }, { 138,-11455 }, { 139,-11455 }, { 140,-11455 }, { 141,-11455 },
 { 142,-11455 }, { 143,-11455 }, { 144,-11455 }, { 145,-11455 }, { 146,-11455 },
 { 147,-11455 }, { 148,-11455 }, { 149,-11455 }, { 150,-11455 }, { 151,-11455 },
 { 152,-11455 }, { 153,-11455 }, { 154,-11455 }, { 155,-11455 }, { 156,-11455 },
 { 157,-11455 }, { 158,-11455 }, { 159,-11455 }, { 160,-11455 }, { 161,-11455 },

 { 162,-11455 }, { 163,-11455 }, { 164,-11455 }, { 165,-11455 }, { 166,-11455 },
 { 167,-11455 }, { 168,-11455 }, { 169,-11455 }, { 170,-11455 }, { 171,-11455 },
 { 172,-11455 }, { 173,-11455 }, { 174,-11455 }, { 175,-11455 }, { 176,-11455 },
 { 177,-11455 }, { 178,-11455 }, { 179,-11455 }, { 180,-11455 }, { 181,-11455 },
 { 182,-11455 }, { 183,-11455 }, { 184,-11455 }, { 185,-11455 }, { 186,-11455 },
 { 187,-11455 }, { 188,-11455 }, { 189,-11455 }, { 190,-11455 }, { 191,-11455 },
 { 192,-11455 }, { 193,-11455 }, { 194,-11455 }, { 195,-11455 }, { 196,-11455 },
 { 197,-11455 }, { 198,-11455 }, { 199,-11455 }, { 200,-11455 }, { 201,-11455 },
 { 202,-11455 }, { 203,-11455 }, { 204,-11455 }, { 205,-11455 }, { 206,-11455 },
 { 207,-11455 }, { 208,-11455 }, { 209,-11455 }, { 210,-11455 }, { 211,-11455 },

 { 212,-11455 }, { 213,-11455 }, { 214,-11455 }, { 215,-11455 }, { 216,-11455 },
 { 217,-11455 }, { 218,-11455 }, { 219,-11455 }, { 220,-11455 }, { 221,-11455 },
 { 222,-11455 }, { 223,-11455 }, { 224,-11455 }, { 225,-11455 }, { 226,-11455 },
 { 227,-11455 }, { 228,-11455 }, { 229,-11455 }, { 230,-11455 }, { 231,-11455 },
 { 232,-11455 }, { 233,-11455 }, { 234,-11455 }, { 235,-11455 }, { 236,-11455 },
 { 237,-11455 }, { 238,-11455 }, { 239,-11455 }, { 240,-11455 }, { 241,-11455 },
 { 242,-11455 }, { 243,-11455 }, { 244,-11455 }, { 245,-11455 }, { 246,-11455 },
 { 247,-11455 }, { 248,-11455 }, { 249,-11455 }, { 250,-11455 }, { 251,-11455 },
 { 252,-11455 }, { 253,-11455 }, { 254,-11455 }, { 255,-11455 }, {   0,  60 },
 {   0,5746 }, {   0,  67 }, {   0,5744 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  48, 255 }, {  49, 255 }, {  50, 255 }, {  51, 255 }, {  52, 255 },

 {  53, 255 }, {  54, 255 }, {  55, 255 }, {  56, 255 }, {  57, 255 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,-11698 }, {  66,-11698 }, {  67,-11698 }, {  68,-11698 }, {  69,-11698 },
 {  70,-11698 }, {  71,-11698 }, {  72,-11698 }, {  73,-11698 }, {  74,-11698 },
 {  75,-11698 }, {  76,-11698 }, {  77,-11698 }, {  78,-11698 }, {  79,-11698 },
 {  80,-11698 }, {  81,-11698 }, {  82,-11698 }, {  83,-11698 }, {  84,-11698 },
 {  85,-11698 }, {  86,-11698 }, {  87,-11698 }, {  88,-11698 }, {  89,-11698 },
 {  90,-11698 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95,-11428 }, {   0,   0 }, {  97,-11698 }, {  98,-11698 }, {  99,-11698 },
 { 100,-11698 }, { 101,-11698 }, { 102,-11698 }, { 103,-11698 }, { 104,-11698 },

 { 105,-11698 }, { 106,-11698 }, { 107,-11698 }, { 108,-11698 }, { 109,-11698 },
 { 110,-11698 }, { 111,-11698 }, { 112,-11698 }, { 113,-11698 }, { 114,-11698 },
 { 115,-11698 }, { 116,-11698 }, { 117,-11698 }, { 118,-11698 }, { 119,-11698 },
 { 120,-11698 }, { 121,-11698 }, { 122,-11698 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-11698 }, { 129,-11698 },
 { 130,-11698 }, { 131,-11698 }, { 132,-11698 }, { 133,-11698 }, { 134,-11698 },
 { 135,-11698 }, { 136,-11698 }, { 137,-11698 }, { 138,-11698 }, { 139,-11698 },
 { 140,-11698 }, { 141,-11698 }, { 142,-11698 }, { 143,-11698 }, { 144,-11698 },
 { 145,-11698 }, { 146,-11698 }, { 147,-11698 }, { 148,-11698 }, { 149,-11698 },
 { 150,-11698 }, { 151,-11698 }, { 152,-11698 }, { 153,-11698 }, { 154,-11698 },

 { 155,-11698 }, { 156,-11698 }, { 157,-11698 }, { 158,-11698 }, { 159,-11698 },
 { 160,-11698 }, { 161,-11698 }, { 162,-11698 }, { 163,-11698 }, { 164,-11698 },
 { 165,-11698 }, { 166,-11698 }, { 167,-11698 }, { 168,-11698 }, { 169,-11698 },
 { 170,-11698 }, { 171,-11698 }, { 172,-11698 }, { 173,-11698 }, { 174,-11698 },
 { 175,-11698 }, { 176,-11698 }, { 177,-11698 }, { 178,-11698 }, { 179,-11698 },
 { 180,-11698 }, { 181,-11698 }, { 182,-11698 }, { 183,-11698 }, { 184,-11698 },
 { 185,-11698 }, { 186,-11698 }, { 187,-11698 }, { 188,-11698 }, { 189,-11698 },
 { 190,-11698 }, { 191,-11698 }, { 192,-11698 }, { 193,-11698 }, { 194,-11698 },
 { 195,-11698 }, { 196,-11698 }, { 197,-11698 }, { 198,-11698 }, { 199,-11698 },
 { 200,-11698 }, { 201,-11698 }, { 202,-11698 }, { 203,-11698 }, { 204,-11698 },

 { 205,-11698 }, { 206,-11698 }, { 207,-11698 }, { 208,-11698 }, { 209,-11698 },
 { 210,-11698 }, { 211,-11698 }, { 212,-11698 }, { 213,-11698 }, { 214,-11698 },
 { 215,-11698 }, { 216,-11698 }, { 217,-11698 }, { 218,-11698 }, { 219,-11698 },
 { 220,-11698 }, { 221,-11698 }, { 222,-11698 }, { 223,-11698 }, { 224,-11698 },
 { 225,-11698 }, { 226,-11698 }, { 227,-11698 }, { 228,-11698 }, { 229,-11698 },
 { 230,-11698 }, { 231,-11698 }, { 232,-11698 }, { 233,-11698 }, { 234,-11698 },
 { 235,-11698 }, { 236,-11698 }, { 237,-11698 }, { 238,-11698 }, { 239,-11698 },
 { 240,-11698 }, { 241,-11698 }, { 242,-11698 }, { 243,-11698 }, { 244,-11698 },
 { 245,-11698 }, { 246,-11698 }, { 247,-11698 }, { 248,-11698 }, { 249,-11698 },
 { 250,-11698 }, { 251,-11698 }, { 252,-11698 }, { 253,-11698 }, { 254,-11698 },

 { 255,-11698 }, {   0,  66 }, {   0,5489 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {  48,2700 }, {  49,2700 }, {  50,2700 }, {  51,2700 }, {  52,2700 },
 {  53,2700 }, {  54,2700 }, {  55,2700 }, {  56,2700 }, {  57,2700 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-11683 }, {  66,-11683 }, {  67,-11683 },
 {  68,-11683 }, {  69,-11683 }, {  70,-11683 }, {  71,-11683 }, {  72,-11683 },
 {  73,-11683 }, {  74,-11683 }, {  75,-11683 }, {  76,-11683 }, {  77,-11683 },
 {  78,-11683 }, {  79,-11683 }, {  80,-11683 }, {  81,-11683 }, {  82,-11683 },
 {  83,-11683 }, {  84,-11683 }, {  85,-11683 }, {  86,-11683 }, {  87,-11683 },
 {  88,-11683 }, {  89,-11683 }, {  90,-11683 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,2957 }, {   0,   0 }, {  97,-11683 },

 {  98,-11683 }, {  99,-11683 }, { 100,-11683 }, { 101,-11683 }, { 102,-11683 },
 { 103,-11683 }, { 104,-11683 }, { 105,-11683 }, { 106,-11683 }, { 107,-11683 },
 { 108,-11683 }, { 109,-11683 }, { 110,-11683 }, { 111,-11683 }, { 112,-11683 },
 { 113,-11683 }, { 114,-11683 }, { 115,-11683 }, { 116,-11683 }, { 117,-11683 },
 { 118,-11683 }, { 119,-11683 }, { 120,-11683 }, { 121,-11683 }, { 122,-11683 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,-11683 }, { 129,-11683 }, { 130,-11683 }, { 131,-11683 }, { 132,-11683 },
 { 133,-11683 }, { 134,-11683 }, { 135,-11683 }, { 136,-11683 }, { 137,-11683 },
 { 138,-11683 }, { 139,-11683 }, { 140,-11683 }, { 141,-11683 }, { 142,-11683 },
 { 143,-11683 }, { 144,-11683 }, { 145,-11683 }, { 146,-11683 }, { 147,-11683 },

 { 148,-11683 }, { 149,-11683 }, { 150,-11683 }, { 151,-11683 }, { 152,-11683 },
 { 153,-11683 }, { 154,-11683 }, { 155,-11683 }, { 156,-11683 }, { 157,-11683 },
 { 158,-11683 }, { 159,-11683 }, { 160,-11683 }, { 161,-11683 }, { 162,-11683 },
 { 163,-11683 }, { 164,-11683 }, { 165,-11683 }, { 166,-11683 }, { 167,-11683 },
 { 168,-11683 }, { 169,-11683 }, { 170,-11683 }, { 171,-11683 }, { 172,-11683 },
 { 173,-11683 }, { 174,-11683 }, { 175,-11683 }, { 176,-11683 }, { 177,-11683 },
 { 178,-11683 }, { 179,-11683 }, { 180,-11683 }, { 181,-11683 }, { 182,-11683 },
 { 183,-11683 }, { 184,-11683 }, { 185,-11683 }, { 186,-11683 }, { 187,-11683 },
 { 188,-11683 }, { 189,-11683 }, { 190,-11683 }, { 191,-11683 }, { 192,-11683 },
 { 193,-11683 }, { 194,-11683 }, { 195,-11683 }, { 196,-11683 }, { 197,-11683 },

 { 198,-11683 }, { 199,-11683 }, { 200,-11683 }, { 201,-11683 }, { 202,-11683 },
 { 203,-11683 }, { 204,-11683 }, { 205,-11683 }, { 206,-11683 }, { 207,-11683 },
 { 208,-11683 }, { 209,-11683 }, { 210,-11683 }, { 211,-11683 }, { 212,-11683 },
 { 213,-11683 }, { 214,-11683 }, { 215,-11683 }, { 216,-11683 }, { 217,-11683 },
 { 218,-11683 }, { 219,-11683 }, { 220,-11683 }, { 221,-11683 }, { 222,-11683 },
 { 223,-11683 }, { 224,-11683 }, { 225,-11683 }, { 226,-11683 }, { 227,-11683 },
 { 228,-11683 }, { 229,-11683 }, { 230,-11683 }, { 231,-11683 }, { 232,-11683 },
 { 233,-11683 }, { 234,-11683 }, { 235,-11683 }, { 236,-11683 }, { 237,-11683 },
 { 238,-11683 }, { 239,-11683 }, { 240,-11683 }, { 241,-11683 }, { 242,-11683 },
 { 243,-11683 }, { 244,-11683 }, { 245,-11683 }, { 246,-11683 }, { 247,-11683 },

 { 248,-11683 }, { 249,-11683 }, { 250,-11683 }, { 251,-11683 }, { 252,-11683 },
 { 253,-11683 }, { 254,-11683 }, { 255,-11683 }, {   0,  59 }, {   0,5232 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  62 }, {   0,5224 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 },
 {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 },
 {  48,  -8 }, {  49,  -8 }, {  50,  -8 }, {  51,  -8 }, {  52,  -8 },
 {  53,  -8 }, {  54,  -8 }, {  55,  -8 }, {   0,   0 }, {  65,-11938 },
 {  66,-11938 }, {  67,-11938 }, {  68,-11938 }, {  69,-11938 }, {  70,-11938 },
 {  71,-11938 }, {  72,-11938 }, {  73,-11938 }, {  74,-11938 }, {  75,-11938 },
 {  76,-11938 }, {  77,-11938 }, {  78,-11938 }, {  79,-11938 }, {  80,-11938 },
 {  81,-11938 }, {  82,-11938 }, {  83,-11938 }, {  84,-11938 }, {  85,-11938 },
 {  86,-11938 }, {  87,-11938 }, {  88,-11938 }, {  89,-11938 }, {  90,-11938 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  95,2710 },
 {   0,   0 }, {  97,-11938 }, {  98,-11938 }, {  99,-11938 }, { 100,-11938 },
 { 101,-11938 }, { 102,-11938 }, { 103,-11938 }, { 104,-11938 }, { 105,-11938 },
 { 106,-11938 }, { 107,-11938 }, { 108,-11938 }, { 109,-11938 }, { 110,-11938 },
 { 111,-11938 }, { 112,-11938 }, { 113,-11938 }, { 114,-11938 }, { 115,-11938 },
 { 116,-11938 }, { 117,-11938 }, { 118,-11938 }, { 119,-11938 }, { 120,-11938 },
 { 121,-11938 }, { 122,-11938 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, { 128,-11938 }, { 129,-11938 }, { 130,-11938 },
 { 131,-11938 }, { 132,-11938 }, { 133,-11938 }, { 134,-11938 }, { 135,-11938 },
 { 136,-11938 }, { 137,-11938 }, { 138,-11938 }, { 139,-11938 }, { 140,-11938 },

 { 141,-11938 }, { 142,-11938 }, { 143,-11938 }, { 144,-11938 }, { 145,-11938 },
 { 146,-11938 }, { 147,-11938 }, { 148,-11938 }, { 149,-11938 }, { 150,-11938 },
 { 151,-11938 }, { 152,-11938 }, { 153,-11938 }, { 154,-11938 }, { 155,-11938 },
 { 156,-11938 }, { 157,-11938 }, { 158,-11938 }, { 159,-11938 }, { 160,-11938 },
 { 161,-11938 }, { 162,-11938 }, { 163,-11938 }, { 164,-11938 }, { 165,-11938 },
 { 166,-11938 }, { 167,-11938 }, { 168,-11938 }, { 169,-11938 }, { 170,-11938 },
 { 171,-11938 }, { 172,-11938 }, { 173,-11938 }, { 174,-11938 }, { 175,-11938 },
 { 176,-11938 }, { 177,-11938 }, { 178,-11938 }, { 179,-11938 }, { 180,-11938 },
 { 181,-11938 }, { 182,-11938 }, { 183,-11938 }, { 184,-11938 }, { 185,-11938 },
 { 186,-11938 }, { 187,-11938 }, { 188,-11938 }, { 189,-11938 }, { 190,-11938 },

 { 191,-11938 }, { 192,-11938 }, { 193,-11938 }, { 194,-11938 }, { 195,-11938 },
 { 196,-11938 }, { 197,-11938 }, { 198,-11938 }, { 199,-11938 }, { 200,-11938 },
 { 201,-11938 }, { 202,-11938 }, { 203,-11938 }, { 204,-11938 }, { 205,-11938 },
 { 206,-11938 }, { 207,-11938 }, { 208,-11938 }, { 209,-11938 }, { 210,-11938 },
 { 211,-11938 }, { 212,-11938 }, { 213,-11938 }, { 214,-11938 }, { 215,-11938 },
 { 216,-11938 }, { 217,-11938 }, { 218,-11938 }, { 219,-11938 }, { 220,-11938 },
 { 221,-11938 }, { 222,-11938 }, { 223,-11938 }, { 224,-11938 }, { 225,-11938 },
 { 226,-11938 }, { 227,-11938 }, { 228,-11938 }, { 229,-11938 }, { 230,-11938 },
 { 231,-11938 }, { 232,-11938 }, { 233,-11938 }, { 234,-11938 }, { 235,-11938 },
 { 236,-11938 }, { 237,-11938 }, { 238,-11938 }, { 239,-11938 }, { 240,-11938 },

 { 241,-11938 }, { 242,-11938 }, { 243,-11938 }, { 244,-11938 }, { 245,-11938 },
 { 246,-11938 }, { 247,-11938 }, { 248,-11938 }, { 249,-11938 }, { 250,-11938 },
 { 251,-11938 }, { 252,-11938 }, { 253,-11938 }, { 254,-11938 }, { 255,-11938 },
 {   0,  58 }, {   0,4975 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 },
 {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 },
 {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,2461 }, {  66,2461 }, {  67,2461 }, {  68,2461 },
 {  69,2461 }, {  70,2461 }, {  71,-12193 }, {  72,-12193 }, {  73,-12193 },
 {  74,-12193 }, {  75,-12193 }, {  76,-12193 }, {  77,-12193 }, {  78,-12193 },
 {  79,-12193 }, {  80,-12193 }, {  81,-12193 }, {  82,-12193 }, {  83,-12193 },

 {  84,-12193 }, {  85,-12193 }, {  86,-12193 }, {  87,-12193 }, {  88,-12193 },
 {  89,-12193 }, {  90,-12193 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  95,2718 }, {   0,   0 }, {  97,2461 }, {  98,2461 },
 {  99,2461 }, { 100,2461 }, { 101,2461 }, { 102,2461 }, { 103,-12193 },
 { 104,-12193 }, { 105,-12193 }, { 106,-12193 }, { 107,-12193 }, { 108,-12193 },
 { 109,-12193 }, { 110,-12193 }, { 111,-12193 }, { 112,-12193 }, { 113,-12193 },
 { 114,-12193 }, { 115,-12193 }, { 116,-12193 }, { 117,-12193 }, { 118,-12193 },
 { 119,-12193 }, { 120,-12193 }, { 121,-12193 }, { 122,-12193 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-12193 },
 { 129,-12193 }, { 130,-12193 }, { 131,-12193 }, { 132,-12193 }, { 133,-12193 },

 { 134,-12193 }, { 135,-12193 }, { 136,-12193 }, { 137,-12193 }, { 138,-12193 },
 { 139,-12193 }, { 140,-12193 }, { 141,-12193 }, { 142,-12193 }, { 143,-12193 },
 { 144,-12193 }, { 145,-12193 }, { 146,-12193 }, { 147,-12193 }, { 148,-12193 },
 { 149,-12193 }, { 150,-12193 }, { 151,-12193 }, { 152,-12193 }, { 153,-12193 },
 { 154,-12193 }, { 155,-12193 }, { 156,-12193 }, { 157,-12193 }, { 158,-12193 },
 { 159,-12193 }, { 160,-12193 }, { 161,-12193 }, { 162,-12193 }, { 163,-12193 },
 { 164,-12193 }, { 165,-12193 }, { 166,-12193 }, { 167,-12193 }, { 168,-12193 },
 { 169,-12193 }, { 170,-12193 }, { 171,-12193 }, { 172,-12193 }, { 173,-12193 },
 { 174,-12193 }, { 175,-12193 }, { 176,-12193 }, { 177,-12193 }, { 178,-12193 },
 { 179,-12193 }, { 180,-12193 }, { 181,-12193 }, { 182,-12193 }, { 183,-12193 },

 { 184,-12193 }, { 185,-12193 }, { 186,-12193 }, { 187,-12193 }, { 188,-12193 },
 { 189,-12193 }, { 190,-12193 }, { 191,-12193 }, { 192,-12193 }, { 193,-12193 },
 { 194,-12193 }, { 195,-12193 }, { 196,-12193 }, { 197,-12193 }, { 198,-12193 },
 { 199,-12193 }, { 200,-12193 }, { 201,-12193 }, { 202,-12193 }, { 203,-12193 },
 { 204,-12193 }, { 205,-12193 }, { 206,-12193 }, { 207,-12193 }, { 208,-12193 },
 { 209,-12193 }, { 210,-12193 }, { 211,-12193 }, { 212,-12193 }, { 213,-12193 },
 { 214,-12193 }, { 215,-12193 }, { 216,-12193 }, { 217,-12193 }, { 218,-12193 },
 { 219,-12193 }, { 220,-12193 }, { 221,-12193 }, { 222,-12193 }, { 223,-12193 },
 { 224,-12193 }, { 225,-12193 }, { 226,-12193 }, { 227,-12193 }, { 228,-12193 },
 { 229,-12193 }, { 230,-12193 }, { 231,-12193 }, { 232,-12193 }, { 233,-12193 },

 { 234,-12193 }, { 235,-12193 }, { 236,-12193 }, { 237,-12193 }, { 238,-12193 },
 { 239,-12193 }, { 240,-12193 }, { 241,-12193 }, { 242,-12193 }, { 243,-12193 },
 { 244,-12193 }, { 245,-12193 }, { 246,-12193 }, { 247,-12193 }, { 248,-12193 },
 { 249,-12193 }, { 250,-12193 }, { 251,-12193 }, { 252,-12193 }, { 253,-12193 },
 { 254,-12193 }, { 255,-12193 }, {   0,  61 }, {   0,4718 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   3 }, {   0,4675 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48,-257 }, {  49,-257 }, {  50,-257 }, {  51,-257 },
 {  52,-257 }, {  53,-257 }, {  54,-257 }, {  55,-257 }, {  56,-257 },
 {  57,-257 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-257 }, {  66,-257 },
 {  67,-257 }, {  68,-257 }, {  69,-257 }, {  70,-257 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  33,   0 },

 {   0,   0 }, {  35,   0 }, {   0,   0 }, {  37,   0 }, {  38,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  42,   0 }, {  43,   0 },
 {   0,   0 }, {  45,   0 }, {   0,   0 }, {  47,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97,-257 }, {  98,-257 }, {  99,-257 }, { 100,-257 }, { 101,-257 },
 { 102,-257 }, {  60,   0 }, {  61,   0 }, {  62,   0 }, {  63,   0 },
 {  64,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  94,   0 }, {   0,   0 }, {  96,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 124,   0 }, {   0,   0 }, { 126,   0 }, {   0,  18 }, {   0,4547 },
 {   1,2394 }, {   2,2394 }, {   3,2394 }, {   4,2394 }, {   5,2394 },

 {   6,2394 }, {   7,2394 }, {   8,2394 }, {   9,2652 }, {  10,2910 },
 {  11,2394 }, {  12,2652 }, {  13,2910 }, {  14,2394 }, {  15,2394 },
 {  16,2394 }, {  17,2394 }, {  18,2394 }, {  19,2394 }, {  20,2394 },
 {  21,2394 }, {  22,2394 }, {  23,2394 }, {  24,2394 }, {  25,2394 },
 {  26,2394 }, {  27,2394 }, {  28,2394 }, {  29,2394 }, {  30,2394 },
 {  31,2394 }, {  32,2652 }, {  33,2394 }, {  34,2394 }, {  35,2394 },
 {  36,2394 }, {  37,2394 }, {  38,2394 }, {  39,2394 }, {  40,2394 },
 {  41,2394 }, {  42,2394 }, {  43,2394 }, {  44,2394 }, {  45,2957 },
 {  46,2394 }, {  47,2394 }, {  48,2394 }, {  49,2394 }, {  50,2394 },
 {  51,2394 }, {  52,2394 }, {  53,2394 }, {  54,2394 }, {  55,2394 },

 {  56,2394 }, {  57,2394 }, {  58,2394 }, {  59,2394 }, {  60,2394 },
 {  61,2394 }, {  62,2394 }, {  63,2394 }, {  64,2394 }, {  65,2394 },
 {  66,2394 }, {  67,2394 }, {  68,2394 }, {  69,2394 }, {  70,2394 },
 {  71,2394 }, {  72,2394 }, {  73,2394 }, {  74,2394 }, {  75,2394 },
 {  76,2394 }, {  77,2394 }, {  78,2394 }, {  79,2394 }, {  80,2394 },
 {  81,2394 }, {  82,2394 }, {  83,2394 }, {  84,2394 }, {  85,2394 },
 {  86,2394 }, {  87,2394 }, {  88,2394 }, {  89,2394 }, {  90,2394 },
 {  91,2394 }, {  92,2394 }, {  93,2394 }, {  94,2394 }, {  95,2394 },
 {  96,2394 }, {  97,2394 }, {  98,2394 }, {  99,2394 }, { 100,2394 },
 { 101,2394 }, { 102,2394 }, { 103,2394 }, { 104,2394 }, { 105,2394 },

 { 106,2394 }, { 107,2394 }, { 108,2394 }, { 109,2394 }, { 110,2394 },
 { 111,2394 }, { 112,2394 }, { 113,2394 }, { 114,2394 }, { 115,2394 },
 { 116,2394 }, { 117,2394 }, { 118,2394 }, { 119,2394 }, { 120,2394 },
 { 121,2394 }, { 122,2394 }, { 123,2394 }, { 124,2394 }, { 125,2394 },
 { 126,2394 }, { 127,2394 }, { 128,2394 }, { 129,2394 }, { 130,2394 },
 { 131,2394 }, { 132,2394 }, { 133,2394 }, { 134,2394 }, { 135,2394 },
 { 136,2394 }, { 137,2394 }, { 138,2394 }, { 139,2394 }, { 140,2394 },
 { 141,2394 }, { 142,2394 }, { 143,2394 }, { 144,2394 }, { 145,2394 },
 { 146,2394 }, { 147,2394 }, { 148,2394 }, { 149,2394 }, { 150,2394 },
 { 151,2394 }, { 152,2394 }, { 153,2394 }, { 154,2394 }, { 155,2394 },

 { 156,2394 }, { 157,2394 }, { 158,2394 }, { 159,2394 }, { 160,2394 },
 { 161,2394 }, { 162,2394 }, { 163,2394 }, { 164,2394 }, { 165,2394 },
 { 166,2394 }, { 167,2394 }, { 168,2394 }, { 169,2394 }, { 170,2394 },
 { 171,2394 }, { 172,2394 }, { 173,2394 }, { 174,2394 }, { 175,2394 },
 { 176,2394 }, { 177,2394 }, { 178,2394 }, { 179,2394 }, { 180,2394 },
 { 181,2394 }, { 182,2394 }, { 183,2394 }, { 184,2394 }, { 185,2394 },
 { 186,2394 }, { 187,2394 }, { 188,2394 }, { 189,2394 }, { 190,2394 },
 { 191,2394 }, { 192,2394 }, { 193,2394 }, { 194,2394 }, { 195,2394 },
 { 196,2394 }, { 197,2394 }, { 198,2394 }, { 199,2394 }, { 200,2394 },
 { 201,2394 }, { 202,2394 }, { 203,2394 }, { 204,2394 }, { 205,2394 },

 { 206,2394 }, { 207,2394 }, { 208,2394 }, { 209,2394 }, { 210,2394 },
 { 211,2394 }, { 212,2394 }, { 213,2394 }, { 214,2394 }, { 215,2394 },
 { 216,2394 }, { 217,2394 }, { 218,2394 }, { 219,2394 }, { 220,2394 },
 { 221,2394 }, { 222,2394 }, { 223,2394 }, { 224,2394 }, { 225,2394 },
 { 226,2394 }, { 227,2394 }, { 228,2394 }, { 229,2394 }, { 230,2394 },
 { 231,2394 }, { 232,2394 }, { 233,2394 }, { 234,2394 }, { 235,2394 },
 { 236,2394 }, { 237,2394 }, { 238,2394 }, { 239,2394 }, { 240,2394 },
 { 241,2394 }, { 242,2394 }, { 243,2394 }, { 244,2394 }, { 245,2394 },
 { 246,2394 }, { 247,2394 }, { 248,2394 }, { 249,2394 }, { 250,2394 },
 { 251,2394 }, { 252,2394 }, { 253,2394 }, { 254,2394 }, { 255,2394 },

 { 256,2394 }, {   0,  18 }, {   0,4289 }, {   1,   0 }, {   2,   0 },
 {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 }, {   7,   0 },
 {   8,   0 }, {   9, 258 }, {  10,-4194 }, {  11,   0 }, {  12, 258 },
 {  13,-4194 }, {  14,   0 }, {  15,   0 }, {  16,   0 }, {  17,   0 },
 {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 }, {  22,   0 },
 {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 }, {  27,   0 },
 {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 }, {  32, 258 },
 {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 }, {  37,   0 },
 {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 }, {  42,   0 },
 {  43,   0 }, {  44,   0 }, {  45, 516 }, {  46,   0 }, {  47,   0 },

 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 }, {  62,   0 },
 {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },
 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 }, {  92,   0 },
 {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 }, {  97,   0 },

 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 }, { 127,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },
 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },

 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },
 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },

 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },
 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },

 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 }, {   0,  18 },
 {   0,4031 }, {   1,-258 }, {   2,-258 }, {   3,-258 }, {   4,-258 },
 {   5,-258 }, {   6,-258 }, {   7,-258 }, {   8,-258 }, {   9,   0 },
 {  10,-4452 }, {  11,-258 }, {  12,   0 }, {  13,-4452 }, {  14,-258 },
 {  15,-258 }, {  16,-258 }, {  17,-258 }, {  18,-258 }, {  19,-258 },
 {  20,-258 }, {  21,-258 }, {  22,-258 }, {  23,-258 }, {  24,-258 },
 {  25,-258 }, {  26,-258 }, {  27,-258 }, {  28,-258 }, {  29,-258 },
 {  30,-258 }, {  31,-258 }, {  32,   0 }, {  33,-258 }, {  34,-258 },
 {  35,-258 }, {  36,-258 }, {  37,-258 }, {  38,-258 }, {  39,-258 },

 {  40,-258 }, {  41,-258 }, {  42,-258 }, {  43,-258 }, {  44,-258 },
 {  45, 258 }, {  46,-258 }, {  47,-258 }, {  48,-258 }, {  49,-258 },
 {  50,-258 }, {  51,-258 }, {  52,-258 }, {  53,-258 }, {  54,-258 },
 {  55,-258 }, {  56,-258 }, {  57,-258 }, {  58,-258 }, {  59,-258 },
 {  60,-258 }, {  61,-258 }, {  62,-258 }, {  63,-258 }, {  64,-258 },
 {  65,-258 }, {  66,-258 }, {  67,-258 }, {  68,-258 }, {  69,-258 },
 {  70,-258 }, {  71,-258 }, {  72,-258 }, {  73,-258 }, {  74,-258 },
 {  75,-258 }, {  76,-258 }, {  77,-258 }, {  78,-258 }, {  79,-258 },
 {  80,-258 }, {  81,-258 }, {  82,-258 }, {  83,-258 }, {  84,-258 },
 {  85,-258 }, {  86,-258 }, {  87,-258 }, {  88,-258 }, {  89,-258 },

 {  90,-258 }, {  91,-258 }, {  92,-258 }, {  93,-258 }, {  94,-258 },
 {  95,-258 }, {  96,-258 }, {  97,-258 }, {  98,-258 }, {  99,-258 },
 { 100,-258 }, { 101,-258 }, { 102,-258 }, { 103,-258 }, { 104,-258 },
 { 105,-258 }, { 106,-258 }, { 107,-258 }, { 108,-258 }, { 109,-258 },
 { 110,-258 }, { 111,-258 }, { 112,-258 }, { 113,-258 }, { 114,-258 },
 { 115,-258 }, { 116,-258 }, { 117,-258 }, { 118,-258 }, { 119,-258 },
 { 120,-258 }, { 121,-258 }, { 122,-258 }, { 123,-258 }, { 124,-258 },
 { 125,-258 }, { 126,-258 }, { 127,-258 }, { 128,-258 }, { 129,-258 },
 { 130,-258 }, { 131,-258 }, { 132,-258 }, { 133,-258 }, { 134,-258 },
 { 135,-258 }, { 136,-258 }, { 137,-258 }, { 138,-258 }, { 139,-258 },

 { 140,-258 }, { 141,-258 }, { 142,-258 }, { 143,-258 }, { 144,-258 },
 { 145,-258 }, { 146,-258 }, { 147,-258 }, { 148,-258 }, { 149,-258 },
 { 150,-258 }, { 151,-258 }, { 152,-258 }, { 153,-258 }, { 154,-258 },
 { 155,-258 }, { 156,-258 }, { 157,-258 }, { 158,-258 }, { 159,-258 },
 { 160,-258 }, { 161,-258 }, { 162,-258 }, { 163,-258 }, { 164,-258 },
 { 165,-258 }, { 166,-258 }, { 167,-258 }, { 168,-258 }, { 169,-258 },
 { 170,-258 }, { 171,-258 }, { 172,-258 }, { 173,-258 }, { 174,-258 },
 { 175,-258 }, { 176,-258 }, { 177,-258 }, { 178,-258 }, { 179,-258 },
 { 180,-258 }, { 181,-258 }, { 182,-258 }, { 183,-258 }, { 184,-258 },
 { 185,-258 }, { 186,-258 }, { 187,-258 }, { 188,-258 }, { 189,-258 },

 { 190,-258 }, { 191,-258 }, { 192,-258 }, { 193,-258 }, { 194,-258 },
 { 195,-258 }, { 196,-258 }, { 197,-258 }, { 198,-258 }, { 199,-258 },
 { 200,-258 }, { 201,-258 }, { 202,-258 }, { 203,-258 }, { 204,-258 },
 { 205,-258 }, { 206,-258 }, { 207,-258 }, { 208,-258 }, { 209,-258 },
 { 210,-258 }, { 211,-258 }, { 212,-258 }, { 213,-258 }, { 214,-258 },
 { 215,-258 }, { 216,-258 }, { 217,-258 }, { 218,-258 }, { 219,-258 },
 { 220,-258 }, { 221,-258 }, { 222,-258 }, { 223,-258 }, { 224,-258 },
 { 225,-258 }, { 226,-258 }, { 227,-258 }, { 228,-258 }, { 229,-258 },
 { 230,-258 }, { 231,-258 }, { 232,-258 }, { 233,-258 }, { 234,-258 },
 { 235,-258 }, { 236,-258 }, { 237,-258 }, { 238,-258 }, { 239,-258 },

 { 240,-258 }, { 241,-258 }, { 242,-258 }, { 243,-258 }, { 244,-258 },
 { 245,-258 }, { 246,-258 }, { 247,-258 }, { 248,-258 }, { 249,-258 },
 { 250,-258 }, { 251,-258 }, { 252,-258 }, { 253,-258 }, { 254,-258 },
 { 255,-258 }, { 256,-258 }, {   0,  18 }, {   0,3773 }, {   1,-516 },
 {   2,-516 }, {   3,-516 }, {   4,-516 }, {   5,-516 }, {   6,-516 },
 {   7,-516 }, {   8,-516 }, {   9,-258 }, {  10,-4710 }, {  11,-516 },
 {  12,-258 }, {  13,-4710 }, {  14,-516 }, {  15,-516 }, {  16,-516 },
 {  17,-516 }, {  18,-516 }, {  19,-516 }, {  20,-516 }, {  21,-516 },
 {  22,-516 }, {  23,-516 }, {  24,-516 }, {  25,-516 }, {  26,-516 },
 {  27,-516 }, {  28,-516 }, {  29,-516 }, {  30,-516 }, {  31,-516 },

 {  32,-258 }, {  33,-516 }, {  34,-516 }, {  35,-516 }, {  36,-516 },
 {  37,-516 }, {  38,-516 }, {  39,-516 }, {  40,-516 }, {  41,-516 },
 {  42,-516 }, {  43,-516 }, {  44,-516 }, {  45,2441 }, {  46,-516 },
 {  47,-516 }, {  48,-516 }, {  49,-516 }, {  50,-516 }, {  51,-516 },
 {  52,-516 }, {  53,-516 }, {  54,-516 }, {  55,-516 }, {  56,-516 },
 {  57,-516 }, {  58,-516 }, {  59,-516 }, {  60,-516 }, {  61,-516 },
 {  62,-516 }, {  63,-516 }, {  64,-516 }, {  65,-516 }, {  66,-516 },
 {  67,-516 }, {  68,-516 }, {  69,-516 }, {  70,-516 }, {  71,-516 },
 {  72,-516 }, {  73,-516 }, {  74,-516 }, {  75,-516 }, {  76,-516 },
 {  77,-516 }, {  78,-516 }, {  79,-516 }, {  80,-516 }, {  81,-516 },

 {  82,-516 }, {  83,-516 }, {  84,-516 }, {  85,-516 }, {  86,-516 },
 {  87,-516 }, {  88,-516 }, {  89,-516 }, {  90,-516 }, {  91,-516 },
 {  92,-516 }, {  93,-516 }, {  94,-516 }, {  95,-516 }, {  96,-516 },
 {  97,-516 }, {  98,-516 }, {  99,-516 }, { 100,-516 }, { 101,-516 },
 { 102,-516 }, { 103,-516 }, { 104,-516 }, { 105,-516 }, { 106,-516 },
 { 107,-516 }, { 108,-516 }, { 109,-516 }, { 110,-516 }, { 111,-516 },
 { 112,-516 }, { 113,-516 }, { 114,-516 }, { 115,-516 }, { 116,-516 },
 { 117,-516 }, { 118,-516 }, { 119,-516 }, { 120,-516 }, { 121,-516 },
 { 122,-516 }, { 123,-516 }, { 124,-516 }, { 125,-516 }, { 126,-516 },
 { 127,-516 }, { 128,-516 }, { 129,-516 }, { 130,-516 }, { 131,-516 },

 { 132,-516 }, { 133,-516 }, { 134,-516 }, { 135,-516 }, { 136,-516 },
 { 137,-516 }, { 138,-516 }, { 139,-516 }, { 140,-516 }, { 141,-516 },
 { 142,-516 }, { 143,-516 }, { 144,-516 }, { 145,-516 }, { 146,-516 },
 { 147,-516 }, { 148,-516 }, { 149,-516 }, { 150,-516 }, { 151,-516 },
 { 152,-516 }, { 153,-516 }, { 154,-516 }, { 155,-516 }, { 156,-516 },
 { 157,-516 }, { 158,-516 }, { 159,-516 }, { 160,-516 }, { 161,-516 },
 { 162,-516 }, { 163,-516 }, { 164,-516 }, { 165,-516 }, { 166,-516 },
 { 167,-516 }, { 168,-516 }, { 169,-516 }, { 170,-516 }, { 171,-516 },
 { 172,-516 }, { 173,-516 }, { 174,-516 }, { 175,-516 }, { 176,-516 },
 { 177,-516 }, { 178,-516 }, { 179,-516 }, { 180,-516 }, { 181,-516 },

 { 182,-516 }, { 183,-516 }, { 184,-516 }, { 185,-516 }, { 186,-516 },
 { 187,-516 }, { 188,-516 }, { 189,-516 }, { 190,-516 }, { 191,-516 },
 { 192,-516 }, { 193,-516 }, { 194,-516 }, { 195,-516 }, { 196,-516 },
 { 197,-516 }, { 198,-516 }, { 199,-516 }, { 200,-516 }, { 201,-516 },
 { 202,-516 }, { 203,-516 }, { 204,-516 }, { 205,-516 }, { 206,-516 },
 { 207,-516 }, { 208,-516 }, { 209,-516 }, { 210,-516 }, { 211,-516 },
 { 212,-516 }, { 213,-516 }, { 214,-516 }, { 215,-516 }, { 216,-516 },
 { 217,-516 }, { 218,-516 }, { 219,-516 }, { 220,-516 }, { 221,-516 },
 { 222,-516 }, { 223,-516 }, { 224,-516 }, { 225,-516 }, { 226,-516 },
 { 227,-516 }, { 228,-516 }, { 229,-516 }, { 230,-516 }, { 231,-516 },

 { 232,-516 }, { 233,-516 }, { 234,-516 }, { 235,-516 }, { 236,-516 },
 { 237,-516 }, { 238,-516 }, { 239,-516 }, { 240,-516 }, { 241,-516 },
 { 242,-516 }, { 243,-516 }, { 244,-516 }, { 245,-516 }, { 246,-516 },
 { 247,-516 }, { 248,-516 }, { 249,-516 }, { 250,-516 }, { 251,-516 },
 { 252,-516 }, { 253,-516 }, { 254,-516 }, { 255,-516 }, { 256,-516 },
 {   0,  29 }, {   0,3515 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0,3507 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  27 }, {   0,3484 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-13651 },
 {  49,-13651 }, {  50,-13651 }, {  51,-13651 }, {  52,-13651 }, {  53,-13651 },
 {  54,-13651 }, {  55,-13651 }, {  48,2433 }, {  49,2433 }, {  50,2433 },
 {  51,2433 }, {  52,2433 }, {  53,2433 }, {  54,2433 }, {  55,2433 },
 {  56,2433 }, {  57,2433 }, {   0,   0 }, {   0,   0 }, {   0,  30 },
 {   0,3446 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,2433 },

 {  66,2433 }, {  67,2433 }, {  68,2433 }, {  69,2433 }, {  70,2433 },
 {  48,2433 }, {  49,2433 }, {  50,2433 }, {  51,2433 }, {  52,2433 },
 {  53,2433 }, {  54,2433 }, {  55,2433 }, {  56,2433 }, {  57,2433 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,2433 }, {  66,2433 }, {  67,2433 },
 {  68,2433 }, {  69,2433 }, {  70,2433 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,2433 }, {  98,2433 }, {  99,2433 }, { 100,2433 },
 { 101,2433 }, { 102,2433 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-13718 }, {  49,-13718 },
 {  50,-13718 }, {  51,-13718 }, {  52,-13718 }, {  53,-13718 }, {  54,-13718 },

 {  55,-13718 }, {  56,-13718 }, {  57,-13718 }, {   0,   0 }, {  97,2433 },
 {  98,2433 }, {  99,2433 }, { 100,2433 }, { 101,2433 }, { 102,2433 },
 {  65,-13718 }, {  66,-13718 }, {  67,-13718 }, {  68,-13718 }, {  69,-13718 },
 {  70,-13718 }, {   0,  36 }, {   0,3374 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97,-13718 }, {  98,-13718 }, {  99,-13718 },
 { 100,-13718 }, { 101,-13718 }, { 102,-13718 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  36,-14089 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 }, {  72,   0 },
 {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 }, {  77,   0 },
 {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 }, {  82,   0 },

 {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 }, {  87,   0 },
 {  88,   0 }, {  89,   0 }, {  90,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95,   0 }, {   0,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 }, { 107,   0 },
 { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 }, { 112,   0 },
 { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 }, { 117,   0 },
 { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 }, { 122,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 }, { 132,   0 },

 { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 }, { 137,   0 },
 { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 }, { 142,   0 },
 { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 }, { 147,   0 },
 { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 }, { 152,   0 },
 { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 }, { 157,   0 },
 { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 }, { 162,   0 },
 { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 }, { 167,   0 },
 { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 }, { 172,   0 },
 { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 }, { 177,   0 },
 { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 }, { 182,   0 },

 { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 }, { 187,   0 },
 { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 }, { 192,   0 },
 { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 }, { 197,   0 },
 { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 }, { 202,   0 },
 { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 }, { 207,   0 },
 { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 }, { 212,   0 },
 { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 }, { 217,   0 },
 { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 }, { 222,   0 },
 { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 }, { 227,   0 },
 { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 }, { 232,   0 },

 { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 }, { 237,   0 },
 { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 }, { 242,   0 },
 { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 }, { 247,   0 },
 { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 }, { 252,   0 },
 { 253,   0 }, { 254,   0 }, { 255,   0 }, {   0,  27 }, {   0,3117 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  27 }, {   0,3094 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,2104 }, {  49,2104 }, {  50,2104 },
 {  51,2104 }, {  52,2104 }, {  53,2104 }, {  54,2104 }, {  55,2104 },
 {  56,2104 }, {  57,2104 }, {   0,   0 }, {   0,   0 }, {   0,  64 },
 {   0,3056 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,2104 },
 {  66,2104 }, {  67,2104 }, {  68,2104 }, {  69,2104 }, {  70,2104 },
 {  48,2104 }, {  49,2104 }, {  50,2104 }, {  51,2104 }, {  52,2104 },

 {  53,2104 }, {  54,2104 }, {  55,2104 }, {  56,2104 }, {  57,2104 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,2104 }, {  66,2104 }, {  67,2104 },
 {  68,2104 }, {  69,2104 }, {  70,2104 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,2104 }, {  98,2104 }, {  99,2104 }, { 100,2104 },
 { 101,2104 }, { 102,2104 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,   0 }, {  49,   0 },
 {  50,   0 }, {  51,   0 }, {  52,   0 }, {  53,   0 }, {  54,   0 },
 {  55,   0 }, {  56,   0 }, {  57,   0 }, {   0,   0 }, {  97,2104 },
 {  98,2104 }, {  99,2104 }, { 100,2104 }, { 101,2104 }, { 102,2104 },

 {  65,-14402 }, {  66,-14402 }, {  67,-14402 }, {  68,-14402 }, {  69,-3048 },
 {  70,-14402 }, {  71,-14402 }, {  72,-14402 }, {  73,-14402 }, {  74,-14402 },
 {  75,-14402 }, {  76,-14402 }, {  77,-14402 }, {  78,-14402 }, {  79,-14402 },
 {  80,-14402 }, {  81,-14402 }, {  82,-14402 }, {  83,-14402 }, {  84,-14402 },
 {  85,-14402 }, {  86,-14402 }, {  87,-14402 }, {  88,-14402 }, {  89,-14402 },
 {  90,-14402 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  95, 257 }, {   0,   0 }, {  97,-14402 }, {  98,-14402 }, {  99,-14402 },
 { 100,-14402 }, { 101,-3048 }, { 102,-14402 }, { 103,-14402 }, { 104,-14402 },
 { 105,-14402 }, { 106,-14402 }, { 107,-14402 }, { 108,-14402 }, { 109,-14402 },
 { 110,-14402 }, { 111,-14402 }, { 112,-14402 }, { 113,-14402 }, { 114,-14402 },

 { 115,-14402 }, { 116,-14402 }, { 117,-14402 }, { 118,-14402 }, { 119,-14402 },
 { 120,-14402 }, { 121,-14402 }, { 122,-14402 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, { 128,-14402 }, { 129,-14402 },
 { 130,-14402 }, { 131,-14402 }, { 132,-14402 }, { 133,-14402 }, { 134,-14402 },
 { 135,-14402 }, { 136,-14402 }, { 137,-14402 }, { 138,-14402 }, { 139,-14402 },
 { 140,-14402 }, { 141,-14402 }, { 142,-14402 }, { 143,-14402 }, { 144,-14402 },
 { 145,-14402 }, { 146,-14402 }, { 147,-14402 }, { 148,-14402 }, { 149,-14402 },
 { 150,-14402 }, { 151,-14402 }, { 152,-14402 }, { 153,-14402 }, { 154,-14402 },
 { 155,-14402 }, { 156,-14402 }, { 157,-14402 }, { 158,-14402 }, { 159,-14402 },
 { 160,-14402 }, { 161,-14402 }, { 162,-14402 }, { 163,-14402 }, { 164,-14402 },

 { 165,-14402 }, { 166,-14402 }, { 167,-14402 }, { 168,-14402 }, { 169,-14402 },
 { 170,-14402 }, { 171,-14402 }, { 172,-14402 }, { 173,-14402 }, { 174,-14402 },
 { 175,-14402 }, { 176,-14402 }, { 177,-14402 }, { 178,-14402 }, { 179,-14402 },
 { 180,-14402 }, { 181,-14402 }, { 182,-14402 }, { 183,-14402 }, { 184,-14402 },
 { 185,-14402 }, { 186,-14402 }, { 187,-14402 }, { 188,-14402 }, { 189,-14402 },
 { 190,-14402 }, { 191,-14402 }, { 192,-14402 }, { 193,-14402 }, { 194,-14402 },
 { 195,-14402 }, { 196,-14402 }, { 197,-14402 }, { 198,-14402 }, { 199,-14402 },
 { 200,-14402 }, { 201,-14402 }, { 202,-14402 }, { 203,-14402 }, { 204,-14402 },
 { 205,-14402 }, { 206,-14402 }, { 207,-14402 }, { 208,-14402 }, { 209,-14402 },
 { 210,-14402 }, { 211,-14402 }, { 212,-14402 }, { 213,-14402 }, { 214,-14402 },

 { 215,-14402 }, { 216,-14402 }, { 217,-14402 }, { 218,-14402 }, { 219,-14402 },
 { 220,-14402 }, { 221,-14402 }, { 222,-14402 }, { 223,-14402 }, { 224,-14402 },
 { 225,-14402 }, { 226,-14402 }, { 227,-14402 }, { 228,-14402 }, { 229,-14402 },
 { 230,-14402 }, { 231,-14402 }, { 232,-14402 }, { 233,-14402 }, { 234,-14402 },
 { 235,-14402 }, { 236,-14402 }, { 237,-14402 }, { 238,-14402 }, { 239,-14402 },
 { 240,-14402 }, { 241,-14402 }, { 242,-14402 }, { 243,-14402 }, { 244,-14402 },
 { 245,-14402 }, { 246,-14402 }, { 247,-14402 }, { 248,-14402 }, { 249,-14402 },
 { 250,-14402 }, { 251,-14402 }, { 252,-14402 }, { 253,-14402 }, { 254,-14402 },
 { 255,-14402 }, {   0,  72 }, {   0,2799 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,  66 }, {   0,2789 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,-257 }, {  49,-257 }, {  50,-257 }, {  51,-257 }, {  52,-257 },
 {  53,-257 }, {  54,-257 }, {  55,-257 }, {  56,-257 }, {  57,-257 },

 {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 }, {  52,   0 },
 {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 }, {  57,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-14383 }, {  66,-14383 }, {  67,-14383 },
 {  68,-14383 }, {  69,-14383 }, {  70,-14383 }, {  71,-14383 }, {  72,-14383 },
 {  73,-14383 }, {  74,-14383 }, {  75,-14383 }, {  76,-14383 }, {  77,-14383 },
 {  78,-14383 }, {  79,-14383 }, {  80,-14383 }, {  81,-14383 }, {  82,-14383 },
 {  83,-14383 }, {  84,-14383 }, {  85,-14383 }, {  86,-14383 }, {  87,-14383 },
 {  88,-14383 }, {  89,-14383 }, {  90,-14383 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95, 257 }, {   0,   0 }, {  97,-14383 },

 {  98,-14383 }, {  99,-14383 }, { 100,-14383 }, { 101,-14383 }, { 102,-14383 },
 { 103,-14383 }, { 104,-14383 }, { 105,-14383 }, { 106,-14383 }, { 107,-14383 },
 { 108,-14383 }, { 109,-14383 }, { 110,-14383 }, { 111,-14383 }, { 112,-14383 },
 { 113,-14383 }, { 114,-14383 }, { 115,-14383 }, { 116,-14383 }, { 117,-14383 },
 { 118,-14383 }, { 119,-14383 }, { 120,-14383 }, { 121,-14383 }, { 122,-14383 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,-14383 }, { 129,-14383 }, { 130,-14383 }, { 131,-14383 }, { 132,-14383 },
 { 133,-14383 }, { 134,-14383 }, { 135,-14383 }, { 136,-14383 }, { 137,-14383 },
 { 138,-14383 }, { 139,-14383 }, { 140,-14383 }, { 141,-14383 }, { 142,-14383 },
 { 143,-14383 }, { 144,-14383 }, { 145,-14383 }, { 146,-14383 }, { 147,-14383 },

 { 148,-14383 }, { 149,-14383 }, { 150,-14383 }, { 151,-14383 }, { 152,-14383 },
 { 153,-14383 }, { 154,-14383 }, { 155,-14383 }, { 156,-14383 }, { 157,-14383 },
 { 158,-14383 }, { 159,-14383 }, { 160,-14383 }, { 161,-14383 }, { 162,-14383 },
 { 163,-14383 }, { 164,-14383 }, { 165,-14383 }, { 166,-14383 }, { 167,-14383 },
 { 168,-14383 }, { 169,-14383 }, { 170,-14383 }, { 171,-14383 }, { 172,-14383 },
 { 173,-14383 }, { 174,-14383 }, { 175,-14383 }, { 176,-14383 }, { 177,-14383 },
 { 178,-14383 }, { 179,-14383 }, { 180,-14383 }, { 181,-14383 }, { 182,-14383 },
 { 183,-14383 }, { 184,-14383 }, { 185,-14383 }, { 186,-14383 }, { 187,-14383 },
 { 188,-14383 }, { 189,-14383 }, { 190,-14383 }, { 191,-14383 }, { 192,-14383 },
 { 193,-14383 }, { 194,-14383 }, { 195,-14383 }, { 196,-14383 }, { 197,-14383 },

 { 198,-14383 }, { 199,-14383 }, { 200,-14383 }, { 201,-14383 }, { 202,-14383 },
 { 203,-14383 }, { 204,-14383 }, { 205,-14383 }, { 206,-14383 }, { 207,-14383 },
 { 208,-14383 }, { 209,-14383 }, { 210,-14383 }, { 211,-14383 }, { 212,-14383 },
 { 213,-14383 }, { 214,-14383 }, { 215,-14383 }, { 216,-14383 }, { 217,-14383 },
 { 218,-14383 }, { 219,-14383 }, { 220,-14383 }, { 221,-14383 }, { 222,-14383 },
 { 223,-14383 }, { 224,-14383 }, { 225,-14383 }, { 226,-14383 }, { 227,-14383 },
 { 228,-14383 }, { 229,-14383 }, { 230,-14383 }, { 231,-14383 }, { 232,-14383 },
 { 233,-14383 }, { 234,-14383 }, { 235,-14383 }, { 236,-14383 }, { 237,-14383 },
 { 238,-14383 }, { 239,-14383 }, { 240,-14383 }, { 241,-14383 }, { 242,-14383 },
 { 243,-14383 }, { 244,-14383 }, { 245,-14383 }, { 246,-14383 }, { 247,-14383 },

 { 248,-14383 }, { 249,-14383 }, { 250,-14383 }, { 251,-14383 }, { 252,-14383 },
 { 253,-14383 }, { 254,-14383 }, { 255,-14383 }, {   0,  73 }, {   0,2532 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  70 }, {   0,2522 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,  58 }, {   0,2514 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,-257 }, {  49,-257 }, {  50,-257 },
 {  51,-257 }, {  52,-257 }, {  53,-257 }, {  54,-257 }, {  55,-257 },
 {  56,-257 }, {  57,-257 }, {  48,-2710 }, {  49,-2710 }, {  50,-2710 },
 {  51,-2710 }, {  52,-2710 }, {  53,-2710 }, {  54,-2710 }, {  55,-2710 },
 {  48,-2461 }, {  49,-2461 }, {  50,-2461 }, {  51,-2461 }, {  52,-2461 },
 {  53,-2461 }, {  54,-2461 }, {  55,-2461 }, {  56,-2461 }, {  57,-2461 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,   0 }, {  66,   0 }, {  67,   0 },
 {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,-14654 }, {  72,-14654 },

 {  73,-14654 }, {  74,-14654 }, {  75,-14654 }, {  76,-14654 }, {  77,-14654 },
 {  78,-14654 }, {  79,-14654 }, {  80,-14654 }, {  81,-14654 }, {  82,-14654 },
 {  83,-14654 }, {  84,-14654 }, {  85,-14654 }, {  86,-14654 }, {  87,-14654 },
 {  88,-14654 }, {  89,-14654 }, {  90,-14654 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  95, 257 }, {   0,   0 }, {  97,   0 },
 {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 }, { 102,   0 },
 { 103,-14654 }, { 104,-14654 }, { 105,-14654 }, { 106,-14654 }, { 107,-14654 },
 { 108,-14654 }, { 109,-14654 }, { 110,-14654 }, { 111,-14654 }, { 112,-14654 },
 { 113,-14654 }, { 114,-14654 }, { 115,-14654 }, { 116,-14654 }, { 117,-14654 },
 { 118,-14654 }, { 119,-14654 }, { 120,-14654 }, { 121,-14654 }, { 122,-14654 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 128,-14654 }, { 129,-14654 }, { 130,-14654 }, { 131,-14654 }, { 132,-14654 },
 { 133,-14654 }, { 134,-14654 }, { 135,-14654 }, { 136,-14654 }, { 137,-14654 },
 { 138,-14654 }, { 139,-14654 }, { 140,-14654 }, { 141,-14654 }, { 142,-14654 },
 { 143,-14654 }, { 144,-14654 }, { 145,-14654 }, { 146,-14654 }, { 147,-14654 },
 { 148,-14654 }, { 149,-14654 }, { 150,-14654 }, { 151,-14654 }, { 152,-14654 },
 { 153,-14654 }, { 154,-14654 }, { 155,-14654 }, { 156,-14654 }, { 157,-14654 },
 { 158,-14654 }, { 159,-14654 }, { 160,-14654 }, { 161,-14654 }, { 162,-14654 },
 { 163,-14654 }, { 164,-14654 }, { 165,-14654 }, { 166,-14654 }, { 167,-14654 },
 { 168,-14654 }, { 169,-14654 }, { 170,-14654 }, { 171,-14654 }, { 172,-14654 },

 { 173,-14654 }, { 174,-14654 }, { 175,-14654 }, { 176,-14654 }, { 177,-14654 },
 { 178,-14654 }, { 179,-14654 }, { 180,-14654 }, { 181,-14654 }, { 182,-14654 },
 { 183,-14654 }, { 184,-14654 }, { 185,-14654 }, { 186,-14654 }, { 187,-14654 },
 { 188,-14654 }, { 189,-14654 }, { 190,-14654 }, { 191,-14654 }, { 192,-14654 },
 { 193,-14654 }, { 194,-14654 }, { 195,-14654 }, { 196,-14654 }, { 197,-14654 },
 { 198,-14654 }, { 199,-14654 }, { 200,-14654 }, { 201,-14654 }, { 202,-14654 },
 { 203,-14654 }, { 204,-14654 }, { 205,-14654 }, { 206,-14654 }, { 207,-14654 },
 { 208,-14654 }, { 209,-14654 }, { 210,-14654 }, { 211,-14654 }, { 212,-14654 },
 { 213,-14654 }, { 214,-14654 }, { 215,-14654 }, { 216,-14654 }, { 217,-14654 },
 { 218,-14654 }, { 219,-14654 }, { 220,-14654 }, { 221,-14654 }, { 222,-14654 },

 { 223,-14654 }, { 224,-14654 }, { 225,-14654 }, { 226,-14654 }, { 227,-14654 },
 { 228,-14654 }, { 229,-14654 }, { 230,-14654 }, { 231,-14654 }, { 232,-14654 },
 { 233,-14654 }, { 234,-14654 }, { 235,-14654 }, { 236,-14654 }, { 237,-14654 },
 { 238,-14654 }, { 239,-14654 }, { 240,-14654 }, { 241,-14654 }, { 242,-14654 },
 { 243,-14654 }, { 244,-14654 }, { 245,-14654 }, { 246,-14654 }, { 247,-14654 },
 { 248,-14654 }, { 249,-14654 }, { 250,-14654 }, { 251,-14654 }, { 252,-14654 },
 { 253,-14654 }, { 254,-14654 }, { 255,-14654 }, {   0,  69 }, {   0,2257 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,-2718 }, {  49,-2718 }, {  50,-2718 },
 {  51,-2718 }, {  52,-2718 }, {  53,-2718 }, {  54,-2718 }, {  55,-2718 },
 {  56,-2718 }, {  57,-2718 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-2718 },

 {  66,-2718 }, {  67,-2718 }, {  68,-2718 }, {  69,-2718 }, {  70,-2718 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,-2718 }, {  98,-2718 }, {  99,-2718 }, { 100,-2718 },
 { 101,-2718 }, { 102,-2718 }, {   0,  18 }, {   0,2153 }, {   1,   0 },
 {   2,   0 }, {   3,   0 }, {   4,   0 }, {   5,   0 }, {   6,   0 },
 {   7,   0 }, {   8,   0 }, {   9, 258 }, {  10, 516 }, {  11,   0 },

 {  12, 258 }, {  13, 516 }, {  14,   0 }, {  15,   0 }, {  16,   0 },
 {  17,   0 }, {  18,   0 }, {  19,   0 }, {  20,   0 }, {  21,   0 },
 {  22,   0 }, {  23,   0 }, {  24,   0 }, {  25,   0 }, {  26,   0 },
 {  27,   0 }, {  28,   0 }, {  29,   0 }, {  30,   0 }, {  31,   0 },
 {  32, 258 }, {  33,   0 }, {  34,   0 }, {  35,   0 }, {  36,   0 },
 {  37,   0 }, {  38,   0 }, {  39,   0 }, {  40,   0 }, {  41,   0 },
 {  42,   0 }, {  43,   0 }, {  44,   0 }, {  45, 563 }, {  46,   0 },
 {  47,   0 }, {  48,   0 }, {  49,   0 }, {  50,   0 }, {  51,   0 },
 {  52,   0 }, {  53,   0 }, {  54,   0 }, {  55,   0 }, {  56,   0 },
 {  57,   0 }, {  58,   0 }, {  59,   0 }, {  60,   0 }, {  61,   0 },

 {  62,   0 }, {  63,   0 }, {  64,   0 }, {  65,   0 }, {  66,   0 },
 {  67,   0 }, {  68,   0 }, {  69,   0 }, {  70,   0 }, {  71,   0 },
 {  72,   0 }, {  73,   0 }, {  74,   0 }, {  75,   0 }, {  76,   0 },
 {  77,   0 }, {  78,   0 }, {  79,   0 }, {  80,   0 }, {  81,   0 },
 {  82,   0 }, {  83,   0 }, {  84,   0 }, {  85,   0 }, {  86,   0 },
 {  87,   0 }, {  88,   0 }, {  89,   0 }, {  90,   0 }, {  91,   0 },
 {  92,   0 }, {  93,   0 }, {  94,   0 }, {  95,   0 }, {  96,   0 },
 {  97,   0 }, {  98,   0 }, {  99,   0 }, { 100,   0 }, { 101,   0 },
 { 102,   0 }, { 103,   0 }, { 104,   0 }, { 105,   0 }, { 106,   0 },
 { 107,   0 }, { 108,   0 }, { 109,   0 }, { 110,   0 }, { 111,   0 },

 { 112,   0 }, { 113,   0 }, { 114,   0 }, { 115,   0 }, { 116,   0 },
 { 117,   0 }, { 118,   0 }, { 119,   0 }, { 120,   0 }, { 121,   0 },
 { 122,   0 }, { 123,   0 }, { 124,   0 }, { 125,   0 }, { 126,   0 },
 { 127,   0 }, { 128,   0 }, { 129,   0 }, { 130,   0 }, { 131,   0 },
 { 132,   0 }, { 133,   0 }, { 134,   0 }, { 135,   0 }, { 136,   0 },
 { 137,   0 }, { 138,   0 }, { 139,   0 }, { 140,   0 }, { 141,   0 },
 { 142,   0 }, { 143,   0 }, { 144,   0 }, { 145,   0 }, { 146,   0 },
 { 147,   0 }, { 148,   0 }, { 149,   0 }, { 150,   0 }, { 151,   0 },
 { 152,   0 }, { 153,   0 }, { 154,   0 }, { 155,   0 }, { 156,   0 },
 { 157,   0 }, { 158,   0 }, { 159,   0 }, { 160,   0 }, { 161,   0 },

 { 162,   0 }, { 163,   0 }, { 164,   0 }, { 165,   0 }, { 166,   0 },
 { 167,   0 }, { 168,   0 }, { 169,   0 }, { 170,   0 }, { 171,   0 },
 { 172,   0 }, { 173,   0 }, { 174,   0 }, { 175,   0 }, { 176,   0 },
 { 177,   0 }, { 178,   0 }, { 179,   0 }, { 180,   0 }, { 181,   0 },
 { 182,   0 }, { 183,   0 }, { 184,   0 }, { 185,   0 }, { 186,   0 },
 { 187,   0 }, { 188,   0 }, { 189,   0 }, { 190,   0 }, { 191,   0 },
 { 192,   0 }, { 193,   0 }, { 194,   0 }, { 195,   0 }, { 196,   0 },
 { 197,   0 }, { 198,   0 }, { 199,   0 }, { 200,   0 }, { 201,   0 },
 { 202,   0 }, { 203,   0 }, { 204,   0 }, { 205,   0 }, { 206,   0 },
 { 207,   0 }, { 208,   0 }, { 209,   0 }, { 210,   0 }, { 211,   0 },

 { 212,   0 }, { 213,   0 }, { 214,   0 }, { 215,   0 }, { 216,   0 },
 { 217,   0 }, { 218,   0 }, { 219,   0 }, { 220,   0 }, { 221,   0 },
 { 222,   0 }, { 223,   0 }, { 224,   0 }, { 225,   0 }, { 226,   0 },
 { 227,   0 }, { 228,   0 }, { 229,   0 }, { 230,   0 }, { 231,   0 },
 { 232,   0 }, { 233,   0 }, { 234,   0 }, { 235,   0 }, { 236,   0 },
 { 237,   0 }, { 238,   0 }, { 239,   0 }, { 240,   0 }, { 241,   0 },
 { 242,   0 }, { 243,   0 }, { 244,   0 }, { 245,   0 }, { 246,   0 },
 { 247,   0 }, { 248,   0 }, { 249,   0 }, { 250,   0 }, { 251,   0 },
 { 252,   0 }, { 253,   0 }, { 254,   0 }, { 255,   0 }, { 256,   0 },
 {   0,  18 }, {   0,1895 }, {   1,-258 }, {   2,-258 }, {   3,-258 },

 {   4,-258 }, {   5,-258 }, {   6,-258 }, {   7,-258 }, {   8,-258 },
 {   9,   0 }, {  10, 258 }, {  11,-258 }, {  12,   0 }, {  13, 258 },
 {  14,-258 }, {  15,-258 }, {  16,-258 }, {  17,-258 }, {  18,-258 },
 {  19,-258 }, {  20,-258 }, {  21,-258 }, {  22,-258 }, {  23,-258 },
 {  24,-258 }, {  25,-258 }, {  26,-258 }, {  27,-258 }, {  28,-258 },
 {  29,-258 }, {  30,-258 }, {  31,-258 }, {  32,   0 }, {  33,-258 },
 {  34,-258 }, {  35,-258 }, {  36,-258 }, {  37,-258 }, {  38,-258 },
 {  39,-258 }, {  40,-258 }, {  41,-258 }, {  42,-258 }, {  43,-258 },
 {  44,-258 }, {  45, 305 }, {  46,-258 }, {  47,-258 }, {  48,-258 },
 {  49,-258 }, {  50,-258 }, {  51,-258 }, {  52,-258 }, {  53,-258 },

 {  54,-258 }, {  55,-258 }, {  56,-258 }, {  57,-258 }, {  58,-258 },
 {  59,-258 }, {  60,-258 }, {  61,-258 }, {  62,-258 }, {  63,-258 },
 {  64,-258 }, {  65,-258 }, {  66,-258 }, {  67,-258 }, {  68,-258 },
 {  69,-258 }, {  70,-258 }, {  71,-258 }, {  72,-258 }, {  73,-258 },
 {  74,-258 }, {  75,-258 }, {  76,-258 }, {  77,-258 }, {  78,-258 },
 {  79,-258 }, {  80,-258 }, {  81,-258 }, {  82,-258 }, {  83,-258 },
 {  84,-258 }, {  85,-258 }, {  86,-258 }, {  87,-258 }, {  88,-258 },
 {  89,-258 }, {  90,-258 }, {  91,-258 }, {  92,-258 }, {  93,-258 },
 {  94,-258 }, {  95,-258 }, {  96,-258 }, {  97,-258 }, {  98,-258 },
 {  99,-258 }, { 100,-258 }, { 101,-258 }, { 102,-258 }, { 103,-258 },

 { 104,-258 }, { 105,-258 }, { 106,-258 }, { 107,-258 }, { 108,-258 },
 { 109,-258 }, { 110,-258 }, { 111,-258 }, { 112,-258 }, { 113,-258 },
 { 114,-258 }, { 115,-258 }, { 116,-258 }, { 117,-258 }, { 118,-258 },
 { 119,-258 }, { 120,-258 }, { 121,-258 }, { 122,-258 }, { 123,-258 },
 { 124,-258 }, { 125,-258 }, { 126,-258 }, { 127,-258 }, { 128,-258 },
 { 129,-258 }, { 130,-258 }, { 131,-258 }, { 132,-258 }, { 133,-258 },
 { 134,-258 }, { 135,-258 }, { 136,-258 }, { 137,-258 }, { 138,-258 },
 { 139,-258 }, { 140,-258 }, { 141,-258 }, { 142,-258 }, { 143,-258 },
 { 144,-258 }, { 145,-258 }, { 146,-258 }, { 147,-258 }, { 148,-258 },
 { 149,-258 }, { 150,-258 }, { 151,-258 }, { 152,-258 }, { 153,-258 },

 { 154,-258 }, { 155,-258 }, { 156,-258 }, { 157,-258 }, { 158,-258 },
 { 159,-258 }, { 160,-258 }, { 161,-258 }, { 162,-258 }, { 163,-258 },
 { 164,-258 }, { 165,-258 }, { 166,-258 }, { 167,-258 }, { 168,-258 },
 { 169,-258 }, { 170,-258 }, { 171,-258 }, { 172,-258 }, { 173,-258 },
 { 174,-258 }, { 175,-258 }, { 176,-258 }, { 177,-258 }, { 178,-258 },
 { 179,-258 }, { 180,-258 }, { 181,-258 }, { 182,-258 }, { 183,-258 },
 { 184,-258 }, { 185,-258 }, { 186,-258 }, { 187,-258 }, { 188,-258 },
 { 189,-258 }, { 190,-258 }, { 191,-258 }, { 192,-258 }, { 193,-258 },
 { 194,-258 }, { 195,-258 }, { 196,-258 }, { 197,-258 }, { 198,-258 },
 { 199,-258 }, { 200,-258 }, { 201,-258 }, { 202,-258 }, { 203,-258 },

 { 204,-258 }, { 205,-258 }, { 206,-258 }, { 207,-258 }, { 208,-258 },
 { 209,-258 }, { 210,-258 }, { 211,-258 }, { 212,-258 }, { 213,-258 },
 { 214,-258 }, { 215,-258 }, { 216,-258 }, { 217,-258 }, { 218,-258 },
 { 219,-258 }, { 220,-258 }, { 221,-258 }, { 222,-258 }, { 223,-258 },
 { 224,-258 }, { 225,-258 }, { 226,-258 }, { 227,-258 }, { 228,-258 },
 { 229,-258 }, { 230,-258 }, { 231,-258 }, { 232,-258 }, { 233,-258 },
 { 234,-258 }, { 235,-258 }, { 236,-258 }, { 237,-258 }, { 238,-258 },
 { 239,-258 }, { 240,-258 }, { 241,-258 }, { 242,-258 }, { 243,-258 },
 { 244,-258 }, { 245,-258 }, { 246,-258 }, { 247,-258 }, { 248,-258 },
 { 249,-258 }, { 250,-258 }, { 251,-258 }, { 252,-258 }, { 253,-258 },

 { 254,-258 }, { 255,-258 }, { 256,-258 }, {   0,  18 }, {   0,1637 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   9,-6830 }, {  10,-6830 },
 {   0,   0 }, {  12,-6830 }, {  13,-6830 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  32,-6830 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  39,-15868 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  45,-15833 },

 {   0,  18 }, {   0,1590 }, {   1,-563 }, {   2,-563 }, {   3,-563 },
 {   4,-563 }, {   5,-563 }, {   6,-563 }, {   7,-563 }, {   8,-563 },
 {   9,-305 }, {  10, -47 }, {  11,-563 }, {  12,-305 }, {  13, -47 },
 {  14,-563 }, {  15,-563 }, {  16,-563 }, {  17,-563 }, {  18,-563 },
 {  19,-563 }, {  20,-563 }, {  21,-563 }, {  22,-563 }, {  23,-563 },
 {  24,-563 }, {  25,-563 }, {  26,-563 }, {  27,-563 }, {  28,-563 },
 {  29,-563 }, {  30,-563 }, {  31,-563 }, {  32,-305 }, {  33,-563 },
 {  34,-563 }, {  35,-563 }, {  36,-563 }, {  37,-563 }, {  38,-563 },
 {  39,-563 }, {  40,-563 }, {  41,-563 }, {  42,-563 }, {  43,-563 },
 {  44,-563 }, {  45, 704 }, {  46,-563 }, {  47,-563 }, {  48,-563 },

 {  49,-563 }, {  50,-563 }, {  51,-563 }, {  52,-563 }, {  53,-563 },
 {  54,-563 }, {  55,-563 }, {  56,-563 }, {  57,-563 }, {  58,-563 },
 {  59,-563 }, {  60,-563 }, {  61,-563 }, {  62,-563 }, {  63,-563 },
 {  64,-563 }, {  65,-563 }, {  66,-563 }, {  67,-563 }, {  68,-563 },
 {  69,-563 }, {  70,-563 }, {  71,-563 }, {  72,-563 }, {  73,-563 },
 {  74,-563 }, {  75,-563 }, {  76,-563 }, {  77,-563 }, {  78,-563 },
 {  79,-563 }, {  80,-563 }, {  81,-563 }, {  82,-563 }, {  83,-563 },
 {  84,-563 }, {  85,-563 }, {  86,-563 }, {  87,-563 }, {  88,-563 },
 {  89,-563 }, {  90,-563 }, {  91,-563 }, {  92,-563 }, {  93,-563 },
 {  94,-563 }, {  95,-563 }, {  96,-563 }, {  97,-563 }, {  98,-563 },

 {  99,-563 }, { 100,-563 }, { 101,-563 }, { 102,-563 }, { 103,-563 },
 { 104,-563 }, { 105,-563 }, { 106,-563 }, { 107,-563 }, { 108,-563 },
 { 109,-563 }, { 110,-563 }, { 111,-563 }, { 112,-563 }, { 113,-563 },
 { 114,-563 }, { 115,-563 }, { 116,-563 }, { 117,-563 }, { 118,-563 },
 { 119,-563 }, { 120,-563 }, { 121,-563 }, { 122,-563 }, { 123,-563 },
 { 124,-563 }, { 125,-563 }, { 126,-563 }, { 127,-563 }, { 128,-563 },
 { 129,-563 }, { 130,-563 }, { 131,-563 }, { 132,-563 }, { 133,-563 },
 { 134,-563 }, { 135,-563 }, { 136,-563 }, { 137,-563 }, { 138,-563 },
 { 139,-563 }, { 140,-563 }, { 141,-563 }, { 142,-563 }, { 143,-563 },
 { 144,-563 }, { 145,-563 }, { 146,-563 }, { 147,-563 }, { 148,-563 },

 { 149,-563 }, { 150,-563 }, { 151,-563 }, { 152,-563 }, { 153,-563 },
 { 154,-563 }, { 155,-563 }, { 156,-563 }, { 157,-563 }, { 158,-563 },
 { 159,-563 }, { 160,-563 }, { 161,-563 }, { 162,-563 }, { 163,-563 },
 { 164,-563 }, { 165,-563 }, { 166,-563 }, { 167,-563 }, { 168,-563 },
 { 169,-563 }, { 170,-563 }, { 171,-563 }, { 172,-563 }, { 173,-563 },
 { 174,-563 }, { 175,-563 }, { 176,-563 }, { 177,-563 }, { 178,-563 },
 { 179,-563 }, { 180,-563 }, { 181,-563 }, { 182,-563 }, { 183,-563 },
 { 184,-563 }, { 185,-563 }, { 186,-563 }, { 187,-563 }, { 188,-563 },
 { 189,-563 }, { 190,-563 }, { 191,-563 }, { 192,-563 }, { 193,-563 },
 { 194,-563 }, { 195,-563 }, { 196,-563 }, { 197,-563 }, { 198,-563 },

 { 199,-563 }, { 200,-563 }, { 201,-563 }, { 202,-563 }, { 203,-563 },
 { 204,-563 }, { 205,-563 }, { 206,-563 }, { 207,-563 }, { 208,-563 },
 { 209,-563 }, { 210,-563 }, { 211,-563 }, { 212,-563 }, { 213,-563 },
 { 214,-563 }, { 215,-563 }, { 216,-563 }, { 217,-563 }, { 218,-563 },
 { 219,-563 }, { 220,-563 }, { 221,-563 }, { 222,-563 }, { 223,-563 },
 { 224,-563 }, { 225,-563 }, { 226,-563 }, { 227,-563 }, { 228,-563 },
 { 229,-563 }, { 230,-563 }, { 231,-563 }, { 232,-563 }, { 233,-563 },
 { 234,-563 }, { 235,-563 }, { 236,-563 }, { 237,-563 }, { 238,-563 },
 { 239,-563 }, { 240,-563 }, { 241,-563 }, { 242,-563 }, { 243,-563 },
 { 244,-563 }, { 245,-563 }, { 246,-563 }, { 247,-563 }, { 248,-563 },

 { 249,-563 }, { 250,-563 }, { 251,-563 }, { 252,-563 }, { 253,-563 },
 { 254,-563 }, { 255,-563 }, { 256,-563 }, {   0,  18 }, {   0,1332 },
 {   1,-2957 }, {   2,-2957 }, {   3,-2957 }, {   4,-2957 }, {   5,-2957 },
 {   6,-2957 }, {   7,-2957 }, {   8,-2957 }, {   9,-2699 }, {  10,-7151 },
 {  11,-2957 }, {  12,-2699 }, {  13,-7151 }, {  14,-2957 }, {  15,-2957 },
 {  16,-2957 }, {  17,-2957 }, {  18,-2957 }, {  19,-2957 }, {  20,-2957 },
 {  21,-2957 }, {  22,-2957 }, {  23,-2957 }, {  24,-2957 }, {  25,-2957 },
 {  26,-2957 }, {  27,-2957 }, {  28,-2957 }, {  29,-2957 }, {  30,-2957 },
 {  31,-2957 }, {  32,-2699 }, {  33,-2957 }, {  34,-2957 }, {  35,-2957 },
 {  36,-2957 }, {  37,-2957 }, {  38,-2957 }, {  39,-2957 }, {  40,-2957 },

 {  41,-2957 }, {  42,-2957 }, {  43,-2957 }, {  44,-2957 }, {  45,   0 },
 {  46,-2957 }, {  47,-2957 }, {  48,-2957 }, {  49,-2957 }, {  50,-2957 },
 {  51,-2957 }, {  52,-2957 }, {  53,-2957 }, {  54,-2957 }, {  55,-2957 },
 {  56,-2957 }, {  57,-2957 }, {  58,-2957 }, {  59,-2957 }, {  60,-2957 },
 {  61,-2957 }, {  62,-2957 }, {  63,-2957 }, {  64,-2957 }, {  65,-2957 },
 {  66,-2957 }, {  67,-2957 }, {  68,-2957 }, {  69,-2957 }, {  70,-2957 },
 {  71,-2957 }, {  72,-2957 }, {  73,-2957 }, {  74,-2957 }, {  75,-2957 },
 {  76,-2957 }, {  77,-2957 }, {  78,-2957 }, {  79,-2957 }, {  80,-2957 },
 {  81,-2957 }, {  82,-2957 }, {  83,-2957 }, {  84,-2957 }, {  85,-2957 },
 {  86,-2957 }, {  87,-2957 }, {  88,-2957 }, {  89,-2957 }, {  90,-2957 },

 {  91,-2957 }, {  92,-2957 }, {  93,-2957 }, {  94,-2957 }, {  95,-2957 },
 {  96,-2957 }, {  97,-2957 }, {  98,-2957 }, {  99,-2957 }, { 100,-2957 },
 { 101,-2957 }, { 102,-2957 }, { 103,-2957 }, { 104,-2957 }, { 105,-2957 },
 { 106,-2957 }, { 107,-2957 }, { 108,-2957 }, { 109,-2957 }, { 110,-2957 },
 { 111,-2957 }, { 112,-2957 }, { 113,-2957 }, { 114,-2957 }, { 115,-2957 },
 { 116,-2957 }, { 117,-2957 }, { 118,-2957 }, { 119,-2957 }, { 120,-2957 },
 { 121,-2957 }, { 122,-2957 }, { 123,-2957 }, { 124,-2957 }, { 125,-2957 },
 { 126,-2957 }, { 127,-2957 }, { 128,-2957 }, { 129,-2957 }, { 130,-2957 },
 { 131,-2957 }, { 132,-2957 }, { 133,-2957 }, { 134,-2957 }, { 135,-2957 },
 { 136,-2957 }, { 137,-2957 }, { 138,-2957 }, { 139,-2957 }, { 140,-2957 },

 { 141,-2957 }, { 142,-2957 }, { 143,-2957 }, { 144,-2957 }, { 145,-2957 },
 { 146,-2957 }, { 147,-2957 }, { 148,-2957 }, { 149,-2957 }, { 150,-2957 },
 { 151,-2957 }, { 152,-2957 }, { 153,-2957 }, { 154,-2957 }, { 155,-2957 },
 { 156,-2957 }, { 157,-2957 }, { 158,-2957 }, { 159,-2957 }, { 160,-2957 },
 { 161,-2957 }, { 162,-2957 }, { 163,-2957 }, { 164,-2957 }, { 165,-2957 },
 { 166,-2957 }, { 167,-2957 }, { 168,-2957 }, { 169,-2957 }, { 170,-2957 },
 { 171,-2957 }, { 172,-2957 }, { 173,-2957 }, { 174,-2957 }, { 175,-2957 },
 { 176,-2957 }, { 177,-2957 }, { 178,-2957 }, { 179,-2957 }, { 180,-2957 },
 { 181,-2957 }, { 182,-2957 }, { 183,-2957 }, { 184,-2957 }, { 185,-2957 },
 { 186,-2957 }, { 187,-2957 }, { 188,-2957 }, { 189,-2957 }, { 190,-2957 },

 { 191,-2957 }, { 192,-2957 }, { 193,-2957 }, { 194,-2957 }, { 195,-2957 },
 { 196,-2957 }, { 197,-2957 }, { 198,-2957 }, { 199,-2957 }, { 200,-2957 },
 { 201,-2957 }, { 202,-2957 }, { 203,-2957 }, { 204,-2957 }, { 205,-2957 },
 { 206,-2957 }, { 207,-2957 }, { 208,-2957 }, { 209,-2957 }, { 210,-2957 },
 { 211,-2957 }, { 212,-2957 }, { 213,-2957 }, { 214,-2957 }, { 215,-2957 },
 { 216,-2957 }, { 217,-2957 }, { 218,-2957 }, { 219,-2957 }, { 220,-2957 },
 { 221,-2957 }, { 222,-2957 }, { 223,-2957 }, { 224,-2957 }, { 225,-2957 },
 { 226,-2957 }, { 227,-2957 }, { 228,-2957 }, { 229,-2957 }, { 230,-2957 },
 { 231,-2957 }, { 232,-2957 }, { 233,-2957 }, { 234,-2957 }, { 235,-2957 },
 { 236,-2957 }, { 237,-2957 }, { 238,-2957 }, { 239,-2957 }, { 240,-2957 },

 { 241,-2957 }, { 242,-2957 }, { 243,-2957 }, { 244,-2957 }, { 245,-2957 },
 { 246,-2957 }, { 247,-2957 }, { 248,-2957 }, { 249,-2957 }, { 250,-2957 },
 { 251,-2957 }, { 252,-2957 }, { 253,-2957 }, { 254,-2957 }, { 255,-2957 },
 { 256,-2957 }, {   0,  27 }, {   0,1074 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,  27 },
 {   0,1051 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48, 446 }, {  49, 446 }, {  50, 446 }, {  51, 446 }, {  52, 446 },
 {  53, 446 }, {  54, 446 }, {  55, 446 }, {  56, 446 }, {  57, 446 },
 {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0,1013 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65, 446 }, {  66, 446 }, {  67, 446 },
 {  68, 446 }, {  69, 446 }, {  70, 446 }, {  48, 446 }, {  49, 446 },
 {  50, 446 }, {  51, 446 }, {  52, 446 }, {  53, 446 }, {  54, 446 },
 {  55, 446 }, {  56, 446 }, {  57, 446 }, {   0,   0 }, {   0,   0 },

 {   0,  27 }, {   0, 990 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65, 446 }, {  66, 446 }, {  67, 446 }, {  68, 446 }, {  69, 446 },
 {  70, 446 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97, 446 },
 {  98, 446 }, {  99, 446 }, { 100, 446 }, { 101, 446 }, { 102, 446 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48, 446 }, {  49, 446 }, {  50, 446 }, {  51, 446 },
 {  52, 446 }, {  53, 446 }, {  54, 446 }, {  55, 446 }, {  56, 446 },
 {  57, 446 }, {   0,   0 }, {  97, 446 }, {  98, 446 }, {  99, 446 },
 { 100, 446 }, { 101, 446 }, { 102, 446 }, {  65, 446 }, {  66, 446 },
 {  67, 446 }, {  68, 446 }, {  69, 446 }, {  70, 446 }, {  48, 446 },

 {  49, 446 }, {  50, 446 }, {  51, 446 }, {  52, 446 }, {  53, 446 },
 {  54, 446 }, {  55, 446 }, {  56, 446 }, {  57, 446 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65, 446 }, {  66, 446 }, {  67, 446 }, {  68, 446 },
 {  69, 446 }, {  70, 446 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97, 446 }, {  98, 446 }, {  99, 446 }, { 100, 446 }, { 101, 446 },
 { 102, 446 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97, 446 }, {  98, 446 },

 {  99, 446 }, { 100, 446 }, { 101, 446 }, { 102, 446 }, {   0,  18 },
 {   0, 886 }, {   1,-1267 }, {   2,-1267 }, {   3,-1267 }, {   4,-1267 },
 {   5,-1267 }, {   6,-1267 }, {   7,-1267 }, {   8,-1267 }, {   9,-1009 },
 {  10,-751 }, {  11,-1267 }, {  12,-1009 }, {  13,-751 }, {  14,-1267 },
 {  15,-1267 }, {  16,-1267 }, {  17,-1267 }, {  18,-1267 }, {  19,-1267 },
 {  20,-1267 }, {  21,-1267 }, {  22,-1267 }, {  23,-1267 }, {  24,-1267 },
 {  25,-1267 }, {  26,-1267 }, {  27,-1267 }, {  28,-1267 }, {  29,-1267 },
 {  30,-1267 }, {  31,-1267 }, {  32,-1009 }, {  33,-1267 }, {  34,-1267 },
 {  35,-1267 }, {  36,-1267 }, {  37,-1267 }, {  38,-1267 }, {  39,-1267 },
 {  40,-1267 }, {  41,-1267 }, {  42,-1267 }, {  43,-1267 }, {  44,-1267 },

 {  45,   0 }, {  46,-1267 }, {  47,-1267 }, {  48,-1267 }, {  49,-1267 },
 {  50,-1267 }, {  51,-1267 }, {  52,-1267 }, {  53,-1267 }, {  54,-1267 },
 {  55,-1267 }, {  56,-1267 }, {  57,-1267 }, {  58,-1267 }, {  59,-1267 },
 {  60,-1267 }, {  61,-1267 }, {  62,-1267 }, {  63,-1267 }, {  64,-1267 },
 {  65,-1267 }, {  66,-1267 }, {  67,-1267 }, {  68,-1267 }, {  69,-1267 },
 {  70,-1267 }, {  71,-1267 }, {  72,-1267 }, {  73,-1267 }, {  74,-1267 },
 {  75,-1267 }, {  76,-1267 }, {  77,-1267 }, {  78,-1267 }, {  79,-1267 },
 {  80,-1267 }, {  81,-1267 }, {  82,-1267 }, {  83,-1267 }, {  84,-1267 },
 {  85,-1267 }, {  86,-1267 }, {  87,-1267 }, {  88,-1267 }, {  89,-1267 },
 {  90,-1267 }, {  91,-1267 }, {  92,-1267 }, {  93,-1267 }, {  94,-1267 },

 {  95,-1267 }, {  96,-1267 }, {  97,-1267 }, {  98,-1267 }, {  99,-1267 },
 { 100,-1267 }, { 101,-1267 }, { 102,-1267 }, { 103,-1267 }, { 104,-1267 },
 { 105,-1267 }, { 106,-1267 }, { 107,-1267 }, { 108,-1267 }, { 109,-1267 },
 { 110,-1267 }, { 111,-1267 }, { 112,-1267 }, { 113,-1267 }, { 114,-1267 },
 { 115,-1267 }, { 116,-1267 }, { 117,-1267 }, { 118,-1267 }, { 119,-1267 },
 { 120,-1267 }, { 121,-1267 }, { 122,-1267 }, { 123,-1267 }, { 124,-1267 },
 { 125,-1267 }, { 126,-1267 }, { 127,-1267 }, { 128,-1267 }, { 129,-1267 },
 { 130,-1267 }, { 131,-1267 }, { 132,-1267 }, { 133,-1267 }, { 134,-1267 },
 { 135,-1267 }, { 136,-1267 }, { 137,-1267 }, { 138,-1267 }, { 139,-1267 },
 { 140,-1267 }, { 141,-1267 }, { 142,-1267 }, { 143,-1267 }, { 144,-1267 },

 { 145,-1267 }, { 146,-1267 }, { 147,-1267 }, { 148,-1267 }, { 149,-1267 },
 { 150,-1267 }, { 151,-1267 }, { 152,-1267 }, { 153,-1267 }, { 154,-1267 },
 { 155,-1267 }, { 156,-1267 }, { 157,-1267 }, { 158,-1267 }, { 159,-1267 },
 { 160,-1267 }, { 161,-1267 }, { 162,-1267 }, { 163,-1267 }, { 164,-1267 },
 { 165,-1267 }, { 166,-1267 }, { 167,-1267 }, { 168,-1267 }, { 169,-1267 },
 { 170,-1267 }, { 171,-1267 }, { 172,-1267 }, { 173,-1267 }, { 174,-1267 },
 { 175,-1267 }, { 176,-1267 }, { 177,-1267 }, { 178,-1267 }, { 179,-1267 },
 { 180,-1267 }, { 181,-1267 }, { 182,-1267 }, { 183,-1267 }, { 184,-1267 },
 { 185,-1267 }, { 186,-1267 }, { 187,-1267 }, { 188,-1267 }, { 189,-1267 },
 { 190,-1267 }, { 191,-1267 }, { 192,-1267 }, { 193,-1267 }, { 194,-1267 },

 { 195,-1267 }, { 196,-1267 }, { 197,-1267 }, { 198,-1267 }, { 199,-1267 },
 { 200,-1267 }, { 201,-1267 }, { 202,-1267 }, { 203,-1267 }, { 204,-1267 },
 { 205,-1267 }, { 206,-1267 }, { 207,-1267 }, { 208,-1267 }, { 209,-1267 },
 { 210,-1267 }, { 211,-1267 }, { 212,-1267 }, { 213,-1267 }, { 214,-1267 },
 { 215,-1267 }, { 216,-1267 }, { 217,-1267 }, { 218,-1267 }, { 219,-1267 },
 { 220,-1267 }, { 221,-1267 }, { 222,-1267 }, { 223,-1267 }, { 224,-1267 },
 { 225,-1267 }, { 226,-1267 }, { 227,-1267 }, { 228,-1267 }, { 229,-1267 },
 { 230,-1267 }, { 231,-1267 }, { 232,-1267 }, { 233,-1267 }, { 234,-1267 },
 { 235,-1267 }, { 236,-1267 }, { 237,-1267 }, { 238,-1267 }, { 239,-1267 },
 { 240,-1267 }, { 241,-1267 }, { 242,-1267 }, { 243,-1267 }, { 244,-1267 },

 { 245,-1267 }, { 246,-1267 }, { 247,-1267 }, { 248,-1267 }, { 249,-1267 },
 { 250,-1267 }, { 251,-1267 }, { 252,-1267 }, { 253,-1267 }, { 254,-1267 },
 { 255,-1267 }, { 256,-1267 }, {   0,  27 }, {   0, 628 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,  27 }, {   0, 605 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  48, 143 }, {  49, 143 }, {  50, 143 }, {  51, 143 },
 {  52, 143 }, {  53, 143 }, {  54, 143 }, {  55, 143 }, {  56, 143 },
 {  57, 143 }, {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0, 567 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65, 143 }, {  66, 143 },
 {  67, 143 }, {  68, 143 }, {  69, 143 }, {  70, 143 }, {  48,-16557 },
 {  49,-16557 }, {  50,-16557 }, {  51,-16557 }, {  52,-16557 }, {  53,-16557 },
 {  54,-16557 }, {  55,-16557 }, {  56,-16557 }, {  57,-16557 }, {   0,   0 },
 {   0,   0 }, {   0,  27 }, {   0, 544 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {  65,-16557 }, {  66,-16557 }, {  67,-16557 }, {  68,-16557 },
 {  69,-16557 }, {  70,-16557 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97, 143 }, {  98, 143 }, {  99, 143 }, { 100, 143 }, { 101, 143 },
 { 102, 143 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48, 105 }, {  49, 105 }, {  50, 105 },
 {  51, 105 }, {  52, 105 }, {  53, 105 }, {  54, 105 }, {  55, 105 },
 {  56, 105 }, {  57, 105 }, {   0,   0 }, {  97,-16557 }, {  98,-16557 },
 {  99,-16557 }, { 100,-16557 }, { 101,-16557 }, { 102,-16557 }, {  65, 105 },
 {  66, 105 }, {  67, 105 }, {  68, 105 }, {  69, 105 }, {  70, 105 },
 {  48,-16616 }, {  49,-16616 }, {  50,-16616 }, {  51,-16616 }, {  52,-16616 },

 {  53,-16616 }, {  54,-16616 }, {  55,-16616 }, {  56,-16616 }, {  57,-16616 },
 {   0,  27 }, {   0, 485 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,-16616 }, {  66,-16616 }, {  67,-16616 },
 {  68,-16616 }, {  69,-16616 }, {  70,-16616 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97, 105 }, {  98, 105 }, {  99, 105 }, { 100, 105 },
 { 101, 105 }, { 102, 105 }, {   0,   0 }, {   0,  27 }, {   0, 462 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,-16616 },
 {  98,-16616 }, {  99,-16616 }, { 100,-16616 }, { 101,-16616 }, { 102,-16616 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,  61 },
 {  49,  61 }, {  50,  61 }, {  51,  61 }, {  52,  61 }, {  53,  61 },
 {  54,  61 }, {  55,  61 }, {  56,  61 }, {  57,  61 }, {   0,   0 },
 {   0,   0 }, {   0,  27 }, {   0, 424 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  65,  61 }, {  66,  61 }, {  67,  61 }, {  68,  61 },
 {  69,  61 }, {  70,  61 }, {  48,  61 }, {  49,  61 }, {  50,  61 },
 {  51,  61 }, {  52,  61 }, {  53,  61 }, {  54,  61 }, {  55,  61 },
 {  56,  61 }, {  57,  61 }, {   0,   0 }, {   0,   0 }, {   0,  27 },
 {   0, 401 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,  61 },
 {  66,  61 }, {  67,  61 }, {  68,  61 }, {  69,  61 }, {  70,  61 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,  61 }, {  98,  61 },
 {  99,  61 }, { 100,  61 }, { 101,  61 }, { 102,  61 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  48,  82 }, {  49,  82 }, {  50,  82 }, {  51,  82 }, {  52,  82 },
 {  53,  82 }, {  54,  82 }, {  55,  82 }, {  56,  82 }, {  57,  82 },
 {   0,   0 }, {  97,  61 }, {  98,  61 }, {  99,  61 }, { 100,  61 },
 { 101,  61 }, { 102,  61 }, {  65,  82 }, {  66,  82 }, {  67,  82 },
 {  68,  82 }, {  69,  82 }, {  70,  82 }, {  48,  82 }, {  49,  82 },
 {  50,  82 }, {  51,  82 }, {  52,  82 }, {  53,  82 }, {  54,  82 },
 {  55,  82 }, {  56,  82 }, {  57,  82 }, {   0,  27 }, {   0, 342 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  65,  82 }, {  66,  82 }, {  67,  82 }, {  68,  82 }, {  69,  82 },
 {  70,  82 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  97,  82 },
 {  98,  82 }, {  99,  82 }, { 100,  82 }, { 101,  82 }, { 102,  82 },
 {   0,   0 }, {   0,  27 }, {   0, 319 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97,  82 }, {  98,  82 }, {  99,  82 },
 { 100,  82 }, { 101,  82 }, { 102,  82 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  48,  61 }, {  49,  61 }, {  50,  61 },

 {  51,  61 }, {  52,  61 }, {  53,  61 }, {  54,  61 }, {  55,  61 },
 {  56,  61 }, {  57,  61 }, {   0,   0 }, {   0,   0 }, {   0,  27 },
 {   0, 281 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,  61 },
 {  66,  61 }, {  67,  61 }, {  68,  61 }, {  69,  61 }, {  70,  61 },
 {  48,  61 }, {  49,  61 }, {  50,  61 }, {  51,  61 }, {  52,  61 },
 {  53,  61 }, {  54,  61 }, {  55,  61 }, {  56,  61 }, {  57,  61 },
 {   0,   0 }, {   0,   0 }, {   0,  27 }, {   0, 258 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  65,  61 }, {  66,  61 }, {  67,  61 },
 {  68,  61 }, {  69,  61 }, {  70,  61 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {  97,  61 }, {  98,  61 }, {  99,  61 }, { 100,  61 },

 { 101,  61 }, { 102,  61 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  48,-16881 }, {  49,-16881 },
 {  50,-16881 }, {  51,-16881 }, {  52,-16881 }, {  53,-16881 }, {  54,-16881 },
 {  55,-16881 }, {  56,-16881 }, {  57,-16881 }, {   0,   0 }, {  97,  61 },
 {  98,  61 }, {  99,  61 }, { 100,  61 }, { 101,  61 }, { 102,  61 },
 {  65,-16881 }, {  66,-16881 }, {  67,-16881 }, {  68,-16881 }, {  69,-16881 },
 {  70,-16881 }, {  48,-16902 }, {  49,-16902 }, {  50,-16902 }, {  51,-16902 },
 {  52,-16902 }, {  53,-16902 }, {  54,-16902 }, {  55,-16902 }, {  56,-16902 },
 {  57,-16902 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {  65,-16902 }, {  66,-16902 },

 {  67,-16902 }, {  68,-16902 }, {  69,-16902 }, {  70,-16902 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {  97,-16881 }, {  98,-16881 }, {  99,-16881 },
 { 100,-16881 }, { 101,-16881 }, { 102,-16881 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {  97,-16902 }, {  98,-16902 }, {  99,-16902 }, { 100,-16902 }, { 101,-16902 },
 { 102,-16902 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },

 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 }, {   0,   0 },
 { 257,  77 }, {   1,   0 },    };

static const struct yy_trans_info *yy_start_state_list[25] =
    {
    &yy_transition[1],
    &yy_transition[3],
    &yy_transition[261],
    &yy_transition[519],
    &yy_transition[777],
    &yy_transition[1035],
    &yy_transition[1293],
    &yy_transition[1551],
    &yy_transition[1809],
    &yy_transition[2067],
    &yy_transition[2325],
    &yy_transition[2583],
    &yy_transition[2841],
    &yy_transition[3099],
    &yy_transition[3357],
    &yy_transition[3615],
    &yy_transition[3873],
    &yy_transition[4131],
    &yy_transition[4389],
    &yy_transition[4647],
    &yy_transition[4905],
    &yy_transition[5163],
    &yy_transition[5421],
    &yy_transition[5679],
    &yy_transition[5937],

    } ;

/* The intent behind this definition is that it'll catch
 * any uses of REJECT which flex missed.
 */
#define REJECT reject_used_but_not_detected
#define yymore() yymore_used_but_not_detected
#define YY_MORE_ADJ 0
#define YY_RESTORE_YY_MORE_OFFSET
#line 1 "scan.l"

#line 49 "scan.l"

/* LCOV_EXCL_START */

/* Avoid exit() on fatal scanner errors (a bit ugly -- see yy_fatal_error) */
#undef fprintf
#define fprintf(file, fmt, msg)  fprintf_to_ereport(fmt, msg)

static void
fprintf_to_ereport(const char *fmt, const char *msg)
{
	ereport(ERROR, (errmsg_internal("%s", msg)));
}

/*
 * GUC variables.  This is a DIRECT violation of the warning given at the
 * head of gram.y, ie flex/bison code must not depend on any GUC variables;
 * as such, changing their values can induce very unintuitive behavior.
 * But we shall have to live with it until we can remove these variables.
 */
int			backslash_quote = BACKSLASH_QUOTE_SAFE_ENCODING;
bool		escape_string_warning = true;
bool		standard_conforming_strings = true;

/*
 * Constant data exported from this file.  This array maps from the
 * zero-based keyword numbers returned by ScanKeywordLookup to the
 * Bison token numbers needed by gram.y.  This is exported because
 * callers need to pass it to scanner_init, if they are using the
 * standard keyword list ScanKeywords.
 */
#define PG_KEYWORD(kwname, value, category, collabel) value,

const uint16 ScanKeywordTokens[] = {
#include "parser/kwlist.h"
};

#undef PG_KEYWORD

/*
 * Set the type of YYSTYPE.
 */
#define YYSTYPE core_YYSTYPE

/*
 * Set the type of yyextra.  All state variables used by the scanner should
 * be in yyextra, *not* statically allocated.
 */
#define YY_EXTRA_TYPE core_yy_extra_type *

/*
 * Each call to yylex must set yylloc to the location of the found token
 * (expressed as a byte offset from the start of the input text).
 * When we parse a token that requires multiple lexer rules to process,
 * this should be done in the first such rule, else yylloc will point
 * into the middle of the token.
 */
#define SET_YYLLOC()  (*(yylloc) = yytext - yyextra->scanbuf)

/*
 * Advance yylloc by the given number of bytes.
 */
#define ADVANCE_YYLLOC(delta)  ( *(yylloc) += (delta) )

/*
 * Sometimes, we do want yylloc to point into the middle of a token; this is
 * useful for instance to throw an error about an escape sequence within a
 * string literal.  But if we find no error there, we want to revert yylloc
 * to the token start, so that that's the location reported to the parser.
 * Use PUSH_YYLLOC/POP_YYLLOC to save/restore yylloc around such code.
 * (Currently the implied "stack" is just one location, but someday we might
 * need to nest these.)
 */
#define PUSH_YYLLOC()	(yyextra->save_yylloc = *(yylloc))
#define POP_YYLLOC()	(*(yylloc) = yyextra->save_yylloc)

#define startlit()	( yyextra->literallen = 0 )
static void addlit(char *ytext, int yleng, core_yyscan_t yyscanner);
static void addlitchar(unsigned char ychar, core_yyscan_t yyscanner);
static char *litbufdup(core_yyscan_t yyscanner);
static unsigned char unescape_single_char(unsigned char c, core_yyscan_t yyscanner);
static int	process_integer_literal(const char *token, YYSTYPE *lval, int base);
static void addunicode(pg_wchar c, yyscan_t yyscanner);

#define yyerror(msg)  scanner_yyerror(msg, yyscanner)

#define lexer_errposition()  scanner_errposition(*(yylloc), yyscanner)

static void check_string_escape_warning(unsigned char ychar, core_yyscan_t yyscanner);
static void check_escape_warning(core_yyscan_t yyscanner);

/*
 * Work around a bug in flex 2.5.35: it emits a couple of functions that
 * it forgets to emit declarations for.  Since we use -Wmissing-prototypes,
 * this would cause warnings.  Providing our own declarations should be
 * harmless even when the bug gets fixed.
 */
extern int	core_yyget_column(yyscan_t yyscanner);
extern void core_yyset_column(int column_no, yyscan_t yyscanner);

#line 6081 "scan.c"
#define YY_NO_INPUT 1
/*
 * OK, here is a short description of lex/flex rules behavior.
 * The longest pattern which matches an input string is always chosen.
 * For equal-length patterns, the first occurring in the rules list is chosen.
 * INITIAL is the starting state, to which all non-conditional rules apply.
 * Exclusive states change parsing rules while the state is active.  When in
 * an exclusive state, only those rules defined for that state apply.
 *
 * We use exclusive states for quoted strings, extended comments,
 * and to eliminate parsing troubles for numeric strings.
 * Exclusive states:
 *  <xb> bit string literal
 *  <xc> extended C-style comments
 *  <xd> delimited identifiers (double-quoted identifiers)
 *  <xh> hexadecimal byte string
 *  <xq> standard quoted strings
 *  <xqs> quote stop (detect continued strings)
 *  <xe> extended quoted strings (support backslash escape sequences)
 *  <xdolq> $foo$ quoted strings
 *  <xui> quoted identifier with Unicode escapes
 *  <xus> quoted string with Unicode escapes
 *  <xeu> Unicode surrogate pair in extended quoted string
 *
 * Remember to add an <<EOF>> case whenever you add a new exclusive state!
 * The default one is probably not the right thing.
 */

/*
 * In order to make the world safe for Windows and Mac clients as well as
 * Unix ones, we accept either \n or \r as a newline.  A DOS-style \r\n
 * sequence will be seen as two successive newlines, but that doesn't cause
 * any problems.  Comments that start with -- and extend to the next
 * newline are treated as equivalent to a single whitespace character.
 *
 * NOTE a fine point: if there is no newline following --, we will absorb
 * everything to the end of the input as a comment.  This is correct.  Older
 * versions of Postgres failed to recognize -- as a comment if the input
 * did not end with a newline.
 *
 * XXX perhaps \f (formfeed) should be treated as a newline as well?
 *
 * XXX if you change the set of whitespace characters, fix scanner_isspace()
 * to agree.
 */
/*
 * SQL requires at least one newline in the whitespace separating
 * string literals that are to be concatenated.  Silly, but who are we
 * to argue?  Note that {whitespace_with_newline} should not have * after
 * it, whereas {whitespace} should generally have a * after it...
 */
/* If we see {quote} then {quotecontinue}, the quoted string continues */
/*
 * {quotecontinuefail} is needed to avoid lexer backup when we fail to match
 * {quotecontinue}.  It might seem that this could just be {whitespace}*,
 * but if there's a dash after {whitespace_with_newline}, it must be consumed
 * to see if there's another dash --- which would start a {comment} and thus
 * allow continuation of the {quotecontinue} token.
 */
/* Bit string
 * It is tempting to scan the string for only those characters
 * which are allowed. However, this leads to silently swallowed
 * characters if illegal characters are included in the string.
 * For example, if xbinside is [01] then B'ABCD' is interpreted
 * as a zero-length string, and the ABCD' is lost!
 * Better to pass the string forward and let the input routines
 * validate the contents.
 */
/* Hexadecimal byte string */
/* National character */
/* Quoted string that allows backslash escapes */
/* Extended quote
 * xqdouble implements embedded quote, ''''
 */
/* $foo$ style quotes ("dollar quoting")
 * The quoted string starts with $foo$ where "foo" is an optional string
 * in the form of an identifier, except that it may not contain "$",
 * and extends to the first occurrence of an identical string.
 * There is *no* processing of the quoted text.
 *
 * {dolqfailed} is an error rule to avoid scanner backup when {dolqdelim}
 * fails to match its trailing "$".
 */
/* Double quote
 * Allows embedded spaces and other special characters into identifiers.
 */
/* Quoted identifier with Unicode escapes */
/* Quoted string with Unicode escapes */
/* error rule to avoid backup */
/* C-style comments
 *
 * The "extended comment" syntax closely resembles allowable operator syntax.
 * The tricky part here is to get lex to recognize a string starting with
 * slash-star as a comment, when interpreting it as an operator would produce
 * a longer match --- remember lex will prefer a longer match!  Also, if we
 * have something like plus-slash-star, lex will think this is a 3-character
 * operator whereas we want to see it as a + operator and a comment start.
 * The solution is two-fold:
 * 1. append {op_chars}* to xcstart so that it matches as much text as
 *    {operator} would. Then the tie-breaker (first matching rule of same
 *    length) ensures xcstart wins.  We put back the extra stuff with yyless()
 *    in case it contains a star-slash that should terminate the comment.
 * 2. In the operator rule, check for slash-star within the operator, and
 *    if found throw it back with yyless().  This handles the plus-slash-star
 *    problem.
 * Dash-dash comments have similar interactions with the operator rule.
 */
/* Assorted special-case operators and operator-like tokens */
/*
 * These operator-like tokens (unlike the above ones) also match the {operator}
 * rule, which means that they might be overridden by a longer match if they
 * are followed by a comment start or a + or - character. Accordingly, if you
 * add to this list, you must also add corresponding code to the {operator}
 * block to return the correct token in such cases. (This is not needed in
 * psqlscan.l since the token value is ignored there.)
 */
/*
 * "self" is the set of chars that should be returned as single-character
 * tokens.  "op_chars" is the set of chars that can make up "Op" tokens,
 * which can be one or more characters long (but if a single-char token
 * appears in the "self" set, it is not to be returned as an Op).  Note
 * that the sets overlap, but each has some chars that are not in the other.
 *
 * If you change either set, adjust the character lists appearing in the
 * rule for "operator"!
 */
/*
 * Numbers
 *
 * Unary minus is not part of a number here.  Instead we pass it separately to
 * the parser, and there it gets coerced via doNegate().
 *
 * {numericfail} is used because we would like "1..10" to lex as 1, dot_dot, 10.
 *
 * {realfail} is added to prevent the need for scanner
 * backup when the {real} rule fails to match completely.
 */
/* Positional parameters don't accept underscores. */
/*
 * Dollar quoted strings are totally opaque, and no escaping is done on them.
 * Other quoted strings must allow some special characters such as single-quote
 *  and newline.
 * Embedded single-quotes are implemented both in the SQL standard
 *  style of two adjacent single quotes "''" and in the Postgres/Java style
 *  of escaped-quote "\'".
 * Other embedded escaped characters are matched explicitly and the leading
 *  backslash is dropped from the string.
 * Note that xcstart must appear before operator, as explained above!
 *  Also whitespace (comment) must appear before operator.
 */
#line 6232 "scan.c"

#define INITIAL 0
#define xb 1
#define xc 2
#define xd 3
#define xh 4
#define xq 5
#define xqs 6
#define xe 7
#define xdolq 8
#define xui 9
#define xus 10
#define xeu 11

#ifndef YY_NO_UNISTD_H
/* Special case for "unistd.h", since it is non-ANSI. We include it way
 * down here because we want the user's section 1 to have been scanned first.
 * The user has a chance to override it with an option.
 */
#include <unistd.h>
#endif

#ifndef YY_EXTRA_TYPE
#define YY_EXTRA_TYPE void *
#endif

/* Holds the entire state of the reentrant scanner. */
struct yyguts_t
    {

    /* User-defined. Not touched by flex. */
    YY_EXTRA_TYPE yyextra_r;

    /* The rest are the same as the globals declared in the non-reentrant scanner. */
    FILE *yyin_r, *yyout_r;
    size_t yy_buffer_stack_top; /**< index of top of stack. */
    size_t yy_buffer_stack_max; /**< capacity of stack. */
    YY_BUFFER_STATE * yy_buffer_stack; /**< Stack as an array. */
    char yy_hold_char;
    int yy_n_chars;
    int yyleng_r;
    char *yy_c_buf_p;
    int yy_init;
    int yy_start;
    int yy_did_buffer_switch_on_eof;
    int yy_start_stack_ptr;
    int yy_start_stack_depth;
    int *yy_start_stack;
    yy_state_type yy_last_accepting_state;
    char* yy_last_accepting_cpos;

    int yylineno_r;
    int yy_flex_debug_r;

    char *yytext_r;
    int yy_more_flag;
    int yy_more_len;

    YYSTYPE * yylval_r;

    YYLTYPE * yylloc_r;

    }; /* end struct yyguts_t */

static int yy_init_globals ( yyscan_t yyscanner );

    /* This must go here because YYSTYPE and YYLTYPE are included
     * from bison output in section 1.*/
    #    define yylval yyg->yylval_r
    
    #    define yylloc yyg->yylloc_r
    
int yylex_init (yyscan_t* scanner);

int yylex_init_extra ( YY_EXTRA_TYPE user_defined, yyscan_t* scanner);

/* Accessor methods to globals.
   These are made visible to non-reentrant scanners for convenience. */

int yylex_destroy ( yyscan_t yyscanner );

int yyget_debug ( yyscan_t yyscanner );

void yyset_debug ( int debug_flag , yyscan_t yyscanner );

YY_EXTRA_TYPE yyget_extra ( yyscan_t yyscanner );

void yyset_extra ( YY_EXTRA_TYPE user_defined , yyscan_t yyscanner );

FILE *yyget_in ( yyscan_t yyscanner );

void yyset_in  ( FILE * _in_str , yyscan_t yyscanner );

FILE *yyget_out ( yyscan_t yyscanner );

void yyset_out  ( FILE * _out_str , yyscan_t yyscanner );

			int yyget_leng ( yyscan_t yyscanner );

char *yyget_text ( yyscan_t yyscanner );

int yyget_lineno ( yyscan_t yyscanner );

void yyset_lineno ( int _line_number , yyscan_t yyscanner );

int yyget_column  ( yyscan_t yyscanner );

void yyset_column ( int _column_no , yyscan_t yyscanner );

YYSTYPE * yyget_lval ( yyscan_t yyscanner );

void yyset_lval ( YYSTYPE * yylval_param , yyscan_t yyscanner );

       YYLTYPE *yyget_lloc ( yyscan_t yyscanner );
    
        void yyset_lloc ( YYLTYPE * yylloc_param , yyscan_t yyscanner );
    
/* Macros after this point can all be overridden by user definitions in
 * section 1.
 */

#ifndef YY_SKIP_YYWRAP
#ifdef __cplusplus
extern "C" int yywrap ( yyscan_t yyscanner );
#else
extern int yywrap ( yyscan_t yyscanner );
#endif
#endif

#ifndef YY_NO_UNPUT
    
#endif

#ifndef yytext_ptr
static void yy_flex_strncpy ( char *, const char *, int , yyscan_t yyscanner);
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen ( const char * , yyscan_t yyscanner);
#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
static int yyinput ( yyscan_t yyscanner );
#else
static int input ( yyscan_t yyscanner );
#endif

#endif

/* Amount of stuff to slurp up with each read. */
#ifndef YY_READ_BUF_SIZE
#ifdef __ia64__
/* On IA-64, the buffer size is 16k, not 8k */
#define YY_READ_BUF_SIZE 16384
#else
#define YY_READ_BUF_SIZE 8192
#endif /* __ia64__ */
#endif

/* Copy whatever the last rule matched to the standard output. */
#ifndef ECHO
/* This used to be an fputs(), but since the string might contain NUL's,
 * we now use fwrite().
 */
#define ECHO do { if (fwrite( yytext, (size_t) yyleng, 1, yyout )) {} } while (0)
#endif

/* Gets input and stuffs it into "buf".  number of characters read, or YY_NULL,
 * is returned in "result".
 */
#ifndef YY_INPUT
#define YY_INPUT(buf,result,max_size) \
	if ( YY_CURRENT_BUFFER_LVALUE->yy_is_interactive ) \
		{ \
		int c = '*'; \
		int n; \
		for ( n = 0; n < max_size && \
			     (c = getc( yyin )) != EOF && c != '\n'; ++n ) \
			buf[n] = (char) c; \
		if ( c == '\n' ) \
			buf[n++] = (char) c; \
		if ( c == EOF && ferror( yyin ) ) \
			YY_FATAL_ERROR( "input in flex scanner failed" ); \
		result = n; \
		} \
	else \
		{ \
		errno=0; \
		while ( (result = (int) fread(buf, 1, (yy_size_t) max_size, yyin)) == 0 && ferror(yyin)) \
			{ \
			if( errno != EINTR) \
				{ \
				YY_FATAL_ERROR( "input in flex scanner failed" ); \
				break; \
				} \
			errno=0; \
			clearerr(yyin); \
			} \
		}\
\

#endif

/* No semi-colon after return; correct usage is to write "yyterminate();" -
 * we don't want an extra ';' after the "return" because that will cause
 * some compilers to complain about unreachable statements.
 */
#ifndef yyterminate
#define yyterminate() return YY_NULL
#endif

/* Number of entries by which start-condition stack grows. */
#ifndef YY_START_STACK_INCR
#define YY_START_STACK_INCR 25
#endif

/* Report a fatal error. */
#ifndef YY_FATAL_ERROR
#define YY_FATAL_ERROR(msg) yy_fatal_error( msg , yyscanner)
#endif

/* end tables serialization structures and prototypes */

/* Default declaration of generated scanner - a define so the user can
 * easily add parameters.
 */
#ifndef YY_DECL
#define YY_DECL_IS_OURS 1

extern int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param , yyscan_t yyscanner);

#define YY_DECL int yylex \
               (YYSTYPE * yylval_param, YYLTYPE * yylloc_param , yyscan_t yyscanner)
#endif /* !YY_DECL */

/* Code executed at the beginning of each rule, after yytext and yyleng
 * have been set up.
 */
#ifndef YY_USER_ACTION
#define YY_USER_ACTION
#endif

/* Code executed at the end of each rule. */
#ifndef YY_BREAK
#define YY_BREAK /*LINTED*/break;
#endif

#define YY_RULE_SETUP \
	YY_USER_ACTION

/** The main scanner function which does all the work.
 */
YY_DECL
{
	yy_state_type yy_current_state;
	char *yy_cp, *yy_bp;
	int yy_act;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    yylval = yylval_param;

    yylloc = yylloc_param;

	if ( !yyg->yy_init )
		{
		yyg->yy_init = 1;

#ifdef YY_USER_INIT
		YY_USER_INIT;
#endif

		if ( ! yyg->yy_start )
			yyg->yy_start = 1;	/* first start state */

		if ( ! yyin )
			yyin = stdin;

		if ( ! yyout )
			yyout = stdout;

		if ( ! YY_CURRENT_BUFFER ) {
			yyensure_buffer_stack (yyscanner);
			YY_CURRENT_BUFFER_LVALUE =
				yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
		}

		yy_load_buffer_state( yyscanner );
		}

	{
#line 441 "scan.l"


#line 6528 "scan.c"

	while ( /*CONSTCOND*/1 )		/* loops until end-of-file is reached */
		{
		yy_cp = yyg->yy_c_buf_p;

		/* Support of yytext. */
		*yy_cp = yyg->yy_hold_char;

		/* yy_bp points to the position in yy_ch_buf of the start of
		 * the current run.
		 */
		yy_bp = yy_cp;

		yy_current_state = yy_start_state_list[yyg->yy_start];
yy_match:
		{
		const struct yy_trans_info *yy_trans_info;

		YY_CHAR yy_c;

		for ( yy_c = YY_SC_TO_UI(*yy_cp);
		      (yy_trans_info = &yy_current_state[yy_c])->
		yy_verify == yy_c;
		      yy_c = YY_SC_TO_UI(*++yy_cp) )
			yy_current_state += yy_trans_info->yy_nxt;
		}

yy_find_action:
		yy_act = yy_current_state[-1].yy_nxt;

		YY_DO_BEFORE_ACTION;

do_action:	/* This label is used only to access EOF actions. */

		switch ( yy_act )
	{ /* beginning of action switch */
case 1:
/* rule 1 can match eol */
YY_RULE_SETUP
#line 443 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 2:
YY_RULE_SETUP
#line 447 "scan.l"
{
					/* Set location in case of syntax error in comment */
					SET_YYLLOC();
					yyextra->xcdepth = 0;
					BEGIN(xc);
					/* Put back any characters past slash-star; see above */
					yyless(2);
				}
	YY_BREAK

case 3:
YY_RULE_SETUP
#line 457 "scan.l"
{
					(yyextra->xcdepth)++;
					/* Put back any characters past slash-star; see above */
					yyless(2);
				}
	YY_BREAK
case 4:
YY_RULE_SETUP
#line 463 "scan.l"
{
					if (yyextra->xcdepth <= 0)
						BEGIN(INITIAL);
					else
						(yyextra->xcdepth)--;
				}
	YY_BREAK
case 5:
/* rule 5 can match eol */
YY_RULE_SETUP
#line 470 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 6:
YY_RULE_SETUP
#line 474 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case 7:
YY_RULE_SETUP
#line 478 "scan.l"
{
					/* ignore */
				}
	YY_BREAK
case YY_STATE_EOF(xc):
#line 482 "scan.l"
{
					yyerror("unterminated /* comment");
				}
	YY_BREAK
/* <xc> */
case 8:
YY_RULE_SETUP
#line 487 "scan.l"
{
					/* Binary bit type.
					 * At some point we should simply pass the string
					 * forward to the parser and label it there.
					 * In the meantime, place a leading "b" on the string
					 * to mark it for the input routine as a binary string.
					 */
					SET_YYLLOC();
					BEGIN(xb);
					startlit();
					addlitchar('b', yyscanner);
				}
	YY_BREAK
case 9:
/* rule 9 can match eol */
#line 500 "scan.l"
case 10:
/* rule 10 can match eol */
YY_RULE_SETUP
#line 500 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xb):
#line 503 "scan.l"
{ yyerror("unterminated bit string literal"); }
	YY_BREAK
case 11:
YY_RULE_SETUP
#line 505 "scan.l"
{
					/* Hexadecimal bit type.
					 * At some point we should simply pass the string
					 * forward to the parser and label it there.
					 * In the meantime, place a leading "x" on the string
					 * to mark it for the input routine as a hex string.
					 */
					SET_YYLLOC();
					BEGIN(xh);
					startlit();
					addlitchar('x', yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xh):
#line 517 "scan.l"
{ yyerror("unterminated hexadecimal string literal"); }
	YY_BREAK
case 12:
YY_RULE_SETUP
#line 519 "scan.l"
{
					/* National character.
					 * We will pass this along as a normal character string,
					 * but preceded with an internally-generated "NCHAR".
					 */
					int		kwnum;

					SET_YYLLOC();
					yyless(1);	/* eat only 'n' this time */

					kwnum = ScanKeywordLookup("nchar",
											  yyextra->keywordlist);
					if (kwnum >= 0)
					{
						yylval->keyword = GetScanKeyword(kwnum,
														 yyextra->keywordlist);
						return yyextra->keyword_tokens[kwnum];
					}
					else
					{
						/* If NCHAR isn't a keyword, just return "n" */
						yylval->str = pstrdup("n");
						return IDENT;
					}
				}
	YY_BREAK
case 13:
YY_RULE_SETUP
#line 545 "scan.l"
{
					yyextra->warn_on_first_escape = true;
					yyextra->saw_non_ascii = false;
					SET_YYLLOC();
					if (yyextra->standard_conforming_strings)
						BEGIN(xq);
					else
						BEGIN(xe);
					startlit();
				}
	YY_BREAK
case 14:
YY_RULE_SETUP
#line 555 "scan.l"
{
					yyextra->warn_on_first_escape = false;
					yyextra->saw_non_ascii = false;
					SET_YYLLOC();
					BEGIN(xe);
					startlit();
				}
	YY_BREAK
case 15:
YY_RULE_SETUP
#line 562 "scan.l"
{
					SET_YYLLOC();
					if (!yyextra->standard_conforming_strings)
						ereport(ERROR,
								(errcode(ERRCODE_FEATURE_NOT_SUPPORTED),
								 errmsg("unsafe use of string constant with Unicode escapes"),
								 errdetail("String constants with Unicode escapes cannot be used when standard_conforming_strings is off."),
								 lexer_errposition()));
					BEGIN(xus);
					startlit();
				}
	YY_BREAK
case 16:
YY_RULE_SETUP
#line 574 "scan.l"
{
					/*
					 * When we are scanning a quoted string and see an end
					 * quote, we must look ahead for a possible continuation.
					 * If we don't see one, we know the end quote was in fact
					 * the end of the string.  To reduce the lexer table size,
					 * we use a single "xqs" state to do the lookahead for all
					 * types of strings.
					 */
					yyextra->state_before_str_stop = YYSTATE;
					BEGIN(xqs);
				}
	YY_BREAK
case 17:
/* rule 17 can match eol */
YY_RULE_SETUP
#line 586 "scan.l"
{
					/*
					 * Found a quote continuation, so return to the in-quote
					 * state and continue scanning the literal.  Nothing is
					 * added to the literal's contents.
					 */
					BEGIN(yyextra->state_before_str_stop);
				}
	YY_BREAK
case 18:
/* rule 18 can match eol */
#line 595 "scan.l"
case 19:
/* rule 19 can match eol */
#line 596 "scan.l"
YY_RULE_SETUP
case YY_STATE_EOF(xqs):
#line 596 "scan.l"
{
					/*
					 * Failed to see a quote continuation.  Throw back
					 * everything after the end quote, and handle the string
					 * according to the state we were in previously.
					 */
					yyless(0);
					BEGIN(INITIAL);

					switch (yyextra->state_before_str_stop)
					{
						case xb:
							yylval->str = litbufdup(yyscanner);
							return BCONST;
						case xh:
							yylval->str = litbufdup(yyscanner);
							return XCONST;
						case xq:
						case xe:
							/*
							 * Check that the data remains valid, if it might
							 * have been made invalid by unescaping any chars.
							 */
							if (yyextra->saw_non_ascii)
								pg_verifymbstr(yyextra->literalbuf,
											   yyextra->literallen,
											   false);
							yylval->str = litbufdup(yyscanner);
							return SCONST;
						case xus:
							yylval->str = litbufdup(yyscanner);
							return USCONST;
						default:
							yyerror("unhandled previous state in xqs");
					}
				}
	YY_BREAK
case 20:
YY_RULE_SETUP
#line 633 "scan.l"
{
					addlitchar('\'', yyscanner);
				}
	YY_BREAK
case 21:
/* rule 21 can match eol */
YY_RULE_SETUP
#line 636 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 22:
/* rule 22 can match eol */
YY_RULE_SETUP
#line 639 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 23:
YY_RULE_SETUP
#line 642 "scan.l"
{
					pg_wchar	c = strtoul(yytext + 2, NULL, 16);

					/*
					 * For consistency with other productions, issue any
					 * escape warning with cursor pointing to start of string.
					 * We might want to change that, someday.
					 */
					check_escape_warning(yyscanner);

					/* Remember start of overall string token ... */
					PUSH_YYLLOC();
					/* ... and set the error cursor to point at this esc seq */
					SET_YYLLOC();

					if (is_utf16_surrogate_first(c))
					{
						yyextra->utf16_first_part = c;
						BEGIN(xeu);
					}
					else if (is_utf16_surrogate_second(c))
						yyerror("invalid Unicode surrogate pair");
					else
						addunicode(c, yyscanner);

					/* Restore yylloc to be start of string token */
					POP_YYLLOC();
				}
	YY_BREAK
case 24:
YY_RULE_SETUP
#line 670 "scan.l"
{
					pg_wchar	c = strtoul(yytext + 2, NULL, 16);

					/* Remember start of overall string token ... */
					PUSH_YYLLOC();
					/* ... and set the error cursor to point at this esc seq */
					SET_YYLLOC();

					if (!is_utf16_surrogate_second(c))
						yyerror("invalid Unicode surrogate pair");

					c = surrogate_pair_to_codepoint(yyextra->utf16_first_part, c);

					addunicode(c, yyscanner);

					/* Restore yylloc to be start of string token */
					POP_YYLLOC();

					BEGIN(xe);
				}
	YY_BREAK
case 25:
#line 691 "scan.l"
case 26:
/* rule 26 can match eol */
#line 692 "scan.l"
YY_RULE_SETUP
case YY_STATE_EOF(xeu):
#line 692 "scan.l"
{
					/* Set the error cursor to point at missing esc seq */
					SET_YYLLOC();
					yyerror("invalid Unicode surrogate pair");
				}
	YY_BREAK
case 27:
YY_RULE_SETUP
#line 697 "scan.l"
{
					/* Set the error cursor to point at malformed esc seq */
					SET_YYLLOC();
					ereport(ERROR,
							(errcode(ERRCODE_INVALID_ESCAPE_SEQUENCE),
							 errmsg("invalid Unicode escape"),
							 errhint("Unicode escapes must be \\uXXXX or \\UXXXXXXXX."),
							 lexer_errposition()));
				}
	YY_BREAK
case 28:
/* rule 28 can match eol */
YY_RULE_SETUP
#line 706 "scan.l"
{
					if (yytext[1] == '\'')
					{
						if (yyextra->backslash_quote == BACKSLASH_QUOTE_OFF ||
							(yyextra->backslash_quote == BACKSLASH_QUOTE_SAFE_ENCODING &&
							 PG_ENCODING_IS_CLIENT_ONLY(pg_get_client_encoding())))
							ereport(ERROR,
									(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
									 errmsg("unsafe use of \\' in a string literal"),
									 errhint("Use '' to write quotes in strings. \\' is insecure in client-only encodings."),
									 lexer_errposition()));
					}
					check_string_escape_warning(yytext[1], yyscanner);
					addlitchar(unescape_single_char(yytext[1], yyscanner),
							   yyscanner);
				}
	YY_BREAK
case 29:
YY_RULE_SETUP
#line 722 "scan.l"
{
					unsigned char c = strtoul(yytext + 1, NULL, 8);

					check_escape_warning(yyscanner);
					addlitchar(c, yyscanner);
					if (c == '\0' || IS_HIGHBIT_SET(c))
						yyextra->saw_non_ascii = true;
				}
	YY_BREAK
case 30:
YY_RULE_SETUP
#line 730 "scan.l"
{
					unsigned char c = strtoul(yytext + 2, NULL, 16);

					check_escape_warning(yyscanner);
					addlitchar(c, yyscanner);
					if (c == '\0' || IS_HIGHBIT_SET(c))
						yyextra->saw_non_ascii = true;
				}
	YY_BREAK
case 31:
YY_RULE_SETUP
#line 738 "scan.l"
{
					/* This is only needed for \ just before EOF */
					addlitchar(yytext[0], yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xq):
case YY_STATE_EOF(xe):
case YY_STATE_EOF(xus):
#line 742 "scan.l"
{ yyerror("unterminated quoted string"); }
	YY_BREAK
case 32:
YY_RULE_SETUP
#line 744 "scan.l"
{
					SET_YYLLOC();
					yyextra->dolqstart = pstrdup(yytext);
					BEGIN(xdolq);
					startlit();
				}
	YY_BREAK
case 33:
YY_RULE_SETUP
#line 750 "scan.l"
{
					SET_YYLLOC();
					/* throw back all but the initial "$" */
					yyless(1);
					/* and treat it as {other} */
					return yytext[0];
				}
	YY_BREAK
case 34:
YY_RULE_SETUP
#line 757 "scan.l"
{
					if (strcmp(yytext, yyextra->dolqstart) == 0)
					{
						pfree(yyextra->dolqstart);
						yyextra->dolqstart = NULL;
						BEGIN(INITIAL);
						yylval->str = litbufdup(yyscanner);
						return SCONST;
					}
					else
					{
						/*
						 * When we fail to match $...$ to dolqstart, transfer
						 * the $... part to the output, but put back the final
						 * $ for rescanning.  Consider $delim$...$junk$delim$
						 */
						addlit(yytext, yyleng - 1, yyscanner);
						yyless(yyleng - 1);
					}
				}
	YY_BREAK
case 35:
/* rule 35 can match eol */
YY_RULE_SETUP
#line 777 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 36:
YY_RULE_SETUP
#line 780 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case 37:
YY_RULE_SETUP
#line 783 "scan.l"
{
					/* This is only needed for $ inside the quoted text */
					addlitchar(yytext[0], yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xdolq):
#line 787 "scan.l"
{ yyerror("unterminated dollar-quoted string"); }
	YY_BREAK
case 38:
YY_RULE_SETUP
#line 789 "scan.l"
{
					SET_YYLLOC();
					BEGIN(xd);
					startlit();
				}
	YY_BREAK
case 39:
YY_RULE_SETUP
#line 794 "scan.l"
{
					SET_YYLLOC();
					BEGIN(xui);
					startlit();
				}
	YY_BREAK
case 40:
YY_RULE_SETUP
#line 799 "scan.l"
{
					char	   *ident;

					BEGIN(INITIAL);
					if (yyextra->literallen == 0)
						yyerror("zero-length delimited identifier");
					ident = litbufdup(yyscanner);
					if (yyextra->literallen >= NAMEDATALEN)
						truncate_identifier(ident, yyextra->literallen, true);
					yylval->str = ident;
					return IDENT;
				}
	YY_BREAK
case 41:
YY_RULE_SETUP
#line 811 "scan.l"
{
					BEGIN(INITIAL);
					if (yyextra->literallen == 0)
						yyerror("zero-length delimited identifier");
					/* can't truncate till after we de-escape the ident */
					yylval->str = litbufdup(yyscanner);
					return UIDENT;
				}
	YY_BREAK
case 42:
YY_RULE_SETUP
#line 819 "scan.l"
{
					addlitchar('"', yyscanner);
				}
	YY_BREAK
case 43:
/* rule 43 can match eol */
YY_RULE_SETUP
#line 822 "scan.l"
{
					addlit(yytext, yyleng, yyscanner);
				}
	YY_BREAK
case YY_STATE_EOF(xd):
case YY_STATE_EOF(xui):
#line 825 "scan.l"
{ yyerror("unterminated quoted identifier"); }
	YY_BREAK
case 44:
YY_RULE_SETUP
#line 827 "scan.l"
{
					char	   *ident;

					SET_YYLLOC();
					/* throw back all but the initial u/U */
					yyless(1);
					/* and treat it as {identifier} */
					ident = downcase_truncate_identifier(yytext, yyleng, true);
					yylval->str = ident;
					return IDENT;
				}
	YY_BREAK
case 45:
YY_RULE_SETUP
#line 839 "scan.l"
{
					SET_YYLLOC();
					return TYPECAST;
				}
	YY_BREAK
case 46:
YY_RULE_SETUP
#line 844 "scan.l"
{
					SET_YYLLOC();
					return DOT_DOT;
				}
	YY_BREAK
case 47:
YY_RULE_SETUP
#line 849 "scan.l"
{
					SET_YYLLOC();
					return COLON_EQUALS;
				}
	YY_BREAK
case 48:
YY_RULE_SETUP
#line 854 "scan.l"
{
					SET_YYLLOC();
					return EQUALS_GREATER;
				}
	YY_BREAK
case 49:
YY_RULE_SETUP
#line 859 "scan.l"
{
					SET_YYLLOC();
					return LESS_EQUALS;
				}
	YY_BREAK
case 50:
YY_RULE_SETUP
#line 864 "scan.l"
{
					SET_YYLLOC();
					return GREATER_EQUALS;
				}
	YY_BREAK
case 51:
YY_RULE_SETUP
#line 869 "scan.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					SET_YYLLOC();
					return NOT_EQUALS;
				}
	YY_BREAK
case 52:
YY_RULE_SETUP
#line 875 "scan.l"
{
					/* We accept both "<>" and "!=" as meaning NOT_EQUALS */
					SET_YYLLOC();
					return NOT_EQUALS;
				}
	YY_BREAK
case 53:
YY_RULE_SETUP
#line 881 "scan.l"
{
					SET_YYLLOC();
					return yytext[0];
				}
	YY_BREAK
case 54:
YY_RULE_SETUP
#line 886 "scan.l"
{
					/*
					 * Check for embedded slash-star or dash-dash; those
					 * are comment starts, so operator must stop there.
					 * Note that slash-star or dash-dash at the first
					 * character will match a prior rule, not this one.
					 */
					int			nchars = yyleng;
					char	   *slashstar = strstr(yytext, "/*");
					char	   *dashdash = strstr(yytext, "--");

					if (slashstar && dashdash)
					{
						/* if both appear, take the first one */
						if (slashstar > dashdash)
							slashstar = dashdash;
					}
					else if (!slashstar)
						slashstar = dashdash;
					if (slashstar)
						nchars = slashstar - yytext;

					/*
					 * For SQL compatibility, '+' and '-' cannot be the
					 * last char of a multi-char operator unless the operator
					 * contains chars that are not in SQL operators.
					 * The idea is to lex '=-' as two operators, but not
					 * to forbid operator names like '?-' that could not be
					 * sequences of SQL operators.
					 */
					if (nchars > 1 &&
						(yytext[nchars - 1] == '+' ||
						 yytext[nchars - 1] == '-'))
					{
						int			ic;

						for (ic = nchars - 2; ic >= 0; ic--)
						{
							char c = yytext[ic];
							if (c == '~' || c == '!' || c == '@' ||
								c == '#' || c == '^' || c == '&' ||
								c == '|' || c == '`' || c == '?' ||
								c == '%')
								break;
						}
						if (ic < 0)
						{
							/*
							 * didn't find a qualifying character, so remove
							 * all trailing [+-]
							 */
							do {
								nchars--;
							} while (nchars > 1 &&
								 (yytext[nchars - 1] == '+' ||
								  yytext[nchars - 1] == '-'));
						}
					}

					SET_YYLLOC();

					if (nchars < yyleng)
					{
						/* Strip the unwanted chars from the token */
						yyless(nchars);
						/*
						 * If what we have left is only one char, and it's
						 * one of the characters matching "self", then
						 * return it as a character token the same way
						 * that the "self" rule would have.
						 */
						if (nchars == 1 &&
							strchr(",()[].;:+-*/%^<>=", yytext[0]))
							return yytext[0];
						/*
						 * Likewise, if what we have left is two chars, and
						 * those match the tokens ">=", "<=", "=>", "<>" or
						 * "!=", then we must return the appropriate token
						 * rather than the generic Op.
						 */
						if (nchars == 2)
						{
							if (yytext[0] == '=' && yytext[1] == '>')
								return EQUALS_GREATER;
							if (yytext[0] == '>' && yytext[1] == '=')
								return GREATER_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '=')
								return LESS_EQUALS;
							if (yytext[0] == '<' && yytext[1] == '>')
								return NOT_EQUALS;
							if (yytext[0] == '!' && yytext[1] == '=')
								return NOT_EQUALS;
						}
					}

					/*
					 * Complain if operator is too long.  Unlike the case
					 * for identifiers, we make this an error not a notice-
					 * and-truncate, because the odds are we are looking at
					 * a syntactic mistake anyway.
					 */
					if (nchars >= NAMEDATALEN)
						yyerror("operator too long");

					yylval->str = pstrdup(yytext);
					return Op;
				}
	YY_BREAK
case 55:
YY_RULE_SETUP
#line 994 "scan.l"
{
					SET_YYLLOC();
					yylval->ival = atol(yytext + 1);
					return PARAM;
				}
	YY_BREAK
case 56:
YY_RULE_SETUP
#line 999 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after parameter");
				}
	YY_BREAK
case 57:
YY_RULE_SETUP
#line 1004 "scan.l"
{
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval, 10);
				}
	YY_BREAK
case 58:
YY_RULE_SETUP
#line 1008 "scan.l"
{
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval, 16);
				}
	YY_BREAK
case 59:
YY_RULE_SETUP
#line 1012 "scan.l"
{
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval, 8);
				}
	YY_BREAK
case 60:
YY_RULE_SETUP
#line 1016 "scan.l"
{
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval, 2);
				}
	YY_BREAK
case 61:
YY_RULE_SETUP
#line 1020 "scan.l"
{
					SET_YYLLOC();
					yyerror("invalid hexadecimal integer");
				}
	YY_BREAK
case 62:
YY_RULE_SETUP
#line 1024 "scan.l"
{
					SET_YYLLOC();
					yyerror("invalid octal integer");
				}
	YY_BREAK
case 63:
YY_RULE_SETUP
#line 1028 "scan.l"
{
					SET_YYLLOC();
					yyerror("invalid binary integer");
				}
	YY_BREAK
case 64:
YY_RULE_SETUP
#line 1032 "scan.l"
{
					SET_YYLLOC();
					yylval->str = pstrdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 65:
YY_RULE_SETUP
#line 1037 "scan.l"
{
					/* throw back the .., and treat as integer */
					yyless(yyleng - 2);
					SET_YYLLOC();
					return process_integer_literal(yytext, yylval, 10);
				}
	YY_BREAK
case 66:
YY_RULE_SETUP
#line 1043 "scan.l"
{
					SET_YYLLOC();
					yylval->str = pstrdup(yytext);
					return FCONST;
				}
	YY_BREAK
case 67:
YY_RULE_SETUP
#line 1048 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 68:
YY_RULE_SETUP
#line 1052 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 69:
YY_RULE_SETUP
#line 1056 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 70:
YY_RULE_SETUP
#line 1060 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 71:
YY_RULE_SETUP
#line 1064 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 72:
YY_RULE_SETUP
#line 1068 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 73:
YY_RULE_SETUP
#line 1072 "scan.l"
{
					SET_YYLLOC();
					yyerror("trailing junk after numeric literal");
				}
	YY_BREAK
case 74:
YY_RULE_SETUP
#line 1078 "scan.l"
{
					int			kwnum;
					char	   *ident;

					SET_YYLLOC();

					/* Is it a keyword? */
					kwnum = ScanKeywordLookup(yytext,
											  yyextra->keywordlist);
					if (kwnum >= 0)
					{
						yylval->keyword = GetScanKeyword(kwnum,
														 yyextra->keywordlist);
						return yyextra->keyword_tokens[kwnum];
					}

					/*
					 * No.  Convert the identifier to lower case, and truncate
					 * if necessary.
					 */
					ident = downcase_truncate_identifier(yytext, yyleng, true);
					yylval->str = ident;
					return IDENT;
				}
	YY_BREAK
case 75:
YY_RULE_SETUP
#line 1103 "scan.l"
{
					SET_YYLLOC();
					return yytext[0];
				}
	YY_BREAK
case YY_STATE_EOF(INITIAL):
#line 1108 "scan.l"
{
					SET_YYLLOC();
					yyterminate();
				}
	YY_BREAK
case 76:
YY_RULE_SETUP
#line 1113 "scan.l"
YY_FATAL_ERROR( "flex scanner jammed" );
	YY_BREAK
#line 7537 "scan.c"

	case YY_END_OF_BUFFER:
		{
		/* Amount of text matched not including the EOB char. */
		int yy_amount_of_matched_text = (int) (yy_cp - yyg->yytext_ptr) - 1;

		/* Undo the effects of YY_DO_BEFORE_ACTION. */
		*yy_cp = yyg->yy_hold_char;
		YY_RESTORE_YY_MORE_OFFSET

		if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_NEW )
			{
			/* We're scanning a new file or input source.  It's
			 * possible that this happened because the user
			 * just pointed yyin at a new source and called
			 * yylex().  If so, then we have to assure
			 * consistency between YY_CURRENT_BUFFER and our
			 * globals.  Here is the right place to do so, because
			 * this is the first action (other than possibly a
			 * back-up) that will match for the new input source.
			 */
			yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
			YY_CURRENT_BUFFER_LVALUE->yy_input_file = yyin;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status = YY_BUFFER_NORMAL;
			}

		/* Note that here we test for yy_c_buf_p "<=" to the position
		 * of the first EOB in the buffer, since yy_c_buf_p will
		 * already have been incremented past the NUL character
		 * (since all states make transitions on EOB to the
		 * end-of-buffer state).  Contrast this with the test
		 * in input().
		 */
		if ( yyg->yy_c_buf_p <= &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			{ /* This was really a NUL. */
			yy_state_type yy_next_state;

			yyg->yy_c_buf_p = yyg->yytext_ptr + yy_amount_of_matched_text;

			yy_current_state = yy_get_previous_state( yyscanner );

			/* Okay, we're now positioned to make the NUL
			 * transition.  We couldn't have
			 * yy_get_previous_state() go ahead and do it
			 * for us because it doesn't know how to deal
			 * with the possibility of jamming (and we don't
			 * want to build jamming into it because then it
			 * will run more slowly).
			 */

			yy_next_state = yy_try_NUL_trans( yy_current_state , yyscanner);

			yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;

			if ( yy_next_state )
				{
				/* Consume the NUL. */
				yy_cp = ++yyg->yy_c_buf_p;
				yy_current_state = yy_next_state;
				goto yy_match;
				}

			else
				{
				yy_cp = yyg->yy_c_buf_p;
				goto yy_find_action;
				}
			}

		else switch ( yy_get_next_buffer( yyscanner ) )
			{
			case EOB_ACT_END_OF_FILE:
				{
				yyg->yy_did_buffer_switch_on_eof = 0;

				if ( yywrap( yyscanner ) )
					{
					/* Note: because we've taken care in
					 * yy_get_next_buffer() to have set up
					 * yytext, we can now set up
					 * yy_c_buf_p so that if some total
					 * hoser (like flex itself) wants to
					 * call the scanner after we return the
					 * YY_NULL, it'll still work - another
					 * YY_NULL will get returned.
					 */
					yyg->yy_c_buf_p = yyg->yytext_ptr + YY_MORE_ADJ;

					yy_act = YY_STATE_EOF(YY_START);
					goto do_action;
					}

				else
					{
					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
					}
				break;
				}

			case EOB_ACT_CONTINUE_SCAN:
				yyg->yy_c_buf_p =
					yyg->yytext_ptr + yy_amount_of_matched_text;

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_match;

			case EOB_ACT_LAST_MATCH:
				yyg->yy_c_buf_p =
				&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars];

				yy_current_state = yy_get_previous_state( yyscanner );

				yy_cp = yyg->yy_c_buf_p;
				yy_bp = yyg->yytext_ptr + YY_MORE_ADJ;
				goto yy_find_action;
			}
		break;
		}

	default:
		YY_FATAL_ERROR(
			"fatal flex scanner internal error--no action found" );
	} /* end of action switch */
		} /* end of scanning one token */
	} /* end of user's declarations */
} /* end of yylex */

/* yy_get_next_buffer - try to read in a new buffer
 *
 * Returns a code representing an action:
 *	EOB_ACT_LAST_MATCH -
 *	EOB_ACT_CONTINUE_SCAN - continue scanning from current position
 *	EOB_ACT_END_OF_FILE - end of file
 */
static int yy_get_next_buffer (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	char *dest = YY_CURRENT_BUFFER_LVALUE->yy_ch_buf;
	char *source = yyg->yytext_ptr;
	int number_to_move, i;
	int ret_val;

	if ( yyg->yy_c_buf_p > &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] )
		YY_FATAL_ERROR(
		"fatal flex scanner internal error--end of buffer missed" );

	if ( YY_CURRENT_BUFFER_LVALUE->yy_fill_buffer == 0 )
		{ /* Don't try to fill the buffer, so this is an EOF. */
		if ( yyg->yy_c_buf_p - yyg->yytext_ptr - YY_MORE_ADJ == 1 )
			{
			/* We matched a single character, the EOB, so
			 * treat this as a final EOF.
			 */
			return EOB_ACT_END_OF_FILE;
			}

		else
			{
			/* We matched some text prior to the EOB, first
			 * process it.
			 */
			return EOB_ACT_LAST_MATCH;
			}
		}

	/* Try to read more data. */

	/* First move last chars to start of buffer. */
	number_to_move = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr - 1);

	for ( i = 0; i < number_to_move; ++i )
		*(dest++) = *(source++);

	if ( YY_CURRENT_BUFFER_LVALUE->yy_buffer_status == YY_BUFFER_EOF_PENDING )
		/* don't do the read, it's not guaranteed to return an EOF,
		 * just force an EOF
		 */
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars = 0;

	else
		{
			int num_to_read =
			YY_CURRENT_BUFFER_LVALUE->yy_buf_size - number_to_move - 1;

		while ( num_to_read <= 0 )
			{ /* Not enough room in the buffer - grow it. */

			/* just a shorter name for the current buffer */
			YY_BUFFER_STATE b = YY_CURRENT_BUFFER_LVALUE;

			int yy_c_buf_p_offset =
				(int) (yyg->yy_c_buf_p - b->yy_ch_buf);

			if ( b->yy_is_our_buffer )
				{
				int new_size = b->yy_buf_size * 2;

				if ( new_size <= 0 )
					b->yy_buf_size += b->yy_buf_size / 8;
				else
					b->yy_buf_size *= 2;

				b->yy_ch_buf = (char *)
					/* Include room in for 2 EOB chars. */
					yyrealloc( (void *) b->yy_ch_buf,
							 (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
				}
			else
				/* Can't grow it, we don't own it. */
				b->yy_ch_buf = NULL;

			if ( ! b->yy_ch_buf )
				YY_FATAL_ERROR(
				"fatal error - scanner input buffer overflow" );

			yyg->yy_c_buf_p = &b->yy_ch_buf[yy_c_buf_p_offset];

			num_to_read = YY_CURRENT_BUFFER_LVALUE->yy_buf_size -
						number_to_move - 1;

			}

		if ( num_to_read > YY_READ_BUF_SIZE )
			num_to_read = YY_READ_BUF_SIZE;

		/* Read in more data. */
		YY_INPUT( (&YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[number_to_move]),
			yyg->yy_n_chars, num_to_read );

		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	if ( yyg->yy_n_chars == 0 )
		{
		if ( number_to_move == YY_MORE_ADJ )
			{
			ret_val = EOB_ACT_END_OF_FILE;
			yyrestart( yyin  , yyscanner);
			}

		else
			{
			ret_val = EOB_ACT_LAST_MATCH;
			YY_CURRENT_BUFFER_LVALUE->yy_buffer_status =
				YY_BUFFER_EOF_PENDING;
			}
		}

	else
		ret_val = EOB_ACT_CONTINUE_SCAN;

	if ((yyg->yy_n_chars + number_to_move) > YY_CURRENT_BUFFER_LVALUE->yy_buf_size) {
		/* Extend the array by 50%, plus the number we really need. */
		int new_size = yyg->yy_n_chars + number_to_move + (yyg->yy_n_chars >> 1);
		YY_CURRENT_BUFFER_LVALUE->yy_ch_buf = (char *) yyrealloc(
			(void *) YY_CURRENT_BUFFER_LVALUE->yy_ch_buf, (yy_size_t) new_size , yyscanner );
		if ( ! YY_CURRENT_BUFFER_LVALUE->yy_ch_buf )
			YY_FATAL_ERROR( "out of dynamic memory in yy_get_next_buffer()" );
		/* "- 2" to take care of EOB's */
		YY_CURRENT_BUFFER_LVALUE->yy_buf_size = (int) (new_size - 2);
	}

	yyg->yy_n_chars += number_to_move;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] = YY_END_OF_BUFFER_CHAR;
	YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars + 1] = YY_END_OF_BUFFER_CHAR;

	yyg->yytext_ptr = &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[0];

	return ret_val;
}

/* yy_get_previous_state - get the state just before the EOB char was reached */

    static yy_state_type yy_get_previous_state (yyscan_t yyscanner)
{
	yy_state_type yy_current_state;
	char *yy_cp;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_current_state = yy_start_state_list[yyg->yy_start];

	for ( yy_cp = yyg->yytext_ptr + YY_MORE_ADJ; yy_cp < yyg->yy_c_buf_p; ++yy_cp )
		{
		yy_current_state += yy_current_state[(*yy_cp ? YY_SC_TO_UI(*yy_cp) : 256)].yy_nxt;
		}

	return yy_current_state;
}

/* yy_try_NUL_trans - try to make a transition on the NUL character
 *
 * synopsis
 *	next_state = yy_try_NUL_trans( current_state );
 */
    static yy_state_type yy_try_NUL_trans  (yy_state_type yy_current_state , yyscan_t yyscanner)
{
	int yy_is_jam;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner; /* This var may be unused depending upon options. */

	int yy_c = 256;
	const struct yy_trans_info *yy_trans_info;

	yy_trans_info = &yy_current_state[(unsigned int) yy_c];
	yy_current_state += yy_trans_info->yy_nxt;
	yy_is_jam = (yy_trans_info->yy_verify != yy_c);

	(void)yyg;
	return yy_is_jam ? 0 : yy_current_state;
}

#ifndef YY_NO_UNPUT

#endif

#ifndef YY_NO_INPUT
#ifdef __cplusplus
    static int yyinput (yyscan_t yyscanner)
#else
    static int input  (yyscan_t yyscanner)
#endif

{
	int c;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	*yyg->yy_c_buf_p = yyg->yy_hold_char;

	if ( *yyg->yy_c_buf_p == YY_END_OF_BUFFER_CHAR )
		{
		/* yy_c_buf_p now points to the character we want to return.
		 * If this occurs *before* the EOB characters, then it's a
		 * valid NUL; if not, then we've hit the end of the buffer.
		 */
		if ( yyg->yy_c_buf_p < &YY_CURRENT_BUFFER_LVALUE->yy_ch_buf[yyg->yy_n_chars] )
			/* This was really a NUL. */
			*yyg->yy_c_buf_p = '\0';

		else
			{ /* need more input */
			int offset = (int) (yyg->yy_c_buf_p - yyg->yytext_ptr);
			++yyg->yy_c_buf_p;

			switch ( yy_get_next_buffer( yyscanner ) )
				{
				case EOB_ACT_LAST_MATCH:
					/* This happens because yy_g_n_b()
					 * sees that we've accumulated a
					 * token and flags that we need to
					 * try matching the token before
					 * proceeding.  But for input(),
					 * there's no matching to consider.
					 * So convert the EOB_ACT_LAST_MATCH
					 * to EOB_ACT_END_OF_FILE.
					 */

					/* Reset buffer status. */
					yyrestart( yyin , yyscanner);

					/*FALLTHROUGH*/

				case EOB_ACT_END_OF_FILE:
					{
					if ( yywrap( yyscanner ) )
						return 0;

					if ( ! yyg->yy_did_buffer_switch_on_eof )
						YY_NEW_FILE;
#ifdef __cplusplus
					return yyinput(yyscanner);
#else
					return input(yyscanner);
#endif
					}

				case EOB_ACT_CONTINUE_SCAN:
					yyg->yy_c_buf_p = yyg->yytext_ptr + offset;
					break;
				}
			}
		}

	c = *(unsigned char *) yyg->yy_c_buf_p;	/* cast for 8-bit char's */
	*yyg->yy_c_buf_p = '\0';	/* preserve yytext */
	yyg->yy_hold_char = *++yyg->yy_c_buf_p;

	return c;
}
#endif	/* ifndef YY_NO_INPUT */

/** Immediately switch to a different input stream.
 * @param input_file A readable stream.
 * @param yyscanner The scanner object.
 * @note This function does not reset the start condition to @c INITIAL .
 */
    void yyrestart  (FILE * input_file , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! YY_CURRENT_BUFFER ){
        yyensure_buffer_stack (yyscanner);
		YY_CURRENT_BUFFER_LVALUE =
            yy_create_buffer( yyin, YY_BUF_SIZE , yyscanner);
	}

	yy_init_buffer( YY_CURRENT_BUFFER, input_file , yyscanner);
	yy_load_buffer_state( yyscanner );
}

/** Switch to a different input buffer.
 * @param new_buffer The new input buffer.
 * @param yyscanner The scanner object.
 */
    void yy_switch_to_buffer  (YY_BUFFER_STATE  new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	/* TODO. We should be able to replace this entire function body
	 * with
	 *		yypop_buffer_state();
	 *		yypush_buffer_state(new_buffer);
     */
	yyensure_buffer_stack (yyscanner);
	if ( YY_CURRENT_BUFFER == new_buffer )
		return;

	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	YY_CURRENT_BUFFER_LVALUE = new_buffer;
	yy_load_buffer_state( yyscanner );

	/* We don't actually know whether we did this switch during
	 * EOF (yywrap()) processing, but the only time this flag
	 * is looked at is after yywrap() is called, so it's safe
	 * to go ahead and always set it.
	 */
	yyg->yy_did_buffer_switch_on_eof = 1;
}

static void yy_load_buffer_state  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	yyg->yy_n_chars = YY_CURRENT_BUFFER_LVALUE->yy_n_chars;
	yyg->yytext_ptr = yyg->yy_c_buf_p = YY_CURRENT_BUFFER_LVALUE->yy_buf_pos;
	yyin = YY_CURRENT_BUFFER_LVALUE->yy_input_file;
	yyg->yy_hold_char = *yyg->yy_c_buf_p;
}

/** Allocate and initialize an input buffer state.
 * @param file A readable stream.
 * @param size The character buffer size in bytes. When in doubt, use @c YY_BUF_SIZE.
 * @param yyscanner The scanner object.
 * @return the allocated buffer state.
 */
    YY_BUFFER_STATE yy_create_buffer  (FILE * file, int  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_buf_size = size;

	/* yy_ch_buf has to be 2 characters longer than the size given because
	 * we need to put in 2 end-of-buffer characters.
	 */
	b->yy_ch_buf = (char *) yyalloc( (yy_size_t) (b->yy_buf_size + 2) , yyscanner );
	if ( ! b->yy_ch_buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_create_buffer()" );

	b->yy_is_our_buffer = 1;

	yy_init_buffer( b, file , yyscanner);

	return b;
}

/** Destroy the buffer.
 * @param b a buffer created with yy_create_buffer()
 * @param yyscanner The scanner object.
 */
    void yy_delete_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if ( ! b )
		return;

	if ( b == YY_CURRENT_BUFFER ) /* Not sure if we should pop here. */
		YY_CURRENT_BUFFER_LVALUE = (YY_BUFFER_STATE) 0;

	if ( b->yy_is_our_buffer )
		yyfree( (void *) b->yy_ch_buf , yyscanner );

	yyfree( (void *) b , yyscanner );
}

/* Initializes or reinitializes a buffer.
 * This function is sometimes called more than once on the same buffer,
 * such as during a yyrestart() or at EOF.
 */
    static void yy_init_buffer  (YY_BUFFER_STATE  b, FILE * file , yyscan_t yyscanner)

{
	int oerrno = errno;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	yy_flush_buffer( b , yyscanner);

	b->yy_input_file = file;
	b->yy_fill_buffer = 1;

    /* If b is the current buffer, then yy_init_buffer was _probably_
     * called from yyrestart() or through yy_get_next_buffer.
     * In that case, we don't want to reset the lineno or column.
     */
    if (b != YY_CURRENT_BUFFER){
        b->yy_bs_lineno = 1;
        b->yy_bs_column = 0;
    }

        b->yy_is_interactive = 0;
    
	errno = oerrno;
}

/** Discard all buffered characters. On the next scan, YY_INPUT will be called.
 * @param b the buffer state to be flushed, usually @c YY_CURRENT_BUFFER.
 * @param yyscanner The scanner object.
 */
    void yy_flush_buffer (YY_BUFFER_STATE  b , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if ( ! b )
		return;

	b->yy_n_chars = 0;

	/* We always need two end-of-buffer characters.  The first causes
	 * a transition to the end-of-buffer state.  The second causes
	 * a jam in that state.
	 */
	b->yy_ch_buf[0] = YY_END_OF_BUFFER_CHAR;
	b->yy_ch_buf[1] = YY_END_OF_BUFFER_CHAR;

	b->yy_buf_pos = &b->yy_ch_buf[0];

	b->yy_at_bol = 1;
	b->yy_buffer_status = YY_BUFFER_NEW;

	if ( b == YY_CURRENT_BUFFER )
		yy_load_buffer_state( yyscanner );
}

/** Pushes the new state onto the stack. The new state becomes
 *  the current state. This function will allocate the stack
 *  if necessary.
 *  @param new_buffer The new state.
 *  @param yyscanner The scanner object.
 */
void yypush_buffer_state (YY_BUFFER_STATE new_buffer , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (new_buffer == NULL)
		return;

	yyensure_buffer_stack(yyscanner);

	/* This block is copied from yy_switch_to_buffer. */
	if ( YY_CURRENT_BUFFER )
		{
		/* Flush out information for old buffer. */
		*yyg->yy_c_buf_p = yyg->yy_hold_char;
		YY_CURRENT_BUFFER_LVALUE->yy_buf_pos = yyg->yy_c_buf_p;
		YY_CURRENT_BUFFER_LVALUE->yy_n_chars = yyg->yy_n_chars;
		}

	/* Only push if top exists. Otherwise, replace top. */
	if (YY_CURRENT_BUFFER)
		yyg->yy_buffer_stack_top++;
	YY_CURRENT_BUFFER_LVALUE = new_buffer;

	/* copied from yy_switch_to_buffer. */
	yy_load_buffer_state( yyscanner );
	yyg->yy_did_buffer_switch_on_eof = 1;
}

/** Removes and deletes the top of the stack, if present.
 *  The next element becomes the new top.
 *  @param yyscanner The scanner object.
 */
void yypop_buffer_state (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	if (!YY_CURRENT_BUFFER)
		return;

	yy_delete_buffer(YY_CURRENT_BUFFER , yyscanner);
	YY_CURRENT_BUFFER_LVALUE = NULL;
	if (yyg->yy_buffer_stack_top > 0)
		--yyg->yy_buffer_stack_top;

	if (YY_CURRENT_BUFFER) {
		yy_load_buffer_state( yyscanner );
		yyg->yy_did_buffer_switch_on_eof = 1;
	}
}

/* Allocates the stack if it does not exist.
 *  Guarantees space for at least one push.
 */
static void yyensure_buffer_stack (yyscan_t yyscanner)
{
	yy_size_t num_to_alloc;
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

	if (!yyg->yy_buffer_stack) {

		/* First allocation is just for 2 elements, since we don't know if this
		 * scanner will even need a stack. We use 2 instead of 1 to avoid an
		 * immediate realloc on the next call.
         */
      num_to_alloc = 1; /* After all that talk, this was set to 1 anyways... */
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyalloc
								(num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		memset(yyg->yy_buffer_stack, 0, num_to_alloc * sizeof(struct yy_buffer_state*));

		yyg->yy_buffer_stack_max = num_to_alloc;
		yyg->yy_buffer_stack_top = 0;
		return;
	}

	if (yyg->yy_buffer_stack_top >= (yyg->yy_buffer_stack_max) - 1){

		/* Increase the buffer to prepare for a possible push. */
		yy_size_t grow_size = 8 /* arbitrary grow size */;

		num_to_alloc = yyg->yy_buffer_stack_max + grow_size;
		yyg->yy_buffer_stack = (struct yy_buffer_state**)yyrealloc
								(yyg->yy_buffer_stack,
								num_to_alloc * sizeof(struct yy_buffer_state*)
								, yyscanner);
		if ( ! yyg->yy_buffer_stack )
			YY_FATAL_ERROR( "out of dynamic memory in yyensure_buffer_stack()" );

		/* zero only the new slots.*/
		memset(yyg->yy_buffer_stack + yyg->yy_buffer_stack_max, 0, grow_size * sizeof(struct yy_buffer_state*));
		yyg->yy_buffer_stack_max = num_to_alloc;
	}
}

/** Setup the input buffer state to scan directly from a user-specified character buffer.
 * @param base the character buffer
 * @param size the size in bytes of the character buffer
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_buffer  (char * base, yy_size_t  size , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
    
	if ( size < 2 ||
	     base[size-2] != YY_END_OF_BUFFER_CHAR ||
	     base[size-1] != YY_END_OF_BUFFER_CHAR )
		/* They forgot to leave room for the EOB's. */
		return NULL;

	b = (YY_BUFFER_STATE) yyalloc( sizeof( struct yy_buffer_state ) , yyscanner );
	if ( ! b )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_buffer()" );

	b->yy_buf_size = (int) (size - 2);	/* "- 2" to take care of EOB's */
	b->yy_buf_pos = b->yy_ch_buf = base;
	b->yy_is_our_buffer = 0;
	b->yy_input_file = NULL;
	b->yy_n_chars = b->yy_buf_size;
	b->yy_is_interactive = 0;
	b->yy_at_bol = 1;
	b->yy_fill_buffer = 0;
	b->yy_buffer_status = YY_BUFFER_NEW;

	yy_switch_to_buffer( b , yyscanner );

	return b;
}

/** Setup the input buffer state to scan a string. The next call to yylex() will
 * scan from a @e copy of @a str.
 * @param yystr a NUL-terminated string to scan
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 * @note If you want to scan bytes that may contain NUL values, then use
 *       yy_scan_bytes() instead.
 */
YY_BUFFER_STATE yy_scan_string (const char * yystr , yyscan_t yyscanner)
{
    
	return yy_scan_bytes( yystr, (int) strlen(yystr) , yyscanner);
}

/** Setup the input buffer state to scan the given bytes. The next call to yylex() will
 * scan from a @e copy of @a bytes.
 * @param yybytes the byte buffer to scan
 * @param _yybytes_len the number of bytes in the buffer pointed to by @a bytes.
 * @param yyscanner The scanner object.
 * @return the newly allocated buffer state object.
 */
YY_BUFFER_STATE yy_scan_bytes  (const char * yybytes, int  _yybytes_len , yyscan_t yyscanner)
{
	YY_BUFFER_STATE b;
	char *buf;
	yy_size_t n;
	int i;
    
	/* Get memory for full buffer, including space for trailing EOB's. */
	n = (yy_size_t) (_yybytes_len + 2);
	buf = (char *) yyalloc( n , yyscanner );
	if ( ! buf )
		YY_FATAL_ERROR( "out of dynamic memory in yy_scan_bytes()" );

	for ( i = 0; i < _yybytes_len; ++i )
		buf[i] = yybytes[i];

	buf[_yybytes_len] = buf[_yybytes_len+1] = YY_END_OF_BUFFER_CHAR;

	b = yy_scan_buffer( buf, n , yyscanner);
	if ( ! b )
		YY_FATAL_ERROR( "bad buffer in yy_scan_bytes()" );

	/* It's okay to grow etc. this buffer, and we should throw it
	 * away when we're done.
	 */
	b->yy_is_our_buffer = 1;

	return b;
}

#ifndef YY_EXIT_FAILURE
#define YY_EXIT_FAILURE 2
#endif

static void yynoreturn yy_fatal_error (const char* msg , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;
	fprintf( stderr, "%s\n", msg );
	exit( YY_EXIT_FAILURE );
}

/* Redefine yyless() so it works in section 3 code. */

#undef yyless
#define yyless(n) \
	do \
		{ \
		/* Undo effects of setting up yytext. */ \
        int yyless_macro_arg = (n); \
        YY_LESS_LINENO(yyless_macro_arg);\
		yytext[yyleng] = yyg->yy_hold_char; \
		yyg->yy_c_buf_p = yytext + yyless_macro_arg; \
		yyg->yy_hold_char = *yyg->yy_c_buf_p; \
		*yyg->yy_c_buf_p = '\0'; \
		yyleng = yyless_macro_arg; \
		} \
	while ( 0 )

/* Accessor  methods (get/set functions) to struct members. */

/** Get the user-defined data for this scanner.
 * @param yyscanner The scanner object.
 */
YY_EXTRA_TYPE yyget_extra  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyextra;
}

/** Get the current line number.
 * @param yyscanner The scanner object.
 */
int yyget_lineno  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yylineno;
}

/** Get the current column number.
 * @param yyscanner The scanner object.
 */
int yyget_column  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        if (! YY_CURRENT_BUFFER)
            return 0;
    
    return yycolumn;
}

/** Get the input stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_in  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyin;
}

/** Get the output stream.
 * @param yyscanner The scanner object.
 */
FILE *yyget_out  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyout;
}

/** Get the length of the current token.
 * @param yyscanner The scanner object.
 */
int yyget_leng  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yyleng;
}

/** Get the current token.
 * @param yyscanner The scanner object.
 */

char *yyget_text  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yytext;
}

/** Set the user-defined data. This data is never touched by the scanner.
 * @param user_defined The data to be associated with this scanner.
 * @param yyscanner The scanner object.
 */
void yyset_extra (YY_EXTRA_TYPE  user_defined , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyextra = user_defined ;
}

/** Set the current line number.
 * @param _line_number line number
 * @param yyscanner The scanner object.
 */
void yyset_lineno (int  _line_number , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* lineno is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_lineno called with no buffer" );
    
    yylineno = _line_number;
}

/** Set the current column.
 * @param _column_no column number
 * @param yyscanner The scanner object.
 */
void yyset_column (int  _column_no , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

        /* column is only valid if an input buffer exists. */
        if (! YY_CURRENT_BUFFER )
           YY_FATAL_ERROR( "yyset_column called with no buffer" );
    
    yycolumn = _column_no;
}

/** Set the input stream. This does not discard the current
 * input buffer.
 * @param _in_str A readable stream.
 * @param yyscanner The scanner object.
 * @see yy_switch_to_buffer
 */
void yyset_in (FILE *  _in_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyin = _in_str ;
}

void yyset_out (FILE *  _out_str , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yyout = _out_str ;
}

int yyget_debug  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yy_flex_debug;
}

void yyset_debug (int  _bdebug , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yy_flex_debug = _bdebug ;
}

/* Accessor methods for yylval and yylloc */

YYSTYPE * yyget_lval  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylval;
}

void yyset_lval (YYSTYPE *  yylval_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylval = yylval_param;
}

YYLTYPE *yyget_lloc  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    return yylloc;
}
    
void yyset_lloc (YYLTYPE *  yylloc_param , yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    yylloc = yylloc_param;
}
    
/* User-visible API */

/* yylex_init is special because it creates the scanner itself, so it is
 * the ONLY reentrant function that doesn't take the scanner as the last argument.
 * That's why we explicitly handle the declaration, instead of using our macros.
 */
int yylex_init(yyscan_t* ptr_yy_globals)
{
    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), NULL );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    return yy_init_globals ( *ptr_yy_globals );
}

/* yylex_init_extra has the same functionality as yylex_init, but follows the
 * convention of taking the scanner as the last argument. Note however, that
 * this is a *pointer* to a scanner, as it will be allocated by this call (and
 * is the reason, too, why this function also must handle its own declaration).
 * The user defined value in the first argument will be available to yyalloc in
 * the yyextra field.
 */
int yylex_init_extra( YY_EXTRA_TYPE yy_user_defined, yyscan_t* ptr_yy_globals )
{
    struct yyguts_t dummy_yyguts;

    yyset_extra (yy_user_defined, &dummy_yyguts);

    if (ptr_yy_globals == NULL){
        errno = EINVAL;
        return 1;
    }

    *ptr_yy_globals = (yyscan_t) yyalloc ( sizeof( struct yyguts_t ), &dummy_yyguts );

    if (*ptr_yy_globals == NULL){
        errno = ENOMEM;
        return 1;
    }

    /* By setting to 0xAA, we expose bugs in
    yy_init_globals. Leave at 0x00 for releases. */
    memset(*ptr_yy_globals,0x00,sizeof(struct yyguts_t));

    yyset_extra (yy_user_defined, *ptr_yy_globals);

    return yy_init_globals ( *ptr_yy_globals );
}

static int yy_init_globals (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
    /* Initialization is the same as for the non-reentrant scanner.
     * This function is called from yylex_destroy(), so don't allocate here.
     */

    yyg->yy_buffer_stack = NULL;
    yyg->yy_buffer_stack_top = 0;
    yyg->yy_buffer_stack_max = 0;
    yyg->yy_c_buf_p = NULL;
    yyg->yy_init = 0;
    yyg->yy_start = 0;

    yyg->yy_start_stack_ptr = 0;
    yyg->yy_start_stack_depth = 0;
    yyg->yy_start_stack =  NULL;

/* Defined in main.c */
#ifdef YY_STDINIT
    yyin = stdin;
    yyout = stdout;
#else
    yyin = NULL;
    yyout = NULL;
#endif

    /* For future reference: Set errno on error, since we are called by
     * yylex_init()
     */
    return 0;
}

/* yylex_destroy is for both reentrant and non-reentrant scanners. */
int yylex_destroy  (yyscan_t yyscanner)
{
    struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;

    /* Pop the buffer stack, destroying each element. */
	while(YY_CURRENT_BUFFER){
		yy_delete_buffer( YY_CURRENT_BUFFER , yyscanner );
		YY_CURRENT_BUFFER_LVALUE = NULL;
		yypop_buffer_state(yyscanner);
	}

	/* Destroy the stack itself. */
	yyfree(yyg->yy_buffer_stack , yyscanner);
	yyg->yy_buffer_stack = NULL;

    /* Destroy the start condition stack. */
        yyfree( yyg->yy_start_stack , yyscanner );
        yyg->yy_start_stack = NULL;

    /* Reset the globals. This is important in a non-reentrant scanner so the next time
     * yylex() is called, initialization will occur. */
    yy_init_globals( yyscanner);

    /* Destroy the main struct (reentrant only). */
    yyfree ( yyscanner , yyscanner );
    yyscanner = NULL;
    return 0;
}

/*
 * Internal utility routines.
 */

#ifndef yytext_ptr
static void yy_flex_strncpy (char* s1, const char * s2, int n , yyscan_t yyscanner)
{
	struct yyguts_t * yyg = (struct yyguts_t*)yyscanner;
	(void)yyg;

	int i;
	for ( i = 0; i < n; ++i )
		s1[i] = s2[i];
}
#endif

#ifdef YY_NEED_STRLEN
static int yy_flex_strlen (const char * s , yyscan_t yyscanner)
{
	int n;
	for ( n = 0; s[n]; ++n )
		;

	return n;
}
#endif

#define YYTABLES_NAME "yytables"

#line 1113 "scan.l"


/* LCOV_EXCL_STOP */

/*
 * Arrange access to yyextra for subroutines of the main yylex() function.
 * We expect each subroutine to have a yyscanner parameter.  Rather than
 * use the yyget_xxx functions, which might or might not get inlined by the
 * compiler, we cheat just a bit and cast yyscanner to the right type.
 */
#undef yyextra
#define yyextra  (((struct yyguts_t *) yyscanner)->yyextra_r)

/* Likewise for a couple of other things we need. */
#undef yylloc
#define yylloc	(((struct yyguts_t *) yyscanner)->yylloc_r)
#undef yyleng
#define yyleng	(((struct yyguts_t *) yyscanner)->yyleng_r)


/*
 * scanner_errposition
 *		Report a lexer or grammar error cursor position, if possible.
 *
 * This is expected to be used within an ereport() call, or via an error
 * callback such as setup_scanner_errposition_callback().  The return value
 * is a dummy (always 0, in fact).
 *
 * Note that this can only be used for messages emitted during raw parsing
 * (essentially, scan.l, parser.c, and gram.y), since it requires the
 * yyscanner struct to still be available.
 */
int
scanner_errposition(int location, core_yyscan_t yyscanner)
{
	int			pos;

	if (location < 0)
		return 0;				/* no-op if location is unknown */

	/* Convert byte offset to character number */
	pos = pg_mbstrlen_with_len(yyextra->scanbuf, location) + 1;
	/* And pass it to the ereport mechanism */
	return errposition(pos);
}

/*
 * Error context callback for inserting scanner error location.
 *
 * Note that this will be called for *any* error occurring while the
 * callback is installed.  We avoid inserting an irrelevant error location
 * if the error is a query cancel --- are there any other important cases?
 */
static void
scb_error_callback(void *arg)
{
	ScannerCallbackState *scbstate = (ScannerCallbackState *) arg;

	if (geterrcode() != ERRCODE_QUERY_CANCELED)
		(void) scanner_errposition(scbstate->location, scbstate->yyscanner);
}

/*
 * setup_scanner_errposition_callback
 *		Arrange for non-scanner errors to report an error position
 *
 * Sometimes the scanner calls functions that aren't part of the scanner
 * subsystem and can't reasonably be passed the yyscanner pointer; yet
 * we would like any errors thrown in those functions to be tagged with an
 * error location.  Use this function to set up an error context stack
 * entry that will accomplish that.  Usage pattern:
 *
 *		declare a local variable "ScannerCallbackState scbstate"
 *		...
 *		setup_scanner_errposition_callback(&scbstate, yyscanner, location);
 *		call function that might throw error;
 *		cancel_scanner_errposition_callback(&scbstate);
 */
void
setup_scanner_errposition_callback(ScannerCallbackState *scbstate,
								   core_yyscan_t yyscanner,
								   int location)
{
	/* Setup error traceback support for ereport() */
	scbstate->yyscanner = yyscanner;
	scbstate->location = location;
	scbstate->errcallback.callback = scb_error_callback;
	scbstate->errcallback.arg = (void *) scbstate;
	scbstate->errcallback.previous = error_context_stack;
	error_context_stack = &scbstate->errcallback;
}

/*
 * Cancel a previously-set-up errposition callback.
 */
void
cancel_scanner_errposition_callback(ScannerCallbackState *scbstate)
{
	/* Pop the error context stack */
	error_context_stack = scbstate->errcallback.previous;
}

/*
 * scanner_yyerror
 *		Report a lexer or grammar error.
 *
 * The message's cursor position is whatever YYLLOC was last set to,
 * ie, the start of the current token if called within yylex(), or the
 * most recently lexed token if called from the grammar.
 * This is OK for syntax error messages from the Bison parser, because Bison
 * parsers report error as soon as the first unparsable token is reached.
 * Beware of using yyerror for other purposes, as the cursor position might
 * be misleading!
 */
void
scanner_yyerror(const char *message, core_yyscan_t yyscanner)
{
	const char *loc = yyextra->scanbuf + *yylloc;

	if (*loc == YY_END_OF_BUFFER_CHAR)
	{
		ereport(ERROR,
				(errcode(ERRCODE_SYNTAX_ERROR),
		/* translator: %s is typically the translation of "syntax error" */
				 errmsg("%s at end of input", _(message)),
				 lexer_errposition()));
	}
	else
	{
		ereport(ERROR,
				(errcode(ERRCODE_SYNTAX_ERROR),
		/* translator: first %s is typically the translation of "syntax error" */
				 errmsg("%s at or near \"%s\"", _(message), loc),
				 lexer_errposition()));
	}
}


/*
 * Called before any actual parsing is done
 */
core_yyscan_t
scanner_init(const char *str,
			 core_yy_extra_type *yyext,
			 const ScanKeywordList *keywordlist,
			 const uint16 *keyword_tokens)
{
	Size		slen = strlen(str);
	yyscan_t	scanner;

	if (yylex_init(&scanner) != 0)
		elog(ERROR, "yylex_init() failed: %m");

	core_yyset_extra(yyext, scanner);

	yyext->keywordlist = keywordlist;
	yyext->keyword_tokens = keyword_tokens;

	yyext->backslash_quote = backslash_quote;
	yyext->escape_string_warning = escape_string_warning;
	yyext->standard_conforming_strings = standard_conforming_strings;

	/*
	 * Make a scan buffer with special termination needed by flex.
	 */
	yyext->scanbuf = (char *) palloc(slen + 2);
	yyext->scanbuflen = slen;
	memcpy(yyext->scanbuf, str, slen);
	yyext->scanbuf[slen] = yyext->scanbuf[slen + 1] = YY_END_OF_BUFFER_CHAR;
	yy_scan_buffer(yyext->scanbuf, slen + 2, scanner);

	/* initialize literal buffer to a reasonable but expansible size */
	yyext->literalalloc = 1024;
	yyext->literalbuf = (char *) palloc(yyext->literalalloc);
	yyext->literallen = 0;

	return scanner;
}


/*
 * Called after parsing is done to clean up after scanner_init()
 */
void
scanner_finish(core_yyscan_t yyscanner)
{
	/*
	 * We don't bother to call yylex_destroy(), because all it would do is
	 * pfree a small amount of control storage.  It's cheaper to leak the
	 * storage until the parsing context is destroyed.  The amount of space
	 * involved is usually negligible compared to the output parse tree
	 * anyway.
	 *
	 * We do bother to pfree the scanbuf and literal buffer, but only if they
	 * represent a nontrivial amount of space.  The 8K cutoff is arbitrary.
	 */
	if (yyextra->scanbuflen >= 8192)
		pfree(yyextra->scanbuf);
	if (yyextra->literalalloc >= 8192)
		pfree(yyextra->literalbuf);
}


static void
addlit(char *ytext, int yleng, core_yyscan_t yyscanner)
{
	/* enlarge buffer if needed */
	if ((yyextra->literallen + yleng) >= yyextra->literalalloc)
	{
		yyextra->literalalloc = pg_nextpower2_32(yyextra->literallen + yleng + 1);
		yyextra->literalbuf = (char *) repalloc(yyextra->literalbuf,
												yyextra->literalalloc);
	}
	/* append new data */
	memcpy(yyextra->literalbuf + yyextra->literallen, ytext, yleng);
	yyextra->literallen += yleng;
}


static void
addlitchar(unsigned char ychar, core_yyscan_t yyscanner)
{
	/* enlarge buffer if needed */
	if ((yyextra->literallen + 1) >= yyextra->literalalloc)
	{
		yyextra->literalalloc *= 2;
		yyextra->literalbuf = (char *) repalloc(yyextra->literalbuf,
												yyextra->literalalloc);
	}
	/* append new data */
	yyextra->literalbuf[yyextra->literallen] = ychar;
	yyextra->literallen += 1;
}


/*
 * Create a palloc'd copy of literalbuf, adding a trailing null.
 */
static char *
litbufdup(core_yyscan_t yyscanner)
{
	int			llen = yyextra->literallen;
	char	   *new;

	new = palloc(llen + 1);
	memcpy(new, yyextra->literalbuf, llen);
	new[llen] = '\0';
	return new;
}

/*
 * Process {decinteger}, {hexinteger}, etc.  Note this will also do the right
 * thing with {numeric}, ie digits and a decimal point.
 */
static int
process_integer_literal(const char *token, YYSTYPE *lval, int base)
{
	ErrorSaveContext escontext = {T_ErrorSaveContext};
	int32		val;

	val = pg_strtoint32_safe(token, (Node *) &escontext);
	if (escontext.error_occurred)
	{
		/* integer too large (or contains decimal pt), treat it as a float */
		lval->str = pstrdup(token);
		return FCONST;
	}
	lval->ival = val;
	return ICONST;
}

static void
addunicode(pg_wchar c, core_yyscan_t yyscanner)
{
	ScannerCallbackState scbstate;
	char		buf[MAX_UNICODE_EQUIVALENT_STRING + 1];

	if (!is_valid_unicode_codepoint(c))
		yyerror("invalid Unicode escape value");

	/*
	 * We expect that pg_unicode_to_server() will complain about any
	 * unconvertible code point, so we don't have to set saw_non_ascii.
	 */
	setup_scanner_errposition_callback(&scbstate, yyscanner, *(yylloc));
	pg_unicode_to_server(c, (unsigned char *) buf);
	cancel_scanner_errposition_callback(&scbstate);
	addlit(buf, strlen(buf), yyscanner);
}

static unsigned char
unescape_single_char(unsigned char c, core_yyscan_t yyscanner)
{
	switch (c)
	{
		case 'b':
			return '\b';
		case 'f':
			return '\f';
		case 'n':
			return '\n';
		case 'r':
			return '\r';
		case 't':
			return '\t';
		default:
			/* check for backslash followed by non-7-bit-ASCII */
			if (c == '\0' || IS_HIGHBIT_SET(c))
				yyextra->saw_non_ascii = true;

			return c;
	}
}

static void
check_string_escape_warning(unsigned char ychar, core_yyscan_t yyscanner)
{
	if (ychar == '\'')
	{
		if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
			ereport(WARNING,
					(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
					 errmsg("nonstandard use of \\' in a string literal"),
					 errhint("Use '' to write quotes in strings, or use the escape string syntax (E'...')."),
					 lexer_errposition()));
		yyextra->warn_on_first_escape = false;	/* warn only once per string */
	}
	else if (ychar == '\\')
	{
		if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
			ereport(WARNING,
					(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
					 errmsg("nonstandard use of \\\\ in a string literal"),
					 errhint("Use the escape string syntax for backslashes, e.g., E'\\\\'."),
					 lexer_errposition()));
		yyextra->warn_on_first_escape = false;	/* warn only once per string */
	}
	else
		check_escape_warning(yyscanner);
}

static void
check_escape_warning(core_yyscan_t yyscanner)
{
	if (yyextra->warn_on_first_escape && yyextra->escape_string_warning)
		ereport(WARNING,
				(errcode(ERRCODE_NONSTANDARD_USE_OF_ESCAPE_CHARACTER),
				 errmsg("nonstandard use of escape in a string literal"),
		errhint("Use the escape string syntax for escapes, e.g., E'\\r\\n'."),
				 lexer_errposition()));
	yyextra->warn_on_first_escape = false;		/* warn only once per string */
}

/*
 * Interface functions to make flex use palloc() instead of malloc().
 * It'd be better to make these static, but flex insists otherwise.
 */

void *
core_yyalloc(yy_size_t bytes, core_yyscan_t yyscanner)
{
	return palloc(bytes);
}

void *
core_yyrealloc(void *ptr, yy_size_t bytes, core_yyscan_t yyscanner)
{
	if (ptr)
		return repalloc(ptr, bytes);
	else
		return palloc(bytes);
}

void
core_yyfree(void *ptr, core_yyscan_t yyscanner)
{
	if (ptr)
		pfree(ptr);
}

