<?php
/*
  Author: Greg Feigenson
  File: add_workorder.php
  Copyright: 2004-2005 Greg Feigenson
  
  This software is licensed under the BSD license.
  Please see attached license or www.opensource.org
  for details
*/

require_once('objects/workorder_object.php');
require('includes/header.inc.php');
global $_wo_id;

echo "<div align='center'>";

if ($_POST['submitted'] == !null)
{
       if ($_POST['f_name'] != null && $_POST['l_name'] != null && $_POST['duedate'] != null && $_POST['problemdesc'] != null)
       {
	     //Create local vars... much prettier than accessing POST data directly
	     $fname	= $_POST['f_name'];
		 $lname	= $_POST['l_name'];
	     $desc	= "'".$_POST['problemdesc']."'";
	     $date	= $_POST['duedate'];
		
		 //do some fixin on the time
	     if ($_POST['duetime'] == null)
			$time = "09:30"; //begining of work day
	     else
			$time = $_POST['duetime'];
			
	     $promised_date = "'".formatDate($date,$time)."'";

		 //error checking
	     if ($promised_date == "'date'")
			echo "<b><font color='red'>Please double check your date and make sure it's correctly formatted</font></b>";

	     elseif ($promised_date == "'time'")
			echo "<b><font color='red'>Please double check your time and make sure it's correctly formatted</font></b>";
	     elseif ($promised_date == "'error'")
			echo "<b><font color='red'>ERROR! Please make sure your date/time are correctly formatted</font></b>";
	     else
	     {
		     if ($assignee != null)
				$assignee       = "'".$_POST['assignee']."'";
		     else
				$assignee = "'".$_SESSION['user']."'";
		     
		     //Other vars
		     $start_date  = "'".date("Y-m-d H:i:s")."'"; //start date should almost always be now
		     $status      = "0";
		     $total_cost  = "'0'";
	
		     //include the db
		     include("includes/db.inc.php");
		     
		     //Grab user ID for username
		     $query = "SELECT customer_id FROM customers WHERE first_name='$fname' AND last_name='$lname'";
		     $result = pg_exec($query) or die("Query failed : " . pg_last_error($connection));
		     $line = pg_fetch_assoc($result);
		     
		     if (pg_num_rows($result) < 1)
		     {
			     echo "<br><br><b><font color='red'>Sorry, could not find any customer named $username</font></b>"; 
		     } 	
		     else
		     {
			     $customer_id = $line['customer_id'];
			     
			     //formulate query
			     $query = 	"INSERT INTO workorder
					(customer_id, start_date, promised_date, staff, status, total_cost, description)
					VALUES ($customer_id, $start_date, $promised_date, $assignee,$status,$total_cost,$desc)";

			     //standard PG query - @ surpresses pg_query's innate nature to provide debug info - we already know the problem is ref. integrity.
			     //@$result = pg_exec($query) or die("<b><font color='red'>Query failed: Please make sure you are refering to a real customer ID</font></b>");
			     $result = pg_exec($query) or die("Query failed : " . pg_last_error($connection)); //debug line, only uncomment if above fails

			     //go to next step - adding a problem
			     if ($result)
			     {
				     //grab the workorder id
				     $query = "SELECT currval('workorder_workorder_id_seq')";
				     $result = pg_query($connection,$query) or die("Query failed : " . pg_last_error($connection));
				     $temp =  pg_fetch_assoc($result);
				     
				     //assign the workorder an id
				     $workorder->id = $temp['currval'];
				     
				     //throw the w/o ID into a global var to access later
				     $_wo_id = $temp['currval'];
				     
				     echo "<SCRIPT LANGUAGE='Javascript'>
					   window.location = 'add_problem.php?wo=$_wo_id'
					   </script>";
			     }

			     else
			     {
				    echo "<br><br><b><font color='red'>Problem creating work order! Please make sure
				    required fields (fields with *) are filled out CORRECTLY</font></b>"; 
			     }
		     }
	     }
        }

        			else
        			{
            				echo "<br><br><b><font color='red'>Problem creating work order! Please make sure
            				required fields (fields with *) are filled out</font></b>";
        			}
}

      echo "<form name='input' action='add_workorder.php' method='POST'>
       <h1>Create a new ticket</h1>
       <br><br>

       <table border=1>
       
       <input type='hidden' name='submitted' value='yes'>
       
       <tr><td>*Customer First Name*:</td>
       <td><input type='text' name='f_name'></td></tr>

       <tr><td>*Customer Last Name*:</td>
       <td><input type='text' name='l_name'></td></tr>

       <tr><td>*Date Due (mm/dd/yyyy)*:</td>
       <td><input type='text' name='duedate'></td></tr>
       
       <tr><td>Time Due (hh:mm military or leave blank):</td>
       <td><input type='text' name='duetime'></td></tr>

       <tr><td>Assigned to:</td>
       <td><input type='text' name='assignee' value='".$_SESSION['user']."'></td></tr>
       
       </table>
       
       <BR>
       *Brief description of problem*:<br>
       <textarea rows='10' cols='30' name='problemdesc'> </textarea>
       <BR><BR>

       <input type='submit' value='Submit Workorder'>

       </form>";

require('includes/footer.inc.php');

//Functions
function formatDate($date,$time)
{
		$parseflag = checkParsing($date,$time);

		if ($parseflag == -1)
				return "date";
		if ($parseflag == -2)
				return "time";
		if ($parseflag == null)
				return "error";
				
		//Grab sections to form date
		$month = substr($date,0,2);
		$day = substr($date,3,2);
		
		if ($month > 12 || $day > 31 || $month < 0 || $day < 0)
				return "badnumber"; 
		
		$year = substr($date,-4,4);
		$hour = substr($time,0,2);
		$minute = substr($time,-2,2);
		$second = 0;
		
		$timestamp = date("Y-m-d H:i:s",mktime($hour,$minute,$second,$month,$day,$year));
		return $timestamp;
}

function checkParsing($date,$time)
{
		if (!ereg("^[0-9]{2}[^0-9][0-9]{2}[^0-9][0-9]{4}$",$date))
			return -1; //malformed date errno
		if (!ereg("^[0-9]{2}[:][0-9]{2}$",$time))
			return -2; //malformed time errno
		return 1; //date/time ok - unfortunately 0 is null, so I can't use that
}
?>