""" 
   Copyright (C) 2001 PimenTech SARL (http://www.pimentech.net)

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  
"""
from string import *

def number_format(x, dec_sep = ',',  mil_sep = ' '):
	"""
	Formate lisiblement un nombre :
	number_format(100000.5)
	1 000 000,5
	number_format('100000.50',' euros ')
	1 000 000 euros 50
	number_format('100000.50','&euro;', '&nbsp;')
	1&nbsp;000&nbsp;000&nbsp;50
	"""
	split_num = split(str(x), '.')
	if len(split_num) == 2:
		ent_val, dec_val = split_num
		dec_val = dec_sep + dec_val
	else:
		ent_val = split_num[0]
		dec_val = ''
	n = len(ent_val)
	result = ''
	i = n % 3
	if i:
		result = ent_val[0:i]
	else:
		result = ent_val[0:3]
		i = i + 3
	while i<n:
		result = '%s %s' % (result, ent_val[i:i+3])
		i = i + 3
	return '%s%s' % (result, dec_val)
							
		
