<html>
<?php
$title="Accounts";
require_once "calpp_config.inc";
require_once "$CLP_BASE/authentication.inc";
require_once "$CLP_BASE/validate.inc";
require_once "$CLP_BASE/form_elements.inc";
require_once "$CLP_BASE/design.inc";

$work_links = work_area_links();
echo $work_links;

echo "<b>Create New <a href=Accounts.php?action=InsertGroup>Account Group</a> | <a href=Accounts.php?action=InsertAccount>Account Ledger</a></b>";
function show_balance_sheet(){
    global $login_entity;
    $sql_l="select '<br>' || achead_id || '.  ' || '<a href=Accounts.php?action=EditGroup&achead_id=' || achead_id || '>' || achead_name || '</a>' from acheads where nature='Liability' order by oid";
    $sql_a="select '<br>' || achead_id || '.  ' || '<a href=Accounts.php?action=EditGroup&achead_id=' || achead_id || '>' || achead_name || '</a>' from acheads where nature='Asset' order by oid";
    $sql_e="select '<br>' || achead_id || '.  ' || '<a href=Accounts.php?action=EditGroup&achead_id=' || achead_id || '>' || achead_name || '</a>' from acheads where nature='Expenditure' order by oid";
    $sql_i="select '<br>' || achead_id || '.  ' || '<a href=Accounts.php?action=EditGroup&achead_id=' || achead_id || '>' || achead_name || '</a>' from acheads where nature='Income' order by oid";
    $l=Retn_Sql_Result($sql_l);
    $a=Retn_Sql_Result($sql_a);
    $e=Retn_Sql_Result($sql_e);
    $i=Retn_Sql_Result($sql_i);
    echo "<h1>Account Groups</h1>";
    echo "<h2>Part I: Balance Sheet</h2>";
    echo "<table><tr><th align=left>Liabilities<th align=left>Assets";
    echo "<tr><td valign=top>$l<td valign=top>$a";
    echo "<tr>";
    echo "<tr><td colspan=2><h2>Part II: Profit and Loss</h2>";
    echo "<tr><th align=left>Expenditure<th align=left>Income";
    echo "<tr><td valign=top>$e<td valign=top>$i";
    echo "<tr></table>";
    echo "<hr>";
    echo "<h1>Account Ledgers</h1>";
    $sql_accounts="select ah.achead_name as Group, a.account_id , 
		          '<a href=Accounts.php?action=EditAccount&account_id=' || a.account_id || '>' ||  
		          a.account_name  || '</a>' as ledgers, a.opening_balance
		     from accounts as a, acheads as ah 
                    where a.achead_id=ah.achead_id
                          and a.entity_id=1";
    $accounts_list = Show_Sql($sql_accounts);
    //echo "<p>$sql_accounts";
    $sql = "select * from accounts";
    //Show_Sql($sql);
    
}
if (!isset($action)){
   show_balance_sheet();
}
if ($action=="InsertGroup"){
    if (!isset($step_1)){
         // create insert group form
	 echo "<form>";
	 echo "<h3>Create New Account Group</h3>";
	 echo "<table>";
	 echo "<tr><td>Group Name:<td><input type=text name=achead_name size=30>";
	 echo "<tr><td>Group Nature:<td><select name=nature size=1>
	      <option value=Asset>Asset</option>
	      <option value=Liability>Liability</option>
	      <option value=Income>Income</option>
	      <option value=Expenditure>Expenditure</option></select>
	      ";
	 echo "<tr><td>Group Type:<td><select name=achead_type size=1>
	      <option value=Cash>Cash</option>
	      <option value=Bank>Bank</option>
	      <option value=ChitGroup>Chit Group</option>
	      <option value=Others>Others</option></select>
	      ";
	 echo "<tr><td>Category 1:<td><input type=text name=custom_cat1 size=30>";
	 echo "<tr><td>Category 2:<td><input type=text name=custom_cat2 size=30>";
	 echo "</table>";
	 echo "<input type=hidden name=action value=InsertGroup>";
	 echo "<input type=hidden name=step_1 value=RequestNewGroup>";
	 echo "<input type=submit name=submit value=\"Create New Group\">";
	 echo "</form>";
    }  else  {
	 // validate data
         $blank=0;
         $achead_name = trim($achead_name);
	 if ($achead_name==''){
	      $blank=1;
              $why_fail[]="Account group name not given.";
	 } else {
	      $test_sql="select achead_name from acheads
                      where achead_name='$achead_name'";
	      $test_count = Retn_Row_Count($test_sql);
	      if ($test_count > 0){
		   $blank=1;
		   $why_fail[]="Account group name already exists.";
	      }
	 }
         if ($blank==1){
	      echo "<h1>Failed to create new account group for the following reason:</h1>";
              echo "<b>$why_fail[0]</b>";
         } else {
	      // create new account group
	      $sql = "insert into acheads (achead_name, nature, achead_type, custom_cat1, custom_cat2) values ('$achead_name', '$nature', '$achead_type', '$custom_cat1', '$custom_cat2')";
	      $result = Exec_Sql($sql);
	      if ($result > 0){
		   echo "<h1>New Group has been created</h1>";
		   echo "Transaction ID: $result";
	      } else {
		   echo "<h1>Failed to create new account group</h1>";
	      }
	 }
    }
}
if ($action=="InsertAccount"){
    if (!isset($step_1)){
	 // create insert account form
	 echo "<form>";
         echo "<h3>Create New Account Ledger</h3>";
	 echo "<table>
	 <tr><td>Account Name:<td><input type=text name=account_name size=40>
	 <tr><td>Account Code:<td><input type=text name=account_code size=10>
	 <tr><td>Account Head:<td>";
         $tmp = ins_select('achead_id', '', 'sql:select achead_id, achead_name from acheads');
         echo $tmp;
         echo "<tr><td>Opening Balance: Rs.<td><input type=text name=opening_balance size=40>";
         echo "<tr><td><input type=submit name=submit value=\"Open New
	 Account\">";
         echo "<input type=hidden name=action value=InsertAccount>";
         echo "<input type=hidden name=step_1 value=RequestNewAccount>";
	 echo "</table>";
	 echo "</form>";
   } else {
	 // validate account details
	 $blank=0;
         $account_name=trim($account_name);
         if ($account_name==''){
	      $blank=1;
              $why_fail[]="Account name not given.";
         }
         //account code is optional.  uncomment to make it compulsory
         $account_code=trim($account_code);
	 //if($account_code=''){
	 //     $blank=1;
	 //     $why_fail[]="Account code not given.";
	 //}
         // check if account_name, account_code already exist
         if ($account_code!=''){
	      $test_sql = "select account_name, account_code from accounts 
		      where entity_id=$login_entity
                        and (account_name='$account_name' or  account_code='$account_code')";
	 } else {
	       $test_sql = "select account_name from accounts 
		      where entity_id=$login_entity
                        and account_name='$account_name'";
	 }
         $test_count = Retn_Row_Count($test_sql);
         if ($test_count > 0){
	      $blank=1;
              $why_fail[]="Account name or code already exists.";
         }
	 $opening_balance = make_cur($opening_balance);
         if (($opening_balance > $max_cur) || ($opening_balance < $min_cur)){
	      $blank=1;
              $why_fail[]="Opening balance exceeds permissible limits";
         }
         if ($blank==1){
	      echo "<h1>Failed to open new account ledger for the following reason(s)</h1>:";
	      $why = implode($why_fail, '<br>');
              echo $why;
	 } else {     
	      // process RequestNewAccount and open account if in order
	      $sql = "insert into accounts (account_code, account_name, achead_id, opening_balance, entity_id) values
		     ('$account_code', '$account_name', $achead_id, $opening_balance, $login_entity)";
	      $result = Exec_Sql($sql);
	      if ($result>0){
		   echo "<h3>New account ledger opened successfully.</h3>";
                   echo "Transaction ID: $result";
	      } else {
		   echo "<h3>Failed to open new account ledger.</h3>";
	      }
	}
    }
}

if ($action=='EditGroup'){
    if (!isset($step_1)){
         // create insert group form
         $sql = "select * from acheads where achead_id=$achead_id";
         $achead_p = Retn_Sql_Array($sql);
         $achead_p = $achead_p[0];
	 echo "<form>";
	 echo "<h3>Edit Account Group</h3>";
	 echo "<table>";
	 echo "<tr><td>Group Name:<td><input type=text name=achead_name size=30 value=\"$achead_p[achead_name]\">";
	 echo "<tr><td>Group Nature:<td><select name=nature size=1>";
	 echo "<option value=$achead_p[nature]>Current Setting:$achead_p[nature]</option>
	      <option value=Asset>Asset</option>
	      <option value=Liability>Liability</option>
	      <option value=Income>Income</option>
	      <option value=Expenditure>Expenditure</option></select>
	      ";
	 echo "<tr><td>Group Type:<td><select name=achead_type size=1>
              <option value=$achead_p[achead_type]>Current Setting:$achead_p[achead_type]</option>
	      <option value=Cash>Cash</option>
	      <option value=Bank>Bank</option>
	      <option value=ChitGroup>Chit Group</option>
	      <option value=Others>Others</option></select>
	      ";
	 echo "<tr><td>Category 1:<td><input type=text name=custom_cat1 size=30 value=\"$achead_p[custom_cat1]\">";
	 echo "<tr><td>Category 2:<td><input type=text name=custom_cat2 size=30 value=\"$achead_p[custom_cat2]\">";
	 echo "</table>";
         echo "<input type=hidden name=achead_id value=$achead_id>";
	 echo "<input type=hidden name=action value=EditGroup>";
	 echo "<input type=hidden name=step_1 value=RequestEditGroup>";
	 echo "<input type=submit name=submit value=\"Edit\">";
	 echo "<input type=submit name=submit value=\"Delete\">";
	 echo "</form>";
    }  else  {
	 if ($submit=='Edit'){
	      // validate data
	      $blank=0;
              // dont allow delete of sys accounts
              //if ($achead_id < 50){
              //    $blank=1;
              //    $why_fail[]="You are not authorised to edit system account heads";
              //}
	      $achead_name = trim($achead_name);
	      if ($achead_name==''){
		   $blank=1;
		   $why_fail[]="Account group name not given.";
	      } else {
		   $test_sql="select achead_name from acheads
                      where achead_name='$achead_name' and achead_id!=$achead_id";
		   $test_count = Retn_Row_Count($test_sql);
		   if ($test_count > 0){
			$blank=1;
			$why_fail[]="Another account group with the same name already exists.";
		   }
	      }
	      if ($blank==1){
		   echo "<h1>Failed to edit account group for the following reason:</h1>";
		   echo "<b>$why_fail[0]</b>";
	      } else {
		   $sql = "update acheads set achead_name='$achead_name', nature='$nature', achead_type='$achead_type', custom_cat1='$custom_cat1', custom_cat2='$custom_cat2' where achead_id=$achead_id";      
		   $result = Exec_Sql($sql);
		   echo "<h3>Group Details successfully edited!</h3>";
	      }
	 }
	 if ($submit=='Delete'){
              $blank=0;
              //if ($achead_id < 50){
	      //	   $blank=1;
              //     $why_fail[]="You are not authorised to delete system accounts.";
	      //}
	      $test_sql="select * from accounts where achead_id=$achead_id";
	      $achead_row_count=Retn_Row_Count($test_sql);
	      if ($achead_row_count > 0){
                   $blank=1;
		   $why_fail ="Group holds $achead_row_count ledger(s).  
                               Remove the Ledgers before attempting to delete the Group"; 
	      } 
              if ($blank==1){
		   $why = implode($why_fail, "<br>");
                   echo "<h1>Group could not be deleted for the following reason(s)</h1>";
                   echo "<b>$why</b>";
	      } else {
		   $sql = "delete from acheads where achead_id=$achead_id";
		   $result = Exec_Sql($sql);
		   echo "<h3>Group Details successfully deleted!</h3>";
	      }
	 }
    }  
}

if ($action=="EditAccount"){
    if (!isset($step_1)){
	 // create edit account form
	 echo "<form>";
         echo "<h3>Edit Account Ledger Details</h3>";
         $ac_d_sql="select * from accounts where account_id=$account_id";
         $ac_d = Retn_Sql_Array($ac_d_sql);
         $ac_d = $ac_d[0];
	 echo "<table>
	 <tr><td>Account Name:<td><input type=text name=account_name size=40 value=\"$ac_d[account_name]\">
	 <tr><td>Account Code:<td><input type=text name=account_code size=10 value=\"$ac_d[account_code]\">
	 <tr><td>Account Head:<td>";
         $achead_name_sql = "select achead_name from acheads where achead_id=$ac_d[achead_id]";
         $achead_name = Retn_Result($achead_name_sql);
         $custom_option = "<option value=$ac_d[achead_id]>Current Setting: $achead_name</option>";
         $tmp = ins_select('achead_id', '', 'sql:select achead_id, achead_name from acheads','' , $custom_option);
         echo $tmp;
         $tmp_amt = fmt_ind_rs($ac_d[opening_balance]);
         echo "<tr><td>Opening Balance: Rs.<td><input type=text name=opening_balance size=40 value=$tmp_amt>";
         echo "<tr><td><td><input type=reset name=reset value=Reset>";
         echo "<input type=hidden name=account_id value=$account_id>";
         echo "<input type=submit name=submit value=Edit>";
         echo "<input type=submit name=submit value=Delete>";
         echo "<input type=hidden name=action value=EditAccount>";
         echo "<input type=hidden name=step_1 value=RequestEditAccount>";
	 echo "</table>";
	 echo "</form>";
   } else {
         if ($submit=='Edit'){
	      // validate account details
	      $blank=0;
              //if ($account_id < 10){
		//   $blank=1;
		//   $why_fail[]="You are not authorised to edit system ledger accounts";
	      //}
	      $account_name=trim($account_name);
	      if ($account_name==''){
		   $blank=1;
		   $why_fail[]="Account name not given.";
	      }
	      //account code is optional.  uncomment to make it compulsory
	      $account_code=trim($account_code);
	      //if($account_code=''){
	      //     $blank=1;
	      //     $why_fail[]="Account code not given.";
	      //}
	      // check if account_name, account_code already exist
	      if ($account_code!=''){
		   $test_sql = "select account_name, account_code from accounts 
		      where (entity_id=$login_entity and account_id!=$account_id)
                        and (account_name='$account_name' or  account_code='$account_code')";
	      } else {
		   $test_sql = "select account_name from accounts 
		      where (entity_id=$login_entity and account_id!=$account_id)
                        and account_name='$account_name'";
	      }
	      $test_count = Retn_Row_Count($test_sql);
	      if ($test_count > 0){
		   $blank=1;
		   $why_fail[]="Account name or code already exists.";
	      }
	      $opening_balance = make_cur($opening_balance);
              if (($opening_balance > $max_cur) || ($opening_balance < $min_cur)){
		   $blank=1;
                   $why_fail[]="Opening balance exceeds permissible limits";
              }
	      if ($blank==1){
		   echo "<h1>Edit account ledger failed for the following reason(s)</h1>:";
		   $why = implode($why_fail, '<br>');
		   echo $why;
	      } else {     
		   $sql = "update accounts set account_name='$account_name', account_code='$account_code', achead_id='$achead_id', opening_balance='$opening_balance' where account_id=$account_id";
		   $result = Exec_Sql($sql);
		   if ($result == 0){
			echo "<h3>Account Ledger details updated successfully!</h3>";
		   } else {
			echo "<h3>Failed to update Account Ledger!</h3>";
		   }
	      }
	 } elseif($submit=='Delete'){
	      $blank=0;
              //if ($account_id < 10){
	//	   $blank=1;
	//	   $why_fail[]="You are not authorised to delete system ledger accounts.";
         //     }
              $sql = "select count(b.bill_id) 
                        from bills as b, bill_items as i 
                       where b.bill_id=i.bill_id 
                             and i.bill_ac_id=$account_id and b.entity_id=$login_entity";
              $t_count = Retn_Result($sql);
              if ($t_count > 0){
		   $blank = 1;
                   $why_fail[]="Ledger Account is involved in $t_count transaction(s), and hence cannot be deleted";
              }
	      if ($blank==1){
		   echo "<h1>Ledger Account could not be deleted for the following reason(s):</h1>";
                   $why = implode($why_fail, "<br>");
                   echo "<b>$why</b>";
              } else {                       
		   $sql = "delete from accounts where account_id=$account_id";
		   $result = Exec_Sql($sql);
		   if ($result == 0){
			echo "<h3>Account Ledger deleted successfully!</h3>";
		   } else {
			echo "<h3>Failed to delete Account Ledger!</h3>";
		   }
	      }
	 }
   }	 
}

?>