<?php
// core calpp functions

// functions
$CALPP=TRUE;
function insert_event($proceeding_id, $step_id){
    global $reasons;
    // returns event_id if successful and 0 if insert_event fails
    // validate parameter data
    $test_proceeding_id = (integer)$proceeding_id;
    $test_step_id = (integer)$step_id;
    if (($test_proceeding_id==0) || ($test_step_id==0)){
         $reasons[]="invalid proceeding_id or step id";
	 return 0;
    }
    // get step count
    $sql_step_count = "select count(e.event_id) from events as e, proceedings as pg
			where (e.step_id=$step_id and e.proceeding_id=$proceeding_id)
                              and pg.proceeding_id=e.proceeding_id
			      and pg.entity_id=$GLOBALS[login_entity]";
    $reasons[]="sql_step_count: $sql_step_count";
    $step_count = Retn_Result($sql_step_count);
    $reasons[]="<p>step_count: $step_count";
    $step_count = $step_count + 1;
    // insert event
    $sql_event = "insert into events (proceeding_id, step_id, step_count, entry_contact_id, entry_timestamp)
		   values ($proceeding_id, $step_id, $step_count, $GLOBALS[login_user_id], CURRENT_TIMESTAMP)";
    $reasons[]="<p>sql_event: $sql_event";
    $event_oid = Exec_Sql($sql_event);
    $event_id = Retn_ID($event_oid, "events");
    if ($event_id > 0){
	 return $event_id;
    } else {
	 return 0;
    }
}

function insert_assertion($event_id, $particular_id, $heading_count, $key_count, $assertion){
    // return assertion_id if successful and 0 on failure
    $sql_assertion = "insert into assertions (event_id, particular_id, heading_count, key_count, assertion) values
		      ($event_id, $particular_id, $heading_count, $key_count, '$assertion')";
    $assertion_oid = Exec_Sql($sql_assertion);
    $assertion_id = Retn_ID($assertion_oid, "assertions");
    return $assertion_id; 
}

function get_assertions($event_id){
    // return assertions as an array
    $sql = "select p.particular_id, p.heading, a.heading_count, p.particular_code, 
                   a.key_count, p.particular_name, a.assertion
              from particulars as p, assertions as a
             where p.particular_id = a.particular_id and
                   a.event_id = $event_id";
/*
	$h = $name_parts[2];
	$hn = $name_parts[3];
	$ky = $name_parts[4];
	$kyn= $name_parts[5];
	if (($hn==1) && ($kyn==1)){
	   ${$h}[$ky]=$value;
	}
	${$h}[$hn][$ky][$kyn]=$value;
*/
}

function reset_tables(){
    // function to reset tables and sequences to start afresh
    $tables=array('bill', 'bill_item', 'ledger', 'cheque', 'event', 'assertion');
    while (list($key, $value)=each($tables)){
         $table = $value . 's';
	 $sql_delete = "delete from $table";
         $del = Exec_Sql($sql_delete);
         $sequence = $table . "_" . $value . "_" . "id" . "_" . "seq";
         $sql_seq  ="select setval('$sequence', 1)";
         $seq = Exec_Sql($sql_seq);
    }
}

function play_sound($sound){
    // plays $sound on the server system
    // collection; crash
    if ($sound=='collection'){
	 $play = exec("play /usr/local/httpd/htdocs/calpptechno/sounds/apert.wav");
    }
}
?>
