% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.updatePluginMessages.R
\name{rk.updatePluginMessages}
\alias{rk.updatePluginMessages}
\title{Update plugin i18n messages}
\usage{
rk.updatePluginMessages(
  pluginmap,
  extractOnly = FALSE,
  default_po = NULL,
  outdir = NULL,
  bug_reports = "https://mail.kde.org/mailman/listinfo/kde-i18n-doc"
)
}
\arguments{
\item{pluginmap}{Character string,
      full path to the main pluginmap file of the plugin to translate.}

\item{extractOnly}{Logical,
      should translatable strings only be extracted? If \code{FALSE}, translatable
strings will be updated and installed.}

\item{default_po}{Optional character string, fallback default name for \code{*.pot} file.}

\item{outdir}{Optional character string, change the output directory for generated files.}

\item{bug_reports}{Character string, URL to a bug tracker, mailing list or similar,
      where translation
issues should be reported.}
}
\description{
A wrapper for calling \code{update_plugin_messages.py} to extract translatable
strings from a plugin or update/merge translations.
}
\note{
For details on the translating process, please refer to the chapter
\href{help:rkwardplugins/i18n.html}{Plugin translations}
of the  \emph{Introduction to Writing Plugins for RKWard}, especially
subsection \href{help:rkwardplugins/i18n_workflow.html}{Translation maintainance}.
}
\examples{
\dontrun{
rk.updatePluginMessages("~/myPlugins/lifeSaver/rkward/lifeSaver.pluginmap")
}
}
\seealso{
\href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
