% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.rkh.setting.R
\name{rk.rkh.setting}
\alias{rk.rkh.setting}
\title{Create XML "setting" node for RKWard help pages}
\usage{
rk.rkh.setting(id, text = NULL, title = NULL, i18n = NULL)
}
\arguments{
\item{id}{Either a character string (the \code{id} of the XML element to explain),
or an object of class \code{XiMpLe.node} (whose \code{id} will be extracted and used).}

\item{text}{Character string, the text to be displayed.}

\item{title}{Character string, title to be displayed. If \code{NULL}, the \code{label}
of the element will be shown.}

\item{i18n}{Either a character string or a named list with the optional elements \code{context}
or \code{comment}, to give some \code{i18n_context} information for this node.
If set to \code{FALSE},
      the attribute \code{title} will be renamed into \code{noi18n_title}.}
}
\value{
An object of class \code{XiMpLe.node}.
}
\description{
This function will create a setting node for settings sections in RKWard help files.
}
\examples{
test.checkbox <- rk.XML.cbox(label="foo", value="foo1", chk=TRUE)
# explain the option
test.setting <- rk.rkh.setting(test.checkbox, text="Check this to do Foo.")
cat(pasteXML(test.setting))
}
\seealso{
\code{\link[rkwarddev:rk.rkh.doc]{rk.rkh.doc}},
   \code{\link[rkwarddev:rk.rkh.settings]{rk.rkh.settings}}
   and the \href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
