% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.paste.JS.R
\name{rk.paste.JS}
\alias{rk.paste.JS}
\title{Paste JavaScript objects and character strings}
\usage{
rk.paste.JS(
  ...,
  level = 2,
  indent.by = rk.get.indent(),
  funct = NULL,
  array = NULL,
  var.prefix = NULL,
  modifiers = NULL,
  default = NULL,
  join = NULL,
  getter = NULL,
  var = TRUE,
  empty.e = rk.get.empty.e(),
  opt.sep = NULL
)
}
\arguments{
\item{...}{Objects of class \code{rk.JS.ite}, \code{rk.JS.arr}, \code{rk.JS.opt},
      \code{rk.JS.oset} or character.
Another special case is XiMpLe nodes created by \code{rk.comment()}, which will be turned
into JavaScript comments (i.e., lines starting with "//").}

\item{level}{Integer, which indentation level to use, minimum is 1.}

\item{indent.by}{A character string defining the indentation string to use.}

\item{funct}{For \code{rk.JS.arr} and \code{rk.JS.opt} objects only: Character string,
      name of the R function
to be called to combine the options, e.g. "list" for \code{list()},
      or "c" for \code{c()}.}

\item{array}{For \code{rk.JS.opt} objects only: Logical,
      whether the options should be collected
in an array or a concatenated character string.}

\item{var.prefix}{For \code{rk.JS.var} objects only: A character string. will be used as a prefix
for the JS variable names.}

\item{modifiers}{For \code{rk.JS.var} objects only: A character vector with modifiers you'd like to apply the XML node's property.}

\item{default}{For \code{rk.JS.var} objects only: Logical,
      if \code{TRUE} the default value (no special modifier) of the node will
also be defined. Does nothing if \code{modifiers=NULL}.}

\item{join}{For \code{rk.JS.var} objects only: A character string,
      useful for GUI elements which accept multiple objects
(e.g., multi-varslots). If \code{join} is something other than \code{""},
      these objects will be collapsed into one string
when pasted, joined by this string.}

\item{getter}{For \code{rk.JS.var} objects only: A character string,
      naming the JavaScript function which should be used to get the
values in the actual plugin. Depending on the XML element, \code{"getString"},
      \code{"getBool"} or \code{"getList"} can be
useful alternatives. For backwards compatibility,
      the default is set to \code{"getValue"}.}

\item{var}{For \code{rk.JS.var} objects only: Logical,
      if \code{FALSE} the variable(s) are assumed to already be defined (globally?)
and the JS keyword "var" will be omitted.}

\item{empty.e}{For \code{rk.JS.ite} objects only: Logical,
      if \code{TRUE} will force to add empty \code{else \{\}} brackets when
there is no \code{else} statement defined,
      which is considered to enhance code readability by some.}

\item{opt.sep}{For \code{rk.JS.arr} and \code{rk.JS.opt} objects only: Character string,
      will be printed in the resulting R code
before the option name.}
}
\value{
A character string.
}
\description{
Paste JavaScript objects and character strings
}
\note{
To get a list of the implemented modifiers in this package see \code{\link[rkwarddev:modifiers]{modifiers}}.
}
\seealso{
\code{\link[rkwarddev:rk.JS.array]{rk.JS.array}},
   \code{\link[rkwarddev:rk.JS.options]{rk.JS.options}},
   \code{\link[rkwarddev:rk.JS.optionset]{rk.JS.optionset}},
   \code{\link[rkwarddev:rk.JS.vars]{rk.JS.vars}},
   \code{\link[rkwarddev:ite]{ite}},
   \code{\link[rkwarddev:modifiers]{modifiers}},
   and the \href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
