% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.XML.varselector.R
\name{rk.XML.varselector}
\alias{rk.XML.varselector}
\title{Create node "varselector" for RKWard plugins}
\usage{
rk.XML.varselector(label = NULL, id.name = "auto", i18n = NULL)
}
\arguments{
\item{label}{Character string, a text label for the variable selection slot.
Must be set if \code{id.name="auto"}.}

\item{id.name}{Character vector, unique ID for this element.}

\item{i18n}{Either a character string or a named list with the optional elements \code{context}
or \code{comment},
      to give some \code{i18n_context} information for this node. If set to \code{FALSE},
the attribute \code{label} will be renamed into \code{noi18n_label}.}
}
\value{
An object of class \code{XiMpLe.node}.
}
\description{
Create node "varselector" for RKWard plugins
}
\examples{
test.varselector <- rk.XML.varselector("Select some vars")
cat(pasteXML(test.varselector))
}
\seealso{
\code{\link[rkwarddev:rk.XML.varslot]{rk.XML.varslot}},
   \code{\link[rkwarddev:rk.XML.vars]{rk.XML.vars}},
   and the \href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
