% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.XML.snippets.R
\name{rk.XML.snippets}
\alias{rk.XML.snippets}
\title{Create XML "snippets" node for RKWard plugins}
\usage{
rk.XML.snippets(...)
}
\arguments{
\item{...}{Objects of class \code{XiMpLe.node}. Accepts only \code{<snippet>} and \code{<include>}.}
}
\value{
An object of class \code{XiMpLe.node}.
}
\description{
This function will create a snippets node for the document section,
      with optional child nodes
\code{<snippet>} and \code{<include>}.
}
\examples{
# define a formula section with varselector and varslots
test.formula <- rk.XML.vars("Variables", "Fixed", formula.dependent="Dependent")
# define the snippets section
test.snippet <- rk.XML.snippet(test.formula)
test.snippets <- rk.XML.snippets(test.snippet)
cat(pasteXML(test.snippets))
}
\seealso{
\code{\link[rkwarddev:rk.XML.plugin]{rk.XML.plugin}}
   \code{\link[rkwarddev:rk.XML.snippet]{rk.XML.snippet}},
   \code{\link[rkwarddev:rk.XML.include]{rk.XML.include}},
   and the \href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
