% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.XML.preview.R
\name{rk.XML.preview}
\alias{rk.XML.preview}
\title{Create XML node "preview" for RKWard plugins}
\usage{
rk.XML.preview(
  label = "Preview",
  mode = "plot",
  placement = "default",
  active = FALSE,
  id.name = "auto",
  i18n = NULL
)
}
\arguments{
\item{label}{A character string, text label for the preview checkbox.}

\item{mode}{A character string, must be either \code{"plot"}, \code{"output"},
      \code{"data"}, or \code{"custom"}.}

\item{placement}{A character string, must be either \code{"default"}, \code{"attached"},
      \code{"detached"}, or \code{"docked"}.}

\item{active}{Logical, whether the preview should be enabled by default.}

\item{id.name}{Character string, a unique ID for this plugin element.
If \code{"auto"} and a label was provided,
      an ID will be generated automatically from the label
if present, otherwise from the objects in the frame.
If \code{NULL}, no ID will be given.}

\item{i18n}{Either a character string or a named list with the optional elements \code{context}
or \code{comment},
      to give some \code{i18n_context} information for this node. If set to \code{FALSE},
the attribute \code{label} will be renamed into \code{noi18n_label}.}
}
\value{
An object of class \code{XiMpLe.node}.
}
\description{
Create XML node "preview" for RKWard plugins
}
\examples{
test.preview <- rk.XML.preview("See a preview?")
cat(pasteXML(test.preview))
}
\seealso{
\href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
