% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.XML.embed.R
\name{rk.XML.embed}
\alias{rk.XML.embed}
\title{Create XML node "embed" for RKWard plugins}
\usage{
rk.XML.embed(
  component,
  button = FALSE,
  label = "Options",
  namespace = NULL,
  id.name = "auto",
  i18n = NULL
)
}
\arguments{
\item{component}{Either a character string,
      registered name (\code{id} in pluginmap file) of the component to be embedded,
or an object of class \code{\link[rkwarddev:rk.plug.comp-class]{rk.plug.comp}},
      whose name will be used.}

\item{button}{Logical,
      whether the plugin should be embedded as a button and appear if it's pressed.}

\item{label}{A character string,
      text label for the button (only used if \code{button=TRUE}).}

\item{namespace}{An optional character string,
      XiMpLe node \code{<about>} or XiMpLe doc of doctype "rkpluginmap",
to prefix the given \code{component} with the respective namespace (\code{"namespace::component"}).}

\item{id.name}{Character string, a unique ID for this plugin element.
If \code{"auto"},
      an ID will be generated automatically from the label and component strings.}

\item{i18n}{Either a character string or a named list with the optional elements \code{context}
or \code{comment},
      to give some \code{i18n_context} information for this node. If set to \code{FALSE},
the attribute \code{label} will be renamed into \code{noi18n_label}.}
}
\value{
An object of class \code{XiMpLe.node}.
}
\description{
Create XML node "embed" for RKWard plugins
}
\examples{
test.embed <- rk.XML.embed("someComponent")
cat(pasteXML(test.embed))
}
\seealso{
\href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
