% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rk.XML.connect.R
\name{rk.XML.connect}
\alias{rk.XML.connect}
\title{Create XML node "connect" for RKWard plugins}
\usage{
rk.XML.connect(
  governor,
  client,
  get = "state",
  set = "enabled",
  not = FALSE,
  reconcile = FALSE
)
}
\arguments{
\item{governor}{Either a character string (the \code{id} of the property whose state should control
the \code{client}),
      or an object of class \code{XiMpLe.node} (whose \code{id} will be extracted
and used). Usually a \code{<convert>} node defined earlier (see
\code{\link[rkwarddev:rk.XML.convert]{rk.XML.convert}}).}

\item{client}{Either a character string (the \code{id} if the element to be controlled by \code{governor})m
an object of class \code{XiMpLe.node} (whose \code{id} will be extracted and used),
      or an object of class
\code{\link[rkwarddev:rk.plug.comp-class]{rk.plug.comp}} (whose name will be used).}

\item{get}{Character string, a valid modifier for the node property of \code{governor},
      often
the ".state" value of some apropriate node. If set to an empty \code{""},
      no modifier will be appended.}

\item{set}{Character string, a valid modifier for the node property of \code{client},
      usually
one of \code{"enabled"},
      \code{"visible"} or \code{"required"}. If you provide an \code{<external>}
node instead, its ID will be used as the modifier without validation (see above).}

\item{not}{Logical, if \code{TRUE},
      the state of \code{governor} (\code{TRUE/FALSE}) will be inversed.}

\item{reconcile}{Logical,
      forces the \code{governor} to only accept values which are valid for
the \code{client} as well.}
}
\value{
An object of class \code{XiMpLe.node}.
}
\description{
If you define a \code{XiMpLe.node} object as \code{governor} which is not a \code{<convert>} node
and \code{not=FALSE}, the function will automatically append  to its \code{id}.
}
\note{
To get a list of the implemented modifiers in this package see \code{\link[rkwarddev:modifiers]{modifiers}}.
}
\section{Connect embedded plugins}{
 To connect to properties of embedded plugins, the validity check of the \code{set}
 modifier needs to be skipped. You do this by providing an \code{<external>} XiMpLe node instead,
      whose ID is
 then taken unvalidated. This can be useful in combination with \code{rk.plug.comp} object provided as \code{client}.
}

\examples{
test.connect <- rk.XML.connect(governor="lgc_foobar", client="frame_bar")
cat(pasteXML(test.connect))
}
\seealso{
\code{\link[rkwarddev:rk.XML.convert]{rk.XML.convert}},
   \code{\link[rkwarddev:rk.XML.external]{rk.XML.external}},
   \code{\link[rkwarddev:rk.XML.logic]{rk.XML.logic}},
   \code{\link[rkwarddev:rk.XML.set]{rk.XML.set}},
   \code{\link[rkwarddev:rk.XML.switch]{rk.XML.switch}},
   \code{\link[rkwarddev:modifiers]{modifiers}},
   and the \href{help:/rkwardplugins/index.html}{Introduction to Writing Plugins for RKWard}
}
