# RKWard Plugin for String Manipulation (rk.stringr)

[![License: GPL v3](https://img.shields.io/badge/License-GPLv3-blue.svg)](https://www.gnu.org/licenses/gpl-3.0)

An RKWard plugin that provides a user-friendly graphical interface for the powerful `stringr` package. This plugin brings modern, consistent, and intuitive string manipulation directly into your RKWard workflow. It is designed for common data cleaning and preparation tasks, allowing you to perform a wide range of text transformations without writing code.

A key design feature is that all operations are vectorized and **preserve the length of the input data**. Each function returns a vector (or list) of the same length as your input, making it safe and predictable to use when transforming columns in a data frame.

## Features

The plugin is organized into several modules accessible from the RKWard menu, each targeting a specific category of string operations:

#### Detect & Locate Matches
Use regular expressions to find patterns within your text.
- Check if strings contain a pattern (`str_detect`).
- Verify if strings start or end with specific text (`str_starts`, `str_ends`).
- Count the number of times a pattern occurs (`str_count`).
- Find the exact start and end positions of matches (`str_locate`, `str_locate_all`).

#### Mutate Strings
Easily change the case of your text for standardization.
- Convert to `lower`, `UPPER`, `Title`, or `Sentence` case.

#### Extract from Strings
Pull out specific pieces of your strings.
- Extract substrings by character position (`str_sub`).
- Extract text that matches a pattern, including specific capture groups (`str_extract`, `str_match`).

#### Split Strings
Break strings into multiple pieces based on a delimiter.
- Split strings into a list of substrings (`str_split`).
- Split strings into a fixed number of columns in a matrix (`str_split_fixed`).

#### Manage String Length
Standardize the length and padding of your strings.
- Get the number of characters in each string (`str_length`).
- Remove leading/trailing and excess internal whitespace (`str_trim`, `str_squish`).
- Pad strings with characters to a uniform length (`str_pad`).
- Truncate strings that are too long (`str_trunc`).

## Installation

plugin package, you need the source code (e.g., by downloading it from GitHub).

1.  Open RKWard.
2.  Run the following commands in the R console:

```R
local({
## Preparar
require(devtools)
## Computar
  install_github(
    repo="AlfCano/rk.stringr"
  )
## Imprimir el resultado
rk.header ("Resultados de Instalar desde git")
})

```

3.  Restart RKWard to ensure the new menu items appear correctly.

## Usage

Once installed, the plugin components can be found in the RKWard menu under:

**Data > String Manipulation (stringr)**

From there, you can select the desired operation (e.g., "Mutate Strings", "Split Strings", etc.) to open its dialog window.

## Dependencies

-   RKWard version `0.7.0` or newer.
-   R version `3.5.0` or newer.
-   The R package `stringr` (version `1.4.0` or newer). The plugin will prompt you to install it if it is not found.

## Author

* Alfonso Cano (alfonso.cano@correo.buap.mx)  
* Assisted by Gemini, a large language model from Google.
