#
# FILE            $Id: Formatters.py,v 1.4 1998/02/04 18:19:41 dlarsson Exp dlarsson $
#
# DESCRIPTION     Formatters for MIF and HTML manual formats.
#
# AUTHOR          SEISY/LKSB Daniel Larsson
#
# Permission to use, copy, modify, and distribute this software and its
# documentation for any purpose and without fee is hereby granted,
# provided that the above copyright notice appear in all copies and that
# both that copyright notice and this permission notice appear in
# supporting documentation, and that the name of ABB Industrial Systems
# not be used in advertising or publicity pertaining to
# distribution of the software without specific, written prior permission.
#
# ABB INDUSTRIAL SYSTEMS DISCLAIMS ALL WARRANTIES WITH REGARD TO
# THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
# FITNESS, IN NO EVENT SHALL ABB INDUSTRIAL SYSTEMS BE LIABLE
# FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
# WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
# ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT
# OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
#
# Copyright (C) ABB Industrial Systems AB, 1996
# Unpublished work.  All Rights Reserved.
#
# HISTORY:
# $Log: Formatters.py,v $
# Revision 1.4  1998/02/04 18:19:41  dlarsson
# Removed ni features.
#
# Revision 1.3  1997/01/23 20:43:58  omfadmin
# Added a warning message.
#
# Revision 1.2  1996/09/06  10:12:46  omfadmin
# Added 'try: ... except:' around importing formatters. Otherwise
# gendoc will fail if HTMLgen isn't present on the site.
#
# Revision 1.1  1996/06/24  10:07:57  omfadmin
# Initial revision
#
#

"""Format manual pages.

A manual page formatter translates a ManualPage into a concrete document
format, such as HTML, MIF, UNIX man or some other format.

A formatter needs to implement a number of methods, which are called by the
ManualPage class when rendering a document:

> # Example implementation of man formatter
> class Formatter:
>       file_ext = '.txt'
>
>	def _add_(self, txt):
>		# Add text to the document
>		self._text_ = self._text_ + txt
>
>	# -----   THESE ARE THE REQUIRED METHODS  -----
>	def __init__(self):
>		# String to collect document text
>		self._text_ = ''
>
>	def render_title(self, manpage, title, marker):
>		# **manpage** is a reference back to the manual page object.
>		# **title** is the title of the document.
>		# **marker** is a list of markers for the title. Markers
>		# are used to implement indices. See the MIFFormatter
>		# for how its used.
>		self._add_(title+'\\n\\n')
>
>	def render_section(self, manpage, lvl, section, marker):
>		# *lvl* is an integer indicating the nesting depth of
>		# the section. The title is at level 0, top level sections
>		# at level 1, and so on.
>		self._add_(section+'\\n\\n')
>
>	def render_paragraph(self, manpage, para):
>		# *para* is the paragraph text.
>		self._add_(para+'\\n\\n')
>
>	def render_code(self, manpage, code):
>		# *code* is the code snippet.
>		self._add_(code+'\\n\\n')
>
>	def render_ordered_list(self, manpage, list):
>		# *list* is a list of items.
>		code = ''
>		for i in range(len(list)):
>			code = code + '%d.  %s\\n' % (i+1, list[i])
>		self._add_(code+'\\n')
>
>	def render_list(self, manpage, list):
>		# *list* is a list of items.
>		code = ''
>		for i in list:
>			code = code + '*  %s\\n' % i
>		self._add_(code+'\\n')
>
>       # In this particular case (since nothing is done), these
>       # functions need not be implemented (render_bold, render_italic,
>       # render_underline, render_internal_link, render_external_link)
>       def render_bold(self, text):
>               return text
>
>       def render_italic(self, text):
>               return text
>
>       def render_underline(self, text):
>               return text
>
>       def render_internal_link(self, link, link_text):
>               return link_text
>
>       def render_external_link(self, link, link_text):
>               return link_text
>
>	def end(self):
>		# Called when the document is ready.
>		# IMPORTANT: The same formatter object is very likely
>		# to be used for more than one ManualPage, so we must
>		# remove the text also (alternatively, we might initialise
>		# self._text_ in 'render_title', since it is always called
>		# first).
>		text = self._text_
>		self._text_ = ''
>		return text
>
"""

__author__ = "Daniel Larsson"
__version__ = "$Revision: 1.4 $"

import os

# Will contain all available formatters
formatters = {}

def main(path):
    files = reduce(lambda c, dir: c+os.listdir(dir), path, [])
    modules = filter(lambda file: file[-3:] == '.py', files)

    for module in modules:
	if module not in ["Formatters.py", "__init__.py"]:
	    py_module = module[:-3]
	    try:
		exec "import %s" % py_module
	    except ImportError:
		import sys
		sys.stderr.write('Warning: Failed to import %s (%s: %s)\n' % (py_module, sys.exc_type, sys.exc_value))

    global formatters
    from types import ClassType, ModuleType

    for object in vars().values():
	if type(object) == ModuleType:
	    for mod_obj in object.__dict__.values():
		if type(mod_obj) == ClassType and hasattr(mod_obj, 'render_title'):
		    formatters[mod_obj.__name__] = mod_obj




