// wavetable.c

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#include <math.h>
#include "localdefs.h"
#ifdef __GNUG__
#pragma implementation
#endif
#include "wavetable.h"

WaveTable::WaveTable(int size) : mySize(size) {
	table = new double[mySize+1];	// one extra for interpolation
	zeroTable();
}

WaveTable::~WaveTable() {
	delete [] table;
}

void
WaveTable::zeroTable() {
	double *t = table;
	for(int i=0; i <= mySize; i++)
		*t++ = 0.0;
}

double
WaveTable::operator [] (int index) {
	return *(table + wrapIndex(index));
}

double
WaveTable::operator [] (double index) {
	int intIndex = int(index);
	double fraction = index - intIndex;
	double first = *(table + wrapIndex(intIndex));
	double second = *(table + wrapIndex(intIndex + 1));
	return first + fraction * (second - first);
}

//**********

SineTable::SineTable(int size) : WaveTable(size) {
	const double radinc = 2.0 * M_PI /double(mySize);
	for(int i = 0; i < mySize; i++) {
		table[i] = sin(radinc * i);
	}
}

