// edit_request.C

/******************************************************************************
 *
 *  MiXViews - an X window system based sound & data editor/processor
 *
 *  Copyright (c) 1993, 1994 Regents of the University of California
 *
 *  Author:     Douglas Scott
 *  Date:       December 13, 1994
 *
 *  Permission to use, copy and modify this software and its documentation
 *  for research and/or educational purposes and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation. The author reserves the right to distribute this
 *  software and its documentation.  The University of California and the author
 *  make no representations about the suitability of this software for any 
 *  purpose, and in no event shall University of California be liable for any
 *  damage, loss of data, or profits resulting from its use.
 *  It is provided "as is" without express or implied warranty.
 *
 ******************************************************************************/


#include "localdefs.h"
#include "application.h"
#include "controller.h"
#include "datafile.h"
#include "editor.h"
#include "envelope.h"
#include "filename.h"
#include "request.h"
#include "query.h"
#include "lpcdata.h"

Status
DataEditor::setDefaultDir() {
	Request request("Set Default Directory:");
	request.appendLabel(
		scat("Setting global resource: ", data->defaultDirAttribute())
	);
	String newDir(defaultDir());
	request.appendValue("New directory:", &newDir);
	Status status;
	if ((status = (_controller->handleRequest(request) == Yes)))
		Application::setGlobalResource(data->defaultDirAttribute(), newDir);
	return status;
}

Status
DataEditor::newFile() {
	int newLength = 32;
	Request request("Create New File:");
	request.appendValue("Length (in frames/samples):", 
						&newLength, PositiveIntegers);
	String newName(FileName::untitledName(data->fileSuffix()));
	request.appendValue("File name:",  &newName);
	Status status;
	if ((status = (_controller->handleRequest(request) == Yes))) {
		Data *newData = data->newData(newLength);
		Controller *newCtlr = new Controller(newData, newName);
		newCtlr->display(_controller->world());
	}
	return status;
}

Status
LPCEditor::adjustPitchDeviation() {
	double threshold = 1.0;
	Request request1("Adjust Pitch Deviation:");
	request1.appendLabel("First, enter an error threshold between 0.0 and 1.0.");
	request1.appendLabel("A value of 1 will include all frames.");
	request1.appendValue("Error threshold:", &threshold, Range(0, 1));
	if (_controller->handleRequest(request1) != Yes)
		return Fail;
	setChannels(0, 3); // regardless of selection, select channels 0-3
	LPCData* selection = (LPCData *) currentSelection();

	Request request2("Adjust Pitch Deviation:");
	request2.appendLabel("Scale pitch deviation to +- new interval.");
	request2.appendLabel("Pitches below cutoff value will be skipped.");

	double currentDev = selection->averagePitchDeviation(threshold);
	Range pitchRange = selection->limits(3);
	double cutoff = pitchRange.min();

	request2.appendValue("New deviation (hz):",
		&currentDev, Range(0.0, 10.0 * currentDev));
	request2.appendValue("Pitch cutoff value (hz):", &cutoff, pitchRange);
	Status status;
	if((status = (_controller->handleRequest(request2) == Yes))) {
		Application::inform("Scaling pitch deviation...");
		selection->scalePitchDeviation(
			currentDev,			// new deviation
			threshold,
			cutoff				// cutoff frequency
		);
	}
	return status;
}
